       SUBROUTINE CLEAR_PLOT H C======================================================================CH C                                                                      CH C  CLEAR_PLOT: clears monitor 1 if IMONITOR .NE. 0                     CH C              clears monitor 2 if IMONITOR2 .NE. 0                    CH C              clears the bitmap if IORIENTH .NE. 0                    CH C                                                                      CH C  Written by Arthur Haynes, TRIUMF U.B.C., July 6, 1981.              CH C                                                                      CH C  Modified by Alan Carruthers, March 15, 1983.                        CH C  --Three flags added (CLEAR1, CLEAR2 and CLEARH) to indicate if      CH C    monitor 1, monitor 2 or hardcopy have been cleared since          CH C    application program started executing or since last plot was      CH C    terminated, whichever is more recent.                             CH C  --CLEARUNC flag indicates if monitors and hardcopy (if active) are  CH C    to be cleared regardless of the settings of CLEAR1, CLEAR2, or    CH C    CLEAR3. If CLEARUNC = .FALSE., then monitors and hardcopy will be CH C    cleared only if their respective CLEAR1, CLEAR2 or CLEARH flags   CH C    are .FALSE.                                                       CH C                                                                      CH C  Modified by Alan Carruthers, July 15, 1983.                         CH C    --call to PUT_METAFILE1 added to support metafile                 CH C  Modified by Joe Chuma, December 5, 1983 to include the              CH C    Hewlett-Packard plotter                                           CH C  Modified by Bernard Henin, July 1984, to include the                CH C    TEKTRONIX 4107.                                                   CH C  Modified by F.W. Jones, August/84, to include the VT241.            CH C  Modified by F.W. Jones, Jan 29/85:                                  CH C   To improve plotting performance, flag BITMAP_EMPTY has             CH C   been added to inhibit clearing of the bitmap when nothing          CH C   has been written into it.  BITMAP_EMPTY is initially true,         CH C   and is set true whenever the bitmap is cleared.  It is set         CH C   false when something is written into the bitmap by PLOT_HARDCOPY.  CH C  Modified Dec 4/85 by F. Jones for the QMS Lasergrafix.              CH C  Modified July 21/86 by J. Chuma to open the scratch files on        CH C    SYS$SCRATCH.                                                      CH C  Modified Aug 11/86 by F.W. Jones to include the Houston             CH C    Instruments plotter.                                              CH C  Modified Sept 3/86 by C. Kost to delete .SCRATCH files upon image   CH C    run-down                                                          CH C  Modified Mar 20/87 by F. Jones for Seiko GR-1105 terminal support   CH C  Modified Nov 10/87 by C. Kost to include HPPaintjet bitmap          CH C  Modified Nov 27/87 by F. Jones.  Some terminals home the alpha      CH C    cursor even though the alpha screen is not cleared during a       CH C    graphics clear.  To avoid this, the alpha cursor is saved         CH C    before clearing the graphics screen and then restored to its      CH C    former position.                                                  CH C  Modified Nov 27/87 by F. Jones.  The code has been restructured     CH C    for clarity and easier maintenance.                               CH C  Modified by J.Chuma Nov 14/88   Support LN03+ as device 16          CH C======================================================================C         COMMON /ZPQ_HEAD/HEADER        LOGICAL HEADER*       COMMON /PLOT_MONITOR/ IMONITOR,IOUTM       DATA IMONITOR,IOUTM/1,6/-       COMMON /PLOT_MONITOR2/ IMONITOR2,IOUTM2         DATA IMONITOR2,IOUTM2/0,6/       COMMON /PLOT_CLEAR/ CLEAR        LOGICAL CLEAR/.TRUE./ (       COMMON /PLOT_PREVIOUS/ XP,YP,IPENP       DATA XP,YP,IPENP/0.,0.,0/ 1       COMMON /PLOT_BUFFER/ INDEX,IMODE,BUFFER(78)        LOGICAL*1 BUFFER       DATA INDEX,IMODE/0,1/ 5       COMMON /PLOT_BUFFER2/ INDEX2,IMODE2,BUFFER2(78)        LOGICAL*1 BUFFER2        DATA INDEX2,IMODE2/0,1/ A       COMMON /PLOT_HARDCOPY/ XLAST,YLAST,N1,N2,HARDCOPY(188,2048)        LOGICAL*1 HARDCOPY,       DATA XLAST,YLAST,N1,N2/0.,0.,188,2048/B       COMMON /HARDCOPY_RANGE/ XMINHP,XMAXHP,YMINHP,YMAXHP,IORIENTH7       DATA XMINHP,XMAXHP,YMINHP,YMAXHP/0.,639.,0.,479./        DATA IORIENTH/-1/ :       COMMON /HARDCOPY_RANGE2/ XMINH2,XMAXH2,YMINH2,YMAXH27       DATA XMINH2,XMAXH2,YMINH2,YMAXH2/0.,479.,0.,639./  C 2       COMMON /PLOT_CLEARED/PL_CLEAR_M, PL_CLEAR_M27       LOGICAL PL_CLEAR_M/.FALSE./, PL_CLEAR_M2/.FALSE./ ;       COMMON /PLOT_CLEAR_A/CLEAR1, CLEAR2, CLEARH, CLEARUNC 9       LOGICAL CLEAR1, CLEAR2, CLEARH, CLEARUNC, NCLEARUNC =       DATA CLEAR1/.FALSE./, CLEAR2/.FALSE./, CLEARH/.FALSE./,       #     CLEARUNC/.TRUE./ *       COMMON /METAFILE1/ META_ON, META_LUN       LOGICAL META_ON  C 0       COMMON/BITMAP_STATUS/BITMAP_EMPTY,MAXLINES"       LOGICAL BITMAP_EMPTY/.TRUE./       INTEGER MAXLINES/480/        COMMON/BITMAP_DEVICE/IBIT C       COMMON/GRAPHICS_BITMAP/HPAINT,NBYTES,IOFFSET,NXDIM,NYDIM,MAXY        LOGICAL*1 HPAINT(1)  C !       CHARACTER*(*) FF,CAN,ESC,GS B       PARAMETER(FF=CHAR(12),CAN=CHAR(24),ESC=CHAR(27),GS=CHAR(29))  3       IF( NBYTES .NE. 0 )CALL BITMAP_FREE_VM(ISTAT) 2       IF( IBIT   .EQ. 5 )CALL BITMAP_GET_VM(ISTAT)       CLEAR = .FALSE.         NCLEARUNC = .NOT. CLEARUNC8       XP=0.          ! Initialize previous x-coordinate.8       YP=0.          ! Initialize previous y-coordinate.5       IPENP=0        ! Initialize previous pen value. 3       INDEX=0        ! Initialize terminal buffer 1 3       INDEX2=0       ! Initialize terminal buffer 2 H C======================================================================C C  Clear monitor 1H C======================================================================C        IF(IMONITOR.EQ.0)GO TO 200)       IF(NCLEARUNC .AND. CLEAR1)GO TO 200 >       PL_CLEAR_M = .TRUE.  !flag for telling PLOT_MONITOR that6 C                           plot has just been cleared       CLEAR1 = .TRUE.   5 1000  FORMAT('+',A,$)      !format for terminal clear    C VT640 & PT100G,       IF(IMONITOR.EQ.1.OR.IMONITOR.EQ.9)THEN7         WRITE(IOUTM,1000)GS//CAN//ESC//'7'//GS//ESC//FF          CALL SLEEP2(0.5)*         WRITE(IOUTM,1000)GS//CAN//ESC//'8'  
 C Tek 4010        ELSE IF(IMONITOR.EQ.2)THEN$         WRITE(IOUTM,1000)GS//ESC//FF         CALL SLEEP2(0.5)   C VS11:         ELSE IF(IMONITOR.EQ.3)THEN         CALL VSINIT    C Zeta plotter: "       ELSE IF(IMONITOR .EQ. 4)THEN2          CLOSE(UNIT=IOUTM,DISPOSE='DELETE',ERR=11)@ 11       OPEN(UNIT=IOUTM,FILE='SYS$SCRATCH:ZETAPLOTTER.SCRATCH',H      #     CARRIAGECONTROL='LIST',STATUS='NEW',DISPOSE='DELETE',ERR=199)!          CALL Z_PLOTS(53,0,IOUTM)           HEADER=.TRUE. C 
 C HP plotter: "       ELSE IF(IMONITOR .EQ. 5)THEN2          CLOSE(UNIT=IOUTM,DISPOSE='DELETE',ERR=12)> 12       OPEN(UNIT=IOUTM,FILE='SYS$SCRATCH:HPPLOTTER.SCRATCH',H      #     CARRIAGECONTROL='LIST',STATUS='NEW',DISPOSE='DELETE',ERR=199)"          CALL HP_PLOTS(53,0,IOUTM) C  C CIT467        ELSE IF(IMONITOR.EQ.6)THEN8         WRITE(IOUTM,1000)ESC//'2'//ESC//'7'//GS//ESC//FF         CALL SLEEP2(0.5)+         WRITE(IOUTM,1000)ESC//'2'//ESC//'8'   
 C Tek 4107        ELSE IF(IMONITOR.EQ.7)THENB         WRITE(IOUTM,1000)ESC//'%!1'//ESC//'7'//ESC//'%!0'//ESC//FF         CALL SLEEP2(0.5)-         WRITE(IOUTM,1000)ESC//'%!1'//ESC//'8'    C VT241:        ELSE IF(IMONITOR.EQ.8)THEN* C If in transparent mode, home the cursor:;         WRITE(IOUTM,1000)ESC//'\'//ESC//'[2J'//ESC//'[1;1H'          CALL REGIS_MODE 4         WRITE(IOUTM,1000)'W(F15)'   ! JLC  Nov 28/88 C  C QMS Lasergrafix:!       ELSE IF(IMONITOR.EQ.10)THEN 1         CLOSE(UNIT=IOUTM,DISPOSE='DELETE',ERR=13) > 13      OPEN(UNIT=IOUTM,FILE='SYS$SCRATCH:QMSPLOTTER.SCRATCH',G      #    CARRIAGECONTROL='LIST',STATUS='NEW',DISPOSE='DELETE',ERR=199)          CALL QMS_PLOTS(IOUTM)  C  C Houston Instruments plotter:!       ELSE IF(IMONITOR.EQ.11)THEN 1         CLOSE(UNIT=IOUTM,DISPOSE='DELETE',ERR=14) ; 14      OPEN(UNIT=IOUTM,FILE='SYS$SCRATCH:HOUSTON.SCRATCH', G      #    CARRIAGECONTROL='LIST',STATUS='NEW',DISPOSE='DELETE',ERR=199) !         CALL HOUSTON_PLOTS(IOUTM)    C Seiko GR-1105 terminal: !       ELSE IF(IMONITOR.EQ.12)THEN          CALL SEIKO_CLEAR    C Imagen laser printer (IMPRESS)!       ELSE IF(IMONITOR.EQ.13)THEN 1         CLOSE(UNIT=IOUTM,DISPOSE='DELETE',ERR=15) : 15      OPEN(UNIT=IOUTM,FILE='SYS$SCRATCH:IMAGEN.SCRATCH',G      #    CARRIAGECONTROL='NONE',STATUS='NEW',DISPOSE='DELETE',ERR=199) %         CALL IMPRESS_PLOT_INIT(IOUTM)    C PostScript!       ELSE IF(IMONITOR.EQ.14)THEN 1         CLOSE(UNIT=IOUTM,DISPOSE='DELETE',ERR=16) > 16      OPEN(UNIT=IOUTM,FILE='SYS$SCRATCH:POSTSCRIPT.SCRATCH',G      #    CARRIAGECONTROL='LIST',STATUS='NEW',DISPOSE='DELETE',ERR=199) (         CALL POSTSCRIPT_PLOT_INIT(IOUTM)   C VaxStation!       ELSE IF(IMONITOR.EQ.15)THEN          CALL VST_PLOT_CLEAR    C LN03+ %       ELSE IF( IMONITOR .EQ. 16 )THEN 1         CLOSE(UNIT=IOUTM,DISPOSE='DELETE',ERR=17) 8 17      OPEN(UNIT=IOUTM,FILE='SYS$SCRATCH:LN03.SCRATCH',H      #  CARRIAGECONTROL='FORTRAN',STATUS='NEW',DISPOSE='DELETE',ERR=199)>         WRITE(IOUTM,1000)ESC//'[?38h'          !enter Tek mode7         WRITE(IOUTM,1000)GS//CAN//ESC//'7'//GS//ESC//FF *         WRITE(IOUTM,1000)GS//CAN//ESC//'8'       ENDIF   H C======================================================================C C  Clear monitor 2H C======================================================================C! 200   IF(IMONITOR2.EQ.0)GO TO 300 )       IF(NCLEARUNC .AND. CLEAR2)GO TO 300 ?       PL_CLEAR_M2 = .TRUE. !flag for telling PLOT_MONITOR2 that 6 C                           plot has just been cleared       CLEAR2 = .TRUE.    C VT640 & PT100G.       IF(IMONITOR2.EQ.1.OR.IMONITOR2.EQ.9)THEN8         WRITE(IOUTM2,1000)GS//CAN//ESC//'7'//GS//ESC//FF         CALL SLEEP2(0.5)+         WRITE(IOUTM2,1000)GS//CAN//ESC//'8'   
 C Tek 4010!       ELSE IF(IMONITOR2.EQ.2)THEN %         WRITE(IOUTM2,1000)GS//ESC//FF          CALL SLEEP2(0.5)   C VS11: !       ELSE IF(IMONITOR2.EQ.3)THEN $         IF(IMONITOR.NE.3)CALL VSINIT   C Zeta plotter: #       ELSE IF(IMONITOR2 .EQ. 4)THEN 3          CLOSE(UNIT=IOUTM2,DISPOSE='DELETE',ERR=22) A 22       OPEN(UNIT=IOUTM2,FILE='SYS$SCRATCH:ZETAPLOTTER.SCRATCH', H      #     CARRIAGECONTROL='LIST',STATUS='NEW',DISPOSE='DELETE',ERR=299)"          CALL Z_PLOTS(53,0,IOUTM2)          HEADER=.TRUE.  
 C HP plotter: #       ELSE IF(IMONITOR2 .EQ. 5)THEN 3          CLOSE(UNIT=IOUTM2,DISPOSE='DELETE',ERR=23) ? 23       OPEN(UNIT=IOUTM2,FILE='SYS$SCRATCH:HPPLOTTER.SCRATCH', H      #     CARRIAGECONTROL='LIST',STATUS='NEW',DISPOSE='DELETE',ERR=299)#          CALL HP_PLOTS(53,0,IOUTM2)    C CIT467!       ELSE IF(IMONITOR2.EQ.6)THEN 9         WRITE(IOUTM2,1000)ESC//'2'//ESC//'7'//GS//ESC//FF          CALL SLEEP2(0.5),         WRITE(IOUTM2,1000)ESC//'2'//ESC//'8'  
 C Tek 4107!       ELSE IF(IMONITOR2.EQ.7)THEN C         WRITE(IOUTM2,1000)ESC//'%!1'//ESC//'7'//ESC//'%!0'//ESC//FF          CALL SLEEP2(0.5).         WRITE(IOUTM2,1000)ESC//'%!1'//ESC//'8'   C VT241:!       ELSE IF(IMONITOR2.EQ.8)THEN * C If in transparent mode, home the cursor:<         WRITE(IOUTM2,1000)ESC//'\'//ESC//'[2J'//ESC//'[1;1H':         WRITE(IOUTM2,1000)'W(F15)'         ! JLC Nov 28/88 C QMS Lasergrafix:"       ELSE IF(IMONITOR2.EQ.10)THEN2         CLOSE(UNIT=IOUTM2,DISPOSE='DELETE',ERR=24)? 24      OPEN(UNIT=IOUTM2,FILE='SYS$SCRATCH:QMSPLOTTER.SCRATCH', G      #    CARRIAGECONTROL='LIST',STATUS='NEW',DISPOSE='DELETE',ERR=299)          CALL QMS_PLOTS(IOUTM2)   C Houston Instruments plotter:"       ELSE IF(IMONITOR2.EQ.11)THEN2         CLOSE(UNIT=IOUTM2,DISPOSE='DELETE',ERR=25)< 25      OPEN(UNIT=IOUTM2,FILE='SYS$SCRATCH:HOUSTON.SCRATCH',G      #    CARRIAGECONTROL='LIST',STATUS='NEW',DISPOSE='DELETE',ERR=299) "         CALL HOUSTON_PLOTS(IOUTM2)   C Seiko GR-1105 terminal: "       ELSE IF(IMONITOR2.EQ.12)THEN         CALL SEIKO_CLEAR2     C Imagen laser printer (IMPRESS)"       ELSE IF(IMONITOR2.EQ.13)THEN2         CLOSE(UNIT=IOUTM2,DISPOSE='DELETE',ERR=26); 26      OPEN(UNIT=IOUTM2,FILE='SYS$SCRATCH:IMAGEN.SCRATCH', G      #    CARRIAGECONTROL='NONE',STATUS='NEW',DISPOSE='DELETE',ERR=299) &         CALL IMPRESS_PLOT_INIT(IOUTM2)   C PostScript"       ELSE IF(IMONITOR2.EQ.14)THEN2         CLOSE(UNIT=IOUTM2,DISPOSE='DELETE',ERR=27)? 27      OPEN(UNIT=IOUTM2,FILE='SYS$SCRATCH:POSTSCRIPT.SCRATCH', G      #    CARRIAGECONTROL='LIST',STATUS='NEW',DISPOSE='DELETE',ERR=299) )         CALL POSTSCRIPT_PLOT_INIT(IOUTM2)    C LN03+ &       ELSE IF( IMONITOR2 .EQ. 16 )THEN2         CLOSE(UNIT=IOUTM2,DISPOSE='DELETE',ERR=28)9 28      OPEN(UNIT=IOUTM2,FILE='SYS$SCRATCH:LN03.SCRATCH', H      #  CARRIAGECONTROL='FORTRAN',STATUS='NEW',DISPOSE='DELETE',ERR=299)?         WRITE(IOUTM2,1000)ESC//'[?38h'          !enter Tek mode 8         WRITE(IOUTM2,1000)GS//CAN//ESC//'7'//GS//ESC//FF+         WRITE(IOUTM2,1000)GS//CAN//ESC//'8'        END IF  5 300   CALL PEN_UP(0.,0.)  ! Pen up to location (0,0).   B C================================================================= C  Clear the hardcopy bit map.B C=================================================================        IF(IORIENTH.EQ.0)GO TO 350*       IF(NCLEARUNC .AND. CLEARH) GO TO 350       CLEARH = .TRUE. !       IF( BITMAP_EMPTY )GO TO 350 =       IF( IBIT .NE. 5 )CALL ZERO_ARRAY(HARDCOPY,188*MAXLINES)        BITMAP_EMPTY=.TRUE. 5       MAXLINES=INT(XMAXH2)+1      !reset maximum size : C=========================================================7 C  Set the last point plotted on the hardcopy bit map,  7 C  given by coordinates (XLAST,YLAST) to zero.          : C========================================================= 350   XLAST=0.       YLAST=0.C       CLEARUNC =.TRUE. !reset for unconditional clear of monitors 1 1 C                       and 2 and hardcopy bitmap < C     If metafile is active, place "clear" instruction in itB       IF(META_ON)CALL PUT_METAFILE1(META_LUN,'CLEAR',0.,0.,0,IERR)       RETURN  ' C Error opening work file for monitor 1  199   CALL TRANSPARENT_MODE(0)C       WRITE(*,*)'Error opening SYS$SCRATCH work file for monitor 1'        CALL PUT_FORMSG        GO TO 200   ' C Error opening work file for monitor 2  299   CALL TRANSPARENT_MODE(0)C       WRITE(*,*)'Error opening SYS$SCRATCH work file for monitor 2'        CALL PUT_FORMSG        GO TO 300 	       END 