*        SUBROUTINE CONVOL(A,B,NUM,WORK,M,*)G C=====================================================================C G C      Subroutine Convol -                      Craig Irwin 11/84     C G C                                                                     C G C          This routine will calculate the convolution or decon-      C G C      volution of a function using the Fast fourier transform.       C G C                                                                     C G C      INPUT -    A   - array containing the function                 C G C                 B   - array containing the convolution function     C G C                 NUM - number of elements in A                       C G C                       positive - calculate convolution              C G C                       negative - calculate deconvolution            C G C                 WORK- array to do calculations in                   C G C                 M   - size of work array (must be at least 3*N)     C G C                                                                     C G C      OUTPUT -   A   - contains the new convoluted function          C G C                 *   - error return, will write error message        C G C                       to UNIT 6                                     C G C                                                                     C G C   required routines - CFT in DSK1:[KOST.CERN]CERN/LIB               C G C                                                                     C G C=====================================================================C "        DIMENSION A(1),B(1),WORK(1)        LOGICAL*1 CONV G C=====================================================================C G C      Initialize the constants and check the limits                  C G C=====================================================================C          IF (M.LT.3*NUM) GOTO 9800         IF (NUM.EQ.0)   GOTO 9900        IF (NUM.LT.0) THEN           CONV = .FALSE.         ELSE           CONV = .TRUE.
        END IF         N = IABS(NUM)        NN = 2*N         NNN = N + 1        BSUM = 0.G C=====================================================================C G C      Normalize the convolution function                             C G C=====================================================================C         DO 100 I=1,N           BSUM = BSUM + B(I) C          WORK(I) = 0.              ! initialize for argument in CFT C          WORK(N+I) = 0.            ! initialize for argument in CFT  100    CONTINUE         DO 200 I=1,N :          WORK(NN+I) = B(I)/BSUM    ! do not modify the B's 200    CONTINUE G C=====================================================================C G C      Call the discrete fast fourier transform (REAL)                C G C=====================================================================C         CALL CFT(A,WORK,N,N,N,1) -        CALL CFT(WORK(NN+1),WORK(NNN),N,N,N,1) G C=====================================================================C G C      Multiply the two matrices together (convolution)               C G C=====================================================================C         IF (CONV) THEN           DO 300 I=1,N             TEMP = A(I)5            A(I) = A(I)*WORK(NN+I) - WORK(I)*WORK(I+N) 8            WORK(I) = WORK(NN+I)*WORK(I) + TEMP*WORK(I+N) 300      CONTINUE G C=====================================================================C G C      Call the inverse discete fast fourier transform (convolution)  C G C=====================================================================C 6          CALL CFT(A,WORK,N,N,N,-1)      ! results in A          DO 400 I=1,N             A(I) = A(I)/N 400      CONTINUE G C=====================================================================C G C      Divide the two matrices  (deconvolution)                       C G C=====================================================================C         ELSE           DO 500 I=1,N /            DENOM = WORK(NN+I)**2 + WORK(I+N)**2             TEMP = A(I)5            A(I) = A(I)*WORK(NN+I) + WORK(I)*WORK(I+N),8            WORK(I) = WORK(I)*WORK(NN+I) - TEMP*WORK(I+N)$            IF (DENOM.EQ.0.) GOTO 500              A(I)= A(I)/DENOM #              WORK(I)= WORK(I)/DENOM  500      CONTINUE G C=====================================================================ClG C      Call the inverse discete fast fourier transform (deconvolution)CsG C=====================================================================C           DO 600 I=1,N             A(I) = A(I)/N            WORK(I) = WORK(I)/N 600      CONTINUE 6          CALL CFT(A,WORK,N,N,N,-1)      ! results in A
        END IFfG C=====================================================================C G C      Error handling section                                         C G C=====================================================================Cn        GOTO 10000  9800   WRITE(6,9850)B 9850   FORMAT('- **** ERROR in CONVOL - workspace too small ****')        RETURN1 9900   WRITE(6,9950)E 9950   FORMAT('- **** ERROR in CONVOL - N cannot be equal to 0 ****')         RETURN1
 10000  RETURN 
        END