-       SUBROUTINE CROSSHAIR2_R(X,Y,CODE,XL,YL) H C=======================================================================H C==                                                                   ==H C==   CROSSHAIR2_R                                                    ==H C==   sets monitor2 into crosshair mode                               ==H C                                                                      CH C  If the plot coordinates (XL,YL) are on the screen then the          CH C  crosshair will appear at the screen location corresponding to       CH C  (XL,YL). If (XL,YL) is off the screen then it will appear where it  CH C  was the last time it was positioned. It can then be positioned to   CH C  any point on the display screen using the four arrow keys on the    CH C  keyboard. After being positioned, typing any key on the keyboard    CH C  will cause the character corresponding to that key to be returned   CH C  in CODE (LOGICAL*1), and the cross hair plot coordinates to be      CH C  returned in (X,Y).                                                  CH C                                                                      CH C  Note: In order to use this subroutine correctly the trailer codes   CH C  of the VT640 local mode (set using the PF3 key after doing a SETUP  CH C  RESET) must be set to 0D (carriage return) and FF hexadecimal.      CH C                                                                      CH C  NOTE:  There are 4 light pen modes which can be set by via the MODE CH C  variable (CHARACTER*1) in the common block LIGHT_PEN_MODE.  The     CH C  modes are:                                                          CH C                                                                      CH C              '0' - clear (ie. nothing happens)                       CH C              '1' - turns the 'L1' light on the keyboard on           CH C              '2' - beeps when a reading is made                      CH C              '3' - flashes 'LIGHT PEN READY' (default)               CH C                                                                      CH C  These mode have no effect when you are not using the light pen.     CH C                                                                      CH C   Written by Arthur Haynes, TRIUMF U.B.C., July 7, 1981.             CH C   Modified by Henry Baragar, TRIUMF UBC, November 18, 1982.          CH C   Modified by Alan Carruthers, February 23, 1983 to allow            CH C     joystick positioning of crosshairs on VS11, then readback        CH C     of crosshair location.                                           CH C   Modified by Alan Carruthers, October 4, 1983 to prevent            CH C     integer overflow when IXLM and IYLM are calculated.              CH C   Modified by Henry Baragar, May 23, 1984 to use READ_KEY            CH C     to get imput to prevent problems that occur when the             CE C     <CR> is hit for input.	                                       C H C   Modified by Bernard Henin, July 1984, to include the               CH C     TEKTRONIX-4107.                                                  CH C   Modified by Corrie Kost, Aug 23/1984 to use VT241 and              CH C     improve coding readability                                       CH C   Modified by F.W. Jones, Oct 28/86.  For the VT640, after the       CH C     crosshair address is sent, a string of 30 nulls is sent before   CH C     bringing up the crosshairs.  This is to correct a timing         CH C     problem that occurs in some VT640's, where the crosshairs will   CH C     not come up and the terminal will hang.  An alternative fix      CH C     would be to put a "sleep" of about 0.05 sec between the two      CH C     escape sequences.  This problem appeared after the "sleep" was   CH C     removed from the TRANSPARENT_MODE procedure and seems to result  CH C     from quick transitions between transparent and graphics modes.   CH C   Modified by J.Chuma, Jan 30, 1987, to correct scaling numbers for  CH C     the TEK-4107.  See [KOST.LIBRARY.EXAMPLES]TK4107.FOR for tests)  CH C   Modified by J.Chuma, Feb 2, 1987, to upgrade the monitor 2         CH C     capability                                                       CH C                                                                      CH C   Input  Parameters: XL,YL (R*4).                                    CH C                                                                      CH C   Output Parameters: X,Y (R*4); CODE (L*1).                          CH C                                                                      CH C======================================================================C       COMMON /PLOT_CLEAR/ CLEAR        LOGICAL CLEAR/.TRUE./ +       COMMON /PLOT_MONITOR2/ IMONITOR,IOUTM        DATA IMONITOR,IOUTM/0,6/D       COMMON /MONITOR2_SIZE/ XMINMSIZE,XMAXMSIZE,YMINMSIZE,YMAXMSIZEC       DATA XMINMSIZE,XMAXMSIZE,YMINMSIZE,YMAXMSIZE/0.,639.,0.,479./ 9       COMMON /PLOT_TO_MONITOR2/ RMATRIXMP(2,2),SHIFTMP(2) 0       DATA RMATRIXMP/1.,0.,0.,1./,SHIFTMP/0.,0./9       COMMON /MONITOR2_TO_PLOT/ RMATRIXPM(2,2),SHIFTPM(2) 0       DATA RMATRIXPM/1.,0.,0.,1./,SHIFTPM/0.,0./#       COMMON /PLOT_INPUT_UNIT/ IINS        DATA IINS/5/7       LOGICAL*1 CODE,IBYTE(4),GS/Z1D/,ESC/Z1B/,SUB/Z1A/        LOGICAL*1 I241(11)       INTEGER I33/33/ #       LOGICAL*1 IYHI,IYLO,IXHI,IXLO "       COMMON /LIGHT_PEN_MODE/ MODE       CHARACTER*1 MODE       DATA MODE /'3'/ "       CHARACTER*1 READ_KEY, ALTKEY=       PARAMETER (BIG = 2.147E9)  !inserted by Alan Carruthers C C                      2.147E9 is slightly smaller than the maximum ? C                      value that an integer variable can have.        PARAMETER(CR=13)       LOGICAL*1 NULLS(30)/30*0/  C        IF(CLEAR)CALL CLEAR_PLOT C 
       X=0.
       Y=0.       CODE='0' C  C    IMONITOR #      DEVICE  C    ----------     -------- C       1            VT640 C       2            TX4010  C       3            VS11  C       4            ZETA  C       5            HP  C       6            CIT-467 C       7            TEK4107 C       8            VT241 C       9            PT100 C 2       IF(IMONITOR.LT.1 .OR. IMONITOR .GT.9) RETURN. C            1   2   3   4   5   6   7   8   98       GOTO (100,200,300,400,500,600,700,800,100)IMONITORB C=================================================================B C==   Determine the monitor coordinates (XLM,YLM) which         ==B C==   correspond to the plot coordinates (XL,YL):               ==B C==                                                             ==B C==       |XLM|               |XL|                              ==B C==       |   | = RMATRIXMP * |  | + SHIFTMP                    ==B C==       |YLM|               |YL|                              ==B C=================================================================8 100   XLM=RMATRIXMP(1,1)*XL+RMATRIXMP(1,2)*YL+SHIFTMP(1)8       YLM=RMATRIXMP(2,1)*XL+RMATRIXMP(2,2)*YL+SHIFTMP(2)B C=================================================================B C==   (IXLM,IYLM) are the monitor dot coordinates which         ==B C==   correspond to the plot coordinates (XL,YL).               ==B C=================================================================@       IXLM=MAX(-BIG,MIN(BIG,XLM+SIGN(.5,XLM)))  !Alan Carruthers@       IYLM=MAX(-BIG,MIN(BIG,YLM+SIGN(.5,YLM)))  !Alan CarruthersB C=================================================================B C==   Check to see if (IXLM,IYLM) is on the monitor screen.     ==B C=================================================================3       IF(IXLM.LT.XMINMSIZE.OR.IXLM.GT.XMAXMSIZE.OR. 9      *   IYLM.LT.YMINMSIZE.OR.IYLM.GT.YMAXMSIZE)GO TO 125 B C=================================================================B C==   (IXLM,IYLM) is on the monitor screen. Load the crosshair  ==B C==   to location (IXLM,IYLM) on the screen.                    ==B C=================================================================B C==   Scale from VT640 to TX4010 values since VT640 is a TX4010 ==B C==   emulator.                                                 ==B C=================================================================       IXLM=IXLM*1024/640       IYLM=IYLM*780/480 B C=================================================================B C==   Calculate the four plot characters required to load the   ==B C==   crosshair to the TX4010 location: (IXLM,IYLM).            ==B C=================================================================       IYHI=32+IYLM/32        IYLO=96+MOD(IYLM,32)       IXHI=32+IXLM/32        IXLO=64+MOD(IXLM,32)B C=================================================================B C==   Load the crosshair at the TX4010 location: (IXLM,IYLM).   ==B C=================================================================F       WRITE(IOUTM,122)GS,IYHI,IYLO,IXHI,IXLO,ESC,'/','f',NULLS,ESC,SUB 122   FORMAT('$',40A1)       GO TO 124 B C=================================================================B C==   (IXLM,IYLM) is off the monitor screen. Display the        ==B C==   crosshair on the screen at the same place it was last     ==B C==   positioned.                                               ==B C=================================================================4 125   WRITE(IOUTM,150)GS,ESC,'"',MODE,'e',ESC,SUB    C H C Enter Graphics, ...Crosshair mode, Read code and crosshair coordinates C  150   FORMAT('$',10A1)< 124   CODE = ICHAR(READ_KEY('NOESC LC2UC PURGE',' ',ALTKEY))' 	DO WHILE (CODE.EQ.CR .OR. CODE.EQ.ESC)  	    CALL BELL(1) 0 	    WRITE(IOUTM,150)GS,ESC,'"',MODE,'e',ESC,SUB; 	    CODE = ICHAR(READ_KEY('NOESC LC2UC PURGE',' ',ALTKEY))  	ENDDO 	DO IBYTER=1,48 	    IBYTE(IBYTER) = ICHAR(READ_KEY('NOESC',' ',ALTKEY)) 	ENDDO+ 	IDUMMY = ICHAR(READ_KEY(' ',' ',ALTKEY,0))=B C=================================================================B C==   Calculate the crosshair coordinates (IXM,IYM) for the     ==B C==   device.                                                   ==B C=================================================================$       IXM=(IBYTE(1)-I33)*32+IBYTE(2)$       IYM=(IBYTE(3)-I33)*32+IBYTE(4)B C=================================================================B C==   Scale from TX4010 to VT640 values since VT640 is a TX4010 ==B C==   emulator.                                                 ==B C=================================================================       IXM=IXM*640./1024.+.6u       IYM=IYM*480./780.+.6B C=================================================================B C==   Determine the plot coordinates (X,Y) which correspond     ==B C==   to the crosshair monitor coordinates (IXM,IYM):           ==B C==                                                             ==B C==       |X|               |IXM|                               ==B C==       | | = RMATRIXPM * |   | + SHIFTPM                     ==B C==       |Y|               |IYM|                               ==B C=================================================================8       X=RMATRIXPM(1,1)*IXM+RMATRIXPM(1,2)*IYM+SHIFTPM(1)8       Y=RMATRIXPM(2,1)*IXM+RMATRIXPM(2,2)*IYM+SHIFTPM(2)       RETURN C 
 C***** TX4010r C B C=================================================================B C==   Determine the monitor coordinates (XLM,YLM) which         ==B C==   correspond to the plot coordinates (XL,YL):               ==B C==                                                             ==B C==       |XLM|               |XL|                              ==B C==       |   | = RMATRIXMP * |  | + SHIFTMP                    ==B C==       |YLM|               |YL|                              ==B C=================================================================8 200   XLM=RMATRIXMP(1,1)*XL+RMATRIXMP(1,2)*YL+SHIFTMP(1)8       YLM=RMATRIXMP(2,1)*XL+RMATRIXMP(2,2)*YL+SHIFTMP(2)B C=================================================================B C==   (IXLM,IYLM) are the monitor dot coordinates which         ==B C==   correspond to the plot coordinates (XL,YL).               ==B C=================================================================@       IXLM=MAX(-BIG,MIN(BIG,XLM+SIGN(.5,XLM)))  !Alan Carruthers@       IYLM=MAX(-BIG,MIN(BIG,YLM+SIGN(.5,YLM)))  !Alan CarruthersB C=================================================================B C==   Check to see if (IXLM,IYLM) is on the monitor screen.     ==B C=================================================================3       IF(IXLM.LT.XMINMSIZE.OR.IXLM.GT.XMAXMSIZE.OR. 9      *   IYLM.LT.YMINMSIZE.OR.IYLM.GT.YMAXMSIZE)GO TO 225 B C=================================================================B C==   (IXLM,IYLM) is on the monitor screen. Load the crosshair  ==B C==   to location (IXLM,IYLM) on the screen.                    ==B C=================================================================B C==   Calculate the four plot characters required to load the   ==B C==   crosshair to the TX4010 location: (IXLM,IYLM).            ==B C=================================================================       IYHI=32+IYLM/32        IYLO=96+MOD(IYLM,32)       IXHI=32+IXLM/32        IXLO=64+MOD(IXLM,32)B C=================================================================B C==   Load the crosshair at the TX4010 location: (IXLM,IYLM).   ==B C=================================================================@       WRITE(IOUTM,222)GS,IYHI,IYLO,IXHI,IXLO,ESC,'/','f',ESC,SUB 222   FORMAT('$',10A1)       GO TO 224 B C=================================================================B C==   (IXLM,IYLM) is off the monitor screen. Display the        ==B C==   crosshair on the screen at the same place it was last     ==B C==   positioned.                                               ==B C=================================================================4 225   WRITE(IOUTM,250)GS,ESC,'"',MODE,'e',ESC,SUB    C H C Enter Graphics, ...Crosshair mode, Read code and crosshair coordinates C  250   FORMAT('$',10A1)< 224   CODE = ICHAR(READ_KEY('NOESC LC2UC PURGE',' ',ALTKEY))' 	DO WHILE (CODE.EQ.CR .OR. CODE.EQ.ESC)  	    CALL BELL(1) 0 	    WRITE(IOUTM,250)GS,ESC,'"',MODE,'e',ESC,SUB; 	    CODE = ICHAR(READ_KEY('NOESC LC2UC PURGE',' ',ALTKEY))  	ENDDO 	DO IBYTER=1,48 	    IBYTE(IBYTER) = ICHAR(READ_KEY('NOESC',' ',ALTKEY)) 	ENDDO+ 	IDUMMY = ICHAR(READ_KEY(' ',' ',ALTKEY,0)) B C=================================================================B C==   Calculate the crosshair coordinates (IXM,IYM) for the     ==B C==   device.                                                   ==B C=================================================================$       IXM=(IBYTE(1)-I33)*32+IBYTE(2)$       IYM=(IBYTE(3)-I33)*32+IBYTE(4)B C=================================================================B C==   Determine the plot coordinates (X,Y) which correspond     ==B C==   to the crosshair monitor coordinates (IXM,IYM):           ==B C==                                                             ==B C==       |X|               |IXM|                               ==B C==       | | = RMATRIXPM * |   | + SHIFTPM                     ==B C==       |Y|               |IYM|                               ==B C=================================================================8       X=RMATRIXPM(1,1)*IXM+RMATRIXPM(1,2)*IYM+SHIFTPM(1)8       Y=RMATRIXPM(2,1)*IXM+RMATRIXPM(2,2)*IYM+SHIFTPM(2)       RETURN C 	 C*** VS11  C 8 C Note: IMONITOR = 3   On VS11 crosshairs are positioned6 C                      at their last location -- can'tC C                      yet pre-position crosshairs USING XL and YL.  C B C     Subroutine VSGETJOY allows positioning of crosshairs on VS11B C     using joystick, then returns monitor coordinates IXM and IYM0 C     once either button on joystick is pressed. C $ 300   CALL VSGETJOY(0,IXM,IYM,ISTAT)B C=================================================================B C==   Determine the plot coordinates (X,Y) which correspond     ==B C==   to the crosshair monitor coordinates (IXM,IYM):           ==B C==                                                             ==B C==       |X|               |IXM|                               ==B C==       | | = RMATRIXPM * |   | + SHIFTPM                     ==B C==       |Y|               |IYM|                               ==B C=================================================================8       X=RMATRIXPM(1,1)*IXM+RMATRIXPM(1,2)*IYM+SHIFTPM(1)8       Y=RMATRIXPM(2,1)*IXM+RMATRIXPM(2,2)*IYM+SHIFTPM(2)       RETURN C 	 C*** ZETA  C  400   RETURN C  C*** HP  C  500   RETURN C  C*** CIT-467 C B C=================================================================B C==   Determine the monitor coordinates (XLM,YLM) which         ==B C==   correspond to the plot coordinates (XL,YL):               ==B C==                                                             ==B C==       |XLM|               |XL|                              ==B C==       |   | = RMATRIXMP * |  | + SHIFTMP                    ==B C==       |YLM|               |YL|                              ==B C=================================================================8 600   XLM=RMATRIXMP(1,1)*XL+RMATRIXMP(1,2)*YL+SHIFTMP(1)8       YLM=RMATRIXMP(2,1)*XL+RMATRIXMP(2,2)*YL+SHIFTMP(2)B C=================================================================B C==   (IXLM,IYLM) are the monitor dot coordinates which         ==B C==   correspond to the plot coordinates (XL,YL).               ==B C=================================================================@       IXLM=MAX(-BIG,MIN(BIG,XLM+SIGN(.5,XLM)))  !Alan Carruthers@       IYLM=MAX(-BIG,MIN(BIG,YLM+SIGN(.5,YLM)))  !Alan CarruthersB C=================================================================B C==   Check to see if (IXLM,IYLM) is on the monitor screen.     ==B C=================================================================3       IF(IXLM.LT.XMINMSIZE.OR.IXLM.GT.XMAXMSIZE.OR. 9      *   IYLM.LT.YMINMSIZE.OR.IYLM.GT.YMAXMSIZE)GO TO 625 B C=================================================================B C==   (IXLM,IYLM) is on the monitor screen. Load the crosshair  ==B C==   to location (IXLM,IYLM) on the screen.                    ==B C=================================================================B C==   Scale from CIT-467 to TX4010  since CIT-467   is a TX4010 ==B C==   emulator.                                                 ==B C=================================================================2       IXLM=IXLM*1023.77/571.      ! SEE CIT467.FOR2       IYLM=IYLM*785.87/479.       ! SEE CIT467.FORB C=================================================================B C==   Calculate the four plot characters required to load the   ==B C==   crosshair to the TX4010 location: (IXLM,IYLM).            ==B C=================================================================       IYHI=32+IYLM/323       IYLO=96+MOD(IYLM,32)       IXHI=32+IXLM/32)       IXLO=64+MOD(IXLM,32)B C=================================================================B C==   Load the crosshair at the TX4010 location: (IXLM,IYLM).   ==B C=================================================================@       WRITE(IOUTM,622)GS,IYHI,IYLO,IXHI,IXLO,ESC,'/','f',ESC,SUB 622   FORMAT('$',10A1)       GO TO 624=B C=================================================================B C==   (IXLM,IYLM) is off the monitor screen. Display the        ==B C==   crosshair on the screen at the same place it was last     ==B C==   positioned.                                               ==B C=================================================================4 625   WRITE(IOUTM,650)GS,ESC,'"',MODE,'e',ESC,SUB    C=H C Enter Graphics, ...Crosshair mode, Read code and crosshair coordinates C= 650   FORMAT('$',10A1)< 624   CODE = ICHAR(READ_KEY('NOESC LC2UC PURGE',' ',ALTKEY))' 	DO WHILE (CODE.EQ.CR .OR. CODE.EQ.ESC)M 	    CALL BELL(1)A0 	    WRITE(IOUTM,650)GS,ESC,'"',MODE,'e',ESC,SUB; 	    CODE = ICHAR(READ_KEY('NOESC LC2UC PURGE',' ',ALTKEY))= 	ENDDO 	DO IBYTER=1,48 	    IBYTE(IBYTER) = ICHAR(READ_KEY('NOESC',' ',ALTKEY)) 	ENDDO+ 	IDUMMY = ICHAR(READ_KEY(' ',' ',ALTKEY,0))YB C=================================================================B C==   Calculate the crosshair coordinates (IXM,IYM) for the     ==B C==   device.                                                   ==B C=================================================================$       IXM=(IBYTE(1)-I33)*32+IBYTE(2)$       IYM=(IBYTE(3)-I33)*32+IBYTE(4)B C=================================================================B C==   Scale from TX4010 to CIT-467 since CIT-467    is a TX4010 ==B C==   emulator.                                                 ==B C=================================================================@       IXM=IXM*571./1023.77+.6        ! DONT ASK WHY THIS WORKS !?       IYM=IYM*479./786.11+.6         ! SEE CIT467.FOR FOR TESTS B C=================================================================B C==   Determine the plot coordinates (X,Y) which correspond     ==B C==   to the crosshair monitor coordinates (IXM,IYM):           ==B C==                                                             ==B C==       |X|               |IXM|                               ==B C==       | | = RMATRIXPM * |   | + SHIFTPM                     ==B C==       |Y|               |IYM|                               ==B C=================================================================8       X=RMATRIXPM(1,1)*IXM+RMATRIXPM(1,2)*IYM+SHIFTPM(1)8       Y=RMATRIXPM(2,1)*IXM+RMATRIXPM(2,2)*IYM+SHIFTPM(2)       RETURN C= C*** TEK4107 C=B C=================================================================B C==   Determine the monitor coordinates (XLM,YLM) which         ==B C==   correspond to the plot coordinates (XL,YL):               ==B C==                                                             ==B C==       |XLM|               |XL|                              ==B C==       |   | = RMATRIXMP * |  | + SHIFTMP                    ==B C==       |YLM|               |YL|                              ==B C=================================================================8 700   XLM=RMATRIXMP(1,1)*XL+RMATRIXMP(1,2)*YL+SHIFTMP(1)8       YLM=RMATRIXMP(2,1)*XL+RMATRIXMP(2,2)*YL+SHIFTMP(2)B C=================================================================B C==   (IXLM,IYLM) are the monitor dot coordinates which         ==B C==   correspond to the plot coordinates (XL,YL).               ==B C=================================================================@       IXLM=MAX(-BIG,MIN(BIG,XLM+SIGN(.5,XLM)))  !Alan Carruthers@       IYLM=MAX(-BIG,MIN(BIG,YLM+SIGN(.5,YLM)))  !Alan CarruthersB C=================================================================B C==   Check to see if (IXLM,IYLM) is on the monitor screen.     ==B C=================================================================3       IF(IXLM.LT.XMINMSIZE.OR.IXLM.GT.XMAXMSIZE.OR. 9      *   IYLM.LT.YMINMSIZE.OR.IYLM.GT.YMAXMSIZE)GO TO 725EB C=================================================================B C==   (IXLM,IYLM) is on the monitor screen. Load the crosshair  ==B C==   to location (IXLM,IYLM) on the screen.                    ==B C=================================================================B C==   Scale from VT640 to TX4010 values since VT640 is a TX4010 ==B C==   emulator.                                                 ==B C=================================================================G       IXLM=IXLM*1023.8/639.+0.12707355      ! DONT ASK WHY THIS WORKS ! F       IYLM=IYLM*782.515/479.+0.127943215031 ! SEE TK4107.FOR FOR TESTSB C=================================================================B C==   Calculate the four plot characters required to load the   ==B C==   crosshair to the TX4010 location: (IXLM,IYLM).            ==B C=================================================================       IYHI=32+IYLM/32        IYLO=96+MOD(IYLM,32)       IXHI=32+IXLM/32=       IXLO=64+MOD(IXLM,32)B C=================================================================B C==   Load the crosshair at the TX4010 location: (IXLM,IYLM).   ==B C=================================================================       WRITE(IOUTM,722)F      #           ESC,'%!',0,GS,IYHI,IYLO,IXHI,IXLO,ESC,'/','f',ESC,SUB 722   FORMAT('$',A1,A2,I1,10A1)r       GO TO 724 B C=================================================================B C==   (IXLM,IYLM) is off the monitor screen. Display the        ==B C==   crosshair on the screen at the same place it was last     ==B C==   positioned.                                               ==B C=================================================================? 725   WRITE(IOUTM,722)ESC,'%!',0,GS,ESC,'"',MODE,'e',ESC,SUB   t CcH C Enter Graphics, ...Crosshair mode, Read code and crosshair coordinates C  750   FORMAT('$',10A1)< 724   CODE = ICHAR(READ_KEY('NOESC LC2UC PURGE',' ',ALTKEY))' 	DO WHILE (CODE.EQ.CR .OR. CODE.EQ.ESC)  	    CALL BELL(1) ; 	    WRITE(IOUTM,722)ESC,'%!',0,GS,ESC,'"',MODE,'e',ESC,SUB ; 	    CODE = ICHAR(READ_KEY('NOESC LC2UC PURGE',' ',ALTKEY))= 	ENDDO 	DO IBYTER=1,48 	    IBYTE(IBYTER) = ICHAR(READ_KEY('NOESC',' ',ALTKEY)) 	ENDDO+ 	IDUMMY = ICHAR(READ_KEY(' ',' ',ALTKEY,0))PB C=================================================================B C==   Calculate the crosshair coordinates (IXM,IYM) for the     ==B C==   device.                                                   ==B C=================================================================$       IXM=(IBYTE(1)-I33)*32+IBYTE(2)$       IYM=(IBYTE(3)-I33)*32+IBYTE(4)B C=================================================================B C==   Scale from TX4010 to VT640 values since VT640 is a TX4010 ==B C==   emulator.                                                 ==B C=================================================================?       IXM=IXM*(639./1023.8)+.65   ! DONT ASK WHY IT JUST WORKS.I>       IYM=IYM*(479./783.2)+0.92   ! SEE TK4107.FOR FOR TESTINGB C=================================================================B C==   Determine the plot coordinates (X,Y) which correspond     ==B C==   to the crosshair monitor coordinates (IXM,IYM):           ==B C==                                                             ==B C==       |X|               |IXM|                               ==B C==       | | = RMATRIXPM * |   | + SHIFTPM                     ==B C==       |Y|               |IYM|                               ==B C=================================================================8       X=RMATRIXPM(1,1)*IXM+RMATRIXPM(1,2)*IYM+SHIFTPM(1)8       Y=RMATRIXPM(2,1)*IXM+RMATRIXPM(2,2)*IYM+SHIFTPM(2)       RETURN C 	 C== VT241I C.B C=================================================================B C==   Determine the monitor coordinates (XLM,YLM) which         ==B C==   correspond to the plot coordinates (XL,YL):               ==B C==                                                             ==B C==       |XLM|               |XL|                              ==B C==       |   | = RMATRIXMP * |  | + SHIFTMP                    ==B C==       |YLM|               |YL|                              ==B C================================================================= 800   CALL REGIS_MODE  C 8       XLM=RMATRIXMP(1,1)*XL+RMATRIXMP(1,2)*YL+SHIFTMP(1)8       YLM=RMATRIXMP(2,1)*XL+RMATRIXMP(2,2)*YL+SHIFTMP(2)B C=================================================================B C==   (IXLM,IYLM) are the monitor dot coordinates which         ==B C==   correspond to the plot coordinates (XL,YL).               ==B C=================================================================2       XLM=MAX(-BIG,MIN(BIG,XLM))  !Alan Carruthers2       YLM=MAX(-BIG,MIN(BIG,YLM))  !Alan Carruthers       IXLM=NINT(XLM)       IYLM=NINT(YLM)B C=================================================================B C==   Check to see if (IXLM,IYLM) is on the monitor screen.     ==B C=================================================================3       IF(IXLM.LT.XMINMSIZE.OR.IXLM.GT.XMAXMSIZE.OR. 9      *   IYLM.LT.YMINMSIZE.OR.IYLM.GT.YMAXMSIZE)GO TO 825iB C=================================================================B C==   (IXLM,IYLM) is on the monitor screen. Load the crosshair  ==B C==   to location (IXLM,IYLM) on the screen.                    ==B C=================================================================       IYLM=ABS(IYLM-479)B C=================================================================B C==   Load the crosshair at the VT241  location: (IXLM,IYLM).   ==B C=================================================================3       WRITE(IOUTM,822)'P[',IXLM,',',IYLM,']R(P(I))' ! 822   FORMAT(1X,A,I3.3,A1,I3.3,A)t       GO TO 824T C'J C Enter Graphics ...Crosshair mode.. Read code and cross-hair coordinates. C   825    WRITE(IOUTM,850)'R(P(I))' 850    FORMAT(1X,A)e= 824    CODE = ICHAR(READ_KEY('NOESC LC2UC PURGE',' ',ALTKEY))e' 	DO WHILE (CODE.EQ.CR .OR. CODE.EQ.ESC)l 	    CALL BELL(1)  	    WRITE(IOUTM,850)'R(P(I))'; 	    CODE = ICHAR(READ_KEY('NOESC LC2UC PURGE',' ',ALTKEY))o 	ENDDO5         I241(1) = ICHAR(READ_KEY('NOESC',' ',ALTKEY))          I241R=11 	DO WHILE (I241(I241R) .NE. CR)o             I241R=I241R+1S6 	    I241(I241R) = ICHAR(READ_KEY('NOESC',' ',ALTKEY)) 	ENDDO         I241R=I241R-17 Co& C  INTERPRET STRING I241 AS P[xxx,yyy]+ C  Extract xxx  ---> IXM  ,   yyy ----> IYM  C        IYM=0 A       I=I241R-1                                  !Start at last y 	       J=0         DO WHILE (I241(I).NE. ',')        IYM=IYM+(I241(I)-48)*10**J       I=I-1        J=J+1        ENDDO A       I=I-1                                     ! Start at last x)       IXM=0 	       J=0 !       DO WHILE (I241(I) .NE. '[')         IXM=IXM+(I241(I)-48)*10**J       I=I-1        J=J+1=       ENDDO=       IYM=ABS(479-IYM)B C=================================================================B C==   Determine the plot coordinates (X,Y) which correspond     ==B C==   to the crosshair monitor coordinates (IXM,IYM):           ==B C==                                                             ==B C==       |X|               |IXM|                               ==B C==       | | = RMATRIXPM * |   | + SHIFTPM                     ==B C==       |Y|               |IYM|                               ==B C=================================================================8       X=RMATRIXPM(1,1)*IXM+RMATRIXPM(1,2)*IYM+SHIFTPM(1)8       Y=RMATRIXPM(2,1)*IXM+RMATRIXPM(2,2)*IYM+SHIFTPM(2)       RETURN	       END 