,       SUBROUTINE CROSSHAIR_R(X,Y,CODE,XL,YL)H C======================================================================CH C                                                                      CH C  CROSSHAIR_R                                                         CH C                                                                      CH C  Gets a digitized point using the device's crosshair cursor.         CH C                                                                      CH C  If the plot coordinates (XL,YL) are on the screen then the          CH C  crosshair will appear at the screen location corresponding to       CH C  (XL,YL). If (XL,YL) is off the screen then it will appear where it  CH C  was the last time it was positioned. It can then be positioned to   CH C  any point on the display screen using the four arrow keys on the    CH C  keyboard. After being positioned, typing any key on the keyboard    CH C  will cause the character corresponding to that key to be returned   CH C  in CODE (LOGICAL*1), and the cross hair plot coordinates to be      CH C  returned in (X,Y).                                                  CH C                                                                      CH C  Note: In order to use this subroutine correctly the trailer codes   CH C  of the VT640 local mode (set using the PF3 key after doing a SETUP  CH C  RESET) must be set to 0D (carriage return) and 0C hexadecimal.      CH C                                                                      CH C  NOTE:  There are 4 light pen modes which can be set by via the MODE CH C  variable (CHARACTER*1) in the common block LIGHT_PEN_MODE.  The     CH C  modes are:                                                          CH C              '0' - clear (ie. nothing happens)                       CH C              '1' - turns the 'L1' light on the keyboard on           CH C              '2' - beeps when a reading is made                      CH C              '3' - flashes 'LIGHT PEN READY' (default)               CH C  These mode have no effect when you are not using the light pen.     CH C                                                                      CH C   Written by Arthur Haynes, TRIUMF U.B.C., July 7, 1981.             CH C   Modified by Henry Baragar, TRIUMF UBC, November 18, 1982.          CH C   Modified by Alan Carruthers, February 23, 1983 to allow            CH C     joystick positioning of crosshairs on VS11, then readback        CH C     of crosshair location.                                           CH C   Modified by Alan Carruthers, October 4, 1983 to prevent            CH C     integer overflow when IXLM and IYLM are calculated.              CH C   Modified by Henry Baragar, May 23, 1984 to use READ_KEY            CH C     to get imput to prevent problems that occur when the             CE C     <CR> is hit for input.	                                       C H C   Modified by Bernard Henin, July 1984, to include the               CH C     TEKTRONIX-4107.                                                  CH C   Modified by Corrie Kost, Aug 23/1984 to use VT241 and              CH C     improve coding readability                                       CH C   Modified by F.W. Jones, Oct 28/86.  For the VT640, after the       CH C     crosshair address is sent, a string of 40 nulls is sent before   CH C     bringing up the crosshairs.  This is to correct a timing         CH C     problem that occurs in some VT640's, where the crosshairs will   CH C     not come up and the terminal will hang.  An alternative fix      CH C     would be to put a "sleep" of about 0.05 sec between the two      CH C     escape sequences.  This problem appeared after the "sleep" was   CH C     removed from the TRANSPARENT_MODE procedure and seems to result  CH C     from quick transitions between transparent and graphics modes.   CH C   Modified by J.Chuma, Jan 30, 1987, to correct scaling numbers for  CH C     the TEK-4107.  See [KOST.LIBRARY.EXAMPLES]TK4107.FOR for tests)  CH C   Modified Mar 20/87 by F. Jones for Seiko GR-1105 terminal support  CH C   Modified Aug 18/87 by F. Jones.  To correct VT640 crosshair        CH C     hangup which appeared again, the fix has been changed.  Now a    CH C     string of 60 nulls is sent before sending the crosshair address  CH C     and mode change sequences, which are sent without intervening    CH C     nulls.                                                           CH C                                                                      CH C   Modified May 6/88 by C. Kost. Restrain cursor addresses returned   CH C     to 0-1023 (both X&Y)                                             CH C   Modified Aug 9/88 by C.Kost. Optionally preset cursor for VAXSTATn.CH C   Input  Parameters: XL,YL (R*4).                                    CH C                                                                      CH C   Output Parameters: X,Y (R*4); CODE (L*1).                          CH C                                                                      CH C======================================================================C       COMMON /PLOT_CLEAR/ CLEAR        LOGICAL CLEAR/.TRUE./ *       COMMON /PLOT_MONITOR/ IMONITOR,IOUTM       DATA IMONITOR,IOUTM/1,6/C       COMMON /MONITOR_SIZE/ XMINMSIZE,XMAXMSIZE,YMINMSIZE,YMAXMSIZE C       DATA XMINMSIZE,XMAXMSIZE,YMINMSIZE,YMAXMSIZE/0.,639.,0.,479./ 8       COMMON /PLOT_TO_MONITOR/ RMATRIXMP(2,2),SHIFTMP(2)0       DATA RMATRIXMP/1.,0.,0.,1./,SHIFTMP/0.,0./8       COMMON /MONITOR_TO_PLOT/ RMATRIXPM(2,2),SHIFTPM(2)0       DATA RMATRIXPM/1.,0.,0.,1./,SHIFTPM/0.,0./7       LOGICAL*1 CODE,IBYTE(4),GS/Z1D/,ESC/Z1B/,SUB/Z1A/        INTEGER I33/33/ #       LOGICAL*1 IYHI,IYLO,IXHI,IXLO        LOGICAL*1 I241(11)"       COMMON /LIGHT_PEN_MODE/ MODE       CHARACTER*1 MODE/'3'/ "       CHARACTER*1 READ_KEY, ALTKEY. C 2.147E9 is slightly smaller than the maximum* C value that an integer variable can have:=       PARAMETER (BIG = 2.147E9)  !inserted by Alan Carruthers        PARAMETER(CR=13)       LOGICAL*1 NULLS(60)/60*0/        CHARACTER*1 US /31/        CHARACTER*2 HEXBUFF =       INTEGER*2 IXM2,IYM2,IXLOB,IXMOB,IXHOB,IYLOB,IYMOB,IYHOB  C        IF(CLEAR)CALL CLEAR_PLOT
       X=0.
       Y=0.       CODE='0' C  C    IMONITOR #      DEVICE  C    ----------     -------- C       1            VT640 C       2            TX4010  C       3            VS11  C       4            ZETA  C       5            HP  C       6            CIT-467 C       7            TEK4107 C       8            VT241 C       9            PT100	 C      10 	 C      11 ! C      12            SEIKO GR1105  C      13        C      14              C      15            VAXSTATION  C 9 C            1   2   3   4   5   6   7   8   9  10 11  12 :       GOTO (100,200,300,400,500,600,700,800,100,10,10,900, C            13 14  15       #       10,10,1000)IMONITOR 10    RETURNB C=================================================================@ C   Determine the monitor coordinates (XLM,YLM) which         ==@ C   correspond to the plot coordinates (XL,YL):               ==@ C                                                             ==@ C       |XLM|               |XL|                              ==@ C       |   | = RMATRIXMP * |  | + SHIFTMP                    ==@ C       |YLM|               |YL|                              ==B C=================================================================8 100   XLM=RMATRIXMP(1,1)*XL+RMATRIXMP(1,2)*YL+SHIFTMP(1)8       YLM=RMATRIXMP(2,1)*XL+RMATRIXMP(2,2)*YL+SHIFTMP(2)B C=================================================================@ C   (IXLM,IYLM) are the monitor dot coordinates which         ==@ C   correspond to the plot coordinates (XL,YL).               ==B C=================================================================@       IXLM=MAX(-BIG,MIN(BIG,XLM+SIGN(.5,XLM)))  !Alan Carruthers@       IYLM=MAX(-BIG,MIN(BIG,YLM+SIGN(.5,YLM)))  !Alan CarruthersB C=================================================================@ C   Check to see if (IXLM,IYLM) is on the monitor screen.     ==B C=================================================================3       IF(IXLM.LT.XMINMSIZE.OR.IXLM.GT.XMAXMSIZE.OR. 9      *   IYLM.LT.YMINMSIZE.OR.IYLM.GT.YMAXMSIZE)GO TO 125 B C=================================================================@ C   (IXLM,IYLM) is on the monitor screen. Load the crosshair  ==@ C   to location (IXLM,IYLM) on the screen.                    ==B C=================================================================@ C   Scale from VT640 to TX4010 values since VT640 is a TX4010 ==@ C   emulator.                                                 ==B C=================================================================       IXLM=IXLM*1024/640       IYLM=IYLM*780/480 B C=================================================================@ C   Calculate the four plot characters required to load the   ==@ C   crosshair to the TX4010 location: (IXLM,IYLM).            ==B C=================================================================       IYHI=32+IYLM/32        IYLO=96+MOD(IYLM,32)       IXHI=32+IXLM/32        IXLO=64+MOD(IXLM,32)B C=================================================================@ C   Load the crosshair at the TX4010 location: (IXLM,IYLM).   ==B C=================================================================H cc      WRITE(IOUTM,122)GS,IYHI,IYLO,IXHI,IXLO,ESC,'/','f',NULLS,ESC,SUBF       WRITE(IOUTM,122)NULLS,GS,IYHI,IYLO,IXHI,IXLO,ESC,'/','f',ESC,SUB 122   FORMAT('$',70A1)       GO TO 124 B C=================================================================@ C   (IXLM,IYLM) is off the monitor screen. Display the        ==@ C   crosshair on the screen at the same place it was last     ==@ C   positioned.                                               ==B C=================================================================4 125   WRITE(IOUTM,150)GS,ESC,'"',MODE,'e',ESC,SUB    C H C Enter Graphics, ...Crosshair mode, Read code and crosshair coordinates C  150   FORMAT('$',10A1)< 124   CODE = ICHAR(READ_KEY('NOESC LC2UC PURGE',' ',ALTKEY))' 	DO WHILE (CODE.EQ.CR .OR. CODE.EQ.ESC)  	    CALL BELL(1) 0 	    WRITE(IOUTM,150)GS,ESC,'"',MODE,'e',ESC,SUB; 	    CODE = ICHAR(READ_KEY('NOESC LC2UC PURGE',' ',ALTKEY))  	ENDDO 	DO IBYTER=1,48 	    IBYTE(IBYTER) = ICHAR(READ_KEY('NOESC',' ',ALTKEY)) 	ENDDO+ 	IDUMMY = ICHAR(READ_KEY(' ',' ',ALTKEY,0)) B C=================================================================@ C   Calculate the crosshair coordinates (IXM,IYM) for the     ==@ C   device.                                                   ==B C=================================================================$       IXM=(IBYTE(1)-I33)*32+IBYTE(2)$       IYM=(IBYTE(3)-I33)*32+IBYTE(4)       IXM=MAX(0,IXM)       IYM=MAX(0,IYM)       IXM=MIN(IXM,1023)        IYM=MIN(IYM,1023) B C=================================================================@ C   Scale from TX4010 to VT640 values since VT640 is a TX4010 ==@ C   emulator.                                                 ==B C=================================================================       IXM=IXM*640./1024.+.6        IYM=IYM*480./780.+.6B C=================================================================@ C   Determine the plot coordinates (X,Y) which correspond     ==@ C   to the crosshair monitor coordinates (IXM,IYM):           ==@ C                                                             ==@ C       |X|               |IXM|                               ==@ C       | | = RMATRIXPM * |   | + SHIFTPM                     ==@ C       |Y|               |IYM|                               ==B C=================================================================8       X=RMATRIXPM(1,1)*IXM+RMATRIXPM(1,2)*IYM+SHIFTPM(1)8       Y=RMATRIXPM(2,1)*IXM+RMATRIXPM(2,2)*IYM+SHIFTPM(2)       RETURN C 
 C***** TX4010  C B C=================================================================@ C   Determine the monitor coordinates (XLM,YLM) which         ==@ C   correspond to the plot coordinates (XL,YL):               ==@ C                                                             ==@ C       |XLM|               |XL|                              ==@ C       |   | = RMATRIXMP * |  | + SHIFTMP                    ==@ C       |YLM|               |YL|                              ==B C=================================================================8 200   XLM=RMATRIXMP(1,1)*XL+RMATRIXMP(1,2)*YL+SHIFTMP(1)8       YLM=RMATRIXMP(2,1)*XL+RMATRIXMP(2,2)*YL+SHIFTMP(2)B C=================================================================@ C   (IXLM,IYLM) are the monitor dot coordinates which         ==@ C   correspond to the plot coordinates (XL,YL).               ==B C=================================================================@       IXLM=MAX(-BIG,MIN(BIG,XLM+SIGN(.5,XLM)))  !Alan Carruthers@       IYLM=MAX(-BIG,MIN(BIG,YLM+SIGN(.5,YLM)))  !Alan CarruthersB C=================================================================@ C   Check to see if (IXLM,IYLM) is on the monitor screen.     ==B C=================================================================3       IF(IXLM.LT.XMINMSIZE.OR.IXLM.GT.XMAXMSIZE.OR. 9      *   IYLM.LT.YMINMSIZE.OR.IYLM.GT.YMAXMSIZE)GO TO 225 B C=================================================================@ C   (IXLM,IYLM) is on the monitor screen. Load the crosshair  ==@ C   to location (IXLM,IYLM) on the screen.                    ==B C=================================================================@ C   Calculate the four plot characters required to load the   ==@ C   crosshair to the TX4010 location: (IXLM,IYLM).            ==B C=================================================================       IYHI=32+IYLM/32        IYLO=96+MOD(IYLM,32)       IXHI=32+IXLM/32        IXLO=64+MOD(IXLM,32)B C=================================================================@ C   Load the crosshair at the TX4010 location: (IXLM,IYLM).   ==B C=================================================================@       WRITE(IOUTM,222)GS,IYHI,IYLO,IXHI,IXLO,ESC,'/','f',ESC,SUB 222   FORMAT('$',10A1)       GO TO 224 B C=================================================================@ C   (IXLM,IYLM) is off the monitor screen. Display the        ==@ C   crosshair on the screen at the same place it was last     ==@ C   positioned.                                               ==B C=================================================================4 225   WRITE(IOUTM,250)GS,ESC,'"',MODE,'e',ESC,SUB    C H C Enter Graphics, ...Crosshair mode, Read code and crosshair coordinates C  250   FORMAT('$',10A1)< 224   CODE = ICHAR(READ_KEY('NOESC LC2UC PURGE',' ',ALTKEY))' 	DO WHILE (CODE.EQ.CR .OR. CODE.EQ.ESC)  	    CALL BELL(1) 0 	    WRITE(IOUTM,250)GS,ESC,'"',MODE,'e',ESC,SUB; 	    CODE = ICHAR(READ_KEY('NOESC LC2UC PURGE',' ',ALTKEY))  	ENDDO 	DO IBYTER=1,48 	    IBYTE(IBYTER) = ICHAR(READ_KEY('NOESC',' ',ALTKEY)) 	ENDDO+ 	IDUMMY = ICHAR(READ_KEY(' ',' ',ALTKEY,0)) B C=================================================================@ C   Calculate the crosshair coordinates (IXM,IYM) for the     ==@ C   device.                                                   ==B C=================================================================$       IXM=(IBYTE(1)-I33)*32+IBYTE(2)$       IYM=(IBYTE(3)-I33)*32+IBYTE(4)       IXM=MAX(0,IXM)       IYM=MAX(0,IYM)       IXM=MIN(IXM,1023)        IYM=MIN(IYM,1023) B C=================================================================@ C   Determine the plot coordinates (X,Y) which correspond     ==@ C   to the crosshair monitor coordinates (IXM,IYM):           ==@ C                                                             ==@ C       |X|               |IXM|                               ==@ C       | | = RMATRIXPM * |   | + SHIFTPM                     ==@ C       |Y|               |IYM|                               ==B C=================================================================8       X=RMATRIXPM(1,1)*IXM+RMATRIXPM(1,2)*IYM+SHIFTPM(1)8       Y=RMATRIXPM(2,1)*IXM+RMATRIXPM(2,2)*IYM+SHIFTPM(2)       RETURN C 	 C*** VS11  C 8 C Note: IMONITOR = 3   On VS11 crosshairs are positioned6 C                      at their last location -- can'tC C                      yet pre-position crosshairs USING XL and YL.  C B C     Subroutine VSGETJOY allows positioning of crosshairs on VS11B C     using joystick, then returns monitor coordinates IXM and IYM0 C     once either button on joystick is pressed. C $ 300   CALL VSGETJOY(0,IXM,IYM,ISTAT)B C=================================================================@ C   Determine the plot coordinates (X,Y) which correspond     ==@ C   to the crosshair monitor coordinates (IXM,IYM):           ==@ C                                                             ==@ C       |X|               |IXM|                               ==@ C       | | = RMATRIXPM * |   | + SHIFTPM                     ==@ C       |Y|               |IYM|                               ==B C=================================================================8       X=RMATRIXPM(1,1)*IXM+RMATRIXPM(1,2)*IYM+SHIFTPM(1)8       Y=RMATRIXPM(2,1)*IXM+RMATRIXPM(2,2)*IYM+SHIFTPM(2)       RETURN C 	 C*** ZETA  Cy 400   RETURN Cg C*** HPe Ct 500   RETURN Ct C*** CIT-467 C B C=================================================================@ C   Determine the monitor coordinates (XLM,YLM) which         ==@ C   correspond to the plot coordinates (XL,YL):               ==@ C                                                             ==@ C       |XLM|               |XL|                              ==@ C       |   | = RMATRIXMP * |  | + SHIFTMP                    ==@ C       |YLM|               |YL|                              ==B C=================================================================8 600   XLM=RMATRIXMP(1,1)*XL+RMATRIXMP(1,2)*YL+SHIFTMP(1)8       YLM=RMATRIXMP(2,1)*XL+RMATRIXMP(2,2)*YL+SHIFTMP(2)B C=================================================================@ C   (IXLM,IYLM) are the monitor dot coordinates which         ==@ C   correspond to the plot coordinates (XL,YL).               ==B C=================================================================@       IXLM=MAX(-BIG,MIN(BIG,XLM+SIGN(.5,XLM)))  !Alan Carruthers@       IYLM=MAX(-BIG,MIN(BIG,YLM+SIGN(.5,YLM)))  !Alan CarruthersB C=================================================================@ C   Check to see if (IXLM,IYLM) is on the monitor screen.     ==B C=================================================================3       IF(IXLM.LT.XMINMSIZE.OR.IXLM.GT.XMAXMSIZE.OR.J9      *   IYLM.LT.YMINMSIZE.OR.IYLM.GT.YMAXMSIZE)GO TO 625TB C=================================================================@ C   (IXLM,IYLM) is on the monitor screen. Load the crosshair  ==@ C   to location (IXLM,IYLM) on the screen.                    ==B C=================================================================@ C   Scale from CIT-467 to TX4010  since CIT-467   is a TX4010 ==@ C   emulator.                                                 ==B C=================================================================2       IXLM=IXLM*1023.77/571.      ! SEE CIT467.FOR2       IYLM=IYLM*785.87/479.       ! SEE CIT467.FORB C=================================================================@ C   Calculate the four plot characters required to load the   ==@ C   crosshair to the TX4010 location: (IXLM,IYLM).            ==B C=================================================================       IYHI=32+IYLM/32r       IYLO=96+MOD(IYLM,32)       IXHI=32+IXLM/32        IXLO=64+MOD(IXLM,32)B C=================================================================@ C   Load the crosshair at the TX4010 location: (IXLM,IYLM).   ==B C=================================================================@       WRITE(IOUTM,622)GS,IYHI,IYLO,IXHI,IXLO,ESC,'/','f',ESC,SUB 622   FORMAT('$',10A1)       GO TO 624mB C=================================================================@ C   (IXLM,IYLM) is off the monitor screen. Display the        ==@ C   crosshair on the screen at the same place it was last     ==@ C   positioned.                                               ==B C=================================================================4 625   WRITE(IOUTM,650)GS,ESC,'"',MODE,'e',ESC,SUB    CcH C Enter Graphics, ...Crosshair mode, Read code and crosshair coordinates CF 650   FORMAT('$',10A1)< 624   CODE = ICHAR(READ_KEY('NOESC LC2UC PURGE',' ',ALTKEY))' 	DO WHILE (CODE.EQ.CR .OR. CODE.EQ.ESC)  	    CALL BELL(1)r0 	    WRITE(IOUTM,650)GS,ESC,'"',MODE,'e',ESC,SUB; 	    CODE = ICHAR(READ_KEY('NOESC LC2UC PURGE',' ',ALTKEY))n 	ENDDO 	DO IBYTER=1,48 	    IBYTE(IBYTER) = ICHAR(READ_KEY('NOESC',' ',ALTKEY)) 	ENDDO+ 	IDUMMY = ICHAR(READ_KEY(' ',' ',ALTKEY,0))uB C=================================================================@ C   Calculate the crosshair coordinates (IXM,IYM) for the     ==@ C   device.                                                   ==B C=================================================================$       IXM=(IBYTE(1)-I33)*32+IBYTE(2)$       IYM=(IBYTE(3)-I33)*32+IBYTE(4)       IXM=MAX(0,IXM)       IYM=MAX(0,IYM)       IXM=MIN(IXM,1023)        IYM=MIN(IYM,1023) B C=================================================================@ C   Scale from TX4010 to CIT-467 since CIT-467    is a TX4010 ==@ C   emulator.                                                 ==B C=================================================================@       IXM=IXM*571./1023.77+.6        ! DONT ASK WHY THIS WORKS !?       IYM=IYM*479./786.11+.6         ! SEE CIT467.FOR FOR TESTS B C=================================================================@ C   Determine the plot coordinates (X,Y) which correspond     ==@ C   to the crosshair monitor coordinates (IXM,IYM):           ==@ C                                                             ==@ C       |X|               |IXM|                               ==@ C       | | = RMATRIXPM * |   | + SHIFTPM                     ==@ C       |Y|               |IYM|                               ==B C=================================================================8       X=RMATRIXPM(1,1)*IXM+RMATRIXPM(1,2)*IYM+SHIFTPM(1)8       Y=RMATRIXPM(2,1)*IXM+RMATRIXPM(2,2)*IYM+SHIFTPM(2)       RETURN C  C*** TEK4107 C B C=================================================================@ C   Determine the monitor coordinates (XLM,YLM) which         ==@ C   correspond to the plot coordinates (XL,YL):               ==@ C                                                             ==@ C       |XLM|               |XL|                              ==@ C       |   | = RMATRIXMP * |  | + SHIFTMP                    ==@ C       |YLM|               |YL|                              ==B C=================================================================8 700   XLM=RMATRIXMP(1,1)*XL+RMATRIXMP(1,2)*YL+SHIFTMP(1)8       YLM=RMATRIXMP(2,1)*XL+RMATRIXMP(2,2)*YL+SHIFTMP(2)B C=================================================================@ C   (IXLM,IYLM) are the monitor dot coordinates which         ==@ C   correspond to the plot coordinates (XL,YL).               ==B C=================================================================@       IXLM=MAX(-BIG,MIN(BIG,XLM+SIGN(.5,XLM)))  !Alan Carruthers@       IYLM=MAX(-BIG,MIN(BIG,YLM+SIGN(.5,YLM)))  !Alan CarruthersB C=================================================================@ C   Check to see if (IXLM,IYLM) is on the monitor screen.     ==B C=================================================================3       IF(IXLM.LT.XMINMSIZE.OR.IXLM.GT.XMAXMSIZE.OR. 9      *   IYLM.LT.YMINMSIZE.OR.IYLM.GT.YMAXMSIZE)GO TO 725MB C=================================================================@ C   (IXLM,IYLM) is on the monitor screen. Load the crosshair  ==@ C   to location (IXLM,IYLM) on the screen.                    ==B C=================================================================@ C   Scale from VT640 to TX4010 values since VT640 is a TX4010 ==@ C   emulator.                                                 ==B C=================================================================G       IXLM=IXLM*1023.8/639.+0.12707355      ! DONT ASK WHY THIS WORKS !=F       IYLM=IYLM*782.515/479.+0.127943215031 ! SEE TK4107.FOR FOR TESTSB C=================================================================@ C   Calculate the four plot characters required to load the   ==@ C   crosshair to the TX4010 location: (IXLM,IYLM).            ==B C=================================================================       IYHI=32+IYLM/32        IYLO=96+MOD(IYLM,32)       IXHI=32+IXLM/32        IXLO=64+MOD(IXLM,32)B C=================================================================@ C   Load the crosshair at the TX4010 location: (IXLM,IYLM).   ==B C=================================================================       WRITE(IOUTM,722)F      #           ESC,'%!',0,GS,IYHI,IYLO,IXHI,IXLO,ESC,'/','f',ESC,SUB 722   FORMAT('$',A1,A2,I1,10A1)e       GO TO 724aB C=================================================================@ C   (IXLM,IYLM) is off the monitor screen. Display the        ==@ C   crosshair on the screen at the same place it was last     ==@ C   positioned.                                               ==B C=================================================================? 725   WRITE(IOUTM,722)ESC,'%!',0,GS,ESC,'"',MODE,'e',ESC,SUB   = C=H C Enter Graphics, ...Crosshair mode, Read code and crosshair coordinates CY 750   FORMAT('$',10A1)< 724   CODE = ICHAR(READ_KEY('NOESC LC2UC PURGE',' ',ALTKEY))' 	DO WHILE (CODE.EQ.CR .OR. CODE.EQ.ESC)= 	    CALL BELL(1)=; 	    WRITE(IOUTM,722)ESC,'%!',0,GS,ESC,'"',MODE,'e',ESC,SUBI; 	    CODE = ICHAR(READ_KEY('NOESC LC2UC PURGE',' ',ALTKEY))= 	ENDDO 	DO IBYTER=1,48 	    IBYTE(IBYTER) = ICHAR(READ_KEY('NOESC',' ',ALTKEY)) 	ENDDO+ 	IDUMMY = ICHAR(READ_KEY(' ',' ',ALTKEY,0))HB C=================================================================@ C   Calculate the crosshair coordinates (IXM,IYM) for the     ==@ C   device.                                                   ==B C=================================================================$       IXM=(IBYTE(1)-I33)*32+IBYTE(2)$       IYM=(IBYTE(3)-I33)*32+IBYTE(4)       IXM=MAX(0,IXM)       IYM=MAX(0,IYM)       IXM=MIN(IXM,1023)T       IYM=MIN(IYM,1023)DB C=================================================================@ C   Scale from TX4010 to VT640 values since VT640 is a TX4010 ==@ C   emulator.                                                 ==B C=================================================================?       IXM=IXM*(639./1023.8)+.65   ! DONT ASK WHY IT JUST WORKS.C>       IYM=IYM*(479./783.2)+0.92   ! SEE TK4107.FOR FOR TESTINGB C=================================================================@ C   Determine the plot coordinates (X,Y) which correspond     ==@ C   to the crosshair monitor coordinates (IXM,IYM):           ==@ C                                                             ==@ C       |X|               |IXM|                               ==@ C       | | = RMATRIXPM * |   | + SHIFTPM                     ==@ C       |Y|               |IYM|                               ==B C=================================================================8       X=RMATRIXPM(1,1)*IXM+RMATRIXPM(1,2)*IYM+SHIFTPM(1)8       Y=RMATRIXPM(2,1)*IXM+RMATRIXPM(2,2)*IYM+SHIFTPM(2)        WRITE(IOUTM,760)ESC,'ID',0 760   FORMAT('$',A1,A2,I1)       RETURN C  C VT241  C=B C=================================================================@ C   Determine the monitor coordinates (XLM,YLM) which         ==@ C   correspond to the plot coordinates (XL,YL):               ==@ C                                                             ==@ C       |XLM|               |XL|                              ==@ C       |   | = RMATRIXMP * |  | + SHIFTMP                    ==@ C       |YLM|               |YL|                              ==B C================================================================= 800   CALL REGIS_MODE  C 8       XLM=RMATRIXMP(1,1)*XL+RMATRIXMP(1,2)*YL+SHIFTMP(1)8       YLM=RMATRIXMP(2,1)*XL+RMATRIXMP(2,2)*YL+SHIFTMP(2)B C=================================================================@ C   (IXLM,IYLM) are the monitor dot coordinates which         ==@ C   correspond to the plot coordinates (XL,YL).               ==B C=================================================================2       XLM=MAX(-BIG,MIN(BIG,XLM))  !Alan Carruthers2       YLM=MAX(-BIG,MIN(BIG,YLM))  !Alan Carruthers       IXLM=NINT(XLM)       IYLM=NINT(YLM)B C=================================================================@ C   Check to see if (IXLM,IYLM) is on the monitor screen.     ==B C=================================================================3       IF(IXLM.LT.XMINMSIZE.OR.IXLM.GT.XMAXMSIZE.OR.L9      *   IYLM.LT.YMINMSIZE.OR.IYLM.GT.YMAXMSIZE)GO TO 825=B C=================================================================@ C   (IXLM,IYLM) is on the monitor screen. Load the crosshair  ==@ C   to location (IXLM,IYLM) on the screen.                    ==B C=================================================================       IYLM=ABS(IYLM-479)B C=================================================================@ C   Load the crosshair at the VT241  location: (IXLM,IYLM).   ==B C=================================================================3       WRITE(IOUTM,822)'P[',IXLM,',',IYLM,']R(P(I))'s! 822   FORMAT(1X,A,I3.3,A1,I3.3,A)=       GO TO 824= C=J C Enter Graphics ...Crosshair mode.. Read code and cross-hair coordinates. C.  825    WRITE(IOUTM,850)'R(P(I))' 850    FORMAT(1X,A)M> C824    CODE = ICHAR(READ_KEY('NOESC LC2UC PURGE',' ',ALTKEY))7 824    CODE = ICHAR(READ_KEY('NOESC LC2UC',' ',ALTKEY)) ( C	DO WHILE (CODE.EQ.CR .OR. CODE.EQ.ESC) C	    CALL BELL(1) C	    WRITE(IOUTM,850)'R(P(I))'=< C	    CODE = ICHAR(READ_KEY('NOESC LC2UC PURGE',' ',ALTKEY)) C	ENDDO 5         I241(1) = ICHAR(READ_KEY('NOESC',' ',ALTKEY))h         I241R=1h 	DO WHILE (I241(I241R) .NE. CR),             I241R=I241R+1=6 	    I241(I241R) = ICHAR(READ_KEY('NOESC',' ',ALTKEY)) 	ENDDO5         WRITE(IOUTM,852)ESC,'\'     ! Exit Regis Mode   852    FORMAT(1X,A1,A)X         I241R=I241R-1= C=& C  INTERPRET STRING I241 AS P[xxx,yyy]+ C  Extract xxx  ---> IXM  ,   yyy ----> IYM  C        IYM=0oA       I=I241R-1                                  !Start at last y=	       J=0=        DO WHILE (I241(I).NE. ',')        IYM=IYM+(I241(I)-48)*10**J       I=I-1        J=J+1A       ENDDOTA       I=I-1                                     ! Start at last x=       IXM=0I	       J=0s!       DO WHILE (I241(I) .NE. '[')e        IXM=IXM+(I241(I)-48)*10**J       I=I-1s       J=J+1w       ENDDO=       IYM=ABS(479-IYM)B C=================================================================@ C   Determine the plot coordinates (X,Y) which correspond     ==@ C   to the crosshair monitor coordinates (IXM,IYM):           ==@ C                                                             ==@ C       |X|               |IXM|                               ==@ C       | | = RMATRIXPM * |   | + SHIFTPM                     ==@ C       |Y|               |IYM|                               ==B C=================================================================8       X=RMATRIXPM(1,1)*IXM+RMATRIXPM(1,2)*IYM+SHIFTPM(1)8       Y=RMATRIXPM(2,1)*IXM+RMATRIXPM(2,2)*IYM+SHIFTPM(2)       RETURN C= C*** SEIKO GR-1105 *** C=B C=================================================================@ C   Determine the monitor coordinates (XLM,YLM) which         ==@ C   correspond to the plot coordinates (XL,YL):               ==@ C                                                             ==@ C       |XLM|               |XL|                              ==@ C       |   | = RMATRIXMP * |  | + SHIFTMP                    ==@ C       |YLM|               |YL|                              ==B C=================================================================8 900   XLM=RMATRIXMP(1,1)*XL+RMATRIXMP(1,2)*YL+SHIFTMP(1)8       YLM=RMATRIXMP(2,1)*XL+RMATRIXMP(2,2)*YL+SHIFTMP(2)B C=================================================================@ C   (IXLM,IYLM) are the monitor dot coordinates which         ==@ C   correspond to the plot coordinates (XL,YL).               ==B C=================================================================@       IXLM=MAX(-BIG,MIN(BIG,XLM+SIGN(.5,XLM)))  !Alan Carruthers@       IYLM=MAX(-BIG,MIN(BIG,YLM+SIGN(.5,YLM)))  !Alan Carruthers C B C=================================================================@ C   Check to see if (IXLM,IYLM) is on the monitor screen.     ==B C=================================================================3       IF(IXLM.LT.XMINMSIZE.OR.IXLM.GT.XMAXMSIZE.OR. 9      *   IYLM.LT.YMINMSIZE.OR.IYLM.GT.YMAXMSIZE)GO TO 925tB C=================================================================@ C   (IXLM,IYLM) is on the monitor screen. Load the crosshair  ==@ C   to location (IXLM,IYLM) on the screen.                    ==B C=================================================================! C Convert to 15-bit ASCII format:)        IXLOB=IBITS(IXLM,0,5) + 32        IXMOB=IBITS(IXLM,5,5) + 64!       IXHOB=IBITS(IXLM,10,5) + 96         IYLOB=IBITS(IYLM,0,5) + 32        IYMOB=IBITS(IYLM,5,5) + 64!       IYHOB=IBITS(IYLM,10,5) + 96 @       WRITE(IOUTM,922)ESC,'K',' ',ESC,'c','B',IXHOB,IXMOB,IXLOB,G      #                                        IYHOB,IYMOB,IYLOB,' ',ESC  922   FORMAT(1X,20A1)I CR C Query crosshair position: ( 925   WRITE(IOUTM,960)ESC,'K ',ESC,'rA!' 960   FORMAT(1X,A1,A2,A1,A3) C  C Read the response:6       IDUMMY=ICHAR(READ_KEY('NOESC PURGE',' ',ALTKEY))0       IDUMMY=ICHAR(READ_KEY('NOESC',' ',ALTKEY))0       IDUMMY=ICHAR(READ_KEY('NOESC',' ',ALTKEY))6       IXHOB = ICHAR(READ_KEY('NOESC',' ',ALTKEY)) - 326       IXMOB = ICHAR(READ_KEY('NOESC',' ',ALTKEY)) - 326       IXLOB = ICHAR(READ_KEY('NOESC',' ',ALTKEY)) - 326       IYHOB = ICHAR(READ_KEY('NOESC',' ',ALTKEY)) - 326       IYMOB = ICHAR(READ_KEY('NOESC',' ',ALTKEY)) - 326       IYLOB = ICHAR(READ_KEY('NOESC',' ',ALTKEY)) - 32/       HEXBUFF(1:1)=READ_KEY('NOESC',' ',ALTKEY)=/       HEXBUFF(2:2)=READ_KEY('NOESC',' ',ALTKEY)=.       IDUMMY = ICHAR(READ_KEY(' ',' ',ALTKEY)) C Get key code:        READ(HEXBUFF,970)CODEM 970   FORMAT(Z2) C B C=================================================================@ C   Calculate the crosshair coordinates (IXM,IYM) for the     ==@ C   device.                                                   ==B C=================================================================#       CALL MVBITS(IXLOB,0,5,IXM2,0).#       CALL MVBITS(IXMOB,0,5,IXM2,5)M$       CALL MVBITS(IXHOB,0,5,IXM2,10)>       CALL MVBITS(IXM2,14,1,IXM2,15)      !set bit 15 = bit 14#       CALL MVBITS(IYLOB,0,5,IYM2,0)e#       CALL MVBITS(IYMOB,0,5,IYM2,5)e$       CALL MVBITS(IYHOB,0,5,IYM2,10)>       CALL MVBITS(IYM2,14,1,IYM2,15)      !set bit 15 = bit 14       IXM=IXM2       IYM=IYM2 C B C=================================================================@ C   Determine the plot coordinates (X,Y) which correspond     ==@ C   to the crosshair monitor coordinates (IXM,IYM):           ==@ C                                                             ==@ C       |X|               |IXM|                               ==@ C       | | = RMATRIXPM * |   | + SHIFTPM                     ==@ C       |Y|               |IYM|                               ==B C=================================================================8       X=RMATRIXPM(1,1)*IXM+RMATRIXPM(1,2)*IYM+SHIFTPM(1)8       Y=RMATRIXPM(2,1)*IXM+RMATRIXPM(2,2)*IYM+SHIFTPM(2)       RETURN  B C================================================================= C  IMONITOR=15:  VaxStation B C=================================================================B C=================================================================@ C   Determine the monitor coordinates (XLM,YLM) which         ==@ C   correspond to the plot coordinates (XL,YL):               ==@ C                                                             ==@ C       |XLM|               |XL|                              ==@ C       |   | = RMATRIXMP * |  | + SHIFTMP                    ==@ C       |YLM|               |YL|                              ==B C=================================================================8 1000  XLM=RMATRIXMP(1,1)*XL+RMATRIXMP(1,2)*YL+SHIFTMP(1)8       YLM=RMATRIXMP(2,1)*XL+RMATRIXMP(2,2)*YL+SHIFTMP(2),       CALL VST_CROSSHAIR(XM,YM,CODE,XLM,YLM)B C=================================================================@ C   Determine the plot coordinates (X,Y) which correspond     ==@ C   to the crosshair monitor coordinates (IXM,IYM):           ==@ C                                                             ==@ C       |X|               |IXM|                               ==@ C       | | = RMATRIXPM * |   | + SHIFTPM                     ==@ C       |Y|               |IYM|                               ==B C=================================================================6       X=RMATRIXPM(1,1)*XM+RMATRIXPM(1,2)*YM+SHIFTPM(1)6       Y=RMATRIXPM(2,1)*XM+RMATRIXPM(2,2)*YM+SHIFTPM(2)       RETURN  	       END=