&       SUBROUTINE CUMSUM(XIN,NPTS,XOUT)H C***********************************************************************H C                                                                      *H C    Reqd. Routines - NONE                                             *H C                                                                      *H C    This routine calculates the cumulative sum of an input array,     *H C    XIN, with NPTS number of elements, and puts these sums into       *H C    the output array XOUT (which will also have NPTS points).         *H C                                                                      *H C    Input:   XIN    -    REAL*4       input array                     *H C             NPTS   -    INTEGER*4    number of points in XIN         *H C                                                                      *H C    Output:  XOUT   -    REAL*4       output array                    *H C                                                                      *H C    Example:                                                          *H C             Suppose that XIN = {1,2,3,4,5}                           *H C             CALL CUMSUM(XIN,5,XOUT)                                  *H C             Then XOUT = {1,3,6,10,15}                                *H C                                                                      *H C                                        Author:   Joe Chuma           *H C                                                  May 23, 1984        *H C                                                                      *H C***********************************************************************       REAL*4  XIN(1), XOUT(1)        XSUM = 0.0       DO I = 1, NPTS         XSUM    = XSUM + XIN(I)          XOUT(I) = XSUM       END DO       RETURN	       END 