"       SUBROUTINE DEL_ARRAY(IOFF,*)G C**********************************************************************  C B C  DEL_ARRAY:  Deallocates a block of virtual memory THAT HAD BEENA C              ALLOCATED PREVIOUSLY WITH ROUTINE GET_ARRAY.  When E C              GET_ARRAY is called successfully, it records the array B C              in the Master Table (the size and virtual address).@ C              This information is necessary to later delete the C              array.  C 	 C  INPUT:  C A C  IOFF:       The offset from the base address that was returned  C              by GETSPACE.  C  C  ERROR RETURNS:  C . C  RETURN1:    IOFF is not in Master Table  OR5 C              Bad address (according to LIB$FREE_VM)  C : C  Descriptive messages are printed out for error returns. C G C**********************************************************************        COMMON /X$/ R$8 A       COMMON /TABLE$/ MAXTABLE,NTABLE,IEXIST,IVEC,IADDRESS,IBYTES        LOGICAL*1 L$1(1)       INTEGER I$4(1)       REAL*8 R$8(1) (       EQUIVALENCE (I$4(1),L$1(1),R$8(1))G C********************************************************************** / C  Check Master Table to see if IOFF is entered D C  (Do not look at the "holes"; indicated by a .FALSE. value for the C  flag of this slot).G C**********************************************************************        DO 100 I=1,NTABLE 	       K=I &       IF(.NOT.(L$1(IEXIST+I)))GOTO 100%       IF(IOFF.EQ.I$4(IVEC+I))GOTO 200  100   CONTINUE, C********************** Can't find the entry       WRITE(6,150)C 150   FORMAT('0*** Error in DEL_ARRAY: this array is not recorded') 
       RETURN1 7 C********************** Found the entry; free the space  200   NADDR=I$4(IADDRESS+K)        NBYTES=I$4(IBYTES+K)(       CALL FREE_SPACE(NBYTES,NADDR,&900)G C********************************************************************** D C  Empty this entry slot in the Master Table by setting the flag for C  this slot to .FALSE. G C**********************************************************************        L$1(IEXIST+K)=.FALSE.        RETURN
 900   RETURN1 	       END 