? C    >========================================================< : C	>------------------------------------------------------<D C------>  DOPL3D  package for VAX VMS Interactive Graphics  <-------: C	>------------------------------------------------------<? C    >========================================================<  C : C	 3-D version under development, Feb. 1982 -- Jess Brewer C  C  C D C==================== P R O T O C A L L S : =======================< C  C...CALL DOPLOT_3D6 C   or   DOPL3D...to make an Interactive Graphics plot- C			of points loaded in via DO3DPT and DO3DCH  C			(see below).   C D C------------------------------------------------------------------< C   C...CALL DOPLOT_3D_POINT (X,Y,Z)C C   or   DO3DPT (X,Y,Z)...to plot a POINT (X,Y,Z).  (REAL*4 X,Y,Z). + C				  "points" in succession come out as a  C				  connected line. C # C...CALL DOPLOT_3D_CHAR (X,Y,Z,ICH) C C   or   DO3DCH (X,Y,Z,ICH)...to plot the CHARACTER loaded into the + C					first byte of INTEGER*4 variable ICH. & C					For ICH < 41, plot SYMBOL number C					ICH1 = MOD(ICH,20). , C					For ICH < 0, an isolated dot is drawn. C A C   or   DO3DCH (X,Y,Z,'+')...to plot a '+' symbol.  (And so on.) @ C   or   DO3DCH (X,Y,Z,RAD).....to plot a SPHERE of radius RAD.  C A C................................................................  C  C...CALL DOPLOT_3D_MAX (MAXPT)A C   or   DO3DMX (MAXPT)...to change the max # of points plottable  C				  (default is 4000). 7 C			Note!...COMMON blocks /DO3DTX/, /DO3DTY/, /DO3DTZ/, 1 C				  /DO3DTL/, /DO3DBH/, /DO3DBV/ and /DO3DBD/   C				  (see below)  M U S T , C				  be Redimensioned Externally if you do C				  change  MAXPT.  C ; C...CALL DOPLOT_3D_LIMITS (XMIN,XMAX, YMIN,YMAX, ZMIN,ZMAX) 4 C   or   SET3DL (XMIN,XMAX, YMIN,YMAX, ZMIN,ZMAX)... C							 to fix (X,Y,Z) LIMITS C							 externally.  Otherwise ! C							 data scanned for limits.  C % C...CALL DOPLOT_3D_XLABEL (NLBX,LABX) A C   or   XLAB (NLBX,LABX)...to LABEL the HORIZONTAL axis with the , C				    NLBX char. in INTEGER*4 array LABX. C % C...CALL DOPLOT_3D_YLABEL (NLBY,LABY) @ C   or   YLAB (NLBY,LABY)...to LABEL the INTO-PAGE axis with the, C				    NLBY char. in INTEGER*4 array LABY. C % C...CALL DOPLOT_3D_ZLABEL (NLBZ,LABZ) ? C   or   ZLAB (NLBZ,LABZ)...to LABEL the VERTICAL axis with the , C				    NLBY char. in INTEGER*4 array LABY. C & C...CALL DOPLOT_3D_TITLE (NTTL,LBLTTL)? C   or   TITL3D (NTTL,LBLTTL)...to TITLE the plot with the NTTL ( C					  char. in INTEGER*4 array LBLTTL. C 8 C...String Size Limits: max(NLBX,Y,Z)=40, max(NTTL)=100. C  C...CALL DOPLOT_3D_BOX (IFBOX)4 C   or   DOBOX (IFBOX)...to turn on (IFBOX = .TRUE.)" C				     or off (IFBOX = .FALSE.)0 C				 the drawing of a 3-D Box with axis labels. C + C...CALL DOPLOT_3D_AXES (IFXAX,IFYAX,IFZAX) > C   or   DOAX3D (IFXAX,IFYAX,IFZAX)...to turn X-, Y- or X-AXIS C						  PLOTTING	 on  C						 (IF?AX = .TRUE.) C					or off (IF?AX = .FALSE.) C & C...CALL DOPLOT_3D_SIZE (XINCH, ZINCH)B C   or   DIM3D (XINCH, ZINCH)...to set Cal-Comp plot DIMENSIONS to( C					  other than default (7.0 by 5.0).( C					--NOTE: Maximum vertical plot size! C					  for Small paper is 11.0". ( C					  Large plotter will automatically  C					  be used for larger plots C					  (up to 30.0"). C - C...CALL DOPLOT_3D_VIEW (PTHETA, PPHI, PDIST) 7 C   or   PERSP (PTHETA, PPHI, PDIST)...set polar angles ) C		    defining the "viewpoint direction" 1 C		    relative to the (X,Y,Z) coordinate system.  C  C ' C					    Also set PDIST = the distance * C					    (in "virtual inches") from which) C					    the centre of the picture is to + C					    seem viewed.  Set PDIST = 0.0 for   C					    perspective-free view. C  C , C...CALL DOPLOT_3D_CHAR_SIZE (CHLBL, CHPLOT)D C   or   CHSZ3D (CHLBL, CHPLOT)...to set Cal-Comp CHARACTER SIZES to* C					    other than default (.28" Labels,  C					    .07" plotted Symbols.) C  C  C...Main Entry Point: * C========================================< 	SUBROUTINE DO3DCH (X, Y, Z, L) * C========================================< 	COMMON /DO3DTX/ XSET(4000)  	COMMON /DO3DTY/ YSET(4000)  	COMMON /DO3DTZ/ ZSET(4000)  	COMMON /DO3DTL/ LSET(4000)  	COMMON /DO3DBH/ HOR(4000) 	COMMON /DO3DBV/ VER(4000) 	COMMON /DO3DBD/ DIST(4000)  C ! 	COMMON /DEVICE2_TYPE/ I_PLOT_DEV  C % 	REAL*4 GAPL(100), GAPR(100), ARGS(4) # 	COMMON /PRSP3D/ PLDIST, ROTAT(3,3)  	REAL*4 ROT1(3,3), ROT2(3,3)- 	COMMON /ORIGIN/ HOVER, VUP, XWID, YWID, ZHGT - 	INTEGER LABX(25),LABY(10),LABZ(10),NTITL(25) * 	LOGICAL*1 LINX(1),LINY(1),LINZ(1),LINT(1)1 	LOGICAL*1 XLB(100), YLB(40), ZLB(40), TITLE(100)  	EQUIVALENCE (LABX(1),XLB(1))  	EQUIVALENCE (LABY(1),YLB(1))  	EQUIVALENCE (LABZ(1),ZLB(1))   	EQUIVALENCE (NTITL(1),TITLE(1))4 	INTEGER NEWLX(25), NEWLY(10), NEWLZ(10), NEWTTL(25)8 	LOGICAL*1 LEWLX(100), LEWLY(40), LEWLZ(40), LEWTTL(100)  	EQUIVALENCE (NEWLX(1),LEWLX(1))  	EQUIVALENCE (NEWLY(1),LEWLY(1))  	EQUIVALENCE (NEWLZ(1),LEWLZ(1))" 	EQUIVALENCE (NEWTTL(1),LEWTTL(1)) 	DIMENSION HSPH(33), VSPH(33)  	LOGICAL*1 LOGL(4) 	INTEGER*2 I2LL(2)4 	EQUIVALENCE (LL, LOGL(1)), (LL,I2LL(1)), (LL, RSPH) 	DIMENSION NAME(25)  	LOGICAL*1 DUM(100)  	EQUIVALENCE (NAME(1),DUM(1))  	LOGICAL ASK_IF 7 	LOGICAL XAXIS, YAXIS, ZAXIS, IFXAX, IFYAX, IFZAX, SAVE ? 	LOGICAL BOX3D, IFBOX, STEREO, NEW_CALL, NO_CHANGE, HIDE, SPHLS  	LOGICAL ADD_LINE, ADD_CHAR  	LOGICAL*1 CHAR  	REAL*8 CMD(27) J C---------------- D A T A   Statements: ---------------------------------< 	DATA NCMD /27/ B 	DATA CMD /'        ','X LIMITS','Y LIMITS','Z LIMITS','AXES    ',?      >		'VIEW    ','DISTANCE','EXIT    ','MARGINS ','WIDTH   ', ?      >		'HEIGHT  ','CHARSIZE','POINTSIZ','FONT    ','PRINT_PL', ?      >		'PEN_PLOT','TITLE   ','LABELS  ','TEXT    ','CAPTION ', ?      >		'BOX     ','KEEP    ','STEREO  ','HIDE    ','PENTYPE ',       >		'ADD     ','DEVICE  '/ 	DATA RADIAN /57.29578/ 0 	DATA XMIN/0.0/, XMAX/0.0/, YMIN/0.0/, YMAX/0.0/ 	DATA ZMIN/0.0/, ZMAX/0.0/4 	DATA XAXIS /.TRUE./, YAXIS /.TRUE./, ZAXIS /.TRUE./6 	DATA BOX3D /.TRUE./, SAVE /.FALSE./, STEREO /.FALSE./ 	DATA HIDE /.FALSE./. 	DATA PTHETA /70.0/, PPHI /-25.0/, PDIST /0.0/ 	DATA WIDTH /4.0/, HEIGHT /4.0/ , 	DATA HCCOVR /0.0/, VCCUP /0.0/, VCCDN /0.0/ 	DATA NLBX/0/, NLBY/0/, NTTL/0/  	DATA SEPAR /3.0/  	DATA MAXSIG /9/, MINSIG /4/% 	DATA CHSIZ /0.125/, PLCHSZ /0.06667/   	DATA VCCMAX /7.0/, HCCMAX /9.0/ 	DATA FXTRIG /0.01/ & 	DATA HUGE /0.12345E10/, TINY /1.0E-4/* 	DATA NPT /0/, MAXPT /4000/, MAXLSG /4000/) 	DATA IFSTIM /1/, LFPLPX /9/, LFZETA /88/ K C========================================================================== " 	ENTRY DOPLOT_3D_CHAR (X, Y, Z, L) C  	IF (NPT .GE. MAXPT) RETURN  	LSET(NPT+1) = L 	GO TO 2, C------------------------------------------< 	ENTRY DO3DPT (X, Y, Z)   	ENTRY DOPLOT_3D_POINT (X, Y, Z) C  	IF (NPT .GE. MAXPT) RETURN  	LSET(NPT+1) = '    '  C     2	NPT = NPT + 1 	XSET(NPT) = X 	YSET(NPT) = Y 	ZSET(NPT) = Z 	RETURN  C--------------------------< 	ENTRY DOPL3D  	ENTRY DOPLOT_3D C  	IF (IFSTIM .EQ. 1) C      > CALL PLOT_DEVICE2 (1, 6, LFZETA)	! No Zeta unless requested!  	NEW_CALL = .TRUE. 	NO_CHANGE = .FALSE. C  Check for less than 2 points:  	IF (NPT .GE. 2) GO TO 1231  	WRITE (*,1111) NPT 3  1111	FORMAT (///,' ***** DOPL3D called with only', @      >   I3,'  point(s).   Not worth plotting.  Points are:',//) 	IF (NPT .GT. 0) WRITE (*,1112) -      >		    (XSET(I),YSET(I),ZSET(I),I=1,NPT)   1112	FORMAT (20X,'X = ',G14.7, ,      >	 ',    Y = ',G14.7,',    Z = ',G14.7) C  	RETURN = C-----------------------------------------------------------<   1231	CALL LOC_C_TRAP (&1232)  	GO TO 1234   1232	WRITE (*,1233)*  1233	FORMAT (/,10X,'*** Interrupt ***',/) 	GO TO 1231  C , C...Interactive Options for replotting etc.: C   1234	CALL TRANSPARENT_MODE(0) C 4 	CALL CLI ('DOPL3D>', NCMD, -8, CMD, JCMD, 4, ARGS, -      >			'jess$util:USERS.HLB ', '3D_DOPL3D')  C . 	IF (JCMD .EQ. 1  .AND.  NO_CHANGE) GO TO 9900; 	IF (JCMD .NE. 14  .AND.  JCMD .NE. 15) NO_CHANGE = .FALSE.  C + 	GO TO (2345,2000,3000,3500,4000,5800,5850, 6      >	  9900,5900,6000,7000,8000,9000,3450,3670,3675,6      >	  4560,5670,6780,7890,7980,1100,1200,8642,3580,      >	  9200,3570),  JCMD C 1 C..............(ok) XLIM YLIM ZLIM AXES VIEW DIST 0 C	  EXIT MARG WIDE HIGH CHSZ PTSZ FONT PXPL ZETA0 C	  TITL LABL TEXT CAPT BOX  KEEP STER HIDE PEN  C	  ADD  DEVH C-----------------------------------------------------------------------/ C...KEEP (Do not empty Display Buffer on Exit):  C 1  1100	SAVE = ASK_IF ('Preserve Buffer on Exit? ')  	GO TO 1234  C : C...STER (Display Stereoscopic Views of the same picture.) C .  1200	STEREO = ASK_IF ('Stereoscopic views? ') 	IF (.NOT. STEREO) GO TO 1234  C  	SEP = AMAX1(3.0, 1.5*WIDTH) C   1202	WRITE (*,1212) SEP, SEPAR <  1212	FORMAT (' An aesthetic separation of images might be',6      >	  F8.2,'"',/,'   Separation is now',F8.2,'"',$)' 	CALL ASK ('+   Replacement? ', 'R',CX)  	IF (CX .GT. 0.0) SEPAR = CX 	IF (SEPAR .LT. 3.0) GO TO 1202  C  	GO TO 1234  C  C...XLIM (set XMIN, XMAX): C   2000	XMIN = ARGS(1) 	XMAX = ARGS(2)  	WRITE (*,2222) XMIN, XMAX%  2222	FORMAT (' X Limits now',2G12.4)  	GO TO 1234  C  C...YLIM (set YMIN, YMAX): C   3000	YMIN = ARGS(1) 	YMAX = ARGS(2)  	WRITE (*,3333) YMIN, YMAX%  3333	FORMAT (' Y Limits now',2G12.4)  	GO TO 1234  C  C...ZLIM (set ZMIN, ZMAX): C   3500	ZMIN = ARGS(1) 	ZMAX = ARGS(2)  	WRITE (*,353) ZMIN, ZMAX %   353	FORMAT (' Z Limits now',2G12.4)  	GO TO 1234  C ( C...AXES (Enable/Disable Axis plotting): C &  4000	XAXIS = ASK_IF ('Plot X-axis? ')! 	YAXIS = ASK_IF ('Plot Y-axis? ') ! 	ZAXIS = ASK_IF ('Plot Z-axis? ')  	GO TO 1234  C % C...VIEW (Set Perspective Viewpoint):= C=,  5800	IF (ARGS(1) .NE. 0.0) PTHETA = ARGS(1)% 	IF (ARGS(2) .NE. 0.0) PPHI = ARGS(2)  	WRITE (*,585) PTHETA, PPHI ?   585	FORMAT (' "Viewpoint" polar angles are now',2F9.2,' deg')- 	GO TO 1234- C-$ C...DIST (Set Perspective Distance): C=6  5850	IF (ARGS(1) .NE. 0.0) PDIST = AMAX1(0.0,ARGS(1)) 	WRITE (*,586) PDIST7   586	FORMAT (' Perspective Distance is now ',F9.2,'"')= 	GO TO 1234  C $ C...MARG (Set left & lower Margins.) CA,  5900	IF (ARGS(1) .NE. 0.0) HCCOVR = ARGS(1)& 	IF (ARGS(2) .NE. 0.0) VCCUP = ARGS(2) 	WRITE (*,5911) HCCOVR, VCCUP 0  5911	FORMAT (' Left & Lower Margins are now (',      >		F6.3,'",',F7.3,'").')- 	GO TO 1234  C. C...WIDE (set Width of plot):  C +  6000	IF (ARGS(1) .GT. 0.0) WIDTH = ARGS(1). 	WRITE (*,666) WIDTH)   666	FORMAT (' Plot Width now',F7.3,'"')  	GO TO 1234t Cl C...HIGH (set Height of plot): CX,  7000	IF (ARGS(1) .GT. 0.0) HEIGHT = ARGS(1) 	WRITE (*,777) HEIGHTd*   777	FORMAT (' Plot Height now',F7.3,'"') 	GO TO 1234  C	 C...CHSZ (Set Character Size): C +  8000	IF (ARGS(1) .GT. 0.0) CHSIZ = ARGS(1), 	WRITE (*,888) CHSIZ(   888	FORMAT (' Char Size now',F6.3,'"') 	GO TO 1234y Cl C...PTSZ (Set Size of Points): CX,  9000	IF (ARGS(1) .GT. 0.0) PLCHSZ = ARGS(1) 	WRITE (*,999) PLCHSZ.)   999	FORMAT (' Point Size now',F6.3,'"'). 	GO TO 1234. CL$ C...FONT (Select PALPHA Font Table): CM  3450	CALL Q_FONTh Ca 	GO TO 1234  Ct  C...DEVICE (Select Plot Device): C	.  3570	K_PLOT_DEV = J_PLOT_DEV		! (Old version) 	J_PLOT_DEV = ARGS(1) + 0.5  	IF (J_PLOT_DEV .NE. 0  .AND. +      >		IABS(J_PLOT_DEV) .LE. 9) GO TO 3572 A  3571	IF (IABS(J_PLOT_DEV) .LE. 9) GO TO 3572	! BEWARE I/O LOOPS!  	CALL SEL_PLOT_DEV (J_PLOT_DEV)  	GO TO 3571 +  3572	IF (K_PLOT_DEV .EQ. 9) CALL DWG_CLOSE  	IF (J_PLOT_DEV .EQ. 9) THEN" 		CALL PLOT_DEVICE2 (5, 6, LFZETA)! 		CALL DWG	! Open EDGR plot file.  	ELSE + 		CALL PLOT_DEVICE2 (J_PLOT_DEV, 6, LFZETA)  	END IF  	GO TO 1234  C ; C...PENTYPE (For Zeta plotter only): [NOT YET IMPLEMENTED!]  C 1  3580	IF (ARGS(1) .GT. 0  .AND.  ARGS(1) .LT. 7)        >		I_PLOT_PEN = ARGS(1) 	WRITE (*,3581) I_PLOT_PEN*  3581	FORMAT (' Zeta Plotter Pen type',I3) 	GO TO 1234  C 2 C...PRINT_PL (Make a Hard Copy on the PRINTRONIX): C   3670	IF (NEW_CALL) GO TO 3688- 	CALL PLOT_IN (0.,0.,999)	! End current Plot.  	CALL PXASK (LFPLPX) 	NO_CHANGE = .TRUE.  	GO TO 1234  C 4 C...PEN_PLOT (Make a Hard Copy on the ZETA Plotter): C   3675	IF (NEW_CALL) GO TO 3688- 	CALL PLOT_IN (0.,0.,999)	! End current Plot. 	 	CALL ZPQ  	NO_CHANGE = .TRUE.  	GO TO 1234  C   3688	WRITE (*,3689)  3689	FORMAT (/,5X, F      > 'I cannot hard-copy a plot that has not been displayed yet!',/) 	GO TO 1234  C  C...TITL (Enter a new Title):  C (  4560	WRITE (*,4561) (TITLE(I),I=1,NTTL)+  4561	FORMAT (' Present Title:',/,1X,100A1) ) 	CALL ASK ('Replacement?', '100S',NEWTTL)  	NTTLN = 100 	CALL TRIM_BLNK (NTTLN, NEWTTL)  	IF (NTTLN .EQ. 0) GO TO 1234   	CALL MOVEC (NTTLN,NEWTTL,NTITL)
 	NTTL = NTTLN  	GO TO 1234  C 2 C...LABL (Enter new X- and/or Y- and/or Z-Labels): C &  5670	WRITE (*,5671) (XLB(I),I=1,NLBX)-  5671	FORMAT (' Present X Label:',/,1X,100A1) ( 	CALL ASK ('Replacement?', '100S',NEWLX) 	NLBXN = 100 	CALL TRIM_BLNK (NLBXN, NEWLX) 	IF (NLBXN .EQ. 0) GO TO 5680  	CALL MOVEC (NLBXN,NEWLX,LABX)
 	NLBX = NLBXN  C &  5680	WRITE (*,5681) (YLB(I),I=1,NLBY),  5681	FORMAT (' Present Y Label:',/,1X,40A1)' 	CALL ASK ('Replacement?', '40S',NEWLY)  	NLBYN = 40  	CALL TRIM_BLNK (NLBYN, NEWLY) 	IF (NLBYN .EQ. 0) GO TO 5685  	CALL MOVEC (NLBYN,NEWLY,LABY)
 	NLBY = NLBYN  C &  5685	WRITE (*,5686) (ZLB(I),I=1,NLBZ)-  5686	FORMAT (' Present Z Label: ',/,1X,40A1) ' 	CALL ASK ('Replacement?', '40S',NEWLZ)  	NLBZN = 40  	CALL TRIM_BLNK (NLBZN, NEWLZ) 	IF (NLBZN .EQ. 0) GO TO 1234  	CALL MOVEC (NLBZN,NEWLZ,LABZ)
 	NLBZ = NLBZN  	GO TO 1234  C 0 C...TEXT (Overwrite elaborate textual material): C   6780	IFTEXT = 1 	GO TO 7893  C  C...CAPT (Enter a new Caption):  C   7890	CALL SETC (100,DUM,' ') 4 	CALL ASK ('Enter a line of Caption > ', '132S',DUM)
 	NCHCPT = 100  	CALL TRIM_BLNK (NCHCPT, DUM) . 	CALL ASK ('Character size (")? ', 'R',CHSCPT)! 	CALL ASK ('Angle? ', 'R',ANGCPT)  	IFTEXT = 0  C   7893	WRITE (*,7894)G  7894	FORMAT (' Position 1st character w/cursor & hit any key but CR:') - 	CALL CROSSHAIR (IXCH, IYCH, CMDCH, 320, 240) 2 	CALL SCALE_I_TO_INCH (IXCH, IYCH, XCCPOS, YCCPOS) C  	IF (IFTEXT .EQ. 0) GO TO 7895 C ! 	CALL SUB_SCRIBE (XCCPOS, YCCPOS)  C  	GO TO 1231  C ,  7895	CALL PRESYM (NCHCPT, DUM, NCHCPT, DUM); 	CALL PSYM_IN (XCCPOS, YCCPOS, CHSCPT, DUM, ANGCPT, NCHCPT)   	GO TO 1234 C 9 C...BOX (Enable/Disable 3-D BOX and Axis Label plotting):  C 3  7980	BOX3D = ASK_IF ('Plot Box and Axis Labels? ')  	GO TO 1234  C  C...HIDE (Remove Hidden Lines):  C :  8642	HIDE = ASK_IF ('Hidden Line Removal (expensive!)? ')2 	IF (HIDE) CALL ASK ('Halo width (")? ', 'R',HALO) 	HALO = ABS(HALO) $ 	IF (HALO .LT. 0.001) HIDE = .FALSE. 	GO TO 1234  C & C...ADD (Add Points or Lines by hand): C $  9200	IF (NPT .GE. MAXPT) GO TO 1234( 	ADD_LINE = ASK_IF ('Entering a Line? ') 	ADD_CHAR = .FALSE.  	IF (.NOT. ADD_LINE)  4      >		ADD_CHAR = ASK_IF ('Entering a Character? ')	 	I1ST = 1  	IF (.NOT. ADD_LINE) GO TO 9230 9  9210	CALL ASK ('Add (X,Y,Z) point (0,0,0 when done) > ', %      >		'R',XADD, 'R',YADD, 'R',ZADD) * 	IF (XADD .EQ. 0.0  .AND.  YADD .EQ. 0.0  (      >		.AND.  ZADD .EQ. 0.0) GO TO 1234  9220	NPT = NPT + 1  	XSET(NPT) = XADD  	YSET(NPT) = YADD  	ZSET(NPT) = ZADD  	LSET(NPT) = '    '  	IF (I1ST .EQ. 0) GO TO 9210	 	I1ST = 0  	LSET(NPT) = -1  	GO TO 9220  C   9230	IF (ADD_CHAR) GO TO 9250 C ?  9240	CALL ASK ('Add (X,Y,Z,IPTYP) point (0,0,0 when done) > ', /      >		'R',XADD, 'R',YADD, 'R',ZADD, 'I',LADD)  	GO TO 9260  C <  9250	CALL ASK ('Add (X,Y,Z,CH) point (0,0,0 when done) > ',0      >		'R',XADD, 'R',YADD, 'R',ZADD, '4S',LOGL) C -  9260	IF (XADD .EQ. 0.0  .AND.  YADD .EQ. 0.0 (      >		.AND.  ZADD .EQ. 0.0) GO TO 1234 	NPT = NPT + 1 	XSET(NPT) = XADD  	YSET(NPT) = YADD  	ZSET(NPT) = ZADD  	LSET(NPT) = LADD  	IF (.NOT. ADD_CHAR) GO TO 9240  	LSET(NPT) = LOGL(1) 	GO TO 9250  C % C...OK,		G O     D O     I T    ! ! !  C B C...Generate Rotation Matrix and set Perspective Viewing Distance: C .  2345	CALL PLOT_IN (0.,0.,999)	! Clear screen.5 	IF (IFSTIM .NE. 0) CALL TPLTI	! Initialize plotting. % 	IF (J_PLOT_DEV .EQ. 9) CALL DWG_NEXT  	IFSTIM = 0  	NEW_CALL = .FALSE.  	NO_CHANGE = .TRUE.  C  	PLDIST = PDIST  C 
 	XWID = WIDTH 
 	YWID = WIDTH  	ZHGT = HEIGHT C  	COSB = COS(PTHETA/RADIAN) 	SINB = SIN(PTHETA/RADIAN) 	COSA = COS(PPHI/RADIAN) 	SINA = SIN(PPHI/RADIAN) 	ROTAT(1,1) = COSA 	ROTAT(1,2) = - SINA 	ROTAT(1,3) = 0.0  	ROTAT(2,1) = SINA*COSB  	ROTAT(2,2) = COSA*COSB  	ROTAT(2,3) = SINB 	ROTAT(3,1) = - SINA*SINB  	ROTAT(3,2) = - COSA*SINB  	ROTAT(3,3) = COSB C  	IF (.NOT. STEREO) GO TO 2401  	STDIST = PLDIST$ 	IF (STDIST .EQ. 0.0) STDIST = 100.0  	AVIEW = ATAN2(0.5*SEPAR,STDIST)! 	COSA = COS(-AVIEW + PPHI/RADIAN) ! 	SINA = SIN(-AVIEW + PPHI/RADIAN)  	ROT1(1,1) = COSA  	ROT1(1,2) = - SINA  	ROT1(1,3) = 0.0 	ROT1(2,1) = SINA*COSB 	ROT1(2,2) = COSA*COSB 	ROT1(2,3) = SINB  	ROT1(3,1) = - SINA*SINB 	ROT1(3,2) = - COSA*SINB 	ROT1(3,3) = COSB  C   	COSA = COS(AVIEW + PPHI/RADIAN)  	SINA = SIN(AVIEW + PPHI/RADIAN) 	ROT2(1,1) = COSA  	ROT2(1,2) = - SINA  	ROT2(1,3) = 0.0 	ROT2(2,1) = SINA*COSB 	ROT2(2,2) = COSA*COSB 	ROT2(2,3) = SINB  	ROT2(3,1) = - SINA*SINB 	ROT2(3,2) = - COSA*SINB 	ROT2(3,3) = COSB  C $ Check for externally fixed limits -- C   2401	TXL = XMIN 	TXU = XMAX  	TYL = YMIN  	TYU = YMAX  	TZL = ZMIN  	TZU = ZMAX  C...Get limits from data -- $ 	CALL MINMAX (NPT, XSET, TXL1, TXU1) 	IF (TXL .EQ. 0.0) TXL = TXL1  	IF (TXU .EQ. 0.0) TXU = TXU1  	IF (TXU .NE. TXL) GO TO 130 	IF (TXL .EQ. 0.0) TXL = 1.0 	TXU = 1.5*TXL 	TXL = 0.5*TXL)   130	CALL MINMAX (NPT, YSET, TYL1, TYU1)  	IF (TYL .EQ. 0.0) TYL = TYL1  	IF (TYU .EQ. 0.0) TYU = TYU1  	IF (TYU .NE. TYL) GO TO 140 	IF (TYL .EQ. 0.0) TYL = 1.0 	TYU = 1.5*TYL 	TYL = 0.5*TYL)   140	CALL MINMAX (NPT, ZSET, TZL1, TZU1)O 	IF (TZL .EQ. 0.0) TZL = TZL1e 	IF (TZU .EQ. 0.0) TZU = TZU1e 	IF (TZU .NE. TZL) GO TO 200 	IF (TZL .EQ. 0.0) TZL = 1.0 	TZU = 1.5*TZL 	TZL = 0.5*TZL   200	DTX = TXU - TXL, 	TXU = TXU - FXTRIG*DTXX 	TXL = TXL + FXTRIG*DTX, 	DTY = TYU - TYL 	TYU = TYU - FXTRIG*DTY	 	TYL = TYL + FXTRIG*DTYw 	DTZ = TZU - TZL 	TZU = TZU - FXTRIG*DTZ  	TZL = TZL + FXTRIG*DTZE- C...Use RANGER to find dimensions of graph --L
   300	NBX = 4N& 	CALL RANGER (TXL, TXU, 4.0, SXL, SXU) 	THEMIN = SXU - SXLt 	DO 500 I=5,11- 	CALL RANGER (TXL, TXU, FLOAT(I), SXL1, SXU1)(' 	IF (THEMIN .LT. SXU1 - SXL1) GO TO 500  	SXU = SXU18 	SXL = SXL1H 	NBX = I 	THEMIN = SXU1 - SXL1o   500	CONTINUE C, 	NBY = 3& 	CALL RANGER (TYL, TYU, 3.0, SYL, SYU) 	THEMIN = SYU - SYL  C 
 	DO 510 I=4,91- 	CALL RANGER (TYL, TYU, FLOAT(I), SYL1, SYU1)(' 	IF (THEMIN .LT. SYU1 - SYL1) GO TO 510  	SYU = SYU1o 	SYL = SYL1= 	NBY = I 	THEMIN = SYU1 - SYL1    510	CONTINUE Cs 	NBZ = 4& 	CALL RANGER (TZL, TZU, 4.0, SZL, SZU) 	THEMIN = SZU - SZL  C) 	DO 520 I=5,11- 	CALL RANGER (TZL, TZU, FLOAT(I), SZL1, SZU1)(' 	IF (THEMIN .LT. SZU1 - SZL1) GO TO 520> 	SZU = SZU17 	SZL = SZL1G 	NBZ = I 	THEMIN = SZU1 - SZL1t   520	CONTINUE C67 C...Calculate Scaling Factors between Input (X,Y,Z) and)4 C   Virtual 3-D Plot Coordinates (XVIR, YVIR, ZVIR). CO+ CCCC  IF (NBX.EQ.5 .OR. NBX.EQ.20) NBX = 10X CCCC  IF (NBY.EQ.4) NBY = 8  CG 	XRANGE = SXU - SXL( 	YRANGE = SYU - SYL	 	ZRANGE = SZU - SZL  	XSCALE = XWID/XRANGE1 	YSCALE = YWID/YRANGE  	ZSCALE = ZHGT/ZRANGE8 	XCCINC = XWID/FLOAT(NBX)H 	YCCINC = YWID/FLOAT(NBY)8 	ZCCINC = ZHGT/FLOAT(NBZ)h 	XINC = XRANGE/FLOAT(NBX)  	YINC = YRANGE/FLOAT(NBY)  	ZINC = ZRANGE/FLOAT(NBZ)	6 	NSXIN = ALOG10((ABS(SXU) + ABS(SXL))/ABS(XINC)) + 1.56 	NSYIN = ALOG10((ABS(SYU) + ABS(SYL))/ABS(YINC)) + 1.56 	NSZIN = ALOG10((ABS(SZU) + ABS(SZL))/ABS(ZINC)) + 1.5	 	NSGZ = 0Q	 	NSGY = 0  C  	HMIN = 0.0  	VMIN = 0.0e Ct> C...XCHSZ, YCHSZ, and ZCHSZ are numbers to be used in place of= C   CHSIZ when calling MAP_3D etc., to cause actual character > C   strings to come out in reasonable places.  They are always C   > CHSIZ. C) 	XMID = 0.5*XWID 	YMID = 0.5*YWID 	ZMID = 0.5*ZHGT/ 	CALL MAP_3D (XMID, YMID, ZMID, H, V, SC, DEEP).7 	CALL MAP_3D (XMID+CHSIZ, YMID, ZMID, H1, V1, SC, DEEP)A$ 	XCHSZ = SQRT((H1-H)**2 + (V1-V)**2). 	IF (XCHSZ .GT. 0.0) XCHSZ = CHSIZ*CHSIZ/XCHSZ7 	CALL MAP_3D (XMID, YMID+CHSIZ, ZMID, H1, V1, SC, DEEP) $ 	YCHSZ = SQRT((H1-H)**2 + (V1-V)**2). 	IF (YCHSZ .GT. 0.0) YCHSZ = CHSIZ*CHSIZ/YCHSZ7 	CALL MAP_3D (XMID, YMID, ZMID+CHSIZ, H1, V1, SC, DEEP)=$ 	ZCHSZ = SQRT((H1-H)**2 + (V1-V)**2). 	IF (ZCHSZ .GT. 0.0) ZCHSZ = CHSIZ*CHSIZ/ZCHSZ5 	CALL MAP_3D (XMID+0.707*CHSIZ,YMID+0.707*CHSIZ,ZMID,N      >		H1,V1,SC,DEEP)$ 	DCHSZ = SQRT((H1-H)**2 + (V1-V)**2). 	IF (DCHSZ .GT. 0.0) DCHSZ = CHSIZ*CHSIZ/DCHSZ C)= C...Find maximum reasonable limits of "real" plot coordinatesH. C   relative to "origin" recognized by MAP_3D. CA. 	CALL MAP_3D (0.0, 0.0, 0.0, HH, VV, SC, DEEP) 	IF (BOX3D) A      >    CALL MAP_3D (-10.0*XCHSZ,-5.0*YCHSZ,0.0, HH,VV,SC,DEEP)* 	HMIN = AMIN1(HMIN,HH) 	VMIN = AMIN1(VMIN,VV)/ 	CALL MAP_3D (0.0, 0.0, ZHGT, HH, VV, SC, DEEP), 	IF (BOX3D)3@      >    CALL MAP_3D (-10.0*XCHSZ, 0.0, ZHGT, HH, VV, SC, DEEP) 	HMIN = AMIN1(HMIN,HH) 	VMIN = AMIN1(VMIN,VV)/ 	CALL MAP_3D (0.0, YWID, 0.0, HH, VV, SC, DEEP)S 	HMIN = AMIN1(HMIN,HH) 	VMIN = AMIN1(VMIN,VV)0 	CALL MAP_3D (0.0, YWID, ZHGT, HH, VV, SC, DEEP) 	HMIN = AMIN1(HMIN,HH) 	VMIN = AMIN1(VMIN,VV)/ 	CALL MAP_3D (XWID, 0.0, 0.0, HH, VV, SC, DEEP)d 	IF (BOX3D):?      >    CALL MAP_3D (XWID, -5.0*YCHSZ, 0.0, HH, VV, SC, DEEP)s 	HMIN = AMIN1(HMIN,HH) 	VMIN = AMIN1(VMIN,VV)0 	CALL MAP_3D (XWID, 0.0, ZHGT, HH, VV, SC, DEEP) 	HMIN = AMIN1(HMIN,HH) 	VMIN = AMIN1(VMIN,VV)0 	CALL MAP_3D (XWID, YWID, 0.0, HH, VV, SC, DEEP) 	HMIN = AMIN1(HMIN,HH) 	VMIN = AMIN1(VMIN,VV)1 	CALL MAP_3D (XWID, YWID, ZHGT, HH, VV, SC, DEEP)  	HMIN = AMIN1(HMIN,HH) 	VMIN = AMIN1(VMIN,VV) C 3 C...Generate Offsets for Physical plot coordinates:8 C  	HOVER = HCCOVR - HMIN 	VUP = VCCUP - VMIN ! 	IF (BOX3D) VUP = VUP + 5.5*CHSIZI7 	IF (BOX3D) HOVER = HOVER + 1.0*CHSIZ	! [Formerly 10.0]  CL 	XRAW = SXLc 	YRAW = SYL' 	ZRAW = SZLB C=
 	IPASS = 2 	IF (.NOT. STEREO) GO TO 2403N
 	IPASS = 1 C   	CALL CPYMAT (ROT1, ROTAT, 3, 3) 	GO TO 2403  CL%  2402	CALL CPYMAT (ROT2, ROTAT, 3, 3)r C  	HOVER = HOVER + SEPAR C:   2403	IF (.NOT. BOX3D) GO TO 207 C 1 C...Put in Borders, Grid, and Numerical Labels --L CT 	XVIR = 0.0' 	YVIR = 0.0  	ZVIR = 0.0e 	DXYTIC = 0.02*XWIDS 	DXTIC = DXYTIC  	DYTIC = DXYTICB 	DZTIC = 0.02*ZHGT/ 	IF (ABS(PTHETA)+ABS(PPHI) .LT. 0.01) GO TO 911C5 C...Start with X grid and Labels, lower L to lower R:9- 	IF (ABS(XRAW) .LT. 0.0001*XRANGE) XRAW = 0.0c
 	NSIG = NSXINo2 	CALL ENCODX (XRAW, DUM, MINSIG, MAXSIG, -1, NSIG) 	NSGX = MAX0(NSGX, NSIG) 	DXCC = 0.5*FLOAT(NSIG)*XCHSZ, 	XP = XVIR - DXCC + XCHSZI 	XP1 = XP + 2.0*DXCC 	YP = - 3.5*YCHSZC 	CALL PL_3D (XP1, YP, 0.0, 3)  CCCC	CALL NEWPEN (I_PLOT_PEN )) 	CALL PSYM_3D (XP, YP, 0.0, XP1, YP, 0.0,X      >		 CHSIZ, DUM, NSIG) CCCC	CALL NEWPEN (I_PLOT_PEN ) 	CALL PL_3D (XVIR, 0.0, 0.0, 3)O 	DO 910 I=1,NBXp 	XVIR = XVIR + XCCINCO 	CALL PL_3D (XVIR, 0.0, 0.0, 2)L 	XRAW = XRAW + XINC3- 	IF (ABS(XRAW) .LT. 0.0001*XRANGE) XRAW = 0.08
 	NSIG = NSXINI2 	CALL ENCODX (XRAW, DUM, MINSIG, MAXSIG, -1, NSIG) 	NSGX = MAX0(NSGX, NSIG) 	DXCC = 0.5*FLOAT(NSIG)*XCHSZO 	XP = XVIR - DXCC + XCHSZI 	XP1 = XP + 2.0*DXCC) 	CALL PSYM_3D (XP, YP, 0.0, XP1, YP, 0.0,a      >		 CHSIZ, DUM, NSIG)! 	CALL PL_3D (XVIR, 0.0, DZTIC, 3)_ 	CALL PL_3D (XVIR, 0.0, 0.0, 2)A 	IF (I .EQ. NBX) GO TO 910! 	CALL PL_3D (XVIR, DYTIC, 0.0, 3)  	CALL PL_3D (XVIR, 0.0, 0.0, 2)    910	CONTINUE$   911	IF (PTHETA .EQ. 1.0) GO TO 941. C...Now Y Grid and Labels, lower R to upper R:- 	IF (ABS(YRAW) .LT. 0.0001*YRANGE) YRAW = 0.0 
 	NSIG = NSYIN 2 	CALL ENCODX (YRAW, DUM, MINSIG, MAXSIG, -1, NSIG) 	NSGY = MAX0(NSGY, NSIG) 	XP = XVIR + 2.0*XCHSZ 	XP1 = XP + FLOAT(NSIG)*XCHSZ= 	YP = YVIR - 0.5*YCHSZ) 	CALL PSYM_3D (XP, YP, 0.0, XP1, YP, 0.0,       >		 CHSIZ, DUM, MAXSIG)  	CALL PL_3D (XVIR, YVIR, 0.0, 3) 	DO 920 I=1,NBY	 	YVIR = YVIR + YCCINCP  	CALL PL_3D (XVIR, YVIR, 0.0, 2) 	YRAW = YRAW + YINCR- 	IF (ABS(YRAW) .LT. 0.0001*YRANGE) YRAW = 0.0 
 	NSIG = NSYIN(2 	CALL ENCODX (YRAW, DUM, MINSIG, MAXSIG, -1, NSIG) 	NSGY = MAX0(NSGY, NSIG) 	XP1 = XP + FLOAT(NSIG)*XCHSZ( 	YP = YVIR - 0.5*YCHSZ) 	CALL PSYM_3D (XP, YP, 0.0, XP1, YP, 0.0,       >		 CHSIZ, DUM, MAXSIG)" 	CALL PL_3D (XVIR, YVIR, DZTIC, 3)  	CALL PL_3D (XVIR, YVIR, 0.0, 2) 	IF (I .EQ. NBY) GO TO 920& 	CALL PL_3D (XVIR-DXTIC, YVIR, 0.0, 3)  	CALL PL_3D (XVIR, YVIR, 0.0, 2)   920	CONTINUE0 C...Now "bare" X grid across top of box, R to L:/ 	IF (ABS(PTHETA)+ABS(PPHI) .LT. 0.01) GO TO 931( 	DO 930 I=1,NBXr 	XVIR = XVIR - XCCINCN  	CALL PL_3D (XVIR, YVIR, 0.0, 2)" 	CALL PL_3D (XVIR, YVIR, DZTIC, 3)  	CALL PL_3D (XVIR, YVIR, 0.0, 2) 	IF (I .EQ. NBX) GO TO 930& 	CALL PL_3D (XVIR, YVIR-DYTIC, 0.0, 3)  	CALL PL_3D (XVIR, YVIR, 0.0, 2)   930	CONTINUE* C...And "bare" Y grid, upper L to lower L:   931	CONTINUE 	DO 940 I=1,NBY  	YVIR = YVIR - YCCINC)  	CALL PL_3D (XVIR, YVIR, 0.0, 2) 	IF (I .EQ. NBY) GO TO 940& 	CALL PL_3D (XVIR+DXTIC, YVIR, 0.0, 3)  	CALL PL_3D (XVIR, YVIR, 0.0, 2)" 	CALL PL_3D (XVIR, YVIR, DZTIC, 3)  	CALL PL_3D (XVIR, YVIR, 0.0, 2)   940	CONTINUE"   941	IF (PPHI .EQ. 1.0) GO TO 2017 C...Finally, Z grid and Labels, UP from lower L corner:A 	XRAW = SXLS 	YRAW = SYL  	ZRAW = SZL+ 	XVIR = 0.0  	YVIR = 0.0( 	ZVIR = 0.0/- 	IF (ABS(ZRAW) .LT. 0.0001*ZRANGE) ZRAW = 0.0N
 	NSIG = NSZIN=2 	CALL ENCODX (ZRAW, DUM, MINSIG, MAXSIG, -1, NSIG) 	NSGZ = MAX0(NSGZ, NSIG)' 	DP = - 0.707*(1.0 + FLOAT(NSIG))*DCHSZ* 	DP1 = DP + FLOAT(NSIG)*DCHSZC 	ZP = ZVIR - 0.5*ZCHSZ( 	CALL PSYM_3D (DP, DP, ZP, DP1, DP1, ZP,      >		 CHSIZ, DUM, NSIG) C= 	CALL PL_3D (0.0, 0.0, ZVIR, 3)( 	DO 950 I=1,NBZ  	ZVIR = ZVIR + ZCCINC  	CALL PL_3D (0.0, 0.0, ZVIR, 2)- 	ZRAW = ZRAW + ZINC)- 	IF (ABS(ZRAW) .LT. 0.0001*ZRANGE) ZRAW = 0.0o
 	NSIG = NSZINx2 	CALL ENCODX (ZRAW, DUM, MINSIG, MAXSIG, -1, NSIG) 	NSGZ = MAX0(NSGZ, NSIG)' 	DP = - 0.707*(1.0 + FLOAT(NSIG))*DCHSZs 	DP1 = DP + FLOAT(NSIG)*DCHSZP 	ZP = ZVIR - 0.5*ZCHSZ( 	CALL PSYM_3D (DP, DP, ZP, DP1, DP1, ZP,      >		 CHSIZ, DUM, NSIG) CE 	CALL PL_3D (0.0, 0.0, ZVIR, 3)." 	CALL PL_3D (DXYTIC, 0.0, ZVIR, 2)" 	CALL PL_3D (0.0, DXYTIC, ZVIR, 3) 	CALL PL_3D (0.0, 0.0, ZVIR, 2).   950	CONTINUE C  C...Put in Axis Labels --  C     201	IF (NLBX .LT. 1) GO TO 231 	DO 202 I=1,25   202	NAME(I) = LABX(I)L# 	CALL PRESYM (NLBX, DUM, NLBX, DUM)S 	XW = XCHSZ*FLOAT(NLBX)L 	XP = 0.5*XWID - 0.5*XWI 	YP = - 7.0*YCHSZU= 	CALL PSYM_3D (XP, YP, 0.0, XP+XW, YP, 0.0, CHSIZ, DUM, NLBX)=    231	IF (NLBY .LT. 1) GO TO 241 	IF (PTHETA .EQ. 1.0) GO TO 241= 	DO 204 I=1,10   204	NAME(I) = LABY(I)T# 	CALL PRESYM (NLBY, DUM, NLBY, DUM)T 	YW = YCHSZ*FLOAT(NLBY)T 	YP = 0.5*YWID - 0.4*YWL& 	XP = XWID + (3.5 + FLOAT(NSGY))*XCHSZ= 	CALL PSYM_3D (XP, YP, 0.0, XP, YP+YW, 0.0, CHSIZ, DUM, NLBY)     241	IF (NLBZ .LT. 1) GO TO 207 	IF (PPHI .EQ. 1.0) GO TO 207a 	DO 206 I=1,10   206	NAME(I) = LABZ(I) # 	CALL PRESYM (NLBZ, DUM, NLBZ, DUM)Y 	ZW = FLOAT(NSGZ)*ZCHSZE 	ZP = 0.5*ZHGT - 0.65*ZW' 	DP = - 0.707*(3.4 + FLOAT(NSGZ))*DCHSZ.; 	CALL PSYM_3D (DP, DP, ZP, DP, DP, ZP+ZW, CHSIZ, DUM, NLBZ)Z C.  C...Draw ZERO-axes if requested: C    207	XZER = - SXL*XSCALEG 	YZER = - SYL*YSCALE 	ZZER = - SZL*ZSCALE C( 	IF (.NOT. XAXIS) GO TO 21 	IF (SYU*SYL .GT. 0.0) GO TO 21o 	IF (SZU*SZL .GT. 0.0) GO TO 21n 	IF (SYL+SZL .EQ. 0.0) GO TO 21. C...Horizontal Y=Z=0 axis:5 	CALL DO3DSH (0.0, YZER, ZZER, XWID, 0.0, 0.0, CHSIZ)F C)    21	IF (.NOT. YAXIS) GO TO 22n 	IF (SXU*SXL .GT. 0.0) GO TO 22r 	IF (SZU*SZL .GT. 0.0) GO TO 22  	IF (SXL+SZL .EQ. 0.0) GO TO 22b C...Into-page X=Z=0 axis:D5 	CALL DO3DSH (XZER, 0.0, ZZER, 0.0, YWID, 0.0, CHSIZ)X CZ     22	IF (.NOT. ZAXIS) GO TO 305  	IF (SXU*SXL .GT. 0.0) GO TO 305  	IF (SYU*SYL .GT. 0.0) GO TO 305  	IF (SXL+SXL .EQ. 0.0) GO TO 305 C...Vertical X=Y=0 axis:5 	CALL DO3DSH (XZER, YZER, 0.0, 0.0, 0.0, ZHGT, CHSIZ)I C  C...Put in Title --n Cf    305	IF (NTTL .LE. 0) GO TO 350% 	CALL MOVEC (NTTL, NTITL(1), NAME(1)) # 	CALL PRESYM (NTTL, DUM, NTTL, DUM) 5 	CALL MAP_3D (XMID, YMID, ZMID, DHCC, DVCC, SC, DEEP)p- 	DHCC = DHCC + HOVER - 0.42*FLOAT(NTTL)*CHSIZO 	DHCC = AMAX1 (0.05, DHCC) 	DVCC = 0.5*CHSIZP1 	CALL PSYM_IN (DHCC, DVCC, CHSIZ, DUM, 0.0, NTTL)d Cn3 C...Plot Data POINTS (Characters, Symbols, Spheres)e= C   and load LINE SEGMENTS into transformed (H,V,D) buffer --= Ce   350	NLSG = 0
 	LLAST = 0 Cu 	DO  410 I=1,NPT Ch 	XVIR = XSCALE*(XSET(I) - SXL) 	YVIR = YSCALE*(YSET(I) - SYL) 	ZVIR = ZSCALE*(ZSET(I) - SZL): 	CALL MAP_3D (XVIR, YVIR, ZVIR, HPLOT, VPLOT, SCALE, DEEP) 	XCCPOS = HOVER + HPLOT  	YCCPOS = VUP + VPLOTH CT
 	LL = LSET(I)C	 	LLL = LLE 	CHAR = LOGL(1)	 C  	IF (LL .NE. '    ') GO TO 401 C	, C...Connect up line segments if in sequence. CE  	IF (NLSG .GE. MAXLSG) GO TO 410 	NLSG = NLSG + 1 	HOR(NLSG) = XCCPOSD 	VER(NLSG) = YCCPOS= 	DIST(NLSG) = DEEP/ 	IF (PLDIST .EQ. 0.0) DIST(NLSG) = DEEP + 200.0  	IF (LLL .EQ. LLAST) GO TO 410C C...Starting a new connected line.  Tag starting point with DIST<0.3 	DIST(NLSG) =  - DIST(NLSG)B
 	GO TO 410 CC C...Draw a Point or a Circle:  CM   401	MOST_SIGNIF = I2LL(2) = 	IF (MOST_SIGNIF .EQ. 0  .OR.  MOST_SIGNIF .EQ. -1) GO TO 404P CS( C...If LL contains a REAL*4 radius RSPH,< C   Draw in a Sphere of radius |RSPH| as a projected circle.B C   Make part of normal Line Segment array (for HIDE) if RSPH > 0;@ C   Treat as a Symbol if RSPH < 0  (or if no room left in NLSG). CU   402	SPHLS = .TRUE.= 	IF (.NOT. HIDE  .OR.  NLSG .GT. MAXLSG - 33) SPHLS = .FALSE.(# 	IF (RSPH .LT. 0.0) SPHLS = .FALSE.) 	ARSPH = ABS(RSPH) 	RCIRC = SCALE*XSCALE*ARSPHL	 	NSC = 32C% 	IF (ARSPH .LT. 0.05*XRANGE) NSC = 20L% 	IF (ARSPH .LT. 0.01*XRANGE) NSC = 12X
 	NSC4 = NSC/4N 	NSC2 = 2*NSC4 	NSC4 = NSC4 + 1 	DPHI = 3.14159/FLOAT(NSC2)V
 	PHI = 0.0 	DO 403 ICIRC=1,NSC4 	DHC = RCIRC*COS(PHI)3 	DVC = RCIRC*SIN(PHI)  	IF (SPHLS) GO TO 4029 	HSPH(ICIRC) = XCCPOS + DHC2 	VSPH(ICIRC) = YCCPOS + DVCN" 	HSPH(NSC2+2-ICIRC) = XCCPOS - DHC" 	VSPH(NSC2+2-ICIRC) = YCCPOS + DVC  	HSPH(ICIRC+NSC2) = XCCPOS - DHC  	VSPH(ICIRC+NSC2) = YCCPOS - DVC! 	HSPH(NSC+2-ICIRC) = XCCPOS + DHCW! 	VSPH(NSC+2-ICIRC) = YCCPOS - DVCG
 	GO TO 403$  4029	HOR(NLSG+ICIRC) = XCCPOS + DHC 	VER(NLSG+ICIRC) = YCCPOS + DVC  	DIST(NLSG+ICIRC) = DEEP& 	HOR(NLSG+NSC2+2-ICIRC) = XCCPOS - DHC& 	VER(NLSG+NSC2+2-ICIRC) = YCCPOS + DVC 	DIST(NLSG+NSC2+2-ICIRC) = DEEP $ 	HOR(NLSG+ICIRC+NSC2) = XCCPOS - DHC$ 	VER(NLSG+ICIRC+NSC2) = YCCPOS - DVC 	DIST(NLSG+ICIRC+NSC2) = DEEP'% 	HOR(NLSG+NSC+2-ICIRC) = XCCPOS + DHCO% 	VER(NLSG+NSC+2-ICIRC) = YCCPOS - DVCP 	DIST(NLSG+NSC+2-ICIRC) = DEEP   403	PHI = PHI + DPHI C ! 	IF (SPHLS) DIST(NLSG+1) = - DEEP'$ 	IF (SPHLS) NLSG = NLSG + 2*NSC2 + 1 CT 	NSCP1 = NSC + 17 	IF (.NOT. SPHLS) CALL DRAW_LINE (HSPH, VSPH, NSCP1, 1)D C 
 	GO TO 410 C  C...Plot a symbol or character:D C     404	IF (LLL .GT. 39) GO TO 406 	IF (LLL .GE. 0) GO TO 405> C...For LLL < 0, make a DOT with the pen, but ONLY if the NEXT& C   point is NOT at the same position!' 	IF (XSET(I+1) .NE. XSET(I)) GO TO 4041L' 	IF (YSET(I+1) .NE. YSET(I)) GO TO 40410' 	IF (ZSET(I+1) .NE. ZSET(I)) GO TO 4041H
 	GO TO 410&  4041	CALL PLOT_IN (XCCPOS, YCCPOS, 3)! 	CALL PLOT_IN (XCCPOS, YCCPOS, 2) 
 	GO TO 410 C2   405	LL20 = LLL! 	IF (LLL .GE. 20) LL20 = LLL - 20M? 	CALL TUEC_SYMBOL (XCCPOS, YCCPOS, SCALE*PLCHSZ, LL20, 0.0, -1)=
 	GO TO 410 C=G   406	CALL PSYM_IN (XCCPOS-.285*SCALE*PLCHSZ, YCCPOS-.428*SCALE*PLCHSZ,A&      >	     SCALE*PLCHSZ, CHAR, 0., 1) CT   410	LLAST = LLL= C ! C...Now Plot the LINE SEGMENTS --- C-6 CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC  C	IF (HIDE) WRITE (17,1711) NLSG/ C1711	FORMAT (///,10X,'HIDDEN LINE REMOVAL on',   C    1	  I5,' Line Segments:',/)6 CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC 	NLSG = NLSG - 1 	IF (NLSG .LT. 1) GO TO 4321! 	CALL PLOT_IN (HOR(1), VER(1), 3)C4 	HLAST = HUGE	! (Not equal to any reasonable value.)
 	VLAST = HUGEL CCCC  CRIT = 0.005*ABS(HALO) C  	DO  430 ILS=1,NLSGa C  	DIR = DIST(ILS+1)C 	IF (DIR .LT. 0.0) GO TO 430	! If next pt starts new line, skip LS.O 	HH = HOR(ILS) 	VV = VER(ILS)( 	IF (HH .NE. HLAST  .OR.  VV .NE. VLAST)#      >     CALL PLOT_IN (HH, VV, 3)I 	HLAST = HOR(ILS+1)	 	VLAST = VER(ILS+1)Z 	IF (HIDE) GO TO 421 CO0 C...NO Hidden Line Removal.  Just plot the line: C,$   429	CALL PLOT_IN (HLAST, VLAST, 2)
 	GO TO 430 C-1 C...Hidden Line Removal:  Generate Gaps in LS(i):L CC   421	DHH = HLAST - HH 	DVV = VLAST - VV  	RR = SQRT(DHH*DHH + DVV*DVV)* 	IF (RR .EQ. 0.0) GO TO 4301 	ROTN = ATAN2(DVV,DHH) 	RII = COS(ROTN) 	RIJ = SIN(ROTN) C3 	DIL = ABS(DIST(ILS))( 	DIMAX = AMAX1(DIL,DIR)D6 CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC1 C	WRITE (17,1712) ILS, HH,VV,DIL, HLAST,VLAST,DIRA* C1712	FORMAT (/,' Checking LS(',I3,'):',/,> C    1  ' (',2(F6.2,','),G10.3,') to (',2(F6.2,','),G10.3,')') C	RTNDEG = 57.29578*ROTN& C	WRITE (17,1713) RR, RTNDEG, RII, RIJ1 C1713	FORMAT (' Length=',F7.3,',  Angle=',F7.2,/,7& C    1  ' Rii =',F6.3,',  Rij =',F6.3)6 CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC CI
 	NGAPS = 0 CXC C...Check all other line segments LS(j) to see if they are in frontO C   of current line LS(i): C  	DO 420 JLS=1,NLSG C- 	IF (JLS .EQ. ILS) GO TO 420 	DJR = DIST(JLS+1) 	IF (DJR .LT. 0.0) GO TO 420 	DJL = ABS(DIST(JLS))  	DJMIN = AMIN1(DJL, DJR)2 C...(Allow for vertices within visible precision:)% 	IF (DIMAX .LE. DJMIN+TINY) GO TO 420h Ca8 C...Part of LS(j) is closer than LS(i).  Transform LS(j)4 C   to system where LS(i) goes from (0,0) to (RR,0): C3 	HJ = HOR(JLS) - HH1 	VJ = VER(JLS) - VVP 	HJ1 = HOR(JLS+1) - HH 	VJ1 = VER(JLS+1) - VV 	HJL = RII*HJ + RIJ*VJ 	VJL = -RIJ*HJ + RII*VJe 	HJR = RII*HJ1 + RIJ*VJ1 	VJR = -RIJ*HJ1 + RII*VJ1m? C...Check that there is a possibility of apparent intersection:. 	HJMIN = AMIN1(HJL,HJR)O$ 	IF (HJMIN .GT. RR + HALO) GO TO 420 	HJMAX = AMAX1(HJL,HJR))! 	IF (HJMAX .LT. - HALO) GO TO 420  	VJMAX = AMAX1(VJL, VJR)! 	IF (VJMAX .LT. - HALO) GO TO 4203 	VJMIN = AMIN1(VJL, VJR) 	IF (VJMIN .GT. HALO) GO TO 420) CY6 C...LS(j) appears to intersect LS(i).  Find out where. C  	DVJ = VJR - VJL 	IF (DVJ .EQ. 0.0) GO TO 420 	DHJ = HJR - HJL 	IF (DHJ .NE. 0.0) GO TO 422 CA0 C...LS(j) Perpendicular to LS(i) (special case): CT 	HINT = HJLn" 	DJINT = DJL + (DJL - DJR)*VJL/DVJ" 	DIINT = DIL + (DIR - DIL)*HINT/RR% 	IF (DIINT .LT. DJINT+TINY) GO TO 420s 	DHHALO = HALO
 	GO TO 424 Ca C...LS(j) Diagonal wrt. LS(j): Ca   422	HINT = HJL - VJL*DHJ/DVJ CI< C...Compare Depths of Intersection point on LS(i) and LS(j): C " 	DJINT = DJL + (DJL - DJR)*VJL/DVJ" 	DIINT = DIL + (DIR - DIL)*HINT/RR% 	IF (DIINT .LT. DJINT+TINY) GO TO 420S Co3 C...A genuine obscuration of LS(i) by LS(j) exists!U C. 	RRJ = SQRT(DHJ*DHJ + DVJ*DVJ) 	DHHALO = ABS(HALO*RRJ/DVJ)  CG5 C...Put a Gap into LS(i) where LS(j) passes in front:S C    424	RGL = HINT - DHHALOS 	IF (RGL .GE. RR) GO TO 420  	RGR = HINT + DHHALO 	IF (RGR .LE. 0.0) GO TO 420 	NGAPS = NGAPS + 1 	GAPL(NGAPS) = RGL 	GAPR(NGAPS) = RGR6 CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC4 C	WRITE (17,1714) ILS, JLS, GAPL(NGAPS), GAPR(NGAPS)6 C1714	FORMAT (/,' LS(',I3,') obscured by LS(',I3,').',% C    1  '  Gap from',F7.3,' to',F7.3),6 CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC 	IF (NGAPS .GE. 100) GO TO 425 CT   420	CONTINUE C0( C...ORDER the breaks (if there are any): CZ!   425	IF (NGAPS .LE. 0) GO TO 429P C, 	IF (NGAPS .GT. 1)3      >   CALL ORDER (1,2,NGAPS,GAPL,GAPR,GAPR,GAPR). C06 CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC C	WRITE (17,1715) NGAPS, ILS@ C1715	FORMAT (' Summary:',I3,' Gaps in LS(',I3,').  In order, ')7 C	WRITE (17,1716) (JJJ,GAPL(JJJ),GAPR(JJJ),JJJ=1,NGAPS),. C1716	FORMAT (1X,I3,':  From',F7.3,' to',F7.3)6 CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
 	RGR = 0.0 	RII = COS(ROTN) 	RIJ = SIN(ROTN) C(D C...Draw the line in original location at original angle, with gaps: CS 	DO 440 KG=1,NGAPS 	RGL = GAPL(KG). 	IF (RGL .LT. RGR) GO TO 437 	HHH = HH + RII*RGLL 	VVV = VV + RIJ*RGLZ 	CALL PLOT_IN (HHH, VVV, 2)    437	RGR = AMAX1(RGR,GAPR(KG))2 	HHH = HH + RII*RGR  	VVV = VV + RIJ*RGRS
 	RNXT = RR% 	IF (KG .LT. NGAPS) RNXT = GAPL(KG+1)G4   440	IF (RGR .LT. RNXT)  CALL PLOT_IN (HHH, VVV, 3) C 8 	IF (GAPR(NGAPS) .LT. RR) CALL PLOT_IN (HLAST, VLAST, 2)8 	IF (GAPR(NGAPS) .GE. RR) CALL PLOT_IN (HLAST, VLAST, 3) CL   430	CONTINUE8 C------------------------------------------------------<  4321	IPASS = IPASS + 1R 	IF (IPASS .EQ. 2) GO TO 2402S CI- 	CALL PLOT_IN (0.,0.,99)	! Flush Plot Buffer.. 	NO_CHANGE = .TRUE.L 	GO TO 1234, CI C...Finished.  Exit. CR  9900	IF (.NOT. SAVE) NPT = 0C 	SAVE = .FALSE.  	HIDE = .FALSE.  	CALL CLOSE (LFZETA,'DELETE')+ CV 	RETURN*D C------------------------------------------------------------------<% 	ENTRY DOPLOT_3D_LUNS (LFPXST, LFZPL)0 CT; 	IF (LFPXST .GT. 0  .AND.  LFPXST .LT. 100) LFPLPX = LFPXSTe 	IF (LFPXST .EQ. 0) LFPLPX = 98 	IF (LFZPL .GT. 0  .AND.  LFZPL .LT. 100) LFZETA = LFZPL 	RETURNu& C------------------------------------< 	ENTRY DO3DMX (MXPT) 	ENTRY DOPLOT_3D_MAX (MXPT)I C 
 	MAXPT = MXPT  	MAXLSG = MXPT CD 	RETURNV= C-----------------------------------------------------------< , 	ENTRY SET3DL (XMN, XMX, YMN, YMX, ZMN, ZMX)3 	ENTRY DOPLOT_3D_LIMITS (XMN,XMX, YMN,YMX, ZMN,ZMX)G CO) C  Change XYZ Limits from default values.n= C  Note: Zeros usually better, they give you a nice roundoff.+ C  	XMIN = XMNX 	XMAX = XMXN 	YMIN = YMN= 	YMAX = YMX  	ZMIN = ZMNP 	ZMAX = ZMX0 CI 	RETURN=- C-------------------------------------------<  	ENTRY DIM3D (XNCH, YNCH)d" 	ENTRY DOPLOT_3D_SIZE (XNCH, YNCH) C3
 	WIDTH = XNCH ) 	HEIGHT = AMIN1(YNCH, VCCMAX-VCCUP-VCCDN)P Ct1 C...NOTE: WIDTH,HEIGHT are dimensions (in inches)I% C   of square box formed by x,z axes.F1 C  VCCMAX = RANGE OF VERTICAL PEN MOTION OVERALL.* Ca 	RETURN,2 C------------------------------------------------< 	ENTRY CHSZ3D (CHLB, CHPLT)n( 	ENTRY DOPLOT_3D_CHAR_SIZE (CHLB, CHPLT) C   	IF (CHLB .GT. 0.0) CHSIZ = CHLB# 	IF (CHPLT .GT. 0.0) PLCHSZ = CHPLTU C  	RETURN . C--------------------------------------------< 	ENTRY XLAB (NCHX, LINX)$ 	ENTRY DOPLOT_3D_XLABEL (NCHX, LINX) CS 	NCH = MAX0(0,NCHX)C 	CALL TRIM_BLNK (NCH,LINX) 	NLBX = MIN0(100,NCH)  	CALL MOVEC (NLBX,LINX,LABX) 	RETURN . C--------------------------------------------< 	ENTRY YLAB (NCHY, LINY)$ 	ENTRY DOPLOT_3D_YLABEL (NCHY, LINY) C  	NCH = MAX0(0,NCHY)  	CALL TRIM_BLNK (NCH,LINY) 	NLBY = MIN0(NCH,40) 	CALL MOVEC (NLBY,LINY,LABY) 	RETURNC. C--------------------------------------------< 	ENTRY ZLAB (NCHZ, LINZ)$ 	ENTRY DOPLOT_3D_ZLABEL (NCHZ, LINZ) CH 	NCH = MAX0(0,NCHZ)P 	CALL TRIM_BLNK (NCH,LINZ) 	NLBZ = MIN0(100,NCH)S 	CALL MOVEC (NLBZ,LINZ,LABZ) 	RETURN-. C--------------------------------------------< 	ENTRY TITL3D (NCHT, LINT)# 	ENTRY DOPLOT_3D_TITLE (NCHT, LINT)( CG 	NCH = MAX0(0,NCHT)N 	CALL TRIM_BLNK (NCH,LINT) 	NTTL = MIN0(100,NCH)I 	CALL MOVEC (NTTL,LINT,NTITL)G 	RETURNC2 C------------------------------------------------<  	ENTRY DOAX3D (IFXX, IFYX, IFZX)( 	ENTRY DOPLOT_3D_AXES (IFXX, IFYX, IFZX) C+
 	XAXIS = IFXXX
 	YAXIS = IFYXV
 	ZAXIS = IFZXC 	RETURNC& C------------------------------------< 	ENTRY DOBOX (IFBX)  	ENTRY DOPLOT_3D_BOX (IFBX)S C)
 	BOX3D = IFBX  	RETURNL5 C---------------------------------------------------<.! 	ENTRY PERSP (PTH1, PPH1, PDIST1) + 	ENTRY DOPLOT_3D_PERSP (PTH1, PPH1, PDIST1)m C  	PTHETA = PTH1 	PPHI = PPH1 	PDIST = PDIST1O C6 	RETURNL CE C) 	END