;       SUBROUTINE DSPL11(SIGM,XIN,YIN,NINT,XOUT,YOUT,NOUT,*)  C  C  reqd. routines - NONE   C  C  C     LIBRARY-ROUTINE  C = C                                                29/JULY/1980 > C                                                C.J. KOST SIN C A C================================================================ A C================================================================ @ C==  DSPL11: INTERPOLATES POINTS THROUGH FUNCTION VALUES USING A> C==         SPLINE UNDER TENSION.  FOR TENSIONS CLOSE TO ZERO,D C==         (EG.0.001),THE INTERPOLATION IS CLOSE TO A CUBIC SPLINE.? C==         FOR LARGE TENSIONS,(EG. 100.), THE INTERPOLATION IS E C==         BASICALLY POLYGONAL.  THE ROUTINE IS IN DOUBLE PRECISION. G C==  DSPL1A: CALCULATES SPLINE FIT, BUT DOES NOT PERFORM INTERPOLATION. D C==         THE INPUT PARAMETERS ARE THE SAME AS FOR DSPL11, EXCEXPTF C==         THAT NO ABCISSA VALUES TO BE INTERPOLATED ARE TO BE GIVEN.C C==  DSPL1B: CALCULATES FIRST DERIVATIVE, SECOND DERIVATIVE, INTER- A C==         POLATION, OR INTERGRAL AT SPECIFIED ABCISSAE.  EITHER D C==         DSPL11 OR DSPL1A MUST BE CALLED PRIOR TO CALLING DSPL1B.# C==         MORE EXPLANATION BELOW. C C==  DSPL1C: CALCULATES THE DEFINITE INTEGRAL BETWEEN TWO SPECIFIED E C==         ABCISSAE. EITHER DSPL11 OR DSPL1A MUST BE CALLED PRIOR TO 4 C==         CALLING DSPL1C.  MORE EXPLANATION BELOW.A C================================================================ A C================================================================  C==  DSPL11: C==  C==    ON INPUT:> C==       1.)  SIGM:  IS THE NORMALIZED TENSION FACTOR.  IT IS? C==          NON-ZERO AND CORRESPONDS TO THE CURVINESS DESIRED. C C==          THE SIGN OF SIGM IS IGNORED.  IF SIGM IS CLOSE TO ZERO @ C==          (EG. 0.001), THE RESULTING CURVE IS APPROXIMATELY AF C==          CUBIC SPLINE.  IF SIGM IS LARGE, (EG. 50.), THE RESULTING@ C==          CURVE IS NEARLY A POLYGONAL LINE.  A STANDARD VALUE C==          FOR SIGM IS 1. ? C==       2.)  XIN:  IS AN ARRAY OF THE NIN INCREASING ABCISSAE % C==          OF THE FUNCTIONAL VALUES D C==       3.)  YIN:  IS AN ARRAY OF THE NIN ORDINATES OF THE VALUES,= C==          (IE.YIN(K) IS THE FUNCTIONAL VALUE CORRESPONDING  C==          TO XIN(K)).? C==       4.)  NIN:  IS THE NUMBER OF VALUES TO BE INTERPOLATED  C==          (NIN.GE.2).B C==       5.)  XOUT:  IS AN ARRAY OF THE ABCISSAE OF THE NOUT OUT-D C==          PUT POINTS.  THE VALUES DO NOT HAVE TO BE IN INCREASING; C==          ORDER BUT THE PROGRAM RUNS FASTER IF THEY ARE. < C==       6.)  NOUT:  IS THE DESIRED NUMBER OF OUTPUT POINTSA C==       7.)  SLP1:  IS THE DESIRED SLOPE AT THE FIRST POINT AND A C==          IS OPTIONAL.  IF IT IS NOT INCLUDED IN THE PARAMETER = C==          LIST OF THE SUBROUTINE CALL THEN IT IS GENERATED  C==          INTERNALLY B C==       8.)  SLPN:  IS THE DESIRED SLOPE AT THE FINAL POINT.  IT# C==          IS OPTIONAL AS IN SLP1  C==    ON OUTPUT: @ C==       1.)  YOUT:  IS AN ARRAY OF THE NOUT ORDINATE VALUES OF$ C==          THE INTERPOLATED POINTSA C================================================================  C==   SUBPROGRAMS CALLED C== % C==   NAME      TYPE      EXPLANATION  C== ( C==   DABS      R*8       ABSOLUTE VALUE+ C==   DCOSH     R*8       HYPERBOLIC COSINE - C==   DFLOAT    R*8       CONVERTS I*4 TO R*8 ) C==   DSINH     R*8       HYPERBOLIC SINE , C==   DTANH     R*8       HYPERBOLIC TANGENTC C==   NPAR      I*4       DETERMINES NUMBER OF PARAMETERS PASSED IN + C==                         SUBROUTINE CALL  C== A C================================================================ A C================================================================ A C================================================================ A C================================================================  C==  DSPL1A  C== B C==    THIS ROUTINE CAN BE CALLED TO CALCULATE THE SPLINE FUNCTIONA C==    PARAMETERS WITHOUT CALCULATING ACTUAL INTERPOLATED POINTS. C C==    AFTER DSPL1A HAS BEEN CALLED, DSPL1B OR DSPL1C MAY BE CALLED D C==    TO EVALUATE INTERPOLATED POINTS, DERIVATIVES, INTEGRALS, ETC. C== ? C==    THE SUBROUTINE PARAMETERS FOR DSPL1A ARE THE SAME AS FOR ? C==    DSPL11 EXCEPT FOR THE EXCLUSION OF XOUT, YOUT, AND NOUT.  C== A C==    RETURN 1: IF INPUT DATA IS NOT MONOTONICALLY INCREASING == A C==              THEN THIS ROUTINE WILL RETURN 1.              == A C================================================================ A C================================================================ A C================================================================ A C================================================================  C==  DSPL1B  C== @ C==    NOTE: THIS ROUTINE DOES NOT CALCULATE THE SPLINE FUNCTIONC C==         PARAMETERS.  IT CALCULATES THE INTEGRAL, INTERPOLATION, C C==        FIRST DERIVATIVE, OR SECOND DERIVATIVE, DEPENDING ON THE D C==        INPUT VALUE OF IDERIV.  HOWEVER, DSPL11 OR DSPL1A MUST BED C==        CALLED FIRST TO CALCULATE THE SPLINE FUNCTION PARAMETERS. C==  C==    ON INPUT: C==       1.)  IDERIV:D C==            A) IF IDERIV=-1:  THE INTEGRAL FROM XIN(1) TO XOUT(J)7 C==                              IS RETURNED IN YOUT(J) E C==            B) IF IDERIV=0:   THE INTERPOLATED ORDINATE OF XOUT(J) 7 C==                              IS RETURNED IN YOUT(J) ? C==            C) IF IDERIV=1 : THE FIRST DERIVATIVE AT XOUT(J) 7 C==                             IS RETURNED IN YOUT (J) @ C==            D) IF IDERIV=2 : THE SECOND DERIVATIVE AT XOUT(J)6 C==                             IS RETURNED IN YOUT(J)D C==       2.)  XOUT:  IS AN ARRAY OF THE ABCISSAE OF THE NOUT OUTPUT@ C==          POINTS.  THE VALUES DO NOT HAVE TO BE IN INCREASING< C==          ORDER, BUT THE PROGRAM RUNS FASTER IF THEY ARE.= C==       3.)  NOUT:  IS THE NUMBER OF POINTS TO BE EVALUATED  C==    ON OUTPUT: C C==       1.)  YOUT:  IS AN ARRAY OF THE NOUT VALUES TO BE RETURNED  C==  C==    RETURN CODES: C== E C==       1.)  RETURN 11 :  DSPL1B WAS CALLED BEFORE DSPL11 OR DSPL1A  C==          - ERROR C== A C================================================================ A C================================================================ A C================================================================ A C================================================================  C==  C==  DSPL1C  C== A C==    THIS ROUTINE EVALUATES THE DEFINITE INTEGRAL OF THE INTER- D C==    POLATED CURVE BETWEEN TWO INPUT VALUED. THE SECOND VALUE DOES? C==    NOT HAVE TO BE GREATER THAN THE FIRST.  DSPL11 OR DSPL1A = C==    MUST BE CALLED PRIOR TO DSPL1C.  THE TWO ABCISSAE MUST 1 C==    BE WITHIN THE RANGE OF XIN(1) AND XIN(NIN)  C==  C==    ON INPUT:: C==       1.)  XLOW:  IS THE LOWER X VALUE, (NOT AN ARRAY); C==       2.)  XHI :  IS THE HIGHER X VALUE, (NOT AN ARRAY)  C==  C==    ON OUTPUT: / C==       1.)  YINTG:  IS THE DEFINITE INTEGRAL  C==  C==    RETURN CODES: C== C C==       1.)  RETURN 11 :  DSPL11 OR DSPL1A WERE NOT CALLED BEFORE  C==          DSPL1C - ERROR : C==       2.)  RETURN 2 :  XLOW OR XHI LESS THAN XIN(1) OR* C==          GREATER THAN XIN(NIN) - ERROR C== A C================================================================ A C================================================================ C CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC        IMPLICIT REAL*8(A-H,O-Z)
       SAVE       DATA EXPMAX/80./7       INTEGER I,IBACK,IBAK,N,NM1,NP1,NPAR,ILEVEL,NPARAM $       LOGICAL MONO,INIT,LARGE,ENDSLP       DATA INIT/.FALSE./       REAL SIGM,SLP1,SLPN @       REAL*8 C1,C2,C3,DELN,DELNM1,DELNN,DELS,DELX1,DELX12,DELX2,;      * DIAGIN,DIAG1,DIAG2,DX1,DX2,EXPS,SIGMA,SIGMAP,SINHIN, 5      * SINHS,SLPPN,SLPP1,SPDIAG,TEMP(5000),XIN(5000), 7      * YIN(5000),YP(5000),XOUT(5000),YOUT(5000),C(5000)        INIT=.FALSE.       ENDSLP=.TRUE.  C      NPARAM=NPAR(1)        NPARAM=7$       IF(NPARAM.LT.9) ENDSLP=.FALSE.       GOTO 5'       ENTRY DSPL1A(SIGM,XIN,YIN,NINT,*) A C================================================================ A C================================================================  C==  DSPL1A  C== B C==    THIS ROUTINE CAN BE CALLED TO CALCULATE THE SPLINE FUNCTIONA C==    PARAMETERS WITHOUT CALCULATING ACTUAL INTERPOLATED POINTS. C C==    AFTER DSPL1A HAS BEEN CALLED, DSPL1B OR DSPL1C MAY BE CALLED D C==    TO EVALUATE INTERPOLATED POINTS, DERIVATIVES, INTEGRALS, ETC. C== ? C==    THE SUBROUTINE PARAMETERS FOR DSPL1A ARE THE SAME AS FOR ? C==    DSPL11 EXCEPT FOR THE EXCLUSION OF XOUT, YOUT, AND NOUT.  C== A C==    RETURN 1: IF INPUT DATA IS NOT MONOTONICALLY INCREASING == A C==              THEN THIS ROUTINE WILL RETURN 1.              == A C==                                                            == A C================================================================ A C==  VAX users beware:                                         == A C==                                                            == A C==  N.B. The values of the dummy argument variables SIGM and  == A C==  NINT must be saved or they will be lost for future        == A C==  references (in DSPL1B, for example). In this routine, these= A C==  are saved as SIGMA and NIN respectively.                  == A C================================================================ A C================================================================        INIT=.TRUE.        ENDSLP=.TRUE.  C     NPARAM=NPAR(1)       NPARAM=4$       IF(NPARAM.LT.6) ENDSLP=.FALSE.     5 SIGMA=ABS(SIGM) $       IF(SIGMA.LT.1.D-4) SIGMA=1.D-4       NIN=NINT       NM1=NIN-1        NP1=NIN+1        DELX1=XIN(2)-XIN(1) !       IF(DELX1.LE.0.0D0) RETURN 1        DX1=(YIN(2)-YIN(1))/DELX1I C DETERMINE SLOPES IF NECESSARYY       IF(.NOT.ENDSLP) GOTO 50i       SLPP1=SLP1       SLPPN=SLPN C DENORMALIZE TENSION FACTOR2    10 SIGMAP=SIGMA*DFLOAT(NIN-1)/(XIN(NIN)-XIN(1)): C SET UP RIGHT HAND SIDE AND TRIDIAGONAL SYSTEM FOR YP AND C PERFORM FORWARDS ELIMINATION       DELS=SIGMAP*DELX1=       LARGE=DELS.GT.EXPMAX*       DIAG1=(DELS/DTANH(DELS)-1.0D0)/DELX1       DIAGIN=1.0D0/DIAG1       YP(1)=DIAGIN*(DX1-SLPP1):       IF(.NOT.LARGE) SPDIAG=(1.0D0-DELS/DSINH(DELS))/DELX1"       IF(LARGE) SPDIAG=1.0D0/DELX1       TEMP(1)=DIAGIN*SPDIAG        IF (NIN.EQ.2) GO TO 30       DO 20 I=2,NM1S         DELX2=XIN(I+1)-XIN(I)I#         IF(DELX2.LE.0.0D0) RETURN 1A#         DX2=(YIN(I+1)-YIN(I))/DELX2N         DELS=SIGMAP*DELX2        LARGE=DELS.GT.EXPMAX,         DIAG2=(DELS/DTANH(DELS)-1.0D0)/DELX23         DIAGIN=1.0D0/(DIAG1+DIAG2-SPDIAG*TEMP(I-1)) -         YP(I)=DIAGIN*(DX2-DX1-SPDIAG*YP(I-1))R<         IF(.NOT.LARGE) SPDIAG=(1.0D0-DELS/DSINH(DELS))/DELX2$         IF(LARGE) SPDIAG=1.0D0/DELX2         TEMP(I)=DIAGIN*SPDIAGE         DX1=DX2E         DIAG1=DIAG21    20 CONTINUE+    30 DIAGIN=1.0D0/(DIAG1-SPDIAG*TEMP(NM1)) 1         YP(NIN)=DIAGIN*(SLPPN-DX2-SPDIAG*YP(NM1))  C PERFORM BACK SUBSTITUTION        DO 40 I=2,NIN          IBAK=NP1-I.        YP(IBAK)=YP(IBAK)-TEMP(IBAK)*YP(IBAK+1)    40 CONTINUE
       GOTO 55     50 IF (NIN.EQ.2) GO TO 609 C IF NO DERIVATIVES ARE GIVEN USE SECOND ORDER POLYNOMIAL=6 C INTERPOLATION ON INPUT DATA FOR VALUES AT ENDPOINTS.         DELX2=XIN(3)-XIN(2)          DELX12=XIN(3)-XIN(1)'         C1=-(DELX12+DELX1)/DELX12/DELX1          C2=DELX12/DELX1/DELX2          C3=-DELX1/DELX12/DELX2+         SLPP1=C1*YIN(1)+C2*YIN(2)+C3*YIN(3)          DELN=XIN(NIN)-XIN(NM1)"         DELNM1=XIN(NM1)-XIN(NIN-2)!         DELNN=XIN(NIN)-XIN(NIN-2) "         C1=(DELNN+DELN)/DELNN/DELN         C2=-DELNN/DELN/DELNM1          C3=DELN/DELNN/DELNM13         SLPPN=C3*YIN(NIN-2)+C2*YIN(NM1)+C1*YIN(NIN)          GO TO 103 C IF ONLY TWO POINTS AND DERIVATIVES ARE GIVEN, USE  C STRAIGHT LINE FOR CURVE     60 YP(1)=0.D0       YP(2)=0.D0    55 IF(.NOT.INIT)GOTO 70       RETURN+       ENTRY DSPL1B(IDERIV,XOUT,YOUT,NOUT,*) A C================================================================ A C================================================================  C==  DSPL1B  C== @ C==    NOTE: THIS ROUTINE DOES NOT CALCULATE THE SPLINE FUNCTIONC C==         PARAMETERS.  IT CALCULATES THE INTEGRAL, INTERPOLATION, C C==        FIRST DERIVATIVE, OR SECOND DERIVATIVE, DEPENDING ON THE D C==        INPUT VALUE OF IDERIV.  HOWEVER, DSPL11 OR DSPL1A MUST BED C==        CALLED FIRST TO CALCULATE THE SPLINE FUNCTION PARAMETERS. C==  C==    ON INPUT: C==       1.)  IDERIV:D C==            A) IF IDERIV=-1:  THE INTEGRAL FROM XIN(1) TO XOUT(J)7 C==                              IS RETURNED IN YOUT(J) E C==            B) IF IDERIV=0:   THE iNTERPOLATED ORDINATE OF XOUT(J) 7 C==                              IS RETURNED IN YOUT(J) ? C==            C) IF IDERIV=1 : THE FIRST DERIVATIVE AT XOUT(J) 7 C==                             IS RETURNED IN YOUT (J) @ C==            D) IF IDERIV=2 : THE SECOND DERIVATIVE AT XOUT(J)6 C==                             IS RETURNED IN YOUT(J)D C==       2.)  XOUT:  IS AN ARRAY OF THE ABCISSAE OF THE NOUT OUTPUT@ C==          POINTS.  THE VALUES DO NOT HAVE TO BE IN INCREASING< C==          ORDER, BUT THE PROGRAM RUNS FASTER IF THEY ARE.= C==       3.)  NOUT:  IS THE NUMBER OF POINTS TO BE EVALUATED  C==    ON OUTPUT: C C==       1.)  YOUT:  IS AN ARRAY OF THE NOUT VALUES TO BE RETURNED  C==  C==    RETURN CODES: C== E C==       1.)  RETURN 11 :  DSPL1B WAS CALLED BEFORE DSPL11 OR DSPL1A  C==          - ERROR C== A C================================================================ A C================================================================        IF(.NOT.INIT) RETURN 1 C******************* C******************** C NOW FILL INTERPOLATED ARRAYS (XOUT,YOUT) C  C 
 70    IS=2       MONO=.TRUE.        IF(NOUT.EQ.0)GOTO 90       DO 65 J=2,NOUT5       IF(J.GE.2.AND.XOUT(J).LT.XOUT(J-1))MONO=.FALSE.  65    CONTINUE       IF(.NOT.INIT) GOTO 72        IF(IDERIV.GE.0) GOTO 72        DS=XIN(2)-XIN(1)%       IF(SIGMAP*DS.GT.EXPMAX) GOTO 68 B       C(1)=-(YP(2)-YP(1)*DCOSH(SIGMAP*DS))/SIGMAP/DSINH(SIGMAP*DS)-      # +(YIN(2)-YP(2))*XIN(1)*XIN(1)/2.0D0/DS 6      # -(YIN(1)-YP(1))*(XIN(2)-XIN(1)/2.0D0)*XIN(1)/DS
       GOTO 69 (    68 C(1)=YP(1)/DTANH(SIGMAP*DS)/SIGMAP-      # +(YIN(2)-YP(2))*XIN(1)*XIN(1)/2.0D0/DS 6      # -(YIN(1)-YP(1))*(XIN(2)-XIN(1)/2.0D0)*XIN(1)/DS    69 NINM1=NIN-1        DO 74 I=2,NINM1        DISM=XIN(I)-XIN(I-1)       DIS=XIN(I+1)-XIN(I) A       IF(SIGMAP*DISM.GT.EXPMAX .OR. SIGMAP*DIS.GT.EXPMAX) GOTO 73 B       DELC=-YP(I-1)*(1.D0/SIGMAP/DSINH(SIGMAP*DISM)+XIN(I)*XIN(I)/E      #DISM/2.D0)-YP(I+1)*(1.D0/SIGMAP/DSINH(SIGMAP*DIS)+XIN(I)*XIN(I) 0      #/DIS/2.D0)+YP(I)*(1.0D0/DTANH(SIGMAP*DISM)'      # +1.0D0/DTANH(SIGMAP*DIS))/SIGMAP G      #-YP(I)*((.5D0*XIN(I)-XIN(I-1))*XIN(I)/DISM-(XIN(I+1)-.5D0*XIN(I))       #*XIN(I)/DIS)B      #+(YIN(I+1)*XIN(I)*XIN(I)/2.D0-YIN(I)*(XIN(I+1)-XIN(I)/2.D0)*A      #XIN(I))/DIS+(YIN(I)*(XIN(I)/2.D0-XIN(I-1))*XIN(I)+YIN(I-1)*       #XIN(I)*XIN(I)/2.D0)/DISM
       GOTO 76 ,    73 DELC=-YP(I-1)*XIN(I)*XIN(I)/DISM/2.0D0+      #     -YP(1+1)*XIN(I)*XIN(I)/DIS/2.0D0 H      # + YP(I)*(1.0D0/DTANH(SIGMAP*DISM)+1.0D0/DTANH(SIGMAP*DIS))/SIGMAPG      #-YP(I)*((.5D0*XIN(I)-XIN(I-1))*XIN(I)/DISM-(XIN(I+1)-.5D0*XIN(I))       #*XIN(I)/DIS)B      #+(YIN(I+1)*XIN(I)*XIN(I)/2.D0-YIN(I)*(XIN(I+1)-XIN(I)/2.D0)*A      #XIN(I))/DIS+(YIN(I)*(XIN(I)/2.D0-XIN(I-1))*XIN(I)+YIN(I-1)*       #XIN(I)*XIN(I)/2.D0)/DISM    76 C(I)=C(I-1)+DELC 74    CONTINUE    72 DO 75 J=1,NOUT       IF(.NOT.MONO)IS=2        XT=XOUT(J)        IF(XT.LT.XIN(1)) XT=XIN(1)$       IF(XT.GT.XIN(NIN)) XT=XIN(NIN)       DO 80 I=IS,NIN       IF(XIN(I).GE.XT)GOTO 88  80    CONTINUE 88    DEL1=XT-XIN(I-1)       DEL2=XIN(I)-XT       DELS=XIN(I)-XIN(I-1)!       LARGE=SIGMAP*DELS.GT.EXPMAX        IF(.NOT.INIT)GOTO 92       IDERP2=IDERIV+2        GOTO(91,92,93,94),IDERP2 C  C INTEGRAL CURVE C     91 IF(LARGE) GOTO 81 D       YOUT(J)=(YP(I)*DCOSH(SIGMAP*DEL1)-YP(I-1)*DCOSH(SIGMAP*DEL2))/      #SIGMAP/DSINH(SIGMAP*DELS) 0      #+(YIN(I)-YP(I))*(XT/2.D0-XIN(I-1))*XT/DELS9      #+(YIN(I-1)-YP(I-1))*(XIN(I)-XT/2.D0)*XT/DELS+C(I-1) 
       GOTO 75 7    81 YOUT(J)=(YIN(I)-YP(I))*(XT/2.D0-XIN(I-1))*XT/DELS :      # +(YIN(I-1)-YP(I-1))*(XIN(I)-XT/2.D0)*XT/DELS+C(I-1)
       GOTO 75  C  C NORMAL INTERPOLATION C     92 IF(LARGE) GOTO 82 C       YOUT(J)=(YP(I)*DSINH(SIGMAP*DEL1)+YP(I-1)*DSINH(SIGMAP*DEL2)) G      */DSINH(SIGMAP*DELS)+((YIN(I)-YP(I))*DEL1+(YIN(I-1)-YP(I-1))*DEL2)       */DELS 
       GOTO 75 @    82 YOUT(J)=((YIN(I)-YP(I))*DEL1+(YIN(I-1)-YP(I-1))*DEL2)/DELS
       GOTO 75  C  C FIRST DERIVATIVE C     93 IF(LARGE) GOTO 83 C       YOUT(J)=(YP(I)*DCOSH(SIGMAP*DEL1)-YP(I-1)*DCOSH(SIGMAP*DEL2)) E      #*SIGMAP/DSINH(SIGMAP*DELS)+(YIN(I)-YP(I)-YIN(I-1)+YP(I-1))/DELS 
       GOTO 75 2    83 YOUT(J)=(YIN(I)-YP(I)-YIN(I-1)+YP(I-1))/DELS
       GOTO 75  C  C SECOND DERIVATIVE  C     94 IF(LARGE) GOTO 84 C       YOUT(J)=(YP(I)*DSINH(SIGMAP*DEL1)+YP(I-1)*DSINH(SIGMAP*DEL2)) '      #*SIGMAP*SIGMAP/DSINH(SIGMAP*DELS) 
       GOTO 75     84 YOUT(J)=0.0D0  75    CONTINUE 90    INIT=.TRUE.        RETURN C  C DEFINITE INTEGRAL  C &       ENTRY DSPL1C(XLOW,XHI,YINTG,*,*)A C================================================================ A C================================================================  C==  C==  DSPL1C  C== A C==    THIS ROUTINE EVALUATES THE DEFINITE INTEGRAL OF THE INTER- D C==    POLATED CURVE BETWEEN TWO INPUT VALUED. THE SECOND VALUE DOES? C==    NOT HAVE TO BE GREATER THAN THE FIRST.  DSPL11 OR DSPL1A = C==    MUST BE CALLED PRIOR TO DSPL1C.  THE TWO ABCISSAE MUST 1 C==    BE WITHIN THE RANGE OF XIN(1) AND XIN(NIN)  C==  C==    ON INPUT:: C==       1.)  XLOW:  IS THE LOWER X VALUE, (NOT AN ARRAY); C==       2.)  XHI :  IS THE HIGHER X VALUE, (NOT AN ARRAY)  C==  C==    ON OUTPUT: / C==       1.)  YINTG:  IS THE DEFINITE INTEGRAL  C==: C==    RETURN CODES: C==TC C==       1.)  RETURN 11 :  DSPL11 OR DSPL1A WERE NOT CALLED BEFORES C==          DSPL1C - ERRORD: C==       2.)  RETURN 2 :  XLOW OR XHI LESS THAN XIN(1) OR* C==          GREATER THAN XIN(NIN) - ERROR C==TA C================================================================SA C================================================================L       IF(.NOT.INIT) RETURN 1>       IF( (XLOW-XIN(1) )*( XLOW-XIN(NIN) ) .GT. 0.D0) RETURN 2<       IF( (XHI-XIN(1) )*( XHI-XIN(NIN) ) .GT. 0.D0) RETURN 2' C FIND WHICH INTERVALS CONTAIN XLOW,XHIL       DO 110 I=2,NIN@       IF( (XLOW-XIN(I-1) )*( XLOW-XIN(I) ) .LE. 0.D0 ) GO TO 120 110   CONTINUE 120   ILOW=I       DO 130 I=2,NIN>       IF( (XHI-XIN(I-1) )*( XHI-XIN(I) ) .LE. 0.D0 ) GO TO 140 130   CONTINUE 140   IHI=I 2 C NOW FILL THE C(I) ARRAY OF INTEGRATION CONSTANTS       DS=XIN(2)-XIN(1)&       IF(SIGMAP*DS.GT.EXPMAX) GOTO 168B       C(1)=-(YP(2)-YP(1)*DCOSH(SIGMAP*DS))/SIGMAP/DSINH(SIGMAP*DS)-      # +(YIN(2)-YP(2))*XIN(1)*XIN(1)/2.0D0/DS16      # -(YIN(1)-YP(1))*(XIN(2)-XIN(1)/2.0D0)*XIN(1)/DS       GOTO 169(   168 C(1)=YP(1)/DTANH(SIGMAP*DS)/SIGMAP-      # +(YIN(2)-YP(2))*XIN(1)*XIN(1)/2.0D0/DS-6      # -(YIN(1)-YP(1))*(XIN(2)-XIN(1)/2.0D0)*XIN(1)/DS   169 NINM1=NIN-1        DO 174 I=2,NINM1       DISM=XIN(I)-XIN(I-1)       DIS=XIN(I+1)-XIN(I)IB       IF(SIGMAP*DISM.GT.EXPMAX .OR. SIGMAP*DIS.GT.EXPMAX) GOTO 173B       DELC=-YP(I-1)*(1.D0/SIGMAP/DSINH(SIGMAP*DISM)+XIN(I)*XIN(I)/E      #DISM/2.D0)-YP(I+1)*(1.D0/SIGMAP/DSINH(SIGMAP*DIS)+XIN(I)*XIN(I)=0      #/DIS/2.D0)+YP(I)*(1.0D0/DTANH(SIGMAP*DISM)'      # +1.0D0/DTANH(SIGMAP*DIS))/SIGMAP G      #-YP(I)*((.5D0*XIN(I)-XIN(I-1))*XIN(I)/DISM-(XIN(I+1)-.5D0*XIN(I))T      #*XIN(I)/DIS)B      #+(YIN(I+1)*XIN(I)*XIN(I)/2.D0-YIN(I)*(XIN(I+1)-XIN(I)/2.D0)*A      #XIN(I))/DIS+(YIN(I)*(XIN(I)/2.D0-XIN(I-1))*XIN(I)+YIN(I-1)*0      #XIN(I)*XIN(I)/2.D0)/DISM       GOTO 176,   173 DELC=-YP(I-1)*XIN(I)*XIN(I)/DISM/2.0D0+      #     -YP(1+1)*XIN(I)*XIN(I)/DIS/2.0D0XH      # + YP(I)*(1.0D0/DTANH(SIGMAP*DISM)+1.0D0/DTANH(SIGMAP*DIS))/SIGMAPG      #-YP(I)*((.5D0*XIN(I)-XIN(I-1))*XIN(I)/DISM-(XIN(I+1)-.5D0*XIN(I))       #*XIN(I)/DIS)B      #+(YIN(I+1)*XIN(I)*XIN(I)/2.D0-YIN(I)*(XIN(I+1)-XIN(I)/2.D0)*A      #XIN(I))/DIS+(YIN(I)*(XIN(I)/2.D0-XIN(I-1))*XIN(I)+YIN(I-1)*1      #XIN(I)*XIN(I)/2.D0)/DISM   176 C(I)=C(I-1)+DELC 174   CONTINUE C FIND F(LOW)=YLOW       DEL1=XLOW-XIN(ILOW-1)N       DEL2=XIN(ILOW)-XLOW         DELS=XIN(ILOW)-XIN(ILOW-1)        LARGE=SIGMA*DELS.GT.EXPMAX@       IF(.NOT.LARGE)YLOW=(YP(ILOW)*DCOSH(SIGMAP*DEL1)-YP(ILOW-1)4      #*DCOSH(SIGMAP*DEL2))/SIGMAP/DSINH(SIGMAP*DELS)=      #+(YIN(ILOW)-YP(ILOW))*(XLOW/2.D0-XIN(ILOW-1))*XLOW/DELS=?      #+(YIN(ILOW-1)-YP(ILOW-1))*(XIN(ILOW)-XLOW/2.D0)*XLOW/DELS=      #+C(ILOW-1)E       IF(LARGE)YLOW=(YIN(ILOW)-YP(ILOW))*(XLOW/2.D0-XIN(ILOW-1))*XLOWCD      #/DELS+(YIN(ILOW-1)-YP(ILOW-1))*(XIN(ILOW)-XLOW/2.D0)*XLOW/DELS      #+C(ILOW-1) C FIND F(XHI)=YHI        DEL1=XHI-XIN(IHI-1)O       DEL2=XIN(IHI)-XHIO       DELS=XIN(IHI)-XIN(IHI-1)        LARGE=SIGMA*DELS.GT.EXPMAX=       IF(.NOT.LARGE)YHI=(YP(IHI)*DCOSH(SIGMAP*DEL1)-YP(IHI-1)C4      #*DCOSH(SIGMAP*DEL2))/SIGMAP/DSINH(SIGMAP*DELS)8      #+(YIN(IHI)-YP(IHI))*(XHI/2.D0-XIN(IHI-1))*XHI/DELSC      #+(YIN(IHI-1)-YP(IHI-1))*(XIN(IHI)-XHI/2.D0)*XHI/DELS+C(IHI-1)I?       IF(LARGE)YHI=(YIN(IHI)-YP(IHI))*(XHI/2.D0-XIN(IHI-1))*XHII?      #/DELS+(YIN(IHI-1)-YP(IHI-1))*(XIN(IHI)-XHI/2.D0)*XHI/DELS       #+C(IHI-1) # C RETURN DEFINITE INTEGRAL IN YINTGI       YINTG=YHI-YLOW       RETURN	       END 