;       SUBROUTINE DSPLXY(SIGMA,XIN,YIN,NIN,XOUT,YOUT,NOUT,*)  C  C     LIBRARY-ROUTINE  C = C                                                29/JULY/1980 > C                                                C.J. KOST SIN C $ C     reqd. KOSTL: routines - DSPL11 C A C================================================================ A C================================================================  C==  DSPLXY: C== ? C==    THIS ROUTINE INTERPOLATES A CURVE THROUGH AN ORDERED SET = C==    OF POINTS.  IT FIRST PARAMETERIZES THE POINTS IN TERMS : C==    OF NORMALIZED ARCLENGTH.  NORMALIZED LENGTH IN X IS= C==    REAL LENGTH DIVIDED BY THE RANGE OF X,(IE. THE MAXIMUM E C==    X VALUE OF INPUT POINTS MINUS THE MINIMUM).  NORMALIZED LENGTH D C==    IN Y IS REAL LENGTH DIVIDED BY THE RANGE OF Y,(IE THE MAXIMUMA C==    Y VALUE OF INPUT POINTS MINUS THE MINIMUM).  THE ARCLENGTH B C==    AT AN INPUT POINT IS APPROXIMATED BY THE SUM OF THE LENGTHS? C==    OF STRAIGHT LINES CONNECTING ALL POINTS UP TO THAT INPUT @ C==    POINT.  NEXT, A SPLINE WITH TENSION CURVE IS COMPUTED FORE C==    X VERSUS ARCLENGTH AND Y VERSUS ARCLENGTH.  FOR EQUALLY SPACED D C==    ARCLENGTH, X AND Y VALUES ARE INTERPOLATED SEPARATLY AND THEN& C==    COMBINED TO FORM OUTPUT POINTS. C== < C==    NOTE:  THE INTERPOLATION OF SPLINE WITH TENSION FOR X; C==         VERSUS ARCLENGTH AND Y VERSUS ARCLENGTH IS DONE 3 C==         BY SUBROUTINE DSPL11 IN TRIUMF LIBRARY.  C==  C==    ON INPUT: C== F C==       1.)  SIGMA: IS THE NORMALIZED TENSION FACTOR. IT CORRESPONDSE C==          TO THE CURVINESS DESIRED.  IT IS NONZERO AND ITS SIGN IS B C==          IGNORED.  IF SIGMA IS CLOSE TO ZERO (EG. 0.001), THENB C==          EACH INTERPOLATED FUNCTION - X VERSES ARCLENGTH AND Y@ C==          VERSUS ARCLENGTH - ARE ALMOST CUBIC SPLINES AND THEC C==          RESULTING PLOT IS QUITE CURVY.  IF SIGMA IS LARGE (EG. B C==          100), THEN THE INTERPOLATION BETWEEN POINTS IS ALMOST8 C==          LINEAR.  A STANDARD VALUE FOR SIGMA IS 1.0.E C==       2.)  XIN:  IS AN ARRAY OF THE X VALUES OF THE ORDERED INPUT * C==          POINTS (CONTAINS NIN VALUES).E C==       3.)  YIN:  IS AN ARRAY OF THE Y VALUES OF THE ORDERED INPUT * C==          POINTS (CONTAINS NIN VALUES).4 C==       4.)  NIN:  IS THE DIMENSION OF XIN AND YINA C==       5.)  NOUT: IS THE NUMBER OF DESIRED OUTPUT POINTS.  THE A C==          OUTPUT POINTS ARE APPROXIMATELY SPACED BY EQUAL ARC-  C==          LENGTH. C==  C==    ON OUTPUT:  C== E C==       1.)  XOUT:  IS AN ARRAY OF THE X VALUES OF THE INTERPOLATED + C==          POINTS (CONTAINS NOUT VALUES). E C==       2.)  YOUT:  IS AN ARRAY OF THE Y VALUES OF THE INTERPOLATED + C==          POINTS (CONTAINS NOUT VALUES).  C==  C==    SUBPROGRAMS CALLED: C== & C==    NAME      TYPE      EXPLANATION C== . C==    DFLOAT    R*8       CONVERTS I*4 TO R*8B C==    DSPL11               DOES SPLINE WITH TENSION INTERPOLATION0 C==                        FOR FUNCTIONAL VALUES& C==    DSQRT     R*8       SQUARE ROOT C==  C== A C================================================================ A C================================================================ C CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC        IMPLICIT REAL*8(A-H,O-Z)       INTEGER I,J,NIN,NOUT       REAL*4 SIGMA@       REAL*8 XIN(NIN),YIN(NIN),DIST(1000),XOUT(NOUT),YOUT(NOUT),      *SOUT(2000) C ' C  CALCULATE LENGTH NORMALIZING FACTORS  C        XMIN=XIN(1)        XMAX=XIN(1)        YMIN=YIN(1)        YMAX=YIN(1)        DO 5 J=2,NIN#       IF(XIN(J).LT.XMIN)XMIN=XIN(J) #       IF(XIN(J).GT.XMAX)XMAX=XIN(J) #       IF(YIN(J).LT.YMIN)YMIN=YIN(J) #       IF(YIN(J).GT.YMAX)YMAX=YIN(J)  5     CONTINUE       DELX=XMAX-XMIN       DELY=YMAX-YMIN C 8 C  CALCULATE ARCLENGTH PARAMETERIZATION FOR INPUT POINTS C        DIST(1)=0.0D0        DO 10 I=2,NIN *       DT=DSQRT(((XIN(I)-XIN(I-1))/DELX)**2$      # +((YIN(I)-YIN(I-1))/DELY)**2) 10    DIST(I)=DIST(I-1)+DT#       DELS=DIST(NIN)/DFLOAT(NOUT-1)  C ( C  CALCULATE ARCLENGTHS OF OUTPUT POINTS C        DO 50 I=1,NOUT       SOUT(I)=DFLOAT(I-1)*DELS 50    CONTINUE C > C  USE DSPL11 TO PERFORM SPLINE WITH TENSION INTERPOLATION FOR> C  FUNCTIONAL VALUES X VERSUS ARCLENGTH AND Y VERSUS ARCLENGTH C 9       CALL DSPL11(SIGMA,DIST,XIN,NIN,SOUT,XOUT,NOUT,&999) 9       CALL DSPL11(SIGMA,DIST,YIN,NIN,SOUT,YOUT,NOUT,&999)        RETURN 999   RETURN 1	       END 