?       SUBROUTINE ELLCON(ANGLE,A,B,AREA,R12,XINT,YINT,XMAX,YMAX,       * YATXM,XATYM)  C  C     LIBRARY-ROUTINE  C < C                                                05/AUG/1980> C                                                C.J. KOST SIN C  C     reqd. routines - NONE  C A C================================================================ A C==                                                            == A C==   ELLCON: CONVERTS THE INPUT ELLIPSE COORDINATES: ANGLE,A,B== A C==           INTO THE OUTPUT QUANTITIES: AREA,R12,XINT,YINT,  == A C==           XMAX,YMAX,YATXM,XATYM. THESE PARAMETERS ARE      == A C==           DESCRIBED BELOW:                                 == A C==                                                            == A C==   WRITTEN BY ARTHUR HAYNES, TRIUMF U.B.C., SEPT 1978.      == A C==                                                            == A C==   INPUT  PARAMETERS: ANGLE,A,B (R*4).                      == A C==   OUTPUT PARAMETERS: AREA,R12,XINT,YINT,XMAX,YMAX,YATXM,   == A C==                      XATYM (R*4).                          == A C==                                                            == A C==   ANGLE : ANGLE OF THE ELLIPSE SEMI-MAJOR AXIS A RELATIVE  == A C==           TO THE POSITIVE X-AXIS IN DEGREES.               == A C==   A     : SEMI-MAJOR AXIS OF THE ELLIPSE.                  == A C==   B     : SEMI-MINOR AXIS OF THE ELLIPSE.                  == A C==           NOTE: B MAY BE GREATER THAN A.                   == A C==   AREA  : AREA OF THE ELLIPSE = PI*A*B.                    == A C==                                                            == A C==   FOR THE FOLLOWING PARAMETERS THE X-AXIS AND Y-AXIS ARE   == A C==   ASSUMED TO PASS THROUGH THE CENTER OF THE ELLIPSE:       == A C==                                                            == A C==   R12   : CORRELATION COEFFICIENT OF THE ELLIPSE.          == A C==   XINT  : POSITIVE X-INTERCEPT OF THE ELLIPSE.             == A C==   YINT  : POSITIVE Y-INTERCEPT OF THE ELLIPSE.             == A C==           NOTE: EQUATION OF ELLIPSE IS:                    == A C==           X**2/XI**2-2*R12*X*Y/XI/YI+Y**2/YI**2 = 1        == A C==           WHERE XI = X-INTERCEPT, YI = Y-INTERCEPT.        == A C==   XMAX  : MAXIMUM X-COORDINATE OF THE ELLIPSE (X 1/2 WIDTH)== A C==   YMAX  : MAXIMUM Y-COORDINATE OF THE ELLIPSE (Y 1/2 WIDTH)== A C==   YATXM : Y COORDINATE OF THE ELLIPSE AT XMAX.             == A C==   XATYM : X COORDINATE OF THE ELLIPSE AT YMAX.             == A C==                                                            == A C==   THE ABOVE PARAMETERS ARE CALCULATED FROM ANGLE,A,B USING == A C==   THE FOLLOWING FORMULAS:                                  == A C==                                                            == A C==   AREA  = PI*A*B.                                          == A C==   XMAX  = SQRT((A*COS(ANGLE))**2+(B*SIN(ANGLE))**2).       == A C==   YMAX  = SQRT((A*SIN(ANGLE))**2+(B*COS(ANGLE))**2).       == A C==   XINT  = (A*B)/YMAX  IF YMAX .NE. 0.                      == A C==         = 0.          IF YMAX = 0.                         == A C==   YINT  = (A*B)/XMAX  IF XMAX .NE. 0.                      == A C==         = 0.          IF XMAX = 0.                         == A C==   R12   = SIGN*SQRT(1.-(A*B/XMAX/YMAX)**2),                == A C==           WHERE SIGN = SIGN(1.,SINCOS*(A**2-B**2))         == A C==                      = +1 OR -1 IF SINCOS*(A**2-B**2) NE 0.== A C==                      =  0       IF SINCOS*(A**2-B**2) =  0.== A C==               SINCOS = SIN(ANGLE) * COS(ANGLE).            == A C==                                                            == A C==   YATXM = R12*YMAX.                                        == A C==   XATYM = R12*XMAX.                                        == A C==                                                            == A C================================================================ A CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC        IMPLICIT REAL*8 (A-H,O-Z) =       REAL ANGLE,A,B,AREA,R12,XINT,YINT,XMAX,YMAX,YATXM,XATYM(*       DATA PI/3.14159265358979323846264D0/A C================================================================ A C==   CALCULATE AREA.                                          == A C================================================================-       AB=ABS(A*B)=       AREA=PI*ABA C================================================================ A C==   CALCULATE XMAX AND YMAX.                                 ==EA C================================================================T       ANGL=ANGLE*PI/180.D0       COSA=DCOS(ANGL)        SINA=DSIN(ANGL)Y       SINCOS=SINA*COSA
       ASQ=A*A 
       BSQ=B*BE       COSSQ=COSA*COSA        SINSQ=SINA*SINA=&       DXMAX=DSQRT(ASQ*COSSQ+BSQ*SINSQ)&       DYMAX=DSQRT(ASQ*SINSQ+BSQ*COSSQ)       XMAX=DXMAX       YMAX=DYMAXA C================================================================ A C==   CALCULATE XINT AND YINT.                                 == A C================================================================Y
       XINT=0. $       IF(DYMAX.GT.0.D0)XINT=AB/DYMAX
       YINT=0. $       IF(DXMAX.GT.0.D0)YINT=AB/DXMAXA C================================================================FA C==   CALCULATE R12.                                           ==PA C================================================================J       COEFF=0.D0;       IF(DXMAX*DYMAX.GT.0.D0)COEFF=1.D0-(AB/DXMAX/DYMAX)**2T!       IF(COEFF.LT.0.D0)COEFF=0.D0=       SIGNR=SINCOS*(ASQ-BSQ)       R12=0.9       IF(SIGNR.NE.0.D0)R12=DSQRT(COEFF)*DSIGN(1.D0,SIGNR)IA C================================================================ A C==   CALCULATE YATXM AND XATYM.                               ==EA C================================================================T       YATXM=R12*YMAX       XATYM=R12*XMAX       RETURN	       END 