1       SUBROUTINE ELLIPS(A,B,XC,YC,ANG,N,X,Y,NUSE)  C  C     LIBRARY-ROUTINE  C < C                                                05/AUG/1980> C                                                C.J. KOST SIN C  C    reqd. routines - NONE C G C====================================================================== G C====================================================================== G C==                                                                  == G C==  ELLIPS: RETURNS NUSE POINTS IN (X, Y) WHICH UNIFORMLY POPULATE  == G C==          THE PERIMETER OF THE ELLIPSE SPECIFIED BY THE MAJOR AND == G C==          MINOR AXES: A & B (RESPECTIVELY), THE X AND Y COORDINATES= G C==          OF THE CENTER OF THE ELLIPSE: XC AND YC, AND THE ANGLE  == G C==          OF ORIENTATION (W.R.T. THE X-AXIS): ANG.  N IS THE      == G C==          NUMBER OF POINTS WHICH ELLIPS TRYS TO PRODUCE, WHILE    == G C==          NUSE=N/4 * 4 IS THE ACTUAL NUMBER IT RETURNS IN (X,Y).  == G C==                                                                  == G C==  INPUT  PARAMETERS: A,B,XC,YC,ANG,N.                             == G C==                                                                  == G C==  OUTPUT PARAMETERS: X,Y,NUSE.                                    == G C==                                                                  == G C====================================================================== G C====================================================================== G C==                                                                  == G C==  SUBROUTINES CALLED:                                             == G C==                                                                  == G C==  NAME   TYPE                EXPLANATION                          == G C==                                                                  == G C==  COS    R*4         COSINE FUNCTION.                             == G C==  SIN    R*4         SINE FUNCTION.                               == G C==                                                                  == G C====================================================================== G C====================================================================== G C==                                                                  == G C==  VARIABLES:                                                      == G C==                                                                  == G C==  NAME   TYPE                EXPLANATION                          == G C==                                                                  == G C==  A      R*4         SEMI-MAJOR AXIS LENGTH.                      == G C==  ANG    R*4         ANGLE OF ORIENTATION W.R.T TO THE X-AXIS.    == G C==                     MEASURED IN DEGREES.                         == G C==  B      R*4         SEMI-MINOR AXIS LENGTH.                      == G C==  CANGR  R*4         COSINE OF ANG.                               == G C==  I      I*4         DO LOOP INDEX.                               == G C==  N      I*4         NUMBER OF POINTS ELLIPS TRYS TO POPULATE THE == G C==                     ELLIPSE WITH. ACTUAL NUMBER OF POINTS RETURN-== G C==                     ED IN X,Y IS NUSE=N/4*4.                     == G C==  ND2M1  I*4         N/2-1.                                       == G C==  ND4    I*4         N/4.                                         == G C==  ND4P1  I*4         N/4+1.                                       == G C==  NUSE   I*4         ACTUAL NUMBER OF POINTS USED TO POPULATE THE == G C==                     ELLIPSE. NUSE=N/4*4.                         == G C==  PI     R*4         WELL KNOWN CONSTANT: 3.14159265.             == G C==  SANGR  R*4         SINE OF ANGLE ANG.                           == G C==  THINC  R*4         THETA INCREMENT.                             == G C==  X      R*4(N)      NUSE X-COORDINATES OF THE ELLIPSE.           == G C==  XC     R*4         X-COORDINATE OF THE CENTER OF THE ELLIPSE.   == G C==  XX     R*4         X-COORDINATE OF THE ELLIPSE.                 == G C==  Y      R*4(N)      NUSE Y-COORDINATES OF THE ELLIPSE.           ==-G C==  YC     R*4         Y-COORDINATE OF THE CENTER OF THE ELLIPSE.   ==0G C==  YY     R*4         Y-COORDINATE OF THE ELLIPSE.                 == G C==                                                                  ===G C=======================================================================G C====================================================================== G CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCI       REAL X(N),Y(N)       PI=3.14159265E
       ND4=N/4H       NUSE=4*ND4       IF(ND4.EQ.0)RETURN       ND4P1=ND4+1E       THINC=PI/2./ND4,G C====================================================================== G C==                                                                  ==SG C==   POPULATE 1/4 OF THE ELLIPSE WITH N/4 POINTS IN QUADRANT 1 OF   ==YG C==   THE STANDARD COORDINATE SYSTEM FOR THE ELLIPSE.                ==RG C==                                                                  == G C======================================================================        DO 10 I=1,ND4P1=       X(I)=A*COS((I-1)*THINC)        Y(I)=B*SIN((I-1)*THINC)  10    CONTINUEG C=======================================================================G C==                                                                  ===G C==   POPULATE 1/4 OF THE ELLIPSE WITH N/4 POINTS IN QUADRANT 2 OF   ===G C==   THE STANDARD COORDINATE SYSTEM FOR THE ELLIPSE.                ===G C==                                                                  ===G C=======================================================================       DO 20 I=1,ND4        X(I+ND4P1)=-X(ND4P1-I)       Y(I+ND4P1)=Y(ND4P1-I)  20    CONTINUEG C====================================================================== G C==                                                                  ==OG C==   POPULATE THE BOTTOM 1/2 OF THE ELLIPSE WITH N/4*2 POINTS.      ==IG C==                                                                  == G C=======================================================================       ND2M1=2*ND4-1=       DO 30 I=1,ND2M1        X(I+ND4P1+ND4)=-X(I+1)       Y(I+ND4P1+ND4)=-Y(I+1) 30    CONTINUEG C====================================================================== G C==                                                                  == G C==   ROTATE THE ELLIPSE SO THAT IT HAS AN ORIENTATION ANGLE OF ANG  == G C==   DEGREES W.R.T THE X-AXIS OF THE NEW FRAME.                     == G C==   ALSO SHIFT THE ELLIPSE CENTER TO (XC,YC).                      == G C==                                                                  == G C======================================================================        CANGR=COS(ANG*PI/180.)       SANGR=SIN(ANG*PI/180.)       DO 40 I=1,NUSE
       XX=X(I) 
       YY=Y(I)        X(I)=CANGR*XX-SANGR*YY+XC        Y(I)=SANGR*XX+CANGR*YY+YC  40    CONTINUE       RETURN	       END=