>       SUBROUTINE EXEVAL(EXPRES,NEXP,FUNCTN,NARGUM,NFUN,VARIAB,9      * NINDEX,NVAR,OPERAT,IPRIOR,NOPER,ICODE,MCODE,NCODE, ;      * RCODE,MRCODE,NRCODE,ERROR,IERROR,MERROR,NERROR,IVAR,       * MIVAR,NIVAR,*) A C================================================================ A C================================================================ A C==   EXPRESSION EVALUATOR PACKAGE CONSISTS OF THE FOLLOWING   == A C==   GENERAL SUBROUTINES: EXEVAL, SCAN, CLASS, CTABL, EXRITE; == A C==   AND THE FOLLOWING SUBROUTINES SPECIFIC TO A STANDARD     == A C==   MATHEMATICAL AND LOGICAL EXPRESSION CALCULATOR: EXCALC,  == A C==   EXOPER, EXTABL.                                          ==  C==							       == E C== reqd. KOSTL: routines - CHREAL,EQCMP,EQUC,FINDC,IGC,MOVEC,SETC == A C================================================================ A C================================================================ A C==                                                            == A C==   EXEVAL: IS AN EXPRESSION EVALUATOR, I.E. IT CONVERTS THE == A C==   ARITHMETIC EXPRESSION "EXPRES" ("NEXP" CHARACTERS) INTO  == A C==   AN INTEGERIZED CODE "ICODE" WHICH IS IN REVERSE POLISH   == A C==   NOTATION.                                                == A C==   THE EXPRESSION "EXPRES" CONSISTS OF FUNCTIONS, VARIABLES,== A C==   AND BINARY OR UNARY OPERATORS, WHICH ARE DEFINED IN THE  == A C==   TABLES: "FUNCTN", "VARIAB", AND "OPERAT", RESPECTIVELY.  == A C==   THE EXPRESSION ALSO CONSISTS OF NUMBERS, PARENTHESES, OR == A C==   COMMAS. (NOTE: NUMBERS MAY HAVE EXPONENTS DENOTED BY "E" == A C==   OR "D". PARENTHESES "([{" ARE TREATED AS EQUIVALENT AND  == A C==   ")]}" ARE TREATED AS EQUIVALENT.)                        == A C==   THE CODE "ICODE" CAN LATER BE USED BY THE CALLING PROGRAM== A C==   TO CALCULATE THE VALUE OF THE EXPRESSION WITH APPROPRIATE== A C==   VALUES SUBSTITUTED IN FOR THE VARIABLES IN THE EXPRESSION== A C==   (FOR EXAMPLE: SEE "EXCALC").                             == A C==   "EXEVAL" ALSO HANDLES COMPLETE ERROR CHECKING OF THE     == A C==   EXPRESSION AND ON AN ERROR IT RETURNS (RETURN1) WITH THE == A C==   ERROR MESSAGES IN "ERROR".                               == A C==                                                            == A C==   WRITTEN BY ARTHUR HAYNES, TRIUMF U.B.C., JANUARY 3, 1980.== A C==                                                            == A C==   INPUT  PARAMETERS: EXPRES(NEXP) (L*1); NEXP (I*4);       == A C==   FUNCTN(NFUN) (R*8); NARGUM(2,NFUN), NFUN (I*4);          == A C==   VARIAB(NVAR) (R*8); NINDEX(NVAR),NVAR (I*4);             == A C==   OPERAT(NOPER) (R*8); IPRIOR(2,NOPER),                    == A C==   NOPER,MCODE,MRCODE,MERROR,MIVAR (I*4).                   == A C==                                                            == A C==   OUTPUT PARAMETERS: ICODE(2,NCODE) (I*2); NCODE (I*4);    == A C==   RCODE(NRCODE) (R*8); NRCODE (I*4); ERROR(50,NERROR) (L*1);= A C==   IERROR(2,NERROR),NERROR,IVAR(NIVAR),NIVAR (I*4).         == A C==                                                            == A C==   PARAMETER DEFINITIONS:                                   == A C==   --------- -----------                                    == A C==                                                            == A C==   EXPRES: "NEXP" CHARACTERS WHICH MAKE UP THE ENTIRE       == A C==           ARITHMETIC EXPRESSION TO BE EVALUATED.           == A C==           NOTE: "EXPRES" MAY HAVE BLANKS ANYWHERE IN THE   == A C==           EXPRESSION AND "EXPRES" IS NEVER CHANGED BY      == A C==           "EXEVAL".                                        == A C==                                                            == A C==   NEXP  : NUMBER OF CHARACTERS IN "EXPRES".                == A C==                                                            == A C==   FUNCTN: TABLE OF "NFUN" 8-CHARACTER FUNCTION NAMES, WHICH== A C==           CAN APPEAR IN THE EXPRESSION. NOTE: FOR SETTING  == A C==           UP A TABLE OF THE COMMON ARITHMETIC FUNCTION NAMES= A C==           SEE SUBROUTINE "EXTABL". THE FIRST CHARACTER IN  ==IA C==           THE FUNCTION NAMES MUST BE ALPHABETIC            ==RA C==           (A-Z,a-z,$,_) AND THE FOLLOWING CHARACTERS MUST  ==EA C==           BE ALPHA-NUMERIC (A-Z,a-z,$,_,0-9).              ===A C==           THE FUNCTION NAMES MUST BE LEFT-JUSTIFIED IN THE ===A C==           REAL*8 WORDS WITH NO IMBEDDED BLANKS.            ==XA C==                                                            ==EA C==   NARGUM: "NARGUM(1,I)" & "NARGUM(2,I)" (I=1,NFUN) ARE THE ==NA C==           LOWER & UPPER LIMITS ON THE NUMBER OF ARGUMENTS  ==AA C==           THE FUNCTION "FUNCTN(I)" IS ALLOWED TO HAVE.     ==XA C==           IN OTHER WORDS THE FUNCTION "FUNCTN(I)" IS ALLOWED=	A C==           TO HAVE "NARG" ARGUMENTS WHERE                   ==GA C==           "NARGUM(1,I)" <= NARG <= "NARGUM(2,I)".          ===A C==           NOTE: "NARGUM(1,I)" OR "NARGUM(2,I)" MAY ALSO BE ===A C==           ZERO.                                            == A C==           IF THE NUMBER OF ARGUMENTS THAT THE FUNCTION HAS == A C==           IN THE EXPRESSION DOESN'T AGREE WITH THE ABOVE   ==AA C==           THEN AN ERROR MESSAGE IS RETURNED (RETURN1) IN   ==EA C==           ERROR (NERROR.GT.0)                              == A C==                                                            ==NA C==   NFUN  : NUMBER OF FUNCTION NAMES WHICH ARE DEFINED IN THE==FA C==           FUNCTION TABLE "FUNCTN" & THE ARRAY "NARGUM".    ==EA C==                                                            ==RA C==   VARIAB: TABLE OF "NVAR" 8-CHARACTER VARIABLE NAMES WHICH ==EA C==           CAN APPEAR IN THE EXPRESSION. NOTE: THE FIRST    ==UA C==           CHARACTER IN THE VARIABLE NAMES MUST BE ALPHABETIC= A C==           AND THE FOLLOWING CHARACTERS MUST BE ALPHA-      ==AA C==           NUMERIC. VARIABLE NAMES CANNOT BE THE SAME AS    ==TA C==           FUNCTION NAMES BECAUSE VARIABLES MAY HAVE INDICES==TA C==           WHICH LOOK THE SAME AS FUNCTION ARGUMENTS.       == A C==           THE VARIABLE NAMES MUST BE LEFT-JUSTIFIED IN THE ==NA C==           REAL*8 WORDS WITH NO IMBEDDED BLANKS.            ==RA C==                                                            == A C==   NINDEX: IF "NINDEX(I)" (I=1,NVAR) IS => 0 THEN THE       == A C==           VARIABLE "VARIAB(I)" MUST HAVE "NINDEX(I)" INDICES=NA C==           TO BE VALID.                                     == A C==           IF "NINDEX(I)" IS < 0 THEN THE VARIABLE          == A C==           "VARIAB(I)" CAN HAVE EITHER "|NINDEX(I)|" OR 0   ==*A C==           INDICES.                                         ==;A C==           IF THE NUMBER OF INDICES THAT THE VARIABLE HAS IN== A C==           THE EXPRESSION DOESN'T AGREE WITH THE ABOVE THEN == A C==           AN ERROR MESSAGE IS RETURNED (RETURN1) IN "ERROR"== A C==           (NERROR.GT.0).                                   ==OA C==                                                            ==,A C==   NVAR  : NUMBER OF VARIABLE NAMES WHICH ARE DEFINED IN THE==IA C==           VARIABLE TABLE "VARIAB" & THE ARRAY "NINDEX".    == A C==                                                            == A C==   OPERAT: TABLE OF "NOPER" 8-CHARACTER OPERATOR NAMES WHICH== A C==           CAN APPEAR IN THE EXPRESSION.                    == A C==           NOTE: THE OPERATOR NAMES MUST BE LEFT-JUSTIFIED  == A C==           IN THE REAL*8 WORDS WITH NO IMBEDDED BLANKS.     ==EA C==           OPERATOR NAMES CAN BE ANY SET OF CHARACTERS      ==HA C==           (OTHER THAN QUOTES) DELIMITED BY QUOTES (' OR "),==AA C==           OR THEY CAN BE A STRING COMPRISED OF THE FOLLOWING= A C==           OPERATOR CHARACTERS: !#%&*:=~^`@;|\<>?/+-        == A C==           NOTE: FOR SETTING UP A TABLE OF THE STANDARD     == A C==           MATHEMATICAL AND LOGICAL OPERATORS SEE SUBROUTINE== A C==           "EXOPER".                                        ==NA C==                                                            == A C==   IPRIOR: TABLE OF "NOPER"*2 OPERATOR PRIORITIES WHICH     == A C==           GIVE THE PRECEDENCE OF THE OPERATOR, THE TYPE OF ==CA C==           THE OPERATOR (UNARY OR BINARY), AND THE          ==IA C==           ASSOCIATIVITY OF THE OPERATOR (LEFT OR RIGHT).   ==RA C==           IF "IPRIOR(1,I)" IS NON-ZERO THEN THE OPERATOR   == A C==           "OPERAT(I)" IS UNARY. IF "IPRIOR(2,I)" IS NON-   ==TA C==           ZERO THEN THE OPERATOR "OPERAT(I)" IS BINARY. IF ==SA C==           BOTH "IPRIOR(1,I)" & "IPRIOR(2,I)" ARE NON-ZERO  == A C==           THEN THE TYPE OF THE OPERATOR "OPERAT(I)" IS     ==NA C==           CHOSEN ACCORDING TO THE POSITION OF THE OPERATOR ==OA C==           IN THE EXPRESSION FOR EACH OCCURANCE OF THE      == A C==           OPERATOR.                                        ==(A C==           THE MAGNITUDE OF "IPRIOR(K,I)" (K=1,2), IF NON-  == A C==           ZERO, IS THE VALUE OF THE PRECEDENCE OF THE K'TH ==IA C==           TYPE OF OPERATOR "OPERAT(I)" (WHERE THE 1'ST TYPE=="A C==           IS UNARY AND THE 2'ND TYPE IS BINARY). OPERATORS == A C==           AT THE SAME LEVEL WITHIN PARENTHESES ARE EVALUATED= A C==           IN ORDER OF THEIR PRECEDENCE; THE ONES WITH HIGHER=HA C==           PRECEDENCE BEING EVALUATED FIRST.                ==RA C==           IF "IPRIOR(K,I)" (K=1 OR 2) IS POSITIVE THEN THE == A C==           UNARY (IF K=1) OR BINARY FORM (IF K=2) OF THE    == A C==           OPERATOR "OPERAT(I)" IS LEFT-ASSOCIATIVE.        ==DA C==           IF "IPRIOR(K,I)" (K=1 OR 2) IS NEGATIVE THEN THE == A C==           UNARY (IF K=1) OR BINARY FORM (IF K=2) OF THE    == A C==           OPERATOR "OPERAT(I)" IS RIGHT-ASSOCIATIVE.       ==EA C==           IF A SEQUENCE OF CONSECUTIVE OPERATORS AT THE    == A C==           SAME LEVEL WITHIN PARENTHESES HAVE THE SAME      ==TA C==           PRECEDENCE AND ARE ALL LEFT (RIGHT) ASSOCIATIVE  ==EA C==           THEN THEY ARE EVALUATED LEFT TO RIGHT (RIGHT TO  ==HA C==           LEFT). EXAMPLE: MULTIPLICATION AND DIVISION:     ==YA C==           "*" & "/" ARE USUALLY LEFT-ASSOCIATIVE AND AT THE==UA C==           SAME PRECEDENCE, WHILE EXPONENTIATION "**" IS    ==TA C==           USUALLY RIGHT-ASSOCIATIVE.                       ==SA C==           NOTE: AN AMBIGUITY OCCURS IF 2 OPERATORS HAVE THE== A C==           SAME PRECEDENCE BUT OPPOSITE ASSOCIATIVITIES.    ==HA C==           IN THIS CASE "EXEVAL" ALWAYS TREATS THE RIGHT-   ==DA C==           ASSOCIATIVE OPERATOR AS HAVING A HIGHER PRECEDENCE= A C==           THEN THE LEFT-ASSOCIATIVE OPERATOR. EXAMPLE:     ==AA C==           IF "+" IS LEFT-ASSOCIATIVE AND "-" IS RIGHT-     ==XA C==           ASSOCIATIVE AND THEY ARE AT THE SAME PRECEDENCE  == A C==           THEN THE EXPRESSION "A+B+C-D-E+F-E" IS EVALUATED ==AA C==           AS FOLLOWS: "(((A+B)+(C-(D-E)))+(F-E))".         ==HA C==                                                            ==NA C==   NOPER : NUMBER OF OPERATOR NAMES WHICH ARE DEFINED IN THE== A C==           OPERATOR TABLE "OPERAT" AND THE ARRAY "IPRIOR".  == A C==                                                            ==DA C==   ICODE : ARRAY OF "NCODE"*2 INTEGER*2 CODES WHICH CORRE-  == A C==           SPOND TO THE REVERSE POLISH FORM OF THE ARITHMETIC= A C==           EXPRESSION "EXPRES". THE CODES ARE AS FOLLOWS,   ==OA C==           N=1,NCODE:                                       == A C==                                                            ==FA C==    ICODE(2,N)    ICODE(1,N)      DESCRIPTION               ==DA C==                                                            ==AA C== 1)    -I          TYPE K         OPERATER: OPERAT(I)       ==OA C==     I=1,NOPER     K=1,2          K=1: UNARY, K=2: BINARY   ==FA C==                                                            ==<A C== 2)     I          NARG           FUNCTION: FUNCTN(I)       == A C==     I=1,NFUN                     NARG=NUMBER OF ARGUMENTS  ==SA C==                                                            == A C== 3)   I+NFUN       NINDEX         VARIABLE: VARIAB(I)       == A C==     I=1,NVAR                     NINDEX=NUMBER OF INDICES  ==IA C==                                                            ==,A C== 4) I+NFUN+NVAR     --            REAL*8 CONSTANT: RCODE(I) == A C==    I=1,NRCODE                                              == A C==                                                            ==HA C==   MCODE : MAXIMUM NUMBER OF CODES ALLOWED IN "ICODE".      ==IA C==           IF "MCODE" = "NEXP" THEN "ICODE" IS ALWAYS LARGE ==IA C==           ENOUGH TO EVALUATE "EXPRES".                     ==AA C==                                                            ==AA C==   NCODE : NUMBER OF CODES RETURNED IN "ICODE". NCODE<=MCODE== A C==                                                            ==EA C==   RCODE : ARRAY OF "NRCODE" REAL*8 CONSTANTS WHICH APPEAR  == A C==           IN THE EXPRESSION. SEE DESCRIPTION TABLE 4) OF   ==,A C==           "ICODE".                                         ==EA C==                                                            == A C==   MRCODE: MAXIMUM NUMBER OF REAL*8 CONSTANTS ALLOWED IN    ==YA C==           "RCODE". IF "MRCODE" = "NEXP" THEN "RCODE" IS    ==SA C==           ALWAYS LARGE ENOUGH TO EVALUATE "EXPRES".        ==NA C==                                                            == A C==   NRCODE: NUMBER OF REAL*8 CONSTANTS RETURNED IN "RCODE".  ==TA C==           NRCODE <= MRCODE.                                ===A C==                                                            ==AA C==   ERROR : ARRAY OF "NERROR" 50-CHARACTER ERROR MESSAGES.   ==TA C==           "ERROR(J,I),J=1,50" IS THE I'TH ERROR MESSAGE.   ===A C==           ON AN ERROR A RETURN1 IS PERFORMED.              ==IA C==                                                            ==OA C==   IERROR: "IERROR(1,I)", I=1,NERROR IS THE ERROR NUMBER    ==TA C==           CORRESPONDING TO THE ERROR MESSAGE IN            == A C==           "ERROR(J,I)", J=1,50. (SEE BELOW UNDER "ERROR    ==HA C==           MESSAGES"). "IERROR(2,I)" IS THE CHARACTER       ==DA C==           POSITION IN THE EXPRESSION "EXPRES" AT WHICH THE ==IA C==           ERROR OCCURED.                                   ==OA C==           NOTE: "IERROR(2,I)",I=1,NERROR IS AN ARRAY WHICH == A C==           IS ALWAYS IN INCREASING ORDER, SO THAT ONE CAN,  ==AA C==           FOR EXAMPLE, WRITE OUT THE EXPRESSION AND PUT "$"==AA C==           SIGNS UNDER EACH ERROR AT THE POSITIONS GIVEN BY == A C==           "IERROR(2,I)",I=1,NERROR, AND THEN WRITE OUT THE ==GA C==           ERROR MESSAGES "ERROR(J,I)",J=1,50,I=1,NERROR IN == A C==           THE RIGHT ORDER UNDERNEATH.                      ==IA C==                                                            ==EA C==   MERROR: MAXIMUM NUMBER OF 50-CHARACTER ERROR MESSAGES    == A C==           ALLOWED. IF THIS NUMBER IS EXCEEDED THEN "EXEVAL"==EA C==           PERFORMS A "RETURN1" WITH "NERROR"="MERROR"      == A C==           MESSAGES IN "ERROR".                             ==DA C==                                                            ==AA C==   NERROR: NUMBER OF ERROR MESSAGES IN "ERROR".             == A C==                                                            ==WA C==   IVAR  : ARRAY OF "NIVAR" INDICES SPECIFYING WHICH        == A C==           VARIABLES IN THE VARIABLE TABLE "VARIAB" WERE    ==AA C==           USED IN THE EXPRESSION. NO INDEX IN "IVAR" APPEARS= A C==           TWICE, I.E. THE VARIABLES SPECIFIED BY THE INDICES= A C==           IN "IVAR" ARE DISTINCT.                          == A C==                                                            == A C==   MIVAR : MAXIMUM NUMBER OF INDICES WHICH CAN BE STORED IN ==EA C==           THE ARRAY "IVAR", I.E. THE MAXIMUM NUMBER OF     ==KA C==           DISTINCT VARIABLES WHICH CAN APPEAR IN THE       == A C==           EXPRESSION.                                      ==NA C==           IF "MIVAR" <= 0 THEN "IVAR" & "NIVAR" ARE IGNORED.=OA C==                                                            == A C==   NIVAR : THE NUMBER OF INDICES RETURNED IN "IVAR".        ==RA C==                                                            ==RA C==   RETURN CODES:                                            == A C==   ------ -----                                             ==AA C==                                                            == A C==   RETURN1: OCCURS IF ONE OR MORE ERRORS OCCUR IN THE       == A C==            EXPRESSION "EXPRES". IN THIS CASE "NERROR" > 0. =="A C==                                                            == A C==   ERROR MESSAGES:                                          == A C==   ----- --------                                           == A C==                                                            ==.A C==   ERROR #     ERROR MESSAGE                                == A C==                                                            ==WA C==       1       INVALID CHARACTER                            ==TA C==       2       NO CLOSING QUOTE ON OPERATOR                 == A C==       3       INVALID DECIMAL POINT                        == A C==       4       INVALID EXPONENT                             ==AA C==       5       EXPRESSION TOO LARGE                         =="A C==               (THIS MESSAGE OCCURS WHEN THE "ICODE" ARRAY  ==PA C==                IS NOT LARGE ENOUGH TO CONTAIN THE          == A C==                EXPRESSION).                                == A C==       6       NAME > 8 CHARACTERS                          == A C==       7       "NAME" IS AN UNDEFINED FUNCTION              == A C==               ("NAME" IS 8 CHARACTERS; THIS MESSAGE ONLY   ==RA C==                OCCURS IF "NAME" IS FOLLOWED BY "(".)       ==OA C==       8       "NAME" IS AN UNDEFINED VARIABLE              == A C==               ("NAME" IS 8 CHARACTERS; THIS MESSAGE ONLY   == A C==                OCCURS IF "NAME" IS NOT FOLLOWED BY "(".)   ==RA C==       9       TOO MANY VARIABLES                           ==IA C==               (THIS MESSAGE OCCURS WHEN THE "IVAR" ARRAY   ==DA C==                IS NOT LARGE ENOUGH TO CONTAIN ALL OF THE   ==AA C==                DISTINCT VARIABLES IN THE EXPRESSION).      == A C==      10       INVALID REAL NUMBER                          == A C==               (THIS ERROR MESSAGE SHOULD NEVER OCCUR).     ==NA C==      11       TOO MANY CONSTANTS                           ==HA C==               (THIS MESSAGE OCCURS WHEN THE "RCODE" ARRAY  ==OA C==                IS NOT LARGE ENOUGH TO CONTAIN ALL OF THE   ==IA C==                CONSTANTS IN THE EXPRESSION).               ==WA C==      12       OPERATOR > 8 CHARACTERS                      ==IA C==      13       UNDEFINED OPERATOR                           == A C==      14       BLANK EXPRESSION                             == A C==      15       ")" HAS NO LEADING "("                       ==RA C==      16       "(" HAS NO FOLLOWING ")"                     == A C==      17       OPERATOR STACK OVERFLOW                      =="A C==               (THIS MESSAGE OCCURS IF THE OPERATOR STACK   == A C==                INTEGER*2 STACK(2,100) OVERFLOWS WHEN       == A C==                CONVERTING ICODE INTO REVERSE POLISH; STACK ==.A C==                CAN CONTAIN A MAXIMUM OF 100 OPERATORS)     == A C==      18       INVALID COMMA                                == A C==      19       FUNCTION HAS WRONG NUMBER OF ARGUMENTS       ==RA C==      20       VARIABLE HAS WRONG NUMBER OF INDICES         == A C==                                                            == A C==   SEQUENCING ERROR MESSAGES:                               == A C==   ---------- ----- --------                                == A C==                                                            == A C==   THE FOLLOWING ERROR MESSAGES RELATE TO THE SEQUENCING OF ==NA C==   THE TERMS IN THE EXPRESSION WHERE THE TERMS ARE DEFINED  == A C==   AS FOLLOWS:                                              == A C==                                                            ==RA C==   TERM 1:  FUNCTION                                        == A C==   TERM 2:  VARIABLE                                        ==IA C==   TERM 3:  CONSTANT                                        == A C==   TERM 4:  ")", "]", OR "}"                                == A C==   TERM 5:  "(", "[", OR "{"                                == A C==   TERM 6:  ","                                             == A C==   TERM 7:  NULL (WHICH REFERS TO THE BEGINNING OR END OF   == A C==                  THE EXPRESSION)                           =="A C==   TERM 8:  UNARY  OPERATOR                                 == A C==   TERM 9:  BINARY OPERATOR                                 == A C==                                                            == A C==   IF "TERM I" IS FOLLOWED BY "TERM J" IN THE EXPRESSION AND== A C==   THIS IS NOT ALLOWED, THEN AN ERROR MESSAGE IS RETURNED IN== A C==   ERROR WHICH LOOKS LIKE: "TERM I FOLLOWED BY TERM J", WITH== A C==   "TERM I" AND "TERM J" REPLACED BY THEIR NAMES ABOVE. THE == A C==   ERROR NUMBER FOR THIS MESSAGE IS: 100+10*I+J.            == A C==                                                            == A C==   ERROR #     ERROR MESSAGE                                == A C==                                                            == A C==     113       FUNCTION FOLLOWED BY CONSTANT                ==IA C==     118       FUNCTION FOLLOWED BY UNARY OPERATOR          == A C==     123       VARIABLE FOLLOWED BY CONSTANT                == A C==     128       VARIABLE FOLLOWED BY UNARY OPERATOR          == A C==     131       CONSTANT FOLLOWED BY FUNCTION                == A C==     132       CONSTANT FOLLOWED BY VARIABLE                ==EA C==     133       CONSTANT FOLLOWED BY CONSTANT                ==YA C==     135       CONSTANT FOLLOWED BY "("                     == A C==     138       CONSTANT FOLLOWED BY UNARY OPERATOR          ==EA C==     141       ")" FOLLOWED BY FUNCTION                     ==EA C==     142       ")" FOLLOWED BY VARIABLE                     == A C==     143       ")" FOLLOWED BY CONSTANT                     ==IA C==     145       ")" FOLLOWED BY "("                          == A C==     148       ")" FOLLOWED BY UNARY OPERATOR               ==EA C==     154       "(" FOLLOWED BY ")"                          == A C==     156       "(" FOLLOWED BY ","                          ==RA C==     157       "(" FOLLOWED BY NULL                         == A C==     159       "(" FOLLOWED BY BINARY OPERATOR              ==RA C==     164       "," FOLLOWED BY ")"                          == A C==     166       "," FOLLOWED BY ","                          == A C==     167       "," FOLLOWED BY NULL                         == A C==     169       "," FOLLOWED BY BINARY OPERATOR              == A C==     174       NULL FOLLOWED BY ")"                         == A C==     176       NULL FOLLOWED BY ","                         == A C==     179       NULL FOLLOWED BY BINARY OPERATOR             == A C==     184       UNARY OPERATOR FOLLOWED BY ")"               == A C==     186       UNARY OPERATOR FOLLOWED BY ","               ==RA C==     187       UNARY OPERATOR FOLLOWED BY NULL              ==WA C==     188       UNARY OPERATOR FOLLOWED BY UNARY OPERATOR    ==PA C==     189       UNARY OPERATOR FOLLOWED BY BINARY OPERATOR   ==PA C==     194       BINARY OPERATOR FOLLOWED BY ")"              == A C==     196       BINARY OPERATOR FOLLOWED BY ","              ==GA C==     197       BINARY OPERATOR FOLLOWED BY NULL             ==DA C==     198       BINARY OPERATOR FOLLOWED BY UNARY OPERATOR   == A C==     199       BINARY OPERATOR FOLLOWED BY BINARY OPERATOR  == A C==                                                            == A C================================================================ A C================================================================S%       LOGICAL*1 EXPRES(1),ERROR(50,1)E3       REAL*8 FUNCTN(1),VARIAB(1),OPERAT(1),RCODE(1)S0       INTEGER NARGUM(2,1),NINDEX(1),IPRIOR(2,1),      * IERROR(2,1),IVAR(1)(       INTEGER*2 ICODE(2,1),ISTACK(2,100)7       LOGICAL*1 TERM(15,9),NFIRST/.FALSE./,FUNC,NAME(8)        LOGICAL*1 NFIRS/.FALSE./+       INTEGER LTERM(9)/8,8,8,3,3,3,4,14,15/        LOGICAL EQUC,EQCMP       REAL*8 REAL8       EXTERNAL CLASSA C================================================================ A C==   LEXICAL SCANNER TRANSITION TABLE: STABLE(10,13).         == A C==   THIS TABLE HAS 10 STATES AND 13 CLASSES OF CHARACTERS.   == A C==   THE DESCRIPTION OF THE TABLE IS AS FOLLOWS:              ==FA C==                                                            == A C==                                 STATE #                    == A C==             1    2    3    4    5    6    7    8    9   10 == A C== CLASS                                                      == A C== EOL        -7   -1 -102   -8   -3 -103   -3 -104 -104   -3 == A C== OTHERS    101   -1    3   -8   -3 -103   -3 -104 -104   -3 ==DA C== BLANK       1    2    3    4    5    6    7    8    9   10 ==WA C== A-C,F-Z     2    2    3   -8   -3 -103   -3 -104 -104   -3 ==TA C== E,D         2    2    3   -8    8 -103    8 -104 -104   -3 == A C== 0-9         5    2    3   -8    5    7    7   10   10   10 == A C== .           6   -1    3   -8    7 -103   -3 -104 -104   -3 == A C== )]}        54   -1    3   -8   -3 -103   -3 -104 -104   -3 == A C== ([{        55   -1    3   -8   -3 -103   -3 -104 -104   -3 == A C== ,          56   -1    3   -8   -3 -103   -3 -104 -104   -3 == A C== '"          3   -1   58   -8   -3 -103   -3 -104 -104   -3 == A C== +-          4   -1    3    4   -3 -103   -3    9 -104   -3 == A C== OP.CHARS    4   -1    3    4   -3 -103   -3 -104 -104   -3 == A C==                                                            == A C==   (OP.CHARS: OPERATOR CHARACTERS).                         == A C==   (FOR A LEXICAL SCANNER FLOW CHART SEE TRMF:OPDATA NOTES).== A C==                                                            == A C==   IF 1 <= "STABLE(ISTATE,ICLASS)" <= 10 THEN IT IS A       == A C==   TRANSITION STATE.                                        == A C==   IF "STABLE(ISTATE,ICLASS)" < 1 THEN IT IS AN OUTPUT STATE== A C==   AND THE SCAN POINTER IS TO BE SHIFTED BACK BY 1.         == A C==   IF "STABLE(ISTATE,ICLASS)" > 10 THEN IT IS AN OUTPUT     == A C==   STATE AND THE SCAN POINTER IS NOT TO BE CHANGED.         == A C==                                                            == A C==   OUTPUT STATES:                                           == A C==                                                            == A C==   STATE #    DESCRIPTION                                   == A C==                                                            == A C==      -1      VARIABLE OR FUNCTION NAME                     == A C==      -3      CONSTANT NUMBER                               == A C==      54      RIGHT PARENTHESIS ")"                         == A C==      55      LEFT  PARENTHESIS "("                         == A C==      56      COMMA ","                                     == A C==      -7      END-OF-LINE (NULL)                            == A C==      58      OPERATOR                                      == A C==      -8      OPERATOR                                      == A C==     101      INVALID CHARACTER                             == A C==    -102      NO CLOSING QUOTE ON OPERATOR                  ==RA C==    -103      INVALID DECIMAL POINT                         == A C==    -104      INVALID EXPONENT                              == A C==                                                            == A C================================================================R       INTEGER*2 STABLE(10,13)/8      *  -7,  -1,-102,  -8,  -3,-103,  -3,-104,-104,  -3,8      * 101,  -1,   3,  -8,  -3,-103,  -3,-104,-104,  -3,8      *   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,8      *   2,   2,   3,  -8,  -3,-103,  -3,-104,-104,  -3,8      *   2,   2,   3,  -8,   8,-103,   8,-104,-104,  -3,8      *   5,   2,   3,  -8,   5,   7,   7,  10,  10,  10,8      *   6,  -1,   3,  -8,   7,-103,  -3,-104,-104,  -3,8      *  54,  -1,   3,  -8,  -3,-103,  -3,-104,-104,  -3,8      *  55,  -1,   3,  -8,  -3,-103,  -3,-104,-104,  -3,8      *  56,  -1,   3,  -8,  -3,-103,  -3,-104,-104,  -3,8      *   3,  -1,  58,  -8,  -3,-103,  -3,-104,-104,  -3,8      *   4,  -1,   3,   4,  -3,-103,  -3,   9,-104,  -3,8      *   4,  -1,   3,   4,  -3,-103,  -3,-104,-104,  -3/       INTEGER*2 CTABLE(256),A C================================================================CA C==   DEFINE NFUN2,NVAR2,NOPER2 TO BE => 0.                    == A C================================================================        NFUN2=MAX0(NFUN,0)       NVAR2=MAX0(NVAR,0)       NOPER2=MAX0(NOPER,0)A C================================================================0A C==   INITIALIZE NCODE,NRCODE,NIVAR,NERROR.                    == A C==   NIVAR IS ONLY INITIALIZED IF THERE ARE 24 PARAMETERS.    ==3A C================================================================3
       NCODE=0        NRCODE=0
       NIVAR=06       NERROR=0       IF(NFIRS)GO TO 120A C================================================================ A C==   FIRST TIME THROUGH SUBROUTINE "EXEVAL".                  == A C==   CALL "CTABL" WHICH INITIALIZES THE INTEGER*2 CLASS TABLE == A C==   "CTABLE(256)" WHICH IS USED BY THE EXPRESSION EVALUATOR  ==5A C==   LEXICAL SCANNER TRANSITION TABLE "STABLE".               ==5A C================================================================5       NFIRS=.TRUE.       CALL CTABL(CTABLE)A C================================================================3A C==   LOOP FOR SCANNING THE EXPRESSION "EXPRES" FOR TERMS.     ==3A C==   "SCAN" IS A SUBROUTINE WHICH PERFORMS A LEXICAL SCAN     ==3A C==   USING THE TRANSITION TABLE "STABLE" DESCRIBED ABOVE.     == A C==   "IFIRST" IS THE "FIRST" POINTER TO THE COLUMN IN "EXPRES"== A C==   AT WHICH THE SCAN IS TO BE STARTED.                      ==)A C==   "ILAST" IS THE "LAST" POINTER TO THE COLUMN IN "EXPRES"  == A C==   AT WHICH THE SCAN IS ENDED.                              == A C==   "IFIRST" IS INPUT TO SCAN. "ILAST" IS RETURNED BY SCAN.  == A C==   THE TERM FOUND RESIDES BETWEEN POINTERS "IFIRST" AND     ==TA C==   "ILAST".                                                 == A C==   "ISTATE" IS THE OUTPUT STATE RETURNED BY "SCAN" WHICH    == A C==   DENOTES WHAT TYPE OF TERM RESIDES BETWEEN POINTERS       == A C==   "IFIRST" AND "ILAST".                                    == A C==   "CLASS" IS THE NAME OF THE EXTERNAL SUBROUTINE WHICH     == A C==   RETURNS THE CLASS CORRESPONDING TO EACH CHARACTER IN     == A C==   "EXPRES".                                                == A C================================================================ 
 120   ILAST=0- 1000  IFIRST=ILAST+1"       IF(IFIRST.GT.NEXP)GO TO 3000G       CALL SCAN(EXPRES,NEXP,IFIRST,ILAST,ISTATE,CLASS,CTABLE,STABLE,10) A C================================================================ A C==   IF "ISTATE" = -7, I.E. ON AN END-OF-LINE, STOP SCANNING  == A C==   AND GO TO 3000.                                          == A C================================================================         IF(ISTATE.EQ.-7)GO TO 3000A C================================================================ A C==   ERROR 5: EXPRESSION TOO LARGE, "NCODE" => "MCODE".       == A C================================================================E       IERR=5"       IF(NCODE.GE.MCODE)GO TO 2000       NCODE=NCODE+1 A C================================================================ A C==   FIND THE FIRST NON-BLANK CHARACTER IN THE TERM FOUND     == A C==   BETWEEN POINTERS "IFIRST" AND "ILAST" IN "EXPRES" AND SET===A C==   "IFIRST" TO THE COLUMN FOUND.                            == A C==   SET "ICODE(1,NCODE)" TO "IFIRST". IF THERE IS AN ERROR   == A C==   ASSOCIATED WITH THIS TERM THEN THIS POINTER WILL BE      == A C==   RETURNED IN "IERROR(2,I)" TO POINT TO THE COLUMN AT WHICH==-A C==   THE ERROR OCCURED.                                       == A C================================================================ ;       CALL IGC(EXPRES,ILAST,' ',1,IFIRST,IFIND,&3000,&3000)        IFIRST=IFIND       ICODE(1,NCODE)=IFIRST A C================================================================6A C==   SET ISTATE = |ISTATE|.                                   ==8A C==   ERRORS 1,2,3,4 OCCUR IF ISTATE => 100.                   ==3A C==   IF "ISTATE" => 100 THEN AN ERROR HAS OCCURED, I.E. THE   ==3A C==   TERM FOUND IS INVALID. SET THE ERROR NUMBER "IERR" TO    ===A C==   ISTATE-100 AND GO TO 2000.                               ==NA C==   IF ISTATE => 50 SET ISTATE = ISTATE-50.                  ===A C================================================================U       ISTATE=IABS(ISTATE),&       IF(ISTATE.GE.100)IERR=ISTATE-100!       IF(ISTATE.GE.100)GO TO 2000=&       IF(ISTATE.GE.50)ISTATE=ISTATE-50A C================================================================OA C==   "ISTATE" IS A VALID OUTPUT STATE. "ISTATE" CORRESPONDS   ===A C==   TO THE TERM NUMBER 1,2,3,4,5,6,7,8, OR 9, DEFINED ABOVE  == A C==   UNDER "SEQUENCING ERROR MESSAGES".                       ==OA C=================================================================<       GO TO (1100,1100,1300,1400,1500,1600,3000,1800),ISTATEA C================================================================SA C==   TERM 1 OR 2: FUNCTION OR VARIABLE NAME.                  ==LA C==   EXTRACT THE "NAME" FROM BETWEEN POINTERS "IFIRST" AND    == A C==   "ILAST", GETTING RID OF BLANKS.                          ===A C=================================================================
 1100  NNAME=0=       CALL SETC(8,NAME,' ')=A C================================================================MA C==   ERROR 6: NAME > 8 CHARACTERS.                            ==CA C================================================================V       IERR=6       DO 1110 I=IFIRST,ILAST'       IF(EQUC(EXPRES(I),' '))GO TO 1110        IF(NNAME.EQ.8)GO TO 2000       NNAME=NNAME+1        NAME(NNAME)=EXPRES(I)" 1110  CONTINUEA C================================================================ A C==   FIND WHERE THE "NAME" IS, IN THE FUNCTION AND VARIABLE   ==SA C==   TABLES: "FUNCTN" AND "VARIAB".                           ==PA C================================================================        ISHIFT=0       IF(NFUN2.LE.0)GO TO 1130       FUNC=.TRUE.T       DO 1120 I=1,NFUN2=+       IF(EQCMP(8,FUNCTN(I),NAME))GO TO 1160E 1120  CONTINUE 1130  ISHIFT=NFUN2       FUNC=.FALSE.       IF(NVAR2.LE.0)GO TO 1150       DO 1140 I=1,NVAR2E+       IF(EQCMP(8,VARIAB(I),NAME))GO TO 1160  1140  CONTINUEA C================================================================"A C==   ERROR 7: "NAME" IS AN UNDEFINED FUNCTION OF VARIABLE.    ===A C================================================================- 1150  IERR=7       GO TO 2000A C================================================================TA C==   STORE THE FUNCTION OR VARIABLE CODE: "I+ISHIFT" IN       ===A C==   "ICODE(2,NCODE)".                                        ==NA C==   IF "NAME" IS A FUNCTION, OR "MIVAR" <= 0 THEN GO TO 1000,== A C==   THE BEGINNING OF THE SCAN LOOP.                          ===A C================================================================  1160  ICODE(2,NCODE)=I+ISHIFT=       IF(FUNC)GO TO 1000       IF(MIVAR.LE.0)GO TO 1000A C=================================================================A C==   "NAME" IS A VARIABLE. STORE THE VARIABLE INDEX "I" IN    ==FA C==   "IVAR".                                                  ===A C==   CHECK TO SEE IF THE VARIABLE "NAME" IS ALREADY STORED IN ==RA C==   VARIABLE INDEX ARRAY "IVAR". IF IT IS GO TO 1000.        ==NA C================================================================        IF(NIVAR.LE.0)GO TO 1180       DO 1170 J=1,NIVARE        IF(IVAR(J).EQ.I)GO TO 1000 1170  CONTINUEA C================================================================ A C==   ERROR 9: TOO MANY VARIABLES, "NIVAR" => "MIVAR".         == A C================================================================  1180  IERR=9"       IF(NIVAR.GE.MIVAR)GO TO 2000A C================================================================TA C==   STORE THE VARIABLE INDEX "I" IN "IVAR".                  ==SA C=================================================================       NIVAR=NIVAR+1=       IVAR(NIVAR)=I        GO TO 1000A C================================================================ A C==   TERM 3: CONSTANT NUMBER.                                 ==TA C==   ERROR 10: INVALID REAL NUMBER. THIS ERROR SHOULD NEVER   ==TA C==             OCCUR ASSUMING THE LEXICAL SCANNER "SCAN" IS   == A C==             WORKING PROPERLY.                              == A C==   CONVERT THE CHARACTER STRING NUMBER BETWEEN POINTERS     ===A C==   "IFIRST" AND "ILAST" IN "EXPRES" TO A REAL*8 NUMBER      ==SA C==   "REAL8".                                                 ==)A C=================================================================
 1300  IERR=10O>       CALL CHREAL(EXPRES(IFIRST),ILAST-IFIRST+1,REAL8,2,&2000)A C================================================================ A C==   ERROR 11: TOO MANY CONSTANTS, "NRCODE" => "MRCODE".      == A C==   STORE THE NUMBER "REAL8" IN "RCODE(NRCODE)" AND STORE    ===A C==   CONSTANT CODE "NFUN2+NVAR2+NRCODE" IN "ICODE(2,NCODE)".  == A C================================================================ 
       IERR=11 $       IF(NRCODE.GE.MRCODE)GO TO 2000       NRCODE=NRCODE+1R       RCODE(NRCODE)=REAL8 '       ICODE(2,NCODE)=NFUN2+NVAR2+NRCODET       GO TO 1000A C=================================================================A C==   TERM 4: ")","}", OR "]".                                 ==TA C==   STORE THE RIGHT PARENTHESIS CODE "-NOPER2-4" IN          ===A C==   "ICODE(2,NCODE)".                                        == A C================================================================= 1400  ICODE(2,NCODE)=-NOPER2-4       GO TO 1000A C================================================================EA C==   TERM 5: "(","{", OR "[".                                 == A C==   STORE THE LEFT PARENTHESIS CODE "-NOPER2-5" IN           ===A C==   "ICODE(2,NCODE)".                                        == A C================================================================  1500  ICODE(2,NCODE)=-NOPER2-5       GO TO 1000A C================================================================.A C==   TERM 6: ",".                                             ==FA C==   STORE THE COMMA CODE "-NOPER2-6" IN "ICODE(2,NCODE)".    ==NA C================================================================1 1600  ICODE(2,NCODE)=-NOPER2-6       GO TO 1000A C=================================================================A C==   TERM 8 OR 9: UNARY OR BINARY OPERATOR NAME.              ==UA C==   EXTRACT THE "NAME" FROM BETWEEN POINTERS "IFIRST" AND    ===A C==   "ILAST", GETTING RID OF BLANKS.                          ===A C================================================================T
 1800  NNAME=0N       CALL SETC(8,NAME,' ') A C================================================================ A C==   ERROR 12: OPERATOR > 8 CHARACTERS.                       ==OA C================================================================ 
       IERR=12=       DO 1810 I=IFIRST,ILAST'       IF(EQUC(EXPRES(I),' '))GO TO 1810        IF(NNAME.EQ.8)GO TO 2000       NNAME=NNAME+1        NAME(NNAME)=EXPRES(I)  1810  CONTINUEA C================================================================ A C==   ERROR 13: UNDEFINED OPERATOR.                            == A C================================================================S
       IERR=13B       IF(NOPER2.LE.0)GO TO 2000RA C================================================================NA C==   FIND WHERE THE OPERATOR "NAME" IS, IN THE OPERATOR TABLE == A C==   "OPERAT".                                                ==FA C=================================================================       DO 1820 I=1,NOPER2+       IF(EQCMP(8,OPERAT(I),NAME))GO TO 1830B 1820  CONTINUE       GO TO 2000A C=================================================================A C==   OPERATOR "NAME" = OPERAT(I).                             ===A C==   STORE THE OPERATOR CODE "-I" IN "ICODE(2,NCODE)".        ==HA C================================================================= 1830  ICODE(2,NCODE)=-I=       GO TO 1000A C================================================================0A C==   ERROR MESSAGES: 1 - 17.                                  ===A C=================================================================! 2000  IF(NERROR.GE.MERROR)RETURN1M       NERROR=NERROR+1NA C================================================================NA C==   INITIALIZE THE ERROR MESSAGE "ERROR(1,NERROR)" TO BLANKS.== A C==   SET IERROR(1,NERROR) = IERR = THE ERROR NUMBER.          ==EA C==   SET IERROR(2,NERROR) = IFIRST = THE COLUMN OF THE        ==EA C==   EXPRESSION "EXPRES" AT WHICH THE ERROR OCCURS.           == A C==   THEN GO TO THE NUMBER CORRESPONDING TO "IERR" AND        ===A C==   MOVE THE APPROPRIATE ERROR MESSAGE INTO "ERROR(1,NERROR)".=IA C================================================================-'       CALL SETC(50,ERROR(1,NERROR),' ')=       IERROR(1,NERROR)=IERR=       IERROR(2,NERROR)=IFIRSTE:       GO TO (2010,2020,2030,2040,2050,2060,2070,2070,2090,:      *       2100,2110,2120,2130,2140,2150,2160,2170),IERR8 2010  CALL MOVEC(17,'INVALID CHARACTER',ERROR(1,NERROR))       GO TO 2900C 2020  CALL MOVEC(28,'NO CLOSING QUOTE ON OPERATOR',ERROR(1,NERROR))8
       RETURN1 < 2030  CALL MOVEC(21,'INVALID DECIMAL POINT',ERROR(1,NERROR))       GO TO 29007 2040  CALL MOVEC(16,'INVALID EXPONENT',ERROR(1,NERROR)) C       CALL FINDC(EXPRES,ILAST,'ED',2,IFIRST,IFIND,IDUM,&2900,&2900)=       IERROR(2,NERROR)=IFIND       GO TO 2900; 2050  CALL MOVEC(20,'EXPRESSION TOO LARGE',ERROR(1,NERROR)) 
       RETURN1E: 2060  CALL MOVEC(19,'NAME > 8 CHARACTERS',ERROR(1,NERROR))       GO TO 2900( 2070  CALL MOVEC(8,NAME,ERROR(1,NERROR))!       IF(ILAST.GE.NEXP)GO TO 2080=2       IF(.NOT.EQUC(EXPRES(ILAST+1),'('))GO TO 2080@       CALL MOVEC(25,' IS AN UNDEFINED FUNCTION',ERROR(9,NERROR))       GO TO 2900 2080  IERROR(1,NERROR)=8@       CALL MOVEC(25,' IS AN UNDEFINED VARIABLE',ERROR(9,NERROR))       GO TO 29009 2090  CALL MOVEC(18,'TOO MANY VARIABLES',ERROR(1,NERROR))T
       RETURN1=: 2100  CALL MOVEC(19,'INVALID REAL NUMBER',ERROR(1,NERROR))       GO TO 29009 2110  CALL MOVEC(18,'TOO MANY CONSTANTS',ERROR(1,NERROR)) 
       RETURN1O> 2120  CALL MOVEC(23,'OPERATOR > 8 CHARACTERS',ERROR(1,NERROR))       GO TO 29009 2130  CALL MOVEC(18,'UNDEFINED OPERATOR',ERROR(1,NERROR))=       GO TO 29007 2140  CALL MOVEC(16,'BLANK EXPRESSION',ERROR(1,NERROR))=
       RETURN1 = 2150  CALL MOVEC(22,'")" HAS NO LEADING "("',ERROR(1,NERROR))=
       RETURN1=? 2160  CALL MOVEC(24,'"(" HAS NO FOLLOWING ")"',ERROR(1,NERROR))-
       RETURN1 > 2170  CALL MOVEC(23,'OPERATOR STACK OVERFLOW',ERROR(1,NERROR))
       RETURN1 ! 2900  IF(NERROR.GE.MERROR)RETURN1        GO TO 1000A C=================================================================A C==   THE LEXICAL SCAN OF THE EXPRESSION IS FINISHED.          == A C================================================================ A C==   ERROR 14: BLANK EXPRESSION, NCODE <= 0.                  == A C==   IF THERE ARE ANY ERROR MESSAGES (NERROR > 0) AFTER THE   == A C==   LEXICAL SCAN OF THE EXPRESSION THEN RETURN1.             == A C================================================================ 
 3000  IERR=14O       IF(NCODE.LE.0)GO TO 2000       IF(NERROR.GT.0)RETURN1A C=================================================================A C==   CHECK FOR ERRORS WHICH INVOLVE INVALID SEQUENCING OF THE ===A C==   TERMS IN THE EXPRESSION. THE TERMS 1 - 9 ARE DEFINED ABOVE="A C==   UNDER "SEQUENCING ERROR MESSAGES".                       ==TA C================================================================OA C==   ITERMC: IS THE NUMBER OF THE CURRENT TERM (1 - 9).       ===A C==   ITERMF: IS THE NUMBER OF THE FOLLOWING TERM (1 - 9).     == A C==   BOTH "ITERMC" & "ITERMF" START OFF AS "7" WHICH IS THE   ==DA C==   NUMBER OF THE "NULL" TERM WHICH REFERS TO THE BEGINNING  ===A C==   OR END OF THE EXPRESSION.                                == A C==   ICOLC : IS THE COLUMN AT WHICH THE CURRENT TERM STARTS IN==EA C==           THE EXPRESSION.                                  == A C==   ICOLF : IS THE COLUMN AT WHICH THE FOLLOWING TERM STARTS ===A C==           IN THE EXPRESSION.                               ==EA C=================================================================       ITERMC=7       ITERMF=7
       ICOLC=1O
       ICOLF=1        NCODE1=NCODE+1       DO 40 I=1,NCODE1A C================================================================OA C==   UPDATE THE CURRENT TERM NUMBER: ITERMC, AND DETERMINE THE===A C==   TERM NUMBER OF THE FOLLOWING TERM.                       ==DA C=================================================================       ITERMC=ITERMF=       ICOLC=ICOLFM       IF(I.LE.NCODE)GO TO 3010A C================================================================ A C==   THE FOLLOWING TERM IS A "NULL" (END OF THE EXPRESSION)   ===A C==   (ITERMF=7).                                              ==0A C================================================================2       ITERMF=7       GO TO 3500 3010  ICOLF=ICODE(1,I)       ICODE2=ICODE(2,I)*       IF(ICODE2.GT.0)GO TO 32001       IOPER=-ICODE20#       IF(IOPER.LE.NOPER2)GO TO 3100,A C================================================================ A C==   THE FOLLOWING TERM IS A ")" (ITERMF=4), "(" (ITERMF=5),  ==VA C==   OR A "," (ITERMF=6).                                     ==0A C================================================================F       ITERMF=IOPER-NOPER2I       GO TO 3500A C================================================================AA C==   THE FOLLOWING TERM IS AN OPERATOR.                       ==EA C==   DETERMINE THE OPERATOR TYPE: IOPTYP=1 (UNARY) OR         == A C==   IOPTYP=2 (BINARY).                                       ==TA C================================================================  3100  IOPTYP=0&       IF(IPRIOR(1,IOPER).EQ.0)IOPTYP=2&       IF(IPRIOR(2,IOPER).EQ.0)IOPTYP=1       IF(IOPTYP.NE.0)GO TO 3110VA C================================================================0A C==   HERE THE OPERATOR IS ALLOWED TO BE EITHER UNARY OR       == A C==   BINARY, I.E. IPRIOR(I,IOPER) .NE. 0, I=1,2. THE OPERATOR ==)A C==   TYPE OF THE FOLLOWING TERM IS DETERMINED BY THE CURRENT  ==1A C==   TERM NUMBER (ITERMC).                                    ==CA C==   IF ITERMC <= 4, I.E. THE CURRENT TERM IS A FUNCTION      ==FA C==   VARIABLE, CONSTANT, OR ")", THEN THE OPERATOR IS BINARY  ==CA C==   (IOPTYP=2), OTHERWISE IT IS UNARY (IOPTYP=1).            ==LA C=================================================================       IOPTYP=1       IF(ITERMC.LE.4)IOPTYP=2'A C================================================================TA C==   SET ICODE(1,I) EQUAL TO THE OPERATOR TYPE (1 OR 2, UNARY ==MA C==   OR BINARY), AND THE FOLLOWING TERM NUMBER "ITERMF" TO THE===A C==   UNARY OPERATOR CODE 8, OR THE BINARY OPERATOR CODE 9.    ==RA C================================================================= 3110  ICODE(1,I)=IOPTYP=       ITERMF=IOPTYP+7        GO TO 3500# 3200  IF(ICODE2.GT.NFUN2)GO TO 3300 A C================================================================ A C==   THE FOLLOWING TERM IS A FUNCTION (ITERMF=1).             ===A C================================================================0       ITERMF=1       GO TO 3500A C=================================================================A C==   THE FOLLOWING TERM IS A VARIABLE (ITERMF=2) OR A CONSTANT==HA C==   (ITERMF=3).                                              ==OA C================================================================O 3300  ITERMF=2'       IF(ICODE2.GT.NFUN2+NVAR2)ITERMF=3=A C================================================================TA C==   CHECK TO SEE IF "ITERMF" IS ALLOWED TO FOLLOW "ITERMC",  ==TA C==   I.E. IF THE FOLLOWING TERM IS ALLOWED TO BE AFTER THE    ==CA C==   CURRENT TERM.                                            ==HA C==   IF IT IS ALLOWED THEN GO TO 40; OTHERWISE GO TO 30 AND   ==HA C==   STORE THE APPROPRIATE ERROR MESSAGE IN "ERROR(1,NERROR)".==TA C================================================================ / 3500  GO TO (11,11,13,13,15,15,15,18,18),ITERMC / 11    GO TO (30,30,30,40,40,40,40,30,40),ITERMFG/ 13    GO TO (30,30,30,40,30,40,40,30,40),ITERMF./ 15    GO TO (40,40,40,30,40,30,30,40,30),ITERMF=/ 18    GO TO (40,40,40,30,40,30,30,30,30),ITERMF=A C================================================================ A C==   SEQUENCING ERROR MESSAGES: 113 - 199.                    ===A C================================================================E! 30    IF(NERROR.GE.MERROR)RETURN1N       IF(NFIRST)GO TO 3600A C=================================================================A C==   THE FIRST TIME THROUGH, INITIALIZE THE ARRAY OF TERM     ==MA C==   NAMES: "TERM(1,I)", I=1,9.                               ===A C================================================================O/       CALL MOVEC(LTERM(1),'FUNCTION',TERM(1,1)) /       CALL MOVEC(LTERM(2),'VARIABLE',TERM(1,2)) /       CALL MOVEC(LTERM(3),'CONSTANT',TERM(1,3))=/       CALL MOVEC(LTERM(4),'")"'     ,TERM(1,4))T/       CALL MOVEC(LTERM(5),'"("'     ,TERM(1,5)) /       CALL MOVEC(LTERM(6),'","'     ,TERM(1,6)) /       CALL MOVEC(LTERM(7),'NULL'    ,TERM(1,7)).6       CALL MOVEC(LTERM(8),'UNARY OPERATOR' ,TERM(1,8))6       CALL MOVEC(LTERM(9),'BINARY OPERATOR',TERM(1,9))       NFIRST=.TRUE. A C================================================================ A C==   INITIALIZE THE ERROR MESSAGE "ERROR(1,NERROR)" TO BLANKS.===A C==   SET IERROR(1,NERROR) = 100+ITERMC*10+ITERMF = THE ERROR  == A C==   NUMBER CORRESPONDING TO THE SEQUENCING ERROR WHICH OCCURS== A C==   WHEN TERM "ITERMC" IS FOLLOWED BY TERM "ITERMF".         == A C==   SET IERROR(2,NERROR) = ICOLC = THE COLUMN OF THE         == A C==   EXPRESSION "EXPRES" AT WHICH THE ERROR OCCURS.           == A C==   THEN MOVE THE ERROR MESSAGE: "TERM(1,ITERMC)" FOLLOWED BY== A C==   "TERM(1,ITERMF)", INTO "ERROR(1,NERROR)".                ==RA C================================================================= 3600  NERROR=NERROR+1='       CALL SETC(50,ERROR(1,NERROR),' ') +       IERROR(1,NERROR)=100+ITERMC*10+ITERMFN       IERROR(2,NERROR)=ICOLC>       CALL MOVEC(LTERM(ITERMC),TERM(1,ITERMC),ERROR(1,NERROR))B       CALL MOVEC(13,' FOLLOWED BY ',ERROR(1+LTERM(ITERMC),NERROR)).       CALL MOVEC(LTERM(ITERMF),TERM(1,ITERMF),0      *           ERROR(14+LTERM(ITERMC),NERROR))!       IF(NERROR.GE.MERROR)RETURN1  40    CONTINUEA C================================================================EA C==   THE CHECK FOR SEQUENCING ERRORS OF THE TERMS IN THE      ===A C==   EXPRESSION IS FINISHED.                                  == A C=================================================================A C==   IF THERE ARE ANY ERROR MESSAGES (NERROR > 0) DUE TO      ==RA C==   INVALID SEQUENCING OF THE TERMS IN THE EXPRESSION THEN   ==NA C==   RETURN1.                                                 ==YA C=================================================================       IF(NERROR.GT.0)RETURN1A C================================================================0A C==   CHECK FOR MISMATCHING PARENTHESES.                       ===A C==   THE DO 4000 LOOP SEARCHS FORWARD FOR A ")" WITH NO LEADING=CA C==   "(". THE DO 4030 LOOP SEARCHS BACKWARDS FOR A "(" WITH NO===A C==   FOLLOWING ")".                                           == A C================================================================ A C==   ILEVEL = THE LEVEL OR DEPTH WITHIN PARENTHESES.          == A C==   WHEN SEARCHING FORWARD "ILEVEL" STARTS OFF AS ZERO AND   == A C==   IS INCREMENTED BY 1 FOR EVERY "(" (ICODE2.EQ.5) FOUND,   == A C==   AND IS DECREMENTED BY 1 FOR EVERY ")" (ICODE2.EQ.4) FOUND.==A C==   IF "ILEVEL" BECOMES NEGATIVE THEN A ")" WITH NO LEADING  ==CA C==   "(" HAS BEEN FOUND AND WE GO TO 4010.                    ==.A C================================================================R       ILEVEL=0       DO 4000 I=1,NCODE )       IF(ICODE(2,I).GE.-NOPER2)GO TO 4000 A C================================================================ A C==   "ICODE(2,I)" CORRESPONDS TO A ")", "(", OR ",".          ===A C==   ICODE2.EQ.6  CORRESPONDS TO A ",".                       ==,A C==   ICODE2.EQ.4  CORRESPONDS TO A ")", "}", OR "]".          ==MA C==   ICODE2.EQ.5  CORRESPONDS TO A "(", "{", OR "[".          ==4A C================================================================3       ICODE2=-ICODE(2,I)-NOPER2=       IF(ICODE2.EQ.6)GO TO 4000=$       IF(ICODE2.EQ.4)ILEVEL=ILEVEL-1$       IF(ICODE2.EQ.5)ILEVEL=ILEVEL+1       IF(ILEVEL.LT.0)GO TO 4010= 4000  CONTINUEA C================================================================ A C==   IF ILEVEL.EQ.0 THEN THE PARENTHESES IN THE EXPRESSION ARE===A C==   BALANCED. HENCE GO TO 4100.                              ==EA C==   OTHERWISE IF ILEVEL.GT.0 THEN GO TO 4020 AND SEARCH THE  == A C==   EXPRESSION BACKWARDS FOR A "(" WITH NO FOLLOWING ")".    ===A C================================================================,       IF(ILEVEL.EQ.0)GO TO 4100V       GO TO 4020A C================================================================VA C==   ILEVEL.LT.0:                                             == A C==   ERROR 15: ")" HAS NO LEADING "(".                        == A C================================================================L 4010  IFIRST=ICODE(1,I),
       IERR=15        GO TO 2000A C=================================================================A C==   ILEVEL = THE LEVEL OR DEPTH WITHIN PARENTHESES.          ==AA C==   WHEN SEARCHING BACKWARDS "ILEVEL" STARTS OFF AS ZERO AND ==EA C==   IS INCREMENTED BY 1 FOR EVERY ")" (ICODE2.EQ.4) FOUND,   ==RA C==   AND IS DECREMENTED BY 1 FOR EVERY "(" (ICODE2.EQ.5) FOUND.=TA C==   IF "ILEVEL" BECOMES NEGATIVE THEN A "(" WITH NO FOLLOWING==EA C==   ")" HAS BEEN FOUND AND WE GO TO 4040.                    ==SA C================================================================M 4020  ILEVEL=0       DO 4030 I=1,NCODEO       II=NCODE-I+1*       IF(ICODE(2,II).GE.-NOPER2)GO TO 4030A C=================================================================A C==   "ICODE(2,II)" CORRESPONDS TO A ")", "(", OR ",".         ==1A C==   ICODE2.EQ.6  CORRESPONDS TO A ",".                       == A C==   ICODE2.EQ.4  CORRESPONDS TO A ")", "}", OR "]".          ==CA C==   ICODE2.EQ.5  CORRESPONDS TO A "(", "{", OR "[".          ==RA C================================================================         ICODE2=-ICODE(2,II)-NOPER2       IF(ICODE2.EQ.6)GO TO 4030E$       IF(ICODE2.EQ.4)ILEVEL=ILEVEL+1$       IF(ICODE2.EQ.5)ILEVEL=ILEVEL-1       IF(ILEVEL.LT.0)GO TO 4040H 4030  CONTINUE       GO TO 4100A C================================================================ A C==   ILEVEL.LT.0:                                             ===A C==   ERROR 16: "(" HAS NO FOLLOWING ")".                      ==RA C================================================================T 4040  IFIRST=ICODE(1,II)
       IERR=16        GO TO 2000A C=================================================================A C==   CHECK FOR INVALID COMMAS, AND                            ===A C==   CHECK THAT ALL OF THE FUNCTIONS HAVE THE CORRECT NUMBER  == A C==   OF ARGUMENTS "NARGUM(1,I)" <= NARG <= "NARGUM(2,I)", AND == A C==   CHECK THAT ALL OF THE VARIABLES HAVE THE CORRECT NUMBER  == A C==   OF INDICES "NINDEX(I)".                                  == A C================================================================= 4100  IST=1= 4105  ISTART=IST#       IF(ISTART.GT.NCODE)GO TO 4180        DO 4110 I=ISTART,NCODE       ICODE1=ICODE(1,I)        ICODE2=ICODE(2,I)G'       IF(ICODE2.NE.-NOPER2-6)GO TO 4120 A C================================================================ A C==   ICODE2 = -NOPER2-6: CORRESPONDS TO A COMMA.              ==NA C==   IF "ICODE1" HAS BEEN SET NEGATIVE THEN THE COMMA IS VALID== A C==   OTHERWISE IT IS INVALID.                                 == A C=================================================================       IF(ICODE1.LT.0)GO TO 41200A C=================================================================A C==   ERROR 18: INVALID COMMA.                                 ==OA C================================================================D
       IERR=18P       GO TO 4160 4120  IF(ICODE2.LE.0)GO TO 4110D)       IF(ICODE2.GT.NVAR2+NFUN2)GO TO 4110 A C================================================================ A C==   "ICODE2" CORRESPONDS TO A FUNCTION OR VARIABLE.          ===A C==   COUNT THE NUMBER OF ARGUMENTS "NARG" OF THE FUNCTION OR  ==6A C==   VARIABLE.                                                ==.A C================================================================N       NARG=0
       IST=I+1=       IF(I.EQ.NCODE)GO TO 4140-       IF(ICODE(2,I+1).NE.-NOPER2-5)GO TO 4140EA C================================================================ A C==   AN OPEN PARENTHESIS FOLLOWS THE FUNCTION OR VARIABLE NAME.=OA C==   ILEVEL = THE LEVEL OR DEPTH OF PARENTHESES FOLLOWING THE ==WA C==   FUNCTION OR VARIABLE NAME. THE NUMBER OF ARGUMENTS       ===A C==   FOLLOWING THE FUNCTION OR VARIABLE NAME IS EQUAL TO THE  == A C==   NUMBER OF COMMAS AT LEVEL "ILEVEL"=1 PLUS ONE.           ===A C==   THE SEARCH FOR FUNCTION OR VARIABLE ARGUMENTS TERMINATES == A C==   WHEN ILEVEL BECOMES 0 AGAIN.                             == A C=================================================================       NARG=1       ILEVEL=0       DO 4130 J=IST,NCODE )       IF(ICODE(2,J).GE.-NOPER2)GO TO 4130=       ICOD2=-ICODE(2,J)-NOPER2-       IF(ICOD2.NE.6.OR.ILEVEL.NE.1)GO TO 4135NA C================================================================ A C==   "ICOD2"=6 CORRESPONDS TO A COMMA ON LEVEL "ILEVEL"=1.    == A C==   INCREMENT "NARG" BY 1.                                   == A C==   SET "ICODE(1,J)" TO NEGATIVE SO THAT ON A SUBSEQUENT SCAN== A C==   FOR A FUNCTION OR VARIABLE NAME IT WON'T BE TREATED AS AN==0A C==   INVALID COMMA.                                           ===A C================================================================O       NARG=NARG+11       ICOD1=ICODE(1,J)       ICODE(1,J)=-IABS(ICOD1)=       GO TO 4130A C================================================================OA C==   ICOD2.EQ.4 CORRESPONDS TO A ")", "}", OR A "]".          ==NA C==   ICOD2.EQ.5 CORRESPONDS TO A "(", "{", OR A "[".          ==NA C================================================================N# 4135  IF(ICOD2.EQ.4)ILEVEL=ILEVEL-1R#       IF(ICOD2.EQ.5)ILEVEL=ILEVEL+1=A C================================================================ A C==   WHEN "ILEVEL" BECOMES 0 TERMINATE THE SEARCH FOR COMMAS  ==1A C==   AND FUNCTION OR VARIABLE ARGUMENTS.                      ==4A C=================================================================       IF(ILEVEL.LE.0)GO TO 4140= 4130  CONTINUEA C================================================================OA C==   STORE THE NUMBER OF ARGUMENTS WHICH THE FUNCTION OR      ===A C==   VARIABLE CORRESPONDING TO "ICODE(2,I)" HAS, IN           ==RA C==   "ICODE(1,I)".                                            ===A C================================================================N 4140  ICODE(1,I)=NARG #       IF(ICODE2.GT.NFUN2)GO TO 4150 A C================================================================GA C==   "ICODE2" CORRESPONDS TO FUNCTION NAME "FUNCTN(ICODE2)".  == A C==   CHECK THAT "NARG" LIES IN THE RANGE:                     ==DA C==   NARGUM(1,ICODE2) <= NARG <= NARGUM(2,ICODE2).            ===A C=================================================================?       IF(NARGUM(1,ICODE2).LE.NARG.AND.NARG.LE.NARGUM(2,ICODE2))O      * GO TO 4105EA C================================================================EA C==   ERROR 19: FUNCTION HAS WRONG NUMBER OF ARGUMENTS.        ===A C================================================================O
       IERR=19        GO TO 4160A C================================================================ A C==   "ICODE2" CORRESPONDS TO VARIABLE NAME "VARIAB(IV)".      ===A C================================================================  4150  IV=ICODE2-NFUN22A C=================================================================A C==   ERROR 20: VARIABLE HAS WRONG NUMBER OF INDICES.          ===A C=================================================================
       IERR=201#       IF(NINDEX(IV).LT.0)GO TO 4155.A C=================================================================A C==   NINDEX(IV) => 0: CHECK THAT NARG = NINDEX(IV).           == A C================================================================ &       IF(NARG.EQ.NINDEX(IV))GO TO 4105       GO TO 4160A C=================================================================A C==   NINDEX(IV) <  0: CHECK THAT NARG = 0 OR |NINDEX(IV)|.    ===A C================================================================ 9 4155  IF(NARG.EQ.0.OR.NARG.EQ.IABS(NINDEX(IV)))GO TO 4105=A C================================================================ A C==   ERROR MESSAGES: 18 - 20.                                 ===A C================================================================N! 4160  IF(NERROR.GE.MERROR)RETURN1GA C================================================================EA C==   INITIALIZE THE ERROR MESSAGE "ERROR(1,NERROR)" TO BLANKS.==NA C==   SET IERROR(1,NERROR) = IERR = THE ERROR NUMBER.          ==TA C==   SET IERROR(2,NERROR) = ICODE1 = THE COLUMN OF THE        == A C==   EXPRESSION "EXPRES" AT WHICH THE ERROR OCCURS.           ===A C==   THEN GO TO THE NUMBER CORRESPONDING TO "IERR" AND        ==,A C==   MOVE THE APPROPRIATE ERROR MESSAGE INTO "ERROR(1,NERROR)".=OA C=================================================================       NERROR=NERROR+1='       CALL SETC(50,ERROR(1,NERROR),' ')=       IERROR(1,NERROR)=IERRA       IERROR(2,NERROR)=ICODE1=       IERR=IERR-17!       GO TO (4161,4162,4163),IERR 4 4161  CALL MOVEC(13,'INVALID COMMA',ERROR(1,NERROR))       GO TO 4170= 4162  CALL MOVEC(38,'FUNCTION HAS WRONG NUMBER OF ARGUMENTS',R$      *              ERROR(1,NERROR))       GO TO 4170; 4163  CALL MOVEC(36,'VARIABLE HAS WRONG NUMBER OF INDICES',=$      *              ERROR(1,NERROR))! 4170  IF(NERROR.GE.MERROR)RETURN1, 4110  CONTINUEA C=================================================================A C==   THE CHECK FOR INVALID COMMAS, AND INVALID NUMBERS OF     ==TA C==   FUNCTION ARGUMENTS OR VARIABLE INDICES IS FINISHED.      ==TA C=================================================================A C==   IF THERE ARE ANY ERROR MESSAGES AT THIS POINT THEN       ==EA C==   RETURN1.                                                 ===A C================================================================E 4180  IF(NERROR.GT.0)RETURN1A C================================================================ A C==   CONVERT THE "NCODE" CODES IN "ICODE" TO REVERSE POLISH   ===A C==   NOTATION, STORING THE FINAL R.P.N. CODE IN "ICODE".      ===A C==   NOUT = CURRENT NUMBER OF R.P.N. CODES IN "ICODE".        ===A C==   IERR=17 CORRESPONDS TO ERROR 17: OPERATOR STACK OVERFLOW.===A C==   NSTACK = CURRENT NUMBER OF OPERATORS STORED IN THE       ===A C==            OPERATOR STACK: "STACK(2,100)".                 ===A C================================================================1       NOUT=0
       IERR=17F       NSTACK=0       DO 5000 I=1,NCODE=       ICODE2=ICODE(2,I)=)       IF(ICODE2.LE.NFUN2+NVAR2)GO TO 5010"A C================================================================HA C==   "ICODE2" CORRESPONDS TO A REAL*8 CONSTANT.               ==1A C=================================================================A C==   STORE "ICODE(K,I)",K=1,2 IN ICODE(K,NOUT).               ==UA C================================================================0 5005  NOUT=NOUT+1=       ICODE(1,NOUT)=ICODE(1,I)       ICODE(2,NOUT)=ICODE(2,I)       GO TO 5000 5010  IF(ICODE2.LE.0)GO TO 5020=A C=================================================================A C==   "ICODE2" CORRESPONDS TO A FUNCTION OR VARIABLE.          ===A C==   IF ICODE(1,I).LE.0, I.E. THE FUNCTION OR VARIABLE HAS 0  == A C==   ARGUMENTS THEN GO TO 5005.                               ===A C=================================================================#       IF(ICODE(1,I).LE.0)GO TO 5005=A C================================================================FA C==   ICODE(1,I) > 0, I.E. THE FUNCTION OR VARIABLE HAS A SET  ===A C==   OF ARGUMENTS. STACK THE FUNCTION OR VARIABLE IN THE      == A C==   OPERATOR STACK.                                          ===A C================================================================ A C==   INCREMENT THE NUMBER OF ELEMENTS IN THE STACK "NSTACK" BY===A C==   1 AND CHECK FOR AN OVERFLOW.                             == A C==   IF NO OVERFLOW THEN STORE "ICODE(K,I)",K=1,2 IN          == A C==   "STACK(K,I)".                                            == A C================================================================  5015  NSTACK=NSTACK+1A       IFIRST=1!       IF(NSTACK.GT.100)GO TO 2000=!       ISTACK(1,NSTACK)=ICODE(1,I)=!       ISTACK(2,NSTACK)=ICODE(2,I)S       GO TO 5000% 5020  IF(ICODE2.LT.-NOPER2)GO TO 5100=A C================================================================NA C==   "ICODE2" CORRESPONDS TO OPERATOR "OPERAT(IOPER)".        ===A C==   "IOPTYP" = 1 OR 2 (BINARY OR UNARY) IS THE OPERATOR TYPE.==(A C==   "|IPRIO|" IS THE OPERATOR PRIORITY OR PRECEDENCE AND THE ==RA C==   SIGN OF "IPRIO" GIVES THE OPERATOR ASSOCIATIVITY (+ OR - == A C==   LEFT OR RIGHT ASSOCIATIVITY).                            ==RA C================================================================        IOPER=-ICODE2=       IOPTYP=ICODE(1,I)R        IPRIO=IPRIOR(IOPTYP,IOPER)       IF(NSTACK.LE.0)GO TO 5015=A C=================================================================A C==   POP ANY OPERATORS ON THE STACK WHICH HAVE A HIGHER       ==IA C==   PRECEDENCE THEN THE PRECEDENCE "IPRIO", UNTIL AN OPERATOR==TA C==   WITH LOWER PRECEDENCE OR A "(" OR "," IS ENCOUNTERED.    ==(A C================================================================N       DO 5040 J=1,NSTACKA C================================================================MA C==   SCAN THE STACK STARTING AT THE TOP BY USING "II".        == A C================================================================N       II=NSTACK-J+1=       ISTAC2=ISTACK(2,II)=       IF(ISTAC2.LT.0)GO TO 5030HA C================================================================IA C==   ISTAC2 > 0: CORRESPONDS TO A FUNCTION OR VARIABLE WITH   ===A C==               ARGUMENTS.                                   ==EA C================================================================NA C==   POP OPERATOR FROM STACK INTO ICODE(K,NOUT),K=1,2.        ===A C================================================================R 5025  NOUT=NOUT+1=        ICODE(1,NOUT)=ISTACK(1,II)        ICODE(2,NOUT)=ISTACK(2,II)       GO TO 5040A C================================================================RA C==   IF ISTAC2 < -NOPER2, I.E. "ISTAC2" CORRESPONDS TO A ","  ==TA C==   OR "(", THEN STOP POPPING THE STACK AND GO TO 5050.      ==SA C================================================================E% 5030  IF(ISTAC2.LT.-NOPER2)GO TO 5050 A C================================================================ A C==   -NOPER2 <= ISTAC2 < 0: CORRESPONDS TO AN OPERATOR.       ===A C================================================================        IOPER=-ISTAC2D       IOPTYP=ISTACK(1,II)O'       IAPRIO=IABS(IPRIOR(IOPTYP,IOPER))=       IF(IPRIO.LT.0)GO TO 5035A C================================================================NA C==   IPRIO > 0: THE OPERATOR IS LEFT ASSOCIATIVE.             ===A C==   CHECK TO SEE IF IAPRIO < IPRIO. IF IT IS WE STOP POPPING ==,A C==   THE STACK AND GO TO 5050. IF IT ISN'T WE GO TO 5025 AND  ===A C==   POP "ISTACK(K,II)",K=1,2 INTO "ICODE(K,NOUT)",K=1,2.     ==CA C================================================================F#       IF(IAPRIO.LT.IPRIO)GO TO 5050=       GO TO 5025A C================================================================ A C==   IPRIO < 0: THE OPERATOR IS RIGHT ASSOCIATIVE.            ==.A C==   CHECK TO SEE IF IAPRIO <= |IPRIO|. IF IT IS WE STOP      ==0A C==   POPPING THE STACK AND GO TO 5050. IF IT ISN'T WE GO TO   ===A C==   5025 AND POP "ISTACK(K,II)",K=1,2 INTO "ICODE(K,NOUT)".  ==OA C=================================================================) 5035  IF(IAPRIO.LE.IABS(IPRIO))GO TO 5050T       GO TO 5025 5040  CONTINUE
       II=0A C================================================================RA C==   THE NUMBER OF ELEMENTS LEFT IN THE STACK AFTER THE       ===A C==   DO 5040 LOOP IS "NSTACK"="II".                           ==NA C==   THEN GO TO 5015 AND STORE THE OPERATOR CORRESPONDING TO  ==HA C==   "ISTACK(K,II)",K=1,2 INTO "ICODE(K,II)".                 ==VA C================================================================K 5050  NSTACK=II        GO TO 5015A C=================================================================A C==   "ICODE2" CORRESPONDS TO A ")","(", OR ",".               ==NA C================================================================  5100  ICODE2=-ICODE2-NOPER2 A C=================================================================A C==   IF "ICODE2"=5, I.E. IF A "(" THEN GO TO 5015 AND PUSH IT ==OA C==   ONTO THE STACK.                                          ==PA C================================================================P       IF(ICODE2.EQ.5)GO TO 5015 A C================================================================SA C==   "ICODE2" = 4 OR 6 CORRESPONDS TO A ")" OR A ",".         == A C==   POP ALL ELEMENTS OF THE STACK UPTO THE "(".              ===A C================================================================I       IF(NSTACK.LE.0)GO TO 5000E       DO 5110 J=1,NSTACK       II=NSTACK-J+1=A C================================================================ A C==   IF "ISTACK(2,II)" CORRESPONDS TO A "(" STOP POPPING THE  ==CA C==   STACK AND GO TO 5150.                                    ==HA C=================================================================+       IF(ISTACK(2,II).LT.-NOPER2)GO TO 5150=A C=================================================================A C==   POP THE STACK.                                           == A C=================================================================       NOUT=NOUT+1=        ICODE(1,NOUT)=ISTACK(1,II)        ICODE(2,NOUT)=ISTACK(2,II) 5110  CONTINUE       NSTACK=0       GO TO 5000A C================================================================0A C==   IF "ISTACK(2,II)"=6 (CORRESPONDS TO A COMMA) THEN        == A C==   NSTACK=II.                                               ===A C==   IF "ISTACK(2,II)"=4 (CORRESPONDS TO A ")"  ) THEN        ==TA C==   NSTACK=II-1.                                             ===A C================================================================+ 5150  NSTACK=II,$       IF(ICODE2.EQ.4)NSTACK=NSTACK-1 5000  CONTINUEA C=================================================================A C==   WE HAVE FINISHED SCANNING "ICODE".                       ==NA C================================================================TA C==   POP THE REMAINING ELEMENTS OF THE STACK.                 ===A C=================================================================       IF(NSTACK.LE.0)GO TO 5250=       DO 5200 J=1,NSTACK       II=NSTACK-J+1        NOUT=NOUT+1         ICODE(1,NOUT)=ISTACK(1,II)        ICODE(2,NOUT)=ISTACK(2,II) 5200  CONTINUEA C================================================================RA C==   THE NUMBER OF CODES, "NCODE", IN THE REVERSE POLISH      ===A C==   NOTATION OF "ICODE" IS "NOUT".                           == A C================================================================  5250  NCODE=NOUT       RETURNA C================================================================IA C==   THIS IS THE END!!!!!.                                    == A C=================================================================	       END=7       SUBROUTINE SCAN(INPUT,NINPUT,IFIRST,ILAST,ISTATE, 1      *                CLASS,CTABLE,STABLE,NSTATE)=A C================================================================RA C================================================================IA C==                                                            == A C==   SCAN: PERFORMS A LEXICAL SCAN OF THE "INPUT" ARRAY,      ==,A C==         STARTING AT THE "IFIRST" LOCATION IN "INPUT", USING===A C==         THE TRANSITION TABLE "STABLE(NSTATE,NCLASS)".      == A C==         THE TOKEN WHICH SCAN RETURNS LIES WITHIN THE       ===A C==         LOCATIONS "IFIRST" AND "ILAST" OF "INPUT".         ==UA C==                                                            ==4A C==   WRITTEN BY ARTHUR HAYNES, TRIUMF U.B.C., JANUARY 3, 1980.==GA C==                                                            ==CA C==   INPUT  PARAMETERS: INPUT(NINPUT) (L*1,I*2,I*4,R*4,OR R*8);==A C==                      NINPUT,IFIRST,NSTATE (I*4);           ==KA C==                      CLASS (EXTERNAL SUBROUTINE);          ===A C==                      CTABLE (USUALLY A 256 I*2 ARRAY);     == A C==                      STABLE(NSTATE,NCLASS) (I*2).          ===A C==                                                            ===A C==   OUTPUT PARAMETERS: ILAST,ISTATE (I*4).                   ==DA C==                                                            ==EA C==   PARAMETER DEFINITIONS:                                   ===A C==   --------- -----------                                    ==EA C==                                                            ===A C==   INPUT : A L*1,I*2,I*4,R*4, OR R*8 ARRAY OF ELEMENTS TO BE== A C==           SCANNED FOR TOKENS (OR TERMS).                   =="A C==                                                            ===A C==   NINPUT: NUMBER OF ELEMENTS TO BE SCANNED IN "INPUT".     == A C==                                                            ===A C==   IFIRST: FIRST LOCATION IN "INPUT" AT WHICH THE SCAN IS TO==DA C==           START.                                           == A C==                                                            ===A C==   ILAST : LAST LOCATION IN "INPUT" AT WHICH THE SCAN IS    ==GA C==           TERMINATED. THE TOKEN RETURNED BY SCAN LIES      ===A C==           WITHIN THE LOCATIONS "IFIRST" AND "ILAST" OF     == A C==           "INPUT".                                         ===A C==                                                            == A C==   ISTATE: OUTPUT STATE RETURNED BY SCAN WHICH CORRESPONDS  == A C==           TO THE TYPE OF TOKEN RETURNED. SEE "STABLE".     ===A C==                                                            ==EA C==   CLASS : EXTERNAL CLASS SUBROUTINE WHICH TAKES AN ACTION  == A C==           ON EACH STATE "ISTATE" ENCOUNTERED DURING THE    ==EA C==           LEXICAL SCAN AND WHICH RETURNS THE CLASS "ICLASS"== A C==           OF THE NEXT ELEMENT IN "INPUT". THE SUBROUTINE   ===A C==           CLASS HAS THE FOLLOWING ARGUMENTS:               ==1A C==                                                            ===A C==           CALL CLASS(INPUT,NINPUT,ILAST,ISTATE,NSTATE,     == A C==          * CTABLE,ICLASS,RETURN)                           ===A C==                                                            == A C==           WHERE "INPUT" AND "NINPUT" ARE INPUT             ===A C==           PARAMETERS DEFINED ABOVE, "ILAST" IS AN          ===A C==           I/O PARAMETER WHICH KEEPS TRACK OF THE CURRENT   ==OA C==           ELEMENT IN "INPUT" BEING SCANNED (ON INPUT TO    == A C==           "CLASS" "ILAST" IS ASSUMED TO POINT TO THE LAST  == A C==           ELEMENT LOOKED AT BY "CLASS"; "CLASS" WILL THEN  == A C==           USUALLY INCREMENT "ILAST" BY 1 AND RETURN THE    == A C==           CLASS "ICLASS" OF THE ELEMENT POINTED TO BY      == A C==           "ILAST"), "ISTATE" IS AN INPUT PARAMETER WHICH   ===A C==           TELLS "CLASS" THE CURRENT STATE OF THE SCAN, AND == A C==           ON OCCASION IF "ISTATE" IS AN ACTION STATE ON    ===A C==           INPUT TO "CLASS" THEN "CLASS" MAY CHANGE "ISTATE"==NA C==           AND RETURN IT AS AN OUTPUT PARAMETER,            ==EA C==           "NSTATE" AND "CTABLE" ARE INPUT PARAMETERS       ===A C==           DEFINED BELOW,                                   ===A C==           "ICLASS" IS AN OUTPUT PARAMETER WHICH IS THE CLASS= A C==           OF THE NEXT ELEMENT IN "INPUT", AND "RETURN" IS  =="A C==           A L*1 OUTPUT FLAG WHICH TELLS "SCAN" TO RETURN   =="A C==           IF IT IS ".TRUE.".                               ==CA C==                                                            ==HA C==   CTABLE: IS USUALLY AN INTEGER*2 CLASS TABLE "CTABLE(256)".=PA C==           IF "CHAR" IS A CHARACTER (1 BYTE) THEN IT HAS A  == A C==           NUMERIC VALUE "ICHAR" IN THE RANGE               ==NA C==           0 <= "ICHAR" <= 255 AND ITS CLASS NUMBER IS      == A C==           GIVEN BY "CTABLE(ICHAR+1)".                      ==*A C==                                                            ==4A C==   STABLE: LEXICAL SCANNER TRANSITION TABLE DIMENSIONED AS: ==NA C==           STABLE(NSTATE,NCLASS) WHERE "NSTATE" IS THE NUMBER=2A C==           OF TRANSITION STATES AND "NCLASS" IS THE NUMBER  ==*A C==           OF "INPUT" ELEMENT CLASSES.                      == A C==           IF 1 <= "STABLE(ISTATE,ICLASS)" <= NSTATE THEN IT== A C==           IS A TRANSITION STATE.                           == A C==           IF "STABLE(ISTATE,ICLASS)" < 1 THEN IT IS AN     == A C==           OUTPUT STATE AND THE SCAN POINTER "ILAST" IS     == A C==           SHIFTED BY "CLASS" BACK BY 1.                    == A C==           IF "STABLE(ISTATE,ICLASS)" > NSTATE THEN IT IS AN==EA C==           OUTPUT STATE AND THE SCAN POINTER IS NOT CHANGED.== A C==           THE VALUE OF THE OUTPUT STATE IS RETURNED BY     == A C==           "SCAN" IN "ISTATE".                              == A C==                                                            == A C==   NSTATE: NUMBER OF TRANSITION STATES.                     ==TA C==                                                            == A C==   ALGORITHM USED BY "SCAN":                                == A C==   --------- ---- -- ------                                 ==HA C==                                                            ==CA C==   1) ILAST  <-- IFIRST - 1                                 ==IA C==                                                            == A C==   2) ISTATE <-- 1                                          == A C==                                                            == A C==   3) IF "ISTATE" IS AN OUTPUT STATE THEN RETURN.           =="A C==      IF "ISTATE" IS AN ACTION STATE THEN PERFORM THE ACTION.= A C==                                                            ==EA C==   4) ILAST  <-- ILAST + 1                                  ==DA C==                                                            ==CA C==   5) ICLASS <-- CLASS("INPUT(ILAST)")                      == A C==                                                            == A C==   6) ISTATE <-- STABLE(ISTATE,ICLASS)                      == A C==                                                            ==EA C==   7) GO TO 3).                                             == A C==                                                            == A C================================================================TA C================================================================S        INTEGER*2 STABLE(NSTATE,1)       LOGICAL*1 RETURN       ILAST=IFIRST-1       ISTATE=12 10    CALL CLASS(INPUT,NINPUT,ILAST,ISTATE,NSTATE,&      *           CTABLE,ICLASS,RETURN)       IF(RETURN)RETURN"       ISTATE=STABLE(ISTATE,ICLASS)       GO TO 10	       ENDI1       SUBROUTINE CLASS(INPUT,NINPUT,ILAST,ISTATE,T3      *                 NSTATE,CTABLE,ICLASS,RETURN)LA C================================================================ A C================================================================AA C==                                                            ==OA C==   CLASS: ROUTINE USED BY "SCAN" WHICH TAKES ACTION ON EACH =="A C==          STATE "ISTATE" ENCOUNTERED DURING THE LEXICAL SCAN==NA C==          AND WHICH RETURNS THE CLASS "ICLASS" OF THE NEXT  ==AA C==          CHARACTER (ILAST+1'TH CHARACTER) IN "INPUT".      ==EA C==                                                            ==IA C==   WRITTEN BY ARTHUR HAYNES, TRIUMF U.B.C., JANUARY 3, 1980.==XA C==                                                            ==PA C==   INPUT  PARAMETERS: INPUT(NINPUT) (L*1); NINPUT,ILAST,    =="A C==                      ISTATE,NSTATE (I*4); CTABLE(256) (I*2).= A C==                                                            ==YA C==   OUTPUT PARAMETERS: ILAST,ICLASS (I*4); RETURN (L*1).     == A C==                                                            ==AA C==   PARAMETER DEFINITIONS:                                   ==AA C==   --------- -----------                                    =="A C==                                                            == A C==   INPUT : LOGICAL*1 ARRAY OF CHARACTERS TO BE SCANNED FOR  ==CA C==           TOKENS (OR TERMS).                               ==TA C==                                                            ==TA C==   NINPUT: TOTAL NUMBER OF CHARACTERS IN "INPUT".           =="A C==                                                            ==SA C==   ILAST : IS AN I/O PARAMETER WHICH KEEPS TRACK OF THE     ==SA C==           CURRENT CHARACTER IN "INPUT" BEING SCANNED. ON   ==EA C==           INPUT TO "CLASS" "ILAST" POINTS TO THE LAST      ==AA C==           CHARACTER LOOKED AT BY "CLASS". "CLASS" WILL THEN==YA C==           INCREMENT "ILAST" BY 1.                          ==EA C==                                                            ==AA C==   ISTATE: IS AN INPUT PARAMETER WHICH TELLS "CLASS" THE    == A C==           CURRENT STATE OF THE SCAN.                       == A C==           IF 1 <= ISTATE <= NSTATE THEN IT IS A TRANSITION == A C==           STATE AND "CLASS" INCREMENTS THE SCAN POINTER    == A C==           "ILAST" BY 1 AND RETURNS THE CLASS "ICLASS" OF   ==,A C==           THE NEXT CHARACTER IN "INPUT".                   ==TA C==           IF ISTATE < 1 THEN IT IS AN OUTPUT STATE AND THE == A C==           SCAN POINTER "ILAST" IS SHIFTED BY "CLASS" BACK  == A C==           BY 1, "ICLASS" IS NOT RETURNED, AND "RETURN" IS  ===A C==           SET ".TRUE.".                                    ===A C==           IF ISTATE > NSTATE THEN IT IS AN OUTPUT STATE AND== A C==           THE SCAN POINTER "ILAST" IS NOT CHANGED, "ICLASS"==UA C==           IS NOT RETURNED, AND "RETURN" IS SET ".TRUE.".   ==SA C==                                                            ==HA C==   NSTATE: NUMBER OF TRANSITION STATES.                     ==RA C==                                                            == A C==   CTABLE: IS AN INTEGER*2 CLASS TABLE "CTABLE(256)".       ==UA C==           IF "CHAR" IS A CHARACTER (1 BYTE) THEN IT HAS A  == A C==           NUMERIC VALUE "ICHAR" IN THE RANGE               ==RA C==           0 <= "ICHAR" <= 255 AND ITS CLASS NUMBER IS      == A C==           GIVEN BY "CTABLE(ICHAR+1)".                      == A C==                                                            ==RA C==   ICLASS: CLASS OF THE NEXT CHARACTER IN "INPUT" RETURNED  == A C==           BY SUBROUTINE "CLASS" WHEN 1 <= ISTATE <= NSTATE.==IA C==           THE CLASS VALUES ARE GOVERNED BY THE CLASS TABLE ==-A C==           "CTABLE(256)". SEE "CTABLE" ABOVE.               == A C==                                                            ==*A C==   RETURN: IS A L*1 FLAG WHICH TELLS THE ROUTINE (SCAN)     ==(A C==           CALLING "CLASS" TO RETURN IF "RETURN"=.TRUE.     == A C==           "RETURN" IS SET .TRUE. WHEN "ISTATE" IS AN OUTPUT==UA C==           STATE, OTHERWISE IT IS SET .FALSE.               == A C==                                                            ==/A C================================================================ A C================================================================O       INTEGER*2 CTABLE(256)E       INTEGER   ICHAR/0/(       LOGICAL*1 INPUT(1),LCHAR(4),RETURN"       EQUIVALENCE (ICHAR,LCHAR(1))       RETURN=.FALSE.A C================================================================ A C==   IF "ISTATE" < 1 THEN GO TO 40.                           == A C==   IF "ISTATE" > NSTATE THEN GO TO 50.                      == A C================================================================E       IF(ISTATE)40,40,10" 10    IF(ISTATE.GT.NSTATE)GO TO 50A C================================================================ A C==   1 <= ISTATE <= NSTATE: I.E. ISTATE IS A TRANSITION STATE.== A C==   INCREMENT THE SCAN POINTER "ILAST" BY 1.                 == A C==   IF WE'VE ENCOUNTERED THE END OF THE INPUT STRING, I.E.   == A C==   "ILAST" > "NINPUT" THEN GO TO 30.                        == A C==   OTHERWISE RETURN THE CLASS OF THE CHARACTER "INPUT(ILAST)"= A C==   IN "ICLASS".                                             == A C==   GIVEN THE 1 BYTE CHARACTER: INPUT(ILAST) WE CAN DETERMINE== A C==   ITS NUMERIC VALUE "ICHAR" WHICH LIES WITHIN THE RANGE:   == A C==   0 <= ICHAR <= 255. THE CLASS OF THE CHARACTER            == A C==   "INPUT(ILAST)" IS THEN GIVEN BY "CTABLE(ICHAR+1)".       ==OA C================================================================        ILAST=ILAST+1 !       IF(ILAST.GT.NINPUT)GO TO 30        LCHAR(1)=INPUT(ILAST)        ICLASS=CTABLE(ICHAR+1)       RETURNA C================================================================ A C==   "ILAST" > "NINPUT".                                      == A C================================================================  30    ICLASS=1       RETURNA C================================================================ A C==   ISTATE < 1: OUTPUT STATE. DECREMENT "ILAST" BY 1.        == A C================================================================= 40    ILAST=ILAST-1=A C=================================================================A C==   ISTATE > NSTATE: RETURN.                                 ==OA C================================================================C 50    RETURN=.TRUE.,       RETURN	       ENDC       SUBROUTINE CTABL(CTABLE)A C================================================================AA C================================================================"A C==                                                            ==RA C==   CTABL: SETS UP THE INTEGER*2 CLASS TABLE "CTABLE(256)" FOR= A C==          THE EXPRESSION EVALUATOR LEXICAL SCANNER          ==TA C==          TRANSITION TABLE: "STABLE(10,13)".                =="A C==          IF "CHAR" IS A CHARACTER (1 BYTE) THEN IT HAS A   ==UA C==          NUMERIC VALUE "ICHAR" IN THE RANGE                == A C==          0 <= "ICHAR" <= 255 AND ITS CLASS NUMBER IS GIVEN == A C==          BY "CTABLE(ICHAR+1)".                             == A C==                                                            ==.A C==   WRITTEN BY ARTHUR HAYNES, TRIUMF U.B.C., JANUARY 3, 1980.== A C==                                                            == A C==   INPUT  PARAMETERS: NONE.                                 ==IA C==                                                            == A C==   OUTPUT PARAMETERS: CTABLE(256) (I*2).                    == A C==                                                            ==TA C==   CTABLE: IS SET UP WITH THE FOLLOWING CLASS VALUES:       == A C==                                                            ==SA C==           CLASS   CHARACTERS                               == A C==                                                            == A C==             1     END-OF-LINE (ILAST > NINPUT)             ==AA C==             2     INVALID CHARACTERS                       ==UA C==             3     BLANK                                    ==NA C==             4     A-C,F-Z,$,a-c,f-z,_                      == A C==             5     E,D,e,d                                  == A C==             6     0-9                                      ===A C==             7     .                                        ===A C==             8     )]}                                      == A C==             9     ([{                                      ==LA C==            10     ,                                        ===A C==            11     '"                                       ==.A C==            12     +-                                       ==TA C==            13     OPERATOR CHARACTERS: !#%&*:=~^`@;|\<>?/  ===A C==                                                            ==IA C=================================================================A C================================================================I       INTEGER*2 CTABLE(256) "       LOGICAL*1 LCHAR(4),ARRAY(25)       INTEGER   ICHAR/0/"       EQUIVALENCE (LCHAR(1),ICHAR)A C================================================================TA C==   INITIALIZE THE CTABLE ARRAY TO CLASS 2 WHICH CORRESPONDS ==OA C==   TO OTHER CHARACTERS (INVALID CHARACTERS).                == A C================================================================        DO 10 I=1,256E       CTABLE(I)=2T 10    CONTINUEA C================================================================.A C==   CLASS 3: BLANK                                           == A C=================================================================        CALL MOVEC(1,' ',LCHAR(1))       CTABLE(ICHAR+1)=3SA C================================================================TA C==   CLASS 4: A-C,F-Z,$,a-c,f-z,_                             ===A C================================================================N6       CALL MOVEC(25,'ABCFGHIJKLMNOPQRSTUVWXYZ$',ARRAY)       DO 20 I=1,25       LCHAR(1)=ARRAY(I)=       CTABLE(ICHAR+1)=4S 20    CONTINUE6       CALL MOVEC(25,'abcfghijklmnopqrstuvwxyz_',ARRAY)       DO 30 I=1,25       LCHAR(1)=ARRAY(I)        CTABLE(ICHAR+1)=4  30    CONTINUEA C================================================================ A C==   CLASS 5: E,D,e,d                                         ===A C================================================================         CALL MOVEC(4,'EDed',ARRAY)       DO 40 I=1,4=       LCHAR(1)=ARRAY(I)=       CTABLE(ICHAR+1)=5  40    CONTINUEA C=================================================================A C==   CLASS 6: 0-9                                             ===A C================================================================ '       CALL MOVEC(10,'0123456789',ARRAY)        DO 50 I=1,10       LCHAR(1)=ARRAY(I)E       CTABLE(ICHAR+1)=6  50    CONTINUEA C================================================================TA C==   CLASS 7: .                                               ==AA C================================================================C        CALL MOVEC(1,'.',LCHAR(1))       CTABLE(ICHAR+1)=7 A C================================================================ A C==   CLASS 8: )]}                                             == A C================================================================E       CALL MOVEC(3,')]}',ARRAY),       DO 60 I=1,3        LCHAR(1)=ARRAY(I)        CTABLE(ICHAR+1)=8  60    CONTINUEA C================================================================IA C==   CLASS 9: ([{                                             == A C================================================================        CALL MOVEC(3,'([{',ARRAY)        DO 70 I=1,3        LCHAR(1)=ARRAY(I)B       CTABLE(ICHAR+1)=9L 70    CONTINUEA C================================================================ A C==   CLASS 10: ,                                              == A C================================================================         CALL MOVEC(1,',',LCHAR(1))       CTABLE(ICHAR+1)=10A C================================================================ A C==   CLASS 11: '"                                             == A C================================================================        CALL MOVEC(2,'''"',ARRAY)        DO 80 I=1,2        LCHAR(1)=ARRAY(I)        CTABLE(ICHAR+1)=11 80    CONTINUEA C================================================================ A C==   CLASS 12: +-                                             == A C================================================================        CALL MOVEC(2,'+-',ARRAY)       DO 90 I=1,2        LCHAR(1)=ARRAY(I)        CTABLE(ICHAR+1)=12 90    CONTINUEA C================================================================ A C==   CLASS 13: !#%&*:=~^`@;|\<>?/                             == A C================================================================ /       CALL MOVEC(18,'!#%&*:=~^`@;|\<>?/',ARRAY)=       DO 100 I=1,18=       LCHAR(1)=ARRAY(I)=       CTABLE(ICHAR+1)=13 100   CONTINUE       RETURN	       END=C       SUBROUTINE EXRITE(EXPRES,NEXP,FUNCTN,NFUN,VARIAB,NVAR,OPERAT, :      * NOPER,ICODE,NCODE,RCODE,NRCODE,ERROR,IERROR,NERROR)A C=================================================================A C==   EXRITE: IS A DIAGNOSTIC SUBROUTINE FOR TESTING "EXEVAL". ==WA C================================================================)A C==                                                            ===A C==   EXRITE: WRITES OUT THE ARITHMETIC EXPRESSION "EXPRES"    == A C==   ("NEXP" CHARACTERS) ON UNIT 6, FOLLOWED BY A LINE OF "$" ===A C==   SIGNS INDICATING ANY ERRORS, AND A SERIES OF ERROR       == A C==   MESSAGES "ERROR(1,I)",I=1,NERROR, IF ANY. IF THERE ARE NO===A C==   ERRORS (NERROR=0), THEN "EXRITE" TRANSLATES AND WRITES   ===A C==   OUT EACH ITEM IN THE INTEGER*2 CODE: "ICODE(2,NCODE)".   ===A C==   "ICODE(2,NCODE)" IS ASSUMED TO HAVE BEEN FILLED BY       ===A C==   "EXEVAL".                                                ===A C==                                                            ==OA C==   WRITTEN BY ARTHUR HAYNES, TRIUMF U.B.C., JANUARY 3, 1980.== A C==                                                            == A C==   INPUT  PARAMETERS: ALL.                                  ===A C==                                                            ===A C==   PARAMETERS ARE DEFINED IN "EXEVAL".                      == A C==                                                            ===A C=================================================================A C================================================================T3       REAL*8 FUNCTN(1),VARIAB(1),OPERAT(1),RCODE(1)=       INTEGER*2 ICODE(2,1).       LOGICAL*1 EXPRES(1),ERROR(50,1),LINE(80)       INTEGER IERROR(2,1)=8 C     WRITE(6,11)NCODE,(ICODE(1,I),ICODE(2,I),I=1,NCODE) C11   FORMAT(1X,25I3)8       IF(NERROR.LE.0)GO TO 100A C================================================================ A C==   NERROR > 0: THERE ARE ERROR MESSAGES.                    == A C==   WRITE OUT THE EXPRESSION "EXPRES" ON UNIT 6.             == A C==   UNDERNEATH WRITE OUT "$" SIGNS INDICATING THE ERRORS IN  == A C==   THE EXPRESSION "EXPRES", AND WRITE OUT THE ERROR MESSAGES.==A C================================================================L       WRITE(6,10)EXPRES  10    FORMAT(1X,80A1)        CALL SETC(80,LINE,' ')       DO 20 I=1,NERROR(       CALL SETC(1,LINE(IERROR(2,I)),'$') 20    CONTINUE       WRITE(6,10)LINE        DO 30 I=1,NERROR0       WRITE(6,35)IERROR(1,I),(ERROR(J,I),J=1,50)# 35    FORMAT(' ERROR #',I3,1X,50A1)= 30    CONTINUE       RETURN 100   IF(NCODE.LE.0)RETURNA C=================================================================A C==   WRITE OUT THE TRANSLATION OF THE CODE "ICODE(2,NCODE)".  == A C================================================================        DO 110 I=1,NCODE'       IF(ICODE(2,I).GE.-NOPER)GO TO 120=A C================================================================ A C==   "ICODE(2,I)" CORRESPONDS TO A ")", "(", OR ",".          ===A C================================================================H       ICODE2=-ICODE(2,I)-NOPER!       IF(ICODE2.EQ.4)WRITE(6,114)= 114   FORMAT(' )')!       IF(ICODE2.EQ.5)WRITE(6,115)  115   FORMAT(' (')!       IF(ICODE2.EQ.6)WRITE(6,116)= 116   FORMAT(' ,')       GO TO 110 " 120   IF(ICODE(2,I).GE.0)GO TO 130A C================================================================0A C==   "ICODE(2,I)" CORRESPONDS TO AN OPERATOR.                 ===A C================================================================        IOPER=-ICODE(2,I)=       IOPCOD=ICODE(1,I)=.       IF(IOPCOD.EQ.1)WRITE(6,121)OPERAT(IOPER) 121   FORMAT(' UNARY: ',A8),.       IF(IOPCOD.EQ.2)WRITE(6,122)OPERAT(IOPER) 122   FORMAT(' BINARY:  ',A8)=       GO TO 110=% 130   IF(ICODE(2,I).GT.NFUN)GO TO 140 A C================================================================ A C==   "ICODE(2,I)" CORRESPONDS TO A FUNCTION.                  == A C================================================================1/       WRITE(6,135)FUNCTN(ICODE(2,I)),ICODE(1,I)R& 135   FORMAT(1X,A8,1X,I5,' ARGUMENTS')       GO TO 110U* 140   IF(ICODE(2,I).GT.NFUN+NVAR)GO TO 150A C================================================================RA C==   "ICODE(2,I)" CORRESPONDS TO A VARIABLE.                  ===A C================================================================V4       WRITE(6,135)VARIAB(ICODE(2,I)-NFUN),ICODE(1,I)       GO TO 110=A C================================================================ A C==   "ICODE(2,I)" CORRESPONDS TO A REAL*8 CONSTANT.           == A C================================================================"- 150   WRITE(6,155)RCODE(ICODE(2,I)-NFUN-NVAR)S 155   FORMAT(1X,E16.7) 110   CONTINUE       RETURN	       END +       SUBROUTINE EXTABL(FUNCTN,NARGUM,NFUN)RA C================================================================EA C================================================================OA C==                                                            == A C==   EXTABL: SETS UP A TABLE OF "NFUN"=78 STANDARD MATHEMATICAL= A C==           REAL*8 FUNCTIONS.                                ==AA C==                                                            == A C==   WRITTEN BY ARTHUR HAYNES, TRIUMF U.B.C., JANUARY 3, 1980.==MA C==                                                            == A C==   OUTPUT PARAMETERS: FUNCTN(NFUN) (R*8);                   ==AA C==                      NARGUM(2,NFUN),NFUN (I*4).            == A C==                                                            ===A C==   PARAMETER DEFINITIONS:                                   ===A C==   --------- -----------                                    ==TA C==                                                            == A C==   FUNCTN: TABLE OF "NFUN"=78 8-CHARACTER STANDARD          ==1A C==           MATHEMATICAL FUNCTION NAMES.                     == A C==                                                            ===A C==   NARGUM: "NARGUM(1,I)" & "NARGUM(2,I)" (I=1,NFUN) ARE THE == A C==           LOWER & UPPER LIMITS ON THE NUMBER OF ARGUMENTS  ==HA C==           THE FUNCTION "FUNCTN(I)" IS ALLOWED TO HAVE.     ==WA C==                                                            ==IA C==   NFUN  : NFUN=78 IS THE NUMBER OF STANDARD MATHEMATICAL   ===A C==           FUNCTIONS RETURNED BY "EXTABL".                  ==EA C==                                                            == A C================================================================OA C================================================================(       REAL*8     FUNCTN(1)       INTEGER    NARGUM(2,1)
       NFUN=78=A C=================================================================A C==   INITIALIZE THE NUMBER OF FUNCTION ARGUMENTS TO 1.        ==RA C=================================================================       DO 10 K=1,NFUN       NARGUM(1,K)=1=       NARGUM(2,K)=1  10    CONTINUE(       CALL MOVEC(8,'LOG     ',FUNCTN(1))(       CALL MOVEC(8,'log     ',FUNCTN(2))(       CALL MOVEC(8,'LOGE    ',FUNCTN(3))(       CALL MOVEC(8,'loge    ',FUNCTN(4))(       CALL MOVEC(8,'LOG10   ',FUNCTN(5))(       CALL MOVEC(8,'log10   ',FUNCTN(6))(       CALL MOVEC(8,'EXP     ',FUNCTN(7))(       CALL MOVEC(8,'exp     ',FUNCTN(8))(       CALL MOVEC(8,'SQRT    ',FUNCTN(9)))       CALL MOVEC(8,'sqrt    ',FUNCTN(10))1)       CALL MOVEC(8,'SIN     ',FUNCTN(11)) )       CALL MOVEC(8,'sin     ',FUNCTN(12))=)       CALL MOVEC(8,'SINE    ',FUNCTN(13))=)       CALL MOVEC(8,'sine    ',FUNCTN(14))N)       CALL MOVEC(8,'COS     ',FUNCTN(15))=)       CALL MOVEC(8,'cos     ',FUNCTN(16))=)       CALL MOVEC(8,'COSINE  ',FUNCTN(17))=)       CALL MOVEC(8,'cosine  ',FUNCTN(18)).)       CALL MOVEC(8,'TAN     ',FUNCTN(19))T)       CALL MOVEC(8,'tan     ',FUNCTN(20))E)       CALL MOVEC(8,'TANGENT ',FUNCTN(21)):)       CALL MOVEC(8,'tangent ',FUNCTN(22))2)       CALL MOVEC(8,'ASIN    ',FUNCTN(23))=)       CALL MOVEC(8,'asin    ',FUNCTN(24))=)       CALL MOVEC(8,'ARSIN   ',FUNCTN(25))C)       CALL MOVEC(8,'arsin   ',FUNCTN(26))=)       CALL MOVEC(8,'ARCSINE ',FUNCTN(27))=)       CALL MOVEC(8,'arcsine ',FUNCTN(28))))       CALL MOVEC(8,'ACOS    ',FUNCTN(29))G)       CALL MOVEC(8,'acos    ',FUNCTN(30))2)       CALL MOVEC(8,'ARCOS   ',FUNCTN(31))=)       CALL MOVEC(8,'arcos   ',FUNCTN(32))=)       CALL MOVEC(8,'ARCOSINE',FUNCTN(33)) )       CALL MOVEC(8,'arcosine',FUNCTN(34))=)       CALL MOVEC(8,'ATAN    ',FUNCTN(35))=)       CALL MOVEC(8,'atan    ',FUNCTN(36))2)       CALL MOVEC(8,'ARTAN   ',FUNCTN(37))=)       CALL MOVEC(8,'artan   ',FUNCTN(38))=)       CALL MOVEC(8,'ARCTAN  ',FUNCTN(39))E)       CALL MOVEC(8,'arctan  ',FUNCTN(40)) )       CALL MOVEC(8,'ATAN2   ',FUNCTN(41))=)       CALL MOVEC(8,'atan2   ',FUNCTN(42))C)       CALL MOVEC(8,'ARTAN2  ',FUNCTN(43)),)       CALL MOVEC(8,'artan2  ',FUNCTN(44)) )       CALL MOVEC(8,'ARCTAN2 ',FUNCTN(45)),)       CALL MOVEC(8,'arctan2 ',FUNCTN(46))=       DO 46 I=41,46=       NARGUM(1,I)=2=       NARGUM(2,I)=2= 46    CONTINUE)       CALL MOVEC(8,'SINH    ',FUNCTN(47)) )       CALL MOVEC(8,'sinh    ',FUNCTN(48))=)       CALL MOVEC(8,'COSH    ',FUNCTN(49))A)       CALL MOVEC(8,'cosh    ',FUNCTN(50))F)       CALL MOVEC(8,'TANH    ',FUNCTN(51))A)       CALL MOVEC(8,'tanh    ',FUNCTN(52)) )       CALL MOVEC(8,'ABS     ',FUNCTN(53))A)       CALL MOVEC(8,'abs     ',FUNCTN(54))0)       CALL MOVEC(8,'ABSOLUTE',FUNCTN(55)) )       CALL MOVEC(8,'absolute',FUNCTN(56))P)       CALL MOVEC(8,'MAX     ',FUNCTN(57)) )       CALL MOVEC(8,'max     ',FUNCTN(58)),)       CALL MOVEC(8,'MAXIMUM ',FUNCTN(59)) )       CALL MOVEC(8,'maximum ',FUNCTN(60)) )       CALL MOVEC(8,'MIN     ',FUNCTN(61)) )       CALL MOVEC(8,'min     ',FUNCTN(62)) )       CALL MOVEC(8,'MINIMUM ',FUNCTN(63)) )       CALL MOVEC(8,'minimum ',FUNCTN(64))        DO 64 I=57,64        NARGUM(1,I)=2=       NARGUM(2,I)=2" 64    CONTINUE)       CALL MOVEC(8,'INT     ',FUNCTN(65))A)       CALL MOVEC(8,'int     ',FUNCTN(66)) )       CALL MOVEC(8,'INTEGER ',FUNCTN(67)) )       CALL MOVEC(8,'integer ',FUNCTN(68))M)       CALL MOVEC(8,'IFIX    ',FUNCTN(69))A)       CALL MOVEC(8,'ifix    ',FUNCTN(70))I)       CALL MOVEC(8,'MOD     ',FUNCTN(71)) )       CALL MOVEC(8,'mod     ',FUNCTN(72))O)       CALL MOVEC(8,'MODULUS ',FUNCTN(73)) )       CALL MOVEC(8,'modulus ',FUNCTN(74)) )       CALL MOVEC(8,'SIGN    ',FUNCTN(75)) )       CALL MOVEC(8,'sign    ',FUNCTN(76)) )       CALL MOVEC(8,'DIM     ',FUNCTN(77)) )       CALL MOVEC(8,'dim     ',FUNCTN(78))        DO 78 I=71,78        NARGUM(1,I)=2=       NARGUM(2,I)=2= 78    CONTINUE       RETURN	       END=,       SUBROUTINE EXOPER(OPERAT,IPRIOR,NOPER)A C================================================================ A C=================================================================A C==                                                            == A C==   EXOPER: SETS UP A TABLE OF THE STANDARD MATHEMATICAL AND ===A C==           LOGICAL OPERATORS IN "OPERAT" & "IPRIOR".        ==MA C==                                                            == A C==   WRITTEN BY ARTHUR HAYNES, TRIUMF U.B.C., JANUARY 3, 1980.== A C==                                                            ==LA C==   OUTPUT PARAMETERS: OPERAT(NOPER) (R*8);                  ==NA C==                      IPRIOR(2,NOPER),NOPER (I*4).          =='A C==                                                            == A C==   PARAMETER DEFINITIONS:                                   == A C==   --------- -----------                                    ==AA C==                                                            ==UA C==   OPERAT: TABLE OF "NOPER"=28 8-CHARACTER STANDARD         ==MA C==           MATHEMATICAL AND LOGICAL OPERATORS.              ==NA C==                                                            ==CA C==   IPRIOR: TABLE OF "NOPER"=28 * 2 OPERATOR PRIORITIES WHICH==)A C==           GIVE THE PRECEDENCE OF THE OPERATOR, THE TYPE OF =='A C==           THE OPERATOR (UNARY OR BINARY), AND THE          == A C==           ASSOCIATIVITY OF THE OPERATOR (LEFT OR RIGHT).   ==IA C==           SEE SUBROUTINE "EXEVAL" UNDER "IPRIOR" FOR MORE  == A C==           DETAILS.                                         == A C==                                                            ==AA C==   NOPER : NOPER=28 IS THE NUMBER OF STANDARD MATHEMATICAL  ==UA C==           AND LOGICAL OPERATORS RETURNED BY "EXOPER".      ==MA C==                                                            ==NA C================================================================CA C================================================================)       REAL*8 OPERAT(1),OPER(28),)       INTEGER IPRIOR(2,NOPER),IPRIO(2,28),A C================================================================LA C==   DEFINE OPERATORS USING DATA STATEMENT.                   ==CA C================================================================VA       DATA OPER/'"OR"','|','"XOR"','"\"','"AND"','&','"NOT"','~',48      *'"LT"','<','"EQ"','=','"GT"','>','"LE"','<=','~>',8      *'"NE"','~=','<>','"GE"','>=','~<','+','-','*','/',      *'**'/E8       DATA IPRIO/0,1, 0,1, 0,1, 0,1, 0,2, 0,2, 3,0, 3,0,=      *           0,4, 0,4, 0,4, 0,4, 0,4, 0,4, 0,4, 0,4, 0,4,UB      *           0,4, 0,4, 0,4, 0,4, 0,4, 0,4, 5,5, 5,5, 0,6, 0,6,      *           0,-7/A C================================================================CA C==   FILL OPERATOR ARRAYS: "OPERAT" AND "IPRIOR".             ==)A C================================================================'       NOPER=28       DO 100 I=1,NOPER%       CALL MOVEC(8,OPER(I),OPERAT(I))M       DO 200 J=1,2       IPRIOR(J,I)=IPRIO(J,I) 200   CONTINUE 100   CONTINUE       RETURN	       ENDU/       SUBROUTINE EXCALC(NFUN,VARIAB,NVAR,ICODE,62      *                  NCODE,RCODE,NRCODE,CALC,*)A C================================================================uA C================================================================ A C==                                                            ==NA C==   EXCALC: USES THE NUMBER OF FUNCTIONS "NFUN",             ==CA C==           THE VARIABLES WITH VALUES STORED IN              ==)A C==           "VARIAB", THE CONSTANTS STORED IN "RCODE", AND   =='A C==           THE REVERSE POLISH NOTATION INTEGER*2 CODE:      == A C==           "ICODE(2,NCODE)" TO CALCULATE THE RESULT "CALC". ==UA C==           THE CODE "ICODE" WAS GENERATED PREVIOUSLY USING  == A C==           "EXEVAL" ON THE ARITHMETIC EXPRESSION AND THE    == A C==           FUNCTION AND OPERATOR TABLES DEFINED BY "EXTABL" ==AA C==           AND "EXOPER". VARIABLES CAN'T HAVE ANY INDICES.  ==GA C==           "EXCALC" USES AN INTERNAL REAL*8 STACK:          == A C==           "STACK(100)" TO CALCULATE THE RESULT "CALC".     ===A C==           IF THE STACK OVERFLOWS OR UNDERFLOWS THEN "EXCALC"==A C==           PRINTS OUT AN ERROR MESSAGE ON UNIT 6 AND RETURNS== A C==           VIA RETURN1.                                     == A C==           IF THE FINAL STACK INDEX "ISTACK" IS NOT EQUAL TO== A C==           1, I.E. THE BOTTOM OF THE STACK, THEN "EXCALC"   == A C==           PRINTS OUT AN ERROR MESSAGE ON UNIT 6 AND RETURNS== A C==           VIA RETURN1.                                     == A C==                                                            ==PA C==   WRITTEN BY ARTHUR HAYNES, TRIUMF U.B.C., JANUARY 3, 1980.== A C==                                                            == A C==   INPUT  PARAMETERS: NFUN (I*4); VARIAB(NVAR) (R*8);       ==EA C==                      NVAR (I*4); ICODE(2,NCODE) (I*2);     ==-A C==                      NCODE (I*4); RCODE(NRCODE) (R*8);     == A C==                      NRCODE (I*4).                         == A C==                                                            == A C==   OUTPUT PARAMETERS: CALC (R*8).                           == A C==                                                            == A C==   PARAMETER DEFINITIONS:                                   == A C==   --------- -----------                                    == A C==                                                            == A C==   NFUN  : NUMBER OF FUNCTIONS.                             == A C==                                                            == A C==   VARIAB: ARRAY OF "NVAR" REAL*8 VALUES CORRESPONDING TO   == A C==           THE TABLE OF "NVAR" 8-CHARACTER VARIABLE NAMES   == A C==           "VARIAB" PASSED TO "EXEVAL". THIS ARRAY MUST BE  == A C==           IN PARALLEL WITH THE TABLE OF VARIABLE NAMES.    == A C==                                                            ===A C==   NVAR  : NUMBER OF REAL*8 VARIABLE VALUES IN "VARIAB".    ===A C==                                                            ==OA C==   ICODE : ARRAY OF "NCODE"*2 INTEGER*2 CODES WHICH         ===A C==           CORRESPOND TO THE REVERSE POLISH FORM OF THE     == A C==           ARITHMETIC EXPRESSION "EXPRES" WHICH IS PASSED TO===A C==           "EXEVAL". "ICODE" IS RETURNED BY "EXEVAL".       == A C==           FOR MORE INFORMATION ON "ICODE" SEE "EXEVAL".    == A C==           "EXCALC" ASSUMES THE FOLLOWING CODES FOR THE     =='A C==           OPERATORS AS DEFINED BY "EXOPER":                ==AA C==                                                            ==4A C==   ICODE(2,N)    ICODE(1,N)    DESCRIPTION                  ==,A C==                                                            == A C==      -1         2 = BINARY    "OR"  (LOGICAL "OR").        == A C==      -2         2 = BINARY     |    (LOGICAL "OR").        == A C==      -3         2 = BINARY    "XOR" (LOGICAL EXCLUSIVE OR).== A C==      -4         2 = BINARY     \    (LOGICAL EXCLUSIVE OR).==OA C==      -5         2 = BINARY    "AND" (LOGICAL "AND").       == A C==      -6         2 = BINARY     &    (LOGICAL "AND").       ==EA C==      -7         1 = UNARY     "NOT" (LOGICAL "NOT").       ==DA C==      -8         1 = UNARY      ~    (LOGICAL "NOT").       ===A C==      -9         2 = BINARY    "LT"  (LOGICAL LESS THAN).   ===A C==     -10         2 = BINARY     <    (LOGICAL LESS THAN).   == A C==     -11         2 = BINARY    "EQ"  (LOGICAL EQUALS).      ==,A C==     -12         2 = BINARY     =    (LOGICAL EQUALS).      == A C==     -13         2 = BINARY    "GT"  (LOGICAL GREATER THAN).==RA C==     -14         2 = BINARY     >    (LOGICAL GREATER THAN).==*A C==     -15         2 = BINARY    "LE"  (LESS THAN OR EQUALS). ==EA C==     -16         2 = BINARY     <=   (LESS THAN OR EQUALS). ==IA C==     -17         2 = BINARY     ~>   (NOT GREATER THAN, OR  ==OA C==                                      LESS THAN OR EQUALS). ==DA C==     -18         2 = BINARY    "NE"  (LOGICAL NOT EQUALS).  ==AA C==     -19         2 = BINARY     ~=   (LOGICAL NOT EQUALS).  ==AA C==     -20         2 = BINARY     <>   (LOGICAL NOT EQUALS).  ==TA C==     -21         2 = BINARY    "GE"  (GREATER THAN OR EQUALS)=SA C==     -22         2 = BINARY     >=   (GREATER THAN OR EQUALS)= A C==     -23         2 = BINARY     ~<   (NOT LESS THAN, OR     == A C==                                      GREATER THAN OR EQUALS)=SA C==     -24         1 = UNARY      +    (PLUS).                ==EA C==                 2 = BINARY                                 == A C==     -25         1 = UNARY      -    (MINUS).               == A C==                 2 = BINARY                                 == A C==     -26         2 = BINARY     *    (MULTIPLICATION).      ==NA C==     -27         2 = BINARY     /    (DIVISION).            == A C==     -28         2 = BINARY     **   (EXPONENTIATION).      == A C==                                                            ==EA C==     NOTE: LOGICAL OPERATORS MAY HAVE ARITHMETIC OPERANDS   ==EA C==           AS IN "GT" OR THEY MAY HAVE LOGICAL OPERANDS     == A C==           AS IN "OR". THE RESULT OF A LOGICAL OPERATOR IS  == A C==           ALWAYS LOGICAL. ALL THE OPERANDS AND RESULTS OF  == A C==           LOGICAL OPERATORS ARE STORED AS REAL*8 NUMBERS.  == A C==           WE USE THE FOLLOWING CONVENTION TO INTERPRET     == A C==           LOGICAL OPERANDS AND TO DEFINE LOGICAL RESULTS:  == A C==        1) IF A REAL*8 NUMBER "R" IS A LOGICAL OPERAND THEN == A C==           ITS LOGICAL VALUES ARE ".TRUE." IF "R" IS        == A C==           NON-ZERO AND ".FALSE." IF R IS ZERO.             == A C==        2) IF A REAL*8 NUMBER "R" IS A LOGICAL RESULT THEN  ==SA C==           IT IS STORED AS "1.D0" IF IT IS ".TRUE.", AND    ==IA C==           IT IS STORED AS "0.D0" IF IT IS ".FALSE." .      ==RA C==                                                            ==BA C==                                                            == A C==   NCODE : NUMBER OF INTEGER*2 CODES IN "ICODE(2,NCODE)".   == A C==                                                            == A C==   RCODE : ARRAY OF "NRCODE" REAL*8 CONSTANTS WHICH APPEAR  ==WA C==           IN THE EXPRESSION "EXPRES" PASSED TO "EXEVAL".   ==RA C==           SEE "EXEVAL".                                    ==HA C==                                                            ==XA C==   NRCODE: NUMBER OF REAL*8 CONSTANTS STORED IN "RCODE".    == A C==                                                            ==SA C==   CALC  : REAL*8 VALUE WHICH IS THE FINAL RESULT OF THE    == A C==           CALCULATION OF THE REVERSE POLISH CODE "ICODE".  == A C==           IF "NCODE" <= 0 THEN "CALC" IS RETURNED AS 0.D0. == A C==           IF AN ERROR OCCURS DUE TO AN OVERFLOW, UNDERFLOW,== A C==           OR IF THE FINAL STACK INDEX IS NOT 1, THEN       =="A C==           "CALC" IS RETURNED AS 0.D0.                      =="A C==                                                            ==EA C================================================================EA C================================================================"       IMPLICIT REAL*8 (A-H,O-Z)        INTEGER*2 ICODE(2,1)*       REAL*8 VARIAB(1),RCODE(1),STACK(100)       LOGICAL*1 TRUEA C================================================================LA C==   CALC DEFAULTS TO 0.D0                                    ==LA C================================================================L       CALC=0.D0.       IF(NCODE.LE.0)RETURNA C================================================================ A C==   INITIALIZE THE STACK INDEX "ISTACK" TO 0.                == A C================================================================        ISTACK=0       NFNV=NFUN+NVAR       DO 1000 I=1,NCODE        ICODE2=ICODE(2,I)L       IF(ICODE2.GT.0)GO TO 1300 A C================================================================ A C==   "ICODE2" CORRESPONDS TO OPERATOR "OPERAT(|ICODE2|)".     == A C==   SEE ABOVE TABLE UNDER "ICODE" PARAMETER DEFINTION.       == A C==   SAVE "ISTACK" IN "ISTAC1" AND DECREMENT "ISTACK" BY 1.   == A C==   IF "ICODE1" = 1 THEN THE OPERATOR IS UNARY AND "ISTAC1"  == A C==                   IS USED. CHECK "ISTAC1" FOR AN UNDERFLOW.== A C==   IF "ICODE1" = 2 THEN THE OPERATOR IS BINARY AND "ISTACK" == A C==                   IS USED. CHECK "ISTACK" FOR AN UNDERFLOW.== A C================================================================        ICODE2=-ICODE2       ISTAC1=ISTACKA       ISTACK=ISTACK-1        ICODE1=ICODE(1,I) A C================================================================ A C==   CHECK FOR AN UNDERFLOW. IF AN UNDERFLOW OCCURS GO TO 2100== A C================================================================        GO TO (1001,1002),ICODE1 1001  IF(ISTAC1.LE.0)GO TO 2100        GO TO 1005 1002  IF(ISTACK.LE.0)GO TO 2100 A C================================================================ A C==   GO TO THE SECTION CORRESPONDING TO THE OPERATOR CODE     == A C==   "ICODE2".                                                ==OA C================================================================S? 1005  GO TO (1010,1010,1020,1020,1030,1030,1040,1040,1050,1050, ?      *       1060,1060,1070,1070,1080,1080,1080,1090,1090,1090, <      *       1100,1100,1100,1110,1120,1130,1140,1150),ICODE2       GO TO 1000A C================================================================EA C==   ICODE2 = -1 OR -2: LOGICAL "OR".                         ==PA C================================================================*; 1010  TRUE=STACK(ISTACK).NE.0.D0 .OR. STACK(ISTAC1).NE.0.D0        GO TO 1105A C================================================================"A C==   ICODE2 = -3 OR -4: LOGICAL EXCLUSIVE OR: "XOR".          =="A C================================================================"@ 1020  TRUE=(STACK(ISTACK).EQ.0.D0.OR.STACK(ISTACK).EQ.0.D0).AND.0      *     (STACK(ISTACK)+STACK(ISTAC1).NE.0.D0)       GO TO 1105A C================================================================ A C==   ICODE2 = -5 OR -6: LOGICAL "AND".                        == A C================================================================ < 1030  TRUE=STACK(ISTACK).NE.0.D0 .AND. STACK(ISTAC1).NE.0.D0       GO TO 1105A C================================================================EA C==   ICODE2 = -7 OR -8: LOGICAL "NOT" (UNARY).                == A C================================================================  1040  ISTACK=ISTAC1         TRUE=STACK(ISTACK).EQ.0.D0       GO TO 1105A C================================================================ A C==   ICODE2 = -9 OR -10: LOGICAL LESS THAN "LT".              ==TA C================================================================E) 1050  TRUE=STACK(ISTACK).LT.STACK(ISTAC1)        GO TO 1105A C================================================================EA C==   ICODE2 = -11 OR -12: LOGICAL EQUALS "EQ".                ==NA C================================================================ ) 1060  TRUE=STACK(ISTACK).EQ.STACK(ISTAC1)        GO TO 1105A C=================================================================A C==   ICODE2 = -13 OR -14: LOGICAL GREATER THAN "GT".          ===A C================================================================ ) 1070  TRUE=STACK(ISTACK).GT.STACK(ISTAC1))       GO TO 1105A C=================================================================A C==   ICODE2 = -15, -16, OR -17: LOGICAL LESS THAN OR EQUALS   == A C==                              "LE".                         ===A C================================================================U) 1080  TRUE=STACK(ISTACK).LE.STACK(ISTAC1)=       GO TO 1105A C================================================================ A C==   ICODE2 = -18, -19, OR -20: LOGICAL NOT EQUALS "NE".      ===A C================================================================C) 1090  TRUE=STACK(ISTACK).NE.STACK(ISTAC1)O       GO TO 1105A C=================================================================A C==   ICODE2 = -21, -22, OR -23: LOGICAL GREATER THAN OR EQUALS===A C==                              "GE".                         ===A C=================================================================) 1100  TRUE=STACK(ISTACK).GE.STACK(ISTAC1) A C================================================================SA C==   STORE LOGICAL RESULT IN STACK(ISTACK).                   == A C==   .TRUE. = 1.D0; .FALSE. = 0.D0.                           ==SA C================================================================= 1105  STACK(ISTACK)=0.D0        IF(TRUE)STACK(ISTACK)=1.D0       GO TO 1000A C=================================================================A C==   ICODE2 = -24: PLUS, (UNARY OR BINARY).                   ==RA C================================================================= 1110  GO TO (1111,1112),ICODE1A C================================================================ A C==   UNARY PLUS.                                              ===A C================================================================  1111  ISTACK=ISTAC1R       GO TO 1000A C================================================================ A C==   BINARY PLUS.                                             ===A C================================================================4/ 1112  STACK(ISTACK)=STACK(ISTACK)+STACK(ISTAC1)0       GO TO 1000A C================================================================1A C==   ICODE2 = -25: MINUS, (UNARY OR BINARY).                  ===A C================================================================. 1120  GO TO (1121,1122),ICODE1A C================================================================0A C==   UNARY MINUS.                                             ==OA C================================================================= 1121  ISTACK=ISTAC12"       STACK(ISTACK)=-STACK(ISTACK)       GO TO 1000A C================================================================"A C==   BINARY MINUS.                                            == A C================================================================ / 1122  STACK(ISTACK)=STACK(ISTACK)-STACK(ISTAC1)=       GO TO 1000A C================================================================ A C==   ICODE2 = -26: MULTIPLICATION.                            == A C================================================================ / 1130  STACK(ISTACK)=STACK(ISTACK)*STACK(ISTAC1)=       GO TO 1000A C================================================================ A C==   ICODE2 = -27: DIVISION.                                  ===A C================================================================ / 1140  STACK(ISTACK)=STACK(ISTACK)/STACK(ISTAC1)=       GO TO 1000A C================================================================ A C==   ICODE2 = -28: EXPONENTIATION.                            ===A C================================================================  1150  STACK1=STACK(ISTAC1)&       IPOWER=STACK1+DSIGN(.5D0,STACK1)1       IF(DABS(STACK1-IPOWER).LE.1.D-14)GO TO 1151L)       STACK(ISTACK)=STACK(ISTACK)**STACK1=       GO TO 1000) 1151  STACK(ISTACK)=STACK(ISTACK)**IPOWERE       GO TO 1000" 1300  IF(ICODE2.GT.NFUN)GO TO 1400A C=================================================================A C==   "ICODE2" CORRESPONDS TO THE FUNCTION NUMBER "ICODE2".    ===A C==   NARG = ICODE(1,I) = NUMBER OF FUNCTION ARGUMENTS.        ==0A C==   IF "ISTACK" UNDERFLOWS GO TO 2100.                       ===A C================================================================C       NARG=ICODE(1,I):       ISTACK=ISTACK-NARG+1       IF(ISTACK.LE.0)GO TO 2100 A C=================================================================A C==   GO TO THE APPROPRIATE FUNCTION GIVEN BY "ICODE2".        ==LA C=================================================================       GO TO=D      * ( 1, 1, 1, 1, 5, 5, 7, 7, 9, 9,11,11,11,11,15,15,15,15,19,19,D      *  19,19,23,23,23,23,23,23,29,29,29,29,29,29,35,35,35,35,35,35,D      *  41,41,41,41,41,41,47,47,49,49,51,51,53,53,53,53,57,57,57,57,E      *  61,61,61,61,65,65,65,65,65,65,71,71,71,71,75,75,77,77),ICODE2=       GO TO 1000& 1     STACK(ISTACK)=LOG(STACK(ISTACK))       GO TO 1000( 5     STACK(ISTACK)=LOG10(STACK(ISTACK))       GO TO 1000& 7     STACK(ISTACK)=EXP(STACK(ISTACK))       GO TO 1000' 9     STACK(ISTACK)=SQRT(STACK(ISTACK))=       GO TO 1000& 11    STACK(ISTACK)=SIN(STACK(ISTACK))       GO TO 1000& 15    STACK(ISTACK)=COS(STACK(ISTACK))       GO TO 1000& 19    STACK(ISTACK)=TAN(STACK(ISTACK))       GO TO 1000' 23    STACK(ISTACK)=ASIN(STACK(ISTACK))        GO TO 1000' 29    STACK(ISTACK)=ACOS(STACK(ISTACK))=       GO TO 1000' 35    STACK(ISTACK)=ATAN(STACK(ISTACK))        GO TO 10008 41    STACK(ISTACK)=ATAN2(STACK(ISTACK),STACK(ISTACK+1))       GO TO 1000' 47    STACK(ISTACK)=SINH(STACK(ISTACK))        GO TO 1000' 49    STACK(ISTACK)=COSH(STACK(ISTACK))=       GO TO 1000' 51    STACK(ISTACK)=TANH(STACK(ISTACK))*       GO TO 1000& 53    STACK(ISTACK)=ABS(STACK(ISTACK))       GO TO 10006 57    STACK(ISTACK)=MAX(STACK(ISTACK),STACK(ISTACK+1))       GO TO 10006 61    STACK(ISTACK)=MIN(STACK(ISTACK),STACK(ISTACK+1))       GO TO 1000' 65    STACK(ISTACK)=AINT(STACK(ISTACK))S       GO TO 10006 71    STACK(ISTACK)=MOD(STACK(ISTACK),STACK(ISTACK+1))       GO TO 10007 75    STACK(ISTACK)=SIGN(STACK(ISTACK),STACK(ISTACK+1))        GO TO 10006 77    STACK(ISTACK)=DIM(STACK(ISTACK),STACK(ISTACK+1))       GO TO 1000" 1400  IF(ICODE2.GT.NFNV)GO TO 1500A C================================================================.A C==   "ICODE2" CORRESPONDS TO A VARIABLE "VARIAB(ICODE2-NFUN)".== A C==   PUSH "VARIAB(ICODE2-NFUN)" ONTO THE STACK.               == A C==   IF THE STACK OVERFLOWS GO TO 2000.                       ===A C================================================================S!       IF(ISTACK.GE.100)GO TO 2000        ISTACK=ISTACK+1E'       STACK(ISTACK)=VARIAB(ICODE2-NFUN)        GO TO 1000A C=================================================================A C==   "ICODE2" CORRESPONDS TO A REAL*8 CONSTANT                ==GA C==   "RCODE(ICODE2-NFNV)". PUSH "RCODE(ICODE2-NFNV)" ONTO THE ==OA C==   STACK. IF THE STACK OVERFLOWS GO TO 2000.                ===A C================================================================ ! 1500  IF(ISTACK.GE.100)GO TO 2000=       ISTACK=ISTACK+1=&       STACK(ISTACK)=RCODE(ICODE2-NFNV) 1000  CONTINUEA C================================================================2A C==   IF THE FINAL STACK INDEX "ISTACK" IS NOT EQUAL TO 1, I.E.==1A C==   THE BOTTOM OF THE STACK THEN GO TO 2200.                 ===A C==   OTHERWISE STORE THE RESULT OF THE CALCULATION IN "CALC". ==2A C================================================================        IF(ISTACK.NE.1)GO TO 2200        CALC=STACK(ISTACK)       RETURNA C================================================================IA C==   ERROR MESSAGES ON UNIT 6.                                ===A C================================================================K 2000  WRITE(6,2010)=8 2010  FORMAT(' ***ERROR*** STACK OVERFLOW IN "EXCALC".')
       RETURN1= 2100  WRITE(6,2110)=9 2110  FORMAT(' ***ERROR*** STACK UNDERFLOW IN "EXCALC".'/AG      *       '             THIS MEANS THE REVERSE POLISH CODE "ICODE"',=      *       ' IS INVALID.')
       RETURN1= 2200  WRITE(6,2210)ISTACK4F 2210  FORMAT(' ***ERROR*** FINAL VALUE OF ISTACK =',I3,'IN "EXCALC".',G      *       '             THIS MEANS THE REVERSE POLISH CODE "ICODE"',D      *       ' IS INVALID.')
       RETURN1=	       END=