A       SUBROUTINE FILE_ASSIGN(LUN,FNAME,PROMPT,PLOT_MODE,NEW_FILE, (      >                       IERROR,*,*) C 3 C   reqd. KOSTL: routines - CLRLINE,LEFTJUST,SLEEP2  C G C====================================================================== G C==                                                                  == G C==   Purpose:  Connects logical unit number LUN to a file named     == G C==             either in FNAME or interactively.                    == G C==                                                                  == G C==   First written by C. J. Kost, TRIUMF U.B.C., July 29, 1980.     == G C==   Extensively revised by Alan Carruthers, TRIUMF U.B.C.,         == G C==   July 2, 1982.                                                  == G C==                                                                  == G C==   Input  Parameters:  LUN            (INTEGER*4)                 == G C==                       FNAME          (CHARACTER*60)              == G C==                       PROMPT         (CHARACTER*(*))             == G C==                       PLOT_MODE      (LOGICAL)                   == G C==                       NEW_FILE       (LOGICAL)                   == G C==                                                                  == G C==   Output Parameters:  FNAME          (CHARACTER*60)              == G C==                       IERROR         (INTEGER*4)                 == G C==                                                                  == G C==   Alternate Returns:  (1) Failure to open file in non-           == G C==                           interactive mode                       == G C==                       (2) Unrecoverable failure to open file     == G C==                           in interactive mode.  Unrecoverable    == G C==                           failures include any FORTRAN run-time  == G C==                           error except: a) non-existent file     == G C==                                         b) bad filename syntax   == G C==                                                                  == G C==   Interactive Mode: The user is interactively prompted for a     == G C==        filename whenever FNAME on entry to FILE_ASSIGN           == G C==        is entirely blank or if LUN < 0.  The NEW_FILE parameter  == G C==        determines whether or not an OLD or NEW file is opened.   == G C==        Old files are opened with READONLY access.  New files     == G C==        are opened with  'LIST' carriage control processing.      == H C==        (When sending output to the specified file, 'LIST'        == G C==        processing results in single spacing between records.)    == G C==                                                                  == G C==   Non-interactive Mode: If FNAME on entry is non-blank and       == G C==        LUN > -1,  FILE_ASSIGN will immmediately open the         == G C==        specified file.  The NEW_FILE parameter determines        == G C==        whether or not an OLD or NEW file is opened.  The user    == G C==        is not prompted for information.                          == G C==                                                                  == G C==   Parameters:                                                    == G C==   ----------                                                     == G C==                                                                  == G C==   LUN       : Logical unit number that file is connected to.     == G C==               On entry, if LUN < 0, then FNAME will be blanked   == G C==               then interactively obtained from the implicit      == G C==               FORTRAN logical unit FOR$ACCEPT (will default to   == G C==               SYS$INPUT).                                        == G C==                                                                  == G C==   FNAME     : Name of file.  If FNAME is completely blank on     == G C==               entry to FILE_ASSIGN, FNAME will be interactively  == G C==               obtained.  If LUN < 0 on entry, FNAME will be      == G C==               blanked then interactively obtained.               == G C==                                                                  == G C==               On exit from FILE_ASSIGN, FNAME contains the name  == G C==               of the specified file.                             == G C==                                                                  == G C==   PROMPT    : Character string used to prompt user for FNAME     == G C==               in interactive mode.                               == G C==                                                                  == G C==   PLOT_MODE : If .TRUE., indicates that user is in graphics mode.== G C==                 Prompts are displayed at bottom of screen.       == G C==               If .FALSE., prompts are displayed on successive    == G C==                 screen lines with carriage returns.              == G C==                                                                  == G C==   NEW_FILE  : On entry, if NEW_FILE = .TRUE. then a new file     == G C==               will be opened, otherwise an old file will be      == G C==               opened.                                            == G C==                                                                  == G C==   IERROR    : On a RETURN 1 or RETURN 2, IERROR contains the     == G C==               FORTRAN run-time error number (see Section 7.1     == G C==               of the VAX-11 FORTRAN User's Guide).               == G C==               IERROR = 0 if no error return is taken.            == G C==                                                                  == G C== Modified by J. Chuma on March 21, 1985 to allow large record     == G C== length (i.e. 256).                                               == G C======================================================================        INTEGER SIZE       PARAMETER (SIZE=60) $       CHARACTER*60 FNAME, BLANK_NAME       CHARACTER PROMPT*(*)       CHARACTER*1 CHAR!       LOGICAL PLOT_MODE, NEW_FILE G C====================================================================== G C==   The following COMMON blocks hold the input and output logical  == G C==   unit numbers used by FILE_ASSIGN for prompting and reading     == G C==   user responses.  These particular COMMON blocks are used so    == G C==   as to be compatible with plotting routines.                    == G C==                                                                  == G C==   By default, input is attached to logical unit 5, output to     == G C==   unit 6.  The calling program need not specify these common     == G C==   blocks if these defaults are acceptable.                       == G C====================================================================== %       COMMON /PLOT_OUTPUT_UNIT/ IOUTS #       COMMON /PLOT_INPUT_UNIT/ IINS        DATA IINS/5/, IOUTS/6/       DATA RECLEN /256/  C  C 6       BLANK_NAME = '                              ' //3      >             '                              ' '       IF(LUN .LT. 0) FNAME = BLANK_NAME        LUNN = IABS(LUN)       IERROR = 0D       IF(FNAME .EQ. BLANK_NAME) GO TO 5     !branch to 5 if FNAME is; C                                            entirely blank  C G C====================================================================== G C==   FNAME is not blank.  Connect file given by FNAME to logical    == G C==   unit LUNN.  Failure to connect file results in RETURN 1.       == G C====================================================================== >       CALL LEFT_JUSTIFY(FNAME)   ! chop leading blanks, if any       IF(NEW_FILE) THEN H          OPEN(NAME=FNAME,UNIT=LUNN,IOSTAT=IERROR,TYPE='NEW',RECL=RECLEN,-      >        CARRIAGECONTROL='LIST',ERR=900) 
       ELSE>          OPEN(UNIT=LUNN,NAME=FNAME,TYPE='OLD',READONLY,SHARED,$      >        IOSTAT=IERROR,ERR=900)          REWIND LUNN       END IF       RETURN C G C====================================================================== G C==   FNAME is blank.  Obtain filename interactively.                == G C======================================================================   5    CONTINUE       IERROR = 0       IF(PLOT_MODE) THEN  10      CALL ALP3(0,5,70)          WRITE(IOUTS,20) PROMPT   20      FORMAT('+',A,1X,$) $          READ(IINS,30,END=750) FNAME  30      FORMAT(A)
       ELSE          WRITE(IOUTS,40) PROMPT   40      FORMAT($,1X,A) $          READ(IINS,30,END=750) FNAME       END IF C G C====================================================================== G C==   Left justify FNAME (chop leading blanks).                      == G C======================================================================        CALL LEFT_JUSTIFY(FNAME) C G C====================================================================== G C==   Find position of first blank in FNAME.                         == G C======================================================================        DO 45 I = 1,SIZE)          IF(FNAME(I:I) .EQ. ' ') GO TO 50   45   CONTINUE=       GO TO 720   ! no blanks found -- error message required   50   LENGTH = I - 1A       IF(LENGTH .EQ. 0) GO TO 740   ! go to 740 if FNAME is blank  C G C====================================================================== G C==   Attempt to open file.                                          == G C======================================================================        IF(NEW_FILE) THEN H          OPEN(NAME=FNAME,UNIT=LUNN,IOSTAT=IERROR,TYPE='NEW',RECL=RECLEN,-      >        CARRIAGECONTROL='LIST',ERR=750) 
       ELSEA          OPEN(NAME=FNAME,UNIT=LUNN,READONLY,SHARED,IOSTAT=IERROR,U!      >        TYPE='OLD',ERR=750)P          REWIND LUNN       END IF C G C======================================================================TG C==   File successfully opened.                                      ===G C==   Confirm filename                                               == G C======================================================================n  55   IF(PLOT_MODE) THEN          CALL ALP3(0,5,70)(          WRITE(IOUTS,60) FNAME(1:LENGTH)9  60      FORMAT($,'+Filename=',A,', correct? (Y or N): ') #          READ(IINS,65,END=750) CHARs  65      FORMAT(A1)y
       ELSE(          WRITE(IOUTS,70) FNAME(1:LENGTH)8  70      FORMAT(' Filename=',A/' Correct? (Y or N): ',$)#          READ(IINS,65,END=750) CHAR        END IF/       IF(CHAR .EQ. 'N' .OR. CHAR .EQ. 'n') THEN           IF(NEW_FILE) THEN,             CLOSE(UNIT=LUNN,STATUS='DELETE')
          ELSE *             CLOSE(UNIT=LUNN,STATUS='SAVE')          END IFE          GO TO 54       ELSE IF(CHAR .EQ. 'Y' .OR. CHAR .EQ. 'y') THEN          RETURN 
       ELSE@          GO TO 55   ! Invalid response to Correct (Y or N) query       END IF C  C G C====================================================================== G C==   Error handling code follows.                                   ==mG C======================================================================   720  IF(PLOT_MODE) THEN          CALL ALP3(0,5,70)          WRITE(IOUTS,725) +  725     FORMAT('+Filename is too long!',$)           CALL SLEEP(2.):
       ELSE          WRITE(IOUTS,730) )  730     FORMAT(' Filename is too long!')        END IF
       GO TO 5   740  IF(PLOT_MODE) THEN          CALL ALP3(0,5,70)          WRITE(IOUTS,743) (  743     FORMAT('+Filename is blank!',$)          CALL SLEEP(2.) 
       ELSE          WRITE(IOUTS,746) &  746     FORMAT(' Filename is blank!')       END IF
       GO TO 5  C G C====================================================================== G C==   Error opening file specified interactively.                    == G C======================================================================   750  IF(PLOT_MODE) GO TO 800        IF(IERROR .EQ. 29) THEN           WRITE(IOUTS,755) #  755     FORMAT(' File not found!') "       ELSE IF(IERROR .EQ. 43) THEN          WRITE(IOUTS,756) 2  756     FORMAT(' File name specification error!')
       ELSE          WRITE(IOUTS,760) 2  760     FORMAT(' Error attempting to open file!')          RETURN 2        END IF
       GO TO 5  C   800  CALL ALP3(0,5,70)        IF(IERROR .EQ. 29) THEN           WRITE(IOUTS,810) %  810     FORMAT($,'+File not found!') "       ELSE IF(IERROR .EQ. 43) THEN          WRITE(IOUTS,820) 4  820     FORMAT($,'+File name specification error!')
       ELSE          WRITE(IOUTS,830) 4  830     FORMAT($,'+Error attempting to open file!')          CALL SLEEP(2.)           CALL ALP3(0,5,70)          RETURN 2        END IF       CALL SLEEP(2.)
       GO TO 5   900  RETURN 1	       END 