       SUBROUTINE FLUSH_PLOT H C======================================================================CH C                                                                      CH C   FLUSH_PLOT: flushes out the remainder of the plot buffer.          CH C                                                                      CH C  The plot buffer is initialized but the plot is not cleared.         CH C  The next call to PLOT_R will then continue the plot. The user       CH C  should NOT use this routine with the ZETA plotter so as to try      CH C  to "finish" the plot. To terminate ZETA plots the user must         CH C  call END_PLOT explicitly or implicitly.                             CH C                                                                      CH C   Written by Arthur Haynes, TRIUMF U.B.C., July 6, 1981.             CH C                                                                      CH C   Modified by Alan Carruthers, August 10, 1983                       CH C     -- added reference to /PLOT_MONITOR_DOPLOT/ to enforce           CH C        transmission of graphics primitives to plot buffer            CH C        when PEN_UP is called.  This is to circumvent problems        CH C        when FLUSH_PLOT is called twice in succession.                CH C                                                                      CH C  Modified by F.W. Jones, June 25/84:                                 CH C    The plot buffers were not being properly initialized after        CH C    flushing, since the call to PEN_UP does not guarantee that        CH C    anything goes into the buffer.  Now, the buffers are flushed      CH C    using entry points to CHECK_BUFFER and CHECK_BUFFER2, so          CH C    that the buffers are always initialized in the same way           CH C    whenever they are printed.                                        CH C                                                                      CH C    Modified by Bernard Henin, U.VIC, July 1984 to include the        CH C    TEKTRONIX-4107. Only a few comments added.                        CH C                                                                      CH C  Modified Dec 5/85 by F. Jones for the QMS Lasergrafix.              CH C  Modified Aug 11/86 by F. Jones for the Houston Instruments plotter. CH C  Modified Mar 20/87 by F. Jones for Seiko GR-1105 terminal support   CH C  Modified Nov 14/88 by J. Chuma for the LN03+                        CH C                                                                      CH C======================================================================C         COMMON /PLOT_CLEAR/ CLEAR        LOGICAL CLEAR/.TRUE./ *       COMMON /PLOT_MONITOR/ IMONITOR,IOUTM       DATA IMONITOR,IOUTM/1,6/-       COMMON /PLOT_MONITOR2/ IMONITOR2,IOUTM2         DATA IMONITOR2,IOUTM2/0,6/(       COMMON /PLOT_PREVIOUS/ XP,YP,IPENP-       LOGICAL MUST_DO_PLOT, MUST_DO_PLOT_SAVE .       COMMON /PLOT_MONITOR_DOPLOT/MUST_DO_PLOT       DATA XP,YP,IPENP/0.,0.,0/  C        IF(CLEAR)CALL CLEAR_PLOT C H C======================================================================C C  Monitor 1 section: H C======================================================================C C  C Tektronix compatible: <       IF(IMONITOR.EQ.1.OR.IMONITOR.EQ.2.OR.IMONITOR.EQ.6.OR.=      #   IMONITOR.EQ.7.OR.IMONITOR.EQ.8.OR.IMONITOR.EQ.9)THEN 6          CALL FLUSH_BUFFER      !Entry to CHECK_BUFFER C  C VS11:         ELSE IF(IMONITOR.EQ.3)THEN          CALL VSSYNC C  C Seiko GR-1105:!       ELSE IF(IMONITOR.EQ.12)THEN           CALL SEIKO_FLUSH    C VaxStation!       ELSE IF(IMONITOR.EQ.15)THEN          CALL VST_PLOT_FLUSH  C  C LN03+ !       ELSE IF(IMONITOR.EQ.16)THEN 6          CALL FLUSH_BUFFER      !Entry to CHECK_BUFFER       ENDIF  C H C======================================================================C C  Monitor 2 section: H C======================================================================C C  C Tektronix compatible: ?       IF(IMONITOR2.EQ.1.OR.IMONITOR2.EQ.2.OR.IMONITOR2.EQ.6.OR. @      #   IMONITOR2.EQ.7.OR.IMONITOR2.EQ.8.OR.IMONITOR2.EQ.9)THEN8          CALL FLUSH_BUFFER2      !Entry to CHECK_BUFFER2 C  C VS11: !       ELSE IF(IMONITOR2.EQ.3)THEN %          IF(IMONITOR.NE.3)CALL VSSYNC  C  C Seiko GR-1105:"       ELSE IF(IMONITOR2.EQ.12)THEN          CALL SEIKO_FLUSH2 C  C LN03+ "       ELSE IF(IMONITOR2.EQ.16)THEN8          CALL FLUSH_BUFFER2      !Entry to CHECK_BUFFER2       END IF C  C Penup move for VS11:;       IF(IMONITOR.EQ.3.OR.IMONITOR2.EQ.3)CALL PEN_UP(XP,YP)        RETURN	       END 