7         SUBROUTINE FNICE(XMIN,XMAX,XINC,NWID,NDEC,IPOW)N C 8 C                                          Henry Baragar7 C                                          TRIUMF, UBC A8 C                                          June 24, 1982 C. C      reqd. routines - NONE CTG C====================================================================== G C==    FNICE                                                         ==IG C==                                                                  ==3G C==   Purpose  - calculates exactly the number of digits (NWID)      ==!G C==     required to display "XMIN" and "XMAX" such that they can be  ==NG C==     displayed in F-format, and such that they include enough     ==MG C==     decimal places so that the effect of the first two (one if   == G C==     it has only one) significant digits of "XINC" can be         ==)G C==     observed.                                                    ==IG C==            - If NDEC < 0, the "." is suppressed (ie. NDEC=-1)    ==NG C==                 although NWID still includes a position for it.  ==1G C==            - If NWID < 0 then FNICE will try to fit XMIN and     ==XG C==                 XMAX into ABS(NWID) --without loosing the        ==,G C==                 significance from XINC-- by returning a factor   ==ZG C==                 (10**IPOW) by which XMIN and XMAX should be      == G C==                  multiplied.                                     == G C==            - Primarily used for labelling axis on plots nicely.  ==,G C==                                                                  ==ZG C==   Arguments - XMIN & XMAX   (R*4) -- (I) ends of range;          ==WG C==             - XINC          (R*4) -- (I) increment;              ==AG C==             - NWID          (I*4) -- (I) < 0 --> fit in XMIN &   ==BG C==                                          XMAX into ABS(NWID)by   ==IG C==                                          returning IPOW;         ==EG C==                                   -- (R) width of field includes ==~G C==                                          "." (& "-" if needed);  == G C==             - NDEC          (I*4) -- (I) < 0 --> if inc is an    ==wG C==                                          integer then supress "."== G C==                                          >= 0 --> include ".";   == G C==                                   -- (R) #no. of digs after "."; == G C==             - IPOW          (I*4) -- (R) 10**IPOW is a multipli- == G C==                                          cation factor used to   ==UG C==                                          XMIN & XMAX into -NWID. == G C==   Note 1 - NWID ALWAYS INCLUDES the "."                          == G C==   Note 2 - the numbers are rounded off before the calculations   == G C==     are carried out so that there are always enough digits       == G C==     included.                                                    == G C==   Example -                                                      == H C==         CALL FNICE(-12.0135,5.,.15,NWID,NDEC,IPOW)               == G C==     returns                                                      == G C==         NWID=6                                                   == G C==         NDEC=2                                                   == G C==         IPOW=0                                                   == G C==   Examples (cont) -                                              == G C====================================================================== G C==                INPUT                        |       OUTPUT       == G C==---------------------------------------------+--------------------== G C==   XMIN     XMAX     XINC     NWID     NDEC  |  NWID  NDEC  IPOW  ==0G C==  -12.0135   5.        .15      0        0   |    6     2     0   ==IG C==    9.9      9.99      .01      0        0   |    4     2     0   ==0G C==    1.0      9.9      1.0       0        0   |    3     0     0   ==0G C==    1.0      9.9      1.0       0       -1   |    3    -1     0   ==OG C==    2.5    122.5     12.5       0        0   |    4     0     0   ==EG C==  100.1    100.6       .1      -5        0   |    5     1     0   == G C==  100.1    100.6       .1      -1        0   |    5     1     0   ==UG C== 1000.    5000.     100.       -5        0   |    5     0     0   == G C== 1000.    5000.     100.       -3        0   |    3    -1     2   ===G C== 1000.    5000.     100.       -4        0   |    3    -1     2   == G C==     .1234    .1239    .00015  -3        0   |    6     5     0   == G C==     .115     .145     .015    -3        0   |    4     3     0   ==rG C==     .0045    .0090    .0015   -3        0   |    3    -1    -4   == G C======================================================================t         YMIN = ABS(XMIN)         YMAX = ABS(XMAX)         YINC = ABS(XINC)         IF(YINC.EQ.0.)YINC=1. G         NWIDOR = NWID                                   ! NWID ORiginal G         NDECOR = NDEC                                   ! NDEC ORiginal          NDEC = 0         IPOW = 0 Cs: C       Shift the decimal place left or right until we get@ C       10 <= YINC < 100, and keep track of the number of shifts7 C       so that we know how many decimal places we need  C : C       Section for shifting decimal right for everything. C          DO WHILE (YINC.LT.10.)            YMIN=YMIN*10.            YMAX=YMAX*10.            YINC=YINC*10.            NDEC=NDEC+1         END DO C 9 C       Section for shifting decimal left for everything.= C  2       DO WHILE (YINC.GE.100.)o            YMIN=YMIN/10.            YMAX=YMAX/10.            YINC=YINC/10.            NDEC=NDEC-1         END DO Cr         YINC=IFIX(YINC+.5)         IF(YINC.GE.100.)GO TO 2==         IF(MOD(YINC,10.).EQ.0..AND.MOD(IFIX(YMIN+.5),10).EQ.0 /      *     .AND.MOD(IFIX(YMAX+.5),10).EQ.0)THEN4            YMIN=YMIN/10.            YMAX=YMAX/10.            YINC=YINC/10.            NDEC=NDEC-1
         ENDIF  C 1 C Determine number of significant digits of XMIN   C  	YMIN=IFIX(YMIN+.5)  	IF (YMIN.LT.1.) THEN 
 	   NSIGMIN=1  	ELSEn 	   NSIGMIN=ALOG10(YMIN)+1 	ENDIF C C C Determine NWIDMIN (NWID for XMIN) and include a position for the   C decimal '.'. C) 	IF (NDEC.GT.NSIGMIN) THEN 	   NWIDMIN=NDEC+1 	ELSE IF (NDEC.LE.0) THENi 	   NWIDMIN=NSIGMIN-NDEC+1 	ELSE  	   NWIDMIN=NSIGMIN+1  	ENDIF7         IF(XMIN.LT.0.)NWIDMIN=NWIDMIN+1 		! Include '-'  C 1 C Determine number of significant digits of XMAX   C  	YMAX=IFIX(YMAX+.5)  	IF (YMAX.LT.1.) THENs
 	   NSIGMAX=1  	ELSE  	   NSIGMAX=ALOG10(YMAX)+1 	ENDIF CcO C Determine NWIDMAX (NWID for XMAX) and include a position for the decimal '.'.M Ci 	IF (NDEC.GT.NSIGMAX) THEN 	   NWIDMAX=NDEC+1 	ELSE IF (NDEC.LE.0) THEN  	   NWIDMAX=NSIGMAX-NDEC+1 	ELSEm 	   NWIDMAX=NSIGMAX+1f 	ENDIF7         IF(XMAX.LT.0.)NWIDMAX=NWIDMAX+1 		! Include '-'  C 5 C       NWID is the larger of the NWIDMIN and NWIDMAX  C %         NWID = MAX (NWIDMIN, NWIDMAX) 0         IF(NDECOR.LT.0.AND.NDEC.LE.0)NWID=NWID-15         IF (NWIDOR.GE.0  .OR.  NWID.LE.-NWIDOR)  THEN2 	   IF (NDEC .GT. 0) RETURN 
 	   NDEC=0 	   IF (NDECOR .LT. 0) NDEC=-1
 	   RETURN 	ENDIF C A C       If we RETURNed above, then there was nothing to check for 4 C       problems fitting NWID, but if we continue onD C       to here, we find that we must use IPOW to fit NWID.  We alsoE C       check to make sure that the new NWID is really an improvemento C       over the old NWID. C 7         IF(XMIN.LT.0.)NSIGMIN=NSIGMIN+1 		! Include '-'=7         IF(XMAX.LT.0.)NSIGMAX=NSIGMAX+1 		! Include '-'   	NWIDTEMP = MAX(NSIGMIN,NSIGMAX) 	IF (NWID .LE. NWIDTEMP) THEN- 	   IF (NDEC .GT. 0) RETURN-
 	   NDEC=0 	   IF (NDECOR .LT. 0) NDEC=-1*            RETURN       				! not improved
         ENDIF=5 	NWID = NWIDTEMP                      		! improvement 
 	IPOW = -NDEC 
 	NDEC = -1         RETURN         END0