.       SUBROUTINE FSMOOTH(X,X1,N,IE,ICORR,WORK)H C======================================================================CH C                                                                      CH C  FSMOOTH                                                             CH C  Fourier smoothing without the Fast Fourier Transform.               CH C                                                                      CH C  Authors:  Eric E. Aubanel and Keith B. Oldham                       CH C  Reference:  BYTE, Feb/85.                                           CH C  Adapted from BASIC to VAX FORTRAN by F.W. Jones, TRIUMF             CH C                                                                      CH C  Input:                                                              CH C      X      array of data to be smoothed                             CH C                                                                      CH C      N      number of data points                                    CH C               X must be dimensioned for at least N elements.         CH C               This routine declares X to start at index "0"          CH C               (REAL X(0:N-1)) but this need not be the case          CH C               in the calling program, where the indexing of          CH C               X can be from 1 to N if desired.  The "0"              CH C               indexing has been used to preserve compatibility       CH C               with the original BASIC code.                          CH C                                                                      CH C      IE     number of transform points to retain.                    CH C               This determines the degree of smoothing.               CH C               IE must be greater than 1 and less than                CH C               or equal to the integer part of (N+1)/2.               CH C                                                                      CH C      ICORR  If ICORR=1, the data will be corrected for               CH C               "end effects" by normalizing with respect to           CH C               a straight line connecting the ends of the data.       CH C                                                                      CH C      WORK   an array to be used as work space by FSMOOTH.            CH C               WORK must be dimensioned at least 2*N+6.               CH C                                                                      CH C  Output:                                                             CH C      X1     array of smoothed data                                   CH C               X1 must be dimensioned for at least N elements.        CH C                                                                      CH C======================================================================C       REAL X(0:N-1),X1(0:N-1)        REAL WORK(0:2*N+5) C : C==These are the addresses in WORK of the arrays U,V,R,AI:( C  e.g. WORK(R+J) is equivalent to R(J).       INTEGER U,V,R,AI C 	       U=0        N2=(N+1)/2 + 1       V=U+N2       R=V+N2
       AI=R+N2  C        PI=3.141593  C (       IF(IE.LE.1.OR.IE.GT.(N+1)/2)RETURN C > C============================================================C C  Straight line correction:       IF(ICORR.NE.1)GO TO 250        S1=0.        S2=0. 
       ID=N/10        IF(ID.EQ.0)ID=1        DO J=0,ID-1           S1=S1+X(J)           S2=S2+X(N-J-1)        ENDDO        X1T=S1/ID        X2T=S2/ID        AM=(X2T-X1T)/(N-ID)        B=(X1T+X2T)/2. - AM*N/2.> C============================================================C C  C==Calculate R(0):
 250   G=0.       DO J=0,N-1> C============================================================C C==Straight line correction:+          IF(ICORR.EQ.1)X(J)=X(J) - AM*J - B > C============================================================C          G=G+X(J)        ENDDO        WORK(R+0)=G/N  C  C==Calculate R(k) coefficients:  330   J2=(N-1)/2       AJ2=J2"       IP1=LOG(2.*AJ2 - 1.)/LOG(2.)       DO K=1,IE-1           J1=J2          S=PI*K*2./N          C=COS(S)R          S=SIN(S)=          DO J=1,J1             L=2*J - 1=%             WORK(U+J)=X(L)*C + X(L-1)              WORK(V+J)=X(L)*S          ENDDO          S=2.*S*C           C=2.*C*C - 1.          DO IP=1,IP1             WORK(U+J1+1)=0.t             WORK(V+J1+1)=0.              J1=(J1+1)/2C             DO J=1,J1                 L=2*J - 19                UT=WORK(U+L)*C - WORK(V+L)*S + WORK(U+L+1)K@                WORK(V+J)=WORK(U+L)*S + WORK(V+L)*C + WORK(V+L+1)                WORK(U+J)=UT              ENDDO              S=2.*S*C             C=2.*C*C - 1.           ENDDO7          WORK(R+K)=(X(0) + WORK(U+1)*C + WORK(V+1)*S)/N        ENDDO  C  C==Calculate I(k) coefficients:        DO K=1,IE-1           J1=J2          S=2.*PI*K/N          C=COS(S)           S=SIN(S)           DO J=1,J1             L=2*J - 1              WORK(U+J)=-(X(L)*S) %             WORK(V+J)=X(L)*C + X(L+1)           ENDDO          S=2.*S*C           C=2.*C*C - 1.          DO IP=1,IP1             WORK(U+J1+1)=0..             WORK(V+J1+1)=0.h             J1=(J1+1)/2s             DO J=1,J1                 L=2*J - 19                UT=WORK(U+L)*C - WORK(V+L)*S + WORK(U+L+1) @                WORK(V+J)=WORK(U+L)*S + WORK(V+L)*C + WORK(V+L+1)                WORK(U+J)=UTo             ENDDO.             S=2.*S*C             C=2.*C*C - 1.g          ENDDO2          WORK(AI+K)=-(WORK(U+1)*C + WORK(V+1)*S)/N       ENDDOa CA C==Calculate inverse transform:  C  C==Calculate X1(0):  870   F1=0.        F2=0.        DO K=1,IE-1           T=WORK(R+K)          F1=F1+T          F2=F2 + K*K*T       ENDDO -       X1(0)=WORK(R+0) + 2.*(F1-F2*(1./IE/IE))m> C============================================================C C  Straight line correction:       IF(ICORR.EQ.1)THEN          X1(0)=X1(0)+B$ C==Restore original unsmoothed data:          X(0)=X(0)+B       ENDIF > C============================================================C Cl
       E=IE       IP1=LOG(2.*E-3.)/LOG(2.)       DO J=1,N-1          T2=E*Eg          DO K=1,IE-1             F=1. - K*K/T2t!             WORK(U+K)=WORK(R+K)*Ft%             WORK(V+K)=-(WORK(AI+K)*F)           ENDDO          K1=IE-1          S=2.*PI*J/N          C=COS(S)t          S=SIN(S)p          DO IP=1,IP1             WORK(U+K1+1)=0.m             WORK(V+K1+1)=0.*             K1=(K1+1)/2              DO K=1,K1                 L=2*K - 19                UT=WORK(U+L)*C - WORK(V+L)*S + WORK(U+L+1) @                WORK(V+K)=WORK(U+L)*S + WORK(V+L)*C + WORK(V+L+1)                WORK(U+K)=UT              ENDDO              S=2.*S*C             C=2.*C*C - 1.m          ENDDO9          X1(J)=WORK(R+0) + 2.*(WORK(U+1)*C + WORK(V+1)*S) > C============================================================C C  Straight line correction:          IF(ICORR.EQ.1)THEN "             X1(J)=X1(J) + AM*J + B$ C==Restore original unsmoothed data:              X(J)=X(J) + AM*J + B          ENDIF> C============================================================C       ENDDO2       RETURN	       ENDR