&       SUBROUTINE GET_PLOTTERTYPE(NAME)H C======================================================================CH C                                                                      CH C  GET_PLOTTERTYPE                                   J. Chuma, TRIUMF  CH C                                                                      CH C  Returns a device name indicating the process plotter type.          CH C  The name is obtained by translating the logical name                CH C    TRIUMF_PLOTTER_TYPE.                                              CH C  The plotter type can be set using the PLOTTERTYPE DCL procedure.    CH C                                                                      CH C  Input: none                                                         CH C                                                                      CH C  Output:                                                             CH C                                                                      CH C    NAME   Character string which receives the device name.           CH C           If the plotter type is undefined or cannot be obtained,    CH C           NAME will be blank-filled.                                 CH C                                                                      CH C  Example:                                                            CH C                                                                      CH C      CHARACTER*6 NAME                                                CH C      CALL GET_PLOTTERTYPE(NAME)                                      CH C      WRITE(6,*)'NAME=',NAME                                          CH C      IF(NAME.EQ.'HP    ')WRITE(6,*)'HP type recognized by caller'    CH C      END                                                             CH C                                                                      CH C======================================================================C       INCLUDE '($SSDEF)'       CHARACTER*(*) NAME7       ISTAT=LIB$SYS_TRNLOG('TRIUMF_PLOTTER_TYPE',,NAME) 3       IF(.NOT.ISTAT.OR.ISTAT.EQ.SS$_NOTRAN)NAME=' 'T       RETURN	       ENDT