#       SUBROUTINE GET_TERMTYPE(NAME) H C======================================================================CH C                                                                      CH C  GET_TERMTYPE                                    F.W. Jones, TRIUMF  CH C                                                                      CH C  Returns a device name indicating the process terminal type.         CH C  The name is obtained by translating the logical name                CH C    TRIUMF_TERMINAL_TYPE.                                             CH C  The terminal type can be set using the TERMTYPE DCL procedure.      CH C                                                                      CH C  Input: none                                                         CH C                                                                      CH C  Output:                                                             CH C                                                                      CH C    NAME   Character string which receives the device name.           CH C           If the terminal type is undefined or cannot be obtained,   CH C           NAME will be blank-filled.                                 CH C                                                                      CH C  Example:                                                            CH C                                                                      CH C      CHARACTER*10 NAME                                               CH C      CALL GET_TERMTYPE(NAME)                                         CH C      WRITE(6,*)'NAME=',NAME                                          CH C      IF(NAME.EQ.'VT640')WRITE(6,*)'VT640 type recognized by caller'  CH C      END                                                             CH C                                                                      CH C======================================================================C       INCLUDE '($SSDEF)'       CHARACTER*(*) NAME8       ISTAT=LIB$SYS_TRNLOG('TRIUMF_TERMINAL_TYPE',,NAME)3       IF(.NOT.ISTAT.OR.ISTAT.EQ.SS$_NOTRAN)NAME=' '        RETURN	       END 