/       SUBROUTINE GET_ARRAY(IOFF,LTYPE,LENGTH,*) G C**********************************************************************  C > C  GET_ARRAY:  Allocates space for a new array and records the> C              allocation, if successful, in the master table. C 	 C  INPUT:  C = C  LENGTH:    The length of the requested space in "elements" ) C  LTYPE:     The number of bytes/element  C 
 C  OUTPUT: C = C  IOFF:      The offset from the base address in "elements".  C  C  ERROR RETURNS:  C 0 C  RETURN1: -  LTYPE is not one of 1,2,4 or 8 OR/ C           -  You have requested zero space OR 8 C           -  System cannot get this amount of space OR> C           -  You have exceeded the maximum number of entries? C              in the Master Table (the maximum is specified by # C              the call to ARINIT).  C 9 C  Descriptive messages are printed on Unit 6 for errors.  C G C**********************************************************************        COMMON /X$/ R$8        COMMON /IADDR$/ IADDR A       COMMON /TABLE$/ MAXTABLE,NTABLE,IEXIST,IVEC,IADDRESS,IBYTES        LOGICAL*1 L$1(1)       INTEGER I$4(1)       REAL*8 R$8(1) '       EQUIVALENCE(L$1(1),I$4(1),R$8(1)) + C****************************** Check LTYPE A       IF(LTYPE.NE.1.AND.LTYPE.NE.2.AND.LTYPE.NE.4.AND.LTYPE.NE.8) 
      *THEN           WRITE(6,10) : 10        FORMAT('0*** Error in GET_ARRAY: Invalid LTYPE')           RETURN1        END IFB C****************************** Calculate requested space in bytes       NBYTES=LTYPE*LENGTH )       CALL GET_SPACE(NBYTES,NEWADDR,&900)         IOFF=(NEWADDR-IADDR)/LTYPEG C********************************************************************** B C  Add this block of space to the master table, so that when it is4 C  later freed, FREESPACE will know what size it is.C C  NTABLE is the highest position in the Master Table that has been 
 C  filled.F C  Search through the first NTABLE elements of the Master Table to see= C  if there are any empty "holes".  If not, increment NTABLE. G C**********************************************************************        DO 100 I=1,NTABLE 	       K=I $       IF(.NOT.L$1(IEXIST+I))GOTO 300 100   CONTINUE        IF(NTABLE.GE.MAXTABLE)THEN           WRITE(6,110)G 110       FORMAT('0*** Error in GET_ARRAY: attempt to exceed the specif 
      *ied',/, :      *            '     maximum number of dynamic arrays')           RETURN1        END IF       NTABLE=NTABLE+1        K=NTABLEG C********************************************************************** , C  Record this new array in the master tableG C**********************************************************************  300   I$4(IVEC+K)=IOFF       I$4(IADDRESS+K)=NEWADDR        I$4(IBYTES+K)=NBYTES       L$1(IEXIST+K)=.TRUE.       RETURN
 900   RETURN1 	       END 