/       SUBROUTINE GETFIELDS(STRING,FIELD,NFIELD) H C======================================================================CH C                                                                      CH C  GETFIELDS                                       F.W. Jones, TRIUMF  CH C                                                                      CH C  A routine for getting blank-separated character fields from a       CH C  character string.                                                   CH C                                                                      CH C  Input:                                                              CH C                                                                      CH C    STRING   The character string from which the fields are to be     CH C             obtained.                                                CH C                                                                      CH C    NFIELD   The maximum number of fields to be extracted.            CH C                                                                      CH C  Output:                                                             CH C                                                                      CH C    FIELD    A character array which receives the extracted fields.   CH C             FIELD must be dimensioned at least NFIELD.               CH C             To avoid truncation, FIELD should generally have the     CH C             same character length as STRING.                         CH C                                                                      CH C    NFIELD   The number of fields that were actually extracted.       CH C             If STRING is blank, NFIELD will be returned as 0.        CH C                                                                      CH C  Example:                                                            CH C                                                                      CH C        CHARACTER*80 STRING, FIELD(10)                                CH C        STRING='   user   Friendly  '                                 CH C        NFIELD=10                                                     CH C        CALL GETFIELDS(STRING,FIELD,NFIELD)                           CH C                                                                      CH C    Return values are:                                                CJ C        NFIELD=2   FIELD(1)='user'   FIELD(2)='Friendly'                CH C                                                                      CH C======================================================================C C (       CHARACTER*(*) STRING,FIELD(NFIELD)       CHARACTER*1 CHAR       LOGICAL COPYING_FIELD  C        IF(NFIELD.LE.0)RETURN  C        DO I=1,NFIELD          FIELD(I)=' '       ENDDO        IIN=1        LENSTR=LEN(STRING)       IFIELD=0       IPOS=1       COPYING_FIELD=.FALSE.  C  40    CHAR=STRING(IIN:IIN) C==Blank character encountered:        IF(CHAR.EQ.' ')THEN          COPYING_FIELD=.FALSE. $         IF(IFIELD.EQ.NFIELD)GO TO 99         IIN=IIN+1 !         IF(IIN.LE.LENSTR)GO TO 40          GO TO 99       ENDIF  C # C==Non-blank character encountered:         IF(.NOT.COPYING_FIELD)THEN         IFIELD=IFIELD+1          COPYING_FIELD=.TRUE.         IPOS=1       ENDIF #       FIELD(IFIELD)(IPOS:IPOS)=CHAR        IPOS=IPOS+1        IIN=IIN+1        IF(IIN.LE.LENSTR)GO TO 40  C  99    NFIELD=IFIELD        RETURN	       END 