<       SUBROUTINE GET_METAFILE1(LUN,OPERATOR,X,Y,P1,IERROR,*) C     reqd. routines - NONE H C=======================================================================I C     GET_METAFILE1 reads one record of a graphics metafile that contains > C     Telidon Picture Discription Instructions (Telidon PDIs).@ C     The metafile should be in the format that is output by theG C     PUT_METAFILE1 routine.  Each record read by GET_METAFILE1 usually A C     contains only one Telidon PDI followed by a carriage return F C     (the carriage return signifies the end-of-record) (the CLEAR andA C     INITIALIze operations have two Telidon PDIs on one record).  C H C     An alternate error return is taken for any of the error conditions  C     listed under IERROR below. C  C     Input arguments: C     ----- ---------  C I C     LUN        INTEGER*4   -- logical unit that metafile is attached to  C  C     Output arguments:  C     ------ --------- C  C     OPERATOR   CHARACTER*(*)? C                            -- string containing the operation E C                               corresponding to the Telidon operand. J C                               String must be at least 8 characters long.< C                               The possible operations are: C J C                               'CLEAR   '   clear display surface; pen up5 C                                            to (0,0) J C                               'COLOR   '   select pen color n, 0 < n < 59 C                                            n = 1  white 7 C                                            n = 2  red 9 C                                            n = 3  green 8 C                                            n = 4  blueD C                               'INITIALI'   metafile initialization> C                               'LINE    '   pen down to (X,Y)< C                               'MOVE    '   pen up to (X,Y)M C                               'POINT   '   pen up to (X,Y) and draw a point F C                               'SI      '   ASCII shift-in character;H C                                            denotes end of Telidon PDIsG C                               'SO      '   ASCII shift-out character; F C                                            indicates that subsequentM C                                            characters are to be interpreted < C                                            as Telidon PDIs= C                               'WAIT    '   delay processing  C D C     X          REAL*4      -- X coordinate for LINE, MOVE or POINT6 C                               operations, 0 <= X < 1 C D C     Y          REAL*4      -- Y coordinate for LINE, MOVE or POINT6 C                               operations, 0 <= X < 1 C M C     P1         INTEGER*4   -- parameter associated with certain operations.  C + C     IERROR     INTEGER*4   -- error code: . C                               0  -- no errorC C                               1  -- OPERATOR string will not hold 2 C                                     8 characters1 C                               2  -- end of file I C                               3  -- could not read record from unit LUN L C                               4  -- record contains only a carriage returnL C                               5  -- unrecognized color for COLOR operation> C                               6  -- missing (X,Y) coordinate< C                               7  -- unrecognized operation C , C     Author:  Alan Carruthers, July 5, 1983 C     ------ C H C======================================================================= C        LOGICAL*1 PDI(20)        LOGICAL   PDI4(5) #       EQUIVALENCE (PDI(1), PDI4(1))        INTEGER P1%       CHARACTER OPERATOR*(*), LINE*20  C . C     Set default values for output arguments.       IERROR = 0
       P1  = 0        OPERATOR = ' '       X      = 0.        Y      = 0.  C        L_OPER = LEN(OPERATOR)       IF(L_OPER .LT. 8) THENE C        Error -- operator string is too short to hold operator type.           IERROR = 1           RETURN 1           END IF  C - C     Read Picture Discription Instruction(s)I'       READ(LUN,20,ERR=30,END=25) L,LINE=    20 FORMAT(Q,A)=       GO TO 40 C= C     Error -- end of file.=    25 CONTINUE       IERROR = 2       RETURN 1 Cm- C     Error -- error attempting to read line.i    30 CONTINUE       IERROR = 3       RETURN 1 Ca    40 CONTINUE Ch% C     Convert LINE to LOGICAL*1 arrayU       IF (L .GE. 1) THEN2          CALL STRING_TO_LOGICAL1(%REF(LINE),PDI,L)
       ELSE C        Error -- null line.          IERROR = 4t          RETURN 1s       END IF Co$ C     ------------------------------%       IF     (PDI(1) .EQ. '0E'X) THENn          OPERATOR = 'SO      ' Ca$ C     ------------------------------%       ELSE IF(PDI(1) .EQ. '0F'X) THENI          OPERATOR = 'SI      ' Ce$ C     ------------------------------@       ELSE IF((PDI4(1) .AND. '00FFFFFF'X) .EQ. '00407820'X) THEN'          OPERATOR = 'CLEAR   '   !RESET  C-$ C     ------------------------------%       ELSE IF(PDI(1) .EQ. '3E'X) THEN .          OPERATOR = 'COLOR   '   !SELECT COLOR C (          IF     (PDI(2) .EQ. '5F'X) THEN             P1 = 1   !white (          ELSE IF(PDI(2) .EQ. '6B'X) THEN             P1 = 2   !red (          ELSE IF(PDI(2) .EQ. '75'X) THEN             P1 = 3   !green (          ELSE IF(PDI(2) .EQ. '60'X) THEN             P1 = 4   !blue
          ELSE ( C           Error -- unrecognized color.             IERROR = 5             RETURN 1          END IF5 C $ C     ------------------------------@       ELSE IF((PDI4(1) .AND. '0000FEFF'X) .EQ. '00005C21'X) THEN          OPERATOR = 'INITIALI' C $ C     ------------------------------%       ELSE IF(PDI(1) .EQ. '28'X) THEN           OPERATOR = 'LINE    '6          CALL GET_TELIDON_COORDINATE(PDI,2,LENGTH,X,Y)          IF(LENGTH .LE. 0) THENN. C           Error -- missing (X,Y) coordinate.             IERROR = 6             RETURN 1          END IF  C $ C     ------------------------------%       ELSE IF(PDI(1) .EQ. '24'X) THEN           OPERATOR = 'MOVE    '6          CALL GET_TELIDON_COORDINATE(PDI,2,LENGTH,X,Y)          IF(LENGTH .LE. 0) THEN . C           Error -- missing (X,Y) coordinate.             IERROR = 6             RETURN 1          END IF  C $ C     ------------------------------%       ELSE IF(PDI(1) .EQ. '26'X) THENa          OPERATOR = 'POINT   '6          CALL GET_TELIDON_COORDINATE(PDI,2,LENGTH,X,Y)          IF(LENGTH .LE. 0) THEN . C           Error -- missing (X,Y) coordinate.             IERROR = 6             RETURN 1          END IF  C $ C     ------------------------------A       ELSE IF((PDI(1) .EQ. '3D'X) .AND. (PDI(2) .EQ. '5C'X)) THENN          OPERATOR = 'WAIT    '          P1 = PDI(3) - 64s C $ C     ------------------------------
       ELSE+ C        Error -- operation not recognized.           IERROR = 7T          RETURN 1o       END IF       RETURN C 	       END  Ce Cr C /       SUBROUTINE STRING_TO_LOGICAL1(STRING,S,N)nH C=======================================================================C C     STRING_TO_LOGICAL1 is a dummy routine that copies a character  C     string from STRING to S. Cr& C     An example to demonstrate usage: C        CHARACTER STRING*15 C        LOGICAL*1 S(15) C          . C          .3 C        CALL STRING_TO_LOGICAL1(%REF(STRING),S,15)  C H C=======================================================================       LOGICAL*1 STRING(1)n       LOGICAL*1 S(N) C        DO 50 I = 1, N          S(I) = STRING(I)-    50 CONTINUE       RETURN	       END= C= C= C=9       SUBROUTINE GET_TELIDON_COORDINATE(PDI,N,LENGTH,X,Y)  C %       LOGICAL*1 PDI(20), PDI_COORD(8)P       INTEGER W(2)%       EQUIVALENCE (W(1),PDI_COORD(1))R C)) C     Set PDI_COORD to its default value.r       DO 20 I = 2,8           PDI_COORD(I) = '40'X     20 CONTINUE C'D C     Move the multi-value coordinate operand from PDI to PDI_COORD.6 C     N is assumed to point to the first operand byte.,       IF((N .LT. 1) .OR. (N .GT. 20)) RETURN       LIM = MIN(20,N+7)        J = 0T       DO 30 I = N, LIM          J = J + 1          PDI_COORD(J) = PDI(I)    30 CONTINUE C,4       CALL TELIDON_TO_REAL4_COORDINATE(W,LENGTH,X,Y) C0
       RETURN o	       END  Ce C  C2:       SUBROUTINE TELIDON_TO_REAL4_COORDINATE(W,LENGTH,X,Y)-       INTEGER W(2), XEXPONENT, YEXPONENT, POST2       INTEGER BASE, BIT_POS, BIT_START, XPOS, YPOS"       EQUIVALENCE (X1,IX), (Y1,IY)1       LOGICAL SECOND_WORD, XEXP_FOUND, YEXP_FOUNDC       LOGICAL BTEST1 CE CI       IX = 0       IY = 0D       LENGTH = 0  !LENGTH is returned as the number of operand bytesI C                  comprising the Telidon multi-value coordinate operand.. C 8 C     Examine the multi-value operand in W byte by byte.N       IW = 1                 !IW designates which word of W is being examined.H       SECOND_WORD = .FALSE.  !SECOND_WORD is .TRUE. when the second word4 C                             of W is being examinedK       XEXP_FOUND  = .FALSE.  !haven't yet found the floating point exponent-2 C                             for the X coordinateJ       N_XEXP      = 0        !count of number of leading X coordinate bits, C                             that are clearK       XPOS        = 6        !bit position in floating point representationE- C                             of X coordinate=K       YEXP_FOUND  = .FALSE.  !haven't yet found the floating point exponent!2 C                             for the Y coordinateJ       N_YEXP      = 0        !count of number of leading Y coordinate bits, C                             that are clearK       YPOS        = 6        !bit position in floating point representationO- C                             of Y coordinate-       DO 200 I = 1, 8(          IF(I .GT. 4) THEN             IW = 2              SECOND_WORD = .TRUE.             BASE = I * 8 - 40 
          ELSEG             BASE = I * 8 - 8          END IF( C)5 C        Check to see that byte is a Telidon operand.N0 C        If it isn't, we've finished conversion.L C        (Telidon operands have bit 6 (bits numbered from 0 to 7) set to 1.)0          IF(.NOT. BTEST(W(IW),BASE+6)) GO TO 500          LENGTH = LENGTH + 1 C."          IF(.NOT. XEXP_FOUND) THEN Ci7 C           Search X coordinate bits for first bit set.              IF(I .EQ. 1) THEN #                BIT_START = BASE + 4              ELSE#                BIT_START = BASE + 5O             END IF)             DO 30 J = BIT_START,BASE+3,-1T&                IF(BTEST(W(IW),J)) THEN%                   XEXP_FOUND = .TRUE.oL                   XEXPONENT = 128 - N_XEXP  !gives excess-128 floating point5 C                                            exponentI1                   CALL MVBITS(XEXPONENT,0,8,IX,7) *                   IF(J .GT. (BASE+3)) THEN%                      N = J - BASE - 3-7                      CALL MVBITS(W(IW),BASE+3,N,IX,7-N)o!                      XPOS = 6 - NT                   END IF                GO TO 100                END IF "                N_XEXP = N_XEXP + 1    30       CONTINUE
          ELSE= C=1 C           X exponent has been previously found. & C           Process X coordinate bits.              IF(XPOS .LT. 2) THEN                N = XPOS + 1                  IF(N .LE. 0) THEN3                   CALL MVBITS(W(IW),BASE+3,3,IX,29)S                   XPOS = 28                 ELSEI4                   CALL MVBITS(W(IW),BASE+6-N,N,IX,0)7                   CALL MVBITS(W(IW),BASE+3,3-N,IX,29+N)=                   XPOS = 28 + N                 END IF              ELSE4                CALL MVBITS(W(IW),BASE+3,3,IX,XPOS-2)                XPOS = XPOS - 3             END IF          END IF( C, CE   100    CONTINUE  CO"          IF(.NOT. YEXP_FOUND) THEN CN7 C           Search Y coordinate bits for first bit set.              IF(I .EQ. 1) THENt#                BIT_START = BASE + 1              ELSE#                BIT_START = BASE + 2e             END IF(             DO 130 J = BIT_START,BASE,-1&                IF(BTEST(W(IW),J)) THEN%                   YEXP_FOUND = .TRUE.(L                   YEXPONENT = 128 - N_YEXP  !gives excess-128 floating point5 C                                            exponent)1                   CALL MVBITS(YEXPONENT,0,8,IY,7)O&                   IF(J .GT. BASE) THEN!                      N = J - BASEU5                      CALL MVBITS(W(IW),BASE,N,IY,7-N) !                      YPOS = 6 - NT                   END IF                GO TO 160                END IFC"                N_YEXP = N_YEXP + 1   130       CONTINUE
          ELSE  C 1 C           Y exponent has been previously found. & C           Process Y coordinate bits.              IF(YPOS .LT. 2) THEN                N = YPOS + 1                  IF(N .LE. 0) THEN1                   CALL MVBITS(W(IW),BASE,3,IY,29)n                   YPOS = 281                ELSEd4                   CALL MVBITS(W(IW),BASE+3-N,N,IY,0)5                   CALL MVBITS(W(IW),BASE,3-N,IY,29+N)c                   YPOS = 28 + N                 END IFm             ELSE2                CALL MVBITS(W(IW),BASE,3,IY,YPOS-2)                YPOS = YPOS - 3             END IF          END IF  C_   160    CONTINUE  Co C    200 CONTINUE   500 CONTINUE       X = X1       Y = Y1       RETURN	       END 