<       SUBROUTINE AXLINE( XS0, YS0, SLEN, THETAS, XMIN, XMAX,@      # NLINC, NSINC, TICL, TICS, TICANG, ITYPTC, TICLAB, TICANL,C      # ANGLAB, SIZLAB, NPOS, NDEC, IPOW, ITYPLB, MAX_NLABCH, AXMOD, E      # XOFF, LEADZERO, GRID, XTICARR, YTICARR, NUMTIC, MAXTIC, NXYS )  C F C   AXLINE: Plots a general linear axis with equally spaced tic marks.E C           The axis both starts and ends with a large tic mark, i.e. B C           it is subdivided into a whole number of equally spacedE C           large tic marks which are in turn subdivided into a whole & C           number of small tic marks. C D C           Note: "PLOTCV" calls the plot routine "PLOT_R(X,Y,IPEN)"A C           for plotting the (X,Y) points, which are in user plot @ C           coordinates specified by the calls to HARDCOPY_RANGE C ; C   Written by Arthur Haynes, TRIUMF U.B.C., April 22, 1981  C ; C   Input  Parameters: XS0,YS0,SLEN,THETAS,XMIN,XMAX (R*4); A C                      NLINC,NSINC (I*4); TICL,TICS,TICANG (R*4); G C                      ITYPTC (I*4); TICLAB,TICANL,ANGLAB,SIZLAB (R*4); 3 C                      NPOS,NDEC,IPOW,ITYPLB  (I*4)  C 1 C   Output Parameters: IPOW (If ITYPLB < 0) (I*4)  C  C   Parameter definitions: C 8 C   XS0   : screen x-coordinate of the start of the axis C 8 C   YS0   : screen y-coordinate of the start of the axis C * C   SLEN  : length of axis in screen units C C C   THETAS: angle of the axis in degrees relative to the horizontal  C ; C   XMIN  : label value "X" which corresponds to the origin ; C           of the axis, i.e. minimum "X" value of the axis  C ; C   XMAX  : label value "X" which corresponds to the end of 8 C           the axis, i.e. maximum "X" value of the axis C = C   NLINC : number of large increments into which the axis is ; C           to be subdivided. The number of large tic marks 9 C           plotted on the axis which delineate the large . C           increments will be exactly NLINC+1 C = C   NSINC : number of small increments into which each of the ; C           large increments will be subdivided. The number 9 C           of small tic marks plotted between each large - C           increment will be exactly NSINC-1  C ; C   TICL  : length of the large tic marks which are used to ) C           indicate the large increments  C ; C   TICS  : length of the small tic marks which are used to ) C           indicate the small increments  C < C   TICANG: angle of the tic marks w.r.t. the axis direction C 8 C   ITYPTC: tells "AXCURV" what type of tic mark to plot= C           If ITYPTC = 1 then the tic marks are plotted only E C           on one side of the axis, i.e. that side given by "TICANG" F C           If ITYPTC = 2 then the tic marks are plotted symmetrically? C           on both sides of the axis as straight line segments = C           crossing the axis at an angle of "TICANG" degrees  C E C   TICLAB: length of the virtual pointer (tic mark), which points to E C           the location where the axis label will be centered on its 5 C           perimeter at the large tic mark locations  C : C   TICANL: angle of the virtual pointer (tic mark), which7 C           points to the location where the axis label : C           will be centered on its perimeter at the large8 C           tic mark locations. This angle is in degrees* C           relative to the axis direction C 8 C           Note: The virtual pointers are vectors whose8 C                 starting points are on the axis at the9 C                 large tic mark locations and end points < C                 determine the positions of the axis labels C H C   ANGLAB: angle of the axis labels in degrees, w.r.t. the "horizontal"@ C           screen direction if |ITYPLB| = 1, or w.r.t. the axis% C           direction if |ITYPLB| = 2  C < C   SIZLAB: height of the axis label values. If SIZLAB <= 0,/ C           then no axis labels will be plotted  C 8 C   NPOS  : width in characters of the axis label format9 C           Maximum value of "NPOS" is 20. If "NPOS" <= 0 / C           then no axis labels will be plotted  C = C   NDEC  : number of decimal places in the axis label format > C           If "NDEC" < 0 then the decimal point is suppressed C = C   IPOW  : If "X" is an axis label value at a large tic mark ; C           location then the label plotted will have value C C           "C" with format F(NPOS.NDEC) where "X" = "C" * 10**IPOW < C           If "ITYPLB" => 0 then "IPOW" will be accepted as# C           input to the subroutine ; C           If "ITYPLB" < 0 then "IPOW" will be returned as 8 C           output from the subroutine so that the label: C           values "C" which are plotted will have maximum9 C           significance in the format field F(NPOS.NDEC)  C : C   ITYPLB: Denotes the type of label. See ANGLAB and IPOW C ,       REAL*4    XTICARR(1), YTICARR(1), GRID       INTEGER*4 NUMTIC C        LOGICAL*1 LABEL(20)  C        MAX_NLABCH = 0       IGRID = IFIX(GRID) C = C   Initialize constants needed throughout the subroutine and  C   check the input parameters C        COSTH = COSD(THETAS)       SINTH = SIND(THETAS)*       IF( ABS(COSTH) .LE. 1.E-7 )COSTH=0.0*       IF( ABS(SINTH) .LE. 1.E-7 )SINTH=0.0       COSTIC = COSD(TICANG)        SINTIC = SIND(TICANG)        ANGLB = ANGLAB2       IF( IABS(ITYPLB) .NE. 2 )ANGLB=ANGLAB-THETAS       NLINC2 = MAX(NLINC,1)        NSINC2 = MAX(NSINC,1) #       NPOS2  = MAX(MIN0(NPOS,20),0)  C 6 C   If "SIZLAB" <= 0 then no labels are to be plotted.= C   IPEN1=3: pen is up when moving to first point on the axis  C         IF( SIZLAB .LE. 0 )NPOS2=0       IF( ITYPLB .LT. 0 )IPOW=0        IPEN1 = 3  C < C   TICSP: is the spacing in "S" between the small tic marks C          of the axis C         TICSP = SLEN/NLINC2/NSINC2'       XINC  = (XMAX-XMIN)/NLINC2/NSINC2        IF( NPOS2 .NE. 0 )THEN         IF( ITYPLB .LT. 0 )THEN  C ; C   NPOS2 > 0 and ITYPLB < 0 : labels are to be plotted and : C   "IPOW" will be returned as output from the subroutine. C 5           CALL REALCH(XMIN,-1,IPOW1,NPOS2,NDEC,LABEL) 5           CALL REALCH(XMAX,-1,IPOW2,NPOS2,NDEC,LABEL) "           IPOW = MAX0(IPOW1,IPOW2)         END IF C A C   Initialize some more constants to be used by the subroutine.    C   See "Parameter Definitions".7 C   (XTICL,YTICL) are the coordinates of the end of the ; C   virtual pointer (tic mark) which points to the location : C   where the axis label will be centered on its perimeter C          COSLAB = COSD(ANGLB)         SINLAB = SIND(ANGLB)$         XTICL  = COSD(TICANL)*TICLAB$         YTICL  = SIND(TICANL)*TICLAB C A C   Set "YLIM" for the call to "LABXY" which determines the label E C   position relative to the axis at each long tic mark. The label is G C   not allowed to cross the line "Y = YLIM", where "YLIM" is set to be H C   the maximum perpendicular distance of the long and short tic marks  2 C   from the axis on the labelled side of the axis C          IF( ITYPTC .NE. 2 )THEN  C > C   ITYPTC = 1 : Tic marks are plotted on one side of the axis C C           IF( YTICL .LE. 0. )YLIM=AMIN1(SINTIC*TICL,SINTIC*TICS,0.) C           IF( YTICL .GT. 0. )YLIM=AMAX1(SINTIC*TICL,SINTIC*TICS,0.)          ELSE C @ C   ITYPTC = 2 : Tic marks are plotted on both sides of the axis C F           YLIM=SIGN(1.,YTICL)*AMAX1(ABS(SINTIC*TICL),ABS(SINTIC*TICS))            IF(YTICL.EQ.0.)YLIM=0.         END IF       END IF       NTICS  = NLINC2*NSINC2+1       NUMTIC = 0       LTIC   = 0       DO 100 I = 1, NTICS          STIC = (I-1)*TICSP         XS = XS0+COSTH*STIC          YS = YS0+SINTH*STIC           CALL PLOT_R(XS,YS,IPEN1)         IPEN1 = 2  C ? C   Determine whether the tic length "TICLEN" is long (TICL) or  C   short (TICS) C           MODINC = MOD(I-1,NSINC2)         IF( MODINC .EQ. 0 )THEN            LTIC = LTIC + 1            TICLEN = TICL =           IF( (IGRID .NE. 0) .AND. (NUMTIC .LT. MAXTIC) )THEN $             IF( (IGRID .LT. 0) .OR. <      #          ((LTIC+1)/IGRID*IGRID-(LTIC+1) .EQ. 0) )THEN$               XTICARR(NUMTIC+1) = XS$               YTICARR(NUMTIC+1) = YS!               NUMTIC = NUMTIC + 1              END IF           END IF         ELSE           TICLEN = TICS =           IF( (IGRID .LT. 0) .AND. (NUMTIC .LT. MAXTIC) )THEN "             XTICARR(NUMTIC+1) = XS"             YTICARR(NUMTIC+1) = YS             NUMTIC = NUMTIC + 1            END IF         END IF C ; C   (XT,YT) are the unrotated coordinates of the end of the , C   tic mark relative to the location "STIC" C          XT=COSTIC*TICLEN         YT=SINTIC*TICLEN C C C   (XTS,YTS) are rotated screen coordinates of end of the tic mark  C           XTS=XS+COSTH*XT-SINTH*YT          YTS=YS+SINTH*XT+COSTH*YT C B C   Plot the tic mark by moving the pen from the tic mark locationB C   (XS,YS) to the end of the tic mark (XTS,YTS) with the pen down C          CALL PLOT_R(XTS,YTS,2)         IF( ITYPTC .EQ. 2 )THEN  C E C   ITYPTC = 2 : Plot the tic mark symmetrically on both sides of the E C                axis as a straight line segment crossing the axis at - C                an angle of "TICANG" degrees  C #           XTSN=XS-COSTH*XT+SINTH*YT #           YTSN=YS-SINTH*XT-COSTH*YT "           CALL PLOT_R(XTSN,YTSN,2)         END IF         CALL PLOT_R(XS,YS,2) C , C   Check to see if a label is to be plotted C :         IF( (MODINC .NE. 0) .OR. (NPOS2 .EQ. 0) )GO TO 100E         IF( (NXYS.LT.0) .AND. ((I.EQ.1) .OR. (I.EQ.NTICS)) )GO TO 100  C C C   MODINC = 0 and NPOS2 > 0. Therefore an x-label is to be plotted 6 C   Store the characters for the real label in "LABEL"< C   NLABCH: is the number of non-blank characters in "LABEL" C           XDUM = XMIN + (I-1)*XINC         IF( AXMOD .LT. 0. )THENX%           XDUM = MOD(XDUM,ABS(AXMOD))T$         ELSE IF( AXMOD .GT. 0. )THEN            XDUM = MOD(XDUM,AXMOD)/           IF( XDUM .LT. 0. )XDUM = XDUM + AXMODR         END IF         XDUM = XDUM + XOFF1         CALL REALCH(XDUM,1,IPOW,NPOS2,NDEC,LABEL) +         CALL IGC(LABEL,NPOS2,' ',1,1,IFIND)h"         NLABCH = NPOS2 - IFIND + 1 Ce#         IF( IFIND .EQ. 0 )GO TO 100u Cv+         MAX_NLABCH = MAX(MAX_NLABCH,NLABCH)  C 3 C   Left-justify the "NLABCH" characters of "LABEL"t: C   FLENG : is the length in screen units of the label, as C           plotted by "PSYM"e Co0         CALL MOVEC(NLABCH,LABEL(IFIND),LABEL(1))!         IF( LEADZERO .GT. 0 )THEN +           IF( CHAR(LABEL(1)) .EQ. '.' )THEN *             DO IJK = MIN(20,NLABCH), 1, -1'               LABEL(IJK+1) = LABEL(IJK)l             END DO#             LABEL(1)   = ICHAR('0')S#             NLABCH     = NLABCH + 1 /             MAX_NLABCH = MAX(MAX_NLABCH,NLABCH)            END IF         END IF)         IF( CHAR(LABEL(1)) .EQ. '-' )THEN +           IF( CHAR(LABEL(2)) .EQ. '.' )THEN4*             DO IJK = MIN(19,NLABCH), 2, -1'               LABEL(IJK+1) = LABEL(IJK)i             END DO#             LABEL(2)   = ICHAR('0') #             NLABCH     = NLABCH + 1o/             MAX_NLABCH = MAX(MAX_NLABCH,NLABCH)            END IF         END IF+         FLENG = PSMLEN(LABEL,NLABCH,SIZLAB)l CvH C   Determine the lower left hand corner: (XLAB,YLAB) at which the labelF C   is to be plotted, relative to the axis direction, and the location, C   "STIC" of the large tic mark on the axis C :         CALL LABXY(XTICL,YTICL,ANGLB,COSLAB,SINLAB,SIZLAB,&      #           FLENG,YLIM,XLAB,YLAB) C F C   (XLS,YLS) are the rotated screen coordinates at which the label is C   to be plotted by "PSYM"  C $         XLS=XS+COSTH*XLAB-SINTH*YLAB$         YLS=YS+SINTH*XLAB+COSTH*YLAB         IF(XLS.EQ.-0.)XLS=0.         IF(YLS.EQ.-0.)YLS=0. C G C   Plot the label at angle relative to the horizontal of ANGLE degrees  C          ANGLE=ANGLB+THETAS8         CALL PSYMBOLD(XLS,YLS,SIZLAB,LABEL,ANGLE,NLABCH) C 9 C   Move with the pen up to the beginning of the tic mark  C          CALL PLOT_R(XS,YS,3) 100   CONTINUE       RETURN	       END 