D       SUBROUTINE AXLOG( BASE, XS0, YS0, SLEN, THETAS, POWMIN, POWMAX<      #             ,NLINC, TICL, NSINC, TICS, TICANG, ITYPTC:      #             ,TICLAB, TICANL, ANGLAB, SIZLAB, ITYPLBH      #             ,MAX_NLABCH, GRID, XTICARR, YTICARR, NUMTIC, MAXTIC ) C ? C   AXLOG plots a general logarithmic axis with base "BASE" and ; C         minimum power "POWMIN" and maximum power "POWMAX"  C 9 C  BASE  : the logarithmic base used in plotting the axis  C 7 C  XS0   : screen x-coordinate of the start of the axis  C 7 C  YS0   : screen y-coordinate of the start of the axis  C ) C  SLEN  : length of axis in screen units  C B C  THETAS: angle of the axis in degrees relative to the horizontal C 7 C  POWMIN: minimum power of the base "BASE" of the axis  C 7 C  POWMAX: maximum power of the base "BASE" of the axis  C B C  NLINC : number of large increments into which the axis is to beD C          subdivided.  The number of large tic marks plotted on theD C          axis which delineate the large increments will be NLINC+1 C C C  TICL  : length of the large tic marks which are used to indicate  C          the large increments  C C C  TICS  : length of the small tic marks which are used to indicate  C          the small increments  C ; C  TICANG: angle of the tic marks w.r.t. the axis direction  C 6 C  ITYPTC: tells "AXLOG" what type of tic mark to plotH C          If ITYPTC = 1 then the tic marks are plotted only on one side8 C          of the axis, i.e. that side given by "TICANG"E C          If ITYPTC = 2 then the tic marks are plotted symmetrically B C          on both sides of the axis as line segments crossing the/ C          axis at an angle of "TICANG" degrees  C D C  TICLAB: length of the virtual pointer (tic mark), which points toD C          the location where the axis label will be centered on its4 C          perimeter at the large tic mark locations C G C  TICANL: angle of the virtual pointer (tic mark), which points to the @ C          location where the axis label will be centered on itsF C          perimeter at the large tic mark locations. This angle is in1 C          degrees relative to the axis direction  C G C          Note: The virtual pointers are vectors whose starting points D C                are on the axis at the large tic mark locations andF C                end points determine the positions of the axis labels C G C  ANGLAB: angle of the axis labels in degrees, w.r.t. the "horizontal" ? C          screen direction if |ITYPLB| = 1, or w.r.t. the axis $ C          direction if |ITYPLB| = 2 C C C  SIZLAB: height of the axis label values. If SIZLAB <= 0, then no & C          axis labels will be plotted C 0 C  ITYPLB: Denotes the type of label. See ANGLAB C $       REAL*4    BASE, POWMIN, POWMAX       INTEGER*4 ITICS(2:9)       LOGICAL   DECIMAL $       DATA      EXP1 / 2.718281828 / C ,       REAL*4    XTICARR(1), YTICARR(1), GRID       INTEGER*4 NUMTIC C        CHARACTER STRING*25 #       LOGICAL*1 LABEL(25), UP /Z09/ (       EQUIVALENCE (LABEL(1),STRING(1:1)) C        MAX_NLABCH = 0 C        IGRID  = IFIX(GRID)        NUMTIC = 0 C D C  If DECIMAL = .TRUE. then write the axis labels as decimal numbersC C  instead of as powers, e.g., 0.1  1  10   100   1000  instead of   C 2 C                                -1    0    2    31 C                              10    10   10   10  C        IF( BASE .LT. 0. )THEN         DECIMAL = .TRUE.         BASE    = ABS(BASE) -         IF( BASE .EQ. EXP1 )DECIMAL = .FALSE. 
       ELSE         DECIMAL = .FALSE.        END IF C = C   Convert the base "BASE" into a logical array "LABEL" with G C   "NSIG1" characters.  Then put the "UP" character (hexadecimal "09") E C   at the end of the string. This signifies to PSYM that an exponent E C   is to follow and therefore to be shifted up as well as reduced in 	 C   size.  C        IBASE = IFIX(BASE))       IF( BASE .EQ. EXP1 )THEN   ! Base e          LABEL(1) = 'e'         NSIG1    = 1
       ELSE,         CALL BTD(IBASE,LABEL(1),0,NSIG1,'0')       END IF%       CALL MOVEC(1,UP,LABEL(NSIG1+1))  C : C   Initialize constants needed throughout the subroutine. C        COSTH  = COSD(THETAS)        SINTH  = SIND(THETAS)        COSTIC = COSD(TICANG)        SINTIC = SIND(TICANG)        ANGLB  = ANGLAB 4       IF( IABS(ITYPLB) .NE. 2 )ANGLB = ANGLAB-THETAS       COSLAB = COSD(ANGLB)       SINLAB = SIND(ANGLB) C G C   (XTICL,YTICL) are the coordinates of the end of the virtual pointer E C   (tic mark) which points to the location where the axis label will ! C   be centered on its perimeter.  C !       XTICL = COSD(TICANL)*TICLAB !       YTICL = SIND(TICANL)*TICLAB  C A C   Set "YLIM" for the call to "LABXY" which determines the label E C   position relative to the axis at each long tic mark. The label is G C   not allowed to cross the line "Y = YLIM", where "YLIM" is set to be F C   the maximum perpendicular distance of the long and short tic marks3 C   from the axis on the labelled side of the axis.  C        IF( ITYPTC .EQ. 2 )THEN  C 4 C   Tic marks are plotted on both sides of the axis. C D         YLIM = SIGN(1.,YTICL)*MAX(ABS(SINTIC*TICL),ABS(SINTIC*TICS))$         IF( YTICL .EQ. 0. )YLIM = 0.
       ELSE C 2 C   Tic marks are plotted on one side of the axis. C A         IF( YTICL .LE. 0. )YLIM = MIN(SINTIC*TICL,SINTIC*TICS,0.) A         IF( YTICL .GT. 0. )YLIM = MAX(SINTIC*TICL,SINTIC*TICS,0.)        END IF C , C   N1 = minimum power displayed on the axis, C   N2 = maximum power displayed on the axis C        IF( POWMIN .GE. 0.0 )THEN           N1 = INT(POWMIN+0.99999)
       ELSE         N1 = INT(POWMIN)       END IF       IF( POWMAX .GE. 0.0 )THEN          N2 = INT(POWMAX)
       ELSE          N2 = INT(POWMAX-0.99999)       END IF       IF( NLINC .EQ. 0 )THEN!         NLINC2 = ABS(N2 - N1 + 1) 
       ELSE2         NLINC2 = MIN( ABS(NLINC)+1, ABS(N2-N1+1) )       END IF       NLINC2 = MAX( NLINC2, 2 ) ,       INCR = MAX( ABS(N2-N1+1)/(NLINC2), 1 ) C B       IF( (NSINC .LT. 0) .AND. (IBASE .GT. 10) )NSINC = ABS(NSINC)       IF( NSINC .LT. 0 )THEN         DO I = 2, 9            ITICS(I) = 0         END DO         NSABS = ABS(NSINC)         DO WHILE (NSABS .NE. 0)            INS = NSABS/10           IDX = NSABS - INS*10(           IF( IDX .NE. 0 )ITICS(IDX) = 1           NSABS = INS          END DO         INCRS = 1 
       ELSE*         NSINC = MIN( IBASE-1, ABS(NSINC) )#         IF( INCR .NE. 1 )NSINC = -1          IF( NSINC .GT. 0 )THEN!           INCRS = (IBASE-1)/NSINC          ELSE           INCRS = IBASE          END IF       END IF C        BLOG10 = LOG10(BASE)"       BPOW   = BASE**(POWMIN-N1+1)       M      = INCRS + 1       DO WHILE ( M .LE. IBASE ) (         IF( BPOW .LE. FLOAT(M) )GO TO 30         M = M + INCRS        END DO C , C   put the pen up at the origin of the axis C  30    CALL PLOT_R(XS0,YS0,3)"       PFACT = SLEN/(POWMAX-POWMIN)       IF( NSINC .LT. 0 )THEN         DO I = M, IBASE-1 #           IF( ITICS(I) .EQ. 1 )THEN 7 C                                                  N1-1 3 C   plot the axis line and the small tics at I*BASE  C ?             STIC = (N1-1+LOG10(FLOAT(I))/BLOG10 - POWMIN)*PFACT              XS = XS0+COSTH*STIC              YS = YS0+SINTH*STIC               CALL PLOT_R(XS,YS,2) C - C   Store the tic mark locations for the grid  C ?             IF( (IGRID .LT. 0) .AND. (NUMTIC .LT. MAXTIC) )THEN $               XTICARR(NUMTIC+1) = XS$               YTICARR(NUMTIC+1) = YS!               NUMTIC = NUMTIC + 1              END IF C D C   (XT,YT) are the unrotated coordinates of the end of the tic mark$ C   relative to the location "STIC". C              XT = COSTIC*TICS             YT = SINTIC*TICS C F C   (XTS,YTS) are the rotated screen coordinates of the end of the tic	 C   mark.  C &             XTS = XS+COSTH*XT-SINTH*YT&             YTS = YS+SINTH*XT+COSTH*YT C B C   Plot the tic mark by moving the pen from the tic mark locationC C   (XS,YS) to the end of the tic mark (XTS,YTS) with the pen down.  C "             CALL PLOT_R(XTS,YTS,2)#             IF( ITYPTC .EQ. 2 )THEN  C E C   ITYPTC = 2 : Plot the tic mark symmetrically on both sides of the E C                axis as a straight line segment crossing the axis at . C                an angle of "TICANG" degrees. C )               XTSN = XS-COSTH*XT+SINTH*YT )               YTSN = YS-SINTH*XT-COSTH*YT &               CALL PLOT_R(XTSN,YTSN,2)             END IF              CALL PLOT_R(XS,YS,3)           END IF         END DO
       ELSE          DO I = M, IBASE-1, INCRS7 C                                                  N1-1 3 C   plot the axis line and the small tics at I*BASE  C =           STIC = (N1-1+LOG10(FLOAT(I))/BLOG10 - POWMIN)*PFACT            XS = XS0+COSTH*STIC            YS = YS0+SINTH*STIC            CALL PLOT_R(XS,YS,2) C - C   Store the tic mark locations for the grid  C =           IF( (IGRID .LT. 0) .AND. (NUMTIC .LT. MAXTIC) )THEN "             XTICARR(NUMTIC+1) = XS"             YTICARR(NUMTIC+1) = YS             NUMTIC = NUMTIC + 1            END IF C D C   (XT,YT) are the unrotated coordinates of the end of the tic mark$ C   relative to the location "STIC". C            XT = COSTIC*TICS           YT = SINTIC*TICS C F C   (XTS,YTS) are the rotated screen coordinates of the end of the tic	 C   mark.  C $           XTS = XS+COSTH*XT-SINTH*YT$           YTS = YS+SINTH*XT+COSTH*YT C B C   Plot the tic mark by moving the pen from the tic mark locationC C   (XS,YS) to the end of the tic mark (XTS,YTS) with the pen down.  C             CALL PLOT_R(XTS,YTS,2)!           IF( ITYPTC .EQ. 2 )THEN  C E C   ITYPTC = 2 : Plot the tic mark symmetrically on both sides of theOE C                axis as a straight line segment crossing the axis at . C                an angle of "TICANG" degrees. CP'             XTSN = XS-COSTH*XT+SINTH*YT '             YTSN = YS-SINTH*XT-COSTH*YT $             CALL PLOT_R(XTSN,YTSN,2)           END IF           CALL PLOT_R(XS,YS,3)         END DO       END IF       IPOW = N1 - 1:       J    = 0       DO K = N1, N2g         J    = J + 1         IPOW = IPOW + 1oB         IF( (K .EQ. N1) .OR. (K .EQ. N2) .OR. (J .EQ. INCR) )J = 0 Cr  C                           IPOW C   plot a large tic at BASE C $         STIC = (IPOW - POWMIN)*PFACT         XS = XS0+COSTH*STIC          YS = YS0+SINTH*STICo         CALL PLOT_R(XS,YS,2) C - C   Store the tic mark locations for the gridf CeF         IF( (J.EQ.0) .AND. (IGRID.NE.0) .AND. (NUMTIC.LT.MAXTIC) )THEN"           IF( (IGRID .LT. 0) .OR. :      #        ((K-N1+2)/IGRID*IGRID-(K-N1+2) .EQ. 0) )THEN"             XTICARR(NUMTIC+1) = XS"             YTICARR(NUMTIC+1) = YS             NUMTIC = NUMTIC + 1e           END IF         END IF CrD C   (XT,YT) are the unrotated coordinates of the end of the tic mark$ C   relative to the location "STIC". Ci         XT = COSTIC*TICL         YT = SINTIC*TICL C.F C   (XTS,YTS) are the rotated screen coordinates of the end of the tic	 C   mark.  C "         XTS = XS+COSTH*XT-SINTH*YT"         YTS = YS+SINTH*XT+COSTH*YT C B C   Plot the tic mark by moving the pen from the tic mark locationC C   (XS,YS) to the end of the tic mark (XTS,YTS) with the pen down.  C          CALL PLOT_R(XTS,YTS,2)         IF( ITYPTC .EQ. 2 )THEN  C E C   ITYPTC = 2 : Plot the tic mark symmetrically on both sides of the E C                axis as a straight line segment crossing the axis at . C                an angle of "TICANG" degrees. C %           XTSN = XS-COSTH*XT+SINTH*YT %           YTSN = YS-SINTH*XT-COSTH*YT "           CALL PLOT_R(XTSN,YTSN,2)         END IF         IF( J .NE. 0 )GO TO 34 C C C   A label is to be plotted.  IPOW is the power of the label being F C   plotted.  Append the characters of the power to the base + UP (09)( C   character already stored in "LABEL". C          IF( .NOT.DECIMAL )THEN3 32        CALL BTD(IPOW,LABEL(NSIG1+2),0,NSIG2,'0')            IF( IPOW .EQ. 0 )THEN              NSIG2 = 1 ,             CALL MOVEC(1,'0',LABEL(NSIG1+2))           END IF C 2 C   NLABCH is the number of characters in "LABEL".E C   FLENG = length in screen units of the label, as plotted by "PSYM"  C             NLABCH = NSIG1+1+NSIG2           IDC1 = 1         ELSE           XOUT = BASE**IPOW D           IF( (XOUT .GT. 9999999.0) .OR. (XOUT .LT. 0.0000001) )THEN0             CALL BTD(IBASE,LABEL(1),0,NSIG1,'0')+             CALL MOVEC(1,UP,LABEL(NSIG1+1))              GO TO 32           END IF           STRING = ' '           WRITE(STRING,321)XOUT  321       FORMAT(F25.7)            IDC1 = 0 322       IDC1 = IDC1 + 1 3           IF( STRING(IDC1:IDC1) .NE. ' ' )GO TO 323            GO TO 322  323       IDC2 = 26  324       IDC2 = IDC2 - 1 1           IF( (STRING(IDC2:IDC2) .NE. '0') .AND.  5      #        (STRING(IDC2:IDC2) .NE. ' ') )GO TO 325            GO TO 324 . 325       IF( STRING(IDC1:IDC1) .EQ. '.' )THEN             IDC1 = IDC1 - 1 #             STRING(IDC1:IDC1) = '0'            END IF9           IF( STRING(IDC2:IDC2) .EQ. '.' )IDC2 = IDC2 - 1 "           NLABCH = IDC2 - IDC1 + 1         END IF+         MAX_NLABCH = MAX(MAX_NLABCH,NLABCH) 1         FLENG = PSMLEN(LABEL(IDC1),NLABCH,SIZLAB)  C B C   Determine the lower left hand corner: (XLAB,YLAB) at which theC C   label is to be plotted, relative to the axis direction, and the 6 C   location "STIC" of the large tic mark on the axis. C ?         CALL LABXY(XTICL,YTICL,ANGLB,COSLAB,SINLAB,SIZLAB,FLENG "      #            ,YLIM,XLAB,YLAB) C F C   (XLS,YLS) are the rotated screen coordinates at which the label is C   to be plotted by "PSYM". C &         XLS = XS+COSTH*XLAB-SINTH*YLAB&         YLS = YS+SINTH*XLAB+COSTH*YLAB"         IF( XLS .EQ. -0. )XLS = 0."         IF( YLS .EQ. -0. )YLS = 0. C D C   Plot the label at an angle relative to the horizontal of "ANGLE" C   degrees. C          ANGLE = ANGLB+THETAS>         CALL PSYMBOLD(XLS,YLS,SIZLAB,LABEL(IDC1),ANGLE,NLABCH) C : C   Move with the pen up to the beginning of the tic mark. C  34      CALL PLOT_R(XS,YS,3)         IF( IPOW .NE. N2 )THEN            IF( NSINC .LT. 0 )THEN#             DO I = INCRS+1, IBASE-1 '               IF( ITICS(I) .EQ. 1 )THEN 7 C                                                  IPOW 3 C   plot the axis line and the small tics at I*BASE  C C                 STIC = (IPOW+LOG10(FLOAT(I))/BLOG10 - POWMIN)*PFACT #                 XS = XS0+COSTH*STIC #                 YS = YS0+SINTH*STIC $                 CALL PLOT_R(XS,YS,2) C - C   Store the tic mark locations for the grid  C C                 IF( (IGRID .LT. 0) .AND. (NUMTIC .LT. MAXTIC) )THEN (                   XTICARR(NUMTIC+1) = XS(                   YTICARR(NUMTIC+1) = YS%                   NUMTIC = NUMTIC + 1                  END IF C D C   (XT,YT) are the unrotated coordinates of the end of the tic mark$ C   relative to the location "STIC". C                   XT = COSTIC*TICS                  YT = SINTIC*TICS C F C   (XTS,YTS) are the rotated screen coordinates of the end of the tic	 C   mark.  C *                 XTS = XS+COSTH*XT-SINTH*YT*                 YTS = YS+SINTH*XT+COSTH*YT C B C   Plot the tic mark by moving the pen from the tic mark locationC C   (XS,YS) to the end of the tic mark (XTS,YTS) with the pen down.  C &                 CALL PLOT_R(XTS,YTS,2)'                 IF( ITYPTC .EQ. 2 )THEN  C E C   ITYPTC = 2 : Plot the tic mark symmetrically on both sides of the E C                axis as a straight line segment crossing the axis at . C                an angle of "TICANG" degrees. C -                   XTSN = XS-COSTH*XT+SINTH*YT -                   YTSN = YS-SINTH*XT-COSTH*YT *                   CALL PLOT_R(XTSN,YTSN,2)                 END IF$                 CALL PLOT_R(XS,YS,3)               END IF             END DO           ELSE*             DO I = INCRS+1, IBASE-1, INCRS7 C                                                  IPOW 3 C   plot the axis line and the small tics at I*BASE  C A               STIC = (IPOW+LOG10(FLOAT(I))/BLOG10 - POWMIN)*PFACT !               XS = XS0+COSTH*STIC !               YS = YS0+SINTH*STIC "               CALL PLOT_R(XS,YS,2) C - C   Store the tic mark locations for the grid  C A               IF( (IGRID .LT. 0) .AND. (NUMTIC .LT. MAXTIC) )THEN &                 XTICARR(NUMTIC+1) = XS&                 YTICARR(NUMTIC+1) = YS#                 NUMTIC = NUMTIC + 1                END IF C D C   (XT,YT) are the unrotated coordinates of the end of the tic mark$ C   relative to the location "STIC". C                XT = COSTIC*TICS               YT = SINTIC*TICS C F C   (XTS,YTS) are the rotated screen coordinates of the end of the tic	 C   mark.  C (               XTS = XS+COSTH*XT-SINTH*YT(               YTS = YS+SINTH*XT+COSTH*YT C B C   Plot the tic mark by moving the pen from the tic mark locationC C   (XS,YS) to the end of the tic mark (XTS,YTS) with the pen down.  C $               CALL PLOT_R(XTS,YTS,2)%               IF( ITYPTC .EQ. 2 )THEN  C E C   ITYPTC = 2 : Plot the tic mark symmetrically on both sides of the E C                axis as a straight line segment crossing the axis at . C                an angle of "TICANG" degrees. C +                 XTSN = XS-COSTH*XT+SINTH*YT +                 YTSN = YS-SINTH*XT-COSTH*YT (                 CALL PLOT_R(XTSN,YTSN,2)               END IF"               CALL PLOT_R(XS,YS,3)             END DO           END IF         END IF       END DO C 7 C   Find the excess small tics past the last large tic   C        M = INCRS+1        DO I = INCRS+1, IBASE-1 5         IF( BASE**(POWMAX-N2) .LE. FLOAT(M) )GO TO 40          M = M + 1        END DO 40    M = M - 1        IF( NSINC .LT. 0 )THEN         DO I = INCRS+1, M 5 C                                                  N2i3 C   plot the axis line and the small tics at I*BASEh Cd#           IF( ITICS(I) .EQ. 1 )THENi=             STIC = (N2+LOG10(FLOAT(I))/BLOG10 - POWMIN)*PFACT              XS = XS0+COSTH*STICi             YS = YS0+SINTH*STIC               CALL PLOT_R(XS,YS,2) Cs- C   Store the tic mark locations for the gridm Cr?             IF( (IGRID .LT. 0) .AND. (NUMTIC .LT. MAXTIC) )THENt$               XTICARR(NUMTIC+1) = XS$               YTICARR(NUMTIC+1) = YS!               NUMTIC = NUMTIC + 1T             END IF C D C   (XT,YT) are the unrotated coordinates of the end of the tic mark$ C   relative to the location "STIC". C              XT = COSTIC*TICS             YT = SINTIC*TICS C F C   (XTS,YTS) are the rotated screen coordinates of the end of the tic	 C   mark.  CA&             XTS = XS+COSTH*XT-SINTH*YT&             YTS = YS+SINTH*XT+COSTH*YT CNB C   Plot the tic mark by moving the pen from the tic mark locationC C   (XS,YS) to the end of the tic mark (XTS,YTS) with the pen down.F CK"             CALL PLOT_R(XTS,YTS,2)#             IF( ITYPTC .EQ. 2 )THEN  C E C   ITYPTC = 2 : Plot the tic mark symmetrically on both sides of thePE C                axis as a straight line segment crossing the axis ato. C                an angle of "TICANG" degrees. Ci)               XTSN = XS-COSTH*XT+SINTH*YT )               YTSN = YS-SINTH*XT-COSTH*YTI&               CALL PLOT_R(XTSN,YTSN,2)             END IF              CALL PLOT_R(XS,YS,3)           END IF         END DO
       ELSE          DO I = INCRS+1, M, INCRS5 C                                                  N2 3 C   plot the axis line and the small tics at I*BASEo Ce;           STIC = (N2+LOG10(FLOAT(I))/BLOG10 - POWMIN)*PFACT            XS = XS0+COSTH*STICT           YS = YS0+SINTH*STICN           CALL PLOT_R(XS,YS,2) C - C   Store the tic mark locations for the gridc C =           IF( (IGRID .LT. 0) .AND. (NUMTIC .LT. MAXTIC) )THEN "             XTICARR(NUMTIC+1) = XS"             YTICARR(NUMTIC+1) = YS             NUMTIC = NUMTIC + 1            END IF C D C   (XT,YT) are the unrotated coordinates of the end of the tic mark$ C   relative to the location "STIC". C            XT = COSTIC*TICS           YT = SINTIC*TICS CsF C   (XTS,YTS) are the rotated screen coordinates of the end of the tic	 C   mark.  C $           XTS = XS+COSTH*XT-SINTH*YT$           YTS = YS+SINTH*XT+COSTH*YT CHB C   Plot the tic mark by moving the pen from the tic mark locationC C   (XS,YS) to the end of the tic mark (XTS,YTS) with the pen down.  Ca            CALL PLOT_R(XTS,YTS,2)!           IF( ITYPTC .EQ. 2 )THENt C.E C   ITYPTC = 2 : Plot the tic mark symmetrically on both sides of theeE C                axis as a straight line segment crossing the axis at . C                an angle of "TICANG" degrees. C '             XTSN = XS-COSTH*XT+SINTH*YT '             YTSN = YS-SINTH*XT-COSTH*YTL$             CALL PLOT_R(XTSN,YTSN,2)           END IF           CALL PLOT_R(XS,YS,3)         END DO       END IF' C                                POWMAX ! C   Plot the axis line up to BASEI C        XS = XS0+COSTH*SLEN        YS = YS0+SINTH*SLEN*       CALL PLOT_R(XS,YS,2)       RETURN	       ENDT