B       SUBROUTINE BOX_DENS( ARRAY, NDIM, NROW1, NROW2, NCOL1, NCOL2.      #                    ,X, NX, Y, NY, Z, NZ?      #                    ,FMINIIN, FMAXIIN, FMINI2IN, FMAXI2IN @      #                    ,BSCALEIN, DERIVIN, PARTIALIN, POLARIN&      #                    ,PROFILEIN ) C F C   This routine produces a box density plot of a density distribution C   including the axes C 
 C   INPUT: C  C   ARRAY   --> REAL*4B C               the data to represent by boxes, not used if NZ > 0 C   NDIM    --> INTEGER*4 3 C               the actual first dimension of ARRAY 3 C               as specified in the calling program  C   NROW1   --> INTEGER*4  C   NROW2   --> INTEGER*4 + C               use ARRAY rows ROW1 to ROW2  C   NCOL1   --> INTEGER*4  C   NCOL2   --> INTEGER*4 0 C               use ARRAY columns NCOL1 to NCOL2 C   X       --> REAL*4A C               the x data, if NX = 0, X(I) = I will be generated  C   NX      --> INTEGER*4  C               the length of X  C   Y       --> REAL*4A C               the y data, if NY = 0, Y(I) = I will be generated  C   NY      --> INTEGER*4  C               the length of Y  C   Z       --> REAL*49 C               the z data, if NZ = 0, ARRAY will be used 9 C                           if NZ > 0,     Z will be used  C   NZ      --> INTEGER*4  C               the length of Z  C   FMINI   --> REAL*4 C   FMAXI   --> REAL*4G C               specify a cut-off range for the max and min of the data G C               0 <= FMINI < FMAXI <= 1   defaults FMINI=0.0, FMAXI=1.0  C   FMINI2  --> REAL*4 C   FMAXI2  --> REAL*4? C               specify a range for the max and min of the data * C               max = FMINI2*(max-min)+min* C               min = FMAXI2*(max-min)+min0 C               defaults  FMINI2=0.0, FMAXI2=1.0 C   BSCALE  --> REAL*4: C               scale factor on box size, 0 <= BSCALE <= 1# C               default  BSCALE=1.0  C   DERIV   --> LOGICAL*4 > C               if .TRUE. then the derivative of ARRAY is used7 C                 no derivative allowed with x y z data 4 C               if .FALSE. then ARRAY itself is used' C               default   DERIV=.FALSE.  C   PARTIAL --> LOGICAL*4 B C               if .TRUE. then the box sizes will be scaled to the; C                  portion of ARRAY that is within the axes C C               if .FALSE. then the box sizes will be scaled to the  C                  entire ARRAY ' C               default  PARTIAL=.TRUE.  C   POLAR   --> LOGICAL*4 8 C               if .TRUE. then X is assumed to be R and B C                              Y is assumed to be THETA (degrees) E C               if .FALSE. then X and Y are assumed to be rectangular & C               default  POLAR=.FALSE. C   PROFILE --> INTEGER*4 3 C               if PROFILE = 0 do not draw profiles 9 C               if PROFILE = 1 draw vertical profile only ; C               if PROFILE = 2 draw horizontal profile only G C               if PROFILE = 3 draw both vertical & horizontal profiles " C               default  PROFILE=0 C >       REAL      ARRAY*4(MAX(1,NDIM),1), X*4(1), Y*4(1), Z*4(1)E      #         ,XX*4(5), YY*4(5), X$(1), Y$(1), XR$(1), XC$(1), A$(1) &       INTEGER   PROFILE*4, PROFILEIN*4B       LOGICAL   DERIV, DERIVIN, PARTIAL, PARTIALIN, POLAR, POLARIN C %       COMMON /PLOT_OUTPUT_UNIT/ IOUTS  C A       XF(X) = XLAXIS + (X - XMIN)*(XUAXIS - XLAXIS)/(XMAX - XMIN) A       YF(Y) = YLAXIS + (Y - YMIN)*(YUAXIS - YLAXIS)/(YMAX - YMIN)  C        NUMARGS = NARGS(DUM)       IF( NUMARGS .LE. 20 )THEN          PROFILE = 0 
       ELSE         PROFILE = PROFILEIN        END IF       IF( NUMARGS .LE. 19 )THEN          POLAR   = .FALSE. 
       ELSE         POLAR   = POLARIN        END IF       IF( NUMARGS .LE. 18 )THEN          PARTIAL = .TRUE.
       ELSE         PARTIAL = PARTIALIN        END IF       IF( NUMARGS .LE. 17 )THEN          DERIV   = .FALSE. 
       ELSE         DERIV   = DERIVIN        END IF       IF( NUMARGS .LE. 16 )THEN          BSCALE  = 1.0 
       ELSE         BSCALE  = BSCALEIN       END IF       IF( NUMARGS .LE. 15 )THEN          FMAXI2  = 1.0 
       ELSE         FMAXI2  = FMAXI2IN       END IF       IF( NUMARGS .LE. 14 )THEN          FMINI2  = 0.0 
       ELSE         FMINI2  = FMINI2IN       END IF       IF( NUMARGS .LE. 13 )THEN          FMAXI   = 1.0 
       ELSE         FMAXI   = FMAXIIN        END IF       IF( NUMARGS .LE. 12 )THEN          FMINI   = 0.0 
       ELSE         FMINI   = FMINIIN        END IF       IF( NUMARGS .LT. 12 )THEN A         WRITE(IOUTS,10)'*** ERROR in BOX_DENS: too few arguments'  10      FORMAT(' ',A)          RETURN       END IF       IF( NZ .NE. 0 )THEN          IF( DERIV )THEN            WRITE(IOUTS,10) G      #  '*** ERROR in BOX_DENS: derivative not allowed with x y z data'            RETURN%         ELSE IF( PROFILE .GT. 0 )THEN            WRITE(IOUTS,10) E      #  '*** ERROR in BOX_DENS: profiles not allowed with x y z data'            RETURN         END IF       END IF C 1 C   Get the window and axis locations from GPLOT   C         XUWIND  = GETNAM('XUWIND')        XLWIND  = GETNAM('XLWIND')        YUWIND  = GETNAM('YUWIND')        YLWIND  = GETNAM('YLWIND') C        NUMX = NX        NUMY = NY !       IF( NX .EQ. 0 )NUMX = NCOL2 !       IF( NY .EQ. 0 )NUMY = NROW2 H       IF( NZ .EQ. 0 )THEN        ! there is no Z vector so ARRAY is used!         IF( NUMX .LT. NCOL2 )THEN            WRITE(IOUTS,10) H      #   '*** ERROR in BOX_DENS: X vector has fewer elements than the'//+      #   ' number of columns in the matrix'            RETURN         END IF!         IF( NUMY .LT. NROW2 )THEN            WRITE(IOUTS,10) H      #   '*** ERROR in BOX_DENS: Y vector has fewer elements than the'//(      #   ' number of rows in the matrix'           RETURN         END IF         NUMX = NCOL2         NUMY = NROW2         J11  = NCOL1         J12  = NCOL2         I11  = NROW1         I12  = NROW27       ELSE                       ! there is a z vector  "         NUMX = MIN(NUMX, NUMY, NZ)         NUMY = NUMX          J11  = 1         J12  = NUMX          I11  = 1         I12  = J12       END IF C &       ISTAT = LIB$GET_VM(4*NUMX,INDX1)       IF( .NOT.ISTAT )GO TO 99$       INDX = (INDX1 - %LOC(X$(1)))/4 C &       ISTAT = LIB$GET_VM(4*NUMY,INDY1)       IF( .NOT.ISTAT )GO TO 99$       INDY = (INDY1 - %LOC(Y$(1)))/4 C        DO J = J11, J12          IF( NX .EQ. 0 )THEN            X$(INDX+J) = FLOAT(J)          ELSE           X$(INDX+J) = X(J)          END IF       END DO C        DO I = I11, I12          IF( NY .EQ. 0 )THEN            Y$(INDY+I) = FLOAT(I)          ELSE           Y$(INDY+I) = Y(I)          END IF       END DO C        IF( POLAR )THEN 0         XMIN = X$(INDX+J11) * COSD(Y$(INDY+I11))         XMAX = XMIN 0         YMIN = Y$(INDX+J11) * SIND(Y$(INDY+I11))         YMAX = YMIN          DO I = I11, I12            DO J = J11, J12 1             XTEMP = X$(INDX+J) * COSD(Y$(INDY+I)) 1             YTEMP = X$(INDX+J) * SIND(Y$(INDY+I)) -             IF( XMIN .GT. XTEMP )XMIN = XTEMP -             IF( XMAX .LT. XTEMP )XMAX = XTEMP -             IF( YMIN .GT. YTEMP )YMIN = YTEMP -             IF( YMAX .LT. YTEMP )YMAX = YTEMP            END DO         END DO
       ELSE         XMIN = X$(INDX+J11)          XMAX = XMIN          YMAX = Y$(INDY+I11)          YMIN = YMAX          DO J = J11, J12 5           IF( XMIN .GT. X$(INDX+J) )XMIN = X$(INDX+J) 5           IF( XMAX .LT. X$(INDX+J) )XMAX = X$(INDX+J)          END DO         DO I = I11, I12 5           IF( YMIN .GT. Y$(INDY+I) )YMIN = Y$(INDY+I) 5           IF( YMAX .LT. Y$(INDY+I) )YMAX = Y$(INDY+I)          END DO       END IF       XX(1) = XMIN       XX(2) = XMAX       XX(3) = XMAX       XX(4) = XMIN       XX(5) = XMIN       YY(1) = YMAX       YY(2) = YMAX       YY(3) = YMIN       YY(4) = YMIN       YY(5) = YMAX       XMASK = GETNAM('MASK')       CALL SETNAM('MASK',0.)6       IF( (PROFILE .EQ. 3) .OR. (PROFILE .EQ. 2) )THEN         XUS = 85.0"         CALL SETNAM('%XUAXIS',XUS)       END IF6       IF( (PROFILE .EQ. 3) .OR. (PROFILE .EQ. 1) )THEN         YUS = 80.0"         CALL SETNAM('%YUAXIS',YUS)       END IF       CALL GPLOT(XX,YY,5,4)        CALL SETNAM('MASK',XMASK)        YLAXIS = GETNAM('YLAXIS')        XLAXIS = GETNAM('XLAXIS')        YUAXIS = GETNAM('YUAXIS')        XUAXIS = GETNAM('XUAXIS')        CALL TRANSPARENT_MODE(0)       CALL TRANSPARENT_MODE2(0)  C G C   Determine the min and max values on the axes that have been plotted  C        XMN = XMIN       XMX = XMAX       YMN = YMIN       YMX = YMAX C        XMIN = GETNAM('XMIN')        XMAX = GETNAM('XMAX')        YMIN = GETNAM('YMIN')        YMAX = GETNAM('YMAX')  C $ C   Use the following for zooming in C C       MLO = MAX(0,      IFIX((XMIN-XMN)/(XMX-XMN)*(J12-J11))) + J11 C       MHI = MIN(J12-J11,IFIX((XMAX-XMN)/(XMX-XMN)*(J12-J11))) + J11 C       NLO = MAX(0,      IFIX((YMIN-YMN)/(YMX-YMN)*(I12-I11))) + I11 C       NHI = MIN(I12-I11,IFIX((YMAX-YMN)/(YMX-YMN)*(I12-I11))) + I11  C        AMIN =  1.E30        AMAX = -1.E30        IF( PARTIAL )THEN          J1 = MLO         J2 = MHI         I1 = NLO         I2 = NHI
       ELSE         J1 = J11         J2 = J12         I1 = I11         I2 = I12       END IF C 6       IF( (PROFILE .EQ. 3) .OR. (PROFILE .EQ. 2) )THEN,         ISTAT = LIB$GET_VM(4*(I2-I1+1),IXR1)          IF( .NOT.ISTAT )GO TO 99%         IXR = (IXR1 - %LOC(XR$(1)))/4        END IF6       IF( (PROFILE .EQ. 3) .OR. (PROFILE .EQ. 1) )THEN,         ISTAT = LIB$GET_VM(4*(J2-J1+1),IXC1)          IF( .NOT.ISTAT )GO TO 99%         IXC = (IXC1 - %LOC(XC$(1)))/4        END IF-       ISTAT = LIB$GET_VM(4*NROW2*NCOL2,IAXY1)X       IF( .NOT.ISTAT )GO TO 99$       IAXY = (IAXY1 - %LOC(A$(1)))/4 C,8 C   Determine min and max values. The minimum value willD C   correspond to zero box size, the maximum to the largest box size Cr       IF( .NOT.DERIV )THEN Cl/ C   If DERIV = .FALSE. use linear density scalex C          IF( NZ .EQ. 0 )THEN            DO J = J1, J2              DO I = I1, I2y               AVAL = ARRAY(I,J)D+               A$(IAXY+I+(J-1)*NROW2) = AVALu:               IF( (PROFILE .EQ. 3) .OR. (PROFILE .EQ. 2) )-      #         XR$(IXR+I) = XR$(IXR+I) + AVAL*:               IF( (PROFILE .EQ. 3) .OR. (PROFILE .EQ. 1) )-      #         XC$(IXC+J) = XC$(IXC+J) + AVAL H               IF( (AVAL .LT. AMIN) .AND. (AVAL .GT. -1.E30) )AMIN = AVAL-               IF( AVAL .GT. AMAX )AMAX = AVAL              END DO           END DO         ELSE           DO I = I1, I2 F             IF( (Z(I) .LT. AMIN) .AND. (Z(I) .GT. -1.E30) )AMIN = Z(I)+             IF( Z(I) .GT. AMAX )AMAX = Z(I)e           END DO         END IF
       ELSE Ch4 C   If DERIV = .TRUE., use derivative contrast scale8 C   This only works if using a matrix and not x y z data C          DO J = J1, J2-1            DO I = I1, I2-1 *             AY = ARRAY(I+1,J) - ARRAY(I,J)*             AX = ARRAY(I,J+1) - ARRAY(I,J)#             ARG = SQRT(AX**2+AY**2) (             A$(IAXY+I+(J-1)*NROW2) = ARG8             IF( (PROFILE .EQ. 3) .OR. (PROFILE .EQ. 2) )*      #       XR$(IXR+I) = XR$(IXR+I) + ARG8             IF( (PROFILE .EQ. 3) .OR. (PROFILE .EQ. 1) )*      #       XC$(IXC+J) = XC$(IXC+J) + ARG)             IF( ARG .LT. AMIN )AMIN = ARG )             IF( ARG .GT. AMAX )AMAX = ARG ;             IF( J .EQ. (J2-1) )A$(IAXY+I+(J-1)*NROW2) = ARG            END DO'           A$(IAXY+I2+(J-1)*NROW2) = ARG          END DO?         A$(IAXY+I2+(J2-1)*NROW2) = A$(IAXY+(I2-1)+(J2-2)*NROW2)        END IF C #       IF( FMINI .LT. 0. )FMINI = 0.        FMIN  = FMINI        FMAX  = FMAXI '       AMAX  = AMAX + 0.05*(AMAX - AMIN) -       YSIDE = (YF(YMX) - YF(YMN)) / (I2-I1+1) -       XSIDE = (XF(XMX) - XF(XMN)) / (J2-J1+1)        XSIDE = BSCALE * XSIDE       YSIDE = BSCALE * YSIDE+       AMAXX = FMAXI2 * (AMAX - AMIN) + AMIN +       AMIN  = FMINI2 * (AMAX - AMIN) + AMIN        AMAX  = AMAXX        IF( PROFILE .GT. 0 )THEN!         HISTYP = GETNAM('HISTYP')           YAXIS  = GETNAM('YAXIS')          XAXIS  = GETNAM('XAXIS')!         XLINC  = GETNAM('NLXINC') !         YLINC  = GETNAM('NLYINC')          BOX    = GETNAM('BOX')!         XNUMSZ = GETNAM('XNUMSZ') !         YNUMSZ = GETNAM('YNUMSZ')  C 8         IF( (PROFILE .EQ. 3) .OR. (PROFILE .EQ. 2) )THEN"           CALL SETNAM('HISTYP',3.)!           CALL SETNAM('YAXIS',0.)             CALL SETNAM('XMIN',0.)            CALL SETNAM('XMAX',1.)"           CALL SETNAM('NLXINC',1.)           CALL SETNAM('BOX',0.) "           CALL SETNAM('XNUMSZ',0.)&           CALL SETNAM('XLAXIS',XUAXIS):           CALL SETNAM('XUAXIS',XUAXIS+0.1*(XUWIND-XLWIND))           XRMIN = XR$(IXR+I1)            XRMAX = XRMIN            DO I = I1, I2 9             IF( XRMAX .LT. XR$(IXR+I) )XRMAX = XR$(IXR+I) 9             IF( XRMIN .GT. XR$(IXR+I) )XRMIN = XR$(IXR+I)            END DO           DO I = I1, I2 ?             XR$(IXR+I) = (XR$(IXR+I) - XRMIN) / (XRMAX - XRMIN)            END DO7           CALL GPLOT(XR$(IXR+I1),Y$(INDY+I1),I2-I1+1,1)          END IF C 8         IF( (PROFILE .EQ. 3) .OR. (PROFILE .EQ. 1) )THEN"           CALL SETNAM('HISTYP',1.)           CALL SETNAM('BOX',0.) !           CALL SETNAM('YAXIS',1.) !           CALL SETNAM('XAXIS',0.) "           CALL SETNAM('NLYINC',1.)            CALL SETNAM('YMIN',0.)            CALL SETNAM('YMAX',1.)"           CALL SETNAM('XMIN',XMIN)"           CALL SETNAM('XMAX',XMAX)"           CALL SETNAM('YNUMSZ',0.)&           CALL SETNAM('XLAXIS',XLAXIS)&           CALL SETNAM('XUAXIS',XUAXIS)&           CALL SETNAM('YLAXIS',YUAXIS):           CALL SETNAM('YUAXIS',YUAXIS+0.1*(YUWIND-YLWIND))           XCMIN = XC$(IXC+J1)            XCMAX = XCMIN            DO J = J1, J2 9             IF( XCMIN .GT. XC$(IXC+J) )XCMIN = XC$(IXC+J) 9             IF( XCMAX .LT. XC$(IXC+J) )XCMAX = XC$(IXC+J)            END DO           DO J = J1, J2 ?             XC$(IXC+J) = (XC$(IXC+J) - XCMIN) / (XCMAX - XCMIN)            END DO7           CALL GPLOT(X$(INDX+J1),XC$(IXC+J1),J2-J1+1,1)          END IF C           CALL SETNAM('XMIN',XMIN)          CALL SETNAM('XMAX',XMAX)          CALL SETNAM('YMIN',YMIN)          CALL SETNAM('YMAX',YMAX)$         CALL SETNAM('HISTYP',HISTYP)"         CALL SETNAM('YAXIS',YAXIS)"         CALL SETNAM('XAXIS',XAXIS)#         CALL SETNAM('NLXINC',XLINC) #         CALL SETNAM('NLYINC',YLINC)          CALL SETNAM('BOX',BOX):         CALL SETNAM('%XNUMSZ',100.*XNUMSZ/(YUWIND-YLWIND)):         CALL SETNAM('%YNUMSZ',100.*YNUMSZ/(YUWIND-YLWIND))D         XLAXISP = ABS(XLAXIS - XLWIND) / ABS(XUWIND - XLWIND) * 100.D         XUAXISP = ABS(XUAXIS - XLWIND) / ABS(XUWIND - XLWIND) * 100.D         YLAXISP = ABS(YLAXIS - YLWIND) / ABS(YUWIND - YLWIND) * 100.D         YUAXISP = ABS(YUAXIS - YLWIND) / ABS(YUWIND - YLWIND) * 100.&         CALL SETNAM('%YLAXIS',YLAXISP)&         CALL SETNAM('%YUAXIS',YUAXISP)&         CALL SETNAM('%XLAXIS',XLAXISP)&         CALL SETNAM('%XUAXIS',XUAXISP)       END IF       DO J = J1, J2          IF( NZ .EQ. 0 )THEN  C ' C   Using the matrix and not x y z data  C            DO I = I1, I2              IF( POLAR )THEN 1               XXX = X$(INDX+J) * COSD(Y$(INDY+I)) 1               YYY = X$(INDX+J) * SIND(Y$(INDY+I))              ELSE               XXX = X$(INDX+J)               YYY = Y$(INDY+I)             END IF.             CALL DRAW_DENS_BOX(XF(XXX),YF(YYY)5      #                        ,A$(IAXY+I+(J-1)*NROW2) 2      #                        ,AMAX,AMIN,FMIN,FMAXG      #                        ,XSIDE,YSIDE,XLAXIS,XUAXIS,YLAXIS,YUAXIS)            END DO         ELSE C ' C   Using x y z data and not the matrix  C            IF( POLAR )THEN /             XXX = X$(INDX+J) * COSD(Y$(INDY+J)) /             YYY = X$(INDX+J) * SIND(Y$(INDY+J))            ELSE             XXX = X$(INDX+J)             YYY = Y$(INDY+J)           END IF,           CALL DRAW_DENS_BOX(XF(XXX),YF(YYY)!      #                      ,Z(J) 0      #                      ,AMAX,AMIN,FMIN,FMAXE      #                      ,XSIDE,YSIDE,XLAXIS,XUAXIS,YLAXIS,YUAXIS)          END IF       END DO       CALL FLUSH_PLOT 6       IF( (PROFILE .EQ. 3) .OR. (PROFILE .EQ. 2) )THEN-         ISTAT = LIB$FREE_VM(4*(I2-I1+1),IXR1)           IF( .NOT.ISTAT )GO TO 99       END IF6       IF( (PROFILE .EQ. 3) .OR. (PROFILE .EQ. 1) )THEN-         ISTAT = LIB$FREE_VM(4*(J2-J1+1),IXC1)           IF( .NOT.ISTAT )GO TO 99       END IF.       ISTAT = LIB$FREE_VM(4*NROW2*NCOL2,IAXY1)       IF( .NOT.ISTAT )GO TO 99'       ISTAT = LIB$FREE_VM(4*NUMX,INDX1)        IF( .NOT.ISTAT )GO TO 99'       ISTAT = LIB$FREE_VM(4*NUMY,INDY1)        IF( .NOT.ISTAT )GO TO 99       RETURN" 99    CALL PUT_SYSMSG(ISTAT,IOUTS)       RETURN 100   FORMAT(' ',A) 	       END  C F       SUBROUTINE DRAW_DENS_BOX( XA, YA, AVALUE, AMAX, AMIN, FMIN, FMAX,      #                         ,XSIDE, YSIDE@      #                         ,XLAXIS, XUAXIS, YLAXIS, YUAXIS ) C        DATA FRACMIN / 0.01 /  C B       FRAC = MAX( 0., MIN( 1., (AVALUE - AMIN) / (AMAX - AMIN) ) ) C 8       IF( (FRAC .LE. FRACMIN) .OR. (FRAC .LT. FMIN) .OR.#      #    (FRAC .GT. FMAX) ) RETURN  C        DX = 0.5 * XSIDE * FRAC        DY = 0.5 * YSIDE * FRAC /       XL = MIN( XUAXIS, MAX( XA - DX, XLAXIS )) /       XU = MAX( XLAXIS, MIN( XA + DX, XUAXIS )) /       YL = MIN( YUAXIS, MAX( YA - DY, YLAXIS )) /       YU = MAX( YLAXIS, MIN( YA + DY, YUAXIS ))        CALL PLOT_R(XL,YU,3)       CALL PLOT_R(XU,YU,2)       CALL PLOT_R(XU,YL,2)       CALL PLOT_R(XL,YL,2)       CALL PLOT_R(XL,YU,2)       RETURN	       END 