H C                                                                      *8       SUBROUTINE LABXY(XTICL,YTICL,ANGLAB,COSLAB,SINLAB,3      *                 SIZLAB,FLENG,YLIM,XLAB,YLAB) A C================================================================ A C================================================================ A C==                                                            == A C==   LABXY: Given the label location (XTICL,YTICL) relative to== A C==          a point on an axis and the label angle "ANGLAB"   == A C==          relative to the axis direction, and the label     == A C==          size and length "SIZLAB" and "FLENG", "LABXY"     == A C==          determines the lower left hand corner (XLAB,YLAB),== A C==          at which the label is to be plotted, relative to  == A C==          the same point on the axis.                       == A C==                                                            == A C==   Diagram: showing where (XTICL,YTICL) will be centered on == A C==            the label perimeter as a function of the label  == A C==            angle, shown in degrees. The values outside the == A C==            box represent the label angles when the label   == A C==            is below the axis (YTICL <= 0.), while the      == A C==            values inside the box represent the label angles== A C==            when the label is above the axis (YTICL > 0.).  == A C==            The label angle is linear over each of the four == A C==            regions of the label perimeter.                 == A C==                                                            == A C==                     <------region #1------>                == A C==                   315          0           45              == A C==             ^      +-----------+-----------+     ^         == A C==             |      | 135      180      225 |     |         == A C==             |      |          #3           |     |         == A C==     region #4  270 + 90 #2   LABEL  #4 270 + 90  region #2 == A C==             |      |          #1           |     |         == A C==             |      | 45        0       315 |     |         == A C==             |      +-----------+-----------+     |         == A C==                   225         180         135              == A C==                     <------region #3------>                == A C==                                                            == A C==                                                            == A C==   Written by Arthur Haynes, TRIUMF U.B.C., April 22, 1981. == A C==                                                            == A C==   Input  Parameters: XTICL,YTICL,ANGLAB,COSLAB,SINLAB,     == A C==                      SIZLAB,FLENG,YLIM (R*4).              == A C==                                                            == A C==   Output Parameters: XLAB,YLAB (R*4).                      == A C==                                                            == A C==   Parameter Definitions:                                   == A C==   --------- -----------                                    == A C==                                                            == A C==   XTICL : x-coordinate (parallel to the axis), relative to == A C==           an arbitrary point on the axis, at which the     == A C==           label perimeter will be centered.                == A C==                                                            == A C==   YTICL : y-coordinate (perpendicular to the axis), relative= A C==           to the axis, at which the label perimeter will be== A C==           centered. "YTICL" is positive if the label is to == A C==           be plotted above the axis and "YTICL" is negative== A C==           or zero if the label is to be plotted below the  == A C==           axis.                                            == A C==                                                            == A C==   ANGLAB: angle in degrees at which the label is to be     == A C==           plotted relative to the axis direction.          == A C==                                                            == A C==   COSLAB: cosine of "ANGLAB".                              == A C==                                                            == A C==   SINLAB: sine   of "ANGLAB".                              == A C==                                                            == A C==   SIZLAB: height of the label in the same units as "XTICL" == A C==           and "YTICL".                                     == A C==                                                            == A C==   FLENG : length of the label.                             == A C==                                                            == A C==   YLIM  : The label when plotted is not allowed to cross   == A C==           the line "Y = YLIM". If, after determining the   == A C==           position of (XTICL,YTICL) on the label perimeter == A C==           using the scheme given in the above diagram, the == A C==           label crosses the line "Y = YLIM" then the label == A C==           is shifted away from the axis so that it just    == A C==           touches the line "Y = YLIM" and so that the point== A C==           (XTICL,YTICL) is still on the label perimeter.   == A C==                                                            == A C==   XLAB  : x-coordinate of the lower left hand corner at    == A C==           which the label is to be plotted, calculated in  == A C==           the same coordinate system as (XTICL,YTICL).     == A C==                                                            == A C==   YLAB  : y-coordinate of the lower left hand corner at    == A C==           which the label is to be plotted, calculated in  == A C==           the same coordinate system as (XTICL,YTICL).     == A C==                                                            == A C================================================================ A C================================================================ A C==   If YLIM > YTICL > 0 or YLIM < YTICL <= 0 then set        == A C==   YLIM2 = YTICL.                                           == A C================================================================        YLIM2=YLIM2       IF(YTICL.GT.0..AND.YLIM.GT.YTICL)YLIM2=YTICL2       IF(YTICL.LE.0..AND.YLIM.LT.YTICL)YLIM2=YTICLA C================================================================ A C==   DISTX = length of the line segment which intersects the  == A C==           2 lines: "Y = YTICL" and "Y = YLIM2" at an angle == A C==           of "ANGLAB" degrees.                             == A C==   DISTY = length of the line segment which intersects the  == A C==           2 lines: "Y = YTICL" and "Y = YLIM2" at an angle == A C==           of "ANGLAB + 90" degrees.                        == A C================================================================        DISTX=-1.        DISTY=-1. =       IF(ABS(SINLAB).GT.1.E-3)DISTX=ABS((YLIM2-YTICL)/SINLAB) =       IF(ABS(COSLAB).GT.1.E-3)DISTY=ABS((YLIM2-YTICL)/COSLAB) A C================================================================ A C==   Make sure that -45 <= ANGLE < 315  degrees.              == A C==   Then calculate the region number: "IREG" of the "ANGLE". == A C==   See the diagram above.                                   == A C================================================================ %       ANGLE=AMOD(ANGLAB+45.,360.)-45. '       IF(ANGLE.LT.-45.)ANGLE=ANGLE+360.        IREG=(ANGLE+45.)/90.+1.        IREG=MIN0(MAX0(IREG,1),4) A C================================================================ A C==   Go to the appropriate section depending on the region    == A C==   number: IREG.                                            == A C================================================================ "       GO TO (100,200,300,400),IREGA C================================================================ A C==   Region number 1                                          == A C================================================================  100   IF(YTICL.GT.0.)GO TO 150       X=(ANGLE+45.)/90.*FLENG        Y=SIZLAB       IF(DISTX.LT.0.)GO TO 5008       IF(SINLAB.GT.0..AND.FLENG-X.GT.DISTX)X=FLENG-DISTX,       IF(SINLAB.LT.0..AND.X.GT.DISTX)X=DISTX       GO TO 500  150   X=(45.-ANGLE)/90.*FLENG 
       Y=0.       IF(DISTX.LT.0.)GO TO 500,       IF(SINLAB.GT.0..AND.X.GT.DISTX)X=DISTX8       IF(SINLAB.LT.0..AND.FLENG-X.GT.DISTX)X=FLENG-DISTX       GO TO 500 A C================================================================ A C==   Region number 2                                          == A C================================================================  200   IF(YTICL.GT.0.)GO TO 250
       X=FLENG        Y=(135.-ANGLE)/90.*SIZLAB        IF(DISTY.LT.0.)GO TO 500:       IF(COSLAB.GT.0..AND.SIZLAB-Y.GT.DISTY)Y=SIZLAB-DISTY,       IF(COSLAB.LT.0..AND.Y.GT.DISTY)Y=DISTY       GO TO 500 
 250   X=0.       Y=(ANGLE-45.)/90.*SIZLAB       IF(DISTY.LT.0.)GO TO 500,       IF(COSLAB.GT.0..AND.Y.GT.DISTY)Y=DISTY:       IF(COSLAB.LT.0..AND.SIZLAB-Y.GT.DISTY)Y=SIZLAB-DISTY       GO TO 500 A C================================================================ A C==   Region number 3                                          == A C================================================================  300   IF(YTICL.GT.0.)GO TO 350       X=(225.-ANGLE)/90.*FLENG
       Y=0.       IF(DISTX.LT.0.)GO TO 5008       IF(SINLAB.GT.0..AND.FLENG-X.GT.DISTX)X=FLENG-DISTX,       IF(SINLAB.LT.0..AND.X.GT.DISTX)X=DISTX       GO TO 500  350   X=(ANGLE-135.)/90.*FLENG       Y=SIZLAB       IF(DISTX.LT.0.)GO TO 500,       IF(SINLAB.GT.0..AND.X.GT.DISTX)X=DISTX8       IF(SINLAB.LT.0..AND.FLENG-X.GT.DISTX)X=FLENG-DISTX       GO TO 500 A C================================================================,A C==   Region number 4                                          == A C================================================================  400   IF(YTICL.GT.0.)GO TO 450
       X=0.       Y=(ANGLE-225.)/90.*SIZLAB        IF(DISTY.LT.0.)GO TO 500:       IF(COSLAB.GT.0..AND.SIZLAB-Y.GT.DISTY)Y=SIZLAB-DISTY,       IF(COSLAB.LT.0..AND.Y.GT.DISTY)Y=DISTY       GO TO 500a
 450   X=FLENGe       Y=(315.-ANGLE)/90.*SIZLAB        IF(DISTY.LT.0.)GO TO 500,       IF(COSLAB.GT.0..AND.Y.GT.DISTY)Y=DISTY:       IF(COSLAB.LT.0..AND.SIZLAB-Y.GT.DISTY)Y=SIZLAB-DISTYA C================================================================ A C==   Calculate the location of the lower left hand corner of  == A C==   the label: (XLAB,YLAB).                                  == A C================================================================a" 500   XLAB=XTICL-X*COSLAB+Y*SINLAB"       YLAB=YTICL-X*SINLAB-Y*COSLAB       RETURN	       ENDu  