+       SUBROUTINE GRAPHICS_HARDCOPY(IDEVICE) H C======================================================================CH C                                                                      CH C  GRAPHICS_HARDCOPY                            F.W. Jones, TRIUMF     CH C                                                                      CH C  Controls the output of hardcopy for various devices.                CH C                                                                      CH C  IDEVICE         0:  Device not specified                            CH C                  1:  Printronix                                      CH C                  2:  Zeta plotter                                    CH C                  3:  HP plotter                                      CH C                  4:  HP Laserjet                                     CH C                  5:  HP Thinkjet                                     CH C                  6:  DEC LA100                                       CH C                  7:  QMS Lasergrafix                                 CH C                  8:  Houston Instruments plotter                     CH C                  9:  DEC LN03+                                       CH C                 10:  Imagen laser printer (IMPRESS)                  CH C                 11:  HP Paintjet                                     CH C                 12:  PostScript                                      CL C                 13:  UIS metafile                                        CH C                                                                      CH C  If IDEVICE is 0, the bitmap and MONITOR2 settings are tested        CH C  and a menu of possible devices is displayed.  The user enters a     CH C  code to select the desired device.                                  CH C                                                                      CH C  Once the hardcopy device has been established, a command menu is    CH C  displayed.  The commands are:                                       CH C                                                                      CH C  PRINT -- produces a plot file and submits it to a device queue      CH C           The queue name can be specified by the user.               CH C                                                                      CH C  SAVE  -- produces a plot file for later printing                    CH C           The file name can be specified by the user.                CH C                                                                      CH C   Modified by J. Chuma on October 31, 1985 to change the input       CH C   and output units to IINS and IOUTS                                 CH C                                                                      CH C  Modified Dec 4/85 by F. Jones:  QMS Lasergrafix added.              CH C                                                                      CH C  Modified Feb 22/86 by J. Chuma:  Included IBIT for compatability    CH C  with PLOT_DEVICE_CM and SET_PLOT_DEVICES so the bitmap device       CH C  is known.  Also, included the auxilliary port output for the HP     CH C  or HOUSTON plotter.                                                 CH C                                                                      CH C  Modified Aug 11/86 by F. Jones:  Houston Instruments plotter added. CH C                                                                      CH C  Modified Sep 29/86 by C. Kost: Optional QUE_NAME used in            CH C  COMMON/QUE_NAMES/QUE_NAME is used when IDEVICE<0                    CH C  hardcopy to the device specified by IDEVICE without prompts.        CH C                                                                      CH C  Modified Nov 19/86 by F. Jones:  TeX bitmap option added for        CH C  HP Laserjet+.                                                       CH C                                                                      CH C  Modified Feb 3/87 by F. Jones:  limited support added for the       CH C  DEC LN03+ laser printer, to allow printing and saving hardcopies    CH C  from EDGR.  There is no work file, and it is assumed that the       CH C  plot file LN03.PLT has been generated on unit IOUTM2 with the       CH C  necessary escape sequences, ready to be saved or shipped to the     CH C  LN03.  No file name can be specified in the SAVE command.           CH C                                                                      CH C  Modified Nov 10/87 by F. Jones.  Support added for HP Paintjet.     CH C  Also, the APPEND option has been tentatively removed due to         CH C  problems caused by the SAVE file remaining open for append. This    CH C  feature is rarely used and in any case its removal will keep the    CH C  size of print jobs to a minimum for more equitable queue operation. CH C                                                                      CH C  Modified Feb 10/87 by F. Jones.  In the PRINT operation, plot       CH C  files are now written to the device and directory specified by      CH C  logical name SYS$SCRATCH.  As before, these files will be deleted   CH C  after printing.                                                     CH C                                                                      CH C  Modified June 6/88 by F. Jones.  Error returns added for plot file  CH C  output routines.  WRITE_PLOT_ZETA and WRITE_PLOT_HPP are now        CH C  subroutines rather than entry points to ZP and HP.                  CH C                                                                      CH C  Modified November 4/88 by J. Chuma. Allow QMS plots to Print to     CH C  a queue                                                             CH C                                                                      CH C  Modified Nov 14/88 by J. Chuma: LN03 fully supported                CH C                                                                      CH C  Modified 21-DEC-88 by F. Jones.  This routine has been largely      CH C  re-written to improve clarity and ease of maintenance.  The UIS     CH C  metafile output is now fully supported.                             CH C                                                                      CH C======================================================================C  E       COMMON/VST_PLOT/IVDID,IATB    ! first part of common block only   &       COMMON / BITMAP_DEVICE / IBIT_IN       DATA   IBIT_IN / 0 / C  If last digit of IBIT_IN . C            = 0 --> No specific device chosen C            = 1 --> PRINTRONIX  C            = 2 --> HPLASER C            = 3 --> HPTHINK C            = 4 --> LA100  C            = 5 --> HP Paintjet( C  For example, IBIT_IN = 22 --> HPLASER, C               IBIT_IN = 15 --> HP Paintjet         COMMON/SPOOL/FMTED       LOGICAL FMTED 7       COMMON/PLOT_HARDCOPY/IXLAST,IYLAST,N1,N2,HARDCOPY "       LOGICAL*1 HARDCOPY(188,2048)(       COMMON/PLOT_MONITOR/IMONITOR,IOUTM+       COMMON/PLOT_MONITOR2/IMONITOR2,IOUTM2        COMMON/TO_BIT_OR_NOT/WELL        LOGICAL WELL!       COMMON/PLOT_INPUT_UNIT/IINS #       COMMON/PLOT_OUTPUT_UNIT/IOUTS "       DATA IINS / 5 /, IOUTS / 6 /       COMMON/QUE_NAMES/QUE_NAME        CHARACTER*20 QUE_NAME   3 C Change this parameter when new devices are added:        PARAMETER(NDEV=13) C Device names: <       CHARACTER*15 DEVICE(NDEV)/'Printronix','Zeta plotter',8      # 'HP plotter','HP Laserjet','HP Thinkjet','LA100',<      # 'QMS Lasergrafix','Houston plotter','LN03+','Imagen',2      #  'HP Paintjet','PostScript','UIS metafile'/ C Device codes: ?       CHARACTER*3 DEVCODE(NDEV)/'P','Z','HPP','HPL','HPT','LA', ,      # 'Q','HOU','LN','IM','HPJ','PS','UIS'/# C Default filenames for plot files: ?       CHARACTER*14 DEVFILE(NDEV)/'PX.PLT','ZETA.PLT','HPP.PLT', H      #  'HPLASER.PLT','HPTHINK.PLT','LA100.PLT','QMS.PLT','HOUSTON.PLT',?      #  'LN03.PLT','IMAGEN.PLT','HPPAINT.PLT','POSTSCRIPT.PLT',       #  'UISMETA.PLT'/ C List of valid devices        LOGICAL VALID(NDEV)   .       CHARACTER*60 INBUFF,PARAM,QUEUE,PLOTFILE       CHARACTER*20 DEFQUE        CHARACTER*5 COMMAND        CHARACTER*1 CC       CHARACTER*7 PRTOPT  !       LOGICAL PRINTOK,AUXOK,TEXOK          CHARACTER*(*) ESC,REV,NOR ;       PARAMETER(ESC=CHAR(27),REV=ESC//'[7m',NOR=ESC//'[0m')   &       IBIT = IBIT_IN - 10*(IBIT_IN/10)         IF(NARGS().GT.0)THEN         IDEV=ABS(IDEVICE) 2         IF(IDEVICE.LT.0)THEN      !direct printing           CC='P'0           PLOTFILE='SYS$SCRATCH:'//DEVFILE(IDEV)           QUEUE=QUE_NAME           GO TO 70
         ENDIF 
       ELSE         IDEV=0       ENDIF          IF(IDEV.NE.0)GO TO 60 H C======================================================================C7 C  Device not specified.  Make a list of valid devices. H C======================================================================C       CALL CLTRANS*       IF(WELL)THEN      !Bitmap devices...         IF(IBIT .EQ. 0)THEN            VALID(1)=.TRUE.            VALID(4)=.TRUE.            VALID(5)=.TRUE.            VALID(6)=.TRUE. 1         ELSE IF(IBIT .EQ. 1)THEN      !Printronix            VALID(1)=.TRUE. 2         ELSE IF(IBIT .EQ. 2)THEN      !HP Laserjet           VALID(4)=.TRUE. 2         ELSE IF(IBIT .EQ. 3)THEN      !HP Thinkjet           VALID(5)=.TRUE. ,         ELSE IF(IBIT .EQ. 4)THEN      !LA100           VALID(6)=.TRUE. 2         ELSE IF(IBIT .EQ. 5)THEN      !HP Paintjet           VALID(11)=.TRUE.         END IF             ENDIF    C Plotters: /       IF(IMONITOR2.EQ.4)THEN      !Zeta plotter          VALID(2)=.TRUE. 2       ELSE IF(IMONITOR2.EQ.5)THEN      !HP plotter         VALID(3)=.TRUE. 8       ELSE IF(IMONITOR2.EQ.10)THEN      !QMS Lasergrafix         VALID(7)=.TRUE. 3       ELSE IF(IMONITOR2.EQ.11)THEN      !HI plotter          VALID(8)=.TRUE. /       ELSE IF(IMONITOR2.EQ.13)THEN      !Imagen          VALID(10)=.TRUE.3       ELSE IF(IMONITOR2.EQ.14)THEN      !PostScript          VALID(12)=.TRUE..       ELSE IF(IMONITOR2.EQ.16)THEN      !LN03+         VALID(9)=.TRUE.        ENDIF    C UIS metafile7       IF(IMONITOR.EQ.15.AND.IVDID.GT.0)VALID(13)=.TRUE.    C How many valid devices?        NVALID=0       DO I=1,NDEV          IF(VALID(I))THEN           NVALID=NVALID+1            IDEV=I
         ENDIF        ENDDO        IF(NVALID.EQ.0)THEN 7         WRITE(*,*)'GRAPHICS_HARDCOPY: no valid devices'          RETURN       ENDIF        IF(NVALID.EQ.1)GO TO 60    C Write the selection list       DO I=1,NDEV B         IF(VALID(I))WRITE(IOUTS,*)REV,' ',DEVCODE(I),' ',NOR,'  ',      #     DEVICE(I)       ENDDO        WRITE(IOUTS,*)  H C======================================================================C C  Device selection H C======================================================================C 25    WRITE(IOUTS,1000) ; 1000  FORMAT(' Enter device code or <RETURN> to quit > ',$)        READ(IINS,1001)INBUFF  1001  FORMAT(A) #       IF(LENSIG(INBUFF).EQ.0)RETURN $       CALL STR$UPCASE(INBUFF,INBUFF) C  Strip off leading blanks "       DO WHILE(INBUFF(1:1).EQ.' ')         INBUFF=INBUFF(2:)        ENDDO          DO I=1,NDEV $         IF(INBUFF.EQ.DEVCODE(I))THEN           IF(.NOT.VALID(I))THEN /             WRITE(IOUTS,*)'Invalid device code'              GO TO 25           ENDIF            IDEV=I           GO TO 60
         ENDIF        ENDDO )       WRITE(IOUTS,*)'Invalid device code'        GO TO 25  H C======================================================================CA C  Determine valid commands and defaults.  This section should be D C  modified to reflect local conditions as follows: for each device,@ C    Set PRINTOK to false if printing on a queue is not allowed.D C    Set DEFQUE to the queue name if there is a default print queue.< C    Set TEXOK to true if TeX-includable output is possible.; C    Set AUXOK to true if auxiliary port output is allowed. H C======================================================================C 60    CALL CLTRANS       PRINTOK=.TRUE.       DEFQUE=' '       TEXOK=.FALSE.        AUXOK=.FALSE. *       IF(IDEV.EQ.2)THEN      !Zeta plotter         DEFQUE='ZPLTR'-       ELSE IF(IDEV.EQ.3)THEN      !HP plotter          DEFQUE='HPLTR'         AUXOK=.TRUE..       ELSE IF(IDEV.EQ.4)THEN      !HP Laserjet         DEFQUE='HP$LASER'          TEXOK=.TRUE.)       ELSE IF(IDEV.EQ.6)THEN      !LA 100          DEFQUE='PHYS' 2       ELSE IF(IDEV.EQ.7)THEN      !QMS Lasergrafix         DEFQUE='QMS$LASER'2       ELSE IF(IDEV.EQ.8)THEN      !Houston plotter         AUXOK=.TRUE./       ELSE IF(IDEV.EQ.13)THEN     !UIS metafile          PRINTOK=.FALSE.        ENDIF   H C======================================================================C C  Display the command menu H C======================================================================C*       WRITE(IOUTS,*)'Device=',DEVICE(IDEV)1       WRITE(IOUTS,*)REV,' HARDCOPY COMMANDS ',NOR        IF(PRINTOK)THEN          IF(DEFQUE.EQ.' ')THEN 5           WRITE(IOUTS,*)REV,'  Print {que-name} ',NOR          ELSED           WRITE(IOUTS,*)REV,'  Print [que-name] ',NOR,'  (default ',*      #        DEFQUE(1:LENSIG(DEFQUE)),')'
         ENDIF        ENDIF @       WRITE(IOUTS,*)REV,'  Save [file-name] ',NOR,'  (default ',4      #    DEVFILE(IDEV)(1:LENSIG(DEVFILE(IDEV))),')';       IF(TEXOK)WRITE(IOUTS,*)REV,'  Tex [file-name]  ',NOR, !      #    '  (default HPTEX.PLT)' ;       IF(AUXOK)WRITE(IOUTS,*)REV,'  Aux              ',NOR, %      #    '  (auxiliary port output)'        WRITE(IOUTS,*)  H C======================================================================C C  Read and parse the command H C======================================================================C 65    WRITE(IOUTS,1002) 7 1002  FORMAT(' Enter command or <RETURN> to quit > ',$)        READ(IINS,1003)INBUFF  1003  FORMAT(A) #       IF(LENSIG(INBUFF).EQ.0)RETURN $       CALL STR$UPCASE(INBUFF,INBUFF)  ; C Identify the command and set command code CC accordingly. 4       CALL GRAPHICS_HARDCOPY_PARSE(INBUFF,COMMAND,1)       NC=LENSIG(COMMAND).       IF(INDEX('SAVE',COMMAND(1:NC)).EQ.1)THEN         CC='S'<       ELSE IF(INDEX('PRINT',COMMAND(1:NC)).EQ.1)THEN                 IF(.NOT.PRINTOK)THEN)           WRITE(IOUTS,*)'Invalid command'            GO TO 65
         ENDIF          CC='P'2       ELSE IF(INDEX('AUX',COMMAND(1:NC)).EQ.1)THEN         IF(.NOT.AUXOK)THEN)           WRITE(IOUTS,*)'Invalid command'            GO TO 65
         ENDIF          CC='A'@       ELSE IF(IDEV.EQ.4.AND.INDEX('TEX',COMMAND(1:NC)).EQ.1)THEN         IF(.NOT.TEXOK)THEN)           WRITE(IOUTS,*)'Invalid command'            GO TO 65
         ENDIF          CC='T'
       ELSE-         WRITE(IOUTS,*)'Unrecognized command.'          GO TO 65       ENDIF   ) C Establish plot file name and queue name        IF(CC.EQ.'P')THEN 4         CALL GRAPHICS_HARDCOPY_PARSE(INBUFF,PARAM,2)"         IF(LENSIG(PARAM).EQ.0)THEN           IF(DEFQUE.NE.' ')THEN              QUEUE=DEFQUE           ELSE8             WRITE(IOUTS,*)'Queue name must be specified'             GO TO 65           ENDIF          ELSE           QUEUE=PARAM 
         ENDIF .         PLOTFILE='SYS$SCRATCH:'//DEVFILE(IDEV)       ELSE IF(CC.EQ.'S')THEN4         CALL GRAPHICS_HARDCOPY_PARSE(INBUFF,PARAM,2)"         IF(LENSIG(PARAM).EQ.0)THEN            PLOTFILE=DEVFILE(IDEV)         ELSE           PLOTFILE=PARAM
         ENDIF        ELSE IF(CC.EQ.'T')THEN4         CALL GRAPHICS_HARDCOPY_PARSE(INBUFF,PARAM,2)"         IF(LENSIG(PARAM).EQ.0)THEN           PLOTFILE='HPTEX.PLT'         ELSE           PLOTFILE=PARAM
         ENDIF        ELSE IF(CC.EQ.'A')THEN.         PLOTFILE='SYS$SCRATCH:'//DEVFILE(IDEV)       ENDIF   H C======================================================================C C  Open the plot file H C======================================================================C 70    CALL FIND_UNIT(IOUTH) (       IF(IDEV.EQ.1)THEN      !PrintronixF         OPEN(UNIT=IOUTH,FILE=PLOTFILE,STATUS='NEW',FORM='UNFORMATTED',5      #       CARRIAGECONTROL='LIST',RECL=136,ERR=999) ?       ELSE IF(IDEV.EQ.2.OR.IDEV.EQ.3)THEN      !Zeta/HP plotter 3         OPEN(UNIT=IOUTH,FILE=PLOTFILE,STATUS='NEW', ,      #       CARRIAGECONTROL='LIST',ERR=999)A       ELSE IF(IDEV.EQ.4.OR.IDEV.EQ.5)THEN      !HP Laser/ThinkjetE<         OPEN(UNIT=IOUTH,FILE=PLOTFILE,RECL=255,             9      #       CARRIAGECONTROL='NONE',STATUS='NEW',ERR=999) (       ELSE IF(IDEV.EQ.6)THEN      !LA100&         OPEN(UNIT=IOUTH,FILE=PLOTFILE,"      #       STATUS='NEW',ERR=999)&       ELSE IF(IDEV.EQ.7)THEN      !QMS&         OPEN(UNIT=IOUTH,FILE=PLOTFILE,9      #       CARRIAGECONTROL='LIST',STATUS='NEW',ERR=999)s*       ELSE IF(IDEV.EQ.8)THEN      !Houston&         OPEN(UNIT=IOUTH,FILE=PLOTFILE,9      #       CARRIAGECONTROL='LIST',STATUS='NEW',ERR=999) )       ELSE IF(IDEV.EQ.9)THEN      ! LN03+1&         OPEN(UNIT=IOUTH,FILE=PLOTFILE,<      #       CARRIAGECONTROL='FORTRAN',STATUS='NEW',ERR=999)*       ELSE IF(IDEV.EQ.10)THEN     ! Imagen&         OPEN(UNIT=IOUTH,FILE=PLOTFILE,9      #       CARRIAGECONTROL='NONE',STATUS='NEW',ERR=999) /       ELSE IF(IDEV.EQ.11)THEN     ! HP PaintJet5/         OPEN(UNIT=IOUTH,FILE=PLOTFILE,RECL=512, 9      #       CARRIAGECONTROL='NONE',STATUS='NEW',ERR=999) .       ELSE IF(IDEV.EQ.12)THEN     ! PostScript&         OPEN(UNIT=IOUTH,FILE=PLOTFILE,9      #       CARRIAGECONTROL='LIST',STATUS='NEW',ERR=999)        ENDIF   C       IF(CC.EQ.'S'.OR.CC.EQ.'T')WRITE(IOUTS,*)'Plot file ',PLOTFILE   H C======================================================================C C  Write into the plot file H C======================================================================C(       IF(IDEV.EQ.1)THEN      !Printronix         FMTED=.FALSE. A         CALL WRITE_BITMAP_PX(IOUTH,HARDCOPY,188,N1,N2,.TRUE.,&65) /       ELSE IF(IDEV.EQ.2)THEN      !Zeta plotter .         CALL WRITE_PLOT_ZETA(IOUTM2,IOUTH,&65)-       ELSE IF(IDEV.EQ.3)THEN      !HP plotterd-         CALL WRITE_PLOT_HPP(IOUTM2,IOUTH,&65)u.       ELSE IF(IDEV.EQ.4)THEN      !HP Laserjet         LASER=1          IF(CC.EQ.'T')LASER=2@         CALL WRITE_BITMAP_HPJET(IOUTH,HARDCOPY,188,N1,N2,.TRUE.,      #    LASER,&65).       ELSE IF(IDEV.EQ.5)THEN      !HP ThinkjetF         CALL WRITE_BITMAP_HPJET(IOUTH,HARDCOPY,188,N1,N2,.TRUE.,0,&65)(       ELSE IF(IDEV.EQ.6)THEN      !LA100D         CALL WRITE_BITMAP_LA100(IOUTH,HARDCOPY,188,N1,N2,.TRUE.,&65)2       ELSE IF(IDEV.EQ.7)THEN      !QMS Lasergrafix-         CALL WRITE_PLOT_QMS(IOUTM2,IOUTH,&65)u*       ELSE IF(IDEV.EQ.8)THEN      !Houston1         CALL WRITE_PLOT_HOUSTON(IOUTM2,IOUTH,&65) (       ELSE IF(IDEV.EQ.9)THEN      !LN03+.         CALL WRITE_PLOT_LN03(IOUTM2,IOUTH,&65)1       ELSE IF(IDEV.EQ.10)THEN     !Imagen IMPRESS 1         CALL WRITE_PLOT_IMPRESS(IOUTM2,IOUTH,&65) .       ELSE IF(IDEV.EQ.11)THEN     !HP Paintjet,         CALL WRITE_BITMAP_HPPAINT(IOUTH,&65)-       ELSE IF(IDEV.EQ.12)THEN     !PostScript 4         CALL WRITE_PLOT_POSTSCRIPT(IOUTM2,IOUTH,&65)       ELSE IF(IDEV.EQ.13)THEN 4         CALL VST_WRITE_DISPLAY(IVDID,PLOTFILE,ISTAT)         IF(.NOT.ISTAT)THEN            CALL PUT_SYSMSG(ISTAT)           GO TO 65
         ENDIF        ENDIF   H C======================================================================C C  Print the plot fileH C======================================================================C       IF(CC.EQ.'P')THENt         CLOSE(UNIT=IOUTH)          NC=LENSIG(QUEUE)         PRTOPT=' '@         IF(IDEV.EQ.4.OR.IDEV.EQ.5.OR.IDEV.EQ.11)PRTOPT='PASSALL'B         CALL QUEUE_PLOT(QUEUE(1:NC),PLOTFILE,PRTOPT,ISTAT1,ISTAT2)A         IF(.NOT.ISTAT1.OR..NOT.ISTAT2)GO TO 65      !error return  C Auxiliary port output:       ELSE IF(CC .EQ. 'A')THEN#         CALL AUX_PORT_OUTPUT(IOUTH)M       ENDIF    C Close the plot file and exit       CLOSE(UNIT=IOUTH)<       RETURN   C Error return:p8 999   WRITE(IOUTS,*)'Unable to open plot file ',PLOTFILE       CALL PUT_FORMSG 2       GO TO 65                                      	       ENDe    =       SUBROUTINE GRAPHICS_HARDCOPY_PARSE(STRING,FIELD,IFIELD)HH C======================================================================C C F C  Extracts a specified character field from a string.  Fields may be  C  delimited by blanks or tabs.t Cs
 C  Inputs:* C    STRING  character string to be parsed0 C    IFIELD  number of the field to be extracted
 C  Output:@ C    FIELD   contents of the field if it exists, otherwise blank CiH C======================================================================C          CHARACTER*(*) STRING,FIELD         CHARACTER*(*)TAB       PARAMETER(TAB=CHAR(9))         ICOUNT=0       IN_FIELD=.FALSE.         DO I=1,LEN(STRING)8         IF(STRING(I:I).EQ.' '.OR.STRING(I:I).EQ.TAB)THEN           IF(IN_FIELD)THEN$             IF(ICOUNT.EQ.IFIELD)THEN&               FIELD=STRING(ISTART:I-1)               RETURN             ENDIFl             IN_FIELD=.FALSE.           ENDIFa         ELSE           IF(.NOT.IN_FIELD)THEN              ICOUNT=ICOUNT+1k             IN_FIELD=.TRUE.t             ISTART=I           ENDIFu
         ENDIFC       ENDDO   +       IF(IN_FIELD.AND.ICOUNT.EQ.IFIELD)THEN (         FIELD=STRING(ISTART:LEN(STRING))
       ELSE         FIELD=' '        ENDIF          RETURN	       END 