8       SUBROUTINE HARDCOPY_RANGE(XMINH,XMAXH,YMINH,YMAXH,G      *                          XMINHP,XMAXHP,YMINHP,YMAXHP,IORIENTH,*) H C======================================================================CH C                                                                      CH C  HARDCOPY_RANGE performs a windowing transformation of the world     CH C  coordinate system (user units) to a viewport on the internal        CH C  (hardcopy, printronix) bit map.  It also updates the                CH C  PLOT-to-MONITOR and MONITOR-to-PLOT transformations, but NOT the    CH C  PLOT-to-MONITOR2 and MONITOR2-to-PLOT transformations.  Thus, if    CH C  a second monitor (MONITOR2) is being used for graphics display, be  CH C  sure to call MONITOR2_RANGE after calling HARDCOPY_RANGE !          CH C                                                                      CH C  More specifically, HARDCOPY_RANGE defines the range of the hardcopy CH C  viewport:                                                           CH C      XMINH <= XH <= XMAXH; YMINH <= YH <= YMAXH (dots)               CH C  within the printronix page in dots:                                 CH C      0 <= XH <= 2047 (vertical); 0 <= YH <= 785 (horizontal)         CH C  (The origin of the printronix page (XH,YH) = (0,0) is in the upper  CH C  left hand corner of the page).  It also defines the plot coordinate CH C  range (the window) that is mapped into the hardcopy viewport:       CH C       XMINHP <= X <= XMAXHP; YMINHP <= Y <= YMAXHP,                  CH C  as well as the orientation of the plot on the hardcopy page given   CH C  by IORIENTH:                                                        CH C            IORIENTH =  1: X is vertical; Y is horizontal;            CH C                           (XMINHP,YMINHP) appears in the             CH C                           upper left hand corner of the              CH C                           hardcopy viewport.                         CH C                     =  0: no hardcopy will be plotted in the         CH C                           hardcopy bitmap, although the above        CH C                           ranges will still be set and used          CH C                           for plotting on the monitor.               CH C                     = -1: X is horizontal; Y is vertical;            CH C                           (XMINHP,YMINHP) appears in the             CH C                           lower left hand corner of the              CH C                           hardcopy viewport.                         CH C                                                                      CH C  The values of XMINH,XMAXH,YMINH,YMAXH are restricted to the range   CH C  of the printronix page in dots:                                     CH C       0 <= XH <= 2047; 0 <= YH <= 785.                               CH C  If they fall outside this range they will be set to the nearest     CH C  limit.  The values of XMINHP,XMAXHP,YMINHP,YMAXHP are not           CH C  restricted.  If any of the sides of the "HARDCOPY" viewport or "PLOT"H C  window are equal to 0 (eg. XMINH=XMAXH), then an error message is   CH C  printed on unit 6 and a RETURN1 is performed.                       CH C                                                                      CH C       Note: Within the plot package there are 4 distinct             CH C             coordinate systems used:                                 CH C                                                                      CH C  First, there is the "HARDCOPY" coordinate system "(XH,YH)" with:    CH C             0 <= XH <= 2047 (vertical on the printronix)             CH C             0 <= YH <= 785  (horizontal on the printronix).          CH C  This coordinate system never changes and its units are printronix   CH C  dots.                                                               CH C                                                                      CH C  Second, there is the user defined "PLOT" coordinate system "(X,Y)"  CH C  with                                                                CH C             XMINHP <= X <= XMAXHP; YMINHP <= Y <= YMAXHP             CH C                                                                      CH C  Third, there is the "MONITOR" coordinate system "(XM,YM)" with      CH C             0 <= XM <= XMAXMSIZE (horizontal on the screen)          CH C             0 <= YM <= YMAXMSIZE (vertical on the screen).           CH C  This coordinate system is fixed for each type of monitor and its    CH C  units are monitor dots.                                             CH C                                                                      CH C  Fourth, there is the "MONITOR2" coordinate system defined           CH C  analogously to the MONITOR coordinates.                             CH C                                                                      CH C  The following coordinate transformations tie the first three        CH C  coordinate systems together:                                        CH C                                                                      CH C             /PLOT_TO_HARDCOPY/ RMATRIXHP(2,2),SHIFTHP(2)             CH C             |XH|               |X|                                   CH C             |  | = RMATRIXHP * | | + SHIFTHP                         CH C             |YH|               |Y|                                   CH C                                                                      CH C             /PLOT_TO_MONITOR/  RMATRIXMP(2,2),SHIFTMP(2)             CH C             |XM|               |X|                                   CH C             |  | = RMATRIXMP * | | + SHIFTMP                         CH C             |YM|               |Y|                                   CH C                                                                      CH C             /MONITOR_TO_PLOT/  RMATRIXPM(2,2),SHIFTPM(2)             CH C             |X|               |XM|                                   CH C             | | = RMATRIXPM * |  | + SHIFTPM                         CH C             |Y|               |YM|                                   CH C                                                                      CH C             /HARDCOPY_TO_MONITOR/  RMATRIXMH(2,2),SHIFTMH(2)         CH C             |XM|               |XH|                                  CH C             |  | = RMATRIXMH * |  | + SHIFTMH                        CH C             |YM|               |YH|                                  CH C                                                                      CH C   Written by Arthur Haynes, TRIUMF U.B.C., July 14, 1982.            CH C                                                                      CH C   Input  Parameters: XMINH,XMAXH,YMINH,YMAXH,XMINHP,XMAXHP,          CH C                      YMINHP,YMAXHP (R*4); IORIENTH (I*4).            CH C                                                                      CH C   If HARDCOPY_RANGE is never called these parameters default         CH C   to the following values:                                           CH C   0=XMINH <= XH <= XMAXH=479; 0=YMINH <= YH <= YMAXH=639;            CH C   0=XMINHP <= X <= XMAXHP=639; 0=YMINHP <= Y <= YMAXHP=479;          CH C   IORIENTH = -1.                                                     CH C                                                                      CH C   Modified Jan 19/88 by F.W. Jones:  The internal bitmap is now      CH C   stored with eight significant bits per byte instead of six, so     CH C   the maximum dimensions of the bitmap have been increased to        CH C   1504 x 2047.                                                       CH C                                                                      CH C======================================================================CG       COMMON /HARDCOPY_RANGE/ XMINHP2,XMAXHP2,YMINHP2,YMAXHP2,IORIENTH2 ;       DATA XMINHP2,XMAXHP2,YMINHP2,YMAXHP2/0.,639.,0.,479./        DATA IORIENTH2/-1/:       COMMON /HARDCOPY_RANGE2/ XMINH2,XMAXH2,YMINH2,YMAXH27       DATA XMINH2,XMAXH2,YMINH2,YMAXH2/0.,479.,0.,639./ E       COMMON /MONITOR_RANGE/ XMINMP,XMAXMP,YMINMP,YMAXMP,XMINM,XMAXM, (      *                       YMINM,YMAXM7       DATA XMINMP,XMAXMP,YMINMP,YMAXMP/0.,639.,0.,479./ 3       DATA XMINM,XMAXM,YMINM,YMAXM/0.,639.,0.,479./ C       COMMON /MONITOR_SIZE/ XMINMSIZE,XMAXMSIZE,YMINMSIZE,YMAXMSIZE C       DATA XMINMSIZE,XMAXMSIZE,YMINMSIZE,YMAXMSIZE/0.,639.,0.,479./ 8       COMMON /PLOT_TO_MONITOR/ RMATRIXMP(2,2),SHIFTMP(2)0       DATA RMATRIXMP/1.,0.,0.,1./,SHIFTMP/0.,0./8       COMMON /MONITOR_TO_PLOT/ RMATRIXPM(2,2),SHIFTPM(2)0       DATA RMATRIXPM/1.,0.,0.,1./,SHIFTPM/0.,0./<       COMMON /HARDCOPY_TO_MONITOR/ RMATRIXMH(2,2),SHIFTMH(2)3       DATA RMATRIXMH/0.,-1.,1.,0./,SHIFTMH/0.,479./ 9       COMMON /PLOT_TO_HARDCOPY/ RMATRIXHP(2,2),SHIFTHP(2) 3       DATA RMATRIXHP/0.,1.,-1.,0./,SHIFTHP/479.,0./ 6       COMMON /CALL_MONITOR_RANGE/ MONITOR_RANGE_CALLED+       LOGICAL MONITOR_RANGE_CALLED/.FALSE./  C 0       COMMON/BITMAP_STATUS/BITMAP_EMPTY,MAXLINES"       LOGICAL BITMAP_EMPTY/.TRUE./       INTEGER MAXLINES/480/  C C       COMMON/GRAPHICS_BITMAP/HPAINT,NBYTES,IOFFSET,NXDIM,NYDIM,MAXY        LOGICAL*1 HPAINT(1) !       COMMON /BITMAP_DEVICE/ IBIT        DATA IBIT /0/  C E       DATA XMINHSIZE,XMAXHSIZE,YMINHSIZE,YMAXHSIZE/0.,2047.,0.,1504./  C C C================================================================== C C==   Make sure that the hardcopy viewport is within the bitmap  == C C==   dimensions.                                                == C C==================================================================        IF( IBIT .NE. 5 )THENN2         XMINH2=MAX(MIN(XMINH,XMAXHSIZE),XMINHSIZE)2         XMAXH2=MAX(MIN(XMAXH,XMAXHSIZE),XMINHSIZE)2         YMINH2=MAX(MIN(YMINH,YMAXHSIZE),YMINHSIZE)2         YMAXH2=MAX(MIN(YMAXH,YMAXHSIZE),YMINHSIZE):       ELSE IF( IBIT .EQ. 5 )THEN             ! HP PaintJetA         XMINH2=MAX(MIN(XMINH,9899.),0.)   ! 9900=180dpi*11in*5pgst'         XMAXH2=MAX(MIN(XMAXH,9899.),0.)r?         YMINH2=MAX(MIN(YMINH,1439.),0.)   ! 1440=180dpi*8in*1pg '         YMAXH2=MAX(MIN(YMAXH,1439.),0.)a( C Find array dimensions NXDIM and NYDIM:=         NXMAX=NINT(MAX(XMINH2,XMAXH2))+1     !#dots down paget?         NYMAX=NINT(MAX(YMINH2,YMAXH2))+1     !#dots across paged:         NYDIM=NXMAX*3                        !usually 54009         NXDIM=NYMAX/8                        !usually 180 *         IF(MOD(NYMAX,8).NE.0)NXDIM=NXDIM+1       ENDIF  CMC C================================================================== C C==   Make sure that none of the sides of the viewport and       == C C==   window are 0.                                              == C C==================================================================        IF(XMINH2.EQ.XMAXH2)THEN          WRITE(6,1)HA 1        FORMAT(' ***Error*** in HARDCOPY_RANGE: XMINH = XMAXH.')g          RETURN1       END IF       IF(YMINH2.EQ.YMAXH2)THEN          WRITE(6,2)nA 2        FORMAT(' ***Error*** in HARDCOPY_RANGE: YMINH = YMAXH.')           RETURN1       END IF       IF(XMINHP.EQ.XMAXHP)THEN          WRITE(6,3) C 3        FORMAT(' ***Error*** in HARDCOPY_RANGE: XMINHP = XMAXHP.')           RETURN1       END IF       IF(YMINHP.EQ.YMAXHP)THEN          WRITE(6,4) C 4        FORMAT(' ***Error*** in HARDCOPY_RANGE: YMINHP = YMAXHP.')           RETURN1       END IF       XMINHP2=XMINHP       XMAXHP2=XMAXHP       YMINHP2=YMINHP       YMAXHP2=YMAXHP       IORIENTH2=IORIENTH7       IF(IORIENTH2.NE.0.AND.IORIENTH2.NE.-1)IORIENTH2=1 < C Record maximum number of lines in bitmap since last clear:*       MAXLINES=MAX(MAXLINES,INT(XMAXH2)+1)  B C=================================================================B C==   Calculate the "PLOT" to "HARDCOPY" transformation.        ==B C==                                                             ==B C==   FOR IORIENTH = 1:                                         ==B C==   XH = (X-XMINHP)/(XMAXHP-XMINHP)*(XMAXH-XMINH)+XMINH       ==B C==      = RMATRIXHP(1,1)*X+RMATRIXHP(1,2)*Y+SHIFTHP(1).        ==B C==   YH = (Y-YMINHP)/(YMAXHP-YMINHP)*(YMAXH-YMINH)+YMINH       ==B C==      = RMATRIXHP(2,1)*X+RMATRIXHP(2,2)*Y+SHIFTHP(2).        ==B C==                                                             ==B C==   FOR IORIENTH = -1:                                        ==B C==   XH = XMAXH-(Y-YMINHP)/(YMAXHP-YMINHP)*(XMAXH-XMINH)       ==B C==      = RMATRIXHP(1,1)*X+RMATRIXHP(1,2)*Y+SHIFTHP(1).        ==B C==   YH = (X-XMINHP)/(XMAXHP-XMINHP)*(YMAXH-YMINH)+YMINH       ==B C==      = RMATRIXHP(2,1)*X+RMATRIXHP(2,2)*Y+SHIFTHP(2).        ==B C=================================================================!       IF(IORIENTH2.EQ.-1)GO TO 10 6       RMATRIXHP(1,1)=(XMAXH2-XMINH2)/(XMAXHP2-XMINHP2)       RMATRIXHP(1,2)=0.        RMATRIXHP(2,1)=0. 6       RMATRIXHP(2,2)=(YMAXH2-YMINH2)/(YMAXHP2-YMINHP2).       SHIFTHP(1)=XMINH2-XMINHP2*RMATRIXHP(1,1).       SHIFTHP(2)=YMINH2-YMINHP2*RMATRIXHP(2,2)       GO TO 20 10    RMATRIXHP(1,1)=0. 7       RMATRIXHP(1,2)=-(XMAXH2-XMINH2)/(YMAXHP2-YMINHP2) 6       RMATRIXHP(2,1)=(YMAXH2-YMINH2)/(XMAXHP2-XMINHP2)       RMATRIXHP(2,2)=0. .       SHIFTHP(1)=XMAXH2-YMINHP2*RMATRIXHP(1,2).       SHIFTHP(2)=YMINH2-XMINHP2*RMATRIXHP(2,1)& 20    IF(MONITOR_RANGE_CALLED)GO TO 40B C=================================================================B C==   The MONITOR_RANGE subroutine has never been called.       ==B C==   Hence the monitor should display the whole range of the   ==B C==   hardcopy viewport specified by HARDCOPY_RANGE.            ==B C==   Therefore the default values of the transformation matrix ==B C==   RMATRIXMH and the translation vector SHIFTMH must be      ==B C==   changed in order to accomplish this.                      ==B C==                                                             ==B C==   Calculate the "HARDCOPY" to "MONITOR" transformation.     ==B C==                                                             ==B C==   FOR IORIENTH = IORIENTM = 1:                              ==B C==   XM = (XH-XMINH)/(XMAXH-XMINH)*(XMAXM-XMINM)+XMINM         ==B C==      = RMATRIXMH(1,1)*XH+RMATRIXMH(1,2)*YH+SHIFTMH(1).      ==B C==   YM = (YH-YMINH)/(YMAXH-YMINH)*(YMAXM-YMINM)+YMINM         ==B C==      = RMATRIXMH(2,1)*XH+RMATRIXMH(2,2)*YH+SHIFTMH(2).      ==B C==                                                             ==B C==   FOR IORIENTH = IORIENTM = -1:                             ==B C==   XM = (YH-YMINH)/(YMAXH-YMINH)*(XMAXM-XMINM)+XMINM         ==B C==      = RMATRIXMH(1,1)*XH+RMATRIXMH(1,2)*YH+SHIFTMH(1).      ==B C==   YM = YMAXM-(XH-XMINH)/(XMAXH-XMINH)*(YMAXM-YMINM)         ==B C==        RMATRIXMH(2,1)*XH+RMATRIXMH(2,2)*YH+SHIFTMH(2).      ==B C=================================================================!       IF(IORIENTH2.EQ.-1)GO TO 30 2       RMATRIXMH(1,1)=(XMAXM-XMINM)/(XMAXH2-XMINH2)       RMATRIXMH(1,2)=0.        RMATRIXMH(2,1)=0. 2       RMATRIXMH(2,2)=(YMAXM-YMINM)/(YMAXH2-YMINH2),       SHIFTMH(1)=XMINM-RMATRIXMH(1,1)*XMINH2,       SHIFTMH(2)=YMINM-RMATRIXMH(2,2)*YMINH2       GO TO 40 30    RMATRIXMH(1,1)=0. 3       RMATRIXMH(1,2)= (XMAXM-XMINM)/(YMAXH2-YMINH2) 3       RMATRIXMH(2,1)=-(YMAXM-YMINM)/(XMAXH2-XMINH2)        RMATRIXMH(2,2)=0. ,       SHIFTMH(1)=XMINM-RMATRIXMH(1,2)*YMINH2,       SHIFTMH(2)=YMAXM-RMATRIXMH(2,1)*XMINH2B C=================================================================B C==   Calculate the transformation matrix RMATRIXMP from the    ==B C==   "PLOT" coordinate system to the "MONITOR" coordinate      ==B C==   system:                                                   ==B C==                                                             ==B C==   RMATRIXMP      = RMATRIXMH          * RMATRIXHP           ==B C==                                                             ==B C==   MONITOR<--PLOT = MONITOR<--HARDCOPY * HARDCOPY<--PLOT     ==B C=================================================================3 40    RMATRIXMP(1,1)=RMATRIXMH(1,1)*RMATRIXHP(1,1)+ 2      *               RMATRIXMH(1,2)*RMATRIXHP(2,1)3       RMATRIXMP(1,2)=RMATRIXMH(1,1)*RMATRIXHP(1,2)+ 2      *               RMATRIXMH(1,2)*RMATRIXHP(2,2)3       RMATRIXMP(2,1)=RMATRIXMH(2,1)*RMATRIXHP(1,1)+ 2      *               RMATRIXMH(2,2)*RMATRIXHP(2,1)3       RMATRIXMP(2,2)=RMATRIXMH(2,1)*RMATRIXHP(1,2)+ 2      *               RMATRIXMH(2,2)*RMATRIXHP(2,2)B C=================================================================B C==   Calculate the translation vector SHIFTMP from the "PLOT"  ==B C==   coordinate system to the "MONITOR" coordinate system.     ==B C==                                                             ==B C==   SHIFTMP = RMATRIXMH * SHIFTHP + SHIFTMH                   ==B C=================================================================E       SHIFTMP(1)=RMATRIXMH(1,1)*SHIFTHP(1)+RMATRIXMH(1,2)*SHIFTHP(2)+       *           SHIFTMH(1) E       SHIFTMP(2)=RMATRIXMH(2,1)*SHIFTHP(1)+RMATRIXMH(2,2)*SHIFTHP(2)+       *           SHIFTMH(2) B C=================================================================B C==   Calculate the inverse transformation matrix RMATRIXPM from==B C==   the "MONITOR" coordinate system to the "PLOT" coordinate  ==B C==   system:                                                   ==B C==                                                             ==B C==   RMATRIXPM      = RMATRIXMP**-1                            ==B C==                                                             ==B C==   PLOT<--MONITOR = (MONITOR<--PLOT)**-1                     ==B C=================================================================G       DETMP=RMATRIXMP(1,1)*RMATRIXMP(2,2)-RMATRIXMP(2,1)*RMATRIXMP(1,2) )       RMATRIXPM(1,1)=RMATRIXMP(2,2)/DETMP *       RMATRIXPM(1,2)=-RMATRIXMP(1,2)/DETMP*       RMATRIXPM(2,1)=-RMATRIXMP(2,1)/DETMP)       RMATRIXPM(2,2)=RMATRIXMP(1,1)/DETMPcB C=================================================================B C==   Calculate the inverse translation vector SHIFTPM from the ==B C==   "MONITOR" coordinate system to the "PLOT" coordinate      ==B C==   system.                                                   ==B C==                                                             ==B C==   SHIFTPM = -RMATRIXPM * SHIFTMP                            ==B C=================================================================E       SHIFTPM(1)=-RMATRIXPM(1,1)*SHIFTMP(1)-RMATRIXPM(1,2)*SHIFTMP(2) E       SHIFTPM(2)=-RMATRIXPM(2,1)*SHIFTMP(1)-RMATRIXPM(2,2)*SHIFTMP(2)NB C=================================================================B C==   Calculate the boundaries in the "PLOT" coordinate system  ==B C==   corresponding to the monitor viewport.                    ==B C==   Expand these boundaries by 1/1000000 of their original    ==B C==   dimensions in order to avoid round off problems when one  ==B C==   plots right on the boundaries.                            ==B C=================================================================B       XMINMP2=RMATRIXPM(1,1)*XMINM+RMATRIXPM(1,2)*YMINM+SHIFTPM(1)B       YMINMP2=RMATRIXPM(2,1)*XMINM+RMATRIXPM(2,2)*YMINM+SHIFTPM(2)B       XMAXMP2=RMATRIXPM(1,1)*XMAXM+RMATRIXPM(1,2)*YMAXM+SHIFTPM(1)B       YMAXMP2=RMATRIXPM(2,1)*XMAXM+RMATRIXPM(2,2)*YMAXM+SHIFTPM(2).       XMINMP=XMINMP2-.000001*(XMAXMP2-XMINMP2).       XMAXMP=XMAXMP2+.000001*(XMAXMP2-XMINMP2).       YMINMP=YMINMP2-.000001*(YMAXMP2-YMINMP2).       YMAXMP=YMAXMP2+.000001*(YMAXMP2-YMINMP2)       RETURN	       END=