9       SUBROUTINE HINTER(IMODE,NIN,NOUT,XIN,XOUT,YIN,YOUT,       # MBCLO,BCLO,MBCHI,BCHI) A C================================================================ A C==   HINTER IS A NUMERICAL INTERPOLATION, DIFFERENTIATION OR  == A C== INTEGRATION ROUTINE THAT USES A CUBIC HERMITIAN POLYNOMIAL == A C== AS ITS INTERPOLATING FUNCTION. THIS IS A PIECEWISE CONTINUOUS A C== AND DIFFERENTIABLE (ONCE, BUT NOT TWICE) POLYNOMIAL DEFINED== A C== ON EACH INTERVAL X(I) TO X(I-1) BY THE REQUIREMENT THAT IT == A C== INTERPOLATE THE FUNCTION VALUES F(I) AND F(I+1) AT X(I) AND== A C== X(I+1), AS WELL AS THE SPECIFIED SLOPES S(I) AND S(I+1) AT == A C== AT THESE NODES. THESE SLOPES S(I) = F'(I) ARE CALCULATED   == A C== USING THE STANDARD 3-PT. 1ST DERIVATIVE DIFFERENCE         == A C== INVOLVING F(I-1), F(I) AND F(I+1) -- A SCHEME WHICH IS     == A C== SOMETIMES REFERRED TO AS CUBIC BESSEL INTERPOLATION. THE   == A C== SLOPES AT THE END-POINTS PRESENT A SPECIAL CASE WHICH MUST == A C== BE HANDLED BY IMPOSING BOUNDARY CONDITIONS AT X(1) AND     == A C== X(NIN). THESE CAN BE EITHER 1ST DERIVATIVE CONDITIONS (IN  == A C== WHICH CASE THE ENDPOINT SLOPE IS OBTAINED DIRECTLY) OR A   == A C== 2ND DERIVATIVE CONDITION (IN WHICH CASE THE SLOPE CAN BE   == A C== EXPRESSED IN TERMS OF THIS 2ND DERIV. AND THE ADJACENT     == A C== FUNCTION VALUES AND SLOPES.                                == A C==   THE INTERPOLATION DESCRIBED HERE DIFFERS FROM A SPLINE IN== A C== THAT IT IS A LOCAL METHOD, WITH THE INTERPOLATED VALUE IN A== A C== PARTICULAR VALUE DEPENDING DIRECTLY ONLY ON THE IMMEDIATELY== A C== ADJACENT 2 POINTS, AND INDIRECTLY, THROUGH THE SLOPE       == A C== CALCULATION ON THE NEAREST 4 POINTS. THIS IS QUITE DISTINCT== A C== FROM A SPLINE TECHNIQUE IN WHICH THE INTERPOLATING POLY-   == A C== NOMIAL OBTAINED DEPENDS GLOBALLY ON ALL THE POINTS IN THE  == A C== SAMPLE. THE HERMITIAN TECHNIQUE HAS AN ADVANTAGE OVER SPLINE= A C== INTERPOLATION IN THAT THE RESULTING INTERPOLATING FUNCTION == A C== GENERALLY HAS MUCH LESS RIPPLE (OR SPURIOUS OSCILLATION)   ==IB C== PRESENT THAN DOES THE CORRESPONDING SPLINE SOLUTION. THE   == A C== PRICE THAT IS PAID FOR THIS IS THE LOSS OF THE C2 (TWICE   ===A C== DIFFERENTIABLE ) PROPERTY OF THE CUBIC SPLINE. THESE CUBIC ==NA C== HERMITIAN POLYNOMIALS ARE ONLY ONCE DIFFERENTIABLE.        ==OA C==                                                            ==NA C== SUBROUTINE PARAMETERS:                                     ==EA C==  IMODE: = -1  FOR INTEGRATION                              ==AA C==         =  0  FOR INTERPOLATION                            ==IA C==         =  1  FOR DIFFERENTIATION                          ==1A C==  NIN: NUMBER OF INPUT POINTS                               ==TA C==  NOUT: NUMBER OF OUTPUT POINTS (VALUES TO BE INTERPOLATED) == A C==  XIN: ARRAY OF POSITIONS OF EXISTING DATA POINTS           ==SA C==  XOUT: ARRAY OF POSITIONS OF DESIRED INTERPOLATED DATA VALUESTA C==  YIN: ARRAY OF EXISTING DATA VALUES                        == A C==  YOUT: ARRAY OF DESIRED INTERPOLATED DATA VALUES (RETURNED)==DA C==  MBCLO: INDICATES THE TYPE OF BOUNDARY CONDITION TO BE     == A C==         APPLIED AT THE LOWER ENDPOINT (N=1). IF MCBLO = 1, ==RA C==         BCLO IS TAKEN TO BE THE VALUE OF THE 1ST DERIVATIVE== A C==         (SLOPE) AT THIS BOUNDARY. IF MCBLO = 2, THEN BCLO IS=TA C==         TAKEN TO BE THE VALUE OF THE 2ND DERIVATIVE HERE.  == A C==  BCLO: THE VALUE OF THE LOWER ENDPOINT BOUNDARY CONDITION. ==IA C==  MCBHI: THE ANALOGOUS FLAG TO INDICATE THE NATURE OF THE   ==EA C==         UPPER ENDPOINT (N=NIN) BOUNDARY CONDITION.         ==IA C==  BCHI: THE VALUE OF THE UPPER ENDPOINT BOUNDARY CONDITION. == A C================================================================S       IMPLICIT REAL*8 (A-H,O-Z)I       LOGICAL INIT/.TRUE./5       REAL*8 XIN(NIN),YIN(NIN),XOUT(NOUT),YOUT(NOUT),       # H(100),SLP(100),CON(100)AA C================================================================NA C== DEFINE THE HERMITIAN BASIS FUNCTIONS AS STATEMENT FUNCTIONS==EA C==                                                            ==RA C== PHI0, PHI1, PHI2 REFER TO THE DERIVATIVE, THE INTERPOLATED ==RA C== FUNCTION AND THE INTEGRAL BASIS FUNCTIONS RESPECTIVELY, AND==IA C== THE OTHER SET OF BASIS FUNCTIONS PSI0, PSI1, PSI2 ARE      ==EA C== DEFINED ANALOGOUSLY.                                       == A C================================================================UA C== THE FOLLOWING DEFINE THE DIFFERENTIATED BASIS FUNCTIONS    ==IA C== PHI0 AND PSI0 AT THE LOWER AND UPPER ENDS (PHI10, PHI20 AND== A C== PSI10, PSI20 RESPECTIVELY) OF THE CURRENT INTERVAL.        == A C================================================================N(       PHI13(Z,HH)= -6.D0*Z*(1.D0 - Z)/HH(       PHI23(Z,HH)=  6.D0*Z*(1.D0 - Z)/HH,       PSI13(Z,HH)= (3.D0*Z - 4.D0)*Z + 1.D0 $       PSI23(Z,HH)= Z*(3.D0*Z - 2.D0)A C================================================================RA C== THE FOLLOWING STATEMENTS DEFINE THE BASIS FUNCTIONS PHI1 AND=EA C== PSI1 AT BOTH ENDS OF THE INTERVAL (PHI11 AT LOWER END,     ==TA C== PHI21 AT UPPER, AND ANALOGOUSLY FOR PSI).                  ==NA C================================================================O.       PHI12(Z,HH)= 1.D0 - (3.D0 - 2.D0*Z)*Z*Z &       PHI22(Z,HH)= (3.D0 - 2.D0*Z)*Z*Z%       PSI12(Z,HH)= HH*Z*(1.D0 - Z)**2O%       PSI22(Z,HH)= -HH*Z*Z*(1.D0 - Z)=A C=================================================================A C== THE FOLLOWING DEFINE THE INTEGRATED BASIS FUNCTIONS PHI2 AND==B C== PSI2 AT THE LOWER AND UPPER END (PHI12 AND PHI22 ) OF THE  == A C== INTERVAL, AND SIMILARLY FOR PSI.                           ===A C=================================================================4       PHI11(Z,HH)= HH*((Z/2.D0 - 1.D0)*Z*Z + 1.D0)*Z,       PHI21(Z,HH)= HH*(1.D0 - Z/2.D0)*Z*Z*Z A       PSI11(Z,HH)= HH*HH*((Z/4.D0 - 2.D0/3.D0)*Z + 1.D0/2.D0)*Z*ZT3       PSI21(Z,HH)= HH*HH*(Z/4.D0 - 1.D0/3.D0)*Z*Z*Z=A C================================================================ A C== MAKE INITIAL PASS THROUGH INPUT ARRAY TO CALCULATE SLOPES  == A C================================================================        INIT= .FALSE.R       NINM= NIN-1        H(1)= XIN(2) - XIN(1)C       DO 5 I=2,NINM        H(I)= XIN(I+1) - XIN(I)N%       P= -H(I)/H(I-1)/(H(I) + H(I-1))O$       Q= (H(I) - H(I-1))/H(I)/H(I-1)$       R= H(I-1)/H(I)/(H(I) + H(I-1))0       SLP(I)= P*YIN(I-1) + Q*YIN(I) + R*YIN(I+1)     5 CONTINUE!       IF(MBCLO.LE.1) SLP(1)= BCLO 9       IF(MBCLO.GE.2) SLP(1)= 3.D0*( YIN(2) - YIN(1))/H(1) %      # - 2.D0*SLP(2) - H(1)*BCLO/2.D0R#       IF(MBCHI.LE.1) SLP(NIN)= BCHI,D       IF(MBCHI.GE.2) SLP(NIN)= 3.D0*(YIN(NIN) - YIN(NIN-1))/H(NIN-1)-      # - 2.D0*SLP(NIN-1) + H(NIN-1)*BCHI/2.D0=A C=================================================================A C== ANOTHER LOOP TO CALCULATE THE INTEGRATION CONSTANTS NEEDED == A C== FOR EACH INTERVAL TO EVALUATE THE INTEGRATED FUNCTION.     ===A C================================================================S       CON(1)= 0.0D0C       DO 6 I=2,NIN8       CON(I)= CON(I-1) + (YIN(I-1) + YIN(I))*H(I-1)/2.D02      #      + (SLP(I-1) - SLP(I))*H(I-1)**2/12.D0      6 CONTINUE       GOTO 8A C================================================================ A C== ENTRY HINT ALLOWS SUCCESSIVE CALLS WITH DIFFERING OUTPUT   ==-A C== ARRAYS OR IMODE VALUES ON THE SAME INPUT DATA. A RETURN 1  ==,A C== RESULTS IF HINTER HAS NOT BEEN CALLED PREVIOUSLY.          ===A C================================================================A(       ENTRY HINT(IMODE,NOUT,XOUT,YOUT,*)       IF(INIT) RETURN 12A C================================================================ A C== MAIN LOOP OVER OUTPUT POINTS. THIS ASSUMES MONOTONICITY OF ===A C== BOTH THE INPUT AND OUTPUT ARRAYS AND IN THE SAME SENSE     ==ZA C== (IE. BOTH INCREASING OR BOTH DECREASING). THE INTERVAL ON  ==1A C== INPUT GRID CONTAINING THE CURRENT OUTPUT POINT IS FOUND, AND=2A C== THIS INTERVAL IS STEPPED THROUGH THE INPUT ARRAY AS THE LOOP==A C== RUNS OVER THE OUTPUT POINTS. THIS APPROACH REQUIRES ONLY A ==HA C== SINGLE PASS (LOOP) OVER THE INPUT AND OUTPUT ARRAYS, BUT   ===A C== IT DOES ASSUME THE ABOVE MONOTONICITY REQUIREMENT.         == A C================================================================      8 JINT=1       DO 10 I=1,NOUT       X=XOUT(I)1       IF(JINT.GT.NIN) GOTO 35(       DO 20 J=JINT,NIN       IF(X.LE.XIN(J)) GOTO 30H    20 CONTINUE       JINT= NIN+1Q
       GOTO 35(A C================================================================MA C== INTERPOLATE DATA ON INTERVAL X(JINT-1) TO X(JINT).         ==(A C== IPOS IS A FLAG DESCRIBING THE POSITION OF THE OUTPUT POINT ==FA C== RELATIVE TO THE INPUT ARRAY.                               ==#A C==                                                            ===A C==   IPOS      SITUATION             INTERPOLATING POLYNOMIAL ==LA C==                                                            ==EA C==    1      XOUT(I) < XIN(1)          LINEAR EXTRAPOLATION   ===A C==    2   XIN(1) < XOUT(I) < XIN(NIN)  CUBIC HERMITE INTERPOL.== A C==    3      XOUT(I) > XIN(NIN)        LINEAR EXTRAPOLATION   ==/A C================================================================T    30 IPOS=2
       JINT= J=    35 IF(JINT.EQ.1) IPOS=1        IF(JINT.EQ.(NIN+1)) IPOS=3       IF(IPOS.NE.2) GOTO 38C       JM= JINT-1       HJ=H(JM)        XI= (XOUT(I) - XIN(JM))/HJ    38 IBR= IMODE+2       GOTO (40,50,60),IBRFA C=================================================================A C== IMODE=1: THE VALUE OF THE INTEGRATED FUNCTION IS FOUND     ==IA C=================================================================    40 GOTO (41,42,43),IPOS)    41 YOUT(I)= YIN(1)*( XOUT(I) - XIN(1))R<      #       + SLP(1)*( XOUT(I) - XIN(1))**2/2.D0 + CON(1)         GOTO 10 <    42 YOUT(I)= YIN(JM)*PHI11(XI,HJ) + YIN(JINT)*PHI21(XI,HJ)A      #  + SLP(JM)*PSI11(XI,HJ) + SLP(JINT)*PSI21(XI,HJ) + CON(JM)N
       GOTO 10 -    43 YOUT(I)= YIN(NIN)*( XOUT(I) - XIN(NIN)) @      #       + SLP(NIN)*( XOUT(I) - XIN(NIN))**2/2.D0 + CON(NIN)
       GOTO 10.A C================================================================ A C== IMODE=2: THE VALUE OF THE INTERPOLATED FUNCTION IS FOUND   ==NA C=================================================================    50 GOTO (51,52,53),IPOS1    51 YOUT(I)= YIN(1) + SLP(1)*(XOUT(I) - XIN(1))=
       GOTO 10 <    52 YOUT(I)= YIN(JM)*PHI12(XI,HJ) + YIN(JINT)*PHI22(XI,HJ)<      #       + SLP(JM)*PSI12(XI,HJ) + SLP(JINT)*PSI22(XI,HJ)
       GOTO 10=7    53 YOUT(I)= YIN(NIN) + SLP(NIN)*(XOUT(I) - XIN(NIN))=
       GOTO 10LA C================================================================ A C== IMODE=3: THE VALUE OF THE DIFFERENTIATED FUNCTION IS FOUND ==EA C================================================================     60 GOTO (61,62,63),IPOS    61 YOUT(I)= SLP(1)=
       GOTO 10 <    62 YOUT(I)= YIN(JM)*PHI13(XI,HJ) + YIN(JINT)*PHI23(XI,HJ)<      #       + SLP(JM)*PSI13(XI,HJ) + SLP(JINT)*PSI23(XI,HJ)
       GOTO 10O    63 YOUT(I)= SLP(NIN)I    10 CONTINUE       RETURN	       END1