>       SUBROUTINE HISTP(X,Y,NX,XLAB,NXLAB,YLAB,NYLAB,XFMT,YFMT,A      *                 TITLE,NTITLE,YLOW,YINC,NLINES,NWIDTH,IOUT, 7      *                 IEMPTY,SVAL,NVAL,DIGITS,NDIGS,*)  C  C     LIBRARY-ROUTINE  C < C                                                06/AUG/1980> C                                                C.J. KOST SIN C   @ C     reqd. KOSTL: routines - DTB,EQUC,FINDST,MOVEC,RICON,SCALE2 C A C================================================================ A C================================================================ A C==                                                            == A C==   HISTP: HISTOGRAMS THE NX BIN COUNTS "Y" (VERTICAL AXIS)  == A C==   AGAINST THE BIN VALUES "X" (HORIZONTAL AXIS).            == A C==                                                            == A C==   WRITTEN BY ARTHUR HAYNES, TRIUMF U.B.C., NOV. 17, 1978.  == A C==                                                            == A C==   INPUT  PARAMETERS:                                       == A C==   X(NX),Y(NY),YLOW,YINC,SVAL(NVAL) (R*4); NX,NXLAB,NYLAB,  == A C==   NTITLE,NLINES,NWIDTH,IOUT,IEMPTY,NVAL,NDIGS (I*4);       == A C==   XLAB(NXLAB),YLAB(NYLAB),XFMT,YFMT,TITLE(NTITLE),         == A C==   DIGITS(NDIGS) (L*1).                                     == A C==                                                            == A C==   OUTPUT PARAMETERS: NONE.                                 == A C==                                                            == A C==   PARAMETER DEFINITIONS:                                   == A C==   --------- -----------                                    == A C==                                                            == A C==   X     : ARRAY OF NX BIN VALUES (HORIZONTAL AXIS VALUES). == A C==           THE BIN VALUES CAN BE POSITIVE, NEGATIVE, OR ZERO== A C==           IF NX < 0, THEN |NX| POINTS ARE STORED IN "Y"    == A C==           AND X(I) IS ASSUMED TO BE AN EQUAL SPACED ARRAY  == A C==           WITH VALUES GIVEN BY: X(I) = X(1)+(I-1)*X(2).    == A C==           NOTE WHEN NX < 0 ONLY THE FIRST 2 ELEMENTS OF "X"== A C==           ARE USED, BUT NX VALUES OF "Y" ARE STILL USED.   == A C==           IF NX=0 THEN AN ERROR MESSAGE IS PRINTED ON UNIT6== A C==           NOTE: THERE IS NO LIMIT ON THE ARRAY SIZE: |NX|; == A C==           THE BINS WILL BE PRINTED ACROSS AS MANY PAGES AS == A C==           NECESSARY. THE MAXIMUM NUMBER OF BINS PER PAGE IS== A C==           GIVEN BY:                                        == A C==           NBINS/PAGE = NWIDTH - (1'ST Y FORMAT WIDTH) - 4. == A C==                                                            == A C==   Y     : ARRAY OF NX BIN COUNTS (VERTICAL AXIS COUNTS).   == A C==           THE BIN COUNTS CAN BE POSITIVE, NEGATIVE, OR ZERO== A C==           EACH POINT X(I),Y(I), I=1,...,NX IS PLOTTED AS   == A C==           A SINGLE VERTICAL COLUMN ON THE PRINTER PAGE.    == A C==                                                            == A C==   NX    : |NX| IS THE NUMBER OF BIN COUNTS IN "Y".         == A C==           IF NX > 0 THEN IT IS THE NUMBER OF BIN VALUES IN == A C==           "X". FOR NX < 0 SEE ABOVE UNDER "X".             == A C==                                                            == A C==   XLAB  : X-AXIS LABEL CONSISTING OF "NXLAB" CHARACTERS.   == A C==                                                            == A C==   NXLAB : NUMBER OF CHARACTERS IN "XLAB".                  == A C==                                                            == A C==   YLAB  : Y-AXIS LABEL CONSISTING OF "NYLAB" CHARACTERS.   == A C==                                                            == A C==   NYLAB : NUMBER OF CHARACTERS IN "YLAB".                  == A C==                                                            == A C==   XFMT  : FORMAT OF THE X-AXIS (HORIZONTAL) VALUES.        == A C==           EG. XFMT = '(I5)' OR '(F10.3)' OR '(E12.5)' OR   == A C==           '(G11.5)'. NOTE: THE X ARRAY IS ALWAYS ASSUMED TO== A C==           BE REAL EVEN WHEN THE FORMAT IS INTEGER FORMAT.  == A C==                                                            == A C==   YFMT  : FORMAT OF THE Y-AXIS (VERTICAL) VALUES, FOLLOWED == A C==           BY THE FORMAT OF THE Y-AXIS (VERTICAL) COUNTS,   ==IA C==           WHICH ARE PRINTED BELOW THE X-AXIS BIN VALUES.   == A C==           EG. YFMT = '(I8) ' OR '(I8)(F10.3)' OR '(G12.6) '== A C==           OR '(D12.5)(I7)'. NOTE: THE Y ARRAY IS ALWAYS    ==,A C==           ASSUMED TO BE REAL EVEN WHEN THE FORMAT IS       ===A C==           INTEGER FORMAT. IF THE 2'ND Y-FORMAT CODE IS NOT ===A C==           SPECIFIED THEN IT WILL BY DEFAULT EQUAL THE 1'ST == A C==           FORMAT CODE AND FOR THIS CASE THERE MUST BE AT   ==RA C==           LEAST ONE BLANK CHARACTER FOLLOWING THE Y-FORMAT ==)A C==           CODE.                                            == A C==           NOTE: BOTH "XFMT" & "YFMT" MUST NOT HAVE ANY     ==VA C==                 IMBEDDED BLANKS.                           == A C==                                                            == A C==   TITLE : HISTOGRAM TITLE CONSISTING OF "NTITLE" CHARACTERS.=NA C==           NOTE: THE TITLE IS PRINTED OUT STARTING AT THE   == A C==           FIRST COLUMN OF THE PAGE AND THE 1'ST CHARACTER  ==TA C==           OF "TITLE" IS TREATED AS A CARRIAGE CONTROL.     == A C==                                                            == A C==   NTITLE: THE NUMBER OF CHARACTERS IN "TITLE".             == A C==                                                            == A C==   YLOW  : LOWER LIMIT OF THE HISTOGRAM Y-AXIS (I.E. THE    == A C==           VERTICAL AXIS OF BIN COUNTS). YLOW IS ONLY USED  == A C==           IF "YINC" IS > 0. IF "YINC" IS <= 0 THEN THE     == A C==           LOWER LIMIT OF THE HISTOGRAM Y-AXIS IS CHOSEN    ==AA C==           USING AUTOMATIC SCALING.                         ==AA C==                                                            ==RA C==   YINC  : INCREMENT OF THE HISTOGRAM Y-AXIS (I.E. THE      ==SA C==           VERTICAL AXIS OF BIN COUNTS). IF "YINC" IS 0 THEN==IA C==           AUTOMATIC SCALING IS USED TO DETERMINE "YINC" AND==LA C==           AND "YLOW". IF "YINC" IS < 0 THEN AUTOMATIC      ==SA C==           SCALING IS USED TO DETERMINE "YINC" AND "YLOW",  ==IA C==           BUT IN THIS CASE IF THE AUTOMATIC INCREMENT IS   ==YA C==           LESS THAN THE MAGNITUDE OF "YINC" (|YINC|) THEN  ==MA C==           IT IS SET EQUAL TO |YINC|. EXAMPLE: IF YINC=-1   ==NA C==           THEN "HISTP" WILL SCALE AUTOMATICALLY WITH THE   == A C==           INCREMENT GREATER THAN OR EQUAL TO 1.            ==TA C==           NOTE: THE INPUT PARAMETERS "YLOW" AND "YINC" ARE == A C==           NEVER TAMPERED WITH BY HISTP.                    ==IA C==                                                            ==AA C==   NLINES: NUMBER OF LINES TO BE USED IN PLOTTING THE       == A C==           HISTOGRAM. "NLINES" MUST BE GREATER THAN OR EQUAL==NA C==           TO 2 AND IT CAN EXTEND OVER ANY NUMBER OF PAGES. == A C==           NOTE: THE MAXIMUM Y-SCALE VALUE IS GIVEN BY:     == A C==           YMAX = YLOW+NLINES*YINC, I.E. NLINES IS THE      ==BA C==           NUMBER OF HISTOGRAM INCREMENTS.                  ==.A C==                                                            == A C==   NWIDTH: WIDTH OF THE HISTOGRAM PRINT PAGE IN CHARACTERS, ==CA C==           EG. NWIDTH = 132 WILL GIVE THE FULL PRINTER PAGE.== A C==                                                            == A C==   IOUT  : OUTPUT UNIT ON WHICH THE HISTOGRAM IS PRINTED.   == A C==                                                            ==CA C==   IEMPTY: FLAG INDICATING WHETHER OR NOT TO PRINT EMPTY    == A C==           PAGES OF THE HISTOGRAM ONTO THE PRINTER. IF      == A C==           IEMPTY = 1 THEN EMPTY HISTOGRAM PAGES WILL NOT BE== A C==           PRINTED, OTHERWISE THEY WILL BE PRINTED.         ==AA C==                                                            ==(A C==   SVAL  : ARRAY OF NVAL "NICE" SCALE VALUES BETWEEN 1 & 10 ==AA C==           IN ASCENDING ORDER (1 <= SVAL(I) < 10,           ==EA C==           SVAL(I) < SVAL(I+1)). "SVAL" IS USED WHEN        == A C==           YINC <= 0, FOR AUTOMATIC SCALING OF THE Y-AXIS.  ==UA C==                                                            ==AA C==   NVAL  : NUMBER OF "NICE" SCALE VALUES IN "SVAL". IF      ==BA C==           NVAL <= 0 THEN "HISTP" USES THE DEFAULT SET OF   == A C==           SCALE VALUES: 1, 1.2, 1.5, 2, 2.5, 3, 4, 5, 6, 8.== A C==                                                            ==RA C==   DIGITS: ARRAY OF "NDIGS" DIGITS USED TO PROVIDE HIGH     ==TA C==           RESOLUTION HISTOGRAMS. THESE CHARACTERS ARE THE  ==QA C==           CHARACTERS PLOTTED AT THE TOP OF EACH VERTICAL   == A C==           HISTOGRAM COLUMN. THE TOP HISTOGRAM CHARACTER    == A C==           POSITION IS DIVIDED INTO A RESOLUTION OF         == A C==           1/NDIGS OF A CHARACTER POSITION. IF NDIGS <= 0   == A C==           THEN "DIGITS" IS NOT USED; INSTEAD THE INTERNAL  == A C==           10 DIGITS: 1, 2, 3, 4, 5, 6, 7, 8, 9, X  ARE USED.= A C==           IN THIS DEFAULT CASE THE LAST DIGIT "X" IS USED  ==LA C==           AS THE HISTOGRAM COLUMN FILL CHARACTER. IN       ==TA C==           GENERAL IF NDIGS > 0 THEN DIGITS(NDIGS) WILL BE  ==SA C==           USED AS THE HISTOGRAM COLUMN FILL CHARACTER.     == A C==                                                            == A C==   NDIGS : NUMBER OF DIGITS IN "DIGITS". IF NDIGS <= 0 THEN ==.A C==           "DIGITS" IS NOT USED AND THE DEFAULT DIGITS USED == A C==           ARE: 1, 2, 3, 4, 5, 6, 7, 8, 9, X.               == A C==                                                            ==IA C==                                                            == A C==   PARAMETER RESTRICTIONS AND FORMULAS:                     == A C==   --------- ------------ --- --------                      == A C==                                                            == A C==   NOTE:                                                    ==IA C==                                                            ==IA C==   DEFINITIONS:                                             ==IA C==   XWIDTH  = FORMAT WIDTH OF X FORMAT IN "XFMT".            ==UA C==   YWIDTH1 = FORMAT WIDTH OF 1'ST Y FORMAT IN "YFMT".       == A C==   YWIDTH2 = FORMAT WIDTH OF 2'ND Y FORMAT IN "YFMT".       ==NA C==                                                            ==|A C==   RETURN1:                                                 == A C==   AN ERROR RETURN FROM HISTP CONSISTS OF AN ERROR MESSAGE  ==LA C==   PRINTED ON UNIT "IOUT" INDICATING THE ERROR AND A RETURN1==1A C==   TO THE CALLING PROGRAM.                                  ==NA C==                                                            == A C==   IN EACH OF THE FOLLOWING RESTRICTIONS THE STATEMENT IN   == A C==   PARENTHESES TELLS WHAT WILL HAPPEN IF THE RESTRICTION    ==IA C==   IS VIOLATED:                                             == A C==                                                            ==BA C==   1) 6 <= NWIDTH <= 132, (NWIDTH IS TRUNCATED TO THESE     ==GA C==      LIMITS USING AN INTERNAL VARIABLE NWID=TRUNC(NWIDTH), ==SA C==      HOWEVER, THE VARIABLE NWIDTH IS NOT TAMPERED WITH).   == A C==   2) 1 <= XWIDTH <= 132, (ERROR RETURN).                   == A C==   3) 1 <= YWIDTH1 <= NWIDTH - 5, (ERROR RETURN).           ==NA C==   4) 1 <= YWIDTH2 <= 132, (ERROR RETURN).                  == A C==   5) MAXIMUM NUMBER OF BINS/PAGE = NWIDTH - YWIDTH1 - 4,   == A C==      DUE TO THE ABOVE RESTRICTIONS THIS WILL ALWAYS BE > 0.==IA C==   6) |NX| > 0, (ERROR RETURN).                             == A C==   7) IF NXLAB  <= 0 THEN XLAB   WILL NOT BE USED.          ==RA C==      IF NYLAB  <= 0 THEN YLAB   WILL NOT BE USED.          ==NA C==      IF NTITLE <= 0 THEN TITLE  WILL NOT BE USED.          ==EA C==      IF NVAL   <= 0 THEN SVAL   WILL NOT BE USED.          ==NA C==      IF NDIGS  <= 0 THEN DIGITS WILL NOT BE USED.          == A C==   8) NLINES => 2, (NLINES WILL BE SET TO 2 IF THIS IS NOT  ==EA C==      THE CASE).                                            ==1A C==                                                            ==DA C================================================================ A C================================================================ A CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCV)       REAL      X(1),Y(1),XX(127),SVAL(1)H1       LOGICAL*1 XLAB(1),YLAB(1),XFMT(10),YFMT(20) (       LOGICAL*1 TITLE(1),FMT(10),YFM(10)2       LOGICAL*1 LINE(10,127),LINE2(132),XAXIS(128)       INTEGER*2 IYIX(127)=%       EQUIVALENCE (LINE(1,1),IYIX(1))TA C================================================================.A C==   /C0MM0N/ IS A SCRATCH STORAGE AREA USED TEMPORARILY BY   == A C==   SUBROUTINES "HISTP" AND "SCATP". /C0MM0N/ IS NOT INTENDED== A C==   TO BE USED TO PASS INFORMATION FROM OR TO "HISTP" OR     ==NA C==   "SCATP". /C0MM0N/ MAY BE USED BY ANY OTHER ROUTINES FOR  ==RA C==   TEMPORARY SCRATCH STORAGE.                               ==UA C================================================================,4       COMMON    /C0MM0N/ XX,LINE2,LINE,FMT,YFM,XAXIS!       LOGICAL   EQUC,NPAR21,EMPTYU/       LOGICAL*1 MINUS,BLANK,PLUS,BARR,DIGITS(1)I       LOGICAL*1 BAR        DATA BAR/'I'/E4       DATA MINUS/'-'/,BLANK/' '/,PLUS/'+'/,BARR/'|'/A C=================================================================A C==   DEFAULT SET OF HISTOGRAM DIGITS:                         ===A C=================================================================       LOGICAL*1 DIGIT(10) 9       DATA DIGIT/'1','2','3','4','5','6','7','8','9','X'/        DATA NDIG/10/9A C================================================================ A C==   IF |NX| = 0 GO TO 1000 AND WRITE OUT AN ERROR MESSAGE.   == A C================================================================        NXU=IABS(NX)       IF(NXU.EQ.0)GO TO 1000A C================================================================ A C==   TRUNCATE NWIDTH SO THAT: 6 <= NWID <= 132.               == A C==   TRUNCATE NLINES SO THAT: 2 <= NLINE.                     == A C==   NLINP1 = TOTAL NUMBER OF HISTOGRAM LINES INCLUDING THE   == A C==            X-AXIS (AT Y=0).                                ==DA C================================================================D#       NWID=MAX0(MIN0(NWIDTH,132),6)=       NLINE=MAX0(NLINES,2)       NLINP1=NLINE+1A C================================================================ A C==   FIND THE POSITION OF THE ')' IN "XFMT" AND "YFMT".       == A C==   IF NONE EXISTS IN THE 1'ST 10 CHARACTERS GO TO 1010 OR   ==AA C==   1020 AND WRITE OUT AN ERROR MESSAGE.                     ==RA C================================================================ .       CALL FINDST(XFMT,10,')',1,1,NXFMT,&1010).       CALL FINDST(YFMT,10,')',1,1,NYFMT,&1020)A C================================================================ A C==   NXFMT = NUMBER OF CHARACTERS IN "XFMT".                  == A C==   NYFMT = NUMBER OF CHARACTERS IN "YFMT".                  == A C==   IF NXFMT OR NYFMT IS < 4 GO TO 1030 OR 1040.             == A C================================================================        IF(NXFMT.LT.4)GO TO 1030       IF(NYFMT.LT.4)GO TO 1040A C=================================================================A C==   DETERMINE THE X-FORMAT FIELD WIDTH: "NXWID", AND THE     ===A C==                 Y-FORMAT FIELD WIDTH: "NYWID".             ===A C=================================================================       NCHAR=NXFMT-3 2       CALL DTB(XFMT(3),NXWID,NCHAR,NSIG,' ',&1030).       IF(NXWID.LT.1.OR.NXWID.GT.132)GO TO 1050       NCHAR=NYFMT-3|2       CALL DTB(YFMT(3),NYWID,NCHAR,NSIG,' ',&1040)       IF(NYWID.LT.1)GO TO 1060A C================================================================HA C==   CHECK FOR A SECOND FORMAT CODE IN "YFMT".                ==HA C================================================================H*       IF(EQUC(YFMT(NYFMT+1),'('))GO TO 152A C=================================================================A C==   THERE IS NO SECOND FORMAT CODE IN "YFMT".                ===A C==   HENCE MAKE THE 2'ND Y-FORMAT CODE "YFM" = "YFMT".        ===A C=================================================================       NYFM=NYFMT        CALL MOVEC(NYFMT,YFMT,YFM)       NYWD=NYWID       IF(NYWD.GT.132)GO TO 1060=       GO TO 154=A C================================================================CA C==   HANDLE THE CASE WHEN THERE IS A SECOND FORMAT CODE IN    ==AA C==   "YFMT". PUT IT IN "YFM", AND DETERMINE "NYWD", THE FORMAT==TA C==   FIELD WIDTH OF THE 2'ND Y-FORMAT CODE.                   == A C==   NYFM = NUMBER OF CHARACTERS IN "YFM".                    ===A C=================================================================6 152   CALL FINDST(YFMT(NYFMT+1),10,')',1,1,NYFM,&1070)(       CALL MOVEC(NYFM,YFMT(NYFMT+1),YFM)       IF(NYFM.LT.4)GO TO 1080=       NCHAR=NYFM-30       CALL DTB(YFM(3),NYWD,NCHAR,NSIG,' ',&1080),       IF(NYWD.LT.1.OR.NYWD.GT.132)GO TO 1090A C================================================================ A C==   NOW THAT THE FORMATS ARE CALCULATED, CHECK THAT          ===A C==   NYWID+4 < NWID, WHERE NYWID+4 IS THE NUMBER OF CHARACTERS==YA C==   USED ON THE PAGE IN WRITING OUT: THE VERTICAL Y-LABEL    ==,A C==   (1 CHARACTER), FOLLOWED BY A BLANK, FOLLOWED             =='A C==   BY A Y-AXIS SCALE NUMBER (NYWID CHARACTERS), FOLLOWED BY ===A C==   A BLANK, FOLLOWED BY THE Y-AXIS CHARACTER (| OR -); AND  ==AA C==   NWID IS THE NUMBER OF CHARACTERS TO BE USED ACROSS THE   ===A C==   PAGE IN PRINTING THE HISTOGRAM.                          ==IA C================================================================' 154   NFMT=NYWID+4        IF(NFMT.GE.NWID)GO TO 1060A C================================================================TA C==   DETERMINE: YMINS, (THE MINIMUM Y-VALUE), YDIST (THE      ===A C==   Y-INCREMENT), AND YMAXS (THE MAXIMUM Y-VALUE) OF THE     == A C==   Y-AXIS.                                                  ===A C==   IF YINC > 0 THEN USE YLOW AND YINC TO DETERMINE SCALING. ==DA C==   IF YINC <= 0 THEN PERFORM AUTO-SCALING ON THE Y-AXIS.    ==NA C================================================================M       IF(YINC.GT.0.0)GO TO 206A C=================================================================A C==   YINC <= 0: PERFORM AUTO-SCALING OF THE Y-AXIS.           == A C==   DETERMINE YMIN AND YMAX OF THE "Y" ARRAY.                == A C=================================================================       YMIN=Y(1)=       YMAX=Y(1)T       DO 205 I=1,NXU       IF(Y(I).LT.YMIN)YMIN=Y(I)F       IF(Y(I).GT.YMAX)YMAX=Y(I)C 205   CONTINUEA C================================================================ A C==   IF 0 IS OUTSIDE THE RANGE: YMIN <= Y <= YMAX THEN INCLUDE===A C==   IT BY EXTENDING THE LIMITS YMIN OR YMAX.                 ==LA C==   SCALE2: RETURNS THE NEW AUTOSCALED VALUES YMINS &        ===A C==   YMAXS = YMINS+NLINE*YDIST.                               ==CA C================================================================C       IF(YMIN.GT.0.0)YMIN=0.0        IF(YMAX.LT.0.0)YMAX=0.0S>       CALL SCALE2(YMIN,YMAX,NLINE,YMINS,YMAXS,YDIST,SVAL,NVAL)+       IF(YDIST.LT.ABS(YINC))YDIST=ABS(YINC)        YMAXS=YMINS+NLINE*YDIST        GO TO 208.A C=================================================================A C==   YINC > 0. : YMINS=YLOW, YDIST=YINC.                      ==DA C================================================================  206   YMINS=YLOW       YDIST=YINC       YMAXS=YMINS+NLINE*YDIST=A C================================================================HA C==   DETERMINE THE NUMBER OF HIGH RESOLUTION HISTOGRAM DIGITS.== A C==   YDISTN=YDIST/NDIGIT IS THE RESOLUTION OF THE VERTICAL    ==1A C==   HISTOGRAM COLUMNS.                                       ===A C================================================================A 208   NDIGIT=NDIGS        IF(NDIGIT.LE.0)NDIGIT=NDIG       YDISTN=YDIST/NDIGIT=A C================================================================ A C==   IAXIS IS THE LINE NUMBER FROM THE TOP OF THE HISTOGRAM AT== A C==   WHICH THE X-AXIS (Y=0) IS TO APPEAR.                     == A C==   1 <= IAXIS <= NLINP1 = NLINE+1.                          == A C================================================================ A C==   IYLAB IS THE FIRST LINE FROM THE TOP OF THE HISTOGRAM AT ==DA C==   WHICH THE Y-LABEL IS TO BE WRITTEN VERTICALLY IN COLUMN 1===A C==   OF THE PAGE.                                             ==TA C================================================================ A C==   ISTART IS THE COLUMN POSITION OF THE Y-AXIS.             ==IA C================================================================NA C==   IPAGE IS THE PAGE NUMBER OF THE HISTOGRAM.               ===A C==   IPAGE=1 FOR THE 1'ST PAGE.                               ==NA C================================================================T       IAXIS=YMAXS/YDIST+1.5.       IF(IAXIS.LT.1)IAXIS=1=%       IF(IAXIS.GT.NLINP1)IAXIS=NLINP1R       IYLAB=(NLINP1-NYLAB)/2+1       IF(IYLAB.LT.1)IYLAB=10       ISTART=NYWID+4
       IPAGE=0=A C================================================================UA C==   NXMAX IS THE NUMBER OF CHARACTERS ACROSS THE PAGE WHICH  == A C==   CAN BE USED FOR PLOTTING THE HISTOGRAM COLUMNS.          ==UA C================================================================BA C==   IXX   POINTS TO THE START OF THE (X,Y) ARRAYS WHICH ARE  ==IA C==         TO BE HISTOGRAMMED ON THE CURRENT PAGE (IPAGE).    ==IA C================================================================EA C==   NXX   IS THE NUMBER OF (X,Y) PAIRS TO BE HISTOGRAMMED    ==MA C==         ON THE CURRENT PAGE STARTING AT (X(IXX),Y(IXX)).   ===A C================================================================E       NXMAX=NWID-NFMT=       IXX=1=       NXX=0=A C================================================================MA C==   LOOP OVER THE HISTOGRAM PAGES STARTS HERE AT 210.        ==EA C================================================================ A C==   NXU = IABS(NX) = TOTAL NUMBER OF POINTS IN (X,Y).        ==NA C================================================================UA C==   INCREMENT THE HISTOGRAM POINTER IXX, AND THE PAGE NUMBER ===A C==   IPAGE.                                                   ===A C================================================================= 210   IXX=IXX+NXXO       NXX=NXU-IXX+1E       IF(NXX.LE.0)RETURN       IF(NXX.GT.NXMAX)NXX=NXMAXE       IPAGE=IPAGE+1 A C=================================================================A C==   THE FIRST CHARACTER OF THE X-AXIS IS A "+".              == A C==   THE DO 225 LOOP FILLS THE XAXIS ARRAY (XAXIS(2) TO       == A C==   XAXIS("NXX"+1)) WITH NXX X-AXIS CHARACTERS.              ===A C==   IT ALSO DETERMINES WHETHER OR NOT THIS PAGE OF THE       ==TA C==   HISTOGRAM IS EMPTY (IF IT IS EMPTY THEN EMPTY=.TRUE.).   == A C==   IT ALSO CALCULATES YSUM = SUM OF ALL OF THE BIN COUNTS   ==NA C==   FOR THE CURRENT PAGE, AND IT FILLS THE XX - ARRAY WITH   == A C==   THE X-AXIS VALUES.                                       ===A C================================================================0       XAXIS(1)=PLUSL       YSUM=0.0       IX=IXX       EMPTY=.TRUE.       DO 225 I=1,NXX       XAXIS(I+1)=MINUSA C=================================================================A C==   "|"'S APPEAR AS THE 1'ST, 11'TH, 21'ST, 31'ST,... ETC.   ==0A C==   CHARACTERS OF THE XAXIS(I+1) ARRAY.                      ===A C================================================================L&       IF(I-I/10*10.EQ.1)XAXIS(I+1)=BAR"       IF(Y(IX).NE.0.)EMPTY=.FALSE.       YSUM=YSUM+Y(IX)=A C================================================================ A C==   IYIX: IS THE INTEGERIZED VALUE THAT "Y(IX)" CORRESPONDS  ==FA C==         TO WHEN EXPRESSED IN TERMS OF THE HIGH RESOLUTION  == A C==         Y-INCREMENT: YDISTN = YDIST/NDIGIT.                ===A C================================================================I0       IYIX(I)=Y(IX)/YDISTN+SIGN(.5,Y(IX)/YDISTN)       IF(NX.GT.0)XX(I)=X(IX)'       IF(NX.LT.0)XX(I)=X(1)+(IX-1)*X(2)E
       IX=IX+1O 225   CONTINUEA C================================================================ A C==   IF THE HISTOGRAM IS EMPTY AND IEMPTY=1 THEN GO TO 210    == A C==   AND PLOT THE NEXT HISTOGRAM PAGE, IF ANY.                ===A C================================================================ (       IF(EMPTY.AND.IEMPTY.EQ.1)GO TO 210A C================================================================ A C==   THE FIRST THING TO WRITE OUT IS THE HISTOGRAM "TITLE".   ===A C================================================================U;       IF(NTITLE.GT.0)WRITE(IOUT,220)(TITLE(NN),NN=1,NTITLE)= 220   FORMAT(255A1)=A C================================================================IA C==   IF THERE IS MORE THAN 1 HISTOGRAM PAGE THEN WRITE OUT THE== A C==   HISTOGRAM PAGE NUMBER BELOW THE TITLE.                   ===A C================================================================I*       IF(NXU.GT.NXMAX)WRITE(IOUT,222)IPAGE 222   FORMAT('$PAGE',I3)A C================================================================WA C==   NXX IS THE NUMBER OF HISTOGRAM BINS ON THE CURRENT PAGE. ===A C==   NAXIS IS THE NUMBER OF X-AXIS CHARACTERS ON THE CURRENT  ==SA C==         PAGE.                                              ==CA C==   ISTART IS THE COLUMN POSITION OF THE 1'ST X-AXIS CHARACTER==A C==          WHICH IS A "+".                                   ==AA C==   IEND   IS THE COLUMN POSITION OF THE LAST X-AXIS CHARACTER= A C=================================================================       NAXIS=NXX+1E       IEND=ISTART+NXXMA C================================================================RA C==   THE DO 320 LOOP PRINTS OUT THE ENTIRE HISTOGRAM.         ===A C=================================================================       DO 320 I=1,NLINP1=A C=================================================================A C==   IN THE FIRST COLUMN OF LINE2, WHICH IS THE ENTIRE        ===A C==   HISTOGRAM LINE (UPTO 132 CHARACTERS LONG), WE PUT A BLANK===A C==   OR IF WE ARE PAST THE IYLAB'TH LINE WE WILL PUT A Y-LABEL===A C==   CHARACTER INTO LINE2(1).                                 ===A C=================================================================       LINE2(1)=BLANK       IYL=I-IYLAB+1 5       IF(IYL.GE.1.AND.IYL.LE.NYLAB)LINE2(1)=YLAB(IYL)=A C================================================================XA C==   LINE2(2) IS ALWAYS BLANK.                                ==XA C=================================================================       LINE2(2)=BLANKA C================================================================ A C==   DETERMINE THE Y-SCALE VALUE FOR THE CURRENT LINE #.      == A C==   USING "RICON" CONVERT "YSCALE" INTO "NYWID" CHARACTERS IN== A C==   LINE2(3).                                                == A C================================================================        YSCALE=YMAXS-(I-1)*YDIST0       IF(ABS(YSCALE/YDIST).LT.0.00002)YSCALE=0.04       CALL RICON(YSCALE,LINE2(3),2,YFMT,NYWID,&1040)A C================================================================ A C==   LINE2(NYWID+3) IS ALWAYS BLANK.                          ===A C================================================================T       LINE2(NYWID+3)=BLANK       IF(I.NE.IAXIS)GO TO 330=A C================================================================ A C==   I=IAXIS, I.E. THIS IS THE LINE ON WHICH THE X-AXIS IS TO == A C==   BE PRINTED.                                              ===A C==   MOVE THE "XAXIS" ARRAY TO LINE2(ISTART), AND THEN GO TO  == A C==   360 TO PRINT OUT THE LINE.                               ==SA C=================================================================.       CALL MOVEC(NAXIS,XAXIS(1),LINE2(ISTART))       GO TO 360TA C================================================================SA C==   I.NE.IAXIS, I.E. THIS LINE IS PART OF THE HISTOGRAM.     ==SA C=================================================================A C==   LINE2(ISTART) = "|" WITH EVERY 10'TH LINE FROM THE X-AXIS==IA C==   LINE (LINE # IXAXIS) A "-" CHARACTER.                    ==1A C================================================================= 330   LINE2(ISTART)=BAR=1       IF(MOD(I-IAXIS,10).EQ.0)LINE2(ISTART)=MINUSTA C================================================================GA C==   IY: IS THE INTEGERIZED VALUE THAT "YSCALE" CORRESPONDS TO===A C==       WHEN EXPRESSED IN TERMS OF THE HIGH RESOLUTION       ==1A C==       Y-INCREMENT: YDISTN=YDIST/NDIGIT.                    ===A C================================================================T-       IY=YSCALE/YDISTN+SIGN(.5,YSCALE/YDISTN)=A C================================================================)A C==   THE DO 340 LOOP FILLS THE REMAINDER OF LINE2 WITH THE    ===A C==   APPROPRIATE HISTOGRAM CHARACTERS, WHICH ARE DETERMINED   ==OA C==   BY COMPARING "IY" (YSCALE) TO "IYIX(J)" (Y(IX)).         ==EA C=================================================================       DO 340 J=1,NXX       LINE2(ISTART+J)=BLANK A C=================================================================A C==   IF IY*IYIX(J) <= 0, I.E. WHEN THE Y-AXIS VALUE "IY" FOR  ===A C==   THE CURRENT LINE IS ON THE OPPOSITE SIDE OF THE X-AXIS   ===A C==   RELATIVE TO THE Y-BIN COUNT VALUE "IY", THEN LEAVE       ===A C==   LINE2(ISTART+J) BLANK AND CONTINUE THE LOOP.             ===A C================================================================="       IF(IY*IYIX(J).LE.0)GO TO 340A C================================================================FA C==   BOTH "IY" AND "IYIX(J)" ARE OF THE SAME SIGN AND NON-ZERO===A C==   IDIGIT IS THE NUMBER OF THE DIGIT WHICH WE WILL SET      ==+A C==   LINE2(ISTART+J) EQUAL TO.                                ===A C==   IF IDIGIT <= 0 THEN LEAVE LINE2(ISTART+J) BLANK.         == A C==   IF IDIGIT > NDIGIT SET IDIGIT=NDIGIT.                    ===A C==   FINALLY SET LINE2(ISTART+J) TO THE IDIGIT'TH DIGIT.      ===A C================================================================ ,       IDIGIT=NDIGIT-ISIGN(1,IY)*(IY-IYIX(J))       IF(IDIGIT.LE.0)GO TO 340'       IF(IDIGIT.GT.NDIGIT)IDIGIT=NDIGITP1       IF(NDIGS.LE.0)LINE2(ISTART+J)=DIGIT(IDIGIT) 2       IF(NDIGS.GT.0)LINE2(ISTART+J)=DIGITS(IDIGIT) 340   CONTINUEA C================================================================ A C==   NOW WE CAN WRITE OUT THE HISTOGRAM LINE.                 ==EA C=================================================================( 360   WRITE(IOUT,370)(LINE2(J),J=1,IEND) 370   FORMAT('$',132A1)  320   CONTINUEA C=================================================================A C==   FOR ITIME=1: CONVERT THE HISTOGRAM X-AXIS SCALE VALUES   ===A C==   "XX(I)" TO CHARACTERS IN LINE2, AND MOVE THEM 10 AT A    == A C==   TIME INTO LINE(1,I).                                     ==LA C================================================================ A C==   FOR ITIME=2: CONVERT THE HISTOGRAM Y BIN COUNTS (Y(IX))  ===A C==   TO CHARACTERS IN LINE2, AND MOVE THEM 10 AT A TIME INTO  == A C==   LINE(1,I).                                               ==CA C=================================================================       NW=NXWID        CALL MOVEC(NXFMT,XFMT,FMT)A C=================================================================A C==   ITIME=1: STARTS HERE.                                    ==IA C=================================================================
       ITIME=1= 410   IWW=1=       NWW=0  415   IWW=IWW+NWW        NWW=NW-IWW+1       IF(NWW.LE.0)GO TO 440=       IF(NWW.GT.10)NWW=10        DO 420 I=1,NXX,       CALL RICON(XX(I),LINE2,2,FMT,NW,&1100)*       CALL MOVEC(NWW,LINE2(IWW),LINE(1,I)) 420   CONTINUEA C=================================================================A C==   WRITE OUT THE LINE(I,J) ARRAY OF X-AXIS VALUES.          ==SA C=================================================================       DO 430 I=1,NWW;       WRITE(IOUT,370)(BLANK,J=1,ISTART),(LINE(I,J),J=1,NXX)T 430   CONTINUE       GO TO 415= 440   IF(ITIME.EQ.2)GO TO 460=A C================================================================1A C==   ITIME=1: WRITE OUT THE X-AXIS LABEL BELOW THE X-AXIS     ==AA C==            BIN VALUES.                                     ===A C==   NBLANK : IS THE NUMBER OF LEADING BLANKS BEFORE X-LABEL. ==DA C=================================================================!       NBLANK=ISTART+(NXX-NXLAB)/2=-       IF(NBLANK.GT.132-NXLAB)NBLANK=132-NXLABC       IF(NBLANK.LT.1)NBLANK=1 4       IF(NXLAB.GT.0.AND.NXLAB.LT.132)WRITE(IOUT,370).      *  (BLANK,I=1,NBLANK),(XLAB(I),I=1,NXLAB)6       IF(NXLAB.GE.132)WRITE(IOUT,370)(XLAB(I),I=1,132)(       IF(NXLAB.LE.0)WRITE(IOUT,370)BLANKA C=================================================================A C==   WRITE OUT THE X-AXIS AGAIN BELOW THE X-AXIS LABEL.       ==IA C================================================================G<       WRITE(IOUT,370)(BLANK,J=1,ISTART),(XAXIS(J),J=2,NAXIS)A C=================================================================A C==   ITIME=1: IS COMPLETE HERE.                               ==NA C=================================================================A C==   ITIME=2: STARTS HERE.                                    ==EA C================================================================OA C==   FILL THE "XX" ARRAY WITH THE "Y(IX)" BIN COUNTS.         == A C================================================================O       IX=IXX       DO 450 I=1,NXX       XX(I)=Y(IX)=
       IX=IX+1= 450   CONTINUE
       NW=NYWD        CALL MOVEC(NYFM,YFM,FMT)
       ITIME=2=       GO TO 410=A C================================================================RA C==   ITIME=2: IS COMPLETE.                                    ==HA C================================================================ A C==   WRITE OUT THE TOTAL BIN CONTENTS FOR THE PAGE.           == A C================================================================I 460   NCHAR=354       CALL MOVEC(23,'BIN CONTENTS:  TOTAL = ',LINE2)/       CALL RICON(YSUM,LINE2(24),2,'(G12.6)',12)=#       NBLANK=ISTART+(NXX-NCHAR)/2+2=-       IF(NBLANK.GT.132-NCHAR)NBLANK=132-NCHARI       IF(NBLANK.LT.1)NBLANK=10<       WRITE(IOUT,370)(BLANK,I=1,NBLANK),(LINE2(I),I=1,NCHAR)       GO TO 210(A C================================================================SA C==   ERROR MESSAGES.                                          ===A C================================================================L 1000  WRITE(IOUT,1001)5 1001  FORMAT('0*** ERROR *** IN HISTP. DIMENSION NX',="      *       ' MUST BE NON-ZERO.')
       RETURN1N 1010  WRITE(IOUT,1011): 1011  FORMAT('0*** ERROR *** IN HISTP. FORMAT CODE: XFMT',      *       ' HAS NO ")" IN'/7      *       '               ITS 1''ST 10 CHARACTERS.')S
       RETURN1X 1020  WRITE(IOUT,1021)B 1021  FORMAT('0*** ERROR *** IN HISTP. 1''ST FORMAT CODE OF YFMT',      *       ' HAS NO ")" IN '/L7      *       '               ITS 1''ST 10 CHARACTERS.')=
       RETURN1  1030  WRITE(IOUT,1031): 1031  FORMAT('0*** ERROR *** IN HISTP. FORMAT CODE: XFMT',      *       ' IS INVALID.')
       RETURN1  1040  WRITE(IOUT,1041)B 1041  FORMAT('0*** ERROR *** IN HISTP. 1''ST FORMAT CODE OF YFMT',      *       ' IS INVALID.')
       RETURN1  1050  WRITE(IOUT,1051)C 1051  FORMAT('0*** ERROR *** IN HISTP. FIELD WIDTH IN FORMAT CODE:'=      *      ,' XFMT MUST BE '/@      *       '               IN THE RANGE: 1 <= XWIDTH <= 132.')
       RETURN1= 1060  WRITE(IOUT,1061)C 1061  FORMAT('0*** ERROR *** IN HISTP. FIELD WIDTH IN 1''ST FORMAT' &      *      ,' CODE OF YFMT MUST BE '/C      *       '               IN THE RANGE: 1 <= YWIDTH1 <= NWIDTH',1      *       ' - 5.')X
       RETURN1T 1070  WRITE(IOUT,1071)B 1071  FORMAT('0*** ERROR *** IN HISTP. 2''ND FORMAT CODE OF YFMT',      *       ' HAS NO ")" IN '/=7      *       '               ITS 1''ST 10 CHARACTERS.')I
       RETURN1  1080  WRITE(IOUT,1081)B 1081  FORMAT('0*** ERROR *** IN HISTP. 2''ND FORMAT CODE OF YFMT',      *       ' IS INVALID.')
       RETURN1, 1090  WRITE(IOUT,1091)C 1091  FORMAT('0*** ERROR *** IN HISTP. FIELD WIDTH IN 2''ND FORMAT'='      *      ,' CODE OF YFMT MUST BE '/,=A      *       '               IN THE RANGE: 1 <= YWIDTH2 <= 132.') 
       RETURN1= 1100  IF(ITIME.EQ.1)GO TO 1030       GO TO 1080	       END 