       SUBROUTINE HPLASERQ H C======================================================================CH C  Generates a plot file for the HP Laserjet laser printer.            CH C======================================================================C       IQUEST=1       CALL HPJET(0,IQUEST,1)       RETURN	       END          SUBROUTINE HPTHINKQ H C======================================================================CH C  Generates a plot file for the HP Thinkjet printer.                  CH C======================================================================C       IQUEST=1       CALL HPJET(0,IQUEST,0)       RETURN	       END     *       SUBROUTINE HPJET(IUNIT,IQUEST,LASER)H C======================================================================CH C                                                                      CH C  HPJET                                           F.W. Jones, TRIUMF  CH C                                                                      CH C  Generates a plot file for the HP Laserjet or HP Thinkjet printer.   CH C                                                                      CH C  If IUNIT > 0, the output will be directed to the file FORxxx        CH C  specified by IUNIT. Otherwise the output will be sent to a file     CH C  HPLASER.PLT or HPTHINK.PLT.                                         CH C                                                                      CH C  If IQUEST is set to 1, the output of the plot will be confirmed     CH C  via a query on the user's terminal.  If the user decides not to     CH C  output the plot, IQUEST will be set to 0 on return.                 CH C                                                                      CH C  If IQUEST is set to 0, no query will be made on the user's          CH C  terminal, and the plot will be output automatically.                CH C                                                                      CH C  NOTE:  If IQUEST is set to 1, it must be passed as a variable,      CH C  not a constant, since it may be altered by this routine.            CH C                                                                      CH C======================================================================C C #       COMMON/PLOT_OUTPUT_UNIT/IOUTS !       COMMON/PLOT_INPUT_UNIT/IINS        DATA IINS/5/,IOUTS/6/  C +       COMMON /PLOT_MONITOR/ IMONITOR, IOUTM 9       COMMON /PLOT_HARDCOPY/ IXLAST,IYLAST,N1,N2,HARDCOPY "       LOGICAL*1 HARDCOPY(188,2048),       DATA IXLAST,IYLAST,N1,N2/0,0,188,2048/ C        LOGICAL*1 ANS        LOGICAL*1 ESC/27/        CHARACTER*5 HPTYPE C        HPTYPE='THINK'"       IF(LASER.EQ.1)HPTYPE='LASER' C > C============================================================C C  Query the user.> C============================================================C       IF(IQUEST.EQ.1)THEN           CALL TRANSPARENT_MODE(0)2 10      IF (IMONITOR.EQ.1 .OR. IMONITOR.EQ.6) THENB           WRITE(IOUTS,20)ESC,'#6HP '//HPTYPE//'jet plot? (y/n) > ' 20        FORMAT('+',A1,A,$)         ELSE=           WRITE (IOUTS,30)'HP '//HPTYPE//'jet plot? (y/n) > '  30        FORMAT ('+',A,$)
         ENDIF          READ(IINS,40)ANS 40      FORMAT(A1)(         IF(ANS.EQ.'Y'.OR.ANS.EQ.'y')THEN           GO TO 100 -         ELSE IF(ANS.EQ.'N'.OR.ANS.EQ.'n')THEN            IQUEST=0           RETURN         ELSE           GO TO 10
         ENDIF        ENDIF  C > C============================================================C C  Open the output unit.> C============================================================C 100   IF(IUNIT.LE.0)THEN         CALL FIND_UNIT(IOUT):         OPEN(UNIT=IOUT,FILE='HP'//HPTYPE//'.PLT',RECL=255,9      #       CARRIAGECONTROL='NONE',STATUS='NEW',ERR=999) 
       ELSE         IOUT=IUNIT7         OPEN(UNIT=IOUT,RECL=255,CARRIAGECONTROL='NONE', "      #       STATUS='NEW',ERR=999)       ENDIF  C > C============================================================C C  Send the plot data.> C============================================================CC       CALL WRITE_BITMAP_HPJET(IOUT,HARDCOPY,188,N1,N2,.TRUE.,LASER)        CLOSE(UNIT=IOUT)       RETURN C > C============================================================C C  Error return > C============================================================C 999   WRITE(IOUTS,1000)IOUT : 1000  FORMAT(' ***Unable to open unit ',I3,' for output.')       CLOSE(UNIT=IOUT)       RETURN	       END 