H C======================================================================CH C  HP plotter subroutines                                              CH C                                                                      CH C  WRITTEN BY MIKE KENT, TRIUMF VANCOUVER     JULY 1983                CH C  VERSION 1.0   ( 12 OCTOBER 1983)                                    CH C                                                                      CH C  Extensively modified by Joe Chuma, January 25, 1984                 CH C  Modified by Ken Fong, February, 1984                                CH C  Modified by F. Jones, March/85.                                     CH C                                                                      CH C======================================================================C    $       SUBROUTINE HP_PLOTS(N,M,IUNIT)H C======================================================================CH C                                                                      CH C  Initialization.                                                     CH C                                                                      CH C  Modified March 4/85 by F. Jones:                                    CH C    PX and PY are set outside the plotting region, so that            CH C    an initial pen up to (0,0) will not be masked.                    CH C                                                                      CH C======================================================================C<       COMMON /HPUNIT/ IIUNIT, /HPPEN/ PEN_STATE,PX,PY,ICOUNT       LOGICAL*1 PEN_STATE        PEN_STATE='U'        PX=-1.       PY=-1.       ICOUNT=-1        IIUNIT = IUNIT       CALL HP_NEWPEN(1)  C        RETURN	       END     $       SUBROUTINE HP_PLOT(DX,DY,IPEN)H C======================================================================CH C  Cory's plot package calls Z_PLOT with real values                   CH C  of x and y in the range 0 < x < 27.94 and 0 < y < 21.59 cm with     CH C  infinitely small increments.                                        CH C  The HP plotter requires ASCII integer strings                       CH C  in the range 0 < x < 10900 and 0 < y < 7650.  When using the A4     CH C  setting for paper size (dipswitch selectable).                      CH C  First we scale the data and convert it into integers.               CH C  354.414=10900/21.59*0.702    OLD                                    CH C  390.122=10900/27.94          NEW                                    CH C  273.80=7650/27.94            OLD                                    CH C  354.33=7650/21.59            NEW                                    CH C                                                                      CH C  Modified March 4/85 by F. Jones:                                    CH C    The scaling has been changed so that this routine may be passed   CH C    true "device coordinates" in centimeters.  The above "fudge       CH C    numbers" have been eliminated, since they are an attempt to       CH C    emulate Zeta plotter coordinates, when in fact the Zeta plotter   CH C    has a larger plottable area than the HP plotters.                 CH C                                                                      CH C    The HP 7575A (6-pen) plotter has 402 "plotter units" per cm,      CH C    while the HP 7470A (2-pen) and 7550A (8-pen) have 400 plotter     CH C    units per cm.  In order to support all units in a transparent     CH C    way, the compromise conversion factor of 401 has been used.       CH C    This results in errors of at most 0.25% in actual distances       CH C    plotted.  The three plotters have slight differences in the size  CH C    of the plotting area.  To avoid overflow, the following maxima    CH C    should be used:                                                   CH C                                                                      CH C          X: 25.36 cm (10169 plotter units)                           CH C          Y: 19.07 cm ( 7647 plotter units)                           CH C                                                                      CH C    The following call to MONITOR2_RANGE will support all devices:    CH C                                                                      CH C      CALL MONITOR2_RANGE(5,7,XMINH,XMAXH,YMINH,YMAXH,                CH C                          0.,25.36,0.,19.07,-1)                       CH C                                                                      CH C    Note that the orientation (-1) has been changed to reflect that   CH C    of the HP plotter, which is opposite to that of the Zeta plotter. CH C                                                                      CH C=======================================================================<       COMMON /HPUNIT/ IIUNIT, /HPPEN/ PEN_STATE,PX,PY,ICOUNT        LOGICAL*1   PEN, PEN_STATE       COMMON/HP_FLUSH/BUF !       CHARACTER*6 CHX,CHY,BUF(12)  C        PX=DX        PY=DY        IX=DX*401.       IY=DY*401.       WRITE(CHX,999)IX       WRITE(CHY,999)IY 999   FORMAT(I6) C        PEN = 'D' 9       IF (IPEN.GT.2) PEN = 'U'        !select pen UP/DOWN 6       IF (PEN.EQ.PEN_STATE) THEN      !same pen state?0 C==Forget about old position if pen is still up:0          IF (PEN.EQ.'U'.AND.ICOUNT.GE.1) GOTO 60          ICOUNT=ICOUNT+2 60       BUF(ICOUNT)=CHX          BUF(ICOUNT+1)=CHY!          IF (ICOUNT.LT.11) RETURN F          WRITE(IIUNIT,45) PEN,(BUF(I),I=1,12)    !write buffer if full          ICOUNT=-1          RETURN 
       ELSE          IF (ICOUNT.NE.-1)=      *       WRITE(IIUNIT,45) PEN_STATE,(BUF(I),I=1,ICOUNT+1) E                                   !flush buffer of previous pen state 5                                   !if it is not empty           ICOUNT=1 0          PEN_STATE=PEN           !new pen status          BUF(1)=CHX           BUF(2)=CHY        ENDIF % 45    FORMAT('P',A1,<ICOUNT+1>A6,';')        RETURN C  cc      ENTRY HP_FLUSH cc      IF (ICOUNT.NE.-1) ; cc     *   WRITE(IIUNIT,45) PEN_STATE,(BUF(I),I=1,ICOUNT+1) G cc                                  !flush buffer of previous pen state 7 cc                                  !if it is not empty  cc      ICOUNT=-1  cc      RETURN	       END          SUBROUTINE HP_FLUSH <       COMMON /HPUNIT/ IIUNIT, /HPPEN/ PEN_STATE,PX,PY,ICOUNT       LOGICAL*1 PEN_STATE        COMMON/HP_FLUSH/BUF        CHARACTER*6 BUF(12)          IF (ICOUNT.NE.-1) 9      *   WRITE(IIUNIT,45) PEN_STATE,(BUF(I),I=1,ICOUNT+1) E                                   !flush buffer of previous pen state 5                                   !if it is not empty % 45    FORMAT('P',A1,<ICOUNT+1>A6,';')        ICOUNT=-1        RETURN	       END               SUBROUTINE HP_NEWPEN(IDUM)H C======================================================================CH C  Just selects the pen...                                             CH C  Modified by J.Chuma, April 1, 1986 to put pen up before selecting   CH C  a new pen                                                           CH C=======================================================================<       COMMON /HPUNIT/ IIUNIT, /HPPEN/ PEN_STATE,PX,PY,ICOUNT       LOGICAL*1 PEN_STATE  C  C   FLUSH BUFFER C        CALL HP_FLUSH        WRITE(IIUNIT,70)       WRITE(IIUNIT,60)IDUM       PEN_STATE='U'        ICOUNT=-1  60    FORMAT('SP',I1,';')  70    FORMAT('PU;')        RETURN	       END     !       SUBROUTINE HP_SPEED(ISPEED) H C======================================================================C C  Changes the plotting speed.H C======================================================================C<       COMMON /HPUNIT/ IIUNIT, /HPPEN/ PEN_STATE,PX,PY,ICOUNT C +       IF(ISPEED.LT.1.OR.ISPEED.GT.80)RETURN        CALL HP_FLUSH        WRITE(IIUNIT,1000)ISPEED 1000  FORMAT('VS',I2,';')              RETURN	       END 