       SUBROUTINE LA100HQH C======================================================================CH C  Quick call to LA100H to send a plot to an LA100 printer.            CH C======================================================================C       IQUEST=1       CALL LA100H(0,IQUEST)        RETURN	       END     %       SUBROUTINE LA100H(IUNIT,IQUEST) H C======================================================================CH C                                                                      CH C  LA100H                                          F.W. Jones, TRIUMF  CH C                                                                      CH C  Controls the output of the Printronix bitmap to the                 C C  DEC LA100 printer. H C                                                                      CH C  If IUNIT > 0, the output will be directed to the file FORxxx        CH C  specified by IUNIT, otherwise the output will be sent directly      C C  to the printer.H C                                                                      CH C  If IQUEST is set to 1, the output of the plot will be confirmed     CH C  via a query on the user's terminal.  If the user decides not to     CH C  output the plot, IQUEST will be set to 0 on return.                 CH C                                                                      CH C  If IQUEST is set to 0, a query will not be made on the user's       CH C  terminal, and the output of the plot will be automatic.             CH C                                                                      CH C  NOTE:  If IQUEST is set to 1, it must be passed as a variable,      CH C  not a constant, since it may be altered by this routine.            CH C                                                                      CH C======================================================================C C #       COMMON/PLOT_OUTPUT_UNIT/IOUTS !       COMMON/PLOT_INPUT_UNIT/IINS        DATA IINS/5/,IOUTS/6/  C +       COMMON /PLOT_MONITOR/ IMONITOR, IOUTM 9       COMMON /PLOT_HARDCOPY/ IXLAST,IYLAST,N1,N2,HARDCOPY "       LOGICAL*1 HARDCOPY(188,2048),       DATA IXLAST,IYLAST,N1,N2/0,0,188,2048/ C        LOGICAL*1 ANS        LOGICAL*1 ESC/27/  C > C============================================================C C  Query the user.> C============================================================C       IF(IQUEST.EQ.1)THEN           CALL TRANSPARENT_MODE(0)2 10      IF (IMONITOR.EQ.1 .OR. IMONITOR.EQ.6) THEN5           WRITE(IOUTS,20)ESC,'#6LA100 plot? (y/n) > '  20        FORMAT('+',A1,A,$)         ELSE0           WRITE (IOUTS,30)'LA100 plot? (y/n) > ' 30        FORMAT ('+',A,$)
         ENDIF          READ(IINS,40)ANS 40      FORMAT(A1)(         IF(ANS.EQ.'Y'.OR.ANS.EQ.'y')THEN           GO TO 100 -         ELSE IF(ANS.EQ.'N'.OR.ANS.EQ.'n')THEN            IQUEST=0           RETURN         ELSE           GO TO 10
         ENDIF        ENDIF  C > C============================================================C C  Open the output unit.> C============================================================C 100   IF(IUNIT.LE.0)THEN         CALL FIND_UNIT(IOUT)(         OPEN(UNIT=IOUT,FILE='LA100.PLT',"      #       STATUS='NEW',ERR=999)
       ELSE         IOUT=IUNIT         OPEN(UNIT=IOUT, "      #       STATUS='NEW',ERR=999)       ENDIF  C > C============================================================C C  Send the plot data.> C============================================================C=       CALL WRITE_BITMAP_LA100(IOUT,HARDCOPY,188,N1,N2,.TRUE.)        CLOSE(UNIT=IOUT)       RETURN C > C============================================================C C  Error return > C============================================================C 999   WRITE(IOUTS,1000)IOUT : 1000  FORMAT(' ***Unable to open unit ',I3,' for output.')       CLOSE(UNIT=IOUT)       RETURN	       END 