-       CHARACTER*(*) FUNCTION LOWER_CASE(LINE)  C    C     reqd. routines - NONE A C================================================================ A C================================================================ A C==                                                            == A C==   LOWER_CASE: Converts upper case ASCII characters in      == A C==               "LINE" into lower case ASCII characters. All == A C==               other characters remain the same. The result == A C==               is returned in "LOWER_CASE".                 == A C==                    Both "LINE" and "LOWER_CASE"            == A C==               are variable length character strings, i.e.  == A C==               their length attribute is determined in the  == A C==               calling routine. The lengths of "LINE" and   == A C==               "LOWER_CASE" need not be the same. If "LINE" == A C==               is longer than "LOWER_CASE" then "LINE" will == A C==               be truncated and stored in "LOWER_CASE"; if  == A C==               "LOWER_CASE" is longer than "LINE" then it   == A C==               will be padded with blanks.                  == A C==                                                            == A C==   Written by Alan Carruthers, TRIUMF U.B.C., Nov. 9, 1982. == A C==   (Simple modification of UPPER_CASE routine written by    == A C==   Arthur Haynes.)                                          == A C==                                                            == A C==   Input  Parameters: LINE (CHARACTER*(*)).                 == A C==                                                            == A C==   Output Parameters: LOWER_CASE (CHARACTER*(*)).           == A C==                                                            == A C================================================================ A C================================================================        CHARACTER*(*) LINE       CHARACTER TABLE(0:255)       LOGICAL*1 NFIRST/.FALSE./  C  C        IF(NFIRST)GO TO 100 A C================================================================ A C==   First time through this subroutine.                      == A C==   Set up the character translation table to translate all  == A C==   upper case ASCII characters to lower case.               == A C================================================================        NFIRST=.TRUE.        DO 10 I=0,255 B       TABLE(I)=CHAR(I)            ! Most characters are unchanged. 10    CONTINUE       DO 20 I=65,90 G       TABLE(I)=CHAR(I+32)         ! 0 parity upper case --> lower case. G       TABLE(I+128)=CHAR(I+128+32) ! 1 parity upper case --> lower case.  20    CONTINUE C  C  100   LEN1=LEN(LINE)       LEN2=LEN(LOWER_CASE)       DO 30 I=1,MIN(LEN1,LEN2)?       LOWER_CASE(I:I)=TABLE(ICHAR(LINE(I:I))) ! Translate line.  30    CONTINUE1       IF(LEN2.GT.LEN1)LOWER_CASE(LEN1+1:LEN2)=' '        RETURN	       END 