:       SUBROUTINE MATCH(KEY,LEN,TABLE,MTABLE,NTABLE,MAXLEN,      # IMATCH,NMATCH,NWILD,*) A C================================================================ A C== MATCH: THIS ROUTINE RETURNS THE INDICES OF AN INPUT ARRAY  == A C== OF CHARACTER STRINGS THAT MATCH THE SPECIFIED KEYWORD. THIS== A C== KEYWORD MAY INCLUDE AN ARBITRARY NUMBER OF WILD-CARD       == A C== CHARACTERS("?").                                           == A C==                                                            == A C== INPUT PARAMETERS:                                          == A C==  KEY: THE INPUT STRING TO BE COMPARED WITH THE TABLE ENTRIES= A C==       FOR A POSSIBLE MATCH. IT MAY CONTAIN AN ARBITRARY    == A C==       NUMBER OF WILD CARD CHARACTERS ("?").                == A C==  LEN: LENGTH OF THE INPUT STRING "KEY"                     == A C==  TABLE: AN ARRAY OF CHARACTER STRINGS AGAINST WHICH THE TEST= A C==         STRING "KEY" WILL BE COMPARED FOR POSSIBLE MATCHES.== A C==  MTABLE: THE LENGTH (NUMBER OF CHARACTERS) OF EACH ENTRY   == A C==          (IE., EACH ELEMENT) OF "TABLE".                   == A C==  NTABLE: THE TOTAL NUMBER OF TABLE ENTRIES.                == A C==  MAXLEN: USED FOR DIMENSIONING OF ARRAY "TABLE", AND MUST BE= A C==          GREATER THAN OR EQUAL TO THE LENGTH OF THE LONGEST== A C==          TABLE ENTRY. THE ARRAY "TABLE" IS DIMENSIONED     == A C==          LOGICAL*1  TABLE(MAXLEN,NTABLE) .                 == A C==                                                            == A C== OUTPUT PARAMETERS:                                         == A C==  IMATCH: AN INTEGER ARRAY OF INDICES POINTING TO THE TABLE == A C==          ENTRIES THAT MATCHED THE TEST STRING "KEY".       == A C==  NMATCH: THE NUMBER OF TABLE ENTRIES THAT MATCHED THE TEST == A C==          STRING "KEY".                                     == A C==  NWILD: THE NUMBER OF WILD CARD CHARACTERS ("?") FOUND IN  == A C==         THE TEST STRING "KEY".                             == A C==                                                            ==IA C================================================================NA C=================================================================-       LOGICAL*1 KEY(LEN),TABLE(MAXLEN,NTABLE)N       LOGICAL EQCMPA4       INTEGER IPOS(20),IMATCH(NTABLE),MTABLE(NTABLE)A C================================================================FA C== FIRST, DETERMINE THE NUMBER AND POSITIONS OF (IF ANY) WILD == A C== CARD CHARACTERS PRESENT IN THE STRING "KEY".               == A C== THE NUMBER OF WILD CHARACTERS FOUND IS ACCUMULATED IN      == A C== "NWILD", AND THEIR POSITIONS IN THE ARRAY "POS".           ==HA C================================================================N       NMATCH=0
       NWILD=0 
       IFIND=0C    10 ISTART=IFIND+1       IF(ISTART.GT.LEN) GOTO 15G5       CALL FINDC(KEY,LEN,'?',1,ISTART,IFIND,IDUM,&15)=       NWILD=NWILD+1        IF(NWILD.GT.20) RETURN 1       IPOS(NWILD)=IFINDT
       GOTO 10 A C================================================================EA C== CHECK EACH ENTRY IN THE TABLE OF CHARACTER STRINGS FOR A   ==NA C== POSSIBLE MATCH WITH THE INPUT STRING "KEY".                == A C================================================================O    15 DO 20 I=1,NTABLEA C================================================================HA C== THE FIRST REQUIREMENT FOR A VALID MATCH IS THAT THE CHAR-  ==IA C== ACTER FIELD LEFT OF THE FIRST WILD CHARACTER IN "KEY" MUST == A C== EXACTLY MATCH (IN POSITION) THE CORRESPONDING FIELD IN THE == A C== TABLE ENTRY BEING TESTED. IF THERE IS NO WILD CHARACTER    == A C== PRESENT IN "KEY", THEN THE ENTIRE STRING IN "KEY" MUST MATCH=TA C== THE TABLE ENTRY. IF THE FIELD LEFT OF THE FIRST WILD       ==YA C== CHARACTER IS NULL (IE., "KEY" BEGINS WITH A "?"), THEN NO  == A C== CONDITION IS IMPOSED UPON THE TABLE ENTRY AND ANY STRING   == A C== WILL BE CONSIDERED A MATCH AT THIS STAGE.                  ==FA C================================================================        NCHAR1=LEN%       IF(NWILD.GT.0) NCHAR1=IPOS(1)-1        IFIRST=1+NCHAR1        IF(NCHAR1.EQ.0) GOTO 25=6       IF(.NOT.EQCMP(NCHAR1,KEY(1),TABLE(1,I))) GOTO 20       IF(NWILD.GT.0) GOTO 25"       IF(LEN.NE.MTABLE(I)) GOTO 20       NMATCH=NMATCH+1B       IMATCH(NMATCH)=I
       GOTO 20EA C=================================================================B C== AN ADDITIONAL REQUIREMENT IS THAT THE CHARACTER FIELD TO   == A C== THE RIGHT OF THE LAST WILD CHARACTER IN "KEY" MUST ALSO    ==NA C== MATCH (IN POSITION) THE CORRESPONDING FIELD IN THE TABLE   ==AA C== ENTRY.                                                     ==SA C=================================================================    25 NCHAR2=LEN-IPOS(NWILD) =       ILAST=MTABLE(I)-NCHAR2       IF(NCHAR2.EQ.0) GOTO 351-       IF(.NOT.EQCMP(NCHAR2,KEY(LEN-NCHAR2+1),1$      # TABLE(MTABLE(I)-NCHAR2+1,I)))      # GOTO 20A C================================================================PA C== CONFIRM THAT THESE LEFT AND RIGHT MATCHING FIELDS FOUND IN ===A C== "MTABLE(I)" ARE DISJOINT, IE. NO CHARACTERS ARE INCLUDED IN== A C== BOTH MATCHES.                                              == A C=================================================================0       IF(MTABLE(I)-NCHAR2+1 .LE. NCHAR1) GOTO 20A C=================================================================A C== NOW CHECK (SCANNING LEFT TO RIGHT) IF CHARACTER FIELDS     ==RA C== IMBEDDED BETWEEN TWO WILD CARD CHARACTERS IN "KEY", MATCH  ==UA C== THE TABLE ENTRY.                                           ==TA C================================================================     35 NFIELD=NWILD-1       IF(NFIELD.GT.0) GOTO 40I       NMATCH=NMATCH+1=       IMATCH(NMATCH)=I
       GOTO 20 A C================================================================WA C== IN THIS CASE, THERE ARE MORE THAN 2 WILD CARD CHARACTERS,  ==NA C== AND SO THE INTERNAL FIELDS BETWEEN THSES "?" CHARACTERS    ==AA C== MUST ALSO BE MATCHED.                                      ===A C================================================================H    40 DO 30 K=1,NFIELD!       IF(IFIRST.GT.ILAST) GOTO 200       NCHAR=IPOS(K+1)-IPOS(K)-1C?       CALL FINDST(TABLE(1,I),ILAST,KEY(IPOS(K)+1),NCHAR,IFIRST,       # IFIND,&20)E       IFIRST=IFIND+NCHAR    30 CONTINUE       NMATCH=NMATCH+1        IMATCH(NMATCH)=I    20 CONTINUE       RETURN	       END=