B       SUBROUTINE MATCH2(KEY,LEN,WILDCH,TABLE,MTABLE,NTABLE,MAXLEN,      # IMATCH,NMATCH,NWILD,*) A C================================================================ A C== MATCH2: This routine returns the indices of an input array == A C== of character strings that match the specified keyword. This== A C== keyword may include an arbitrary number of wild-card       == A C== characters WILDCH (normally "*" or "?"). This routine differs A C== from MATCH since that routine always assumes the wild card == A C== character is a question mark "?".                          == A C==                                                            == A C== INPUT PARAMETERS:                                          == A C==  KEY: The input string to be compared with the table entries= A C==       for a possible match. It may contain an arbitrary    == A C==       number of wild card characters WILDCH.               == A C==  LEN: Length of the input string KEY                       == A C==  WILDCH: A single byte (LOGICAL*1) containing the wild card== A C==          character.                                        == A C==  TABLE: An array of character strings against which the test= A C==         string KEY will be compared for possible matches.  == A C==  MTABLE: The length (number of characters) of each entry   == A C==          (ie., each element) of TABLE.                     == A C==  NTABLE: The total number of TABLE entries.                == A C==  MAXLEN: Used for dimensioning of array TABLE, and must be == A C==          greater than or equal to the length of the longest== A C==          TABLE entry. the array TABLE is dimensioned       == A C==          LOGICAL*1  TABLE(MAXLEN,NTABLE) .                 == A C==                                                            == A C== OUTPUT PARAMETERS:                                         == A C==  IMATCH: An integer array of indices pointing to the TABLE == A C==          entries that matched the test string KEY.         == A C==  NMATCH: The number of TABLE entries that matched the test == A C==          string KEY.                                       == A C==  NWILD: The number of wild card characters WILDCH found in == A C==         the test string KEY.                               == A C==                                                            == A C================================================================ A C================================================================ ;       LOGICAL*1 KEY(LEN),TABLE(MAXLEN,MAX(1,NTABLE)),WILDCH        LOGICAL EQCMP B       INTEGER IPOS(20),IMATCH(MAX(1,NTABLE)),MTABLE(MAX(1,NTABLE))A C================================================================ A C== FIRST, DETERMINE THE NUMBER AND POSITIONS OF (IF ANY) WILD == A C== CARD CHARACTERS PRESENT IN THE STRING "KEY".               == A C== THE NUMBER OF WILD CHARACTERS FOUND IS ACCUMULATED IN      == A C== "NWILD", AND THEIR POSITIONS IN THE ARRAY "POS".           == A C================================================================        NMATCH=0
       NWILD=0 
       IFIND=0     10 ISTART=IFIND+1       IF(ISTART.GT.LEN) GOTO 15 8       CALL FINDC(KEY,LEN,WILDCH,1,ISTART,IFIND,IDUM,&15)       NWILD=NWILD+1        IF(NWILD.GT.20) RETURN 1       IPOS(NWILD)=IFIND 
       GOTO 10 A C================================================================ A C== CHECK EACH ENTRY IN THE TABLE OF CHARACTER STRINGS FOR A   == A C== POSSIBLE MATCH WITH THE INPUT STRING "KEY".                == A C================================================================     15 DO 20 I=1,NTABLEA C================================================================ A C== THE FIRST REQUIREMENT FOR A VALID MATCH IS THAT THE CHAR-  == A C== ACTER FIELD LEFT OF THE FIRST WILD CHARACTER IN "KEY" MUST == A C== EXACTLY MATCH (IN POSITION) THE CORRESPONDING FIELD IN THE == A C== TABLE ENTRY BEING TESTED. IF THERE IS NO WILD CHARACTER    == A C== PRESENT IN "KEY", THEN THE ENTIRE STRING IN "KEY" MUST MATCH= A C== THE TABLE ENTRY. IF THE FIELD LEFT OF THE FIRST WILD       == A C== CHARACTER IS NULL (IE., "KEY" BEGINS WITH "WILDCH"), THEN NO=TA C== CONDITION IS IMPOSED UPON THE TABLE ENTRY AND ANY STRING   ===A C== WILL BE CONSIDERED A MATCH AT THIS STAGE.                  ==CA C================================================================c       NCHAR1=LEN%       IF(NWILD.GT.0) NCHAR1=IPOS(1)-1        IFIRST=1+NCHAR1d       IF(NCHAR1.EQ.0) GOTO 25a6       IF(.NOT.EQCMP(NCHAR1,KEY(1),TABLE(1,I))) GOTO 20       IF(NWILD.GT.0) GOTO 25"       IF(LEN.NE.MTABLE(I)) GOTO 20       NMATCH=NMATCH+1=       IMATCH(NMATCH)=I
       GOTO 20"A C================================================================ B C== AN ADDITIONAL REQUIREMENT IS THAT THE CHARACTER FIELD TO   == A C== THE RIGHT OF THE LAST WILD CHARACTER IN "KEY" MUST ALSO    ==mA C== MATCH (IN POSITION) THE CORRESPONDING FIELD IN THE TABLE   ==mA C== ENTRY.                                                     ==cA C================================================================g    25 NCHAR2=LEN-IPOS(NWILD)         ILAST=MTABLE(I)-NCHAR2       IF(NCHAR2.EQ.0) GOTO 35r-       IF(.NOT.EQCMP(NCHAR2,KEY(LEN-NCHAR2+1), $      # TABLE(MTABLE(I)-NCHAR2+1,I)))      # GOTO 20A C================================================================ A C== CONFIRM THAT THESE LEFT AND RIGHT MATCHING FIELDS FOUND IN ==mA C== "MTABLE(I)" ARE DISJOINT, IE. NO CHARACTERS ARE INCLUDED IN==mA C== BOTH MATCHES.                                              ==eA C================================================================s0       IF(MTABLE(I)-NCHAR2+1 .LE. NCHAR1) GOTO 20A C================================================================ A C== NOW CHECK (SCANNING LEFT TO RIGHT) IF CHARACTER FIELDS     == A C== IMBEDDED BETWEEN TWO WILD CARD CHARACTERS IN "KEY", MATCH  == A C== THE TABLE ENTRY.                                           ==TA C================================================================C    35 NFIELD=NWILD-1       IF(NFIELD.GT.0) GOTO 40=       NMATCH=NMATCH+1s       IMATCH(NMATCH)=I
       GOTO 20 A C================================================================eA C== IN THIS CASE, THERE ARE MORE THAN 2 WILD CARD CHARACTERS,  == A C== AND SO THE INTERNAL FIELDS BETWEEN THESE CHARACTERS        == A C== MUST ALSO BE MATCHED.                                      == A C================================================================     40 DO 30 K=1,NFIELD!       IF(IFIRST.GT.ILAST) GOTO 20=       NCHAR=IPOS(K+1)-IPOS(K)-1=?       CALL FINDST(TABLE(1,I),ILAST,KEY(IPOS(K)+1),NCHAR,IFIRST,       # IFIND,&20)E       IFIRST=IFIND+NCHAR    30 CONTINUE       NMATCH=NMATCH+1S       IMATCH(NMATCH)=I    20 CONTINUE       RETURN	       END=