A       SUBROUTINE METAFILE1_ON(FILE,AGE,TITLE,LUN,ISTAT1,ISTAT2,*)  C & C     reqd. KOSTL: routines - PUTMETA1 C H C=======================================================================H C     METAFILE1_ON opens a metafile to receive graphics output generatedH C     by the PLOT_R routines (PLOT_R and the routines it invokes,  PSYM,H C     PLOT_COLOR).  Graphics output is stored  in  Telidon  format  (seeH C     Preliminary  Standard  T500-1982,  Videotex/Teletext  PresentationH C     Level Protocol  Syntax,  Canadian  Standards  Association,  AugustH C     1982),   with  the  exception  that  Telidon  Picture  DescriptionH C     Instructions are delimited by an ASCII carriage return  character. C H C     After  calling  METAFILE1_ON,  subsequent  calls  to  the   PLOT_RH C     routines automatically insert Telidon Picture Discription Instruc-H C     tions (PDIs) into the metafile.  When METAFILE1_OFF is called  theH C     metafile is closed and the  PLOT_R  routines  no  longer  generateH C     Telidon PDIs.  The graphics information that is  inserted  in  theH C     metafile  between  calls   to   METAFILE1_ON   and   METAFILE1_OFF% C     constitutes a metafile "frame".  C H C     If METAFILE1_ON is called a second time  before  METAFILE1_OFF  isF C     called, the old metafile is closed and a new metafile is opened. C H C     Instead of opening a new metafile for each frame, you may  insteadH C     create a new frame and append subsequent graphics PDIs to the  endH C     of an existing metafile by specifying the AGE input  parameter  as C     'OLD'. C  C     Input arguments: C     ----- ---------  C  C     FILE     CHARACTER*(*)H C                   -- file specification of  metafile  to  receive  theH C                      output graphics PDIs.  Missing components of  theH C                      file specification  will  be  supplied  from  theH C                      caller's default device and directory,  and  from: C                      the default file name METAFILE.MET.H C                      Suppose, for example, that the  caller's  defaultH C                      device and directory are  DSK1:[GLOP].   Then  ifH C                      FILE  =  ' ',  the   metafile   will   be   namedH C                      DSK1:[GLOP]METAFILE.MET.   If  FILE = '[.K].DAT',F C                      the metafile will be DSK1:[GLOP.K]METAFILE.DAT. C  C     AGE      CHARACTER*(*)E C                   -- a string that specifies either 'NEW' or 'OLD'. @ C                      If AGE = 'NEW', a new metafile is opened.H C                      If AGE = 'OLD', an existing  metafile  is  openedH C                      and graphics information is appended to  the  end' C                      of the metafile.  C  C     TITLE    CHARACTER*(*)H C                   -- an arbitrary title string that  is  placed  in  aH C                      block of header  records  at  the  start  of  the* C                      the metafile frame. C  C     LUN      INTEGER*4I C                   -- the Fortran logical unit number to  be  used  for  . C                      output to the metafile.H C                      If LUN < 0 a free  Fortran  logical  unit  numberH C                      in the range 30 to 99 will be used for output  toH C                      the metafile.  On return from  METAFILE1_ON,  LUNH C                      will contain the unit number  used  for  metafileH C                      output.  Thus if METAFILE1_ON is  to  select  theI C                      output unit number, a negative  integer  must  be  H C                                                               ----  --H C                      passed to METAFILE1_ON in a variable rather  than; C                      ------ -- ------------ -- - -------- " C                      a constant. C  C  C     Output arguments:  C     ------ --------- C  C     LUN      INTEGER*4H C                   -- contains the Fortran logical unit number used for. C                      output to the metafile. C  C     ISTAT1   INTEGER*4# C                   -- status code:R= C                      ISTAT1 = 0   -- successful completion. H C                             = 1   -- the unit number  specified  by  aH C                                      positive input value  of  LUN  is0 C                                      not free;D C                                      alternate error return taken.H C                             = 2   -- AGE status incorrectly specified;D C                                      alternate error return taken.H C                             = 3   -- could not open metafile  (invalidH C                                      file  specification,   file   notC C                                      found if AGE = 'OLD', etc.);eD C                                      alternate error return taken.H C                             = 4   -- could not write to open  metafile> C                                      (disk quota exceeded?);D C                                      alternate error return taken.H C                             = 5   -- invalid unit number (input  value4 C                                      of LUN > 99);D C                                      alternate error return taken.B C                             = 6   -- no free logical units > 29;D C                                      alternate error return taken. Cn C     ISTAT2   INTEGER*4H C                   -- If ISTAT1 = 3, ISTAT2 contains the condition codeH C                      that was signalled by VMS when  an  open  failureD C                      occurred.  Otherwise ISTAT2 is returned as 1. Cs C / C     Author:  Alan Carruthers, August 31, 1983- C     ------ C H C=======================================================================,       CHARACTER FILE*(*), AGE*(*), TITLE*(*)!       CHARACTER AGE1*3, FNAME*255n(       CHARACTER USERNAME*12, DATETIME*23       INTEGER ITMLST(4)l       LOGICAL ON, OPENED&       DATA META_LUN /-1/, ON /.FALSE./%       COMMON /METAFILE1/ ON, META_LUN  C  C : C     If metafile is already active close active metafile.>       IF(ON .OR. (META_LUN .GE. 0)) CALL METAFILE1_OFF(IDUMMY) C        ISTAT1 = 0       META_LUN = -1r       AGE1 = ' 'C       L = LIB$SKPC(' ',AGE)  !find first non-blank character in AGE        IF(L .EQ. 0) GO TO 80 ;       CALL STR$UPCASE(AGE1,AGE(L:))  !convert to upper case  C 8       IF ((AGE1 .EQ. 'NEW') .OR. (AGE1 .EQ. 'OLD')) THEN          IF(LUN .GE. 0) THEN3             INQUIRE(UNIT=LUN,OPENED=OPENED,ERR=160)i             IF(OPENED) THEN ; C              Error -- specified logical unit is not free..                ISTAT1 = 1                 RETURN 1              END IF
          ELSE ) C           Find a free logical unit > 29e             LUN = 29    20       LUN = LUN + 1a3             INQUIRE(UNIT=LUN,OPENED=OPENED,ERR=180)              IF(OPENED) GO TO 20i          END IFe          META_LUN = LUN  C $ C        Get full file specificationA          INQUIRE(FILE=FILE,DEFAULTFILE='METAFILE.MET',NAME=FNAME)  CU! C        Attempt to open metafile !          IF(AGE1 .EQ. 'NEW') THENr= C           If FNAME file specification has a version number,fB C           locate the position of the version number in the FNAMED C           string so that it will not be passed to META1_OPEN_FILE.$             L = INDEX(FNAME,';') - 1'             IF(L .LT. 0) L = LEN(FNAME)_<             ISTAT2 = META1_OPEN_FILE(.TRUE.,.FALSE.,.FALSE.,*      >                 META_LUN,FNAME(:L))@ C                      FNAME substring passed to META1_OPEN_FILE6 C                      does not include version number
          ELSE <             ISTAT2 = META1_OPEN_FILE(.FALSE.,.FALSE.,.TRUE.,&      >                 META_LUN,FNAME)          END IFa#          IF(.NOT. ISTAT2) GO TO 100           ON = .TRUE. C I C        Write ASCII "shift in" character to metafile to cause subsequentg> C        header records to be interpreted as normal ASCII text<          CALL PUT_METAFILE1(META_LUN,'SI',0.,0.,0,IERR,*140) Cs( C        Get username of current process2          ITMLST(1) = '0202FFFF'X .AND. 'FFFF000C'X0 C                     ----                     -F C                     item code                size of username buffer# C                     for user name #          ITMLST(2) = %LOC(USERNAME)           ITMLST(3) = 0          ITMLST(4) = 0&          CALL SYS$GETJPI(,,,ITMLST,,,) C; C        Get time and date%          CALL LIB$DATE_TIME(DATETIME)e C . C        Write header information to metafile:% C          1) type of metafile format  C          2) user namea C          3) date and time  C          4) title =          WRITE(META_LUN,30,ERR=140) USERNAME, DATETIME, TITLE     30    FORMAT('++ BEGIN'/l"      >          '   BEGIN HEADER'/*      >          '   METAFILE TYPE 01.001'/!      >          '   USERNAME ',A/       >          '   TIME ',A/a#      >          '   BEGIN TITLE'/A/       >          '   END TITLE'/t       >          '   END HEADER'/      >          '++ END')  C(F C        Write ASCII "shift out" character to cause subsequent records6 C        in metafile to be interpreted as Telidon PDIs<          CALL PUT_METAFILE1(META_LUN,'SO',0.,0.,0,IERR,*140) C . C        Write Telidon initialization sequenceB          CALL PUT_METAFILE1(META_LUN,'INITIALI',0.,0.,0,IERR,*140)
       ELSE          GO TO 80g       END IF       RETURN C ; C     Error -- Status of metafile is incorrectly specified; 4 C              file to be opened must be NEW or OLD.    80 CONTINUE       ISTAT1 = 2       RETURN 1 C ' C     Error -- could not open metafile.e   100 CONTINUE       ISTAT1 = 3       META_LUN = -1        RETURN 1 C 2 C     Error -- could not write to opened metafile.   140 CONTINUE       ISTAT1 = 4%       CLOSE(META_LUN,STATUS='DELETE')=       META_LUN = -1=       ON = .FALSE.       RETURN 1 C(1 C     Error -- specified logical unit is invalid.M   160 CONTINUE       ISTAT1 = 5       RETURN 1 C % C     Error -- no free logical units.    180 CONTINUE       ISTAT1 = 6       META_LUN = -1O       RETURN 1	       ENDU C  C  C (       SUBROUTINE METAFILE1_OFF(ISTAT1,*)H C=======================================================================H C     METAFILE1_OFF closes a metafile  that  was  previously  opened  byH C     a call to METAFILE1_ON.  When METAFILE1_OFF is called the metafileH C     is closed and the PLOT_R routines no longer generate Telidon PDIs.H C     The graphics information that is inserted in the metafile  betweenH C     calls to METAFILE1_ON and  METAFILE1_OFF  constitutes  a  metafile C     "frame". C  C     Output arguments:  C     ------ --------- Co C     ISTAT1   INTEGER*4# C                   -- status code: = C                      ISTAT1 = 0   -- successful completion. ; C                             = 1   -- no metafile is open; D C                                      alternate error return taken.H C                             = 2   -- could   not   write   terminating: C                                      record to metafile;D C                                      alternate error return taken. Ct Ct/ C     Author:  Alan Carruthers, August 31, 1983T C     ------ C H C=======================================================================       LOGICAL ON, OPENED%       COMMON /METAFILE1/ ON, META_LUNs Ch Ci       ISTAT1 = 0 Ct       IF(ON) THEN 5          INQUIRE(UNIT=META_LUN,OPENED=OPENED,ERR=100).          IF(OPENED) THEN C C C           Write ASCII "shift in" character to metafile to delimit  C           end of Telidon PDIs ?             CALL PUT_METAFILE1(META_LUN,'SI',0.,0.,0,IERR,*120)  C  C           Close metafile              CLOSE(UNIT=META_LUN)             ON = .FALSE.             META_LUN = -1.             RETURN C 
          ELSEUH C           Error -- logical unit (to which metafile should be attached)! C                    is not open.CE C                    This would occur if metafile was already closed.e             ISTAT1 = 1             RETURN 1          END IF 
       ELSE% C        Error -- no active metafile.           ISTAT1 = 1           RETURN 1        END IF C). C     Error -- logical unit number is invalid.? C              This would occur if metafile was already closed.d   100 CONTINUE       ISTAT1 = 1       RETURN 1 C 2 C     Error -- could not write record to metafile.   120 CONTINUE       ISTAT1 = 2       RETURN 1 C)	       END  CC C G C======================================================================IE       INTEGER FUNCTION META1_OPEN_FILE(NEW,READONLY,APPEND,LUN,FNAME)l       EXTERNAL LIB$SIG_TO_RETi       CHARACTER*(*) FNAMEs#       LOGICAL NEW, READONLY, APPEND  C *       META1_OPEN_FILE = 1  !assume success CE@ C     Establish condition handler to handle any error conditions/ C     that occur while attempting to open file. B C     Any signalled error condition is converted by LIB$SIG_TO_RET< C     to a function value that META1_OPEN_FILE returns with.A C     See pp. 2-107 to 2-108 of VAX-11 Run-Time Library ReferenceD
 C     Manual. (       CALL LIB$ESTABLISH(LIB$SIG_TO_RET) Ch       IF(NEW) THEN/          OPEN(UNIT=LUN,FILE=FNAME,STATUS='NEW',t%      >        CARRIAGECONTROL='LIST') 
       ELSE          IF(READONLY) THEN2             OPEN(UNIT=LUN,FILE=FNAME,STATUS='OLD',      >           READONLY)
          ELSE(             IF(APPEND) THENE5                OPEN(UNIT=LUN,FILE=FNAME,STATUS='OLD', +      >              CARRIAGECONTROL='LIST',t$      >              ACCESS='APPEND')             ELSE5                OPEN(UNIT=LUN,FILE=FNAME,STATUS='OLD',S+      >              CARRIAGECONTROL='LIST')c             END IF          END IFN       END IF       RETURN	       END-