F       SUBROUTINE MONITOR_RANGE(IMONITOR,IOUTM,XMINH,XMAXH,YMINH,YMAXH,B      *                         XMINM,XMAXM,YMINM,YMAXM,IORIENTM,*)H C======================================================================CH C                                                                      CH C  MONITOR_RANGE takes a window of the internal (printronix, or        CH C  "hardcopy") bit map and viewports it into the monitor (usually      CH C  the screen).                                                        CH C                                                                      CH C  More specifically, MONITOR_RANGE defines the window of the          CH C  hardcopy:  XMINH <= XH <= XMAXH; YMINH <= YH <= YMAXH (dots),       CH C  which is to be displayed on the monitor screen in the monitor       CH C  viewport given by:  XMINM <= XM <= XMAXM; YMINM <= YM <= YMAXM,     CH C  with an orientation given by IORIENTM:                              CH C                                                                      CH C    IORIENTM= 1: XH is horizontal on the screen;                      CH C                 YH is vertical on the screen;                        CH C                 The point (XMINH,YMINH) of the hardcopy appears in   CH C                 the lower left hand corner of the monitor viewport   CH C            =-1: XH is vertical on the screen;                        CH C                 YH is horizontal on the screen;                      CH C                 the point (XMINH,YMINH) of the hardcopy appears in   CH C                 the upper left hand corner of the monitor viewport   CH C                                                                      CH C  There are no limits on the values of XMINH,XMAXH,YMINH, and YMAXH,  CH C  although the hardcopy can only exist on the printronix page which   CH C  has a range in dots given by:  0 <= XH <= 2047; 0 <= YH <= 785.     CH C  However the values of XMINM,XMAXM,YMINM,YMAXM are limited to the    CH C  range:  0 <= XM <= XMAXMSIZE; 0 <= YM <= YMAXMSIZE,                 CH C  where XMAXMSIZE and YMAXMSIZE depend on the type of monitor         CH C  specified by IMONITOR:                                              CH C                                                                      CH C  IMONITOR = 0: no monitor,                                           CH C           = 1: VT640: 0 <= XM <= 639; 0 <= YM <= 479                 CH C           = 2: Tektronix 4010/12: X 0-1023, Y 0-779                  CH C           = 3: VS11: 0 <= XM <= 511; 0 <= YM <= 479                  CH C           = 4: Zeta Plotter: X 0-215.9, Y 0-27.94                    CH C           = 5: HP Plotter: X 0-41.49, Y 0-25.84                      CH C           = 6: CIT-467: 0<= XM <= 571; 0<= YM <= 479                 CH C           = 7: TEK4107: 0<= XM <= 639; 0<= YM <= 479                 CH C           = 8: VT241: 0 <= XM <= 639; 0 <= YM <= 479                 CH C           = 9: PT100: 0 <= XM <= 639; 0 <= YM <= 479                 CH C           =10: QMS: 0 <= XM <= 3300; 0 <= YM <= 2550                 CH C           =11: Houston plotter: X 0-86.36, Y 0-54.61                 CH C           =12: Seiko GR-1105: X -2048 - 2047, Y -1560 - 1559         CH C           =13: Imagen: 0 <= XM <= 3328; 0 <= YM <= 2560              C/ C           =14: Postscript: X 0-3276, Y 0-2399 H C           =15: VAXSTATION: X 0-1,    y 0-1                           CH C           =16: LN03+: 0 <= XM <= 639; 0 <= YM <= 479                 CH C                                                                      CH C  If the values of XMINM,XMAXM,YMINM,YMAXM fall outside the monitor   CH C  screen size then they will be set to the nearest limit. If IMONITOR CH C  is invalid then an error message is printed on unit 6 and a RETURN1 CH C  is performed. If any of the sides of the "HARDCOPY" window or       CH C  "MONITOR" window are equal to 0 (eg. XMINH=XMAXH), then an error    CH C  message is printed on unit 6 and a RETURN1 is performed.            CH C                                                                      CH C  IOUTM is the output unit to which the screen plot characters will   CH C  be written.                                                         CH C                                                                      CH C   Input  Parameters: IMONITOR,IOUTM (I*4); XMINH,XMAXH,              CH C                      YMINH,YMAXH,XMINM,XMAXM,YMINM,YMAXM             CH C                      (R*4); IORIENTM (I*4).                          CH C                                                                      CH C   If MONITOR_RANGE is never called these parameters default to the   CH C   following values:                                                  CH C     IMONITOR=1 (VT640); IOUTM=6;                                     CH C     XMINH,XMAXH,YMINH,YMAXH default to the entire hardcopy           CH C     viewport specified by HARDCOPY_RANGE, i.e. the values of         CH C     XMINH,XMAXH,YMINH,YMAXH in the last call to HARDCOPY_RANGE;      CH C     0=XMINM <= XM <= XMAXM=639; 0=YMINM <= YM <= YMAXM=479;          CH C     IORIENTM defaults to -1.                                         CH C                                                                      CH C   Written by Arthur Haynes, TRIUMF U.B.C., July 16, 1982.            CH C                                                                      CH C   Modified by Joe Chuma, December, 1983 to include the HP            CH C   plotter                                                            CH C   Modified by Bernard Henin, july 1984, to include the               CH C   Tektronix 4107.                                                    CH C   Modified by F.W. Jones, August/84, to include the VT241.           CH C   Modified by F.W. Jones, Oct 7/85, to include the PT100.            CH C   Modified by F.W. Jones, Dec 5/85, for QMS Lasergrafix.             CH C   Modified by F.W. Jones, Aug 11/86, for Houston Instuments plotter. CH C   Modified by F.W. Jones, Mar 20/87, for Seiko GR-1105 terminal.     CH C   Modified by F.W. Jones, Jun   /88, for Vaxstation                  CH C   Modified by J.Chuma, Nov /88, for LN03+                            CH C                                                                      CH C======================================================================C  ,       COMMON /PLOT_MONITOR/ IMONITOR2,IOUTM2        DATA IMONITOR2,IOUTM2/1,6/G       COMMON /MONITOR_RANGE/ XMINMP,XMAXMP,YMINMP,YMAXMP,XMINM2,XMAXM2, *      *                       YMINM2,YMAXM27       DATA XMINMP,XMAXMP,YMINMP,YMAXMP/0.,639.,0.,479./ 7       DATA XMINM2,XMAXM2,YMINM2,YMAXM2/0.,639.,0.,479./ C       COMMON /MONITOR_RANGE2/ XMINH2,XMAXH2,YMINH2,YMAXH2,IORIENTM2 7       DATA XMINH2,XMAXH2,YMINH2,YMAXH2/0.,479.,0.,639./        DATA IORIENTM2/-1/7       DATA XMINH2,XMAXH2,YMINH2,YMAXH2/0.,479.,0.,639./ C       COMMON /MONITOR_SIZE/ XMINMSIZE,XMAXMSIZE,YMINMSIZE,YMAXMSIZE C       DATA XMINMSIZE,XMAXMSIZE,YMINMSIZE,YMAXMSIZE/0.,639.,0.,479./ 8       COMMON /PLOT_TO_MONITOR/ RMATRIXMP(2,2),SHIFTMP(2)0       DATA RMATRIXMP/1.,0.,0.,1./,SHIFTMP/0.,0./8       COMMON /MONITOR_TO_PLOT/ RMATRIXPM(2,2),SHIFTPM(2)0       DATA RMATRIXPM/1.,0.,0.,1./,SHIFTPM/0.,0./<       COMMON /HARDCOPY_TO_MONITOR/ RMATRIXMH(2,2),SHIFTMH(2)3       DATA RMATRIXMH/0.,-1.,1.,0./,SHIFTMH/0.,479./ 9       COMMON /PLOT_TO_HARDCOPY/ RMATRIXHP(2,2),SHIFTHP(2) 3       DATA RMATRIXHP/0.,1.,-1.,0./,SHIFTHP/479.,0./ 6       COMMON /CALL_MONITOR_RANGE/ MONITOR_RANGE_CALLED+       LOGICAL MONITOR_RANGE_CALLED/.FALSE./ *       REAL XMINMA(0:16)/12*0.,-2048.,4*0./*       REAL YMINMA(0:16)/12*0.,-1560.,4*0./7       REAL XMAXMA(0:16)/0.,639.,1023.,511.,215.9,41.49, G      #       571.,639.,639.,639.,3300.,86.36,2047.,3328.,3275.,1.,639./ 6       REAL YMAXMA(0:16)/0.,479.,779.,479.,27.94,25.84,G      #       479.,479.,479.,479.,2550.,54.61,1559.,2560.,2399.,1.,479./  C H C======================================================================C C  Procedure begins.H C======================================================================C>       IF(IMONITOR2 .EQ. 3 .AND. IMONITOR .NE. 3)CALL VSRELEASE       IMONITOR2=IMONITOR       IORIENTM2=IORIENTM       XMINH2=XMINH       XMAXH2=XMAXH       YMINH2=YMINH       YMAXH2=YMAXH9       IF(IMONITOR.EQ.0)RETURN !If no monitor then return. B C=================================================================@ C   Check the monitor type.                                   ==B C=================================================================7       IF(IMONITOR .GE. 1 .AND. IMONITOR .LE. 16)GO TO 8        WRITE(6,5)IMONITORE 5     FORMAT(' ***Error*** in MONITOR_RANGE: Invalid monitor type: ',       *       I5)
       RETURN1 ! 8     MONITOR_RANGE_CALLED=.TRUE. B C=================================================================@ C   Set the monitor size parameters.                          ==B C=================================================================        XMINMSIZE=XMINMA(IMONITOR)        XMAXMSIZE=XMAXMA(IMONITOR)        YMINMSIZE=YMINMA(IMONITOR)        YMAXMSIZE=YMAXMA(IMONITOR)       IOUTM2=IOUTMB C=================================================================@ C   Make sure that the monitor viewport is within the monitor ==@ C   screen dimensions.                                        ==B C=================================================================0       XMINM2=MAX(MIN(XMINM,XMAXMSIZE),XMINMSIZE)0       XMAXM2=MAX(MIN(XMAXM,XMAXMSIZE),XMINMSIZE)0       YMINM2=MAX(MIN(YMINM,YMAXMSIZE),YMINMSIZE)0       YMAXM2=MAX(MIN(YMAXM,YMAXMSIZE),YMINMSIZE)C C================================================================== A C   Make sure that none of the sides of the window and         == A C   viewport are 0.                                            == C C==================================================================        IF(XMINM2.EQ.XMAXM2)THEN          WRITE(6,1) @ 1        FORMAT(' ***Error*** in MONITOR_RANGE: XMINM = XMAXM.')          RETURN1       END IF       IF(YMINM2.EQ.YMAXM2)THEN          WRITE(6,2) @ 2        FORMAT(' ***Error*** in MONITOR_RANGE: YMINM = YMAXM.')          RETURN1       END IF       IF(XMINH.EQ.XMAXH)THEN          WRITE(6,3) @ 3        FORMAT(' ***Error*** in MONITOR_RANGE: XMINH = XMAXH.')          RETURN1       END IF       IF(YMINH.EQ.YMAXH)THEN          WRITE(6,4) @ 4        FORMAT(' ***Error*** in MONITOR_RANGE: YMINH = YMAXH.')          RETURN1       END IF       IORIENTM2=IORIENTM$       IF(IORIENTM2.NE.-1)IORIENTM2=1B C=================================================================@ C   Calculate the "HARDCOPY" to "MONITOR" transformation:     ==@ C                                                             ==@ C   FOR IORIENTM = 1:                                         ==@ C   XM = (XH-XMINH)/(XMAXH-XMINH)*(XMAXM-XMINM)+XMINM         ==@ C      = RMATRIXMH(1,1)*XH+RMATRIXMH(1,2)*YH+SHIFTMH(1).      ==@ C   YM = (YH-YMINH)/(YMAXH-YMINH)*(YMAXM-YMINM)+YMINM         ==@ C      = RMATRIXMH(2,1)*XH+RMATRIXMH(2,2)*YH+SHIFTMH(2).      ==@ C                                                             ==@ C   FOR IORIENTM = -1:                                        ==@ C   XM = (YH-YMINH)/(YMAXH-YMINH)*(XMAXM-XMINM)+XMINM         ==@ C      = RMATRIXMH(1,1)*XH+RMATRIXMH(1,2)*YH+SHIFTMH(1).      ==@ C   YM = YMAXM-(XH-XMINH)/(XMAXH-XMINH)*(YMAXM-YMINM)         ==@ C        RMATRIXMH(2,1)*XH+RMATRIXMH(2,2)*YH+SHIFTMH(2).      ==B C=================================================================!       IF(IORIENTM2.EQ.-1)GO TO 10 2       RMATRIXMH(1,1)=(XMAXM2-XMINM2)/(XMAXH-XMINH)       RMATRIXMH(1,2)=0.        RMATRIXMH(2,1)=0. 2       RMATRIXMH(2,2)=(YMAXM2-YMINM2)/(YMAXH-YMINH),       SHIFTMH(1)=XMINM2-RMATRIXMH(1,1)*XMINH,       SHIFTMH(2)=YMINM2-RMATRIXMH(2,2)*YMINH       GO TO 20 10    RMATRIXMH(1,1)=0. 2       RMATRIXMH(1,2)=(XMAXM2-XMINM2)/(YMAXH-YMINH)3       RMATRIXMH(2,1)=-(YMAXM2-YMINM2)/(XMAXH-XMINH)        RMATRIXMH(2,2)=0. ,       SHIFTMH(1)=XMINM2-RMATRIXMH(1,2)*YMINH,       SHIFTMH(2)=YMAXM2-RMATRIXMH(2,1)*XMINHB C=================================================================@ C   Calculate the transformation matrix RMATRIXMP from the    ==@ C   "PLOT" coordinate system to the "MONITOR" coordinate      ==@ C   system:                                                   ==@ C                                                             ==@ C   RMATRIXMP      = RMATRIXMH          * RMATRIXHP           ==@ C                                                             ==@ C   MONITOR<--PLOT = MONITOR<--HARDCOPY * HARDCOPY<--PLOT     ==B C=================================================================3 20    RMATRIXMP(1,1)=RMATRIXMH(1,1)*RMATRIXHP(1,1)+ 2      *               RMATRIXMH(1,2)*RMATRIXHP(2,1)3       RMATRIXMP(1,2)=RMATRIXMH(1,1)*RMATRIXHP(1,2)+ 2      *               RMATRIXMH(1,2)*RMATRIXHP(2,2)3       RMATRIXMP(2,1)=RMATRIXMH(2,1)*RMATRIXHP(1,1)+ 2      *               RMATRIXMH(2,2)*RMATRIXHP(2,1)3       RMATRIXMP(2,2)=RMATRIXMH(2,1)*RMATRIXHP(1,2)+ 2      *               RMATRIXMH(2,2)*RMATRIXHP(2,2)B C=================================================================@ C   Calculate the translation vector SHIFTMP from the "PLOT"  ==@ C   coordinate system to the "MONITOR" coordinate system.     ==@ C                                                             ==@ C   SHIFTMP = RMATRIXMH * SHIFTHP + SHIFTMH                   ==B C=================================================================E       SHIFTMP(1)=RMATRIXMH(1,1)*SHIFTHP(1)+RMATRIXMH(1,2)*SHIFTHP(2)+       *           SHIFTMH(1) E       SHIFTMP(2)=RMATRIXMH(2,1)*SHIFTHP(1)+RMATRIXMH(2,2)*SHIFTHP(2)+       *           SHIFTMH(2) B C=================================================================@ C   Calculate the inverse transformation matrix RMATRIXPM from==@ C   the "MONITOR" coordinate system to the "PLOT" coordinate  ==@ C   system:                                                   ==@ C                                                             ==@ C   RMATRIXPM      = RMATRIXMP**-1                            ==@ C                                                             ==@ C   PLOT<--MONITOR = (MONITOR<--PLOT)**-1                     ==B C=================================================================G       DETMP=RMATRIXMP(1,1)*RMATRIXMP(2,2)-RMATRIXMP(2,1)*RMATRIXMP(1,2) )       RMATRIXPM(1,1)=RMATRIXMP(2,2)/DETMP *       RMATRIXPM(1,2)=-RMATRIXMP(1,2)/DETMP*       RMATRIXPM(2,1)=-RMATRIXMP(2,1)/DETMP)       RMATRIXPM(2,2)=RMATRIXMP(1,1)/DETMP B C=================================================================@ C   Calculate the inverse translation vector SHIFTPM from the ==@ C   "MONITOR" coordinate system to the "PLOT" coordinate      ==@ C   system.                                                   ==@ C                                                             ==@ C   SHIFTPM = -RMATRIXPM * SHIFTMP                            ==B C=================================================================E       SHIFTPM(1)=-RMATRIXPM(1,1)*SHIFTMP(1)-RMATRIXPM(1,2)*SHIFTMP(2) E       SHIFTPM(2)=-RMATRIXPM(2,1)*SHIFTMP(1)-RMATRIXPM(2,2)*SHIFTMP(2) B C=================================================================@ C   Calculate the boundaries in the "PLOT" coordinate system. ==@ C   corresponding to the monitor viewport.                    ==@ C   Expand these boundaries by 1/1000000 of their original    ==@ C   dimensions in order to avoid round off problems when one  ==@ C   plots right on the boundaries.                            ==B C=================================================================D       XMINMP2=RMATRIXPM(1,1)*XMINM2+RMATRIXPM(1,2)*YMINM2+SHIFTPM(1)D       YMINMP2=RMATRIXPM(2,1)*XMINM2+RMATRIXPM(2,2)*YMINM2+SHIFTPM(2)D       XMAXMP2=RMATRIXPM(1,1)*XMAXM2+RMATRIXPM(1,2)*YMAXM2+SHIFTPM(1)D       YMAXMP2=RMATRIXPM(2,1)*XMAXM2+RMATRIXPM(2,2)*YMAXM2+SHIFTPM(2).       XMINMP=XMINMP2-.000001*(XMAXMP2-XMINMP2).       XMAXMP=XMAXMP2+.000001*(XMAXMP2-XMINMP2).       YMINMP=YMINMP2-.000001*(YMAXMP2-YMINMP2).       YMAXMP=YMAXMP2+.000001*(YMAXMP2-YMINMP2)       RETURN	       END 