@ 	SUBROUTINE NAMELIST(PROMPT,NAMES,DESC_ARRAY,NUMBER,INPUT,IECHO, 	1    IPROMPT) C ' C  reqd. KOSTL: routines - NMLSTUFF.MAR  C G CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC  C  C	MODULE NAME:	NAMELIST  C	CREATED BY:	Derek Rowell C	DATE:		Nov 27 1978 C	VERSION:	0.1 C 9 C	FUNCTION:	This is the top-level routine in the namelist 3 C			package. It is called directly by user programs - C			to set values into, or print the value of - C			entities in the namelist. NAMELIST parses + C			the input stream from device FOR$ACCEPT , C			and executes the commands implied by the C			string delimiters. C 7 C	ARGUMENTS:	PROMPT [CHARACTER*(*)] A text string to be / C			   printed on the terminal to prompt input. 0 C			   a "  :" is appended to the supplied text.0 C			NAMES(number) [CHARACTER*15] An array of the- C			   names of entities in the namelist. The - C			   user must initialize this array before . C			   issuing a call to NAMELIST. (This might. C			   be done with a DATA statement or a call C			   to NML$NAMESET.) . C			DESC_ARRAY(number) [INTEGER*4] An array of/ C			   pointers to the descriptor-block for the , C			   entities in the namelist. The pointer2 C			   in a given posistion must correspond to the3 C			   the variable named in the equivalent element - C			   of array NAMES. DESC_ARRAY is normally 2 C			   initialized by a user call to NML$DES_STUF.0 C			NUMBER [INTEGER*4] The number of entities in C			   the namelist. C  C  C ? 	CHARACTER PROMPT*(*),NAMES(NUMBER)*15,DELIM*1,STRING*80,CHAR*1 & 	CHARACTER ERR_MESSAGE*80,FULL_NAME*20 	CHARACTER*15 VAR_NAME6 	INTEGER*4 DESC_BLOCK(26),SUBSCR(7),DESC_ARRAY(NUMBER), 	INTEGER*4 OFFSET,ICOMMA,ISTOP,LPAREN,RPAREN 	INTEGER*4 DTYPE( 	INTEGER LOWER_BOUNDS(7),UPPER_BOUNDS(7) 	COMPLEX COMPLEX_VALUE& 	REAL*8 REAL_VALUE,VALUE,NML$REAL8_VAL, 	LOGICAL FIRST,LOG_VAL,EQUAL,VALID_NAME,DONE 	BYTE BYTE_VAL C * 	COMMON /NML$/ IN_DEV,IOUT_DEV,IPROMPT_DEV C  C  	PARAMETER LOG_1=2, 
 	1	  LOG_2=3, 
 	2	  LOG_4=4,  	3	  BYTE_1=6, 	4	  INTEGER_2=7,  	5	  INTEGER_4=8,  	6	  REAL_4=10,  	7	  REAL_8=11,  	8	  COMPLEX_8=12, 	9	  CHARACTER=14, 	1	  ILLEGAL=0 C  C  	PARAMETER NML$SUCCESS=1 C  	PARAMETER NML$INTERACTIVE=1 C 7 	EQUIVALENCE (BYTE_VALUE,COMPLEX_VALUE,VALUE,REAL_VALUE " 	1   ,INTEGER_VALUE,LOGICAL_VALUE)# 	EQUIVALENCE	(DESC_BLOCK(2),DTYPE),  	1		(DESC_BLOCK(4),NDIMS),% 	2		(DESC_BLOCK(13),LOWER_BOUNDS(1)), $ 	3		(DESC_BLOCK(20),UPPER_BOUNDS(1)) C  C 
 	IN_DEV=INPUT  	IOUT_DEV=IECHO  	IPROMPT_DEV=IPROMPT C * C FORCE A READ ON FIRST CALL TO NML$GETSTR 5	FIRST=.TRUE.
 	DONE=.FALSE.  	EQUAL=.FALSE. 	VALID_NAME=.FALSE.  	DESC_BLOCK(2)=ILLEGAL C  C  C 5 100	CALL NML$GET_STR(STRING,NCHAR,DELIM,FIRST,PROMPT)  	FIRST=.FALSE. C % C TEST FOR '&' AND REPLACE WITH A ','  	IF (DELIM .EQ. '&') THEN  	  DELIM=',' 	  DONE=.TRUE. 	ENDIF C / C TEST FOR A VARIABLE NAME BY THE "=" DELIMITER  C  	IF (DELIM .EQ. '=') THEN 
 	EQUAL=.TRUE.  C 0 C TEST FOR A ZERO LENGTH STRING (FOR =? COMMAND) 	  IF (NCHAR .EQ. 0) GO TO 100 C  C LOOK FOR SUBSCRIPTS 
 	  NSUBS=0 	  DO 15 I=1,7 15	  SUBSCR(I)=0 C  	  LPAREN=INDEX(STRING,'(')  	  RPAREN=INDEX(STRING,')')  	  IF (LPAREN .NE. 0) THEN 	    IPOS=LPAREN+1$ 10	    ICOM=INDEX(STRING(IPOS:),',') 	    ISTOP=ICOM+IPOS-1" 	    IF (ICOM .EQ. 0) ISTOP=RPAREN 	    NSUBS=NSUBS+15 	    SUBSCR(NSUBS)=NML$INT4_VAL(STRING(IPOS:ISTOP-1),  	1	ISTOP-IPOS,IERR)  		IF(IERR .NE.NML$SUCCESS)THEN$ 		  ERR_MESSAGE='INVALID SUBSCRIPTS' 		  GO TO 1000 		ENDIF  C  	    IPOS=ISTOP+1  	    IF (ICOM .NE. 0) GO TO 10 C  	    VAR_NAME=STRING(:LPAREN-1)  	  ELSE  	    VAR_NAME=STRING(:NCHAR) 	  ENDIF 	  FULL_NAME=STRING(:NCHAR)  C % C SEARCH NAME TABLE FOT VARIABLE NAME  C  	  DO 20 I=1,NUMBER ( 	    IF(VAR_NAME .EQ. NAMES(I)) GO TO 30
 20	  CONTINUE  C NAME NOT FOUND? 	  ERR_MESSAGE= 'VARIABLE NAME  '//STRING(:NCHAR)//' NOT FOUND' 
 	  GO TO 1000  C * C FETCH DESCRIPTOR BLOCK FOR THIS VARIABLE C ; 30	  CALL NML$GET_DESC(%VAL(DESC_ARRAY(I)),DESC_BLOCK,IERR) " 	  IF (IERR .NE. NML$SUCCESS) THEN3 	    ERR_MESSAGE='SYSTEM ERROR IN DESCRIPTOR BLOCK'U 	    GO TO 1000P 	  ENDIF C # C CHECK FOR SUBSCRIPTS OUT OF RANGE  	  IF(NSUBS .NE. 0) THEN 	    IF(NSUBS .NE. NDIMS) THEN7 	      ERR_MESSAGE='INCORRECT NUMBER OF SUBSCRIPTS IN 'A 	1	//STRING(:NCHAR)  	      GO TO 10008
 	    ENDIF 	  DO 35 K=1,NDIMS+ 	  IF((SUBSCR(K) .GT. UPPER_BOUNDS(K)) .OR.s- 	1     (SUBSCR(K) .LT. LOWER_BOUNDS(K))) THENp- 	    ERR_MESSAGE='SUBSCRIPT OUT OF RANGE IN 'v 	1     //STRING(:NCHAR)  	    GO TO 1000E 	  ENDIF
 35	  CONTINUEu 	  ENDIF C  Ci 	  VALID_NAME=.TRUE. 	  OFFSET=0e Cm Cd Cm- C TEST DELIMITER FOR A PRINTING REQUEST ('?')U 	ELSE IF (DELIM .EQ. '?') THEN Ct C TEST FOR THE "=?" SEQUENCE# 	  IF (EQUAL .AND. VALID_NAME) THEN	? 	    CALL NML$PRINT_VAR(FULL_NAME,DESC_BLOCK,NSUBS,SUBSCR,IERR)  	  ELSE IF(EQUAL) THEN0 	    CALL NML$PRINT_ALL(NAMES,DESC_ARRAY,NUMBER) 	  ELSE	2 	    CALL NML$PRINT_NAMES(NAMES,NUMBER,DESC_ARRAY) 	  ENDIF C  CN CL) C TEST FOR A DATA ITEM BY A "," DELIMITERA 	ELSE IF (DELIM .EQ. ',') THEN 	  VALID_NAME=.FALSE.C 	  EQUAL=.FALSE. 	  IF(NCHAR .EQ. 0) GO TO 70/ C FETCH DATA TYPE FROM CURRENT DESCRIPTOR BLOCKe3 C TEST FOR A REPEAT CONSTANT BY SEARCHING FOR A (*)e! C BEFORE A TEXT STRING IN QUOTES.  	  IREPEAT=1 	    ISTAR=INDEX(STRING,'*') 	    IQUOTE=INDEX(STRING,'''') 	    IF ((ISTAR .NE. 0) .AND. 3 	1	((IQUOTE .EQ. 0) .OR. (ISTAR .LT. IQUOTE))) THENB8 	    IREPEAT=NML$INT4_VAL(STRING(:ISTAR-1),ISTAR-1,IERR)# 	    IF(IERR .NE. NML$SUCCESS) THEN*B 	      ERR_MESSAGE='INVALID REPEAT CONSTANT IN : '//STRING(:NCHAR) 	      GO TO 1000C
 	    ENDIF 	    STRING=STRING(ISTAR+1:) 	    NCHAR=NCHAR-ISTAR 	  ENDIF CI CG C TEST FOR DATA TYPES AND ENTERP 	IF(DTYPE .EQ. ILLEGAL) THEN. 	  ERR_MESSAGE='INVALID INPUT :NO ''='' GIVEN'
 	  GO TO 1000A 	ENDIF CL CV CE C TEST FOR LOGICAL DATA TYPESL6 	  IF ((DTYPE .EQ. LOG_1) .OR. (DTYPE .EQ. LOG_2) .OR. 	1	(DTYPE .EQ. LOG_4)) THENM$ 	    IF((STRING(1:1) .EQ. 'T') .OR.   	1	(STRING(1:2) .EQ. '.T')) THEN 	      LOGICAL_VALUE= .TRUE.) 	    ELSE IF ((STRING(1:1) .EQ. 'F') .OR.7  	1	(STRING(1:2) .EQ. '.F')) THEN 	      LOGICAL_VALUE=.FALSE.	 	    ELSE < 	      ERR_MESSAGE='INVALID LOGICAL VALUE :'//STRING(:NCHAR) 	      GO TO 1000(
 	    ENDIF CL CV C TEST FOR A BYTE VALUE1# 	  ELSE IF (DTYPE .EQ. BYTE_1) THENU/ 	    BYTE_VALUE=NML$INT4_VAL(STRING,NCHAR,IERR)(# 	    IF(IERR .NE. NML$SUCCESS) THEN_< 	      ERR_MESSAGE='INVALID BYTE VALUE :  '// STRING(:NCHAR) 	      GO TO 1000_
 	    ENDIF CR CT C TEST FOR AN INTEGER VALUEE' 	  ELSE IF ((DTYPE .EQ. INTEGER_2) .OR.T 	1	(DTYPE .EQ. INTEGER_4)) THENS2 	    INTEGER_VALUE=NML$INT4_VAL(STRING,NCHAR,IERR)# 	    IF(IERR .NE. NML$SUCCESS) THEN,= 	      ERR_MESSAGE='INVALID INTEGER VALUE : '//STRING(:NCHAR)A 	      GO TO 1000,
 	    ENDIF C. C  C TEST FOR A REAL VALUE $ 	  ELSE IF ((DTYPE .EQ. REAL_4) .OR. 	1	(DTYPE .EQ. REAL_8)) THEN0 	    REAL_VALUE=NML$REAL8_VAL(STRING,NCHAR,IERR)$ 	    IF (IERR .NE. NML$SUCCESS) THEN: 	      ERR_MESSAGE='INVALID REAL VALUE : '//STRING(:NCHAR) 	      GO TO 1000T
 	    ENDIF C  CD C TEST FOR A COMPLEX VALUE& 	  ELSE IF (DTYPE .EQ. COMPLEX_8) THEN 	    LPAREN=INDEX(STRING,'(')  	    ICOMMA=INDEX(STRING,',')= 	    RPAREN=INDEX(STRING,')')I2 	    IF ((LPAREN .EQ. 0) .OR. (RPAREN .EQ. 0) .OR. 	1	(ICOMMA .EQ. 0)) THEN; 	      ERR_MESSAGE='INVALID SYNTAX FOR A COMPLEX NUMBER : ': 	1	//STRING(:NCHAR)I 	      GO TO 1000R
 	    ENDIF CS7 	    REAL_PART=NML$REAL8_VAL(STRING(LPAREN+1:ICOMMA-1),0 	1	ICOMMA-LPAREN-1,IERR)$ 	    IF (IERR .NE. NML$SUCCESS) THEN9 	      ERR_MESSAGE='INVALID NUMBER IN : '//STRING(:NCHAR)V 	      GO TO 1000A
 	    ENDIF C 8 	    AIMAG_PART=NML$REAL8_VAL(STRING(ICOMMA+1:RPAREN-1), 	1	RPAREN-ICOMMA-1,IERR)$ 	    IF (IERR .NE. NML$SUCCESS) THEN9 	      ERR_MESSAGE='INVALID NUMBER IN : '//STRING(:NCHAR)M 	      GO TO 1000A
 	    ENDIF CN. 	    COMPLEX_VALUE=CMPLX(REAL_PART,AIMAG_PART) 	  ENDIF CB: C CHARACTER DATA MUST BE TREATED SEPARATELY BECAUSE OF THE6 C PROBLEM OF SETTING UP A BUFFER OF UNKNOWN LENGTH. BY9 C TRANSFERRING A BYTE AT A TIME AN ENTRY MAY BE MADE INTOK9 C A LONG CHARACTER VARIABLE WITHOUT STORING A LONG BUFFERO C IN NAMELIST. C(  	  IF(DTYPE .EQ. CHARACTER) THEN$ 	    IF((STRING(1:1) .NE. '''') .OR.- 	1      (STRING(NCHAR:NCHAR) .NE. '''')) THENN. 	      ERR_MESSAGE='INVALID CHARACTER VALUE: ' 	1	//STRING(NCHAR:NCHAR) 	      GO TO 1000O
 	    ENDIF C  	    STRING=STRING(2:NCHAR-1)U 	    NCHAR=NCHAR-2 CR C STORE CHARACTER DATA 	    DO 50 J=1,IREPEAT 	    DO 55 K=1,DESC_BLOCK(3) 	      CHAR=' '5) 	      IF (K .LE. NCHAR) CHAR=STRING(K:K)M2 	      CALL NML$PUT_VALUE(DESC_BLOCK,SUBSCR,NSUBS,  	1	OFFSET+(K-1),%REF(CHAR),IERR)% 	      IF(IERR .NE. NML$SUCCESS) THENT, 		ERR_MESSAGE='INVALID ARRAY SPECIFICATION-'0 	1	  //' STORAGE EXCEEDED OR SUBSCRIPT MISMATCH' 		GO TO 1000 	      ENDIF 55	    CONTINUEU" 50	    OFFSET=OFFSET+DESC_BLOCK(3) C, CC! C STORE NUMERIC AND LOGICAL TYPES  	  ELSE_ 	    DO 60 I=1,IREPEAT2 	      CALL NML$PUT_VALUE(DESC_BLOCK,SUBSCR,NSUBS, 	1 	OFFSET,VALUE,IERR)% 	      IF(IERR .NE. NML$SUCCESS) THENN, 		ERR_MESSAGE='INVALID ARRAY SPECIFICATION-'0 	1	  //' STORAGE EXCEEDED OR SUBSCRIPT MISMATCH' 	      GO TO 1000E
 	    ENDIF 60	    OFFSET=OFFSET+1 	  ENDIF C  CE 	ENDIF C  C TEST FOR COMPLETIONI 70	IF ( DONE) THEN	 	  RETURNN 	ELSE  	  GO TO 100 	ENDIF C' C)< C ERROR HANDLER. IF IN INTERACTIVE MODE ERRORS ARE NON-FATAL9 C AND A BRANCH TO THE ENTRY POINT IS TAKEN. IN BATCH MODE: C ERRORS ARE FATAL.)9 1000	IF(IOUT_DEV .NE. 0) WRITE(IOUT_DEV,1010) ERR_MESSAGE' 	IF (IPROMPT_DEV .NE. 0) THEN/' 	   WRITE(IPROMPT_DEV,1010) ERR_MESSAGEE 	   GO TO 5R 	ELSEI 	   STOP 'FATAL NAMELIST ERROR'T 	ENDIF# 1010	FORMAT(' NAMELIST ERROR:  ',A)N 	END  3 	INTEGER*4 FUNCTION NML$INT4_VAL(STRING,NCHAR,IERR)I CN C	MODULE NAME:	NML$INT4_VALO C	CREATED BY:	Derek Rowell C	DATE:		Nov 27 1978 C	VERSION:	0.1 CT0 C	FUNCTION:	Converts a numeric text string to an C			integer format.E C 4 C	ARGUMENTS:	STRING [CHARACTER*(*)] A numeric string' C			   specifying an integer value, forT C			   example '-1234'.N. C			NCHAR [INTEGER*4] The number of characters C			   in the input string.E, C			IERR [INTEGER*4] Error status on string.' C			   IERR=1 for successful conversion 2 C			   IERR=0 for an error detected on conversion. CA C1 C  	CHARACTER*(*) STRINGT 	PARAMETER NML$SUCCESS=1,= 	1	  NML$ERROR=0 CC. 	DECODE(NCHAR,100,STRING,ERR=200) NML$INT4_VAL 100	FORMAT(I<NCHAR>) 	IERR=NML$SUCCESS: 	RETURNI C: 200	IERR=NML$ERROR 	RETURN  	END    1 	REAL*8 FUNCTION NML$REAL8_VAL(STRING,NCHAR,IERR)D CE C	MODULE NAME:	NML$REAL8_VAL C	CREATED BY:	Derek Rowell C	DATE:		Nov 27 1978 C	VERSION:	0.1 CH6 C	FUNCTION:	Converts a numeric text string to a double C			precision real number. CU4 C	ARGUMENTS:	STRING [CHARACTER*(*)] A numeric string, C			   containing a real number, for example C			   '234.567' or '-234.E07'.T. C			NCHAR [INTEGER*4] The number of characters C			   in STRING.I2 C			IERR [INTEGER*4] Error status upon conversion.. C			   IERR=1 indicates successful conversion.. C			   IERR=0 indicates eroor upon conversion. CF CA CM 	CHARACTER*(*) STRING( 	PARAMETER NML$SUCCESS=1,  	1	  NML$ERROR=0 CI/ 	DECODE(NCHAR,100,STRING,ERR=200) NML$REAL8_VALA 100	FORMAT(D<NCHAR>.0) 	IERR=NML$SUCCESSQ 	RETURN  CA 200	IERR=NML$ERROR 	RETURN. 	END    % 	INTEGER*4 FUNCTION NML$OP_MODE(IERR)F CA C	MODULE NAME:	NML$OP_MODE C	CREATED BY:	Derek Rowell C	DATE:		Nov 28 1978 C	VERSION:	0.1 CL7 C	ARGUMENTS:	IERR [INTEGER*4] Status condition returned10 C			  after call to system services to translate C			  logical device names.R! C			    IERR=1 indicates success. . C			    IERR=0 indicates error in translation. C_ C( CI# 	CHARACTER*64 IN_DEVICE, OUT_DEVICEM C1 	PARAMETER NML$INTERACTIVE=1,S 	1	  NML$BATCH=0,  	2	  NML$SUCCESS=1,  	3	  NML$FAILURE=0,( 	4	  SS$_NORMAL=1  C1 CA C  	IERR=NML$SUCCESSC 	NML$OP_MODE=NML$INTERACTIVE CG7 C TRANSLATE LOGICAL NAMES FOR SYS$INPUT AND SYS$OUTPUT.P, 	ISTAT=SYS$TRNLOG('SYS$INPUT',,IN_DEVICE,,,), 	IF (ISTAT .NE. SS$_NORMAL) IERR=NML$FAILURE CA. 	ISTAT=SYS$TRNLOG('SYS$OUTPUT',,OUT_DEVICE,,,)+ 	IF (STAT .NE. SS$_NORMAL) IERR=NML$FAILUREG CF6 C COMPARE TRANSLATED NAMES TO DECICED IF IN BATCH MODE5 	IF (IN_DEVICE .NE. OUT_DEVICE) NML$OP_MODE=NML$BATCHN CC 	RETURN) 	END      4 	SUBROUTINE NML$PRINT_NAMES(NAMES,NUMBER,DESC_POINT) C1 C	MODULE NAME:	NML$PRINT_NAMES C	CREATED BY:	Derek Rowell C	DATE:		Nov 27 1978 C	VERSION:	0.1 CR6 C	FUNCTION:	Prints a list of all variable names in the+ C			namelist upon receipt of a '?' command.A C 3 C	ARGUMENTS:	NAMES(number) [CHARACTER*(*)] Array of & C			   variable names in the namelist./ C			NUMBER [INTEGER*4] Number of names entered ( C			   the array NAMES.E+ C			DESC_POINT(number) [INTEGER*4] Array ofN( C			   pointers to the descriptor blocks. C			   for the corresponding entries in NAMES. C      C0 C ' 	CHARACTER*15 NAMES(NUMBER),TYPE(14)*10T0 	CHARACTER STRING*80,OUT_STRING*80,SUB_STRING*20 	CHARACTER*80 NML$PACK, 	INTEGER*4 DESC_POINT(NUMBER),DESC_BLOCK(26)( 	INTEGER*4 LOWER_BOUND(7),UPPER_BOUND(7)$ 	INTEGER*4 CLASS,DTYPE,BLENGTH,NDIMS CD# 	EQUIVALENCE (CLASS,DESC_BLOCK(1)),A 	1	    (DTYPE,DESC_BLOCK(2)),C 	2	    (BLENGTH,DESC_BLOCK(3)),F 	3	    (NDIMS,DESC_BLOCK(4)),D' 	4	    (LOWER_BOUND(1),DESC_BLOCK(13)),T& 	5	    (UPPER_BOUND(1),DESC_BLOCK(20)) C 3 	DATA TYPE/'BIT*','LOGICAL*','LOGICAL*','LOGICAL*',N8 	1  'LOGICAL*','BYTE*','INTEGER*','INTEGER*','INTEGER*',7 	2  'REAL*','REAL*','COMPLEX*','COMPLEX*','CHARACTER*'/T C) C0 CI	 	TYPE 100.. 100	FORMAT('0','CURRENT NAMELIST VARIABLES :') CM 	DO 10 I=1,NUMBER/  . C FETCH THE DESCRIPTOR BLOCK FOR THIS VARIABLE7 	CALL NML$GET_DESC(%VAL(DESC_POINT(I)),DESC_BLOCK,IERR)  C0 	STRING=NAMES(I)0 C IF IT IS AN ARRAY ADD THE DIMENSION ATTRIBUTES 	IF(CLASS .EQ. 4) THEN) 	   STRING=NML$PACK(STRING//'(',81,NCHAR)A 	   DO 20 J=1,NDIMS & 	      IF (LOWER_BOUND(J) .NE. 1) THEN+ 		 ENCODE(20,200,SUB_STRING) LOWER_BOUND(J)t5 		 STRING=NML$PACK(STRING//SUB_STRING//':',101,NCHAR)A 	      ENDIF. 	      ENCODE(20,200,SUB_STRING)UPPER_BOUND(J)9 	      STRING=NML$PACK(STRING//SUB_STRING//',',101,NCHAR)h 20	   CONTINUE 	   STRING(NCHAR:NCHAR)=')'t 	ENDIF C PACK STRING AND SAVE% 	OUT_STRING=NML$PACK(STRING,80,NCHAR)  Cc& C FORMULATE TYPE AND LENGTH ATTRIBUTES! 	ENCODE(20,200,SUB_STRING)BLENGTH ) 	STRING='['//TYPE(DTYPE)//SUB_STRING//']'N* 	OUT_STRING(25:)=NML$PACK(STRING,80,NCHAR) CC C, 	TYPE 300, OUT_STRING$ 300	FORMAT(1X,A<25+NCHAR>) C  10	CONTINUEC C:	 	TYPE 400  400	FORMAT('0')E 	RETURNT 200	FORMAT(I20)R 	END    5 	CHARACTER*(*) FUNCTION NML$PACK(STRING,LENGTH,NCHAR)M CN C	MODULE NAME:	NML$PACKY C	CREATED BY:	Derek Rowell C	DATE:		Nov 27 1978 C	VERSION:	0.1 C	4 C	FUNCTION:	Left justifies and elimiates blanks from C			a character string.R CE6 C	ARGUMENTS:	STRING [CHARACTER*(*)] Input string to be C			   justified and packed.- C			LENGTH [INTEGER*4] Length of string (fromA- C			   left margin) to be packed. Need not bei2 C			   equal to the declared length of the string.2 C			NCHAR [INTEGER*4] Number of characters packed,/ C			   i.e. the length of the non-blank string.s C. CF 	CHARACTER*(*) STRING)
 	NML$PACK=' 'M 	NCHAR=0 CE 	DO 10 I=1,LENGTHR" 	IF(STRING(I:I) .EQ. ' ') GO TO 10 	NCHAR=NCHAR+1" 	NML$PACK(NCHAR:NCHAR)=STRING(I:I) 10	CONTINUEQ CR 	RETURNA 	END      4 	SUBROUTINE NML$PRINT_ALL(NAMES,DESC_POINTER,NUMBER) CM C	MODULE NAME:	NML$PRINT_ALL C	CREATED BY:	Derek Rowell C	DATE:		Nov 27 1978 C	VERSION:	0.1 CS7 C	FUNCTION:	Prints the names and values of all entitiesi. C			in the namelist on receipt of an [delim]=? C			command. C	9 C	ARGUMENTS:	NAMES(number)[CHARACTER*(*)] Array of names s# C			   of entities in the namelist. - C			DESC_POINTER(number) Array of pointers toC- C			   the descriptor blocks of corresponding1 C			   entries in NAMES2, C			NUMBER [INTEGER*4] Number of enrtries in C			   the namelist. C  CI8 	INTEGER*4 DESC_POINTER(NUMBER),DESC_BLOCK(26),SUBSCR(7) 	CHARACTER*(*) NAMES(NUMBER) C  	DATA SUBSCR/7*0/I CT 	DO 10 I=1,NUMBERP9 	CALL NML$GET_DESC(%VAL(DESC_POINTER(I)),DESC_BLOCK,IERR)I3 10	CALL NML$PRINT_VAR(NAMES(I),DESC_BLOCK,0,SUBSCR), C  	RETURN  	END      > 	SUBROUTINE NML$GET_VALUE(DESC,SUBSCR,JSUBS,OFFSET,VALUE,IERR) C++I CA C	MODULE NAME: NML$GET_VALUE C_ C	IDENT: 0.1 CD C	FUNCTION:  C = C		THIS ROUTINE STORES A DATA ELEMENT IN A VARIABLE SPECIFIEDD? C		BY THE INPUT DESCRIPTOR BLOCK.  ARRAY OFFSETS ARE CALCULATEDe= C		FROM INFORMATION IN THE DESCRIPTOR BLOCK, AT THE SUBSCRIPT	 C		SPECIFIED IN SUBSCR.a C  C	AUTHOR: DOUGLASS J. WILSON Ce C	DATE: 13-NOV-78a CA C	MODIFIED BY: CN C	CALLING SEQUENCE:E= C		CALL NML$GET_VALUE(DESC_BLOCK,SUBSCR,JSUBS,OFFSET,DC_VALUEU C				  ,CHAR_VALUE,LOG_VALUE)s Ct Cd
 C	ARGUEMENTS:a Cy C		DESC_BLOCK	-[INTEGER*4]0 C				-12 ELEMENT ARRAY CONTAINING THE DESCRIPTOR7 C				 BLOCK FOR A VARIABLE.  FOR SPEC. SEE NML$GET_DECSi CA C		SUBSCR		-[INTEGER*4]A1 C				-7 ELEMENT ARRAY CONTAINING THE CURRENT SUB-R0 C				 SCRIPT SPECIFICATION FOR THIS STORE.  LEFT% C				 MOST SUBSCRIPT IS IN ELEMENT 1., CC C		JSUBS		-[INTEGER*4]0 C				-CONTAINS THE NUMBER OF ELEMENTS PRESENT IN C				 THE SUBSCRIPT ARRAY. CN C		OFFSET		-[INTEGER*4]A6 C				-CONTAINS AN OFFSET IN STORAGE CELLS (IE. REAL*8)3 C				 FROM THE CURRENT POSITION, AT WHICH THE VALUEO C				 IS TO BE STORED. C) C		VALUE		-[COMPLEX*8]" C				-VALUE TO BE STORED (NUMERIC) C* CL C		IERR		-[INTEGER*4]G C				-ERROR CODE RETURNEDY C' CN$ C	CALLED SUBROUTINES: NML$MOVE_BYTES C* CR C--, CM C	TYPE DECLARATIONSA CTD 	INTEGER*4 DESC_BLOCK(26),SUBSCR(7),OFFSET,CLASS,DTYPE,BLENGTH,NDIMS$ 	INTEGER*4 DESC(26),DIMS(7),ZPOINTER* 	INTEGER*4 UPPER_BOUNDS(7),LOWER_BOUNDS(7) 	BYTE VALUE(8) CC# 	EQUIVALENCE (DESC_BLOCK(1),CLASS),  	1	    (DESC_BLOCK(2),DTYPE),  	2	    (DESC_BLOCK(3),BLENGTH),R 	3	    (DESC_BLOCK(4),NDIMS),  	4	    (DESC_BLOCK(5),DIMS(1)),1! 	5	    (DESC_BLOCK(12),ZPOINTER), ( 	6	    (DESC_BLOCK(13),LOWER_BOUNDS(1)),' 	7	    (DESC_BLOCK(20),UPPER_BOUNDS(1))	 CR 	INTEGER*4 LENGTH_TABLE(15)N) 	DATA LENGTH_TABLE/ 	0,0,		!UNKNOWN TYPESC 	1			1,2,4,8,	!LOGICALSE 	2			1,2,4,0,	!INTEGERS= 	3			4,8,		!REALSB 	4			8,0,		!COMPLEXR 	5			1	/	!CHARACTERS CT- C	MOVE DESCRIPTOR BLOCK FOR EQIVALENCE KLUDGEN CA 	DO 1 I=1,26 1	DESC_BLOCK(I)=DESC(I)R C 1 C	CALCULATE OFFSET INTO STORAGE CELLS FROM SUBSCR( C2 	IF (JSUBS .EQ. NDIMS) THENN 		IF (JSUBS .GT. 0) THEN& 			NEW_OFF = SUBSCR(1)-LOWER_BOUNDS(1) 			IF (JSUBS .GT. 1) THENP 				DO 10 I=2,JSUBS0
 				MULT=1 				DO 11 J=1,I-10 11				MULT=MULT*DIMS(J) 6 10				NEW_OFF=NEW_OFF+MULT*(SUBSCR(I)-LOWER_BOUNDS(I)) 			ENDIF 		ELSE 			NEW_OFF=0 		ENDIF, 	ELSE IF(JSUBS .NE. 0) THENN 		IERR=2 		RETURN 	ELSEY 		NEW_OFF=0l 	ENDIF CN. C	MULTIPLY BY BYTE SIZE AND APPROPRIATE OFFSET Cs' 	NEW_OFF = NEW_OFF * BLENGTH + ZPOINTERh3 	NEW_OFF = NEW_OFF + OFFSET * LENGTH_TABLE(DTYPE+1)( C  Cu Ct' 	IF (LENGTH_TABLE(DTYPE+1) .EQ. 0) THEN  		IERR=3				!UNKNOWN DATA TYPE 		RETURN 	ENDIF C ? 	CALL NML$MOVE_BYTES(%VAL(NEW_OFF),VALUE,LENGTH_TABLE(DTYPE+1))l 	RETURNt Cf 	END        2 	SUBROUTINE NML$MOVE_BYTES(SOURCE,DESTINATION,LEN) C	 C	MODULE NAME: NML$MOVE_BYTESl C	CREATED BY:	Derek Rowell C	DATE:		Nov 28 1978 C	VERSION:	0.1 C09 C	FUNCTION:	Moves a block of memory without normalization0( C			This routine is used for storing and, C			retrieving variables of uknown type as a C			contiguous block of bytes. CE8 C	ARGUMENTS:	SOURCE(len) [BYTE] Address of block of core C			  to be moved./ C			DESTINATION(len) [BYTE] Address of block of  C			  core to receive data.a- C			LEN [INTEGER*4] Length of block in bytes.  Cr Ci Co Cn" 	BYTE SOURCE(LEN),DESTINATION(LEN) CT 	DO 10 I=1,LEN 10	DESTINATION(I)=SOURCE(I)s C  	RETURN  	END      < 	SUBROUTINE NML$PRINT_VAR(NAME,DESC_BLOCK,NSUBS,SUBSCR,IERR) C	 C	MODULE NAME:	NML$PRINT_VAR C	CREATED BY:	Derek Rowell C	DATE:		Nov 28 1978 C	VERSION		0.1 Ce6 C	FUNCTION:	Print the value of a variable specified by' C			the current descriptor block. If noB* C			no explicit subscript is specified for( C			an array the whole array is printed. CL5 C	ARGUMENTS:	NAME [CHARACTER*(*)] The name, including - C			  subscripts of the entity to be printed.S- C			DESC_BLOCK(26) [INTEGER*4] The descriptor$# C			  block for the current entity.L. C			NSUBS [INTEGER*4] The number of subscripts+ C			  specified by the user for the entity.T1 C			SUBSCR(7) [INTEGER*4] The array of subscriptsC C			  specified for the array.+ C			IERR [INTEGER*4] Error status returned.F! C			    IERR=1 indiactes success.L! C			    IERR=0 indicates failure.D C  CS Ca C  	CHARACTER*(*) NAMEJ 	CHARACTER*30 NML$PACK,STRINGa
 	REAL*8 VALUED# 	INTEGER*4 DESC_BLOCK(26),SUBSCR(7)L CM* 	COMMON /NML$/ IN_DEV,IOUT_DEV,IPROMPT_DEV 	PARAMETER CHARACTER=14, 	1	  COMPLEX=12t 	1	  CR% C COMPUTE NUMBER OF ELEMENTS TO PRINT*	 	NUMBER=125 	IF((NSUBS .EQ. 0) .AND. (DESC_BLOCK(1) .EQ. 4)) THENO 	   DO 10 I=1,DESC_BLOCK(4)N# 10	   NUMBER=NUMBER*DESC_BLOCK(I+4)R 	ENDIF C-- 	STRING=NML$PACK(NAME//'=',LEN(NAME)+1,NCHAR)	 	WRITE(IPROMPT_DEV,90) 90	FORMAT('0')& 	WRITE(IPROMPT_DEV,100) STRING(:NCHAR) 100	FORMAT('+',A$)> C ADVANCE A LINE IF THERE ARE TOO MANY ITEMS FOR A SINGLE LINE( 	IF((( DESC_BLOCK(2) .GE. COMPLEX) .AND. 	1   (NUMBER .GT. 1)) .OR.( 	2   ((DESC_BLOCK(2) .LT. COMPLEX) .AND.- 	3   (NUMBER .GT. 3))) WRITE(IPROMPT_DEV,150)H 150	FORMAT() CS C  CS CE  C PRINT NUMERIC AND LOGICAL DATA 	NPR=1 CO& 	IF(DESC_BLOCK(2) .NE. CHARACTER) THEN 	   DO 20 I=1,NUMBER@ 	   CALL NML$GET_VALUE(DESC_BLOCK,SUBSCR,NSUBS,(I-1),VALUE,IERR)* 20	   CALL NML$PRINT(VALUE,DESC_BLOCK,NPR) 	   WRITE(IPROMPT_DEV,200) 200	   FORMAT('+') CY CB 	ELSEN C PRINT CHARACTER DATA 	   DO 30 I=1,NUMBER 	   DO 40 J=1,DESC_BLOCK(3)RB 	   CALL NML$GET_VALUE(DESC_BLOCK,SUBSCR,NSUBS,(I-1)*DESC_BLOCK(3) 	1	+(J-1),VALUE,IERR),* 40	   CALL NML$PRINT(VALUE,DESC_BLOCK,NPR) 30	   CONTINUE 300	   FORMAT(' '$)  CE 	ENDIF 	RETURN1 	END  * 	SUBROUTINE NML$PRINT(IN_VAL,DESC_BLOCK,N) CB C	MODULE NAME:	NML$PRINT C	CREATED BY:	Derek Rowell C	DATE:		Nov 29 1978 C	VERSION:	0.1 CL0 C	FUNCTION:	Print a NAMELIST entity, with format C			dictated by the type.  C	2 C	ARGUMENTS:	IN_VAL(8) [BYTE] Value to be printed., C			  (The byte size used is determined from$ C			  the current descriptor block.)/ C			DESC_BLOCK(26) [INTEGER*4] Descriptor block  C			  for the current entity. + C			N [INTEGER*4] Counter for the number of)0 C			  items printed.Is used for line formatting. C( CL CR CU 	BYTE IN_VAL(8),VALUE(8) 	INTEGER*4 DESC_BLOCK(26)B C * 	COMMON /NML$/ IN_DEV,IOUT_DEV,IPROMPT_DEV C DATA TYPES SUPPORTED 	COMPLEX CMPLEX( 	REAL*8 RL8E 	REAL*4 RL4  	INTEGER*4 INT4  	INTEGER*2 INT2N 	LOGICAL*4 LOG4U 	LOGICAL*2 LOG2  	LOGICAL*1 LOG1N
 	BYTE CHAR C_& C DESCRIPTOR BLOCK TYPE SPECIFICATIONS 	PARAMETER	LOGICAL1=2, 	1		LOGICAL2=3,= 	2		LOGICAL4=4,H 	3		INTEGER2=7,W 	4		INTEGER4=8,O
 	5		REAL4=10,T
 	6		REAL8=11,  	7		COMPLEX=12,L 	8		CHARACTER=14 C.% C EQUIVALENCE DATA TYPES FOR PICK-UP. 0 	EQUIVALENCE (VALUE(1),CMPLEX,RL8,RL4,INT4,INT2, 	1	LOG4,LOG2,LOG1,CHAR)_ CL CT2 C MOVE INPUT BYTES TO ENABLE EQUIVALENCE OF VALUES 	DO 10 I=1,8 10	VALUE(I)=IN_VAL(I)  C  C TEST FOR LOGICAL VALUESE& 	IF((DESC_BLOCK(2) .EQ. LOGICAL4) .OR.& 	1  (DESC_BLOCK(2) .EQ. LOGICAL2) .OR.' 	2  (DESC_BLOCK(2) .EQ. LOGICAL1)) THENm 		WRITE(IPROMPT_DEV,100) LOG1  100		FORMAT('+',L15$)	. 		IF (MOD(N,5) .EQ. 0) WRITE(IPROMPT_DEV,1000) Ct C TEST FOR INTEGER VALUES + 	ELSE IF((DESC_BLOCK(2) .EQ. INTEGER2) .OR.o& 	1	(DESC_BLOCK(2) .EQ. INTEGER4)) THEN, 	    IF(DESC_BLOCK(2) .EQ. INTEGER)INT4=INT4 	    WRITE(IPROMPT_DEV,200)INT4  200	    FORMAT('+',I15$)0 	    IF(MOD(N,5) .EQ. 0) WRITE(IPROMPT_DEV,1000) CN C TEST FOR REAL VALUES( 	ELSE IF((DESC_BLOCK(2) .EQ. REAL8) .OR.# 	1	(DESC_BLOCK(2) .EQ. REAL4)) THEN$( 	    IF(DESC_BLOCK(2) .EQ. REAL4)RL8=RL4 	    WRITE(IPROMPT_DEV,300)RL8 300	    FORMAT('+',1PG15.7$)0 	    IF(MOD(N,5) .EQ. 0) WRITE(IPROMPT_DEV,1000) CI C TEST FOR COMPLEX VALUE+ 	ELSE IF((DESC_BLOCK(2) .EQ. COMPLEX)) THENt! 	    WRITE(IPROMPT_DEV,400)CMPLEXu0 400	    FORMAT('+','(',1PG15.7,',',1PG15.7,')'$)0 	    IF(MOD(N,2) .EQ. 0) WRITE(IPROMPT_DEV,1000) C) C TEST FOR CHARACTER DATA	+ 	ELSE IF(DESC_BLOCK(2) .EQ. CHARACTER) THEN	 	    WRITE(IPROMPT_DEV,500)CHARd 500	    FORMAT('+',A1$)o< 	    IF(MOD(N,DESC_BLOCK(3)) .EQ. 0) WRITE(IPROMPT_DEV,1000) Cr 	ELSE	- 	    WRITE(IPROMPT_DEV,*) 'INVALID DATA TYPE'	 	ENDIF CI 	N=N+1 	RETURNa 1000	FORMAT(' '$)	 C  	END> 	SUBROUTINE NML$PUT_VALUE(DESC,SUBSCR,JSUBS,OFFSET,VALUE,IERR) C++	 C  C	MODULE NAME: NML$PUT_VALUE C  C	IDENT: 0.1 Cs C	FUNCTION:  CS= C		THIS ROUTINE STORES A DATA ELEMENT IN A VARIABLE SPECIFIED ? C		BY THE INPUT DESCRIPTOR BLOCK.  ARRAY OFFSETS ARE CALCULATED = C		FROM INFORMATION IN THE DESCRIPTOR BLOCK, AT THE SUBSCRIPT1 C		SPECIFIED IN SUBSCR.  CO C	AUTHOR: DOUGLASS J. WILSON C* C	DATE: 13-NOV-78N CS C	MODIFIED BY: CC C	CALLING SEQUENCE:E= C		CALL NML$PUT_VALUE(DESC_BLOCK,SUBSCR,JSUBS,OFFSET,DC_VALUEK C				  ,CHAR_VALUE,LOG_VALUE)$ CK CM
 C	ARGUEMENTS:) CN C		DESC_BLOCK	-[INTEGER*4]0 C				-26 ELEMENT ARRAY CONTAINING THE DESCRIPTOR7 C				 BLOCK FOR A VARIABLE.  FOR SPEC. SEE NML$GET_DECSR CO C		SUBSCR		-[INTEGER*4] 1 C				-7 ELEMENT ARRAY CONTAINING THE CURRENT SUB- 0 C				 SCRIPT SPECIFICATION FOR THIS STORE.  LEFT% C				 MOST SUBSCRIPT IS IN ELEMENT 1.W CE C		JSUBS		-[INTEGER*4]0 C				-CONTAINS THE NUMBER OF ELEMENTS PRESENT IN C				 THE SUBSCRIPT ARRAY. CB C		OFFSET		-[INTEGER*4]H6 C				-CONTAINS AN OFFSET IN STORAGE CELLS (IE. REAL*8)3 C				 FROM THE CURRENT POSITION, AT WHICH THE VALUEI C				 IS TO BE STORED. C  C		VALUE		-[COMPLEX*8]" C				-VALUE TO BE STORED (NUMERIC) C  C		IERR		-[INTEGER*4]  C				-ERROR CODE RETURNED. C= CE$ C	CALLED SUBROUTINES: NML$MOVE_BYTES C_ CC C--S CN C	TYPE DECLARATIONS( C D 	INTEGER*4 DESC_BLOCK(26),SUBSCR(7),OFFSET,CLASS,DTYPE,BLENGTH,NDIMS$ 	INTEGER*4 DESC(26),DIMS(7),ZPOINTER+ 	INTEGER*4 LOWER_BOUNDS(26),UPPER_BOUNDS(7)R 	BYTE VALUE(8) CC# 	EQUIVALENCE (DESC_BLOCK(1),CLASS),	 	1	    (DESC_BLOCK(2),DTYPE),E 	2	    (DESC_BLOCK(3),BLENGTH),L 	3	    (DESC_BLOCK(4),NDIMS),e 	4	    (DESC_BLOCK(5),DIMS(1)),b! 	5	    (DESC_BLOCK(12),ZPOINTER),A( 	6	    (DESC_BLOCK(13),LOWER_BOUNDS(1)),' 	7	    (DESC_BLOCK(20),UPPER_BOUNDS(1))	 Ch 	INTEGER*4 LENGTH_TABLE(15) ) 	DATA LENGTH_TABLE/ 	0,0,		!UNKNOWN TYPESl 	1			1,2,4,8,	!LOGICALSn 	2			1,2,4,0,	!INTEGERSR 	3			4,8,		!REALS  	4			8,0,		!COMPLEXm 	5			1	/	!CHARACTERS Ce. C	MOVE DESCRIPTOR BLOCK FOR EQIVALENCE KLU~DGE C( 	DO 1 I=1,26 1	DESC_BLOCK(I)=DESC(I)M C 5 C COMPUTE MAXIMUM INDEX INTO ARRAY FOR ERROR CHECKINGT
 	MAX_OFFSET=1P 	IF(NDIMS .GT. 0) THEN 	  DO 5 I=1,NDIMS4! 5	  MAX_OFFSET=MAX_OFFSET*DIMS(I)4 	ENDIF' 	MAX_OFFSET=ZPOINTER+MAX_OFFSET*BLENGTH  CR1 C	CALCULATE OFFSET INTO STORAGE CELLS FROM SUBSCRM CR 	IF (JSUBS .EQ. NDIMS) THEN= 		IF (JSUBS .GT. 0) THEN& 			NEW_OFF = SUBSCR(1)-LOWER_BOUNDS(1) 			IF (JSUBS .GT. 1) THENO 				DO 10 I=2,JSUBSC
 				MULT=1 				DO 11 J=1,I-1T 11				MULT=MULT*DIMS(J)V6 10				NEW_OFF=NEW_OFF+MULT*(SUBSCR(I)-LOWER_BOUNDS(I)) 			ENDIF 		ELSE 			NEW_OFF=0 		ENDIFT 	ELSE IF(JSUBS .NE. 0) THENS 		IERR=2 		RETURN 	ELSE= 		NEW_OFF=0  	ENDIF CR. C	MULTIPLY BY BYTE SIZE AND APPROPRIATE OFFSET C ' 	NEW_OFF = NEW_OFF * BLENGTH + ZPOINTERO3 	NEW_OFF = NEW_OFF + OFFSET * LENGTH_TABLE(DTYPE+1)( CO C_ C,' 	IF (LENGTH_TABLE(DTYPE+1) .EQ. 0) THEN( 		IERR=3				!UNKNOWN DATA TYPE' 	ELSE IF (NEW_OFF .GE. MAX_OFFSET) THEN  		IERR=4				!TOO MANY VARIABLESG 	ELSER C ? 	CALL NML$MOVE_BYTES(VALUE,%VAL(NEW_OFF),LENGTH_TABLE(DTYPE+1)). 	ENDIF 	RETURN4 C  	END C<FF>M, 	SUBROUTINE NML$GET_CHAR(CHARC,FIRST,PROMPT) CI CO C	MODULE NAME: NML$GET_CHARD C1 C	IDENT: 0.1 CFE C	FUNCTION:  SUBROUTINE TO RETURN THE NEXT CHAR FROM THE INPUT STREAMK C  C	AUTHOR: DOUGLASS J. WILSON CB C	DATE: 13-NOV-78R CR C	MODIFIED BY: CM2 C	CALLING SEQUENCE: CALL NML$GET_CHAR(CHARC,FIRST) CO
 C	ARGUEMENTS:W CE C		CHARC	-[CHARACTER*1] ; C			-CHARACTER VARIABLE TO RECIEVE THE NEXT INPUT CHARACTER) CE C		FIRST	-[LOGICAL*1]D6 C			-LOGICAL VARIABLE WHICH IS SET TRUE TO FORCE A NEW C			 INPUT STRING TO BE READ.  CW C	CALLED SUBROUTINES: NONE CE CF 	CHARACTER*(*) PROMPTS 	INTEGER CUR_CHAR.     	LOGICAL * 1 FIRST,NEW_LINEI  	CHARACTER*1 CHARC,IN_BUFFER(81) 	CHARACTER*6 NML$LU_NAME,DEVICEB 	CHARACTER*63 NML$DEVICE_NAMED# 	COMMON /NML$/INDEV,IOUTDEV,IPROMPTM CD 1	IF (FIRST .OR. NEW_LINE) THENF 	   FIRST=.FALSE.R0 	   IF(IPROMPT .NE. 0) WRITE(IPROMPT,200) PROMPT 200	   FORMAT(' ',A,'   '$)F$ 	   READ (INDEV,100) NCHAR,IN_BUFFER 100	   FORMAT(Q,81A1)  CD9 	   IF(IOUTDEV .NE. 0) WRITE(IOUTDEV,300)PROMPT,IN_BUFFERT 300	   FORMAT(' ',A,'   ',80A1) : C	ADD A COMMA TO THE END OF LINE IF THERE IS NOT AN & OR , CE 		IF (IN_BUFFER(NCHAR) .NE. ','S+ 	1	   .OR.  IN_BUFFER(NCHAR) .NE. '&') THEND 			IN_BUFFER(NCHAR+1)=','  			NCHAR=NCHAR+1 		END IF 		CUR_CHAR = 0 		NEW_LINE = .FALSE. 	END IFN CE 	IF (CUR_CHAR .EQ. NCHAR) THEN 		NEW_LINE = .TRUE.B 	ELSET 		CUR_CHAR = CUR_CHAR+1V 		CHARC = IN_BUFFER(CUR_CHAR)U" C CONVERT LOWER-CASE TO UPPER-CASE; 		IF ((ICHAR(CHARC) .GE. 97) .AND. (ICHAR(CHARC) .LE. 122)) " 	1    	CHARC=CHAR(ICHAR(CHARC)-32) 		RETURN 	END IF  CS 	GOTO 1I 	END C<FF>	7 	SUBROUTINE NML$GET_STR(FIELD,NCHAR,DELIM,FIRST,PROMPT)C CT C	MODULE NAME: NML$GET_STR C  C	IDENT: 0.1 CS= C	FUNCTION: RETURN A STRING OF CHARS. BOUNDED BY A DELIMITER.O CI C	AUTHOR: DOUGLASS J. WILSON C  C	DATE: 13-NOV-78R C  C	MODIFIED BY: CE= C	CALLING SEQUENCE: CALL NML$GET_STR(FIELD,NCHAR,DELIM,FIRST). CA
 C	ARGUEMENTS:M CE C		FIELD	-[CHARACTER*80]6 C			-A CHARACTER STRING TO RECIEVE THE INCOMING FIELD. CE C		NCHAR	-[INTERGER*4]7 C			-AN INTEGER VARIABLE TO GET THE COUNT OF CHARACTERS 7 C			 IN THE STRING.  THE DELIMITER DOES NOT COUNT AS A T C			 CHARACTER.  C  C		DELIM	-[CHARACTER*1] ; C			-CHARACTER VARIABLE TO RECIEVE THE DELIMITER CHARACTER.H CI C		FIRST	-[LOGICAL*1],- C			-FLAG TO FORCE A NEW READ IN NML$GET_CHARP C_" C	CALLED SUBROUTINES: NML$GET_CHAR CL CE  	LOGICAL*1 FIRST,IN_QUOTE_STRING 	CHARACTER*(*) FIELD,PROMPT ! 	CHARACTER*1 CHAR,PREV_CHAR,DELIM( 	CHARACTER*4 VALID_DELIM 	INTEGER*4 PAREN_COUNT C) 	DATA VALID_DELIM/'=?&,'/Z CN 	IN_QUOTE_STRING=.FALSE. 	PREV_CHAR=' ' 	NCHAR=0 	PAREN_COUNT=0
 	FIELD=' ' CD C); C FETCH A SINGLE CHARACTER, (IGNORE BLANKS OUTSIDE STRINGS)0& 5	CALL NML$GET_CHAR(CHAR,FIRST,PROMPT)9 	IF ((CHAR .EQ. ' ') .AND. .NOT. IN_QUOTE_STRING) GO TO 50 C! CP+ C HANDLE MULTIPLE (')S INSIDE A TEXT STRINGP 	IF (CHAR .EQ. '''') THENU) 	  IN_QUOTE_STRING= .NOT. IN_QUOTE_STRINGC; 	  IF (IN_QUOTE_STRING .AND. (PREV_CHAR .EQ. '''')) GO TO 5N 	ENDIF CF C=9 C TEST FOR STRING DELIMITERS ONLY OUTSIDE OF TEXT STRINGSS  	IF (.NOT. IN_QUOTE_STRING) THEN9 C IGNORE (,) AS A DELIMITER WITHIN UNBALANCED PARENTHESESS/ 	  IF (CHAR .EQ. '(') PAREN_COUNT=PAREN_COUNT+1S/ 	  IF (CHAR .EQ. ')') PAREN_COUNT=PAREN_COUNT-1N 	  END_DELIM=4& 	  IF (PAREN_COUNT .NE. 0) END_DELIM=3 CE- 	  IDELIM=INDEX(VALID_DELIM(:END_DELIM),CHAR)  	  IF (IDELIM .NE. 0) THEN% 	    DELIM=VALID_DELIM(IDELIM:IDELIM)S 	    RETURNO 	  ENDIF 	ENDIF C	 CE C ADD NEW CHARACTER TO STRING  	NCHAR=NCHAR+1 	FIELD(NCHAR:NCHAR)=CHAR 	PREV_CHAR=CHARF 	GO TO 5 C  C  	END C<FF> . 	CHARACTER*(*) FUNCTION NML$NAME_TRANS(STRING) 	CHARACTER*63 LOG_NAME,DEVICE  	CHARACTER*(*) STRINGF C  	INTEGER SYS$TRNLOG1 	PARAMETER SS$_NORMAL='1'X,A 	1	  SS$_NOTRAN='629'X C  C TRANSLATE LOGICAL NAME 	LOG_NAME=STRING 10	LENGTH=63/ 5	IF(LOG_NAME(LENGTH:LENGTH) .NE. ' ') GO TO 15  	LENGTH=LENGTH-1 	GO TO 5 CS 15	ICOLON=INDEX(LOG_NAME,':')L# 	IF (ICOLON .GT. 0) LENGTH=ICOLON-1E C 
 	DO 40 I=1,63T 40 	DEVICE(I:I)=' 'C CR2 	ISTATUS=SYS$TRNLOG(LOG_NAME(1:LENGTH),,DEVICE,,,) C	" 	IF (ISTATUS .EQ. SS$_NOTRAN) THEN 	    NML$NAME_TRANS=DEVICE 	    RETURNT' 	ELSE IF (ISTATUS .NE. SS$_NORMAL) THENN? 	    TYPE *,'ERROR IN DEVICE NAME TRANSLATION',STRING,LOG_NAME,N 	1  	ISTATUS 	NML$NAME_TRANS=' '  	    RETURNN 	ELSEE 	    LOG_NAME=DEVICE             GO TO 10 	ENDIF CR 	END+ 	CHARACTER*(*) FUNCTION NML$LU_TRANS(IUNIT)G 	CHARACTER*2 NUM 	CHARACTER*63 NML$NAME_TRANS 	CHARACTER*6 LU_NAME CP$ C TRANSLATE LOGICAL UNIT INTO STRING 	ENCODE(4,100,NUM) IUNIT 100	FORMAT(I2)' C CONCATENATE TO FORM FORTRAN FILE NAME* 	IF (IUNIT .LT. 10) THEN 	   LU_NAME='FOR00'//NUM(2:2)A 	ELSE6 	   LU_NAME='FOR0'//NUMA 	ENDIF CM% 	NML$LU_TRANS=NML$NAME_TRANS(LU_NAME)T 	RETURNP 	END