<       SUBROUTINE NUMCON(FNUM,IIPOW,CHNUM,NNPOS,NNDEC,IIFLAG) C  C     LIBRARY-ROUTINE  C < C                                                06/AUG/1980> C                                                C.J. KOST SIN C    C     reqd. routines - NONE  C H C***********************************************************************H C*                                                                     *H C*    NUMCON: CONVERTS A FLOATING POINT NUMBER FNUM INTO A CHARACTER   *H C*       STRING CHNUM WITH FORMAT F(NPOS).(NDEC) SUCH THAT:            *H C*       FNUM = CHNUM*(10**IPOW).                                      *H C*    THE CHARACTER STRING CHNUM IS RIGHT-JUSTIFIED IN THE FIELD WIDTH *H C*       OF NPOS CHARACTERS.                                           *H C*    IF IFLAG=0 THE POWER IPOW WILL BE ACCEPTED AS INPUT AND USED BY  *H C*       THE SUBROUTINE.                                               *H C*    IF IFLAG=1 THE POWER IPOW WILL BE DETERMINED BY THE SUBROUTINE   *H C*       SO THAT THE NUMBER FNUM WILL FIT EXACTLY INTO THE FIELD.      *H C*    IF THE NUMBER OF DECIMAL PLACES NDEC IS LESS THAN OR EQUAL TO 0  *H C*       THE DECIMAL POINT IN THE CHARACTER REPRESENTATION OF FNUM     *H C*       WILL BE SUPPRESSED.                                           *H C*                                                                     *H C***********************************************************************H CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC       IMPLICIT INTEGER*4 (I-M)$       INTEGER*2 CHNUM(NNPOS),TCH(20)0       INTEGER*2 DIGIT(10),SIGN(2),DEC,BLANK,STAR:       DATA DIGIT/'0','1','2','3','4','5','6','7','8','9'/,2      * SIGN/'+','-'/,DEC/'.'/,BLANK/' '/,STAR/'*'/       IPOW=IIPOW       NPOS=NNPOS       NDEC=NNDEC       IFLAG=IIFLAGH C***********************************************************************H C*                                                                     *H C*    BLANK OUT THE CHARACTER STRING CHNUM.                            *H C*                                                                     *H C***********************************************************************       IF(IFLAG.NE.1)IFLAG=0        IF(NPOS.GT.0)GO TO 300       WRITE(6,301)NPOSH 301   FORMAT(' ERROR IN NUMCON:  FORMAT FIELD WIDTH = ',I10,' < OR = 0')       RETURN 300   DO 15 I=1,NPOS       CHNUM(I)=BLANK 15    CONTINUEH C***********************************************************************H C*                                                                     *H C*    DETERMINE NINT THE NUMBER OF DIGITS TO THE LEFT OF THE DECIMAL   *H C*       POINT ALLOWED BY THE FORMAT SPECIFICATION.                    *H C*                                                                     *H C***********************************************************************       IF(NDEC.LT.0)NDEC=-1       NINT=NPOS-NDEC-1       IF(FNUM.LT.0.)NINT=NINT-1        IF(NINT.LT.0)GO TO 400H C***********************************************************************H C*                                                                     *H C*    IF IFLAG=0 SCALE FNUM1=ABS(FNUM) DOWN BY 10**IPOW.               *H C*    IF IFLAG=1 DETERMINE IPOW SO THAT CHNUM=FNUM/10**IPOW WILL FIT   *H C*       EXACTLY IN THE FORMAT SPECIFICATION (EVEN WHEN THE NUMBER IS  *H C*       ROUNDED).                                                     *H C*                                                                     *H C***********************************************************************       FNUM1=ABS(FNUM) )       IF(IFLAG.EQ.0)FNUM1=FNUM1/10.**IPOW        IF(IFLAG.NE.1)GO TO 11       IPOW=0       IF(FNUM1.EQ.0.)GO TO 11        FACT=10.**NINT 30    IF(FNUM1.LT.FACT)GO TO 20        IPOW=IPOW+1        FNUM1=FNUM1/10.        GO TO 30# 20    IF(FNUM1.GE.FACT/10.)GO TO 10        IPOW=IPOW-1        FNUM1=FNUM1*10.        GO TO 20 10    NDEC2=NDEC       IF(NDEC2.LT.0)NDEC2=0        FN=(10.**NDEC2)*FNUM1+.5       FT=FACT*(10.**NDEC2)       IF(FN.GE.FT)IPOW=IPOW+1 !       IF(FN.GE.FT)FNUM1=FNUM1/10.IH C***********************************************************************H C*                                                                     *H C*    EXTRACT THE REQUIRED NUMBER OF DIGITS (NDIG) FROM THE FLOATING   *H C*       NUMBER FNUM1, AND CONVERT TO CHARACTERS IN TCH.               *H C*                                                                     *H C*********************************************************************** 11    NDEC2=NDEC       IF(NDEC2.LT.0)NDEC2=0I       NDIG=NINT+NDEC2)"       FFNUM1=(10.**NDEC2)*FNUM1+.5       IF(NDIG.LE.0)GO TO 560       DO 40 I=1,NDIG       INDEX=AMOD(FFNUM1,10.)+1.T*       IF(INDEX.LT.1.OR.INDEX.GT.10)INDEX=1        TCH(NDIG-I+1)=DIGIT(INDEX)       FFNUM1=FFNUM1/10.  40    CONTINUE 560   IF(FFNUM1.GE.1.)GO TO 400IH C***********************************************************************H C*                                                                     *H C*    INSERT THE DECIMAL POINT INTO CHNUM (IF ANY).                    *H C*    THEN STORE THE DECIMAL CHARACTERS (IF ANY) INTO THE DECIMAL      *H C*       PORTION OF CHNUM.                                             *H C*                                                                     *H C***********************************************************************'       IF(NDEC.GE.0)CHNUM(NPOS-NDEC)=DEC        IF(NDEC.LE.0)GO TO 500       DO 550 I=1,NDEC*)       CHNUM(NPOS-NDEC+I)=TCH(NDIG-NDEC+I)C 550   CONTINUEH C***********************************************************************H C*                                                                     *H C*    STORE THE INTEGRAL DIGIT CHARACTERS OF FNUM1 INTO THE INTEGRAL   *H C*       PORTION OF CHNUM.                                             *H C*                                                                     *H C*********************************************************************** 500   IPTR=NPOS-NDEC-1       IPTR2=NDIG-NDEC2       IF(NINT.LE.0)GO TO 600       DO 520 I=1,NINT $       CHNUM(IPTR-I+1)=TCH(IPTR2-I+1) 520   CONTINUEH C***********************************************************************H C*                                                                     *H C*    DETERMINE THE FIRST NON-BLANK NON-ZERO CHARACTER IN CHNUM        *H C*    THEN BLANK OUT UNNECESSARY LEADING ZEROS.                        *H C*                                                                     *H C*********************************************************************** 600   DO 110 II=1,NPOS?       IF(CHNUM(II).NE.DIGIT(1).AND.CHNUM(II).NE.BLANK)GO TO 120T 110   CONTINUE
       II=NPOS*; 120   IF(CHNUM(II).EQ.DEC.AND.II.GE.2.AND.FNUM.GE.0)II=II-1 ;       IF(CHNUM(II).EQ.DEC.AND.II.GE.3.AND.FNUM.LT.0)II=II-1 
       II=II-1 )       IF(II.EQ.0.AND.FNUM.LT.0.)GO TO 400*       IF(II.EQ.0)GO TO 999       DO 521 I=1,IIN       CHNUM(I)=BLANK 521   CONTINUEH C***********************************************************************H C*                                                                     *H C*    INSERT A MINUS SIGN IN THE APPROPRIATE POSITION OF CHNUM IF FNUM *H C*       IS NEGATIVE.                                                  *H C*                                                                     *H C***********************************************************************%       IF(FNUM.LT.0.)CHNUM(II)=SIGN(2)   999  RETURN 400   DO 401 I=1,NPOS        CHNUM(I)=STAR  401   CONTINUE        GO TO 999	       END*