7       SUBROUTINE PAUSE2(MESS,ILINE,ICOLM,KEYDEC,KEYRET) H C***********************************************************************H C                                                                      *H C    Reqd. [KOST.LIBRARY] Routines - NARGS.MAR, TRANSMODE, READKEY     *H C                                                                      *H C      This routine will pause until a key is typed on the terminal.   *H C    If KEYDEC is included in the call to PAUSE2, then the RETURN is   *H C    taken from PAUSE2 only if the key corresponding to ICHAR(KEYDEC)  *H C    is typed.  No RETURN is necessary.  If KEYDEC is not in the call  *H C    to PAUSE2, then any key will cause a RETURN.                      *H C      Also, if KEYDEC is -1 then any key will cause a RETURN.         *H C    If KEYRET is included in the call, then the key corresponding to  *H C    ICHAR(KEYRET) is the key that was typed.                          *H C      If ICOLM is included in the call, then it is the column number  *H C    at which the prompt is to be displayed.  If it is not included,   *H C    then it defaults to 36.  Similarly, ILINE is the line number at   *H C    which the prompt will be displayed and it will default to 24 if   *H C    not included.                                                     *H C      Finally, if MESS is .NE. ' ', then it is the prompt.  If MESS   *H C    is .EQ. ' ', then prompt defaults to 'Pausing...'.                *H C                                                                      *H C    INPUT:         MESS  CHARACTER*132                                *H C                   ILINE INTEGER*4   0 < ILINE < 25                   *H C                   ICOLM INTEGER*4   0 < ICOLM < 134                  *H C                   KEYDEC INTEGER*4                                   *H C    OUTPUT:        KEYRET INTEGER*4                                   *H C                                                                      *H C    Examples:                                                         *H C     CALL PAUSE2('Pausing (type any key to continue) ...',1,1,-1,IRET)*H C               will cause the message                                 *H C               "Pausing (type any key to continue) ..." to be         *H C               displayed at line 1 and column 1.  Any key will cause  *H C               a RETURN, and the key that was typed will be returned  *H C               in IRET.  The character is CHAR(IRET).                 *H C           CALL PAUSE2('Pausing (type key C to continue) ...',1,1,67) *H C               will cause the message                                 *H C               "Pausing (type key C to continue) ..." to be displayed *H C               at line 1 and column 1.  Only key C will cause a       *H C               RETURN.                                                *H C           CALL PAUSE2('...',4,10)                                    *H C               will cause the message "..." to be displayed at        *H C               line 4 and column 10. Any key that is typed will       *H C               cause a RETURN.                                        *H C           CALL PAUSE2('Message',2)                                   *H C               will cause the message "Message" to be displayed at    *H C               line 2 and column 36.  Any key will cause a RETURN.    *H C           CALL PAUSE2('Message')                                     *H C               will cause the message "Message" to be displayed at    *H C               line 24 and column 36.  Any key will cause a RETURN.   *H C           CALL PAUSE2(' ')                                           *H C               will cause the message "Pausing..." to be displayed at *H C               line 24 and column 36.  Any key will cause a RETURN.   *H C                                                                      *H C                                      Author:  Joe Chuma              *H C                                               June 29, 1984          *H C                                               TRIUMF                 *H C                                                                      *H C***********************************************************************G       CHARACTER  MESS*(*),ALTKEY*1,READ_KEY*1,KEY_IN*1,ESC*1,PROMPT*255 -       COMMON    /PLOT_MONITOR/ IMONITOR,IOUTM        DATA ESC / 27 /        DATA IOUT_UNIT / 6 /       NPARS  = NARGS(DUM)        PROMPT = 'Pausing...'        ILIN   = 24        ICOL   = 36        KEYD   = -1        LMESS  = LEN(MESS)       IF(LMESS .NE. 0)THEN         PROMPT = ' '         PROMPT = MESS(1:LMESS)       END IF3       IF(NPARS .GE. 2)  ILIN = MIN(MAX(1,ILINE),24) 4       IF(NPARS .GE. 3)  ICOL = MIN(MAX(1,ICOLM),132)%       IF(NPARS .GE. 4)  KEYD = KEYDEC        NP = LENSIG(PROMPT) (       IL = IFIX(ALOG10(FLOAT(ILIN))) + 1(       IC = IFIX(ALOG10(FLOAT(ICOL))) + 1H C                                                                      *H C    Position the cursor                                               *H C                                                                      *1       IF(IMONITOR .GT. 0)CALL TRANSPARENT_MODE(0) &  10   WRITE(IOUT_UNIT,20)ESC,ILIN,ICOL.  20   FORMAT('+',A1,'[',I<IL>,';',I<IC>,'f',$)H C                                                                      *H C    Erase that line                                                   *H C                                                                      *       WRITE(IOUT_UNIT,30)ESC  30   FORMAT('+',A1,'[2K')H C                                                                      *H C    Reposition the cursor                                             *H C                                                                      *&       WRITE(IOUT_UNIT,20)ESC,ILIN,ICOL5       KEY_IN = READ_KEY('PROMPT',PROMPT(1:NP),ALTKEY) ,       IF(NPARS .GE. 5)KEYRET = ICHAR(KEY_IN)       IF(KEYD .GE. 0)THEN +         IF(ICHAR(KEY_IN) .NE. KEYD)GO TO 10        END IF       RETURN	       END 