       SUBROUTINE PEN_DOWN(X,Y)H C======================================================================C@ C                                                               @ C     PEN_DOWN: moves the pen down to the plot coordinates      @ C               (X,Y) on the screen and hardcopy.               @ C                                                               @ C     Written by Arthur Haynes, TRIUMF U.B.C., July 6, 1981.    @ C                                                               @ C     Input  Parameters: X,Y (R*4).                             @ C                                                               0 C     Modified by Alan Carruthers, July 15, 1983: C       -- call to PUT_METAFILE1 added to support metafile C < C     Modified Feb 21/85 by F. Jones:  check added to bitmap< C     flag WELL to avoid unnecessary calculation of hardcopy> C     coordinates and call to PLOT_HARDCOPY, in the case where C     the bitmap is turned off.  C   H C======================================================================C*       COMMON /PLOT_MONITOR/ IMONITOR,IOUTM       DATA IMONITOR,IOUTM/1,6/E       COMMON /MONITOR_RANGE/ XMINMP,XMAXMP,YMINMP,YMAXMP,XMINM,XMAXM, (      *                       YMINM,YMAXM7       DATA XMINMP,XMAXMP,YMINMP,YMAXMP/0.,639.,0.,479./ 3       DATA XMINM,XMAXM,YMINM,YMAXM/0.,639.,0.,479./ -       COMMON /PLOT_MONITOR2/ IMONITOR2,IOUTM2         DATA IMONITOR2,IOUTM2/0,6/>       COMMON /MONITOR2_RANGE/ XMINMP2,XMAXMP2,YMINMP2,YMAXMP2,9      *                        XMINM2,XMAXM2,YMINM2,YMAXM2 ;       DATA XMINMP2,XMAXMP2,YMINMP2,YMAXMP2/0.,639.,0.,479./ 7       DATA XMINM2,XMAXM2,YMINM2,YMAXM2/0.,639.,0.,479./ A       COMMON /PLOT_HARDCOPY/ XLAST,YLAST,N1,N2,HARDCOPY(188,2048)        LOGICAL*1 HARDCOPY,       DATA XLAST,YLAST,N1,N2/0.,0.,188,2048/B       COMMON /HARDCOPY_RANGE/ XMINHP,XMAXHP,YMINHP,YMAXHP,IORIENTH7       DATA XMINHP,XMAXHP,YMINHP,YMAXHP/0.,639.,0.,479./        DATA IORIENTH/-1/ 9       COMMON /PLOT_TO_HARDCOPY/ RMATRIXHP(2,2),SHIFTHP(2) 3       DATA RMATRIXHP/0.,1.,-1.,0./,SHIFTHP/479.,0./ *       COMMON /METAFILE1/ META_ON, META_LUN       LOGICAL META_ON        COMMON/TO_BIT_OR_NOT/WELL        LOGICAL WELL+       COMMON/PLOT_HARDCOPY_LINEWIDTH/LWIDTH          REAL XDRAW(2),YDRAW(2) C         IF(IMONITOR.EQ.0)GO TO 200B C=================================================================B C==   Clip the line segment (XLAST,YLAST)-->(X,Y) within the    ==B C==   plot coordinates corresponding to the hardcopy window:    ==B C==   XMINMP <= x <= XMAXMP; YMINMP <= y <= YMAXMP.             ==B C=================================================================C       CALL WINDOW_CLIP(XLAST,YLAST,X,Y,XMINMP,XMAXMP,YMINMP,YMAXMP, )      *                 XDRAW,YDRAW,NDRAW)        IF(NDRAW.EQ.0)GO TO 200        IF(NDRAW.EQ.2)GO TO 150 B C=================================================================B C==   NDRAW = 1: (XLAST,YLAST) is in the hardcopy window.       ==B C=================================================================<       CALL PLOT_MONITOR(XDRAW(1),YDRAW(1),2) !Move pen down E                                              !to (XDRAW(1),YDRAW(1)).        GO TO 200 B C=================================================================B C==   NDRAW = 2: (XLAST,YLAST) is outside the hardcopy window.  ==B C=================================================================B 150   CALL PLOT_MONITOR(XDRAW(1),YDRAW(1),3) !Pen up to beginning.C       CALL PLOT_MONITOR(XDRAW(2),YDRAW(2),2) !Draw clipped segment.  C ! 200   IF(IMONITOR2.EQ.0)GO TO 300 B C=================================================================B C==   Clip the line segment (XLAST,YLAST)-->(X,Y) within the    ==B C==   plot coordinates corresponding to the hardcopy window:    ==B C==   XMINMP2 <= x <= XMAXMP2; YMINMP2 <= y <= YMAXMP2.         ==B C=================================================================G       CALL WINDOW_CLIP(XLAST,YLAST,X,Y,XMINMP2,XMAXMP2,YMINMP2,YMAXMP2, )      *                 XDRAW,YDRAW,NDRAW)        IF(NDRAW.EQ.0)GO TO 300        IF(NDRAW.EQ.2)GO TO 250 B C=================================================================B C==   NDRAW = 1: (XLAST,YLAST) is in the hardcopy window.       ==B C==================================================================       CALL PLOT_MONITOR2(XDRAW(1),YDRAW(1),2) !Move pen down  F                                               !to (XDRAW(1),YDRAW(1)).       GO TO 300 B C=================================================================B C==   NDRAW = 2: (XLAST,YLAST) is outside the hardcopy window.  ==B C=================================================================C 250   CALL PLOT_MONITOR2(XDRAW(1),YDRAW(1),3) !Pen up to beginning. D       CALL PLOT_MONITOR2(XDRAW(2),YDRAW(2),2) !Draw clipped segment. C  300   CONTINUEA       XH =   RMATRIXHP(1,1)*X    +RMATRIXHP(1,2)*Y    +SHIFTHP(1) A       YH =   RMATRIXHP(2,1)*X    +RMATRIXHP(2,2)*Y    +SHIFTHP(2)  C ; C     If metafile is active, send graphics primitives to it 5       IF(META_ON) CALL PUT_METAFILE1(META_LUN,'LINE', *      >            XH/2047.,YH/785.,0,IERR)-       IF(.NOT.WELL.OR.IORIENTH.EQ.0)GO TO 350 B C=================================================================B C==   Draw line segment (XLAST,YLAST)-->(X,Y) on hardcopy.      ==B C==   First convert the plot coordinates to the corresponding   ==B C==   hardcopy coordinates using the matrix RMATRIXHP and the   ==B C==   translation vector SHIFTHP:                               ==B C==                                                             ==B C==       |XH|               |X|                                ==B C==       |  | = RMATRIXHP * | | + SHIFTHP                      ==B C==       |YH|               |Y|                                ==B C=================================================================A       XLASTH=RMATRIXHP(1,1)*XLAST+RMATRIXHP(1,2)*YLAST+SHIFTHP(1) A       YLASTH=RMATRIXHP(2,1)*XLAST+RMATRIXHP(2,2)*YLAST+SHIFTHP(2) $       IXLASTH=XLASTH+SIGN(.5,XLASTH)$       IYLASTH=YLASTH+SIGN(.5,YLASTH)       IXH=XH+SIGN(.5,XH)       IYH=YH+SIGN(.5,YH)B C=================================================================B C==   Draw line segment (IXLASTH,IYLASTH)-->(IXH,IYH) (hardcopy ==B C==   dot coordinates) on the hardcopy bitmap: HARDCOPY(N1,N2). ==B C=================================================================       IF(LWIDTH.LE.1)THEN F         CALL PLOT_HARDCOPY(IXLASTH,IYLASTH,IXH,IYH,HARDCOPY,188,N1,N2)
       ELSE         LIM2=LWIDTH/2          LIM1=-LIM2)         IF(MOD(LWIDTH,2).EQ.0)LIM1=LIM1+1          DO IDY=LIM1,LIM2           DO IDX=LIM1,LIM2G             CALL PLOT_HARDCOPY(IXLASTH+IDX,IYLASTH+IDY,IXH+IDX,IYH+IDY, !      #        HARDCOPY,188,N1,N2)            ENDDO 
         ENDDO        ENDIF B C=================================================================B C==   Set (XLAST,YLAST) to the new pen position (X,Y).          ==B C=================================================================
 350   XLAST=X 
       YLAST=Y        RETURN	       END 