;       SUBROUTINE PLOT3D(IVXYZ, XDATA, YDATA, ZDATA, XSCALE, 8      *   YSCALE, ZSCALE, NLINE, NPNTS, PHI, THETA, XREF,$      *   YREF, XLENTH, MASK, VERTEX) C  C     LIBRARY-ROUTINE  C < C                                                05/AUG/1980> C                                                C.J. KOST SIN C   ) C     reqd. KOSTL: routines - IPLOT,JPLOT  C 2 C MASKED 3-DIMENSIONAL PLOT PROGRAM WITH ROTATIONS8 C THIS ROUTINE WILL ACCEPT 3-DIMENSIONAL DATA IN VARIOUS4 C FORMS AS INPUT, ROTATE IT IN 3-SPACE TO ANY ANGLE,: C AND PLOT THE PROJECTION OF THE RESULTING FIGURE ONTO THE6 C XY PLANE.  LINEAR INTERPOLATION IS USED BETWEEN DATA< C POINTS.  THOSE LINES OF A FIGURE WHICH SHOULD BE HIDDEN BY C A PREVIOUS LINE ARE MASKED. 8 C THE MASKING TECHNIQUE USED BY THIS ROUTINE IS BASED ON C TWO PREMISES -5 C      LINES IN THE FOREGROUND (POSITIVE Z DIRECTION) 2 C      ARE PLOTTED BEFORE LINES IN THE BACKGROUND.8 C      A LINE OR PORTION OF A LINE IS MASKED (HIDDEN) IF6 C      IT LIES WITHIN THE REGION BOUNDED BY PREVIOUSLY C      PLOTTED LINES. 7 C EACH CALL TO PLOT3D CAUSES ONE LINE OF A FIGURE TO BE 
 C PLOTTED.; C TWO PARAMETERS OF THE PLOTTER ARE SET ON THE INITIAL CALL  C FOR EACH FIGURE - 6 C (PIPI) IS THE NUMBER OF PLOTTER INCREMENTS PER INCH.9 C (NYPI) IS THE NUMBER OF INCREMENTS AVAILABLE ACROSS THE " C WIDTH OF THE PAGE (Y-DIRECTION).; C WHEN A NEW FIGURE IS INITIATED, THE PLOTTER ORIGIN IS SET 8 C AT THE BOTTOM OF THE PAPER BY PLOT3D AND SHOULD NOT BE& C MOVED UNTIL THE FIGURE IS COMPLETED. C INPUT PARAMETERS -: C (IVXYZ) IS A FOUR DIGIT DECIMAL INTEGER WHICH IS USED TO8 C SELECT VARIOUS INPUT/OUTPUT OPTIONS.  THESE DIGITS, IN: C DECREASING ORDER OF MAGNITUDE, WILL BE REFERRED TO AS V, C X, Y, AND Z.; C IF V .NE. 0, THE VERTICES OF THE CURRENT FIGURE AND THEIR 7 C PROJECTION ONTO THE Y=0 PLANE, WILL BE STORED IN A 16 8 C ENTRY REAL ARRAY (VERTEX), AND WILL BE UPDATED AS EACH7 C LINE IS PLOTTED.  THESE COORDINATES ARE IN INCHES AND 8 C RELATIVE TO THE CURRENT PLOTTER ORIGIN.  THE X Y PAIRS7 C ARE ORDERED SO THAT THE FIRST PAIR CORRESPONDS TO THE 8 C FIRST POINT OF THE FIGURE, THE SECOND PAIR CORRESPONDS8 C TO THE LAST POINT OF THE FIRST LINE, AND THE FOLLOWING< C PAIRS ARE ORDERED IN A CIRCULAR FASHION.  THE PAIRS ON THE9 C Y=0 PLANE OF THE FIGURE, THEN FOLLOW IN THE SAME ORDER. 9 C IF V=0, THE VERTEX PARAMETER IS IGNORED, BUT SHOULD NOT  C BE DELETED9 C IF X=0, THE X-COMPONENTS OF THIS LINE ARE ASSUMED TO BE % C EQUALLY SPACED, AND ARE COMPUTED BY  C      X(I)=XDATA+(I-1)*XSCALE; C WHERE (XDATA) IS THE INITIAL VALUE IN INCHES AND (XSCALE) < C IS THE SPACING BETWEEN POINTS IN INCHES.  IF X .NE. 0, THE6 C X-COMPONENTS OF THIS LINE ARE READ FROM AN ARRAY AND
 C MODIFIED BY  C      X(I)=XDATA(I)*XSCALE # C WHERE (XSCALE) IS A SCALE FACTOR. ; C THE SAME RELATIONS HOLD FOR THE Y-COMPONENTS, THAT IS, IF  C Y=0  C      Y(I)=YDATA+(I-1)*YSCALE C AND IF Y .NE. 0  C      Y(I)=YDATA(I)*YSCALE : C IF Z=0, THE Z-COMPONENTS OF THIS LINE ARE ALL ASSUMED TO C BE EQUAL, AND ARE COMPUTED BY " C      Z(I)=ZDATA+(NLINE-1)*ZSCALE: C WHERE (NLINE) IS SOME INTEGER ASSOCIATED WITH THIS LINE. C IF Z .NE. 0, AGAIN WE HAVE C      Z(I)=ZDATA(I)*ZSCALE : C WHEN (NLINE) IS EQUAL TO ONE, IT INDICATES THE BEGINNING: C OF A NEW FIGURE.  A CALL TO PLOT3D WITH (NLINE) EQUAL TO< C ZERO BEFORE INITIATING A NEW FIGURE SIMULATES A LINE DRAWN; C AT THE BOTTOM OF THE PAGE.  THEREFORE ONLY THOSE PORTIONS ; C OF A LINE LYING ABOVE ALL PREVIUOS LINES WILL BE PLOTTED. 2 C ALL OTHER PARAMETERS ARE IGNORED ON SUCH A CALL.: C (NPNTS) IS THE NUMBER OF POINTS ON THIS LINE, AND MAY BE C ALTERED FROM LINE TO LINE.; C (PHI) AND (THETA) ARE THE TWO ANGLES (IN DEGREES) USED TO < C SPECIFY THE DESIRED 3-DIMENSIONAL ROTATION.  THE FOLLOWING5 C TWO DEFINITIONS OF THESE ROTATIONS ARE EQUIVALENT - < C IN TERMS OF ROTATIONS OF AXES, THE INITIAL SYSTEM OF AXES,: C XYZ, IS ROTATED BY AN ANGLE (PHI) COUNTERCLOCKWISE ABOUT: C THE Y-AXIS, AND THE RESULTANT SYSTEM IS LABELLED THE TUV: C AXES.  THE TUV AXES ARE THEN ROTATED BY AN ANGLE (THETA): C COUNTERCLOCKWISE ABOUT THE T-AXIS, AND THIS FINAL SYSTEM6 C IS LABELLED THE PQR AXES.  THE PLOTTED FIGURE IS THE6 C PROJECTION OF THE ORIGINAL FIGURE ONTO THE PQ-PLANE.: C IN TERMS OF ROTATION OF COORDINATES, THE FIGURE IS FIRST9 C ROTATED BY AN ANGLE (THETA) CLOCKWISE ABOUT THE X-AXIS. 8 C THE RESULTANT FIGURE IS THEN ROTATED BY AN ANGLE (PHI)8 C CLOCKWISE ABOUT ITS Y-AXIS.  THE PLOTTED FIGURE IS THE4 C PROJECTION OF THIS FINAL FIGURE ONTO THE XY-PLANE.4 C WARNING. SOME ROTATIONS WILL ALTER THE FOREGROUND/1 C BACKGROUND RELATIONSHIPS BETWEEN THE LINES, ANDP1 C THUS THE ORDER IN WHICH THEY SHOULD BE PLOTTED.A3 C (XREF) AND (YREF) ARE THE COORDINATES, IN INCHES,N: C RELATIVE TO THE PLOTTER ORIGIN, TO BE USED AS THE ORIGIN C OF THE FIGURE.9 C (XLENTH) IS THE LENGTH, IN INCHES, TO WHICH THE PLOT ISA9 C RESTRICTED.  ANY POINT WHICH EXCEEDS THIS LIMIT, OR THEO8 C LIMITS OF THE PAPER IN THE Y-DIRECTION (NYPI), WILL BE C SET TO THAT LIMIT.; C (MASK) IS AN INTEGER ARRAY OF 2*XLENTH*PIPI ENTRIES WHICH 8 C IS USED TO STORE THE MASK.  THE CONTENTS OF THIS ARRAY8 C SHOULD NOT BE ALTERED DURING THE PLOTTING OF ANY GIVEN	 C FIGURE. 8 C ALL PARAMETERS EXCEPT (MASK) AND (VERTEX) ARE RETURNED C UNCHANGED.: C BETWEEN ANY TWO CALLS FOR THE SAME FIGURE, ANY PARAMETER: C CAN BE MEANINGFULLY CHANGED EXCEPT (XLENTH), (MASK), AND C (VERTEX). E CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCTF       COMMON /PL3D/INDX,INDY,INDZ,A11,A13,A21,A23,A22,PIPI,NYPI,LIMITX       COMMON /PL3D/SPHI,STHETA&       COMMON /JXPLT/JXOLD,JYOLD,IPNOLD!       INTEGER HIGH, OLDHI, OLDLOWE6       DIMENSION XDATA(1), YDATA(1), ZDATA(1), MASK(1),      *    VERTEX(1) 5       DATA INIT, JVXYZ, SPHI, STHETA/-1, -1, -1.0E38,F      *   -1.0E38/,       IROUND(X) = X + 0.5T C INITIALIZATION PROCEDURESG+ C INITIALIZATION PROCEDURE FOR A NEW FIGUREN& C TEST FOR SPECIAL MASK MODIFYING CALL       IF (NLINE.EQ.0) GO TO 550T) C DETERMINE IF INITIALIZATION IS REQUIREDI       IF (NLINE.NE.1) GO TO 20 C SET PLOTTER PARAMETERS       PIPI = 100.0       PIPI = 400.0       NYPI = 1090A       NYPI = 4360H- C RESET PLOTTER ORIGIN TO BOTTOM OF PLOT PAGER       I = NYPI + 100       I = NYPI + 400 C      CALL IPLOT(0, -I, -3)+ C COMPUTE LENGTH OF PLOT PAGE IN INCREMENTS         LIMITX = XLENTH*PIPI + 0.5       I = LIMITX + LIMITXA; C INITIALIZE MASKING ARRAY OVER THE LENGTH OF THE PLOT PAGEO       DO 10 K=1,IT       MASK(K) = INIT    10      CONTINUE        INIT = -1 : C SET THE NECESSARY INDICATORS FOR THE FIRST LINE OF A NEW C FIGURE       INCI = -1A       I = 0I& C INPUT TYPE AND VERTEX INITIALIZATION) C DETERMINE IF INITIALIZATION IS REQUIRED.'    20      IF (JVXYZ.EQ.IVXYZ) GO TO 70R< C SET INDICATORS FOR TYPES OF INPUT DATA AND SAVING VERTICES       JVXYZ = IVXYZC       INDZ = 1       INDY = 1       INDX = 1       INDV = 1!       IF (JVXYZ.LT.1000) GO TO 30        INDV = 2       JVXYZ = JVXYZ - 1000%    30      IF (JVXYZ.LT.100) GO TO 40Z       INDX = 2       JVXYZ = JVXYZ - 100S$    40      IF (JVXYZ.LT.10) GO TO 50       INDY = 2       JVXYZ = JVXYZ - 10#    50      IF (JVXYZ.LT.1) GO TO 60I       INDZ = 2    60      JVXYZ = IVXYZ C ROTATION INITIALIZATION() C DETERMINE IF INITIALIZATION IS REQUIRED :    70      IF (PHI.EQ.SPHI .AND. THETA.EQ.STHETA) GO TO 80 C COMPUTE ROTATION FACTORS"       SPHI = SIN(0.0174532925*PHI)"       CPHI = COS(0.0174532925*PHI)&       STHETA = SIN(0.0174532925*THETA)&       CTHETA = COS(0.0174532925*THETA)       A11 = CPHI       A13 = -SPHIL       A21 = STHETA*SPHIN       A22 = CTHETA       A23 = STHETA*CPHI        SPHI = PHI       STHETA = THETA C PROCESSING PROCEDURES : C SET FLAG TO MOVE THROUGH THE DATA ARRAYS IN THE OPPOSITE C DIRECTIONH    80      INCI = -INCIO2 C SET INDICATOR TO THE FIRST POINT TO BE PROCESSED       IF (I.NE.0) I = NPNTS + 1T/ C LOOP TO PROCESS EACH POINT IN THE DATA ARRAYSA       DO 530 K=1,NPNTS C DATA CALCULATION       I = I + INCI       GO TO (90,100), INDX&    90      X = XDATA(1) + (I-1)*XSCALE       GO TO 110R   100      X = XDATA(I)*XSCALE    110      GO TO (120,130), INDY&   120      Y = YDATA(1) + (I-1)*YSCALE       GO TO 140    130      Y = YDATA(I)*YSCALE    140      GO TO (150,160), INDZ*   150      Z = ZDATA(1) + (NLINE-1)*ZSCALE       GO TO 170F   160      Z = ZDATA(I)*ZSCALE C DATA ROTATIONC%   170      XXX = A11*X + A13*Z + XREFN       XX = XXX       IX = IROUND(XX*PIPI)        YYY = A21*X + A23*Z + YREF       YY = YYY + A22*Y       IY = IROUND(YY*PIPI) C RESTRICT FIGURE TO PLOT PAGE C     IF(IX.LE.0)IX=1L C     IF(IX.GT.LIMITX)IX=LIMITXU C     IF(IY.LT.10)IY=10T C     IF(IY.GT.NYPI)IY=NYPID       IF (K.NE.1) GO TO 250O: C (LOC) IS THE POSITION OF THE PREVIOUS POINT WITH RESPECT
 C TO THE MASK  C      +1  ABOVE THE MASKS' C      0  WITHIN THE LIMITS OF THE MASKE C      -1  BELOW THE MASKE* C PROCEDURE FOR INITIAL POINT OF EACH LINE4 C LOCATE INITIAL POINT WITH RESPECT TO THE MASK THEN C UPDATE THE MASKD       LOW = IX + IX        HIGH = LOW - 1       MLOW = MASK(LOW)       MHIGH = MASK(HIGH)!       IF (MHIGH-IY) 200, 210, 180T%   180      IF (MLOW-IY) 190, 230, 220    190      LOCOLD = 0U       GO TO 240    200      MASK(HIGH) = IY$       IF (MLOW.EQ.-1) MASK(LOW) = IY   210      LOCOLD = +1       GO TO 240    220      MASK(LOW) = IYF   230      LOCOLD = -1+ C MOVE THE RAISED PEN TO THIS INITIAL POINT(    240      CALL IPLOT(IX, IY, 3)
       JX = IXC
       JY = IYC       IYREF = IY       JXOLD=JX       JYOLD=JY       IPNOLD=2       IF(LOCOLD.EQ.0) IPNOLD=3 C STORE VERTICES IF REQUESTEDT       IF (INDV.EQ.1) GO TO 530       INDEX = INCI + 6       VERTEX(INDEX) = XX       VERTEX(INDEX+1) = YY       VERTEX(INDEX+8) = XXX        VERTEX(INDEX+9) = YYYA       IF (NLINE.NE.1) GO TO 530,       VERTEX(1) = XX       VERTEX(2) = YY       VERTEX(9) = XXXA       VERTEX(10) = YYY       GO TO 530O3 C SPECIAL CASE WHERE CHANGE IN X COORDINATE IS ZEROI: C A SPECIAL PROVISION IS MADE AT THIS POINT SO THAT A LINE: C WILL NOT MASK ITSELF AS LONG AS THE X COORDINATE REMAINS
 C CONSTANT"   250      IF (IX.NE.JX) GO TO 260
       JY = IY0       GO TO 2801, C COMPUTE CONSTANTS FOR LINEAR INTERPOLATION0   260      YINC = FLOAT(IY-JY)/ABS(FLOAT(IX-JX))        INCX = (IX-JX)/IABS(IX-JX)
       YJ = JY): C PERFORM LINEAR INTERPOLATION AT EACH INCREMENTAL STEP ON C THE X AXIS   270      JX = JX + INCXL       YJ = YJ + YINC       JY = IROUND(YJ)E; C LOCATE THE CURRENT POINT WITH RESPECT TO THE MASK AT THATN4 C POINT THEN PLOT THE INCREMENT AS A FUNCTION OF THE9 C LOCATION OF THE PREVIOUS POINT WITH RESPECT TO ITS MASK        LOW = JX + JX        HIGH = LOW -1E       MLOW = MASK(LOW)       MHIGH = MASK(HIGH)&   280      IF (MHIGH-JY) 300, 300, 290%   290      IF (MLOW-JY) 310, 320, 320S% C THE CURRENT POINT IS ABOVE THE MASKT   300      LOC = +1V       IF (LOCOLD) 360, 370, 430=& C THE CURRENT POINT IS WITHIN THE MASK   310      LOC = 0       IF (LOCOLD) 340, 350, 330 % C THE CURRENT POINT IS BELOW THE MASKX   320      LOC = -1        IF (LOCOLD) 510, 450, 440Y- C PLOT FROM ABOVE THE MASK TO WITHIN THE MASK 7   330      IF (MHIGH.LE.IYREF) CALL JPLOT(JX, MHIGH, 2)J       GO TO 3506- C PLOT FROM BELOW THE MASK TO WITHIN THE MASK 5   340      IF (MLOW.GE.IYREF) CALL JPLOT(JX, MLOW, 2) . C PLOT FROM WITHIN THE MASK TO WITHIN THE MASK    350      CALL JPLOT(JX, JY, 3)       GO TO 520S, C PLOT FROM BELOW THE MASK TO ABOVE THE MASK(   360      IF (MLOW-IYREF) 370, 380, 380- C PLOT FROM WITHIN THE MASK TO ABOVE THE MASK0)   370      IF (MHIGH-IYREF) 400, 390, 3901"   380      CALL JPLOT(JX, MLOW, 2)#   390      CALL JPLOT(JX, MHIGH, 3)E       GO TO 430P%   400      IF (MHIGH.EQ.-1) GO TO 430S       OLDHI = HIGH - 2*INCXT'       IF (MASK(OLDHI)-JY) 420, 420, 410O    410      CALL JPLOT(JX, JY, 3)       GO TO 430 .   420      CALL JPLOT(JX-INCX, MASK(OLDHI), 3), C PLOT FROM ABOVE THE MASK TO ABOVE THE MASK   430      MASK(HIGH) = JY$       IF (MLOW.EQ.-1) MASK(LOW) = JY       CALL JPLOT(JX, JY, 2)N       GO TO 5209, C PLOT FROM ABOVE THE MASK TO BELOW THE MASK)   440      IF (MHIGH-IYREF) 460, 460, 450A- C PLOT FROM WITHIN THE MASK TO BELOW THE MASK (   450      IF (MLOW-IYREF) 470, 470, 480#   460      CALL JPLOT(JX, MHIGH, 2)I"   470      CALL JPLOT(JX, MLOW, 3)       GO TO 510     480      OLDLOW = LOW - 2*INCX(       IF (MASK(OLDLOW)-JY) 490, 500, 500    490      CALL JPLOT(JX, JY, 3)       GO TO 510A/   500      CALL JPLOT(JX-INCX, MASK(OLDLOW), 3)X, C PLOT FROM BELOW THE MASK TO BELOW THE MASK   510      MASK(LOW) = JYY       CALL JPLOT(JX, JY, 2)T   520      IYREF = JY        LOCOLD = LOC       IF (JX.NE.IX) GO TO 270T       ISV=IPNOLD       CALL JPLOT(JX, JY, -1)       IPNOLD=ISV   530      CONTINUEO C RAISE PENT       CALL IPLOT(JX, JY, 3)O C STORE VERTICES IF REQUESTED        IF (INDV.EQ.1) GO TO 540       INDEX = -INCI + 6        VERTEX(INDEX) = XX       VERTEX(INDEX+1) = YY       VERTEX(INDEX+8) = XXXE       VERTEX(INDEX+9) = YYY        IF (NLINE.NE.1) GO TO 540E       VERTEX(3) = XX       VERTEX(4) = YY       VERTEX(11) = XXX       VERTEX(12)= YYY    540      I = I - 1 C RETURN TO CALLING PROGRAM        RETURN: C OPTION TO MODIFY THE MASKING TECHNIQUE TO BE USED ON THE8 C FOLLOWING FIGURE SO AS TO PLOT ONLY ABOVE ALL PREVIOUS C LINES.   550      INIT = 0        RETURN	       END 