+         SUBROUTINE PLOT_COLOR(ICODE,ICODE2) H C======================================================================CH C  PLOT_COLOR                                                          CH C  Sets the plotting color for subsequent graphics on these devices:   CH C                                                                      CH C    VS11, HP, ZETA, CIT-467, TEKTRONIX-4107, VT241, HOUSTON,          CH C    SEIKO GR-1105, VAXSTATION                                         CH C                                                                      CH C  INPUTS:                                                             CH C            ICODE = COLOR CODE (0 TO 15 FOR PRESENT SYSTEM FOR        CH C                    VS11;  1 TO 8 FOR ZETA PLOTTER                    CH C                    1 OR 2 FOR HP; 0 TO 7 FOR CIT-467                 CH C                    0 TO 15 FOR TEKTRONIX-4107.                       CH C                    1 TO 7 FOR VAXSTATION                             CH C                                                                      CH C  In the absence of a call to PLOT_COLOR, the pen color for the VS11  CH C  defaults to 15, and for ZETA defaults to 1, the HP defaults to 1    CH C  and CIT-467 defaults to latest setting!.                            CH C                                                                      CH C  Colour codes on the TEKTRONIX-4107:                                 CH C  -----------------------------------                                 CH C      0          1     2     3      4    5        6      7       8    CH C  Transparent  White  Red  Green  Blue  Cyan  Magenta  Yellow  Orange CH C      9            10         11          12           13             CH C  Green-Yellow  Green-Cyan  Blue-Cyan  Blue-Magenta  Red-Magenta      CH C     14          15                                                   CH C  Dark-Grey  Light-Grey                                               CH C                                                                      CH C                                                                      CH C  Modified by Alan Carruthers, July 15, 1983                          CH C         -- call to PUT_METAFILE1 added to support metafile           CH C                                                                      CH C  Modified May 8/84 by F. Jones to store current CIT colour           CH C  setting for communication with PLOT_DATA_LEVEL.  Probably           CH C  a temporary modification, until a canonical method of               CH C  colour representation & storage is devised.                         CH C                                                                      CH C  Modified by Bernard Henin, July/84, to include the TEKTRONIX-4107.  CH C                                                                      CH C  Modified by F.W. Jones, August 1984, to include the VT241.          CH C  Modified by F.W. Jones, Sept 27/84, to store the colour code        CH C  for output to EDGR drawing files.                                   CH C  Modified by F.W. Jones, Aug 11/86, to support the Houston           CH C  Instruments plotter.                                                CH C  Modified by F.W. Jones, Mar 20/87, for Seiko GR-1105 terminal       CH C                                                                      CF C ***	THIS MODULE INCLUDES THE DEFINITIONS OF ALL COMMON             CF C ***	BLOCKS IN THE VS11 SUBROUTINE PACKAGE.                         CH C                                                                      CH C======================================================================C   	IMPLICIT INTEGER*2 (A-Z)            INTEGER*4 ICODE,ICODE2  - 	INTEGER*4 CHANNL,VSLS,VSPOS,AXLS,FUNC,IOUTTY )         COMMON / PLOT_OUTPUT_UNIT /IOUTTY          DATA IOUTTY/6/ 	LOGICAL VSBUG. 	COMMON / VSVARS / VSCHAR,VSSVEC,VSLVEC,VSPNT,/      *	VSTA,VSTB,VSTC,VSEINT,VSSTOP,VSNSTP,SMM,       *	VSDCLR,VSDSET,CHANL1,      *	CHANL2,CHANL3,CHANL4,6      *	VSRW,VSRO,VSWO,SWENA,W1SENA,WRT1S,INTSFY,SIGNB,7      *	RESET,DRAW,MOVE,DOT,TEXT,COLOR,CURSOR,FILL,HIST, #      *	SCRNX,SCRNY,MAXINT,SOK,SNOK, .      *	VSJOY,VSCON,VSCOFF,VSCURD,CURON,CUROFF,(      *	VSBUG,VSXPOS,VSYPOS,SBASE,HISINC,/      *	RELPT,BITMP0,BITMP1,RUNLNG,SHBASE,DJUMP, -      *	DJMS,PIXRDB,DNOP,MARKER,HISTOX,HISTOY, -      *	BLINK,NBLINK,SIMSW,GPINC,LCURS,PXDENA,        *  HGFILL,HISTO,INHINC,PDCE' 	COMMON / VSTICK / MATCH,SWITCH,VSRJOY,       *	NMATCH,NSWTCH,VSLS,AXLS$ 	COMMON / VSIO / VSDEV,CHANNL,CMODE,#      *	VSBLEN,VSBPOS,VSIOSB(4),FUNC * 	COMMON / VSDF / DFSTRT(1000),VSBUFF(8192) C ***	END OF VSDEFS.FOR *       COMMON /PLOT_MONITOR/ IMONITOR,IOUTM       INTEGER*4 IMONITOR,IOUTM       DATA IMONITOR,IOUTM/1,6/-       COMMON /PLOT_MONITOR2/ IMONITOR2,IOUTM2         INTEGER*4 IMONITOR2,IOUTM2        DATA IMONITOR2,IOUTM2/0,6/*       COMMON /METAFILE1/ META_ON, META_LUN       LOGICAL META_ON        INTEGER*4 META_LUN,IERR  C )       COMMON/CIT_COLOUR/ICITCOL1,ICITCOL2 !       INTEGER*4 ICITCOL1,ICITCOL2 ,       COMMON/EDGR_ATT_SET/IFONT_SET,ICOL_SET"       INTEGER*4 IFONT_SET,ICOL_SET C @ C   This common block contains the two numbers ICODE, and ICODE2B C   for use by other routines that need to know the current colour C   codes, e.g. GPLOT  C 0       COMMON /PLOT_COLOURS/ ICOLOUR_1, ICOLOUR_2#       INTEGER*4 ICOLOUR_1,ICOLOUR_2  C "       LOGICAL*1 TEK4107_INDEX (16)F       DATA TEK4107_INDEX /Z30, Z31, Z32, Z33, Z34, Z35, Z36, Z37, Z38,<      *                    Z39, Z3A, Z3B, Z3C, Z3D, Z3E, Z3F/ C        COMMON /PLOT_CLEAR/ CLEAR        LOGICAL CLEAR/.TRUE./  C        LOGICAL*1 ESC/27/  C ; C If metafile is active send color information to metafile. , C ICODE=  1 white   2 red   3 green   4 blue<       IF(META_ON) CALL PUT_METAFILE1(META_LUN,'COLOR',0.,0.,B      >                               JMIN0(4,JMAX0(1,ICODE)),IERR) C D C Make the colour code available for encoding to EDGR drawing files:"       ICOL_SET=MIN(127,ABS(ICODE)) C H C======================================================================C C  First monitorH C======================================================================C C VS11:        IF(IMONITOR.EQ.3) THEN         CMODE = COLOR          INTSTY = ABS(ICODE) #         INTSTY = MIN(INTSTY,MAXINT)           INTSTY = INTSTY * '100'O0         IF (VSBUG) WRITE(IOUTTY,10) CODE, INTSTY 10      FORMAT(' VSCOLR:',2I3)5         CALL VSDPLY(((VSPNT + INTSTY).OR.VSEINT),SOK)  C  C Zeta: !       ELSE IF(IMONITOR.EQ.4) THEN ,         IF( .NOT.CLEAR )CALL Z_NEWPEN(ICODE) C  C HP:         ELSE IF(IMONITOR.EQ.5)THEN-         IF( .NOT.CLEAR )CALL HP_NEWPEN(ICODE)  C  C CIT:!       ELSE IF(IMONITOR.EQ.6) THEN !         WRITE(IOUTM,110)'1B'X,'1'  110     FORMAT('+',2A1)          CALL FLUSH_PLOT -         IF(ICODE.LT.0.OR.ICODE.GT.7)GO TO 500  C Store colour code:         ICITCOL1=ICODE:         IF(ICODE.EQ.0) WRITE(IOUTM,110)'1B'X,'h'   ! BLACK8         IF(ICODE.EQ.1) WRITE(IOUTM,110)'1B'X,'i'   ! RED9         IF(ICODE.EQ.2) WRITE(IOUTM,110)'1B'X,'j'   ! BLUE ;         IF(ICODE.EQ.3) WRITE(IOUTM,110)'1B'X,'k'   ! VIOLET :         IF(ICODE.EQ.4) WRITE(IOUTM,110)'1B'X,'l'   ! GREEN;         IF(ICODE.EQ.5) WRITE(IOUTM,110)'1B'X,'m'   ! YELLOW 9         IF(ICODE.EQ.6) WRITE(IOUTM,110)'1B'X,'n'   ! CYAN :         IF(ICODE.EQ.7) WRITE(IOUTM,110)'1B'X,'o'   ! WHITE C  C TEKTRONIX-4107: $       ELSE IF (IMONITOR .EQ. 7) THEN         CALL FLUSH_PLOT          ICITCOL1=ICODEH         WRITE (IOUTM, 60100) '1B'X, '4D'X, '4C'X, TEK4107_INDEX(ICODE+1) 60100   FORMAT (1X, 4A1) C  C VT241:        ELSE IF(IMONITOR.EQ.8)THEN-         IF(ICODE.LT.0.OR.ICODE.GT.3)GO TO 500          CALL FLUSH_PLOT +         WRITE(IOUTM,1000)'W(I',ICODE+48,')'  1000    FORMAT(1X,A,A1,A)  C  C Houston plotter:!       ELSE IF(IMONITOR.EQ.11)THEN 2         IF( .NOT.CLEAR )CALL HOUSTON_NEWPEN(ICODE) C  C Seiko GR-1105:!       ELSE IF(IMONITOR.EQ.12)THEN -         IF(ICODE.LT.0.OR.ICODE.GT.7)GO TO 500          CALL FLUSH_PLOT 4         WRITE(IOUTM,2000)ESC,'K ',ESC,'gB',' '+ICODE$ 2000    FORMAT('+',A1,A2,A1,A2,A1,$)   C VaxStation!       ELSE IF(IMONITOR.EQ.15)THEN          CALL VST_PLOT_FLUSH #         CALL VST_PLOT_COLOUR(ICODE)        ENDIF  C H C======================================================================C C  Second monitor:H C======================================================================C C VS11:  500   IF(IMONITOR2.EQ.3) THEN            CMODE = COLOR          INTSTY = ABS(ICODE2)#         INTSTY = MIN(INTSTY,MAXINT)           INTSTY = INTSTY * '100'O0         IF (VSBUG) WRITE(IOUTTY,10) CODE, INTSTY5         CALL VSDPLY(((VSPNT + INTSTY).OR.VSEINT),SOK)  C  C Zeta: "       ELSE IF(IMONITOR2.EQ.4) THEN-         IF( .NOT.CLEAR )CALL Z_NEWPEN(ICODE2)  C  C HP: !       ELSE IF(IMONITOR2.EQ.5)THEN .         IF( .NOT.CLEAR )CALL HP_NEWPEN(ICODE2) C  C CIT:"       ELSE IF(IMONITOR2.EQ.6) THEN"         WRITE(IOUTM2,110)'1B'X,'1'         CALL FLUSH_PLOT          ICITCOL2=ICODE2 5         IF(ICODE2.EQ.0) WRITE(IOUTM2,110)'1B'X,'h'    5         IF(ICODE2.EQ.1) WRITE(IOUTM2,110)'1B'X,'i'    4         IF(ICODE2.EQ.2) WRITE(IOUTM2,110)'1B'X,'j'  5         IF(ICODE2.EQ.3) WRITE(IOUTM2,110)'1B'X,'k'    5         IF(ICODE2.EQ.4) WRITE(IOUTM2,110)'1B'X,'l'    2         IF(ICODE2.EQ.5) WRITE(IOUTM2,110)'1B'X,'m'5         IF(ICODE2.EQ.6) WRITE(IOUTM2,110)'1B'X,'n'    5         IF(ICODE2.EQ.7) WRITE(IOUTM2,110)'1B'X,'o'     C  C TEKTRONIX-4107: %       ELSE IF (IMONITOR2 .EQ. 7) THEN          CALL FLUSH_PLOT          ICITCOL2=ICODE2 H         WRITE(IOUTM, 60100) '1B'X, '4D'X, '4C'X, TEK4107_INDEX(ICODE2+1) C  C VT241:!       ELSE IF(IMONITOR2.EQ.8)THENE/         IF(ICODE2.LT.0.OR.ICODE2.GT.3)GO TO 999=         CALL FLUSH_PLOT=-         WRITE(IOUTM2,1000)'W(I',ICODE2+48,')'  C  C Houston plotter:"       ELSE IF(IMONITOR2.EQ.11)THEN3         IF( .NOT.CLEAR )CALL HOUSTON_NEWPEN(ICODE2)e Ce C Seiko GR-1105:"       ELSE IF(IMONITOR2.EQ.12)THEN/         IF(ICODE2.LT.0.OR.ICODE2.GT.7)GO TO 999C         CALL FLUSH_PLOTT6         WRITE(IOUTM2,2000)ESC,'K ',ESC,'gB',' '+ICODE2       ENDIF  C  999   ICOLOUR_1 = ICODE        ICOLOUR_2 = ICODE2       RETURN	       END 