(       SUBROUTINE PLOT_DATA_LEVEL(ILEVEL)H C======================================================================CH C                                                                      CH C   PLOT_DATA_LEVEL: sets the drawing mode on raster or                CH C                      bit-mapped devices                              CH C                                                                      CH C   Written by Arthur Haynes, TRIUMF U.B.C., JULY 6, 1981.             CH C                                                                      CH C   Input  Parameters: ILEVEL (I*4).                                   CH C                                                                      CH C   Parameter Definitions:                                             CH C   --------- -----------                                              CH C                                                                      CH C   ILEVEL:                                                            CH C           = 0: dots turned on (default)                              CH C           = 1: dots turned off                                       CH C           = 2: dots complemented or toggled.                         CH C                                                                      CH C  Modified May 8/84 by F. Jones to support selective erase            CH C  (ILEVEL=1) on the CIT-467 colour terminal.  This involves           CH C  setting the graphics writing colour to black.                       CH C                                                                      CH C  Modified August/84 by F.W. Jones to support the VT241.              CH C  Modified Oct 4/85 by F.W. Jones to support the Plessey PT100.       CH C  Modified Dec 5/85 by F.W. Jones to support the QMS Lasergrafix      CH C  Modified Mar 20/87 by F.W. Jones for the Seiko GR-1105 terminal     CH C                                                                      CH C======================================================================C       COMMON /PLOT_LEVEL/ ILEV       DATA ILEV/0/*       COMMON /PLOT_MONITOR/ IMONITOR,IOUTM       DATA IMONITOR,IOUTM/1,6/       LOGICAL*1 LEVEL  C        LOGICAL*1 ESC/27/,GS/29/       LOGICAL FIRST/.TRUE./  C # C Default colour for CIT467 (cyan):        INTEGER ICITCOL_SAVE/6/ )       COMMON/CIT_COLOUR/ICITCOL1,ICITCOL2 %       INTEGER ICITCOL1/6/,ICITCOL2/6/  C "       LOGICAL*1 TEK4107_INDEX (16)F       DATA TEK4107_INDEX /Z30, Z31, Z32, Z33, Z34, Z35, Z36, Z37, Z38,<      *                    Z39, Z3A, Z3B, Z3C, Z3D, Z3E, Z3F/ C ?       IF(IMONITOR.NE.1.AND.IMONITOR.NE.6.AND.IMONITOR.NE.7.AND. @      #   IMONITOR.NE.8.AND.IMONITOR.NE.9.AND.IMONITOR.NE.10.AND.1      #   IMONITOR.NE.12.AND.IMONITOR.NE.15)RETURN  C 0       IF(ILEVEL .LT. 0 .OR. ILEVEL .GT. 2)RETURN       ILEV=ILEVEL  C  C Finished if QMS:       IF(IMONITOR.EQ.10)RETURN C        CALL FLUSH_PLOT  C  C VT640:       IF(IMONITOR.EQ.1)THEN          LEVEL=ILEVEL4         WRITE(IOUTM,10)'1D'X,'1B'X,'/',LEVEL+'0','d' 10      FORMAT(1X,5A1) C 	 C CIT467:         ELSE IF(IMONITOR.EQ.6)THEN6         IF(ILEVEL.EQ.2)RETURN      !No complement mode8 C Make sure the terminal is "armed" for selective erase:: C Go into 4027 mode and draw a dummy vector to initialize.         IF(FIRST)THEN @           WRITE(IOUTM,1000)ESC,'1',ESC,'O','!VEC 0,0,0,0','!BYE'% 1000      FORMAT('+',4A1/'+',A/'+',A)            FIRST=.FALSE. 
         ENDIF  C Selective erase:         IF(ILEVEL.EQ.1)THEN =           ICITCOL_SAVE=ICITCOL1      !Remember colour setting  C Set writing colour to black:2           WRITE(IOUTM,2000)ESC,'1',ESC,'h',ESC,'2' 2000      FORMAT('+',6A1) 
         ENDIF ' C Restore normal writing mode (colour). B C Do not call PLOT_COLOUR since it messes with the second monitor.         IF(ILEVEL.EQ.0)THEN ?           WRITE(IOUTM,2000)ESC,'1',ESC,'h'+ICITCOL_SAVE,ESC,'2'            ICITCOL1=ICITCOL_SAVE 
         ENDIF  C 	 C TK4107:         ELSE IF(IMONITOR.EQ.7)THEN6         IF(ILEVEL.EQ.2)RETURN      !No complement mode C Selective erase:         IF(ILEVEL.EQ.1)THEN 9           ICITCOL_SAVE=ICITCOL1      !Save colour setting  C Change colour to black: >           WRITE(IOUTM,60100)'1B'X,'4D'X,'4C'X,TEK4107_INDEX(1) 60100     FORMAT (1X, 4A1)
         ENDIF ' C Restore normal writing mode (colour). B C Do not call PLOT_COLOUR since it messes with the second monitor.         IF(ILEVEL.EQ.0)THEN            WRITE(IOUTM,60100):      #     '1B'X,'4D'X,'4C'X,TEK4107_INDEX(ICITCOL_SAVE+1)           ICITCOL1=ICITCOL_SAVE 
         ENDIF  C  C VT241:        ELSE IF(IMONITOR.EQ.8)THEN         CALL REGIS_MODE .         IF(ILEVEL.EQ.0)WRITE(IOUTM,3000)'W(V)'.         IF(ILEVEL.EQ.1)WRITE(IOUTM,3000)'W(E)'.         IF(ILEVEL.EQ.2)WRITE(IOUTM,3000)'W(C)' 3000    FORMAT(1X,A) C 	 C PT100G:         ELSE IF(IMONITOR.EQ.9)THEN9         IF(ILEVEL.EQ.0)WRITE(IOUTM,4000)GS,ESC,'OW `` @@' 9         IF(ILEVEL.EQ.1)WRITE(IOUTM,4000)GS,ESC,'OW b` @@' 9         IF(ILEVEL.EQ.2)WRITE(IOUTM,4000)GS,ESC,'OW a` @@'  4000    FORMAT(1X,A1,A1,A) C  C SEIKO GR1105: !       ELSE IF(IMONITOR.EQ.12)THEN :         IF(ILEVEL.EQ.0)WRITE(IOUTM,5000)ESC,'K ',ESC,'oD ':         IF(ILEVEL.EQ.1)WRITE(IOUTM,5000)ESC,'K ',ESC,'oD!' 5000    FORMAT(1X,A1,A2,A1,A3) C  C VaxStation!       ELSE IF(IMONITOR.EQ.15)THEN "         CALL VST_PLOT_MODE(ILEVEL) C  C LN03+:!       ELSE IF(IMONITOR.EQ.16)THEN 9         IF(ILEVEL.EQ.0)WRITE(IOUTM,4000)GS,ESC,'OW `` @@' 9         IF(ILEVEL.EQ.1)WRITE(IOUTM,4000)GS,ESC,'OW b` @@' 9         IF(ILEVEL.EQ.2)WRITE(IOUTM,4000)GS,ESC,'OW a` @@'        ENDIF          RETURN	       END     )       SUBROUTINE PLOT_DATA_LEVEL2(ILEVEL) H C======================================================================CH C                                                                      CI C   PLOT_DATA_LEVEL2: sets the drawing mode on raster or                C H C                      bit-mapped devices                              CH C                                                                      CH C   Written by Arthur Haynes, TRIUMF U.B.C., JULY 6, 1981.             CH C                                                                      CH C   Input  Parameters: ILEVEL (I*4).                                   CH C                                                                      CH C   Parameter Definitions:                                             CH C   --------- -----------                                              CH C                                                                      CH C   ILEVEL:                                                            CH C           = 0: dots turned on (default)                              CH C           = 1: dots turned off                                       CH C           = 2: dots complemented or toggled.                         CH C                                                                      CH C  Modified May 8/84 by F. Jones to support selective erase            CH C  (ILEVEL=1) on the CIT-467 colour terminal.  This involves           CH C  setting the graphics writing colour to black.                       CH C                                                                      CH C  Modified August/84 by F.W. Jones to support the VT241.              CH C  Modified Oct 4/85 by F.W. Jones to support the Plessey PT100.       CH C  Modified Dec 5/85 by F.W. Jones to support the QMS Lasergrafix      CH C  Modified Mar 20/87 by F.W. Jones for the Seiko GR-1105 terminal     CH C                                                                      CH C======================================================================C        COMMON /PLOT_LEVEL2/ ILEV2       DATA ILEV2/0/ -       COMMON /PLOT_MONITOR2/ IMONITOR2,IOUTM2         DATA IMONITOR2,IOUTM2/0,6/       LOGICAL*1 LEVEL  C        LOGICAL*1 ESC/27/,GS/29/       LOGICAL FIRST/.TRUE./  C # C Default colour for CIT467 (cyan):        INTEGER ICITCOL_SAVE/6/ )       COMMON/CIT_COLOUR/ICITCOL1,ICITCOL2 %       INTEGER ICITCOL1/6/,ICITCOL2/6/  C "       LOGICAL*1 TEK4107_INDEX (16)F       DATA TEK4107_INDEX /Z30, Z31, Z32, Z33, Z34, Z35, Z36, Z37, Z38,<      *                    Z39, Z3A, Z3B, Z3C, Z3D, Z3E, Z3F/ C B       IF(IMONITOR2.NE.1.AND.IMONITOR2.NE.6.AND.IMONITOR2.NE.8.AND.C      #   IMONITOR2.NE.7.AND.IMONITOR2.NE.9.AND.IMONITOR2.NE.10.AND.       #   IMONITOR2.NE.12)RETURN  C 0       IF(ILEVEL .LT. 0 .OR. ILEVEL .GT. 2)RETURN       ILEV2=ILEVEL C  C Finished if QMS:       IF(IMONITOR2.EQ.10)RETURN  C        CALL FLUSH_PLOT  C  C VT640:       IF(IMONITOR2.EQ.1)THEN         LEVEL=ILEVEL5         WRITE(IOUTM2,10)'1D'X,'1B'X,'/',LEVEL+'0','d'  10      FORMAT(1X,5A1) C 	 C CIT467: !       ELSE IF(IMONITOR2.EQ.6)THEN 6         IF(ILEVEL.EQ.2)RETURN      !No complement mode8 C Make sure the terminal is "armed" for selective erase:: C Go into 4027 mode and draw a dummy vector to initialize.         IF(FIRST)THEN A           WRITE(IOUTM2,1000)ESC,'1',ESC,'O','!VEC 0,0,0,0','!BYE' % 1000      FORMAT('+',4A1/'+',A/'+',A)            FIRST=.FALSE. 
         ENDIF  C Selective erase:         IF(ILEVEL.EQ.1)THEN =           ICITCOL_SAVE=ICITCOL2      !Remember colour setting  C Change colour to black: 3           WRITE(IOUTM2,2000)ESC,'1',ESC,'h',ESC,'2'  2000      FORMAT('+',6A1) 
         ENDIF ' C Restore normal writing mode (colour). A C Do not call PLOT_COLOUR since it messes with the first monitor.          IF(ILEVEL.EQ.0)THEN @           WRITE(IOUTM2,2000)ESC,'1',ESC,'h'+ICITCOL_SAVE,ESC,'2'           ICITCOL2=ICITCOL_SAVE 
         ENDIF  C 	 C TK4107: !       ELSE IF(IMONITOR2.EQ.7)THEN 6         IF(ILEVEL.EQ.2)RETURN      !No complement mode C Selective erase:         IF(ILEVEL.EQ.1)THEN =           ICITCOL_SAVE=ICITCOL2      !Remember colour setting  C Change colour to black: >           WRITE(IOUTM,60100)'1B'X,'4D'X,'4C'X,TEK4107_INDEX(1) 60100     FORMAT (1X, 4A1)
         ENDIF ' C Restore normal writing mode (colour). B C Do not call PLOT_COLOUR since it messes with the second monitor.         IF(ILEVEL.EQ.0)THEN            WRITE(IOUTM,60100):      #     '1B'X,'4D'X,'4C'X,TEK4107_INDEX(ICITCOL_SAVE+1)           ICITCOL2=ICITCOL_SAVE 
         ENDIF  C  C VT241:!       ELSE IF(IMONITOR2.EQ.8)THEN          CALL REGIS_MODE2/         IF(ILEVEL.EQ.0)WRITE(IOUTM2,3000)'W(V)' /         IF(ILEVEL.EQ.1)WRITE(IOUTM2,3000)'W(E)' /         IF(ILEVEL.EQ.2)WRITE(IOUTM2,3000)'W(C)'  3000    FORMAT(1X,A) C 	 C PT100G: !       ELSE IF(IMONITOR2.EQ.9)THEN :         IF(ILEVEL.EQ.0)WRITE(IOUTM2,4000)GS,ESC,'OW `` @@':         IF(ILEVEL.EQ.1)WRITE(IOUTM2,4000)GS,ESC,'OW b` @@':         IF(ILEVEL.EQ.2)WRITE(IOUTM2,4000)GS,ESC,'OW a` @@' 4000    FORMAT(1X,A1,A1,A) C  C SEIKO GR1105: "       ELSE IF(IMONITOR2.EQ.12)THEN;         IF(ILEVEL.EQ.0)WRITE(IOUTM2,5000)ESC,'K ',ESC,'oD ' ;         IF(ILEVEL.EQ.1)WRITE(IOUTM2,5000)ESC,'K ',ESC,'oD!'  5000    FORMAT(1X,A1,A2,A1,A3) C  C LN03+:"       ELSE IF(IMONITOR2.EQ.16)THEN:         IF(ILEVEL.EQ.0)WRITE(IOUTM2,4000)GS,ESC,'OW `` @@':         IF(ILEVEL.EQ.1)WRITE(IOUTM2,4000)GS,ESC,'OW b` @@':         IF(ILEVEL.EQ.2)WRITE(IOUTM2,4000)GS,ESC,'OW a` @@'       ENDIF  C        RETURN	       END 