+       SUBROUTINE PLOT_DEVICE(IDEVICE,IOUTM)  C . C  reqd. KOSTL: routines - HCOPYRANG,MONITRANG C B C=================================================================B C=================================================================B C==                                                             ==B C==   PLOT_DEVICE: Sets the plot device to "IDEVICE" and the    ==B C==                screen output unit to "IOUTM".               ==B C==                                                             ==B C==   Written by Arthur Haynes, TRIUMF U.B.C., July 8, 1981.    ==B C==                                                             ==B C==   Input  Parameters: IDEVICE,IOUTM (I*4).                   ==B C==                                                             ==B C==   Parameter Definitions:                                    ==B C==   --------- -----------                                     ==B C==                                                             ==B C==   IDEVICE: Device type. (Default: 1).                       ==B C==                                                             ==B C==        |IDEVICE| = 1: VT640 or Tektronix 4010/12 terminals. ==B C==                       0 <= IX <= 639; 0 <= IY <= 479.       ==B C==                       On the hardcopy: IX is horizontal.    ==B C==        |IDEVICE| = 2: VT640 or Tektronix 4010/12 terminals. ==B C==                       0 <= IX <= 1023; 0 <= IY <= 779.      ==B C==                       On the hardcopy: IX is vertical.      ==B C==        |IDEVICE| = 3: VT640 or Tektronix 4010/12 terminals. ==B C==                       0 <= IX <= 2047; 0 <= IY<= 785.       ==B C==                       On the hardcopy: IX is vertical.      ==B C==        |IDEVICE| = 4: VS11 emulating a VT640 or Tek 4010.   ==B C==                       0 <= IX <= 639; 0 <= IY <= 479.       ==B C==                       On the hardcopy: IX is vertical.      ==B C==         IDEVICE  = 0: Hardcopy only. IX is vertical.        ==B C==                       0 <= IX <= 2047; 0 <= IY <= 785.      ==B C==                                                             ==B C==        If IDEVICE is positive then a screen plot is produced==B C==        and a hardcopy which is a bit map image of the screen==B C==        in printronix format (6 bits per byte) is also       ==B C==        produced.                                            ==B C==        If IDEVICE is negative then only the hardcopy plot is==B C==        done.                                                ==B C==        If IDEVICE is zero then only the hardcopy plot is    ==B C==        produced.                                            ==B C==                                                             ==B C==        When PLOT_DEVICE is called, the hardcopy and screen  ==B C==        are not immediately cleared for that device, but are ==B C==        cleared the next time PLOT_I is called. After a call ==B C==        to PLOT_DEVICE the hardcopy is inaccessible until a  ==B C==        call to PLOT_I is performed.                         ==B C==        Since there is only one hardcopy bit_map_array, only ==B C==        one device can be plotted on at a time, if the user  ==B C==        wants the hardcopy.                                  ==B C==                                                             ==B C==   IOUTM: Output unit for the screen plot. (Default: 6).     ==B C==                                                             ==B C=================================================================B C=================================================================       COMMON /PLOT_CLEAR/ CLEAR        LOGICAL CLEAR/.TRUE./        DATA NDEVICE/4/ C       REAL XMINH(0:4)/5*0./,XMAXH(0:4)/2047.,479.,1023.,2047.,479./ @       REAL YMINH(0:4)/5*0./,YMAXH(0:4)/785.,639.,779.,785.,639./E       REAL XMINHP(0:4)/5*0./,XMAXHP(0:4)/2047.,639.,1023.,2047.,639./ B       REAL YMINHP(0:4)/5*0./,YMAXHP(0:4)/785.,479.,779.,785.,479./A       INTEGER IORIENTH(0:4)/1,-1,1,1,-1/,IMONITOR(0:4)/0,1,1,1,3/ ,       REAL XMINM(0:3)/4*0./,YMINM(0:3)/4*0./G       REAL XMAXM(0:3)/0.,639.,1023.,511./,YMAXM(0:3)/0.,479.,779.,479./TB C=================================================================B C==   Check the validity of the plot device number "IDEVICE".   ==B C=================================================================&       IF(IABS(IDEVICE).GT.NDEVICE)THEN          WRITE(6,10)IDEVICEeE 10       FORMAT(' ***Error*** in PLOT_DEVICE: Invalid device type: ',       *          I5)           RETURN        ENDIF        IADEV=IABS(IDEVICE)t       IMON=IMONITOR(IADEV)       IF(IDEVICE.LT.0)IMON=0A       CALL HARDCOPY_RANGE(XMINH(IADEV),XMAXH(IADEV),YMINH(IADEV), >      * YMAXH(IADEV),XMINHP(IADEV),XMAXHP(IADEV),YMINHP(IADEV),%      * YMAXHP(IADEV),IORIENTH(IADEV)) $       CALL MONITOR_RANGE(IMON,IOUTM,3      *                   XMINH(IADEV),XMAXH(IADEV), 3      *                   YMINH(IADEV),YMAXH(IADEV), 1      *                   XMINM(IMON),XMAXM(IMON), 1      *                   YMINM(IMON),YMAXM(IMON),:)      *                   IORIENTH(IADEV)) B C=================================================================B C==   Set the clear flag on so that the next time PLOT_I is     ==B C==   called the screen will be cleared.                        ==B C=================================================================       CLEAR=.TRUE.       RETURN	       ENDT  