3       SUBROUTINE PLOT_DEVICE2(IDEVICE,IOUTM,IOUTM2)  C 8 C  reqd. KOSTL: routines - HCOPYRANG,MONITRANG,MONIT2RNG C B C=================================================================B C=================================================================B C==                                                             ==B C==   PLOT_DEVICE2: Sets the plot device to "IDEVICE" and the   ==B C==        screen output unit to "IOUTM".  When IDEVICE < -4 or ==B C==        IDEVICE > 4, a second monitor is activated and plottingB C==        output is also sent to the ZETA plotter via logical  ==B C==        unit IOUTM2.                                         ==B C==                                                             ==B C==   Written by Arthur Haynes, TRIUMF U.B.C., July 8, 1981.    ==B C==                                                             ==B C==   Input  Parameters: IDEVICE,IOUTM,IOUTM2 (I*4).            ==B C==                                                             ==B C==   Parameter Definitions:                                    ==B C==   --------- -----------                                     ==B C==                                                             ==B C==   IDEVICE: Device type. The default device type if          ==B C==            PLOT_DEVICE2 is not called is device 1.          ==B C==                                                             ==B C==            X, Y coordinates are user (= world) coordinates. ==B C==                                                             ==B C==            X is horizontal, Y is vertical on VT640,         ==B C==              Tektronix 4010/12, or VS11.                    ==B C==                                                             ==B C==        |IDEVICE| = 1: VT640 or Tektronix 4010/12 terminals. ==B C==                       0 <= X <= 639; 0 <= Y <= 479.         ==B C==                       On the hardcopy: X is horizontal.     ==B C==        |IDEVICE| = 2: VT640 or Tektronix 4010/12 terminals. ==B C==                       0 <= X <= 1023; 0 <= Y <= 779.        ==B C==                       On the hardcopy: X is vertical.       ==B C==        |IDEVICE| = 3: VT640 or Tektronix 4010/12 terminals. ==B C==                       0 <= X <= 2047; 0 <= Y <= 785.        ==B C==                       On the hardcopy: X is vertical.       ==B C==        |IDEVICE| = 4: VS11 emulating a VT640 or Tek 4010.   ==B C==                       0 <= X <= 639; 0 <= Y <= 479.         ==B C==                       On the hardcopy: X is horizontal.     ==B C==        |IDEVICE| = 5: VT640 or Tektronix 4010/12 terminals. ==B C==                       0 <= X <= 639; 0 <= Y <= 479.         ==B C==                       On the hardcopy: X is horizontal.     ==B C==                       Plus a ZETA plot ***********          ==B C==                       On the Zeta:     X is horizontal.     ==B C==        |IDEVICE| = 6: VT640 or Tektronix 4010/12 terminals. ==B C==                       0 <= X <= 1023; 0 <= Y <= 779.        ==B C==                       On the hardcopy: X is vertical.       ==B C==                       Plus a ZETA plot ***********          ==B C==                       On the Zeta:     X is horizontal.     ==B C==        |IDEVICE| = 7: VT640 or Tektronix 4010/12 terminals. ==B C==                       0 <= X <= 2047; 0 <= Y <= 785.        ==B C==                       On the hardcopy: X is vertical.       ==B C==                       Plus a ZETA plot ***********          ==B C==                       On the Zeta:     X is vertical.       ==B C==        |IDEVICE| = 8: VS11 emulating a VT640 or Tek 4010.   ==B C==                       0 <= X <= 639; 0 <= Y <= 479.         ==B C==                       On the hardcopy: X is horizontal.     ==B C==                       Plus a ZETA plot ***********          ==B C==                       On the Zeta:     X is horizontal.     ==B C==         IDEVICE  = 0: Hardcopy only. X is vertical.         ==B C==                       0 <= X <= 2047; 0 <= Y <= 785.        ==B C==                                                             ==B C==        If IDEVICE is positive then a screen plot is produced==B C==        and a hardcopy which is a bit map image of the screen==B C==        in printronix format (6 bits per byte) is also       ==B C==        produced.                                            ==B C==                                                             ==B C==        If IDEVICE is zero or negative then only the hardcopy==B C==        bit map is produced.                                 ==B C==                                                             ==B C==        When PLOT_DEVICE2 is called, the hardcopy and screen ==B C==        are not immediately cleared for that device, but are ==B C==        cleared the next time PLOT_R is called. After a call ==B C==        to PLOT_DEVICE2 the hardcopy should not be accessed  ==B C==        until a call to PLOT_R is performed.                 ==B C==                                                             ==B C==   IOUTM:  Output unit for the screen plot.                  ==B C==   IOUTM2: Output unit for second device (ZETA plotter).     ==B C==                                                             ==B C==                                                             ==B C==   Defaults:                                                 ==B C==   --------                                                  ==B C==                                                             ==B C==   If PLOT_DEVICE2 is not called, the device type defaults   ==B C==   to 1, and plotting output is sent to logical unit 6.      ==B C==   No output is sent to a second device.                     ==B C=================================================================B C=================================================================       COMMON /PLOT_CLEAR/ CLEAR H C***********************************************************************H C                                                                      *H C    Common block DEVICE2_TYPE inserted August 2, 1983                 *H C                                   by J. Chuma                        * CX1 C    Modified by Alan Carruthers, October 6, 1983TC C      If PLOT_DEVICE2 was called with |device type| > 4 then later=D C      called with |device type| <= 4, MONITOR2_RANGE was not calledD C      to turn off monitor 2.  This has been corrected so that every: C      time DEVICE_TYPE2 is called with |device type| <= 48 C      MONITOR2_RANGE is called to deactivate monitor 2.H C                                                                      *H C***********************************************************************$       COMMON /DEVICE2_TYPE/ IDEVICE2       LOGICAL CLEAR/.TRUE./n+       PARAMETER (NDEVICE = 8, NDEVICE1 = 9) )       REAL XMINH(0:NDEVICE)/NDEVICE1*0./,*8      #     XMAXH(0:NDEVICE)/2047.,479.,1023.,2047.,479.,2      #                      479.,1023.,2047.,479./)       REAL YMINH(0:NDEVICE)/NDEVICE1*0./, 5      #     YMAXH(0:NDEVICE)/785.,639.,779.,785.,639.,.0      #                      639.,779.,785.,639./*       REAL XMINHP(0:NDEVICE)/NDEVICE1*0./,9      #     XMAXHP(0:NDEVICE)/2047.,639.,1023.,2047.,639., 3      #                       639.,1023.,2047.,639./ *       REAL YMINHP(0:NDEVICE)/NDEVICE1*0./,6      #     YMAXHP(0:NDEVICE)/785.,479.,779.,785.,479.,1      #                       479.,779.,785.,479./ :       INTEGER IORIENTH(0:NDEVICE)/1,-1,1,1,-1,-1, 1, 1,-1/:       INTEGER IORIENTM(0:NDEVICE)/1,-1,1,1,-1, 1,-1, 1, 1/4       INTEGER IMONITOR(0:NDEVICE)/0,1,1,1,3,1,1,1,3/)       REAL XMINM(0:NDEVICE)/NDEVICE1*0./,=(      #     YMINM(0:NDEVICE)/NDEVICE1*0./E C==================================================================== E C==                                                                == E C== IDEVICE IADEV IMON XMAXH YMAXH XMAXHP YMAXHP XMAXM YMAXM OH OM == E C==     0      0    0   2047  785   2047   785      0     0   1  1 == E C== +/- 1      1    1    479  639    639   479    639   479  -1 -1 == E C== +/- 2      2    1   1023  779   1023   779   1023   779   1  1 == E C== +/- 3      3    1   2047  785   2047   785    511   479   1  1 ==sE C== +/- 4      4    3    479  639    639   479      0     0  -1 -1 ==hE C== +/- 5      5    1    479  639    639   479 20.944 27.94  -1  1 == E C== +/- 6      6    1   1023  779   1023   779 21.276 27.94   1 -1 == E C== +/- 7      7    1   2047  785   2047   785 43.18  27.94   1  1 == E C== +/- 8      8    3    479  639    639   479 20.944 27.94  -1  1 ==hE C====================================================================  C  C   ZETA plot dimensions: C C      YMINM = 0 cm                                 (devices 5 - 8)eC C      XMINM = 0 cm                                 (devices 5 - 8)nC C      YMAXM = 11 * 2.54 = 27.94 cm                 (devices 5 - 8)dB C      XMAXM = 11 * 2.54 * 479/639 = 20.944 cm      (devices 5, 8)> C      XMAXM = 11 * 2.54 * 779/1023 = 21.276 cm     (device 6)> C      XMAXM = 8.5 * 2.54 * 2 = 43.18 cm            (device 7)B C              Note that for device 7 differential scaling is used; C              for the X and Y axes. (e.g. Circles in world C C              coordinates appear on the ZETA plotter as ellipses.)  C  C  C 2       REAL XMAXM(0:NDEVICE)/0.,639.,1023.,511.,0.,8      #                      20.944,21.276,43.18,20.944/,2      #     YMAXM(0:NDEVICE)/0.,479., 779.,479.,0.,4      #                      27.94,27.94,27.94,27.94/B C=================================================================B C==   Check the validity of the plot device number "IDEVICE".   ==B C=================================================================&       IF(IABS(IDEVICE).GT.NDEVICE)THEN          WRITE(6,10)IDEVICEc0 10       FORMAT(' ***Error*** in PLOT_DEVICE2:',,      *          ' Invalid device type: ',I5)          RETURN=       ENDIF=       IDEVICE2 = IDEVICE       IADEV=IABS(IDEVICE)M= C------------------------------------------------------------*/ C     Inserted by Alan Carruthers, Oct 6, 1983:        IF(IADEV .LE. 4) THEN           IMON2 = 0
       ELSE          IMON2 = 4       END IF= C------------------------------------------------------------        IMON=IMONITOR(IADEV)       IF(IDEVICE.LT.0)IMON=0A       CALL HARDCOPY_RANGE(XMINH(IADEV),XMAXH(IADEV),YMINH(IADEV),w>      * YMAXH(IADEV),XMINHP(IADEV),XMAXHP(IADEV),YMINHP(IADEV),%      * YMAXHP(IADEV),IORIENTH(IADEV))  C ) C  INITIALIZE THE ZETA PLOTTER IF IADEV>4  C -       IF(IADEV.GT.4)CALL Z_PLOTS(53,0,IOUTM2)E CP1 C     IF(IADEV.GT.4)CALL MONITOR2_RANGE(4,IOUTM2,RE       CALL MONITOR2_RANGE(IMON2,IOUTM2,  !inserted by Alan Carruthers 3      *                   XMINH(IADEV),XMAXH(IADEV),*3      *                   YMINH(IADEV),YMAXH(IADEV),*3      *                   XMINM(IADEV),XMAXM(IADEV), 3      *                   YMINM(IADEV),YMAXM(IADEV),8)      *                   IORIENTM(IADEV))E$       CALL MONITOR_RANGE(IMON,IOUTM,3      *                   XMINH(IADEV),XMAXH(IADEV), 3      *                   YMINH(IADEV),YMAXH(IADEV),01      *                   XMINM(IMON),XMAXM(IMON),E1      *                   YMINM(IMON),YMAXM(IMON), )      *                   IORIENTH(IADEV))HB C=================================================================B C==   Set the clear flag on so that the next time PLOT_R is     ==B C==   called the screen will be cleared.                        ==B C=================================================================       CLEAR=.TRUE.       RETURN	       END0