?       SUBROUTINE PLOT_HARDCOPY(IX1,IY1,IX2,IY2,ARRAY,ND1,N1,N2) H C======================================================================CH C                                                                      CH C  PLOT_HARDCOPY                                                       CH C                                                                      CH C  Draws a line from the dot location (IX1,IY1) to the dot location    CH C  (IX2,IY2), by lighting up the bits in the bit map array "ARRAY".    CH C                                                                      CH C  The algorithm used originated from the book: "Principles of         CH C  Interactive Computer Graphics", by Newmann & Sproull, pages 25-26.  CH C                                                                      CH C  "ARRAY" contains N2 lines of N1 bytes which form a bit map image    CH C  in printronix format with 6 bits per byte. For the printronix N1    CH C  is a maximum of 131 which implies a total of 786 dots per line      CH C  (IY = 0 to 785).  The x-axis runs vertically down the printronix    CH C  page with IX ranging from 0 to N2-1.  The y-axis runs horizontally  CH C  across the page with IY ranging from 0 to N1*6-1.  The origin of    CH C  this coordinate system is at the top left hand corner of the page,  CH C  i.e. the 1'st bit (low order bit) of "ARRAY(1,1)".                  CH C  0 <= IX <= N2-1; 0 <= IY <= N1*6-1.                                 CH C  The dot location (IX,IY) is represented in the array by the         CH C  "IMOD(IY,6)+1"'th bit of the array location "ARRAY(IY/6+1,IX+1)".   CH C  Eg. (0,0) is the 1'st bit of "ARRAY(1,1)", & (N2-1,N1*6-1) is the   CH C  6'th bit of "ARRAY(N1,N2)".                                         CH C                                                                      CH C   Written by Arthur Haynes, TRIUMF U.B.C., July 8, 1981.             CH C                                                                      CH C   Input  Parameters: IX1,IY1,IX2,IY2,ND1,N1,N2 (I*4).                CH C                      ARRAY(ND1,N2) (Logical*1).                      CH C                                                                      CH C   Parameter Definitions:                                             CH C   --------- -----------                                              CH C                                                                      CH C   IX1   : X-coordinate of the start of the line.                     CH C   IY1   : Y-coordinate of the start of the line.                     CH C                                                                      CH C   IX2   : X-coordinate of the end of the line.                       CH C   IY2   : Y-coordinate of the end of the line.                       CH C                                                                      CH C   Note: (IX1,IY1) and/or (IX2,IY2) can be outside the bit map array. CH C         The subroutine PLOT_HARDCOPY simply clips the line at the    CH C         edges of the array.                                          CH C                                                                      CH C   ARRAY : Bit map array in which the line is plotted by              CH C           lighting up the bits. "ARRAY" is a logical*1               CH C           array dimensioned: (ND1,N2).                               CH C                                                                      CH C   ND1   : First dimension of the array "ARRAY". Must be              CH C           greater than or equal to N1.                               CH C                                                                      CH C   N1    : Number of bytes per line of the bit map array.             CH C                                                                      CH C   N2    : Second dimension of the array "ARRAY".                     CH C           Number of dot lines of the bit map array.                  CH C                                                                      CH C  Modified Jan 29/84 by F.W. Jones:                                   CH C  Flag BITMAP_EMPTY added to communicate with CLEAR_PLOT.             CH C                                                                      CH C  Modified Jan 19/88 by F.W. Jones:  the internal bitmap storage      CH C  has been changed from Printronix format (6 significant bits per     CH C  byte) to HP Laserjet format (8 significant bits per byte).          CH C                                                                      CH C======================================================================C       LOGICAL*1 ARRAY(ND1,N2)          COMMON/TO_BIT_OR_NOT/WELL        LOGICAL WELL/.TRUE./       COMMON /PLOT_LEVEL/ ILEVC       COMMON/GRAPHICS_BITMAP/HPAINT,NBYTES,IOFFSET,NXDIM,NYDIM,MAXY        LOGICAL*1 HPAINT(1) 0       COMMON /PLOT_COLOURS/ ICOLOUR_1, ICOLOUR_20       COMMON/BITMAP_STATUS/BITMAP_EMPTY,MAXLINES"       LOGICAL BITMAP_EMPTY/.TRUE./       INTEGER MAXLINES/480/   "       LOGICAL DY_GT_DX,PL1,PL2,PL3J       INTEGER ICIT467(8)/0,1,4,5,2,3,6,7/  ! REMAPS CITCOLOURS TO PAINTJET  4       INTEGER*2 LOC8(8)/128, 64, 32, 16, 8, 4, 2, 1/4       INTEGER*2 MOC8(8)/127,-65,-33,-17,-9,-5,-3,-2/         INTEGER*2 ILARR1       LOGICAL*1 LARR1        EQUIVALENCE(LARR1,ILARR1)  C        IF(.NOT. WELL) RETURN        BITMAP_EMPTY=.FALSE.A       IF(NBYTES.NE.0) GO TO 200       ! TEST IF HPPAINTJET BITMAP  C              IDELTAX=IX2-IX1        IDELTAY=IY2-IY1        IX=IX1       IY=IY1
       I2=IX+1 %       IF(I2.LT.1.OR.I2.GT.N2)GO TO 50        I1=IY/8+1 %       IF(I1.LT.1.OR.I1.GT.N1)GO TO 50        IBIT=IY+1-(I1-1)*8       LARR1=ARRAY(I1,I2)       IF(ILEV.EQ.0)THEN &          ILARR1=IOR(ILARR1,LOC8(IBIT))       ELSE IF(ILEV.EQ.1)THEN'          ILARR1=IAND(ILARR1,MOC8(IBIT)) 
       ELSE'          ILARR1=IEOR(ILARR1,LOC8(IBIT))        ENDIF        ARRAY(I1,I2)=LARR1- 50    DY_GT_DX=IABS(IDELTAY).GT.IABS(IDELTAX)        IF(DY_GT_DX)THEN          ITEMP=IDELTAX          IDELTAX=IDELTAY          IDELTAY=ITEMP          ITEMP=IX           IX=IY          IY=ITEMP        ENDIF        IDX=ISIGN(1,IDELTAX)       IDY=ISIGN(1,IDELTAY)       IADELTAX=IABS(IDELTAX)       IADELTAY=IABS(IDELTAY)        IERROR=2*IADELTAY-IADELTAX       DO 100 I=1,IADELTAX        IF(IERROR.GT.0)THEN           IY=IY+IDY,          IERROR=IERROR+2*IADELTAY-2*IADELTAX
       ELSE!          IERROR=IERROR+2*IADELTAY        ENDIF        IX=IX+IDX        IXX=IX       IYY=IY       IF(DY_GT_DX)THEN          IXX=IY           IYY=IX        ENDIF        I2=IXX+1&       IF(I2.LT.1.OR.I2.GT.N2)GO TO 100       I1=IYY/8+1&       IF(I1.LT.1.OR.I1.GT.N1)GO TO 100       IBIT=IYY+1-(I1-1)*8        LARR1=ARRAY(I1,I2)       IF(ILEV.EQ.0)THEN &          ILARR1=IOR(ILARR1,LOC8(IBIT))       ELSE IF(ILEV.EQ.1)THEN'          ILARR1=IAND(ILARR1,MOC8(IBIT)) 
       ELSE'          ILARR1=IEOR(ILARR1,LOC8(IBIT))        ENDIF        ARRAY(I1,I2)=LARR1 100   CONTINUE       RETURN  H C======================================================================C C  HP Paintjet section followsH C======================================================================C 200   ICOL=ICIT467(ICOLOUR_1+1)  C H C   For now, MAXY set to NYDIM since package does not keep track of maxY C        MAXY = NYDIM%       N4 = NYDIM/3   ! Usually 5400/3 $       N3 = NXDIM*8   ! Usually 180*8         PL1=0        PL2=0        PL3=0 G       IF(ICOL.EQ.1 .OR. ICOL.EQ.3 .OR. ICOL.EQ.5 .OR. ICOL.EQ.7) PL1=-1 G       IF(ICOL.EQ.2 .OR. ICOL.EQ.3 .OR. ICOL.EQ.6 .OR. ICOL.EQ.7) PL2=-1 G       IF(ICOL.EQ.4 .OR. ICOL.EQ.5 .OR. ICOL.EQ.6 .OR. ICOL.EQ.7) PL3=-1        IDELTAX=IX2-IX1        IDELTAY=IY2-IY1        IX=IX1       IY=IY1
       I2=IX+1 &       IF(I2.LT.1.OR.I2.GT.N4)GO TO 150       I1=IY/8+1 &       IF(I1.LT.1.OR.I1.GT.N3)GO TO 150       IBIT=IY+1-(I1-1)*8         CALL TRANSPARENT_MODE(0)*       WRITE(6,*)'NBYTES,NXDIM,NYDIM,N3,N4'(       WRITE(6,*)NBYTES,NXDIM,NYDIM,N3,N4         IF(PL1)THEN * cc         III=IOFFSET+I1+((I2-1)*3+0)*180*          III=IOFFSET+I1+((I2-1)*3+0)*NXDIM          LARR1=HPAINT(III)&          ILARR1=IOR(ILARR1,LOC8(IBIT))          HPAINT(III)=LARR1
       ELSE* cc         III=IOFFSET+I1+((I2-1)*3+0)*180*          III=IOFFSET+I1+((I2-1)*3+0)*NXDIM4 cc         LARR1=HPAINT(IOFFSET+I1+((I2-1)*3+0)*180)4          LARR1=HPAINT(IOFFSET+I1+((I2-1)*3+0)*NXDIM)'          ILARR1=IAND(ILARR1,MOC8(IBIT)) 4 cc         HPAINT(IOFFSET+I1+((I2-1)*3+0)*180)=LARR14          HPAINT(IOFFSET+I1+((I2-1)*3+0)*NXDIM)=LARR1       ENDIF        IF(PL2)THEN * cc         III=IOFFSET+I1+((I2-1)*3+1)*180*          III=IOFFSET+I1+((I2-1)*3+1)*NXDIM          LARR1=HPAINT(III)&          ILARR1=IOR(ILARR1,LOC8(IBIT))          HPAINT(III)=LARR1
       ELSE* cc         III=IOFFSET+I1+((I2-1)*3+1)*180*          III=IOFFSET+I1+((I2-1)*3+1)*NXDIM          LARR1=HPAINT(III)'          ILARR1=IAND(ILARR1,MOC8(IBIT))           HPAINT(III)=LARR1       ENDIF        IF(PL3)THEN * cc         III=IOFFSET+I1+((I2-1)*3+2)*180*          III=IOFFSET+I1+((I2-1)*3+2)*NXDIM          LARR1=HPAINT(III)&          ILARR1=IOR(ILARR1,LOC8(IBIT))          HPAINT(III)=LARR1
       ELSE* cc         III=IOFFSET+I1+((I2-1)*3+2)*180*          III=IOFFSET+I1+((I2-1)*3+2)*NXDIM          LARR1=HPAINT(III)'          ILARR1=IAND(ILARR1,MOC8(IBIT))           HPAINT(III)=LARR1       ENDIF - 150   DY_GT_DX=IABS(IDELTAY).GT.IABS(IDELTAX)        IF(DY_GT_DX)THEN          ITEMP=IDELTAX          IDELTAX=IDELTAY          IDELTAY=ITEMP          ITEMP=IX           IX=IY          IY=ITEMP        ENDIF        IDX=ISIGN(1,IDELTAX)       IDY=ISIGN(1,IDELTAY)       IADELTAX=IABS(IDELTAX)       IADELTAY=IABS(IDELTAY)        IERROR=2*IADELTAY-IADELTAX       DO 300 I=1,IADELTAX        IF(IERROR.GT.0)THEN           IY=IY+IDY,          IERROR=IERROR+2*IADELTAY-2*IADELTAX
       ELSE!          IERROR=IERROR+2*IADELTAY        ENDIF        IX=IX+IDX        IXX=IX       IYY=IY       IF(DY_GT_DX)THEN          IXX=IYt          IYY=IXI       ENDIFe       I2=IXX+1&       IF(I2.LT.1.OR.I2.GT.N4)GO TO 300       I1=IYY/8+1&       IF(I1.LT.1.OR.I1.GT.N3)GO TO 300       IBIT=IYY+1-(I1-1)*8        IF(PL1)THEN * cc         III=IOFFSET+I1+((I2-1)*3+0)*180*          III=IOFFSET+I1+((I2-1)*3+0)*NXDIM          LARR1=HPAINT(III)&          ILARR1=IOR(ILARR1,LOC8(IBIT))          HPAINT(III)=LARR1
       ELSE* cc         III=IOFFSET+I1+((I2-1)*3+0)*180*          III=IOFFSET+I1+((I2-1)*3+0)*NXDIM4 cc         LARR1=HPAINT(IOFFSET+I1+((I2-1)*3+0)*180)4          LARR1=HPAINT(IOFFSET+I1+((I2-1)*3+0)*NXDIM)'          ILARR1=IAND(ILARR1,MOC8(IBIT))p4 cc         HPAINT(IOFFSET+I1+((I2-1)*3+0)*180)=LARR14          HPAINT(IOFFSET+I1+((I2-1)*3+0)*NXDIM)=LARR1       ENDIFt       IF(PL2)THEN * cc         III=IOFFSET+I1+((I2-1)*3+1)*180*          III=IOFFSET+I1+((I2-1)*3+1)*NXDIM          LARR1=HPAINT(III)&          ILARR1=IOR(ILARR1,LOC8(IBIT))          HPAINT(III)=LARR1
       ELSE* cc         III=IOFFSET+I1+((I2-1)*3+1)*180*          III=IOFFSET+I1+((I2-1)*3+1)*NXDIM          LARR1=HPAINT(III)'          ILARR1=IAND(ILARR1,MOC8(IBIT))e          HPAINT(III)=LARR1       ENDIF        IF(PL3)THEN * cc         III=IOFFSET+I1+((I2-1)*3+2)*180*          III=IOFFSET+I1+((I2-1)*3+2)*NXDIM          LARR1=HPAINT(III)&          ILARR1=IOR(ILARR1,LOC8(IBIT))          HPAINT(III)=LARR1
       ELSE* cc         III=IOFFSET+I1+((I2-1)*3+2)*180*          III=IOFFSET+I1+((I2-1)*3+2)*NXDIM          LARR1=HPAINT(III)'          ILARR1=IAND(ILARR1,MOC8(IBIT))           HPAINT(III)=LARR1       ENDIF  300   CONTINUE       RETURN	       END 