'       SUBROUTINE PLOT_MONITOR(X,Y,IPEN) H C======================================================================CH C                                                                      CH C  PLOT_MONITOR                                                        CH C                                                                      CH C  Generates graphics output for monitor 1:                            CH C    IPEN=2:   move to location (X,Y)                                  CH C    IPEN=3:   draw to location (X,Y)                                  CH C    IPEN=20:  plot a point at location (X,Y)                          CH C                                                                      CH C  If IMONITOR = 0 then PLOT_MONITOR simply returns.                   CH C                                                                      CH C   Written by Arthur Haynes, TRIUMF U.B.C., July 6, 1981.             CH C                                                                      CH C   Input  Parameters: X,Y (R*4); IPEN (I*4).                          CH C                                                                      CH C   Modified by Alan Carruthers, TRIUMF, March 3, 1983                 CH C   No graphics primitives are sent to monitor types 1, 2 or 3 if:     CH C        a) The same pixel as on the previous call to                  CH C           PLOT_MONITOR is referenced; and                            CH C        b) The plot level (pixels turned on, turned off, or           CH C           complemented) has not changed; and                         CH C        c) The plot has not just been cleared; and                    CH C        d) IPEN is the same as on the previous call; and              CH C        e) MUST_DO_PLOT is .FALSE. (May 4, 1983 -- see                CH C           following modification).                                   CH C                                                                      CH C  Modified by Alan Carruthers, TRIUMF, May 4, 1983:                   CH C  Graphics primitives can be forced to be sent if logical variable    CH C  MUST_DO_PLOT in common block /PLOT_MONITOR_DOPLOT/ is set to .TRUE. CH C  MUST_DO_PLOT defaults to .FALSE.  This modification was made to let CH C  PLOT_ALPHA_R force PLOT_MONITOR to send output. (PLOT_ALPHA_R moves CH C  the graphics cursor.)                                               CH C                                                                      CH C  Modified by F.W. Jones, Oct 24/83.                                  CH C  To speed up display on Tektronix-compatible terminals, only the     CH C  necessary bytes of coordinate information are sent to these         CH C  devices.  The bytes normally sent are HI Y, LO Y, HI X, LO X, in    CH C  that order.  The terminal identifies the LO Y and LO X bytes by     CH C  their range.  The HI Y and HI X bytes have the same range, but the  CH C  HI X byte is identified by a preceding LO Y.  The LO X byte         CH C  initiates the drawing of the vector.  In general, after the         CH C  transmission of the first four bytes, only those bytes that change  CH C  need be sent, with the exceptions that:                             CH C                                                                      CH C   1) If the HI X byte is sent, a preceding LO Y byte must            CH C      be sent.                                                        CH C   2) The LO X byte must always be sent, to draw the vector.          CH C                                                                      CH C  In a typical plot, there are often one or more bytes that do not    CH C  change one vector to the next, so more vectors can be packed into   CH C  the buffer, the number of I/O operations decreases, and the display CH C  speed is increased.  For a typical plotting example (PLOTEX3),      CH C  display time is reduced by about 30% and CPU time usage is reduced  CH C  by about 15%.                                                       CH C                                                                      CH C  Associated routines modified: CHECK_BUFFER, PLOT_MONITOR2,          CH C                                CHECK_BUFFER2.                        CH C                                                                      CH C  Modified by Joe Chuma, December 5, 1983 to include the HP           CH C    plotter as a monitor                                              CH C  Modified by Bernard Henin, U.VIC, July 1984, to support the         CH C    TEKTRONIX-4107.                                                   CH C  Modified by F.W. Jones, August 84, to include the VT241.            CH C                                                                      CH C  Modified by F.W. Jones, Oct 4/85:                                   CH C                                                                      CH C    PLESSEY PT100G terminal support added (IMONITOR=9).               CH C    This terminal stores Tek 4014 coordinates at full precision       CH C    for true zoom and replay.  Address range is 4096 instead of       CH C    1024 ... this means there are an extra 2 bits of precision        CH C    in X and Y.  These bits are sent in an extra byte (IEXTRA)        CH C    following the HI Y byte.  The IEXTRA byte need be sent only if    CH C    its value has changed.  If the IEXTRA byte is sent, it must       CH C    be followed by the LO Y byte.  Routine CHECK_BUFFER has also      CH C    been modified to handle the extra byte.                           CH C                                                                      CH C    The code has been substantially rearranged and comments have      CH C    been revised to improve the logical structure and make the        CH C    code easier to read and maintain.  The Tektronix-compatible       CH C    section (IMONITOR=1,2,6,7,9) is now at the beginning of the       CH C    executable code, and sections for the other monitors follow       CH C    in numerical order.                                               CH C                                                                      CH C  Modified Dec 5/85 by F.W. Jones, for the QMS Lasergrafix.           CH C  Modified Aug 11/86 by F.W. Jones for the Houston Instruments        CH C    plotter.                                                          CH C  Modified Jan 30/87 by J.Chuma for the TEK-4107, to get the correct  CH C    scaling numbers. (used [KOST.LIBRARY.EXAMPLES]TK4107.FOR)         CH C  Modified Mar 20/87 by F. Jones for the Seiko GR-1105 terminal       CH C  Modified Jul 6/87 by F. Jones:  when going from point plot mode     CH C    to vector mode (pen up) a US is now sent, followed by the GS      CH C    to go into vector mode.  The GS resets point mode on the VT640    CH C    but not on the other Tektronix emulators.  When using point       CH C    mode, the FS code (enter point mode), which was formerly sent     CH C    for every point, is now sent only if the terminal is not in       CH C    point mode or if a new buffer has just been started.              CH C  Modified Aug 12/87 by F. Jones: Tektronix 4014 precision for        CH C    VT640 emulators with vector zoom has been added.                  CH C                                                                      CH C======================================================================C*       COMMON /PLOT_MONITOR/ IMONITOR,IOUTM       DATA IMONITOR,IOUTM/1,6/1       COMMON /PLOT_BUFFER/ INDEX,IMODE,BUFFER(78)        LOGICAL*1 BUFFER       DATA INDEX,IMODE/0,1/ C       COMMON /MONITOR_SIZE/ XMINMSIZE,XMAXMSIZE,YMINMSIZE,YMAXMSIZE C       DATA XMINMSIZE,XMAXMSIZE,YMINMSIZE,YMAXMSIZE/0.,639.,0.,479./ 8       COMMON /PLOT_TO_MONITOR/ RMATRIXMP(2,2),SHIFTMP(2)0       DATA RMATRIXMP/1.,0.,0.,1./,SHIFTMP/0.,0./       COMMON /PLOT_LEVEL/ ILEV       DATA ILEV/0/2       COMMON /PLOT_CLEARED/PL_CLEAR_M, PL_CLEAR_M2%       LOGICAL PL_CLEAR_M, PL_CLEAR_M2 G C====================================================================== C C  MUST_DO_PLOT is a logical variable that can be set to .true. to  F C  force PLOT_MONITOR (and PLOT_MONITOR2) to send graphics primitives B C  to Monitor 1 (and Monitor 2).  This is useful if, for example, A C  alphanumeric text is sent to the monitor between two identical B C  calls to PLOT_MONITOR (or PLOT_MONITOR2). In this example, the F C  alphanumeric text would change the location of the graphics cursor E C  but PLOT_MONITOR wouldn't realize this.                            G C====================================================================== /       COMMON /PLOT_MONITOR_DOPLOT/ MUST_DO_PLOT #       LOGICAL MUST_DO_PLOT/.FALSE./  C Previous TEK codes: 9       COMMON/TEK_PREVIOUS/IYHIP,IYLOP,IXHIP,IXLOP,IEXTRAP 5       DATA IYHIP,IYLOP,IXHIP,IXLOP,IEXTRAP/0,0,0,0,0/  C TEK precision set externally: #       COMMON/TEK_PRECISION/TEK4014P        LOGICAL TEK4014P/.FALSE./   + C Flag for point plot mode, TEK4014 output: )       LOGICAL POINT_MODE/.FALSE./,TEK4014   :       INTEGER IXPIXEL, IYPIXEL      !pixel last referenced       LOGICAL FIRST/.TRUE./ ?       INTEGER IPENPREV/0/  !saves IPEN value from previous call        LOGICAL DONT_PLOT 2       SAVE IXPIXEL,IYPIXEL,FIRST,ILEVPREV,IPENPREV C H C======================================================================C C  Procedure begins.H C======================================================================C       IF(IMONITOR.EQ.0)RETURN 8       DONT_PLOT = .NOT. (FIRST .OR. (ILEVPREV .NE. ILEV)-      >                   .OR. PL_CLEAR_M .OR. 2      >                   (IPENPREV .NE. IPEN) .OR.&      >                   MUST_DO_PLOT)       FIRST = .FALSE.        PL_CLEAR_M = .FALSE.       ILEVPREV = ILEV        IPENPREV = IPEN   ;       TEK4014=(TEK4014P.OR.IMONITOR.EQ.9.OR.IMONITOR.EQ.16)  C B C=================================================================? C    Determine the monitor coordinates (XM,YM) which correspond + C    to the plot coordinates (X,Y):         + C                                           * C        |XM|               |X|           * C        |  | = RMATRIXMP * | | + SHIFTMP * C        |YM|               |Y|           D C=================================================================  5       XM=RMATRIXMP(1,1)*X+RMATRIXMP(1,2)*Y+SHIFTMP(1) 5       YM=RMATRIXMP(2,1)*X+RMATRIXMP(2,2)*Y+SHIFTMP(2) )       XM=MAX(MIN(XM,XMAXMSIZE),XMINMSIZE) )       YM=MAX(MIN(YM,YMAXMSIZE),YMINMSIZE)  C H C======================================================================C+ C  Identify Tektronix-compatible devices... C C  IMONITOR=1: VT640     IMONITOR=2: Tek4010     IMONITOR=6: CIT467 C C  IMONITOR=7: Tek4107   IMONITOR=9: PT100G      IMONITOR=16: LN03+ ( C  and convert to Tektronix coordinates.H C======================================================================C C VT640:       IF(IMONITOR.EQ.1)THEN          IF(TEK4014)THEN C           IXM=XM*4096./640. + SIGN(.5,XM) !Scale from VT640 to 4014 )           IYM=YM*3120./480. + SIGN(.5,YM)          ELSEC           IXM=XM*1024./640. + SIGN(.5,XM) !Scale from VT640 to 4010 (           IYM=YM*780./480. + SIGN(.5,YM)
         ENDIF 
 C Tek4010:        ELSE IF(IMONITOR.EQ.2)THEN         IXM=XM+SIGN(.5,XM)         IYM=YM+SIGN(.5,YM)	 C CIT467:         ELSE IF(IMONITOR.EQ.6)THEN3         IXM=XM*1023.77/572. !Scale from CIT to 4010          IYM=YM*785.87/479.    
 C TEK4107:        ELSE IF(IMONITOR.EQ.7)THEN+         IXM=MIN(1023.,XM*(1023.8/639.)+0.5) !         IYM=YM*(782.515/479.)+0.2 & C PT100G (stores Tek4014 coordinates):        ELSE IF(IMONITOR.EQ.9)THENA         IXM=XM*4096./640. + SIGN(.5,XM) !Scale from VT640 to 4014 '         IYM=YM*3120./480. + SIGN(.5,YM) % C LN03+ (stores Tek4014 coordinates): !       ELSE IF(IMONITOR.EQ.16)THEN A         IXM=XM*4096./640. + SIGN(.5,XM) !Scale from VT640 to 4014 '         IYM=YM*3120./480. + SIGN(.5,YM)  C Non-Tektronix compatible: 
       ELSE         GO TO 1000       ENDIF  C F       IF(DONT_PLOT)DONT_PLOT=(IXM .EQ. IXPIXEL).AND.(IYM .EQ. IYPIXEL)       IXPIXEL = IXM        IYPIXEL = IYM        IF(DONT_PLOT) RETURN C > C============================================================C* C  Encode coordinates in Tektronix format:> C============================================================C C Get extra byte for 4014:       IF(TEK4014)THEN +         IEXTRA=96+4*(MOD(IYM,4))+MOD(IXM,4)          IXM=IXM/4          IYM=IYM/4        ENDIF        IYHI=32+IYM/32       IYLO=96+MOD(IYM,32)        IXHI=32+IXM/32       IXLO=64+MOD(IXM,32)  C > C============================================================C4 C  Prepare the plot buffer for the coordinate codes.> C============================================================C3 C================================================== " C    IPEN = 2: Plot with pen down.- C  If in point mode, must exit by doing penup  C  to last plotted location.3 C================================================== &       IF(IPEN.EQ.2.AND.POINT_MODE)THEN1         CALL PACK_BUFFER(31) !US: Exit point mode )         CALL PACK_BUFFER(29) !GS: Pen up.          CALL PACK_BUFFER(IYHIP) ,         IF(TEK4014)CALL PACK_BUFFER(IEXTRAP)         CALL PACK_BUFFER(IYLOP)          CALL PACK_BUFFER(IXHIP)          CALL PACK_BUFFER(IXLOP) :         CALL CHECK_BUFFER !Check to see if buffer is full.         POINT_MODE=.FALSE.3 C================================================== # C       IPEN = 3: Plot with pen up. 3 C==================================================        ELSE IF(IPEN.EQ.3)THEN         IF(POINT_MODE)THEN           CALL PACK_BUFFER(31)           POINT_MODE=.FALSE.
         ENDIF ;         CALL PACK_BUFFER(29)  !Pen up: pack a GS character. 3 C================================================== ) C       IPEN = 20: Plot a point at (X,Y). 6 C  Enter point mode if available (all except Tek4010).2 C  For Tek4010, must do penup followed by pendown.3 C==================================================        ELSE IF(IPEN.EQ.20)THEN          IF(IMONITOR.NE.2)THEN ?           IF(.NOT.POINT_MODE.OR.INDEX.LE.6)CALL PACK_BUFFER(28)            POINT_MODE=.TRUE.          ELSE*           CALL PACK_BUFFER(29) !Penup (GS)           POINT_MODE=.FALSE.
         ENDIF        ENDIF  C > C============================================================C* C  Put the coordinate codes in the buffer.> C============================================================C> C The first vector sequence in the buffer must always have all
 C  the bytes:        IF(INDEX.LE.1)THEN         CALL PACK_BUFFER(IYHI)+         IF(TEK4014)CALL PACK_BUFFER(IEXTRA)          CALL PACK_BUFFER(IYLO)         CALL PACK_BUFFER(IXHI)         IYHIP=IYHI         IEXTRAP=IEXTRA         IYLOP=IYLO         IXHIP=IXHI&         GO TO 80      !Finish with XLO       ENDIF  C . C Pack only the necessary bytes in the buffer:+       IF(IYHI.NE.IYHIP)THEN      !Pack YHI?           CALL PACK_BUFFER(IYHI)           IYHIP=IYHI        ENDIF ;       IF(TEK4014.AND.IEXTRA.NE.IEXTRAP)THEN    !Pack EXTRA? !          CALL PACK_BUFFER(IEXTRA) 8          CALL PACK_BUFFER(IYLO)      !Must also pack YLO          IEXTRAP=IEXTRA           IYLOP=IYLO 3          IF(IXHI.NE.IXHIP)THEN       !Maybe XHI too "             CALL PACK_BUFFER(IXHI)             IXHIP=IXHI          ENDIF          GO TO 80        ENDIF =       IF(IXHI.NE.IXHIP)THEN      !Pack XHI (& therefore YLO)?           CALL PACK_BUFFER(IYLO)           CALL PACK_BUFFER(IXHI)           IXHIP=IXHI           IYLOP=IYLO           GO TO 80        ENDIF +       IF(IYLO.NE.IYLOP)THEN      !Pack YLO?           CALL PACK_BUFFER(IYLO)           IYLOP=IYLO        ENDIF 1 80    CALL PACK_BUFFER(IXLO)     !Always pack XLO        IXLOP=IXLO C : C Tek4010: must follow penup with pendown to plot a point:<       IF(IPEN.EQ.20.AND.IMONITOR.EQ.2)CALL PACK_BUFFER(IXLO) C 8       CALL CHECK_BUFFER !Check to see if buffer is full. C        RETURNH C======================================================================C@ C  End of Tektronix-compatible section ... other devices follow.H C======================================================================C C H C======================================================================C C  IMONITOR = 3:  VS11. H C======================================================================C 1000   IF(IMONITOR.EQ.3)THEN$ C Calculate monitor dot coordinates:          IXM=XM+SIGN(.5,XM)=          IYM=YM+SIGN(.5,YM) 5          IF(DONT_PLOT) DONT_PLOT = (IXM .EQ. IXPIXEL)C;      >                             .AND. (IYM .EQ. IYPIXEL)           IXPIXEL = IXM          IYPIXEL = IYM          IF(DONT_PLOT) RETURN  C Plot with pen down:a          IF(IPEN.EQ.2)THEN              CALL VSDRAW(IXM,IYM)G             IF(IMODE.EQ.2)CALL VSSYNC      !flush buffer if direct mode  C PLot with pen up:c          ELSE IF(IPEN.EQ.3)THEN               CALL VSMOVE(IXM,IYM) C Plot a point:o           ELSE IF(IPEN.EQ.20)THEN             CALL VSDOT(IXM,IYM) %             IF(IMODE.EQ.2)CALL VSSYNCC          ENDIF C0H C======================================================================C. C  IMONITOR = 4:  ZETA plotter                H C======================================================================C        ELSE IF(IMONITOR.EQ.4)THEN C Plot with pen down or pen up: )          IF(IPEN.EQ.2 .OR. IPEN.EQ.3)THEN*#             CALL Z_PLOT(XM,YM,IPEN)  C Plot a point:            ELSE IF(IPEN.EQ.20)THEN              CALL Z_PLOT(XM,YM,3)              CALL Z_PLOT(XM,YM,2)          ENDIF C H C======================================================================C- C  IMONITOR = 5:  HP plotter                 tH C======================================================================C        ELSE IF(IMONITOR.EQ.5)THEN C Plot with pen down or pen up:()          IF(IPEN.EQ.2 .OR. IPEN.EQ.3)THENC$             CALL HP_PLOT(XM,YM,IPEN) C Plot a point: 
          ELSE !             CALL HP_PLOT(XM,YM,3)s!             CALL HP_PLOT(XM,YM,2)           ENDIF CPH C======================================================================C C  IMONITOR=8:  VT241MH C======================================================================C        ELSE IF(IMONITOR.EQ.8)THEN         IXM=NINT(XM)         IYM=NINT(YM)         IYM=ABS(IYM-479)	 C Pen up:d)         IF(IPEN.EQ.3)CALL PACK_BUFFER(80)8 C Pen down:          IF(IPEN.EQ.2)THENtE C VT241 quirk: the first pixel of a vector is missing if the previous B C move was a pen up.  Fix this by doing a pen down to the previous C location:s           IF(IPENOLD.EQ.3)THEN              CALL PACK_BUFFER(86)              CALL PACK_BUFFER(91)              CALL PACK_BUFFER(93)           ENDIF            CALL PACK_BUFFER(86)
         ENDIF          CALL PACK_BUFFER(91)         ICH1=IXM/100         IT=IXM/10          ICH2=IT - 10*ICH1O         ICH3=IXM - 10*IT!         CALL PACK_BUFFER(ICH1+48)d!         CALL PACK_BUFFER(ICH2+48)i!         CALL PACK_BUFFER(ICH3+48)b         CALL PACK_BUFFER(44)         ICH1=IYM/100         IT=IYM/10          ICH2=IT - 10*ICH1e         ICH3=IYM - 10*IT!         CALL PACK_BUFFER(ICH1+48)l!         CALL PACK_BUFFER(ICH2+48) !         CALL PACK_BUFFER(ICH3+48)          CALL PACK_BUFFER(93)         CALL CHECK_BUFFERy,         IPENOLD=IPEN      !save the pen code CyH C======================================================================C  C  IMONITOR=10:  QMS LasergrafixH C======================================================================C!       ELSE IF(IMONITOR.EQ.10)THEN  C Plot with pen down or pen up:           IF(IPEN.EQ.2)THEN            IF(ILEV.EQ.1)THEN$              CALL QMS_PLOT(XM,YM,-2)            ELSEm#              CALL QMS_PLOT(XM,YM,2)             ENDIF          ELSE IF(IPEN.EQ.3)THENC!            CALL QMS_PLOT(XM,YM,3)b C Plot a point:h
          ELSE "             CALL QMS_PLOT(XM,YM,3)"             CALL QMS_PLOT(XM,YM,2)          ENDIF CiH C======================================================================C, C  IMONITOR=11:  Houston Instruments plotterH C======================================================================C!       ELSE IF(IMONITOR.EQ.11)THENe C Plot with pen down or pen up:e)          IF(IPEN.EQ.2 .OR. IPEN.EQ.3)THENc)             CALL HOUSTON_PLOT(XM,YM,IPEN)e C Plot a point: 
          ELSE &             CALL HOUSTON_PLOT(XM,YM,3)&             CALL HOUSTON_PLOT(XM,YM,2)          ENDIF C H C======================================================================C! C  IMONITOR=12:  Seiko GR-1105-40 H C======================================================================C!       ELSE IF(IMONITOR.EQ.12)THEN  C Plot with pen down or pen up: )          IF(IPEN.EQ.2 .OR. IPEN.EQ.3)THENh'             CALL SEIKO_PLOT(XM,YM,IPEN)o C Plot a point: 
          ELSE $             CALL SEIKO_PLOT(XM,YM,3)$             CALL SEIKO_PLOT(XM,YM,2)          ENDIF CTH C======================================================================C C  IMONITOR=13:  Imagen IMPRESSoH C======================================================================C!       ELSE IF(IMONITOR.EQ.13)THEN  C Plot with pen down or pen up::)          IF(IPEN.EQ.2 .OR. IPEN.EQ.3)THEN )             CALL IMPRESS_PLOT(XM,YM,IPEN)  C Plot a point: 
          ELSES&             CALL IMPRESS_PLOT(XM,YM,3)&             CALL IMPRESS_PLOT(XM,YM,2)          ENDIF  H C======================================================================C C  IMONITOR=14:  PostScriptfH C======================================================================C!       ELSE IF(IMONITOR.EQ.14)THENi C Plot with pen down or pen up:T)          IF(IPEN.EQ.2 .OR. IPEN.EQ.3)THEN ,             CALL POSTSCRIPT_PLOT(XM,YM,IPEN) C Plot a point:c
          ELSE )             CALL POSTSCRIPT_PLOT(XM,YM,3)b)             CALL POSTSCRIPT_PLOT(XM,YM,2)_          ENDIF  H C======================================================================C C  IMONITOR=15:  VaxStation H C======================================================================C!       ELSE IF(IMONITOR.EQ.15)THENs!         CALL VST_PLOT(XM,YM,IPEN)i! ccC Bypass monitor transformationk! cc        CALL VST_PLOT(X,Y,IPEN)        ENDIFt       RETURN	       ENDt