(       SUBROUTINE PLOT_MONITOR2(X,Y,IPEN)H C======================================================================CH C                                                                      CH C  PLOT_MONITOR2                                                       CH C                                                                      CH C  Generates graphics output for monitor 2:                            CH C    IPEN=2:   move to location (X,Y)                                  CH C    IPEN=3:   draw to location (X,Y)                                  CH C    IPEN=20:  plot a point at location (X,Y)                          CH C                                                                      CH C  If IMONITOR2 = 0 then PLOT_MONITOR2 simply returns.                 CH C                                                                      CH C   Written by Arthur Haynes, TRIUMF U.B.C., July 6, 1981.             CH C                                                                      CH C   Input  Parameters: X,Y (R*4); IPEN (I*4).                          CH C                                                                      CH C   Modified by Alan Carruthers, TRIUMF, March 3, 1983                 CH C   No graphics primitives are sent to monitor types 1, 2 or 3 if:     CH C        a) The same pixel as on the previous call to                  CH C           PLOT_MONITOR2 is referenced; and                           CH C        b) The plot level (pixels turned on, turned off, or           CH C           complemented) has not changed; and                         CH C        c) The plot has not just been cleared; and                    CH C        d) IPEN is the same as on the previous call; and              CH C        e) MUST_DO_PLOT is .FALSE. (May 4, 1983 -- see                CH C           following modification).                                   CH C                                                                      CH C  Modified by Alan Carruthers, TRIUMF, May 4, 1983:                   CH C  Graphics primitives can be forced to be sent if logical variable    CH C  MUST_DO_PLOT in common block /PLOT_MONITOR_DOPLOT/ is set to .TRUE. CH C  MUST_DO_PLOT defaults to .FALSE.  This modification was made to let CH C  PLOT_ALPHA_R force PLOT_MONITOR2 (and PLOT_MONITOR) to send         CH C  output. (PLOT_ALPHA_R moves the graphics cursor.)                   CH C                                                                      CH C  Modified by F.W. Jones, Oct 24/83.                                  CH C  To speed up display on Tektronix-compatible terminals, only the     CH C  necessary bytes of coordinate information are sent to these         CH C  devices.  The bytes normally sent are HI Y, LO Y, HI X, LO X, in    CH C  that order.  The terminal identifies the LO Y and LO X bytes by     CH C  their range.  The HI Y and HI X bytes have the same range, but the  CH C  HI X byte is identified by a preceding LO Y.  The LO X byte         CH C  initiates the drawing of the vector.  In general, after the         CH C  transmission of the first four bytes, only those bytes that change  CH C  need be sent, with the exceptions that:                             CH C                                                                      CH C   1) If the HI X byte is sent, a preceding LO Y byte must            CH C      be sent.                                                        CH C   2) The LO X byte must always be sent, to draw the vector.          CH C                                                                      CH C  In a typical plot, there are often one or more bytes that do not    CH C  change one vector to the next, so more vectors can be packed into   CH C  the buffer, the number of I/O operations decreases, and the display CH C  speed is increased.  For a typical plotting example (PLOTEX3),      CH C  display time is reduced by about 30% and CPU time usage is reduced  CH C  by about 15%.                                                       CH C                                                                      CH C  Associated routines modified: CHECK_BUFFER2, PLOT_MONITOR,          CH C                                CHECK_BUFFER.                         CH C                                                                      CH C  Modified by Joe Chuma, December 5, 1983 to include the HP           CH C    plotter as a monitor                                              CH C  Modified by Bernard Henin, U.VIC, July 1984, to support the         CH C    TEKTRONIX-4107.                                                   CH C  Modified by F.W. Jones, August 84, to include the VT241.            CH C                                                                      CH C  Modified by F.W. Jones, Oct 4/85:                                   CH C                                                                      CH C    PLESSEY PT100 terminal support added (IMONITOR2=9).               CH C    This terminal stores Tek 4014 coordinates at full precision       CH C    for true zoom and replay.  Address range is 4096 instead of       CH C    1024 ... this means there are an extra 2 bits of precision        CH C    in X and Y.  These bits are sent in an extra byte (IEXTRA)        CH C    following the HI Y byte.  The IEXTRA byte need be sent only if    CH C    its value has changed.  If the IEXTRA byte is sent, it must       CH C    be followed by the LO Y byte.  Routine CHECK_BUFFER2 has also     CH C    been modified to handle the extra byte.                           CH C                                                                      CH C    The code has been substantially rearranged and comments have      CH C    been revised to improve the logical structure and make the        CH C    code easier to read and maintain.  The Tektronix-compatible       CH C    section (IMONITOR2=1,2,6,7,9) is now at the beginning of the      CH C    executable code, and sections for the other monitors follow       CH C    in numerical order.                                               CH C                                                                      CH C  Modified Dec 5/85 by F.W. Jones, for the QMS Lasergrafix.           CH C  Modified Aug 11/86 by F.W. Jones for the Houston Instruments        CH C    plotter.                                                          CH C  Modified Jan 30/87 by J.Chuma for the TEK-4107, to get the correct  CH C    scaling numbers. (used [KOST.LIBRARY.EXAMPLES]TK4107.FOR)         CH C  Modified Mar 20/87 by F. Jones for the Seiko GR-1105 terminal       CH C  Modified Jul 6/87 by F. Jones:  when going from point plot mode     CH C    to vector mode (pen up) a US is now sent, followed by the GS      CH C    to go into vector mode.  The GS resets point mode on the VT640    CH C    but not on the other Tektronix emulators.  When using point       CH C    mode, the FS code (enter point mode), which was formerly sent     CH C    for every point, is now sent only if the terminal is not in       CH C    point mode or if a new buffer has just been started.              CH C  Modified by J. Chuma, November 14, 1988 to include the LN03+        CH C                                                                      CH C======================================================================C C .       COMMON /PLOT_MONITOR2/ IMONITOR2, IOUTM2        DATA IMONITOR2,IOUTM2/0,6/2       COMMON /PLOT_BUFFER2/ INDEX,IMODE,BUFFER(78)       LOGICAL*1 BUFFER       DATA INDEX,IMODE/0,1/ D       COMMON /MONITOR2_SIZE/ XMINMSIZE,XMAXMSIZE,YMINMSIZE,YMAXMSIZEC       DATA XMINMSIZE,XMAXMSIZE,YMINMSIZE,YMAXMSIZE/0.,639.,0.,479./ 9       COMMON /PLOT_TO_MONITOR2/ RMATRIXMP(2,2),SHIFTMP(2) 0       DATA RMATRIXMP/1.,0.,0.,1./,SHIFTMP/0.,0./3       COMMON /PLOT_LEVEL2/ ILEV2      !FWJ Nov28/85        DATA ILEV2/0/ 2       COMMON /PLOT_CLEARED/PL_CLEAR_M, PL_CLEAR_M2%       LOGICAL PL_CLEAR_M, PL_CLEAR_M2 G C====================================================================== C C  MUST_DO_PLOT is a logical variable that can be set to .true. to  F C  force PLOT_MONITOR (and PLOT_MONITOR2) to send graphics primitives B C  to Monitor 1 (and Monitor 2).  This is useful if, for example, A C  alphanumeric text is sent to the monitor between two identical B C  calls to PLOT_MONITOR (or PLOT_MONITOR2). In this example, the F C  alphanumeric text would change the location of the graphics cursor E C  but PLOT_MONITOR wouldn't realize this.                            G C====================================================================== /       COMMON /PLOT_MONITOR_DOPLOT/ MUST_DO_PLOT #       LOGICAL MUST_DO_PLOT/.FALSE./  C Previous TEK codes: ?       COMMON/TEK_PREVIOUS2/IYHIP2,IYLOP2,IXHIP2,IXLOP2,IEXTRAP2 :       DATA IYHIP2,IYLOP2,IXHIP2,IXLOP2,IEXTRAP2/0,0,0,0,0/   C Flag for point plot mode. !       LOGICAL POINT_MODE/.FALSE./   9       INTEGER IXPIXEL, IYPIXEL     !pixel last referenced        LOGICAL FIRST/.TRUE./ ?       INTEGER IPENPREV/0/  !saves IPEN value from previous call        LOGICAL DONT_PLOT 2       SAVE IXPIXEL,IYPIXEL,FIRST,ILEVPREV,IPENPREV C H C=======================================================================H C  Procedure begins.                                                  ==H C=======================================================================       IF(IMONITOR2.EQ.0)RETURN9       DONT_PLOT = .NOT. (FIRST .OR. (ILEVPREV .NE. ILEV2) .      >                   .OR. PL_CLEAR_M2 .OR.2      >                   (IPENPREV .NE. IPEN) .OR.&      >                   MUST_DO_PLOT)       FIRST = .FALSE.        PL_CLEAR_M2 = .FALSE.        ILEVPREV = ILEV2&       IPENOLD=IPENPREV      !for VT241       IPENPREV = IPEN B C=================================================================? C    Determine the monitor coordinates (XM,YM) which correspond # C    to the plot coordinates (X,Y):  C  C        |XM|               |X| ) C        |  | = RMATRIXMP * | | + SHIFTMP  C        |YM|               |Y| D C=================================================================  5       XM=RMATRIXMP(1,1)*X+RMATRIXMP(1,2)*Y+SHIFTMP(1) 5       YM=RMATRIXMP(2,1)*X+RMATRIXMP(2,2)*Y+SHIFTMP(2) )       XM=MAX(MIN(XM,XMAXMSIZE),XMINMSIZE) )       YM=MAX(MIN(YM,YMAXMSIZE),YMINMSIZE)  C H C======================================================================C* C  Identify Tektronix-compatible terminalsF C  IMONITOR2=1: VT640     IMONITOR2=2: Tek4010     IMONITOR2=6: CIT467F C  IMONITOR2=7: Tek4107   IMONITOR2=9: PT100G      IMONITOR2=16: LN03+( C  and convert to Tektronix coordinates.H C======================================================================C C VT640:       IF(IMONITOR2.EQ.1)THENA         IXM=XM*1024./640. + SIGN(.5,XM) !Scale from VT640 to 4010 &         IYM=YM*780./480. + SIGN(.5,YM)
 C Tek4010:!       ELSE IF(IMONITOR2.EQ.2)THEN          IXM=XM+SIGN(.5,XM)         IYM=YM+SIGN(.5,YM)	 C CIT467: !       ELSE IF(IMONITOR2.EQ.6)THEN 3         IXM=XM*1023.77/572. !Scale from CIT to 4010          IYM=YM*785.87/479.    
 C TEK4107:!       ELSE IF(IMONITOR2.EQ.7)THEN +         IXM=MIN(1023.,XM*(1023.8/639.)+0.5) !         IYM=YM*(782.515/479.)+0.2 & C PT100G (stores Tek4014 coordinates):!       ELSE IF(IMONITOR2.EQ.9)THEN A         IXM=XM*4096./640. + SIGN(.5,XM) !Scale from VT640 to 4014 '         IYM=YM*3120./480. + SIGN(.5,YM) % C LN03+ (stores Tek4014 coordinates): "       ELSE IF(IMONITOR2.EQ.16)THENA         IXM=XM*4096./640. + SIGN(.5,XM) !Scale from VT640 to 4014 '         IYM=YM*3120./480. + SIGN(.5,YM)  C Non-Tektronix compatible: 
       ELSE         GO TO 1000             ENDIF  C F       IF(DONT_PLOT)DONT_PLOT=(IXM .EQ. IXPIXEL).AND.(IYM .EQ. IYPIXEL)       IXPIXEL = IXM        IYPIXEL = IYM        IF(DONT_PLOT) RETURN C > C============================================================C* C  Encode coordinates in Tektronix format:> C============================================================C C Get extra byte for 4014:7       IF( (IMONITOR2.EQ.9) .OR. (IMONITOR2.EQ.16) )THEN +         IEXTRA=96+4*(MOD(IYM,4))+MOD(IXM,4)          IXM=IXM/4          IYM=IYM/4        ENDIF        IYHI=32+IYM/32       IYLO=96+MOD(IYM,32)        IXHI=32+IXM/32       IXLO=64+MOD(IXM,32)  C > C============================================================C4 C  Prepare the plot buffer for the coordinate codes.> C============================================================C3 C================================================== ! C   IPEN = 2: Plot with pen down. - C  If in point mode, must exit by doing penup  C  to last plotted location.3 C================================================== &       IF(IPEN.EQ.2.AND.POINT_MODE)THEN*         CALL PACK_BUFFER2(29) !GS: Pen up.!         CALL PACK_BUFFER2(IYHIP2) 5         IF( (IMONITOR2.EQ.9) .OR. (IMONITOR2.EQ.16) ) $      #   CALL PACK_BUFFER2(IEXTRAP2)!         CALL PACK_BUFFER2(IYLOP2) !         CALL PACK_BUFFER2(IXHIP2) !         CALL PACK_BUFFER2(IXLOP2) ;         CALL CHECK_BUFFER2 !Check to see if buffer is full.          POINT_MODE=.FALSE.3 C================================================== " C      IPEN = 3: Plot with pen up.3 C==================================================        ELSE IF(IPEN.EQ.3)THEN         IF(POINT_MODE)THEN           CALL PACK_BUFFER2(31)            POINT_MODE=.FALSE.
         ENDIF <         CALL PACK_BUFFER2(29)  !Pen up: pack a GS character.3 C================================================== ( C      IPEN = 20: Plot a point at (X,Y).6 C  Enter point mode if available (all except Tek4010).2 C  For Tek4010, must do penup followed by pendown.3 C==================================================        ELSE IF(IPEN.EQ.20)THEN          IF(IMONITOR2.NE.2)THEN@           IF(.NOT.POINT_MODE.OR.INDEX.LE.5)CALL PACK_BUFFER2(28)           POINT_MODE=.TRUE.          ELSE+           CALL PACK_BUFFER2(29) !Penup (GS)            POINT_MODE=.FALSE.
         ENDIF        ENDIF  C > C============================================================C* C  Put the coordinate codes in the buffer.> C============================================================C> C The first vector sequence in the buffer must always have all C the bytes:       IF(INDEX.LE.1)THEN         CALL PACK_BUFFER2(IYHI) 5         IF( (IMONITOR2.EQ.9) .OR. (IMONITOR2.EQ.16) ) "      #   CALL PACK_BUFFER2(IEXTRA)         CALL PACK_BUFFER2(IYLO)          CALL PACK_BUFFER2(IXHI)          IYHIP2=IYHI          IEXTRAP2=IEXTRA          IYLOP2=IYLO          IXHIP2=IXHI &         GO TO 80      !Finish with XLO       ENDIF  C . C Pack only the necessary bytes in the buffer:,       IF(IYHI.NE.IYHIP2)THEN      !Pack YHI?           CALL PACK_BUFFER2(IYHI)          IYHIP2=IYHI       ENDIF 9       IF( ((IMONITOR2.EQ.9) .OR. (IMONITOR2.EQ.16)) .AND. 4      #    (IEXTRA.NE.IEXTRAP2) )THEN    !Pack EXTRA?"          CALL PACK_BUFFER2(IEXTRA)9          CALL PACK_BUFFER2(IYLO)      !Must also pack YLO           IEXTRAP2=IEXTRA          IYLOP2=IYLO4          IF(IXHI.NE.IXHIP2)THEN       !Maybe XHI too#             CALL PACK_BUFFER2(IXHI)              IXHIP2=IXHI           ENDIF          GO TO 80        ENDIF >       IF(IXHI.NE.IXHIP2)THEN      !Pack XHI (& therefore YLO)?           CALL PACK_BUFFER2(IYLO)           CALL PACK_BUFFER2(IXHI)          IXHIP2=IXHI          IYLOP2=IYLO          GO TO 80        ENDIF ,       IF(IYLO.NE.IYLOP2)THEN      !Pack YLO?           CALL PACK_BUFFER2(IYLO)          IYLOP2=IYLO       ENDIF 2 80    CALL PACK_BUFFER2(IXLO)     !Always pack XLO       IXLOP2=IXLO  C : C Tek4010: must follow penup with pendown to plot a point:>       IF(IPEN.EQ.20.AND.IMONITOR2.EQ.2)CALL PACK_BUFFER2(IXLO) C 9       CALL CHECK_BUFFER2 !Check to see if buffer is full.  C        RETURNH C======================================================================CA C  End of Tektronix-compatible section ... other monitors follow. H C======================================================================C C H C======================================================================C C  IMONITOR2 = 3: VS11H C======================================================================C 1000   IF(IMONITOR2.EQ.3)THEN $ C Calculate monitor dot coordinates:          IXM=XM+SIGN(.5,XM)           IYM=YM+SIGN(.5,YM) 5          IF(DONT_PLOT) DONT_PLOT = (IXM .EQ. IXPIXEL) ;      >                             .AND. (IYM .EQ. IYPIXEL)=          IXPIXEL = IXM          IYPIXEL = IYM          IF(DONT_PLOT) RETURN  C Plot with pen down:           IF(IPEN.EQ.2)THEN              CALL VSDRAW(IXM,IYM)G             IF(IMODE.EQ.2)CALL VSSYNC      !flush buffer if direct mode  C Plot with pen up:           ELSE IF(IPEN.EQ.3)THENg              CALL VSMOVE(IXM,IYM) C Plot a point:            ELSE IF(IPEN.EQ.20)THEN             CALL VSDOT(IXM,IYM) %             IF(IMODE.EQ.2)CALL VSSYNCc          ENDIF C H C======================================================================C C  IMONITOR2 = 4: ZETA plotterH C======================================================================C!       ELSE IF(IMONITOR2.EQ.4)THENs C Plot with pen down or pen up: )          IF(IPEN.EQ.2 .OR. IPEN.EQ.3)THEN #             CALL Z_PLOT(XM,YM,IPEN)t C Plot a point:n           ELSE IF(IPEN.EQ.20)THEN              CALL Z_PLOT(XM,YM,3)              CALL Z_PLOT(XM,YM,2)          ENDIF C H C======================================================================C C  IMONITOR2 = 5: HP plotterH C======================================================================C!       ELSE IF(IMONITOR2.EQ.5)THEN  C Plot with pen down or pen up:s)          IF(IPEN.EQ.2 .OR. IPEN.EQ.3)THEN $             CALL HP_PLOT(XM,YM,IPEN) C Plot a point:t
          ELSE !             CALL HP_PLOT(XM,YM,3)r!             CALL HP_PLOT(XM,YM,2)           ENDIF C H C======================================================================C C  IMONITOR2=8:  VT241H C======================================================================C!       ELSE IF(IMONITOR2.EQ.8)THENC         IXM=NINT(XM)         IYM=NINT(YM)         IYM=ABS(IYM-479)	 C Pen up: *         IF(IPEN.EQ.3)CALL PACK_BUFFER2(80) C Pen down:          IF(IPEN.EQ.2)THENwE C VT241 quirk: the first pixel of a vector is missing if the previous C C  move was a pen up.  Fix this by doing a pen down to the previous  C  location:           IF(IPENOLD.EQ.3)THEN!             CALL PACK_BUFFER2(86)v!             CALL PACK_BUFFER2(91)c!             CALL PACK_BUFFER2(93)n           ENDIFO           CALL PACK_BUFFER2(86).
         ENDIFP         CALL PACK_BUFFER2(91)o         ICH1=IXM/100         IT=IXM/10H         ICH2=IT - 10*ICH1d         ICH3=IXM - 10*IT"         CALL PACK_BUFFER2(ICH1+48)"         CALL PACK_BUFFER2(ICH2+48)"         CALL PACK_BUFFER2(ICH3+48)         CALL PACK_BUFFER2(44)          ICH1=IYM/100         IT=IYM/10,         ICH2=IT - 10*ICH1          ICH3=IYM - 10*IT"         CALL PACK_BUFFER2(ICH1+48)"         CALL PACK_BUFFER2(ICH2+48)"         CALL PACK_BUFFER2(ICH3+48)         CALL PACK_BUFFER2(93)C         CALL CHECK_BUFFER2 ClH C======================================================================C! C  IMONITOR2=10:  QMS LasergrafixyH C======================================================================C"       ELSE IF(IMONITOR2.EQ.10)THEN C Plot with pen down or pen up:e          IF(IPEN.EQ.2)THEN            IF(ILEV2.EQ.1)THENe$              CALL QMS_PLOT(XM,YM,-2)            ELSEf#              CALL QMS_PLOT(XM,YM,2)g            ENDIF          ELSE IF(IPEN.EQ.3)THEN !            CALL QMS_PLOT(XM,YM,3)  C Plot a point: 
          ELSE "             CALL QMS_PLOT(XM,YM,3)"             CALL QMS_PLOT(XM,YM,2)          ENDIF C H C======================================================================C- C  IMONITOR2=11:  Houston Instruments plotterbH C======================================================================C"       ELSE IF(IMONITOR2.EQ.11)THEN C Plot with pen down or pen up:r)          IF(IPEN.EQ.2 .OR. IPEN.EQ.3)THEN )             CALL HOUSTON_PLOT(XM,YM,IPEN)e C Plot a point:e
          ELSEt&             CALL HOUSTON_PLOT(XM,YM,3)&             CALL HOUSTON_PLOT(XM,YM,2)          ENDIF C H C======================================================================C" C  IMONITOR2=12:  Seiko GR-1105-40H C======================================================================C"       ELSE IF(IMONITOR2.EQ.12)THEN C Plot with pen down or pen up: )          IF(IPEN.EQ.2 .OR. IPEN.EQ.3)THEN:(             CALL SEIKO_PLOT2(XM,YM,IPEN) C Plot a point: 
          ELSEC%             CALL SEIKO_PLOT2(XM,YM,3) %             CALL SEIKO_PLOT2(XM,YM,2)           ENDIF C H C======================================================================C  C  IMONITOR2=13:  Imagen IMPRESSH C======================================================================C"       ELSE IF(IMONITOR2.EQ.13)THEN C Plot with pen down or pen up:4)          IF(IPEN.EQ.2 .OR. IPEN.EQ.3)THEN )             CALL IMPRESS_PLOT(XM,YM,IPEN)g C Plot a point:e
          ELSE &             CALL IMPRESS_PLOT(XM,YM,3)&             CALL IMPRESS_PLOT(XM,YM,2)          ENDIF  H C======================================================================C C  IMONITOR2=14:  PostScriptH C======================================================================C"       ELSE IF(IMONITOR2.EQ.14)THEN C Plot with pen down or pen up:d)          IF(IPEN.EQ.2 .OR. IPEN.EQ.3)THENt,             CALL POSTSCRIPT_PLOT(XM,YM,IPEN) C Plot a point: 
          ELSEh)             CALL POSTSCRIPT_PLOT(XM,YM,3)s)             CALL POSTSCRIPT_PLOT(XM,YM,2)a          ENDIF       ENDIFT       RETURN	       ENDi