!       SUBROUTINE PLOT_R(X,Y,IPEN)  C ? C  reqd. KOSTL: routines - CLEARPLOT,ENDPLOT,FLUSHPLOT,PENDOWN, 4 C                        - PENUP,PLOTPOINT,WINDOWCLP C B C=================================================================B C==                                                             ==B C==   PLOT_R: Plot Driver for various devices defined by the    ==B C==        subroutine PLOT_DEVICE2(IDEVICE,IOUTM,IOUTM2), where ==B C==                                                             ==B C==                                                             ==B C==   IDEVICE: Device type. The default device type if          ==B C==            PLOT_DEVICE2 is not called is device 1.          ==B C==                                                             ==B C==            X, Y coordinates are user (= world) coordinates. ==B C==                                                             ==B C==        |IDEVICE| = 1: VT640 or Tektronix 4010/12 terminals. ==B C==                       0 <= X <= 639; 0 <= Y <= 479.         ==B C==                       On the hardcopy: X is horizontal.     ==B C==        |IDEVICE| = 2: VT640 or Tektronix 4010/12 terminals. ==B C==                       0 <= X <= 1023; 0 <= Y <= 779.        ==B C==                       On the hardcopy: X is vertical.       ==B C==        |IDEVICE| = 3: VT640 or Tektronix 4010/12 terminals. ==B C==                       0 <= X <= 2047; 0 <= Y <= 785.        ==B C==                       On the hardcopy: X is vertical.       ==B C==        |IDEVICE| = 4: VS11 emulating a VT640 or Tek 4010.   ==B C==                       0 <= X <= 639; 0 <= Y <= 479.         ==B C==                       On the hardcopy: X is horizontal.     ==B C==        |IDEVICE| = 5: VT640 or Tektronix 4010/12 terminals. ==B C==                       0 <= X <= 639; 0 <= Y <= 479.         ==B C==                       On the hardcopy: X is horizontal.     ==B C==                       Plus a ZETA plot ***********          ==B C==        |IDEVICE| = 6: VT640 or Tektronix 4010/12 terminals. ==B C==                       0 <= X <= 1023; 0 <= Y <= 779.        ==B C==                       On the hardcopy: X is vertical.       ==B C==                       Plus a ZETA plot ***********          ==B C==        |IDEVICE| = 7: VT640 or Tektronix 4010/12 terminals. ==B C==                       0 <= X <= 2047; 0 <= Y <= 785.        ==B C==                       On the hardcopy: X is vertical.       ==B C==                       Plus a ZETA plot ***********          ==B C==        |IDEVICE| = 8: VS11 emulating a VT640 or Tek 4010.   ==B C==                       0 <= X <= 639; 0 <= Y <= 479.         ==B C==                       On the hardcopy: X is horizontal.     ==B C==                       Plus a ZETA plot ***********          ==B C==         IDEVICE  = 0: Hardcopy only. X is vertical.         ==B C==                       0 <= X <= 2047; 0 <= Y <= 785.        ==B C==                                                             ==B C==        If IDEVICE is positive then a screen plot is produced==B C==        and a hardcopy which is a bit map image of the screen==B C==        in printronix format (6 bits per byte) is also       ==B C==        produced.                                            ==B C==                                                             ==B C==        If IDEVICE is zero or negative then only the hardcopy==B C==        bit map is produced.                                 ==B C==                                                             ==B C==                                                             ==B C==   IOUTM:  Output unit for the screen plot.                  ==B C==   IOUTM2: Output unit for second device (ZETA plotter).     ==B C==                                                             ==B C==                                                             ==B C==   Defaults:                                                 ==B C==   --------                                                  ==B C==                                                             ==B C==   If PLOT_DEVICE2 is not called, the device type defaults   ==B C==   to 1, and plotting output is sent to logical unit 6.      ==B C==   No output is sent to a second device.                     ==B C==                                                             ==B C==                                                             ==B C==        For more general applications, such as defining the  ==A C==        hardcopy viewport anywhere on the printronix page with B C==        arbitrary scaling of the plot coordinates (X,Y) and  ==B C==        the ability to monitor any window of the printronix  ==B C==        page anywhere on the monitor screen, see the         ==B C==        subroutines "HARDCOPY_RANGE", "MONITOR_RANGE" and    ==B C==        "MONITOR_RANGE2" in this plot_driver package.        ==B C==                                                             ==B C==        "PRINT_HARDCOPY(IOUTH)" prints the hardcopy plot in  ==B C==        printronix format on the output unit IOUTH. If IOUTH ==B C==        is negative or equal to 9, then the hardcopy plot is ==C C==        printed immediately on the printronix (LPA0: by default) B C==        via unit "ABS(IOUTH)".                               ==B C==                                                             ==B C==        (X,Y) (R*4) are the plot (user or world) coordinates ==B C==        to which the pen is to be moved either up (IPEN=3) or==B C==        down (IPEN=2). The plot coordinates (X,Y) can        ==B C==        have any value positive or negative, but are clipped ==B C==        outside the plot windows:                            ==B C==        0 <= X <= 2047, 0 <= Y <= 785 for IDEVICE = 0;       ==B C==        0 <= X <=  639, 0 <= Y <= 479 for IDEVICE = 1,4,5,8; ==B C==        0 <= X <= 1023, 0 <= Y <= 779 for IDEVICE = 2,6;     ==B C==        0 <= X <= 2047, 0 <= Y <= 785 for IDEVICE = 3,7;     ==B C==                                                             ==B C==        The values of IPEN (I*4) are defined as follows:     ==B C==                                                             ==B C==        IPEN =   0: Clear the plot.                          ==B C==                                                             ==B C==        IPEN =   1: Use the previous value of IPEN.          ==B C==                                                             ==B C==        IPEN =   2: Plot with the pen down.                  ==B C==                                                             ==B C==        IPEN =   3: Plot with the pen up.                    ==B C==                                                             ==B C==        IPEN =   4: Same as IPEN = 2 (pen down).             ==B C==                                                             ==B C==        IPEN =  20: Point plotting mode. Plot a point at     ==B C==                    (X,Y).                                   ==B C==                                                             ==B C==        IPEN =  99: Ignore (X,Y) and flush out the           ==B C==                    remainder of the plot buffer to the      ==B C==                    terminal screen.                         ==B C==                    This 70 character buffer is used to      ==B C==                    temporarily store the plot characters    ==B C==                    which are sent to the terminal.          ==B C==                    The plot buffer is initialized but the   ==B C==                    plot is not cleared. The next call to    ==B C==                    PLOT_R will then continue the plot.      ==B C==                    This value of IPEN is only applicable if ==B C==                    one is plotting to the screen in buffer  ==B C==                    mode(*). If one is plotting to the screen==B C==                    in direct mode(*) or plotting only to a  ==B C==                    hardcopy (IDEVICE = 0) then this value of==B C==                    IPEN is ignored.                         ==B C==                                                             ==B C==        IPEN = 999: Ignore (X,Y) and end the plot by         ==B C==                    flushing out the remainder of the plot   ==B C==                    buffer (if plotting to the screen in     ==B C==                    buffer mode(*)). The next call to PLOT_R ==B C==                    will then clear the hardcopy and screen  ==B C==                    and initialize the plot buffer, before   ==B C==                    plotting.                                ==B C==                                                             ==B C==   (*) footnote: When plotting on the screen there are two   ==B C==       modes: buffer mode (IMODE = 1) and direct mode        ==B C==       (IMODE = 2). Buffer mode is faster because the plot   ==B C==       characters which are to be printed on the screen are  ==B C==       first accumulated in a buffer array of 70 characters, ==B C==       and then printed whenever the buffer is full. Direct  ==B C==       mode allows one to have the plot characters printed   ==B C==       immediately to the screen as soon as PLOT_R is called,==B C==       but is slower because there is more I/O involved.     ==B C==       To switch between the modes use subroutine:           ==B C==       "PLOT_MODE(IMODE)" for monitor1 and "PLOT_MODE2" for  ==B C==       monitor2. The default mode is buffer mode.            ==B C==                                                             ==B C==   Written by Arthur Haynes, TRIUMF U.B.C., July 6, 1981.    ==B C==                                                             ==B C==   Input  parameters: X,Y (R*4); IPEN (I*4).                 ==B C==                                                             ==B C==   Common Blocks internal to the plot driver package:        ==B C==                                                             ==B C==   /PLOT_MONITOR/: IMONITOR,IOUTM (I*4).                     ==B C==    IMONITOR: type of monitor terminal for monitoring the    ==B C==              hardcopy plot. (Default: 1).                   ==B C==              IMONITOR = 0: no monitor terminal.             ==B C==              IMONITOR = 1: VT640 terminal.                  ==B C==              IMONITOR = 2: Tektronix 4010/12 terminals.     ==B C==              IMONITOR = 3: VS11.                            ==B C==              IMONITOR = 4: ZETA                             ==B C==              IMONITOR = 5: HP                               ==B C==              IMONITOR = 6: CIT-467                          ==- C                IMONITOR = 7: Tektronix 4107 $ C                IMONITOR = 8: VT241B C==    IOUTM   : output unit for the monitor plot. (Default: 6) ==B C==                                                             ==D C==   /PLOT_MONITOR2/  -- for monitor2; analogous to /PLOT_MONITOR/ B C==                                                             ==B C==   /PLOT_CLEAR/: CLEAR (LOGICAL).                            ==B C==    CLEAR : logical flag which if .TRUE. tells PLOT_R to     ==B C==            clear the monitor screen and hardcopy bitmap     ==B C==            before plotting any points. (Initially: .TRUE.)  ==B C==                                                             ==B C==   /HARDCOPY_RANGE/ XMINHP,XMAXHP,YMINHP,YMAXHP,IORIENTH     ==B C==    XMINHP  : minimum x-coordinate of the plot window in     ==B C==              the plot coordinate system. (Default: 0.)      ==B C==    XMAXHP  : maximum x-coordinate of the plot window in     ==B C==              the plot coordinate system. (Default: 639.)    ==B C==    YMINHP  : minimum y-coordinate of the plot window in     ==B C==              the plot coordinate system. (Default: 0.)      ==B C==    YMAXHP  : maximum y-coordinate of the plot window in     ==B C==              the plot coordinate system. (Default: 479.)    ==B C==              Note: there are four coordinate systems in     ==B C==              this package of subroutines:                   ==B C==              1) The plot (user or world) coordinate system: ==B C==                 XMINHP <= X <= XMAXHP; YMINHP <= Y <= YMAXHP==B C==                 This system is what is used in calling      ==% C==                 PLOT_R(X,Y,IPEN). B C==              2) The hardcopy coordinate system:             ==B C==                 0 <= XH <= 2047; 0 <= YH <= 785.            ==B C==              3) The monitor coordinate system:              ==B C==                 0 <= XM <= XMAXMSIZE; 0 <= YM <= YMAXMSIZE. ==B C==              4) The monitor2 coordinate system:             ==C C==                 0 <= XM2 <= XMAXMSIZE2; 0 <= YM2 <= YMAXMSIZE2. B C==                                                             ==B C==    IORIENTH: orientation of the plot coordinate system in   ==B C==              the hardcopy viewport (Default: -1)            ==B C==              IORIENTH =  1: the x-axis runs vertically down ==B C==                             the printronix page and the     ==B C==                             y-axis runs horizontally across ==B C==                             the page.                       ==B C==              IORIENTH =  0: no hardcopy is to be done.      ==B C==              IORIENTH = -1: the x-axis runs horizontally    ==B C==                             across the printronix page and  ==B C==                             the y-axis runs vertically up   ==B C==                             the page.                       ==B C==                                                             ==B C==   /PLOT_PREVIOUS/: XP,YP,IPENP (I*4).                       ==B C==    XP   : x-coordinate of previous point plotted by PLOT_R. ==B C==           (Initially: 0.)                                   ==B C==    YP   : y-coordinate of previous point plotted by PLOT_R. ==B C==           (Initially: 0.)                                   ==B C==    IPENP: pen setting of previous point plotted by PLOT_R.  ==B C==           (Initially: 0)                                    ==B C==           (note the previous point (XP,YP) may be inside    ==B C==           or outside the plot or hardcopy windows.          ==B C==                                                             ==B C==   /PLOT_BUFFER/: INDEX,IMODE (I*4); BUFFER(78) (L*1).       ==B C==    INDEX : number of characters in the plot buffer array.   ==B C==            (Initially: 0).                                  ==B C==    IMODE : plotting mode on the screen (see footnote above).==B C==            (Default: 1).                                    ==B C==    BUFFER: 70 character plot buffer for the screen.         ==B C==                                                             ==A C==   /PLOT_BUFFER2/  -- for monitor2; analogous to /PLOT_BUFFER/ B C==                                                             ==B C==   /PLOT_HARDCOPY/: XLAST,YLAST,N1,N2 (I*4);                 ==B C==                    HARDCOPY(131,2048) (L*1).                ==B C==    XLAST: x-coordinate (plot units) of the last pen position==B C==           in the plot window. (Initially: 0.)               ==B C==    YLAST: y-coordinate (plot units) of the last pen position==B C==           in the plot window. (Initially: 0.)               ==B C==           (note: the point (XLAST,YLAST) is always within   ==B C==            the dimensions of the plot window (unlike        ==B C==            the point (XP,YP)).                              ==B C==    N1    : number of horizontal bytes in the hardcopy bit   ==B C==            map, i.e. in the 1'st dimension of the hardcopy  ==B C==            array "HARDCOPY(131,2048)". (N1 = 131)           ==B C==    N2    : number of vertical dot lines in the hardcopy bit ==B C==            map, i.e. in the 2'nd dimension of the hardcopy  ==B C==            array "HARDCOPY(131,2048)". (N2 = 2048)          ==B C==    HARDCOPY: hardcopy bit map which consists of N2 dot lines==B C==              with N1 bytes to a line. The lower 6-bits of   ==B C==              each byte form 6 printronix dots. A dot is     ==B C==              black/white or on/off if a bit is one/zero.    ==B C==              The least significant bit of the first byte of ==B C==              the hardcopy array: HARDCOPY(1,1) is plotted   ==B C==              at the upper left hand corner of the printer   ==B C==              page. The most significant bit of the last byte==B C==              of the hardcopy array: HARDCOPY(N1,N2) is      ==B C==              plotted at the lower right hand corner of the  ==B C==              printer page.                                  ==B C==                                                             ==B C==   /PLOT_INPUT_UNIT/  IINS (I*4).                            ==B C==    IINS:  Input unit for the crosshair coordinates to be    ==B C==           read from the screen.                             ==B C==                                                             ==C C  Modified April 3, 1984 by F.W. Jones to allow output to        C C C  EDGR drawing files.  Modified Sept 27/84 to encode colour      C=C C  and line type.                                                 C C C=================================================================C        COMMON /PLOT_CLEAR/ CLEAR;       LOGICAL CLEAR/.TRUE./=(       COMMON /PLOT_PREVIOUS/ XP,YP,IPENP       DATA XP,YP,IPENP/0.,0.,0/ B       COMMON /HARDCOPY_RANGE/ XMINHP,XMAXHP,YMINHP,YMAXHP,IORIENTH7       DATA XMINHP,XMAXHP,YMINHP,YMAXHP/0.,639.,0.,479./        DATA IORIENTH/-1/ <       COMMON /PLOT_CLEAR_A/ CLEAR1, CLEAR2, CLEARH, CLEARUNC.       LOGICAL CLEAR1, CLEAR2, CLEARH, CLEARUNC+       COMMON /PLOT_MONITOR/ IMONITOR, IOUTM=        DATA IMONITOR/1/, IOUTM/6/.       COMMON /PLOT_MONITOR2/ IMONITOR2, IOUTM2"       DATA IMONITOR2/0/, IOUTM2/6/   C Graphics Editor parameters;       COMMON/CDWG/DWGON,DWGTXT,LDWG,LDWT,IRECG,IRECT,STROKE9!       LOGICAL DWGON,DWGTXT,STROKE          REAL XDRAW(2),YDRAW(2)  E       IPENC=IPEN                  ! IPENC is the current pen setting.aF       IF(IPENC.EQ.1)IPENC=IPENP   ! IPENP is the previous pen setting.@       IF(IPENC.EQ.4)IPENC=2       ! IPENC = 4 is usually dashed.?                                   ! In this case we treat it as -                                   ! undashed.r         IF(CLEAR)THEN A          CALL CLEAR_PLOT    ! Initialize graphics and clear plot. 
       ELSEA          CLEARUNC = .FALSE.  !CLEARUNC is a flag that when .TRUE. H C                             tells CLEAR_PLOT to clear monitors 1 and 2A C                             (if active) and the hardcopy bitmap E C                             (if active) regardless of the values of 7 C                             CLEAR1, CLEAR2 or CLEARH. F C                             CLEAR1, CLEAR2 and CLEARH are flags thatD C                             if .TRUE. indicate that the respectiveA C                             monitor or hardcopy bitmap has been @ C                             cleared since the start of programB C                             execution or since the last plot wasC C                             terminated, whichever is more recent. 9          IF(((IMONITOR .NE. 0) .AND. (.NOT. CLEAR1)) .OR. :      >      ((IMONITOR2 .NE. 0) .AND. (.NOT. CLEAR2)) .OR.5      >      ((IORIENTH .NE. 0) .AND. (.NOT. CLEARH)))i      >      CALL CLEAR_PLOTa          CLEARUNC = .TRUE.       END IF  0       IF(IPENC.NE.3)GO TO 100     ! Check IPENC.B C=================================================================B C==   IPENC = 3: Move with pen up to (X,Y).                     ==B C=================================================================8       IF(DWGON.AND..NOT.DWGTXT)CALL PUT_DWG(X,Y,IPENC,0)9       XP=X ! Set previous coordinates to new coordinates. 
       YP=Y       IPENP=IPENC )       IF((X-XMINHP)*(XMAXHP-X).GE.0..AND. %      *   (Y-YMINHP)*(YMAXHP-Y).GE.0.) ?      *   CALL PEN_UP(X,Y) ! If (X,Y) is in the hardcopy window,='                           ! move to it.        RETURN  , 100   IF(IPENC.NE.2)GO TO 200 ! Check IPENC.B C=================================================================B C==   IPENC = 2: Move with pen down to (X,Y).                   ==B C==   Window-clip the line segment: (XP,YP)-->(X,Y).            ==B C=================================================================8       IF(DWGON.AND..NOT.DWGTXT)CALL PUT_DWG(X,Y,IPENC,0)=       CALL WINDOW_CLIP(XP,YP,X,Y,XMINHP,XMAXHP,YMINHP,YMAXHP,g)      *                 XDRAW,YDRAW,NDRAW)        IF(NDRAW.NE.1)GO TO 110cB C=================================================================B C==   NDRAW = 1: (XP,YP) is in the plot window.                 ==B C==================================================================       XP=X     ! Set previous coordinates to new coordinates.t
       YP=Y       IPENP=IPENCe:       CALL PEN_DOWN(XDRAW(1),YDRAW(1)) ! Move pen down to =                                        ! (XDRAW(1),YDRAW(1)).        RETURNB C=================================================================B C==   (XP,YP) is outside the plot window.                       ==B C=================================================================D 110   XP=X            ! Set previous coordinates to new coordinates.
       YP=Y       IPENP=IPENCIC       IF(NDRAW.LE.0)RETURN !Return if no segment within the window.o<       CALL PEN_UP(XDRAW(1),YDRAW(1))   !Pen up to beginning.=       CALL PEN_DOWN(XDRAW(2),YDRAW(2)) !Draw clipped segment.i       RETURN   200   IF(IPENC.NE.20)GO TO 300B C=================================================================@ C==   IPENC = 20: Plot a point at (X,Y).                      ==B C=================================================================:       XP=X  ! Set previous coordinates to new coordinates.
       YP=Y       IPENP=IPENCE4 C If (X,Y) is in the hardcopy window, plot the point)       IF((X-XMINHP)*(XMAXHP-X).GE.0..AND.u*      #    (Y-YMINHP)*(YMAXHP-Y).GE.0.)THEN         CALL PLOT_POINT(X,Y). C Otherwise, EDGR records must be encoded here       ELSE IF(DWGON)THEN         CALL PUT_DWG(X,Y,3,0),         CALL PUT_DWG(X,Y,2,0)4       ENDIF        RETURN   300   IF(IPENC.NE.99)GO TO 400B C=================================================================B C==   IPENC = 99: flush out the plot buffer.                    ==B C=================================================================       CALL FLUSH_PLOT        RETURN  . 400   IF(IPENC.NE.999)GO TO 500 ! Check IPENC.B C=================================================================B C==   IPENC = 999: End the plot, by printing out the            ==B C==                remainder of the plot buffer and setting CLEAR=B C==                to .TRUE..                                   ==B C=================================================================6       CALL END_PLOT ! Terminate the graphics software.       RETURN  - 500   IF(IPENC.NE.0)GO TO 1000 ! Check IPENC. B C=================================================================B C==   IPENC = 0: Clear the plot.                                ==B C=================================================================       CALL CLEAR_PLOTI       RETURN  B C=================================================================B C==   Illegal value of IPENC.                                   ==B C================================================================= 1000  WRITE(6,1010)IPEN 6 1010  FORMAT('***Error*** IPEN =',I5,' is illegal in',       *       ' call to PLOT_R.')       RETURN	       ENDc